package luckyclient.utils.httputils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import luckyclient.remote.entity.ProjectProtocolTemplate;
import luckyclient.utils.Constants;
import luckyclient.utils.LogUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.*;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.bind.DatatypeConverter;
import java.io.*;
import java.net.*;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 *
 * @author seagull
 * @date 2017121 9:29:40
 */
public class HttpClientTools {
    /**
     * ʹHttpURLConnectionpost
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷ
     * @param ppt      Эģ
     * @return 
     */
    public String sendHttpURLPost(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) {
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout();
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        LogUtil.APP.info("HTTPַ:{}", urlParam);
        // 
        StringBuilder sbParams = new StringBuilder();
        if (params != null && params.size() > 0) {
            if (1 == params.size() && params.containsKey("_forTextJson")) {
                LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendHttpURLPost(Ϊkey-value)...");
                return "ЭģǴı޷ʹsendHttpURLPost(Ϊkey-value)...";
            } else {
                for (Entry<String, Object> e : params.entrySet()) {
                    sbParams.append(e.getKey());
                    sbParams.append("=");
                    sbParams.append(e.getValue());
                    sbParams.append("&");
                    LogUtil.APP.info("HTTPURLPostϢ...key:{}    value:{}", e.getKey(), e.getValue());
                }
            }
        }
        HttpURLConnection con = null;
        OutputStreamWriter osw = null;
        BufferedReader br = null;
        // 
        try {
            URL url = new URL(urlParam);
            con = (HttpURLConnection) url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setConnectTimeout(timeout * 1000);
            //滻ͷϢ
            for (Map.Entry<String, String> m : headmsg.entrySet()) {
                String key = m.getKey();
                String value = m.getValue();
                LogUtil.APP.info("ʼ|滻HTTPURLPostͷϢ...key:{}    value:{}", key, value);
                if (null != value && value.indexOf("Base64(") == 0) {
                    String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                    value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                    LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
                }
                con.setRequestProperty(key, value);
            }
            if (sbParams.length() > 0) {
                osw = new OutputStreamWriter(con.getOutputStream(), charset);
                osw.write(sbParams.substring(0, sbParams.length() - 1));
                osw.flush();
            }
            // ȡ
			StringBuilder resultBuffer = new StringBuilder();
            int contentLength = 0;
            if (null != con.getHeaderField("Content-Length")) {
                contentLength = Integer.parseInt(con.getHeaderField("Content-Length"));
            }

            if (1 == responsehead) {
                Map<String, List<String>> headmsgstr = con.getHeaderFields();
                JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(headmsgstr));
                resultBuffer.append(Constants.RESPONSE_HEAD).append(itemJSONObj).append(Constants.RESPONSE_END);
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(con.getResponseCode()).append(Constants.RESPONSE_END);
            }

            if (contentLength > 0 || "chunked".equals(con.getHeaderField("Transfer-Encoding"))) {
                br = new BufferedReader(new InputStreamReader(con.getInputStream(), charset));
                String temp;
                while ((temp = br.readLine()) != null) {
                    resultBuffer.append(temp);
                }
            } else {
                resultBuffer.append("Content-Length=0");
            }
			return resultBuffer.toString();
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpURLConnectionpost쳣飡", e);
            return "ʹHttpURLConnectionpost쳣飡";
        } finally {
            if (osw != null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpURLConnectionpostر쳣飡", e);
                } finally {
                    if (con != null) {
                        con.disconnect();
                        con = null;
                    }
                }
            }
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpURLConnectionpostر쳣飡", e);
                } finally {
                    if (con != null) {
                        con.disconnect();
                    }
                }
            }
        }

    }

    /**
     * ʹURLConnectionpost
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷ
     * @param ppt      Эģ
     * @return 
     */
    public String sendURLPost(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) {
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout();
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        // 
        LogUtil.APP.info("HTTPַ:{}", urlParam);
        StringBuilder sbParams = new StringBuilder();
        if (params != null && params.size() > 0) {
            if (1 == params.size() && params.containsKey("_forTextJson")) {
                LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendURLPost(Ϊkey-value)...");
                return "ЭģǴı޷ʹsendURLPost(Ϊkey-value)...";
            } else {
                for (Entry<String, Object> e : params.entrySet()) {
                    sbParams.append(e.getKey());
                    sbParams.append("=");
                    sbParams.append(e.getValue());
                    sbParams.append("&");
                    LogUtil.APP.info("URLPostϢ...key:{}    value:{}", e.getKey(), e.getValue());
                }
            }
        }
        URLConnection con;
        OutputStreamWriter osw = null;
        BufferedReader br = null;
        try {
            URL realUrl = new URL(urlParam);
            // 򿪺URL֮
            con = realUrl.openConnection();
            // ͨõ
            con.setRequestProperty("accept", "*/*");
            con.setRequestProperty("connection", "Keep-Alive");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            //滻ͷϢ
            for (Map.Entry<String, String> m : headmsg.entrySet()) {
                String key = m.getKey();
                String value = m.getValue();
                LogUtil.APP.info("ʼ|滻URLPostͷϢ...key:{}    value:{}", key, value);
                if (null != value && value.indexOf("Base64(") == 0) {
                    String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                    value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                    LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
                }
                con.setRequestProperty(key, value);
            }

            con.setConnectTimeout(timeout * 1000);
            // POST
            con.setDoOutput(true);
            con.setDoInput(true);
            // ȡURLConnectionӦ
            osw = new OutputStreamWriter(con.getOutputStream(), charset);
            if (sbParams.length() > 0) {
                // 
                osw.write(sbParams.substring(0, sbParams.length() - 1));
                // flushĻ
                osw.flush();
            }
            // BufferedReaderȡURLӦ
			StringBuilder resultBuffer = new StringBuilder();
            int contentLength = 0;
            if (null != con.getHeaderField("Content-Length")) {
                contentLength = Integer.parseInt(con.getHeaderField("Content-Length"));
            }
			if (1 == responsehead) {
				Map<String, List<String>> headmsgstr = con.getHeaderFields();
				JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(headmsgstr));
				resultBuffer.append(Constants.RESPONSE_HEAD).append(itemJSONObj).append(Constants.RESPONSE_END);
			}
			if (1 == responsecode) {
				resultBuffer.append(Constants.RESPONSE_CODE).append(con.getHeaderField(null)).append(Constants.RESPONSE_END);
			}
            if (contentLength >= 0 || "chunked".equals(con.getHeaderField("Transfer-Encoding"))) {
                br = new BufferedReader(new InputStreamReader(con.getInputStream(), charset));
                String temp;
                while ((temp = br.readLine()) != null) {
                    resultBuffer.append(temp);
                }
            } else {
                resultBuffer.append("Content-Length=0");
            }
			return resultBuffer.toString();
        } catch (Exception e) {
            LogUtil.APP.error("ʹURLConnectionpost쳣飡", e);
            return "ʹURLConnectionpost쳣飡";
        } finally {
            if (osw != null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹURLConnectionpostرosw쳣飡", e);
                }
            }
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹURLConnectionpostرbr쳣飡", e);
                }
            }
        }
    }

    /**
     * get󱣴ļ
     *
     * @param urlParam     ַ
     * @param params       MAP
     * @param fileSavePath ر·
     * @param headmsg      ͷ
     * @param ppt          Эģ
     * @return 
     */
    public String sendGetAndSaveFile(String urlParam, Map<String, Object> params, String fileSavePath, Map<String, String> headmsg, ProjectProtocolTemplate ppt) {
        // 
        LogUtil.APP.info("HTTPַ:{}", urlParam);
        int timeout = ppt.getTimeout();
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        StringBuilder sbParams = new StringBuilder();
        if (params != null && params.size() > 0) {
            if (1 == params.size() && params.containsKey("_forTextJson")) {
                LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendGetAndSaveFile(Ϊkey-value)...");
            } else {
                for (Entry<String, Object> entry : params.entrySet()) {
                    sbParams.append(entry.getKey());
                    sbParams.append("=");
                    sbParams.append(entry.getValue());
                    sbParams.append("&");
                    LogUtil.APP.info("HTTPSaveFileϢ...key:{}    value:{}", entry.getKey(), entry.getValue());
                }
            }
        }
        HttpURLConnection con = null;
        FileOutputStream os = null;
        try {
            URL url;
            if (sbParams.length() > 0) {
                url = new URL(urlParam + "?" + sbParams.substring(0, sbParams.length() - 1));
            } else {
                url = new URL(urlParam);
            }
            con = (HttpURLConnection) url.openConnection();
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            //滻ͷϢ
            for (Map.Entry<String, String> m : headmsg.entrySet()) {
                String key = m.getKey();
                String value = m.getValue();
                LogUtil.APP.info("ʼ|滻HTTPSaveFileͷϢ...key:{}    value:{}", key, value);
                if (null != value && value.indexOf("Base64(") == 0) {
                    String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                    value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                    LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
                }
                con.setRequestProperty(key, value);
            }
            con.setConnectTimeout(timeout * 1000);
            con.connect();
            // BufferedReaderȡURLӦ
            StringBuilder resultBuffer = new StringBuilder();

            if (1 == responsehead) {
                Map<String, List<String>> headmsgstr = con.getHeaderFields();
                JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(headmsgstr));
                resultBuffer.append(Constants.RESPONSE_HEAD).append(itemJSONObj).append(Constants.RESPONSE_END);
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(con.getResponseCode()).append(Constants.RESPONSE_END);
            }

            InputStream is = con.getInputStream();
            os = new FileOutputStream(fileSavePath);
            byte[] buf = new byte[1024];
            int count;
            while ((count = is.read(buf)) != -1) {
                os.write(buf, 0, count);
            }
            os.flush();
            return resultBuffer.toString() + "ļɹǰͻ·:" + fileSavePath + " 鿴";
        } catch (Exception e) {
            LogUtil.APP.error("get󱣴ļ쳣飡", e);
            return "get󱣴ļ쳣飡";
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    LogUtil.APP.error("get󱣴ļرOS쳣飡", e);
                } finally {
                    con.disconnect();
                }
            }
        }
    }

    /**
     * ʹHttpURLConnectionget
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷ
     * @param ppt      Эģ
     * @return 
     */
    public String sendHttpURLGet(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) {
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout();
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        // 
        LogUtil.APP.info("HTTPַ:{}", urlParam);
        StringBuilder sbParams = new StringBuilder();
        if (params != null && params.size() > 0) {
            if (1 == params.size() && params.containsKey("_forTextJson")) {
                LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendHttpURLGet(Ϊkey-value)...");
                return "ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendHttpURLGet(Ϊkey-value)...";
            } else {
                for (Entry<String, Object> entry : params.entrySet()) {
                    sbParams.append(entry.getKey());
                    sbParams.append("=");
                    sbParams.append(entry.getValue());
                    sbParams.append("&");
                    LogUtil.APP.info("HTTPURLGetϢ...key:{}    value:{}", entry.getKey(), entry.getValue());
                }
            }
        }
        HttpURLConnection con = null;
        BufferedReader br = null;
        try {
            URL url;
            if (sbParams.length() > 0) {
                url = new URL(urlParam + "?" + sbParams.substring(0, sbParams.length() - 1));
            } else {
                url = new URL(urlParam);
            }
            con = (HttpURLConnection) url.openConnection();
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            //滻ͷϢ
            for (Map.Entry<String, String> m : headmsg.entrySet()) {
                String key = m.getKey();
                String value = m.getValue();
                LogUtil.APP.info("ʼ|滻HTTPURLGetͷϢ...key:{}    value:{}", key, value);
                if (null != value && value.indexOf("Base64(") == 0) {
                    String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                    value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                    LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
                }
                con.setRequestProperty(key, value);
            }
            con.setConnectTimeout(timeout * 1000);
            con.connect();
			StringBuilder resultBuffer = new StringBuilder();
            if (1 == responsehead) {
                Map<String, List<String>> headmsgstr = con.getHeaderFields();
                JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(headmsgstr));
                resultBuffer.append(Constants.RESPONSE_HEAD).append(itemJSONObj).append(Constants.RESPONSE_END);
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(con.getResponseCode()).append(Constants.RESPONSE_END);
            }

            br = new BufferedReader(new InputStreamReader(con.getInputStream(), charset));
            String temp;
            while ((temp = br.readLine()) != null) {
                resultBuffer.append(temp);
            }
            if (resultBuffer.length() == 0) {
                resultBuffer.append("ȡӦ쳣!Ӧ룺").append(con.getResponseCode());
            }
			return resultBuffer.toString();
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpURLConnectionget쳣飡", e);
            return "ʹHttpURLConnectionget쳣飡";
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpURLConnectiongetرbr쳣飡", e);
                } finally {
                    con.disconnect();
                }
            }
        }
    }

    /**
     * ʹURLConnectionget
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷ
     * @param ppt      Эģ
     * @return 
     */
    public String sendURLGet(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) {
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout();
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        // 
        LogUtil.APP.info("HTTPַ:{}", urlParam);
        StringBuilder sbParams = new StringBuilder();
        if (params != null && params.size() > 0) {
            if (1 == params.size() && params.containsKey("_forTextJson")) {
                LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendURLGet(Ϊkey-value)...");
                return "ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendURLGet(Ϊkey-value)...";
            } else {
                for (Entry<String, Object> entry : params.entrySet()) {
                    sbParams.append(entry.getKey());
                    sbParams.append("=");
                    sbParams.append(entry.getValue());
                    sbParams.append("&");
                    LogUtil.APP.info("URLGetϢ...key:{}    value:{}", entry.getKey(), entry.getValue());
                }
            }

        }
        BufferedReader br = null;
        try {
            URL url;
            if (sbParams.length() > 0) {
                url = new URL(urlParam + "?" + sbParams.substring(0, sbParams.length() - 1));
            } else {
                url = new URL(urlParam);
            }
            URLConnection con = url.openConnection();
            // 
            con.setRequestProperty("accept", "*/*");
            con.setRequestProperty("connection", "Keep-Alive");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            //滻ͷϢ
            for (Map.Entry<String, String> m : headmsg.entrySet()) {
                String key = m.getKey();
                String value = m.getValue();
                LogUtil.APP.info("ʼ|滻URLGetͷϢ...key:{}    value:{}", key, value);
                if (null != value && value.indexOf("Base64(") == 0) {
                    String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                    value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                    LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
                }
                con.setRequestProperty(key, value);
            }
            con.setConnectTimeout(timeout * 1000);
            // 
            con.connect();
			StringBuilder resultBuffer = new StringBuilder();
			if (1 == responsehead) {
				Map<String, List<String>> headmsgstr = con.getHeaderFields();
				JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(headmsgstr));
				resultBuffer.append(Constants.RESPONSE_HEAD).append(itemJSONObj).append(Constants.RESPONSE_END);
			}
			if (1 == responsecode) {
				resultBuffer.append(Constants.RESPONSE_CODE).append(con.getHeaderField(null)).append(Constants.RESPONSE_END);
			}
            br = new BufferedReader(new InputStreamReader(con.getInputStream(), charset));
            String temp;
            while ((temp = br.readLine()) != null) {
                resultBuffer.append(temp);
            }
            if (resultBuffer.length() == 0) {
                resultBuffer.append("ȡӦ쳣!");
            }
			return resultBuffer.toString();
        } catch (Exception e) {
            LogUtil.APP.error("ʹURLConnectionget쳣飡", e);
            return "ʹURLConnectionget쳣飡";
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹURLConnectiongetرbr쳣飡", e);
                }
            }
        }
    }

    /**
     * ʹHttpClientJSONʽpost
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param ppt      Эģ
     * @return 
     */
    public String httpClientPostJson(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) throws NoSuchAlgorithmException, KeyManagementException, UnsupportedEncodingException {
        String cerpath = ppt.getCerificatePath();
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout() * 1000;
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        LogUtil.APP.info("HTTPַ:{}", urlParam);
        CloseableHttpClient httpclient = iniHttpClient(urlParam, cerpath);
        HttpPost httpPost = new HttpPost(urlParam);
        httpPost.setHeader("Content-Type", "application/json");
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout)
                //ʹ䳬ʱʱ
                .setSocketTimeout(timeout).build();
        httpPost.setConfig(requestConfig);
        //滻ͷϢ
        for (Map.Entry<String, String> m : headmsg.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            LogUtil.APP.info("ʼ|滻HTTPPostJsonͷϢ...key:{}    value:{}", key, value);
            if (null != value && value.indexOf("Base64(") == 0) {
                String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
            }
            httpPost.setHeader(key, value);
        }
        // 
        BufferedReader br = null;
        try {
            if (params.size() > 0) {
                if (1 == params.size() && params.containsKey("_forTextJson")) {
                    LogUtil.APP.info("ͣRAW,HTTPPostJsonϢ...{}", params.get("_forTextJson").toString());
                    StringEntity entity = new StringEntity(params.get("_forTextJson").toString(), charset);
                    httpPost.setEntity(entity);
                } else {
                    String jsonString = JSON.toJSONString(params);
                    LogUtil.APP.info("ͣFORM,HTTPPostJsonϢ...{}", jsonString);
                    StringEntity entity = new StringEntity(jsonString, charset);
                    httpPost.setEntity(entity);
                }
            }

            CloseableHttpResponse response = httpclient.execute(httpPost);

            // ȡӦ
			StringBuilder resultBuffer = new StringBuilder();
            if (1 == responsehead) {
                Header[] headmsgstr = response.getAllHeaders();
                resultBuffer.append("RESPONSE_HEAD:{");
                for (Header header : headmsgstr) {
                    resultBuffer.append("\"").append(header.getName()).append("\":\"").append(header.getValue()).append("\",");
                }
                resultBuffer.delete(resultBuffer.length() - 1, resultBuffer.length()).append("} ");
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(response.getStatusLine().getStatusCode()).append(Constants.RESPONSE_END);
            }
            if (null != response.getEntity()) {
                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), charset));
                String temp;
                while ((temp = br.readLine()) != null) {
                    resultBuffer.append(temp);
                }
            }
			return resultBuffer.toString();
        } catch (SSLKeyException ske) {
            LogUtil.APP.error("postSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar", ske);
            LogUtil.APP.warn("쳣Ϊȱjarҵjrelib/ext/sunjce_provider.jarŵclasspath»ǿͻ˵libĿ¼£ǿͻ˵Ŀ¼¶ԡ");
            return "postSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar";
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpClientJSONʽpost쳣飡", e);
            return "ʹHttpClientJSONʽpost쳣飡";
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpClientJSONʽpostرbr쳣飡", e);
                }
            }
        }
    }

    /**
     * ʹHttpClientpost
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param ppt      Эģ
     * @return 
     */
    public String httpClientPost(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) throws NoSuchAlgorithmException, KeyManagementException {
        String cerpath = ppt.getCerificatePath();
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout() * 1000;
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        CloseableHttpClient httpclient = iniHttpClient(urlParam, cerpath);
        LogUtil.APP.info("HTTPַ:{}", urlParam);
        HttpPost httpPost = new HttpPost(urlParam);
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout)
                //ʹ䳬ʱʱ
                .setSocketTimeout(timeout).build();
        httpPost.setConfig(requestConfig);
        //滻ͷϢ
        for (Map.Entry<String, String> m : headmsg.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            LogUtil.APP.info("ʼ|滻HTTPClientPostͷϢ...key:{}    value:{}", key, value);
            if (null != value && value.indexOf("Base64(") == 0) {
                String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
            }
            httpPost.setHeader(key, value);
        }
        // 
        BufferedReader br = null;
        try {
            if (params.size() > 0) {
                if (1 == params.size() && params.containsKey("_forTextJson")) {
                    LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹhttpClientPost(Ϊkey-value)...");
                    return "ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹhttpClientPost(Ϊkey-value)...";
                } else {
                    //ƴӲ
                    List<NameValuePair> nvps = new ArrayList<>();
                    for (Map.Entry<String, Object> m : params.entrySet()) {
                        nvps.add(new BasicNameValuePair(m.getKey(), m.getValue().toString()));
                        LogUtil.APP.info("HTTPClientPostϢ...key:{}    value:{}", m.getKey(), m.getValue());
                    }
                    httpPost.setEntity(new UrlEncodedFormEntity(nvps, charset));
                }
            }

            CloseableHttpResponse response = httpclient.execute(httpPost);
            // ȡӦ
            StringBuilder resultBuffer = new StringBuilder();
            if (1 == responsehead) {
                Header[] headmsgstr = response.getAllHeaders();
                resultBuffer.append("RESPONSE_HEAD:{");
                for (Header header : headmsgstr) {
                    resultBuffer.append("\"").append(header.getName()).append("\":\"").append(header.getValue()).append("\",");
                }
                resultBuffer.delete(resultBuffer.length() - 1, resultBuffer.length()).append("} ");
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(response.getStatusLine().getStatusCode()).append(Constants.RESPONSE_END);
            }
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), charset));
            String temp;
            while ((temp = br.readLine()) != null) {
                resultBuffer.append(temp);
            }
            if (resultBuffer.length() == 0) {
                resultBuffer.append("ȡӦ쳣Ӧ룺").append(response.getStatusLine().getStatusCode());
            }
            return resultBuffer.toString();
        } catch (SSLKeyException ske) {
            LogUtil.APP.error("postSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar", ske);
            LogUtil.APP.warn("쳣Ϊȱjarҵjrelib/ext/sunjce_provider.jarŵclasspath»ǿͻ˵libĿ¼£ǿͻ˵Ŀ¼¶ԡ");
            return "postSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar";
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpClientpost쳣飡", e);
			return "ʹHttpClientpost쳣飡";
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpClientpostرbr쳣飡", e);
                }
            }
        }
    }

    /**
     * ʹHttpClientϴļ
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param ppt      Эģ
     * @return HTTP
     */
    public String httpClientUploadFile(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) throws NoSuchAlgorithmException, KeyManagementException {
        String cerpath = ppt.getCerificatePath();
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout() * 1000;
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        LogUtil.APP.info("HTTPַ:{}", urlParam);
        CloseableHttpClient httpclient = iniHttpClient(urlParam, cerpath);
        HttpPost httpPost = new HttpPost(urlParam);
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout)
                //ʹ䳬ʱʱ
                .setSocketTimeout(timeout).build();
        httpPost.setConfig(requestConfig);
        //滻ͷϢ
        for (Map.Entry<String, String> m : headmsg.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            LogUtil.APP.info("ʼ|滻httpClientUploadFileͷϢ...key:{}    value:{}", key, value);
            if (null != value && value.indexOf("Base64(") == 0) {
                String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
            }
            httpPost.setHeader(key, value);
        }
        // 
        BufferedReader br = null;
        try {
            if (params.size() > 0) {
                if (1 == params.size() && params.containsKey("_forTextJson")) {
                    LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹhttpClientUploadFile(Ϊkey-value)...");
                    return "ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹhttpClientUploadFile(Ϊkey-value)...";
                } else {
                    //ƴӲ
                    MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
                    //ıʽ
                    entityBuilder.setCharset(Charset.forName(charset));

                    for (Map.Entry<String, Object> m : params.entrySet()) {
                        if (m.getValue() instanceof File) {
                            entityBuilder.addBinaryBody(m.getKey(), (File) m.getValue());
                            LogUtil.APP.info("httpClientUploadFile ϴļϢ...key:{}    value:{}", m.getKey(), m.getValue());
                        } else {
                            entityBuilder.addTextBody(m.getKey(), m.getValue().toString());
                            LogUtil.APP.info("httpClientUploadFileϢ...key:{}    value:{}", m.getKey(), m.getValue());
                        }
                    }
                    HttpEntity reqEntity = entityBuilder.build();
                    httpPost.setEntity(reqEntity);
                }
            }

            CloseableHttpResponse response = httpclient.execute(httpPost);
            // ȡӦ
			StringBuilder resultBuffer = new StringBuilder();
            if (1 == responsehead) {
                Header[] headmsgstr = response.getAllHeaders();
                resultBuffer.append("RESPONSE_HEAD:{");
                for (Header header : headmsgstr) {
                    resultBuffer.append("\"").append(header.getName()).append("\":\"").append(header.getValue()).append("\",");
                }
                resultBuffer.delete(resultBuffer.length() - 1, resultBuffer.length()).append("} ");
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(response.getStatusLine().getStatusCode()).append(Constants.RESPONSE_END);
            }
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), charset));
            String temp;
            while ((temp = br.readLine()) != null) {
                resultBuffer.append(temp);
            }
            if (resultBuffer.length() == 0) {
                resultBuffer.append("ȡӦ쳣Ӧ룺").append(response.getStatusLine().getStatusCode());
            }
			return resultBuffer.toString();
        } catch (SSLKeyException ske) {
            LogUtil.APP.error("ϴļSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar", ske);
            LogUtil.APP.warn("쳣Ϊȱjarҵjrelib/ext/sunjce_provider.jarŵclasspath»ǿͻ˵libĿ¼£ǿͻ˵Ŀ¼¶ԡ");
            return "ϴļSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar";
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpClientϴļ쳣飡", e);
            return "ʹHttpClientϴļ쳣飡";
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpClientϴļرbr쳣飡", e);
                }
            }
        }
    }

    /**
     * ʹHttpClientget
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param ppt      Эģ
     * @return HTTP
     */
    public String httpClientGet(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) throws NoSuchAlgorithmException, KeyManagementException {
        String cerpath = ppt.getCerificatePath();
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout() * 1000;
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        LogUtil.APP.info("HTTPַ:{}", urlParam);
        CloseableHttpClient httpclient = iniHttpClient(urlParam, cerpath);
        BufferedReader br = null;
        // 
        StringBuilder sbParams = new StringBuilder();
        if (params != null && params.size() > 0) {
            if (1 == params.size() && params.containsKey("_forTextJson")) {
                LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹhttpClientGet(Ϊkey-value)...");
                return "ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹhttpClientGet(Ϊkey-value)...";
            } else {
                for (Entry<String, Object> entry : params.entrySet()) {
                    sbParams.append(entry.getKey());
                    sbParams.append("=");
                    try {
                        sbParams.append(URLEncoder.encode(String.valueOf(entry.getValue()), charset));
                    } catch (UnsupportedEncodingException e) {
                        LogUtil.APP.error("ʹHttpClientgetƴURLʱ쳣飡", e);
                        throw new RuntimeException(e);
                    }
                    sbParams.append("&");
                    LogUtil.APP.info("HTTPClientGetϢ...key:{}    value:{}", entry.getKey(), entry.getValue());
                }
            }

        }
        if (sbParams.length() > 0) {
            urlParam = urlParam + "?" + sbParams.substring(0, sbParams.length() - 1);
        }
        HttpGet httpGet = new HttpGet(urlParam);
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout)
                //ʹ䳬ʱʱ
                .setSocketTimeout(timeout).build();
        httpGet.setConfig(requestConfig);
        //滻ͷϢ
        for (Map.Entry<String, String> m : headmsg.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            LogUtil.APP.info("ʼ|滻HTTPClientGetͷϢ...key:{}    value:{}", key, value);
            if (null != value && value.indexOf("Base64(") == 0) {
                String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
            }
            httpGet.setHeader(key, value);
        }
        try {
            CloseableHttpResponse response = httpclient.execute(httpGet);

            // ȡӦ
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), charset));
            String temp;
            StringBuilder resultBuffer = new StringBuilder();
            if (1 == responsehead) {
                Header[] headmsgstr = response.getAllHeaders();
                resultBuffer.append("RESPONSE_HEAD:{");
                for (Header header : headmsgstr) {
                    resultBuffer.append("\"").append(header.getName()).append("\":\"").append(header.getValue()).append("\",");
                }
                resultBuffer.delete(resultBuffer.length() - 1, resultBuffer.length()).append("} ");
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(response.getStatusLine().getStatusCode()).append(Constants.RESPONSE_END);
            }
            while ((temp = br.readLine()) != null) {
                resultBuffer.append(temp);
            }
            return resultBuffer.toString();
        } catch (SSLKeyException ske) {
            LogUtil.APP.error("getSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar", ske);
            LogUtil.APP.warn("쳣Ϊȱjarҵjrelib/ext/sunjce_provider.jarŵclasspath»ǿͻ˵libĿ¼£ǿͻ˵Ŀ¼¶ԡ");
            return "getSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar";
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpClientget쳣飡", e);
            return "ʹHttpClientget쳣飡";
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpClientgetرbr쳣飡", e);
                }
            }
        }
    }

    /**
     * ʹsocketpost
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param charset  ʽ
     * @return HTTP
     */
    public String sendSocketPost(String urlParam, Map<String, Object> params, String charset,
                                 Map<String, String> headmsg) {
        LogUtil.APP.info("Socketַ:{}", urlParam);
        // 
        StringBuilder sbParams = new StringBuilder();
        if (params != null && params.size() > 0) {
            if (1 == params.size() && params.containsKey("_forTextJson")) {
                LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendSocketPost(Ϊkey-value)...");
                return "ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendSocketPost(Ϊkey-value)...";
            } else {
                for (Entry<String, Object> entry : params.entrySet()) {
                    sbParams.append(entry.getKey());
                    sbParams.append("=");
                    sbParams.append(entry.getValue());
                    sbParams.append("&");
                    LogUtil.APP.info("SocketPostϢ...key:{}    value:{}", entry.getKey(), entry.getValue());
                }
            }
        }
        Socket socket = null;
        OutputStreamWriter osw = null;
        InputStream is = null;
        try {
            URL url = new URL(urlParam);
            String host = url.getHost();
            int port = url.getPort();
            if (-1 == port) {
                port = 80;
            }
            String path = url.getPath();
            socket = new Socket(host, port);
            StringBuilder sb = new StringBuilder();
            sb.append("POST ").append(path).append(" HTTP/1.1\r\n");
            sb.append("Host: ").append(host).append("\r\n");
            sb.append("Connection: Keep-Alive\r\n");
            sb.append("Content-Type: application/x-www-form-urlencoded; charset=utf-8 \r\n");
            //滻ͷϢ
            for (Map.Entry<String, String> m : headmsg.entrySet()) {
                String key = m.getKey();
                String value = m.getValue();
                LogUtil.APP.info("ʼ|滻SocketͷϢ...key:{}    value:{}", key, value);
                if (null != value && value.indexOf("Base64(") == 0) {
                    String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                    value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                    LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
                }
                sb.append(key).append(": ").append(value).append(" \r\n");
            }
            sb.append("Content-Length: ").append(sb.toString().getBytes().length).append("\r\n");
            // һسУʾϢͷд꣬Ȼȴ
            sb.append("\r\n");
            if (sbParams.length() > 0) {
                sb.append(sbParams.substring(0, sbParams.length() - 1));
            }
            osw = new OutputStreamWriter(socket.getOutputStream());
            osw.write(sb.toString());
            osw.flush();
            is = socket.getInputStream();
            String line;
            // Ӧݳ
            int contentLength = 0;
            // ȡhttpӦͷϢ
            do {
                line = readLine(is, 0, charset);
                if (line.startsWith("Content-Length")) {
                    // õӦݳ
                    contentLength = Integer.parseInt(line.split(":")[1].trim());
                }
                // һĻسУʾͷ
            } while (!"\r\n".equals(line));
            // ȡӦݣҪݣ
            return readLine(is, contentLength, charset);
        } catch (Exception e) {
            LogUtil.APP.error("ʹsocketpost쳣飡", e);
            return "ʹsocketpost쳣飡";
        } finally {
            if (osw != null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹsocketpostرosw쳣飡", e);
                } finally {
                    try {
                        socket.close();
                    } catch (IOException e) {
                        LogUtil.APP.error("ʹsocketpostرsocket쳣飡", e);
                    }
                }
            }
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹsocketpostرsocket is쳣飡", e);
                } finally {
                    try {
                        socket.close();
                    } catch (IOException e) {
                        LogUtil.APP.error("ʹsocketpostرsocket쳣飡", e);
                    }
                }
            }
        }
    }

    /**
     * ʹsocketget
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param charset  ʽ
     * @return HTTP
     */
    public String sendSocketGet(String urlParam, Map<String, Object> params, String charset, Map<String, String> headmsg) {
        LogUtil.APP.info("Socketַ:{}", urlParam);
        // 
        StringBuilder sbParams = new StringBuilder();
        if (params != null && params.size() > 0) {
            if (1 == params.size() && params.containsKey("_forTextJson")) {
                LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendSocketGet(Ϊkey-value)...");
                return "ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendSocketGet(Ϊkey-value)...";
            } else {
                for (Entry<String, Object> entry : params.entrySet()) {
                    sbParams.append(entry.getKey());
                    sbParams.append("=");
                    sbParams.append(entry.getValue());
                    sbParams.append("&");
                    LogUtil.APP.info("SocketPostϢ...key:{}    value:{}", entry.getKey(), entry.getValue());
                }
            }

        }
        Socket socket = null;
        OutputStreamWriter osw = null;
        InputStream is = null;
        try {
            URL url = new URL(urlParam);
            String host = url.getHost();
            int port = url.getPort();
            if (-1 == port) {
                port = 80;
            }
            String path = url.getPath();
            socket = new Socket(host, port);
            StringBuilder sb = new StringBuilder();
            sb.append("GET ").append(path).append(" HTTP/1.1\r\n");
            sb.append("Host: ").append(host).append("\r\n");
            sb.append("Connection: Keep-Alive\r\n");
            sb.append("Content-Type: application/x-www-form-urlencoded; charset=utf-8 \r\n");
            //滻ͷϢ
            for (Map.Entry<String, String> m : headmsg.entrySet()) {
                String key = m.getKey();
                String value = m.getValue();
                LogUtil.APP.info("ʼ|滻SocketͷϢ...key:{}    value:{}", key, value);
                if (null != value && value.indexOf("Base64(") == 0) {
                    String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                    value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                    LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
                }
                sb.append(key).append(": ").append(value).append(" \r\n");
            }
            sb.append("Content-Length: ").append(sb.toString().getBytes().length).append("\r\n");
            // һسУʾϢͷд꣬Ȼȴ
            sb.append("\r\n");
            if (sbParams.length() > 0) {
                sb.append(sbParams.substring(0, sbParams.length() - 1));
            }
            osw = new OutputStreamWriter(socket.getOutputStream());
            osw.write(sb.toString());
            osw.flush();
            is = socket.getInputStream();
            String line;
            // Ӧݳ
            int contentLength = 0;
            // ȡhttpӦͷϢ
            do {
                line = readLine(is, 0, charset);
                if (line.startsWith("Content-Length")) {
                    // õӦݳ
                    contentLength = Integer.parseInt(line.split(":")[1].trim());
                }
                // һĻسУʾͷ
            } while (!"\r\n".equals(line));
            // ȡӦݣҪݣ
            return readLine(is, contentLength, charset);
        } catch (Exception e) {
            LogUtil.APP.error("ʹsocketget쳣飡", e);
            return "ʹsocketget쳣飡";
        } finally {
            if (osw != null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹsocketgetرosw쳣飡", e);
                } finally {
                    try {
                        socket.close();
                    } catch (IOException e) {
                        LogUtil.APP.error("ʹsocketgetرsocket쳣飡", e);
                    }
                }
            }
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹsocketgetرsocket is쳣飡", e);
                } finally {
                    try {
                        socket.close();
                    } catch (IOException e) {
                        LogUtil.APP.error("ʹsocketgetرsocket쳣飡", e);
                    }
                }
            }
        }
    }

    /**
     * ȡһݣcontentLeݳΪ0ʱȡӦͷϢΪ0ʱ
     *
     * @param is            
     * @param contentLength ݳ
     * @param charset       ʽ
     * @return ַ
     */
    private String readLine(InputStream is, int contentLength, String charset) throws IOException {
        List<Byte> lineByte = new ArrayList<>();
        byte tempByte;
        int cumsum = 0;
        if (contentLength != 0) {
            do {
                tempByte = (byte) is.read();
                lineByte.add(Byte.valueOf(tempByte));
                cumsum++;
                // cumsumcontentLengthʾѶ
            } while (cumsum < contentLength);
        } else {
            do {
                tempByte = (byte) is.read();
                lineByte.add(Byte.valueOf(tempByte));
                // зasciiֵΪ10
            } while (tempByte != 10);
        }

        byte[] resutlBytes = new byte[lineByte.size()];
        for (int i = 0; i < lineByte.size(); i++) {
            resutlBytes[i] = lineByte.get(i);
        }
        return new String(resutlBytes, charset);
    }

    /**
     * ʹHttpURLConnectiondelete
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param ppt      Эģ
     * @return HTTP
     */
    public String sendHttpURLDel(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) {
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout();
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        // 
        LogUtil.APP.info("HTTPַ:{}", urlParam);
        StringBuilder sbParams = new StringBuilder();
        if (params != null && params.size() > 0) {
            if (1 == params.size() && params.containsKey("_forTextJson")) {
                LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendHttpURLDel(Ϊkey-value)...");
                return "ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹsendHttpURLDel(Ϊkey-value)...";
            } else {
                for (Entry<String, Object> e : params.entrySet()) {
                    sbParams.append(e.getKey());
                    sbParams.append("=");
                    sbParams.append(e.getValue());
                    sbParams.append("&");
                    LogUtil.APP.info("HttpURLDelϢ...key:{}    value:{}", e.getKey(), e.getValue());
                }
            }
        }
        HttpURLConnection con = null;
        OutputStreamWriter osw = null;
        BufferedReader br = null;
        // 
        try {
            URL url = new URL(urlParam);
            con = (HttpURLConnection) url.openConnection();
            con.setRequestMethod("DELETE");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/json");
            //滻ͷϢ
            for (Map.Entry<String, String> m : headmsg.entrySet()) {
                String key = m.getKey();
                String value = m.getValue();
                LogUtil.APP.info("ʼ|滻HTTPͷϢ...key:{}    value:{}", key, value);
                if (null != value && value.indexOf("Base64(") == 0) {
                    String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                    value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                    LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
                }
                con.setRequestProperty(key, value);
            }
            con.setConnectTimeout(timeout * 1000);
            if (sbParams.length() > 0) {
                osw = new OutputStreamWriter(con.getOutputStream(), charset);
                osw.write(sbParams.substring(0, sbParams.length() - 1));
                osw.flush();
            }
            // ȡ
            StringBuilder resultBuffer = new StringBuilder();
            if (1 == responsehead) {
                Map<String, List<String>> headmsgstr = con.getHeaderFields();
                JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(headmsgstr));
                resultBuffer.append(Constants.RESPONSE_HEAD).append(itemJSONObj).append(Constants.RESPONSE_END);
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(con.getResponseCode()).append(Constants.RESPONSE_END);
            }
            if (null != con.getHeaderField("Content-Length") || null != con.getHeaderField("Transfer-Encoding")) {
                br = new BufferedReader(new InputStreamReader(con.getInputStream(), charset));
                String temp;
                while ((temp = br.readLine()) != null) {
                    resultBuffer.append(temp);
                }
            }
            return resultBuffer.toString();
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpURLConnectiondelete쳣飡", e);
            return "ʹHttpURLConnectiondelete쳣飡";
        } finally {
            if (osw != null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpURLConnectiondeleteرosw쳣飡", e);
                } finally {
                    if (con != null) {
                        con.disconnect();
                        con = null;
                    }
                }
            }
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpURLConnectiondeleteرbr쳣飡", e);
                } finally {
                    if (con != null) {
                        con.disconnect();
                    }
                }
            }
        }
    }

    /**
     * ʹHttpClientDelete  JSONʽ
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param ppt      Эģ
     * @return HTTP
     */
    public String httpClientDeleteJson(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) throws KeyManagementException, NoSuchAlgorithmException {
        String cerpath = ppt.getCerificatePath();
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout() * 1000;
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        LogUtil.APP.info("HTTPַ:{}", urlParam);
        CloseableHttpClient httpclient = iniHttpClient(urlParam, cerpath);
        HttpDeleteWithBody httpDel = new HttpDeleteWithBody(urlParam);
        httpDel.setHeader("Content-Type", "application/json");
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout)
                //ʹ䳬ʱʱ
                .setSocketTimeout(timeout).build();
        httpDel.setConfig(requestConfig);
        //滻ͷϢ
        for (Map.Entry<String, String> m : headmsg.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            LogUtil.APP.info("ʼ|滻HTTPͷϢ...key:{}    value:{}", key, value);
            if (null != value && value.indexOf("Base64(") == 0) {
                String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
            }
            httpDel.setHeader(key, value);
        }
        // 
        BufferedReader br = null;
        try {
            if (params.size() > 0) {
                if (1 == params.size() && params.containsKey("_forTextJson")) {
                    LogUtil.APP.info("ͣTEXT,httpClientDeleteJsonϢ...{}", params.get("_forTextJson").toString());
                    StringEntity entity = new StringEntity(params.get("_forTextJson").toString(), charset);
                    httpDel.setEntity(entity);
                } else {
                    String jsonString = JSON.toJSONString(params);
                    LogUtil.APP.info("ͣFORM,httpClientDeleteJsonϢ...{}", jsonString);
                    StringEntity entity = new StringEntity(jsonString, charset);
                    httpDel.setEntity(entity);
                }

            }

            CloseableHttpResponse response = httpclient.execute(httpDel);

            // ȡӦ
			StringBuilder resultBuffer = new StringBuilder();
            if (1 == responsehead) {
                Header[] headmsgstr = response.getAllHeaders();
                resultBuffer.append("RESPONSE_HEAD:{");
                for (Header header : headmsgstr) {
                    resultBuffer.append("\"").append(header.getName()).append("\":\"").append(header.getValue()).append("\",");
                }
                resultBuffer.delete(resultBuffer.length() - 1, resultBuffer.length()).append("} ");
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(response.getStatusLine().getStatusCode()).append(Constants.RESPONSE_END);
            }
            if (null != response.getEntity()) {
                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), charset));
                String temp;
                while ((temp = br.readLine()) != null) {
                    resultBuffer.append(temp);
                }
            }
			return resultBuffer.toString();
        } catch (SSLKeyException ske) {
            LogUtil.APP.error("DeleteSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar", ske);
            LogUtil.APP.warn("쳣Ϊȱjarҵjrelib/ext/sunjce_provider.jarŵclasspath»ǿͻ˵libĿ¼£ǿͻ˵Ŀ¼¶ԡ");
            return "DeleteSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar";
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpClientDelete(JSONʽ)쳣飡", e);
            return "ʹHttpClientDelete(JSONʽ)쳣飡";
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpClientDelete(JSONʽ)رbr쳣飡", e);
                }
            }
        }
    }

    /**
     * ʹHttpClientPatch  JSONʽ
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param ppt      Эģ
     * @return HTTP
     */
    public String httpClientPatchJson(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) throws KeyManagementException, NoSuchAlgorithmException {
        String cerpath = ppt.getCerificatePath();
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout() * 1000;
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        LogUtil.APP.info("HTTPַ:{}", urlParam);
        CloseableHttpClient httpclient = iniHttpClient(urlParam, cerpath);
        HttpPatch httpput = new HttpPatch(urlParam);
        httpput.setHeader("Content-Type", "application/json");
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout)
                //ʹ䳬ʱʱ
                .setSocketTimeout(timeout).build();
        httpput.setConfig(requestConfig);
        //滻ͷϢ
        for (Map.Entry<String, String> m : headmsg.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            LogUtil.APP.info("ʼ|滻HTTPͷϢ...key:{}    value:{}", key, value);
            if (null != value && value.indexOf("Base64(") == 0) {
                String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
            }
            httpput.setHeader(key, value);
        }
        // 
        BufferedReader br = null;
        try {
            if (params.size() > 0) {
                if (1 == params.size() && params.containsKey("_forTextJson")) {
                    LogUtil.APP.info("ͣTEXT,httpClientPatchJsonϢ...{}", params.get("_forTextJson").toString());
                    StringEntity entity = new StringEntity(params.get("_forTextJson").toString(), charset);
                    httpput.setEntity(entity);
                } else {
                    String jsonString = JSON.toJSONString(params);
                    LogUtil.APP.info("ͣFORM,httpClientPatchJsonϢ...{}", jsonString);
                    StringEntity entity = new StringEntity(jsonString, charset);
                    httpput.setEntity(entity);
                }

            }

            CloseableHttpResponse response = httpclient.execute(httpput);

            // ȡӦ
			StringBuilder resultBuffer = new StringBuilder();
            if (1 == responsehead) {
                Header[] headmsgstr = response.getAllHeaders();
                resultBuffer.append("RESPONSE_HEAD:{");
                for (Header header : headmsgstr) {
                    resultBuffer.append("\"").append(header.getName()).append("\":\"").append(header.getValue()).append("\",");
                }
                resultBuffer.delete(resultBuffer.length() - 1, resultBuffer.length()).append("} ");
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(response.getStatusLine().getStatusCode()).append(Constants.RESPONSE_END);
            }
            if (null != response.getEntity()) {
                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), charset));
                String temp;
                while ((temp = br.readLine()) != null) {
                    resultBuffer.append(temp);
                }
            }
			return resultBuffer.toString();
        } catch (SSLKeyException ske) {
            LogUtil.APP.error("PatchSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar", ske);
            LogUtil.APP.warn("쳣Ϊȱjarҵjrelib/ext/sunjce_provider.jarŵclasspath»ǿͻ˵libĿ¼£ǿͻ˵Ŀ¼¶ԡ");
            return "PatchSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar";
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpClientPatch(JSONʽ)쳣飡", e);
			return "ʹHttpClientPatch(JSONʽ)쳣飡";
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpClientPatch(JSONʽ)رbr쳣飡", e);
                }
            }
        }
	}

    /**
     * ʹHttpClientput  JSONʽ
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param ppt      Эģ
     * @return HTTP
     */
    public String httpClientPutJson(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) throws KeyManagementException, NoSuchAlgorithmException {
        String cerpath = ppt.getCerificatePath();
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout() * 1000;
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        StringBuilder resultBuffer = new StringBuilder();
        LogUtil.APP.info("HTTPַ:{}", urlParam);
        CloseableHttpClient httpclient = iniHttpClient(urlParam, cerpath);
        HttpPut httpput = new HttpPut(urlParam);
        httpput.setHeader("Content-Type", "application/json");
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout)
                //ʹ䳬ʱʱ
                .setSocketTimeout(timeout).build();
        httpput.setConfig(requestConfig);
        //滻ͷϢ
        for (Map.Entry<String, String> m : headmsg.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            LogUtil.APP.info("ʼ|滻HTTPͷϢ...key:{}    value:{}", key, value);
            if (null != value && value.indexOf("Base64(") == 0) {
                String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
            }
            httpput.setHeader(key, value);
        }
        // 
        BufferedReader br = null;
        try {
            if (params.size() > 0) {
                if (1 == params.size() && params.containsKey("_forTextJson")) {
                    LogUtil.APP.info("ͣTEXT,HTTPClientPutJsonϢ...{}", params.get("_forTextJson").toString());
                    StringEntity entity = new StringEntity(params.get("_forTextJson").toString(), charset);
                    httpput.setEntity(entity);
                } else {
                    String jsonString = JSON.toJSONString(params);
                    LogUtil.APP.info("ͣFORM,HTTPClientPutJsonϢ...{}", jsonString);
                    StringEntity entity = new StringEntity(jsonString, charset);
                    httpput.setEntity(entity);
                }

            }

            CloseableHttpResponse response = httpclient.execute(httpput);

            // ȡӦ
            if (1 == responsehead) {
                Header[] headmsgstr = response.getAllHeaders();
                resultBuffer.append("RESPONSE_HEAD:{");
                for (Header header : headmsgstr) {
                    resultBuffer.append("\"").append(header.getName()).append("\":\"").append(header.getValue()).append("\",");
                }
                resultBuffer.delete(resultBuffer.length() - 1, resultBuffer.length()).append("} ");
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(response.getStatusLine().getStatusCode()).append(Constants.RESPONSE_END);
            }
            if (null != response.getEntity()) {
                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), charset));
                String temp;
                while ((temp = br.readLine()) != null) {
                    resultBuffer.append(temp);
                }
            }
			return resultBuffer.toString();
        } catch (SSLKeyException ske) {
            LogUtil.APP.error("putSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar", ske);
            LogUtil.APP.warn("쳣Ϊȱjarҵjrelib/ext/sunjce_provider.jarŵclasspath»ǿͻ˵libĿ¼£ǿͻ˵Ŀ¼¶ԡ");
            return "putSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar";
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpClientput(JSONʽ)쳣飡", e);
            return "ʹHttpClientput(JSONʽ)쳣飡";
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpClientput(JSONʽ)رbr쳣飡", e);
                }
            }
        }
    }

    /**
     * ʹHttpClientput
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param ppt      Эģ
     * @return HTTP
     */
    public String httpClientPut(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) throws KeyManagementException, NoSuchAlgorithmException {
        String cerpath = ppt.getCerificatePath();
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout() * 1000;
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        StringBuilder resultBuffer  = new StringBuilder();
        LogUtil.APP.info("HTTPַ:{}", urlParam);
        CloseableHttpClient httpclient = iniHttpClient(urlParam, cerpath);
        HttpPut httpput = new HttpPut(urlParam);
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout)
                //ʹ䳬ʱʱ
                .setSocketTimeout(timeout).build();
        httpput.setConfig(requestConfig);
        //滻ͷϢ
        for (Map.Entry<String, String> m : headmsg.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            LogUtil.APP.info("ʼ|滻HTTPͷϢ...key:{}    value:{}", key, value);
            if (null != value && value.indexOf("Base64(") == 0) {
                String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
            }
            httpput.setHeader(key, value);
        }
        // 
        BufferedReader br = null;
        try {
            if (params.size() > 0) {
                if (1 == params.size() && params.containsKey("_forTextJson")) {
                    LogUtil.APP.warn("ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹhttpClientPut(Ϊkey-value)...");
                    return "ЭģǴıģʽ(httpClientPostJsonԼhttpClientPutJson)޷ʹhttpClientPut(Ϊkey-value)...";
                } else {
                    //ƴӲ
                    List<NameValuePair> nvps = new ArrayList<>();
                    for (Map.Entry<String, Object> m : params.entrySet()) {
                        nvps.add(new BasicNameValuePair(m.getKey(), m.getValue().toString()));
                        LogUtil.APP.info("ʼHTTPClientPutϢ...key:{}    value:{}", m.getKey(), m.getValue());
                    }
                    httpput.setEntity(new UrlEncodedFormEntity(nvps, charset));
                }

            }

            CloseableHttpResponse response = httpclient.execute(httpput);

            // ȡӦ
            if (1 == responsehead) {
                Header[] headmsgstr = response.getAllHeaders();
                resultBuffer.append("RESPONSE_HEAD:{");
                for (Header header : headmsgstr) {
                    resultBuffer.append("\"").append(header.getName()).append("\":\"").append(header.getValue()).append("\",");
                }
                resultBuffer.delete(resultBuffer.length() - 1, resultBuffer.length()).append("} ");
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(response.getStatusLine().getStatusCode()).append(Constants.RESPONSE_END);
            }
            if (null != response.getEntity()) {
                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), charset));
                String temp;
                while ((temp = br.readLine()) != null) {
                    resultBuffer.append(temp);
                }
            }
			return resultBuffer.toString();
        } catch (SSLKeyException ske) {
            LogUtil.APP.error("putSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar", ske);
            LogUtil.APP.warn("쳣Ϊȱjarҵjrelib/ext/sunjce_provider.jarŵclasspath»ǿͻ˵libĿ¼£ǿͻ˵Ŀ¼¶ԡ");
            return "putSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar";
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpClientput쳣飡", e);
            return "ʹHttpClientput쳣飡";
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ʹHttpClientputرbr쳣飡", e);
                }
            }
        }
    }

    /**
     * ǩ֤
     *
     * @param keyStorePath ֤·
     * @param keyStorepass Կ
     * @return SSL
     */
    private SSLContext sslContextKeyStore(String keyStorePath, String keyStorepass) {
        SSLContext sslContext = null;
        FileInputStream instream = null;
        KeyStore trustStore;
        LogUtil.APP.info("֤·:{}  Կ:{}", keyStorePath, keyStorepass);
        try {
            trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            LogUtil.APP.info("ʼȡ֤ļ...");
            instream = new FileInputStream(new File(keyStorePath));
            LogUtil.APP.info("ʼ֤ԼԿ...");
            trustStore.load(instream, keyStorepass.toCharArray());
            // ԼCAǩ֤
            sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, new TrustSelfSignedStrategy()).build();
            //  javax.net.ssl.TrustManager 
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            tmf.init(trustStore);
            TrustManager[] tms = tmf.getTrustManagers();
            // ʹùõ TrustManager Ӧ https վ
            sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tms, new java.security.SecureRandom());
        } catch (Exception e) {
            LogUtil.APP.error("ǩ֤쳣飡", e);
        } finally {
            try {
                assert instream != null;
                instream.close();
            } catch (IOException e) {
                LogUtil.APP.error("ǩ֤رinstream쳣飡", e);
            }
        }
        return sslContext;
    }

    /**
     * httpclientʽ HTTP/HTTPSʼ
     *
     * @param urlParam 
     * @param cerpath  ·
     * @return HTTPCLIENT
     */
    private CloseableHttpClient iniHttpClient(String urlParam, String cerpath) throws NoSuchAlgorithmException, KeyManagementException {
        CloseableHttpClient httpclient;
        urlParam = urlParam.trim();
        if (urlParam.startsWith("http://")) {
            httpclient = HttpClients.createDefault();
        } else if (urlParam.startsWith("https://")) {
            //ƹ֤ķʽhttps
            SSLContext sslContext;
            if (StrUtil.isBlank(cerpath)) {
                LogUtil.APP.info("ʼHTTPS֤...");
                TrustManager[] trustManagers = {new MyX509TrustManager()};
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustManagers, new SecureRandom());
            } else {
                LogUtil.APP.info("ʼHTTPS˫֤...");
                String[] strcerpath = cerpath.split(";", -1);
                HttpClientTools hct = new HttpClientTools();
                sslContext = hct.sslContextKeyStore(strcerpath[0], strcerpath[1]);
            }

            // ЭhttphttpsӦĴsocketӹĶ
            Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory>create()
                    .register("http", PlainConnectionSocketFactory.INSTANCE)
                    // SSLӻ֤֤Ϣ
                    // .register("https", new SSLConnectionSocketFactory(sslContext)).build();
                    // ֤
                    .register("https", new SSLConnectionSocketFactory(sslContext, NoopHostnameVerifier.INSTANCE))
                    .build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connManager.setDefaultMaxPerRoute(1);
            //Զhttpclient
            httpclient = HttpClients.custom().setConnectionManager(connManager).build();
        } else {
            httpclient = HttpClients.createDefault();
        }
        return httpclient;
    }

    /**
     * ʹHttpClientXMLpost
     *
     * @param urlParam ַ
     * @param params   MAP
     * @param headmsg  ͷMAP
     * @param ppt      Эģ
     * @return HTTP
     */
    public String httpClientPostXml(String urlParam, Map<String, Object> params, Map<String, String> headmsg, ProjectProtocolTemplate ppt) throws NoSuchAlgorithmException, KeyManagementException {
        String cerpath = ppt.getCerificatePath();
        String charset = ppt.getEncoding().toLowerCase();
        int timeout = ppt.getTimeout() * 1000;
        int responsehead = ppt.getIsResponseHead();
        int responsecode = ppt.getIsResponseCode();

        LogUtil.APP.info("HTTPַ:{}", urlParam);
        CloseableHttpClient httpclient = iniHttpClient(urlParam, cerpath);
        HttpPost httpPost = new HttpPost(urlParam);
        httpPost.setHeader("Content-Type", "text/xml");
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout)
                //ʹ䳬ʱʱ
                .setSocketTimeout(timeout).build();
        httpPost.setConfig(requestConfig);
        //滻ͷϢ
        for (Map.Entry<String, String> m : headmsg.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            LogUtil.APP.info("ʼ|滻httpClientPostXmlͷϢ...key:{}    value:{}", key, value);
            if (null != value && value.indexOf("Base64(") == 0) {
                String valuesub = value.substring(value.indexOf("Base64(") + 7, value.lastIndexOf(")"));
                value = "Basic " + DatatypeConverter.printBase64Binary((valuesub).getBytes());
                LogUtil.APP.info("ͷ{}ֵ{}FORMATBASE64ʽ...", key, value);
            }
            httpPost.setHeader(key, value);
        }

        try {
            if (params.size() > 0) {
                if (1 == params.size() && params.containsKey("_forTextXml")) {
                    LogUtil.APP.info("ͣXML,httpClientPostXmlϢ...{}", params.get("_forTextXml").toString());
                    String xmlStr = getXmlString(params.get("_forTextXml").toString());
                    StringEntity entity = new StringEntity(xmlStr, charset);
                    entity.setContentType("text/xml");
                    httpPost.setEntity(entity);
                } else {
                    String jsonString = JSON.toJSONString(params);
                    LogUtil.APP.info("ͣFORM,httpClientPostXmlϢ...{}", jsonString);
                    StringEntity entity = new StringEntity(jsonString, charset);
                    httpPost.setEntity(entity);
                }
            }

            CloseableHttpResponse response = httpclient.execute(httpPost);

            // ȡӦ
            StringBuilder resultBuffer = new StringBuilder();
            if (1 == responsehead) {
                Header[] headmsgstr = response.getAllHeaders();
                resultBuffer.append("RESPONSE_HEAD:{");
                for (Header header : headmsgstr) {
                    resultBuffer.append("\"").append(header.getName()).append("\":\"").append(header.getValue()).append("\",");
                }
                resultBuffer.delete(resultBuffer.length() - 1, resultBuffer.length()).append("} ");
            }
            if (1 == responsecode) {
                resultBuffer.append(Constants.RESPONSE_CODE).append(response.getStatusLine().getStatusCode()).append(Constants.RESPONSE_END);
            }
            if (null != response.getEntity()) {
                HttpEntity entity = response.getEntity();
                resultBuffer.append(EntityUtils.toString(entity));
            }
            return resultBuffer.toString();
        } catch (SSLKeyException ske) {
            LogUtil.APP.error("XMLSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar", ske);
            LogUtil.APP.warn("쳣Ϊȱjarҵjrelib/ext/sunjce_provider.jarŵclasspath»ǿͻ˵libĿ¼£ǿͻ˵Ŀ¼¶ԡ");
            return "XMLSSLKeyException쳣classpath»ǿͻ˵libĿ¼Ƿȱsunjce_provider.jar";
        } catch (Exception e) {
            LogUtil.APP.error("ʹHttpClientXMLpost쳣飡", e);
			return "ʹHttpClientXMLpost쳣飡";
        }
    }

    /**
     * ȡxml,xmlַ post
     *
     * @param path XML·
     * @return ضȡXML
     * @author Seagull
     * @date 2019917
     */
    private String getXmlString(String path) {
        StringBuilder sb = new StringBuilder();
        // 
        BufferedReader br = null;
        try {
            InputStream inputStream = new FileInputStream(path);
            br = new BufferedReader(new InputStreamReader(inputStream));
            String line;
            for (line = br.readLine(); line != null; line = br.readLine()) {
                sb.append(line).append("\n");
            }
        } catch (FileNotFoundException e) {
            LogUtil.APP.error("·" + path + "ûҵӦXMLļ", e);
        } catch (IOException e) {
            LogUtil.APP.error("ȡļʧܣ쳣", e);
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    LogUtil.APP.error("ȡxmlļرbr쳣飡", e);
                }
            }
        }
        return sb.toString();
    }

}
