package luckyclient.utils;

import java.beans.PropertyVetoException;
import java.sql.*;
import java.util.List;

import com.mchange.v2.c3p0.ComboPooledDataSource;

import luckyclient.utils.config.DrivenConfig;
/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 * @ClassName: DBToolkit 
 * @Description: رݿ
 * @author seagull
 * @date 2014824 9:29:40  
 * 
 */
public class DbToolkit { 
    /** 
     * ݿӳ
     */ 
	public ComboPooledDataSource cpds;
	private static final String DRIVERCLASS = DrivenConfig.getConfiguration().getProperty("db.ComboPooledDataSource.DriverClass");
	
	public DbToolkit(String urlBase,String usernameBase,String passwordBase){
		cpds=new ComboPooledDataSource();  
        cpds.setUser(usernameBase);  
        cpds.setPassword(passwordBase);  
        cpds.setJdbcUrl(urlBase);  
        try {  
            cpds.setDriverClass(DRIVERCLASS);  
        } catch (PropertyVetoException e) {  
            // TODO Auto-generated catch block  
            e.printStackTrace();  
        }  
        cpds.setInitialPoolSize(20);  
        cpds.setMaxIdleTime(20);  
        cpds.setMaxPoolSize(30);  
        cpds.setMinPoolSize(1);  	
	}
	
    static { 
    	//ע 
        try { 
                Class.forName(DRIVERCLASS); 
        } catch (ClassNotFoundException e) { 
                e.printStackTrace();
        } 
} 
    
	public  Connection getBaseConnection() throws SQLException{
		// TODO Auto-generated method stub       
        return cpds.getConnection();
	}

    /** 
     * һݿִһ̬SQLѯ 
     * 
     * @param conn            ݿ 
     * @param staticSql ̬SQLַ 
     * @return زѯResultSet
     */ 
    public static ResultSet executeQuery(Connection conn, String staticSql) throws SQLException { 
    	//ִSQLĶ 
        PreparedStatement stmt = conn.prepareStatement(staticSql);
        //ִSQLȡؽ
        // stmt.close();
        return stmt.executeQuery();
    } 

    /** 
     * һݿִһ̬SQL 
     * 
     * @param conn ݿ
     * @param staticSql ̬SQLַ
     */ 
    public static int executeSQL(Connection conn, String staticSql) throws SQLException { 
    	//ִSQLĶ 
        PreparedStatement stmt = conn.prepareStatement(staticSql);
        //ִSQLȡؽ
        stmt.execute();
        return stmt.getUpdateCount();
           
    } 

    /** 
     * һݿִһ̬SQL 
     * 
     * @param conn        ݿ 
     * @param sqlList ̬SQLַ 
     */ 
    public static void executeBatchSQL(Connection conn, List<String> sqlList) { 
            try { 
            	 //ִSQLĶ 
                Statement stmt = conn.createStatement();
                for (String sql : sqlList) {
                    stmt.addBatch(sql);
                }
                //ִSQLȡؽ
                stmt.executeBatch();
            } catch (SQLException e) {
                e.printStackTrace();
            } 
    } 

    public static void closeConnection(Connection conn) { 
            if (conn == null){
            	return;
            } 
            try { 
                if (!conn.isClosed()) { 
                	  //رݿ 
                        conn.close(); 
                } 
            } catch (SQLException e) { 
                    e.printStackTrace();
            } 
    } 
}

