package luckyclient.tool.mail;

import java.util.Date;
import java.util.Properties;

import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import luckyclient.utils.LogUtil;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 *
 * @author seagull
 * @date 2017121 9:29:40
 */
public class SimpleMailSender {
    /**
     * ıʽʼ
     *
     * @param mailInfo ͵ʼϢ
     */
    public boolean sendTextMail(MailSenderInfo mailInfo) {
        // жǷҪ֤
        MyAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (null == pro){
        	return false;
        } 
        
        if (mailInfo.isValidate()) {
            // Ҫ֤򴴽һ֤
            authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        // ʼỰԺ֤һʼsession
        Session sendMailSession = Session.getDefaultInstance(pro, authenticator);
        try {
            // sessionһʼϢ
            Message mailMessage = new MimeMessage(sendMailSession);
            // ʼߵַ
            Address from = new InternetAddress(mailInfo.getFromAddress());
            // ʼϢķ
            mailMessage.setFrom(from);
            // ʼĽߵַõʼϢ
            Address to = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, to);
            // ʼϢ
            mailMessage.setSubject(mailInfo.getSubject());
            // ʼϢ͵ʱ
            mailMessage.setSentDate(new Date());
            // ʼϢҪ
            String mailContent = mailInfo.getContent();
            mailMessage.setText(mailContent);
            // ʼ
            Transport.send(mailMessage);
            return true;
        } catch (MessagingException ex) {
        	LogUtil.APP.error("ʼ쳣", ex);
        }
        return false;
    }

    /**
     * HTMLʽʼ
     *
     * @param mailInfo ͵ʼϢ
     */
    public boolean sendHtmlMail(MailSenderInfo mailInfo) {
        // жǷҪ֤
        MyAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (null == pro){
        	return false;
        }
        
        //Ҫ֤򴴽һ֤
        if (mailInfo.isValidate()) {
            authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        // ʼỰԺ֤һʼsession
        Session sendMailSession = Session.getDefaultInstance(pro, authenticator);
        try {
            // sessionһʼϢ
            Message mailMessage = new MimeMessage(sendMailSession);
            // ʼߵַ
            Address from = new InternetAddress(mailInfo.getFromAddress());
            // ʼϢķ
            mailMessage.setFrom(from);
            // ʼĽߵַõʼϢ
            Address[] to = new InternetAddress[mailInfo.getToAddresses().length];
            // Ϊÿʼߴһַ
            for (int i = 0; i < mailInfo.getToAddresses().length; i++) {
                to[i] = new InternetAddress(mailInfo.getToAddresses()[i]);
            }

            // Message.RecipientType.TOԱʾߵΪTO
            //ռ    mailMessage.setRecipient(Message.RecipientType.TO,to);
            mailMessage.setRecipients(Message.RecipientType.TO, to);
            // ʼϢ
            mailMessage.setSubject(mailInfo.getSubject());
            // ʼϢ͵ʱ
            mailMessage.setSentDate(new Date());
            // MiniMultipartһ࣬MimeBodyPart͵Ķ
            Multipart mainPart = new MimeMultipart();
            // һHTMLݵMimeBodyPart
            BodyPart html = new MimeBodyPart();
            // HTML
            html.setContent(mailInfo.getContent(), "text/html; charset=utf-8");
            mainPart.addBodyPart(html);
            // MiniMultipartΪʼ
            mailMessage.setContent(mainPart);
            // ʼ
            Transport.send(mailMessage);
            return true;
        } catch (MessagingException ex) {
            ex.printStackTrace();
            LogUtil.APP.error("ʼ쳣", ex);
        }
        return false;
    }
}   