package luckyclient.tool.mail;

import java.security.GeneralSecurityException;
import java.util.Properties;

import com.sun.mail.util.MailSSLSocketFactory;

import luckyclient.utils.LogUtil;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 *
 * @author seagull
 * @date 2017121 9:29:40
 */
public class MailSenderInfo {
    /**
     * ʼķIPͶ˿
     */
    private String mailServerHost;
    private String mailServerPort = "25";
    /**
     * ʼߵĵַ
     */
    private String fromAddress;
    /**
     * ʼߵĵַ
     */
    private String toAddress;
    /**
     * ʼߵĵַ
     */
    private String[] toAddresses;
    /**
     * ½ʼͷû
     */
    private String userName;
    private String password;
    /**
     * ǷʹSSL
     */
    private boolean sslenable = true;
    /**
     * ǷҪ֤
     */
    private boolean validate = false;

    /**
     * ʼ
     */
    private String subject;
    /**
     * ʼı
     */
    private String content;
    /**
     * ʼļ
     */
    private String[] attachFileNames;

    /**
     * ʼỰ
     */
    public Properties getProperties() {
        Properties p = new Properties();
        try {
            p.put("mail.smtp.host", this.mailServerHost);
            p.put("mail.smtp.port", this.mailServerPort);
            p.put("mail.smtp.auth", validate ? "true" : "false");
            if (this.sslenable) {
                p.put("mail.smtp.ssl.enable", "true");
                MailSSLSocketFactory sf = new MailSSLSocketFactory();
                sf.setTrustAllHosts(true);
                p.put("mail.smtp.ssl.socketFactory", sf);
            }
        } catch (GeneralSecurityException e) {
            LogUtil.APP.error("ʼỰʧܻ쳣: ",e);
            return null;
        }
        return p;
    }

    public String getMailServerHost() {
        return mailServerHost;
    }

    public void setMailServerHost(String mailServerHost) {
        this.mailServerHost = mailServerHost;
    }

    public String getMailServerPort() {
        return mailServerPort;
    }

    public void setMailServerPort(String mailServerPort) {
        this.mailServerPort = mailServerPort;
    }

    public boolean isSslenable() {
        return this.sslenable;
    }

    public void setSslenable(boolean sslenable) {
        this.sslenable = sslenable;
    }

    public boolean isValidate() {
        return validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String[] getAttachFileNames() {
        return attachFileNames;
    }

    public void setAttachFileNames(String[] fileNames) {
        this.attachFileNames = fileNames;
    }

    public String getFromAddress() {
        return fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToAddress() {
        return toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public String[] getToAddresses() {
        return toAddresses;
    }

    public void setToAddresses(String[] toAddresses) {
        this.toAddresses = toAddresses;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String textContent) {
        this.content = textContent;
    }


}
