package luckyclient.tool.mail;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import luckyclient.remote.api.serverOperation;
import luckyclient.remote.entity.ProjectProtocolTemplate;
import luckyclient.remote.entity.TaskScheduling;
import luckyclient.utils.LogUtil;
import luckyclient.utils.config.SysConfig;
import luckyclient.utils.httputils.HttpClientTools;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 *
 * @author seagull
 * @date 201831
 */
public class MailSendInitialization {

    public static void sendMailInitialization(String subject, String content, String taskid, TaskScheduling taskScheduling, int[] taskCount, String time, String buildStatus, String restartStatus) {
        boolean isSend = false;
        if (null == taskCount) {
            isSend = true;
        } else {
            if (taskCount.length == 5 && null != taskScheduling) {
                Integer sendCondition = taskScheduling.getEmailSendCondition();
                // ȫɹ˷, casecount != casesuc
                if (null != sendCondition && 1 == sendCondition) {
                    if (taskCount[0] == taskCount[1]) {
                        isSend = true;
                    }
                }
                // ʧ˷
                if (null != sendCondition && 2 == sendCondition) {
                    if (taskCount[2] > 0) {
                        isSend = true;
                    }
                }
                // ȫ
                if (null != sendCondition && 0 == sendCondition) {
                    isSend = true;
                }
            }
        }
        if (!isSend) {
            LogUtil.APP.info("ǰҪʼ֪ͨ!");
            return;
        }
        //Ϣ
        MailSendInitialization msi= new MailSendInitialization();
        msi.pushMessage(taskScheduling, content, taskCount, time, buildStatus, restartStatus);

        String[] addresses = serverOperation.getEmailAddress(taskScheduling,taskid);
        Properties properties = SysConfig.getConfiguration();
        if (addresses != null) {
            LogUtil.APP.info("׼Խʼ֪ͨԵ...");
            //Ҫʼ
            MailSenderInfo mailInfo = new MailSenderInfo();
            //Ҫʼ
            SimpleMailSender sms = new SimpleMailSender();
            mailInfo.setMailServerHost(properties.getProperty("mail.smtp.ip"));
            mailInfo.setMailServerPort(properties.getProperty("mail.smtp.port"));
            mailInfo.setSslenable(properties.getProperty("mail.smtp.ssl.enable").equals("true"));
            mailInfo.setValidate(true);
            mailInfo.setUserName(properties.getProperty("mail.smtp.username"));
            //
            mailInfo.setPassword(properties.getProperty("mail.smtp.password"));
            mailInfo.setFromAddress(properties.getProperty("mail.smtp.username"));
            //
            mailInfo.setSubject(subject);
            //
            mailInfo.setContent(content);
            mailInfo.setToAddresses(addresses);
            //sms.sendHtmlMail(mailInfo);

            StringBuilder stringBuilder = new StringBuilder();
            for (String address : addresses) {
                stringBuilder.append(address).append(";");
            }
            String addressesmail = stringBuilder.toString();
            if (sms.sendHtmlMail(mailInfo)) {
                LogUtil.APP.info("{}ĲԽ֪ͨʼɣ", addressesmail);
            } else {
                LogUtil.APP.warn("{}ĲԽ֪ͨʼʧܣ", addressesmail);
            }
        } else {
            LogUtil.APP.info("ǰҪʼ֪ͨ");
        }
    }

    private void pushMessage(TaskScheduling taskScheduling, String content, int[] taskCount, String time, String buildStatus, String restartStatus) {
        try {
            Map<String, String> headmsg = new HashMap<>(0);
            Properties properties = SysConfig.getConfiguration();
            LogUtil.APP.info("׼ʼϢ͵...");

            String pushUrl = taskScheduling.getPushUrl();

            if(StrUtil.isNotBlank(pushUrl)){
                String ip = properties.getProperty("server.web.ip");
                String port = properties.getProperty("server.web.port");
                String path = properties.getProperty("server.web.path");

                ProjectProtocolTemplate ppt = new ProjectProtocolTemplate();
                ppt.setEncoding("utf-8");
                ppt.setTimeout(60);
                ppt.setIsResponseHead(1);
                ppt.setIsResponseCode(1);
                HttpClientTools hct = new HttpClientTools();

                Map<String, Object> parameters = new HashMap<>(0);
                if(null != taskCount){
                    content = "LuckyFrameԶ" + taskScheduling.getSchedulingName() + "ִн\n" +
                            "Զ״̬" + buildStatus + "\n" +
                            "ԶTOMCAT״̬" + restartStatus + "\n" +
                            "Ԥִ" + taskCount[0] + ",ĕr" + time + "\n" +
                            "ִгɹ" + taskCount[1] + "\n" +
                            "ִʧܣ" + taskCount[2] + "\n" +
                            "пڽűԭδɹ" + taskCount[3] + "\n" +
                            "ڳʱδյӿResponseδִɣ" + taskCount[4] + "\n" +
                            "ǰԶƽ̨鿴http://" + ip + ":" + port + path;
                }
                JSONObject contentJson = JSON.parseObject("{\"content\": \"" + content + "\"}");

                JSONObject atJson = JSON.parseObject("{\"atMobiles\": [],\"isAtAll\":true}");

                parameters.put("msgtype", "text");
                parameters.put("text", contentJson);
                parameters.put("at", atJson);
                LogUtil.APP.info("ʼƽִ̨...");
                String result=hct.httpClientPostJson(pushUrl, parameters, headmsg, ppt);
                if(result.startsWith("postSSLKeyException쳣")){
                    LogUtil.APP.error("ƽִ̨ʧ...ԭ");
                    LogUtil.APP.error("֣javax.net.ssl.SSLKeyException: RSA premaster secret error  쳣" +
                            "ҵjrelib/ext/sunjce_provider.jarѴ˰ŵͻ˱libĿ¼¡");
                } else if(result.startsWith("ʹHttpClientJSONʽpost쳣")){
                    LogUtil.APP.error("ƽִ̨ʧ...ԭ");
                }else {
                    LogUtil.APP.info("ƽִ̨ݳɹ...");
                }
            }else{
                LogUtil.APP.warn("͵ַΪգȡ...");
            }

        } catch (Exception e) {
            LogUtil.APP.error("ƽִ̨쳣飡", e);
        }
    }

}
