package luckyclient.tool.jenkins;

import java.io.IOException;

import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.model.BuildResult;
import com.offbytwo.jenkins.model.BuildWithDetails;
import com.offbytwo.jenkins.model.ConsoleLog;
import com.offbytwo.jenkins.model.JobWithDetails;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import luckyclient.utils.LogUtil;

/**
 * * Job Build(񹹽) ز  Build صϢлȡȡ־
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 Seagull
 * =================================================================
 * 
 * @author Seagull
 * @date 20191030
 */
public class JobBuildApi {

	// Jenkins 
	private JenkinsServer jenkinsServer;
	// http ͻ˶
	//private JenkinsHttpClient jenkinsHttpClient;

	/**
	 * 췽е Jenkins 
	 * 
	 * 20191030
	 */
	JobBuildApi() {
		JenkinsConnect jenkinsConnect = new JenkinsConnect();
		//  Jenkins
		jenkinsServer = jenkinsConnect.connection();
		// ÿͻ Jenkins
		//jenkinsHttpClient = jenkinsConnect.getClient();
	}

	/**
	 * ͨjobƴȡ
	 * @param jobName 
	 * @return ع
	 * @author Seagull
	 * @date 20191129
	 */
	public BuildResult buildAndGetResultForJobName(String jobName) {
		BuildResult buildResult = null;
		try {
			//
			jenkinsServer.getJob(jobName).build(false);
			// ȡ Job Ϣ
			JobWithDetails job = jenkinsServer.getJob(jobName);
			// һαʾ
			BuildWithDetails build = job.getLastBuild().details();
			// ȡʾ
			LogUtil.APP.info("Ŀ{}, :{}", jobName,build.getDisplayName());
			// ȡĲϢ
			LogUtil.APP.info("Ŀ{}, :{}", jobName,build.getParameters());
			// ȡ
			LogUtil.APP.info("Ŀ{}, :{}", jobName,build.getNumber());
			// ȡִйĻϢ
			LogUtil.APP.info("Ŀ{}, Ϣ:{}", jobName,build.getActions());
			// ȡʼʱ
			LogUtil.APP.info("Ŀ{}, ʱ:{}", jobName,DateUtil.format(DateUtil.date(build.getTimestamp()), "yyyy-MM-dd HH:mm:ss"));
			// ǰ־
			ConsoleLog currentLog = build.getConsoleOutputText(0);
			// ǰȡ־Ϣ
			//LogUtil.APP.info(currentLog.getConsoleLog());
			// Ƿи־,ѭȡ
			while (currentLog.getHasMoreData()) {
				// ȡ־Ϣ
				ConsoleLog newLog = build.getConsoleOutputText(currentLog.getCurrentBufferSize());
				// ־
				if(!StrUtil.isBlank(newLog.getConsoleLog())){
					LogUtil.APP.info("Ŀ{}, ־{}",jobName,newLog.getConsoleLog());
				}
				currentLog = newLog;

			}
			buildResult = job.getBuildByNumber(build.getNumber()).details().getResult();
			LogUtil.APP.info("Ŀ{}, >>>>>>>>>{}",jobName,buildResult.toString());
		} catch (IOException e) {
			LogUtil.APP.error("ȡִ״̬쳣", e);
		}
		return buildResult;
	}
    
}
