package luckyclient.tool.jenkins;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.model.Computer;
import com.offbytwo.jenkins.model.Plugin;
import com.offbytwo.jenkins.model.PluginManager;

import luckyclient.utils.LogUtil;

/**
 * ȡ Jenkins ϢԼ
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 Seagull
 * =================================================================
 * @author Seagull
 * @date 20191029
 */
public class JenkinsBaseApi {
 
    // Jenkins 
    private JenkinsServer jenkinsServer;
 
    /**
     * 췽е Jenkins 
     * @param jenkinsConnect
     * 20191029
     */
    JenkinsBaseApi(JenkinsConnect jenkinsConnect){
        this.jenkinsServer = jenkinsConnect.connection();
    }
    
    /**
     * ȡϢ
     * @author Seagull
     * @date 20191029
     */
    public void getComputerInfo() {
        try {
            Map<String, Computer> map = jenkinsServer.getComputers();
            for (Computer computer : map.values()) {
                // ȡǰڵ-ڵ
            	LogUtil.APP.info("ǰڵ-ڵ:{}",computer.details().getDisplayName());
                // ȡǰڵ-ִ
                LogUtil.APP.info("ǰڵ-ִ:{}",computer.details().getNumExecutors().toString());
                // ȡǰڵ-ִϸϢ
                //List<Executor> executorList = computer.details().getExecutors();
                // 鿴ǰڵ-Ƿѻ
                LogUtil.APP.info("ǰڵ-Ƿѻ:{}",computer.details().getOffline().toString());
                // ýڵȫͳϢ
                //LoadStatistics loadStatistics = computer.details().getLoadStatistics();
                // ȡڵ-
                //Map<String, Map> monitorData = computer.details().getMonitorData();
                //......
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
 
    /**
     *  Jenkins
     * @author Seagull
     * @date 20191029
     */
    public void restart() {
        try {
        	LogUtil.APP.info("׼Jenkins...");
            jenkinsServer.restart(true);
            LogUtil.APP.info("Jenkinsɹ");
        } catch (IOException e) {
        	LogUtil.APP.error("Jenkins쳣",e);
        }
    }
 
    /**
     * ȫ Jenkins
     * @author Seagull
     * @date 20191029
     */
    public void safeRestart() {
        try {
        	LogUtil.APP.info("׼ȫ Jenkins...");
            jenkinsServer.safeRestart(true);
            LogUtil.APP.info("ȫJenkinsɹ");
        } catch (IOException e) {
        	LogUtil.APP.error("ȫJenkins쳣",e);
        }
    }
 
    /**
     * ȫ Jenkins
     * 
     * @author Seagull
     * @date 20191029
     */
    public void safeExit() {
        try {
        	LogUtil.APP.info("׼ȫ Jenkins...");
            jenkinsServer.safeExit(true);
            LogUtil.APP.info("ȫ Jenkinsɹ");
        } catch (IOException e) {
        	LogUtil.APP.error("ȫJenkins쳣",e);
        }
    }
 
    /**
     * ر Jenkins 
     * 
     * @author Seagull
     * @date 20191029
     */
    public void close() {
    	LogUtil.APP.info("׼رJenkins");
        jenkinsServer.close();
        LogUtil.APP.info("رJenkinsӳɹ");
    }
 
    /**
     * ж Jenkins Ƿ
     * 
     * @author Seagull
     * @date 20191029
     */
    public void isRunning() {
        boolean isRunning = jenkinsServer.isRunning();
        LogUtil.APP.info("Jenkins״̬:{}",isRunning);
    }
 
    /**
     * ȡ Jenkins Ϣ
     * 
     * @author Seagull
     * @date 20191029
     */
    public void getPluginInfo(){
        try {
            PluginManager pluginManager =jenkinsServer.getPluginManager();
            // ȡб
            List<Plugin> plugins = pluginManager.getPlugins();
            for (Plugin plugin:plugins){
                //  wiki URL ַ
                LogUtil.APP.info(plugin.getUrl());
                // 汾
                LogUtil.APP.info(plugin.getVersion());
                // 
                LogUtil.APP.info(plugin.getShortName());
                // 
                LogUtil.APP.info(plugin.getLongName());
                // Ƿֶ֧̬
                LogUtil.APP.info(plugin.getSupportsDynamicLoad());
                // 
                //LogUtil.APP.info(plugin.getDependencies());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
 
}
