package luckyclient.tool.jenkins;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import com.offbytwo.jenkins.model.BuildResult;

import luckyclient.remote.api.serverOperation;
import luckyclient.utils.LogUtil;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 seagull1985
 * =================================================================
 * 
 * @author seagull
 * 
 * @date 2017121 9:29:40
 * 
 */
public class BuildingInitialization {
	
	protected static int THREAD_COUNT = 0;
	protected static int THREAD_SUCCOUNT = 0;

	public static BuildResult buildingRun(String tastid) {
		try {
			String[] jobName = serverOperation.getBuildName(tastid);

			if (jobName != null) {
				ThreadPoolExecutor	threadExecute	= new ThreadPoolExecutor(jobName.length, 10, 3, TimeUnit.SECONDS,
						new ArrayBlockingQueue<>(1000),
			            new ThreadPoolExecutor.CallerRunsPolicy());
				
				LogUtil.APP.info("׼õĲĿйԵȡ");
				for (String s : jobName) {
					BuildingInitialization.THREAD_COUNT++;   //̼߳++ڼ߳Ƿȫִ
					threadExecute.execute(new ThreadForBuildJob(s));
				}
				
				//̼߳ڼ߳Ƿȫִ
				int k=0;
				while(BuildingInitialization.THREAD_COUNT!=0){
					k++;
					//ȴʱ45
					if(k>2700){
						break;
					}
					Thread.sleep(1000);
				}
				threadExecute.shutdown();
				
				if(jobName.length!=THREAD_SUCCOUNT){
					LogUtil.APP.info("Ŀ{}ɹĿ{}й쳣ʧ״̬鿴־...",jobName.length,THREAD_SUCCOUNT);
					return BuildResult.FAILURE;
				}else{
					LogUtil.APP.info("ܹɹĿ{}ȫɹ鿴־...",THREAD_SUCCOUNT);
				}
				
			} else {
				LogUtil.APP.info("ǰûҵҪĿ");
			}
		} catch (Exception e) {
			LogUtil.APP.error("Ŀг쳣", e);
			return BuildResult.UNSTABLE;
		}
		return BuildResult.SUCCESS;

	}

}
