package luckyclient.remote.entity.monitor;

import java.math.BigDecimal;

/**
 * ȷĸ
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 Seagull
 * =================================================================
 * @author Seagull
 * @date 201955
 */
public class Arith
{

    /** Ĭϳ㾫 */
    private static final int DEF_DIV_SCALE = 10;

    /** ಻ʵ */
    private Arith()
    {
    }

    /**
     * ṩȷļӷ㡣
     * @param v1 
     * @param v2 
     * @return ĺ
     */
    public static double add(double v1, double v2)
    {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    /**
     * ṩȷļ㡣
     * @param v1 
     * @param v2 
     * @return Ĳ
     */
    public static double sub(double v1, double v2)
    {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    /**
     * ṩȷĳ˷㡣
     * @param v1 
     * @param v2 
     * @return Ļ
     */
    public static double mul(double v1, double v2)
    {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    /**
     * ṩԣȷĳ㣬ʱȷ
     * СԺ10λԺ롣
     * @param v1 
     * @param v2 
     * @return 
     */
    public static double div(double v1, double v2)
    {
        return div(v1, v2, DEF_DIV_SCALE);
    }

    /**
     * ṩԣȷĳ㡣ʱscaleָ
     * ȣԺ롣
     * @param v1 
     * @param v2 
     * @param scale ʾʾҪȷСԺλ
     * @return 
     */
    public static double div(double v1, double v2, int scale)
    {
        if (scale < 0)
        {
            throw new IllegalArgumentException(
                    "The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        if (b1.compareTo(BigDecimal.ZERO) == 0)
        {
            return BigDecimal.ZERO.doubleValue();
        }
        return b1.divide(b2, scale, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    /**
     * ṩȷСλ봦
     * @param v Ҫ
     * @param scale Сλ
     * @return Ľ
     */
    public static double round(double v, int scale)
    {
        if (scale < 0)
        {
            throw new IllegalArgumentException(
                    "The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, BigDecimal.ROUND_HALF_UP).doubleValue();
    }
}
