package luckyclient.remote.api;

import com.alibaba.fastjson.JSONObject;
import luckyclient.execution.SchedulingConstants;
import luckyclient.execution.dispose.ParamsManageForSteps;
import luckyclient.remote.entity.*;
import luckyclient.utils.httputils.HttpRequest;

import java.util.List;


/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 * 
 * @author seagull
 * @date 2017121 9:29:40
 * 
 */
public class GetServerApi {
	
	private static final String PREFIX = "/openGetApi";

	/**
	 * ͨƻIDȡ
	 * @param planId ԼƻID
	 * @return List
	 */
	public static List<ProjectCase> getCasesbyplanId(int planId) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetCaseListByPlanId.do?planId=" + planId);
		return JSONObject.parseArray(result, ProjectCase.class);
	}

	/**
	 * ͨۺϼƻIDȡԼƻ
	 * @param suiteId ԼƻID
	 * @return List
	 */
	public static List<ProjectPlan> getPlansbysuiteId(int suiteId) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetPlanListBySuiteId.do?suiteId=" + suiteId);
		return JSONObject.parseArray(result, ProjectPlan.class);
	}

	/**
	 * ͨԼƻIDȡԼƻ
	 * @param planId ԼƻID
	 * @return ؼƻ
	 */
	public static ProjectPlan getProjectPlanByPlanId(int planId) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetProjectPlanByPlanId.do?planId=" + planId);
		return JSONObject.parseObject(result, ProjectPlan.class);
	}

	/**
	 * ͨƻƻȡ
	 * @param name Լƻ
	 * @return List
	 */
	public static List<ProjectCase> getCasesbyplanname(String name) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetCaseListByPlanName.do?planName=" + name);
		return JSONObject.parseArray(result, ProjectCase.class);
	}

	/**
	 * ͨIDȡĲ
	 * @param caseid ID
	 * @return List
	 */
	public static List<ProjectCaseSteps> getStepsbycaseid(Integer caseid) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetStepListByCaseId.do?caseId=" + caseid);
		return JSONObject.parseArray(result, ProjectCaseSteps.class);
	}

	/**
	 * ͨtaskidȡ
	 * @param taskid ID
	 * @return ز
	 */
	public static TaskExecute cgetTaskbyid(int taskid) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetTaskByTaskId.do?taskId=" + taskid);
		return JSONObject.parseObject(result, TaskExecute.class);
	}
	
	/**
	 * ͨtaskidȡȶ
	 * @param taskid ID
	 * @return صȶ
	 */
	public static TaskScheduling cGetTaskSchedulingByTaskId(int taskid) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetTaskSchedulingByTaskId.do?taskId=" + taskid);
		return JSONObject.parseObject(result, TaskScheduling.class);
	}

	/**
	 * ͨŻȡ
	 * @param sign 
	 * @return 
	 */
	public static ProjectCase cgetCaseBysign(String sign) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetCaseByCaseSign.do?caseSign=" + sign);
		return JSONObject.parseObject(result, ProjectCase.class);
	}

	/**
	 * ͨIDȡ
	 * @param caseId ID
	 * @return 
	 */
	public static ProjectCase cGetCaseByCaseId(Integer caseId) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetCaseByCaseId.do?caseId=" + caseId);
		return JSONObject.parseObject(result, ProjectCase.class);
	}
	
	/**
	 * ȡĿµй
	 * @param projectid ĿID
	 * @return 
	 */
	public static List<ProjectCaseParams> cgetParamsByProjectid(String projectid) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetParamsByProjectIdAndEnvName.do?projectId="+projectid+"&envName="+ SchedulingConstants.envName);
		List<ProjectCaseParams> paramsList = JSONObject.parseArray(result, ProjectCaseParams.class);
		//úʱȽת
		for(ProjectCaseParams pcp:paramsList){
			pcp.setParamsValue(ParamsManageForSteps.paramsManage(pcp.getParamsValue()));
		}
		return paramsList;
	}

	/**
	 * ͨƻIDȡ
	 * @param taskId ID
	 * @return ID
	 */
	public static List<Integer> clientGetCaseListForUnSucByTaskId(Integer taskId) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetCaseListForUnSucByTaskId.do?taskId=" + taskId);
		return JSONObject.parseArray(result, Integer.class);
	}
	
	/**
	 * ͨtemplateIdȡʵ
	 * @param templateId ģID
	 * @return Эģ
	 * @author Seagull
	 * @date 2019424
	 */
	public static ProjectProtocolTemplate clientGetProjectProtocolTemplateByTemplateId(Integer templateId) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetProjectProtocolTemplateByTemplateId.do?templateId=" + templateId);
		return JSONObject.parseObject(result, ProjectProtocolTemplate.class);
	}
	
	/**
	 * ͨģIDȡб
	 * @param templateId ģID
	 * @return 
	 * @author Seagull
	 * @date 2019424
	 */
	public static List<ProjectTemplateParams> clientGetProjectTemplateParamsListByTemplateId(Integer templateId) {
		String result = HttpRequest.loadJSON(PREFIX+"/clientGetProjectTemplateParamsListByTemplateId.do?templateId=" + templateId);
		return JSONObject.parseArray(result, ProjectTemplateParams.class);
	}

}
