package luckyclient.execution.webdriver.ex;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cn.hutool.core.util.NumberUtil;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

import luckyclient.execution.dispose.ActionManageForSteps;
import luckyclient.execution.dispose.ParamsManageForSteps;
import luckyclient.execution.httpinterface.TestCaseExecution;
import luckyclient.execution.httpinterface.analyticsteps.InterfaceAnalyticCase;
import luckyclient.execution.webdriver.BaseWebDrive;
import luckyclient.execution.webdriver.EncapsulateOperation;
import luckyclient.remote.api.serverOperation;
import luckyclient.remote.entity.ProjectCase;
import luckyclient.remote.entity.ProjectCaseParams;
import luckyclient.remote.entity.ProjectCaseSteps;
import luckyclient.utils.Constants;
import luckyclient.utils.LogUtil;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 *
 * @author seagull
 * @date 201831
 */
public class WebCaseExecution{
    private static Map<String, String> variable = new HashMap<>();
    private static String casenote = "עʼ";

    public static void caseExcution(ProjectCase testcase, List<ProjectCaseSteps> steps, String taskid,Integer planId, WebDriver wd, serverOperation caselog, List<ProjectCaseParams> pcplist) {
    	caselog.updateTaskCaseExecuteStatus(taskid,planId, testcase.getCaseId(), 3);
    	// ѹ뵽MAP
        for (ProjectCaseParams pcp : pcplist) {
            variable.put(pcp.getParamsName(), pcp.getParamsValue());
        }
        // ȫֱ
        variable.putAll(ParamsManageForSteps.GLOBAL_VARIABLE);
        // 0:ɹ 1:ʧ 2: 
        int setcaseresult = 0;
        //תʶ
        int stepJumpNo=0;
        for (int i = 0; i < steps.size(); i++) {
            Map<String, String> params;
            String result;
            ProjectCaseSteps step = steps.get(i);

            //ת﷨
            if(stepJumpNo!=0&&setcaseresult!=0){
                if(stepJumpNo==i+1){
                    setcaseresult = 0;
                    LogUtil.APP.info("תǰ{}",i+1);
                }else if(stepJumpNo>i+1){
                    LogUtil.APP.info("ǰ{},ִ...",i+1);
                    continue;
                }else{
                    LogUtil.APP.info("ת衾{}Сڵǰ衾{}ֱ¼ִ...",stepJumpNo,i+1);
                }
            }

            // ݲ
            if (1 == step.getStepType()){
            	params = WebDriverAnalyticCase.analyticCaseStep(testcase, step, taskid, caselog, variable);
            }else{
            	params = InterfaceAnalyticCase.analyticCaseStep(testcase, step, taskid, caselog, variable);
            }

            // жϷǷ쳣
            if (null != params.get("exception") && params.get("exception").contains("쳣")) {
            	setcaseresult = 2;
                break;
            }

            // ݲִв
            if (1 == step.getStepType()){
            	result = runWebStep(params, wd, taskid, testcase.getCaseId(), step.getStepSerialNumber(), caselog);
            }else{
            	TestCaseExecution testCaseExecution=new TestCaseExecution();
            	result = testCaseExecution.runStep(params, taskid, testcase.getCaseSign(), step, caselog);
            }

            String expectedResults = params.get("ExpectedResults");

            // жϽ
            Map<String,Integer> judgeResult = judgeResult(testcase, step, params, wd, taskid, expectedResults, result, caselog);
            Integer stepresult = judgeResult.get("setResult");
            stepJumpNo = judgeResult.get("stepJumpNo");
			// ʧܣҲڼ,ֱֹ
            if (0 != stepresult) {
            	setcaseresult = stepresult;
                if (testcase.getFailcontinue() == 0) {
                    LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),step.getStepSerialNumber());
                    break;
                } else {
                    LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),step.getStepSerialNumber());
                }
            }
        }

        variable.clear();
        caselog.updateTaskCaseExecuteStatus(taskid,planId, testcase.getCaseId(), setcaseresult);
        if (setcaseresult == 0) {
            LogUtil.APP.info("{}ȫִнɹ...",testcase.getCaseSign());
            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ȫִнɹ", "info", "ending", "");
        } else {
            LogUtil.APP.warn("{}ִйʧܻ...鿴ԭ:{}",testcase.getCaseSign(),casenote);
            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ִйʧܻ" + casenote, "error", "ending", "");
        }
    }

    public static String runWebStep(Map<String, String> params, WebDriver wd, String taskid, Integer caseId, int stepno, serverOperation caselog) {
        String result="";
        String property="";
        String propertyValue="";
        String operation="";
        String operationValue="";

        try {
            property = params.get("property");
            propertyValue = params.get("property_value");
            operation = params.get("operation");
            operationValue = params.get("operation_value");

            LogUtil.APP.info("νɣȴж......");
            caselog.insertTaskCaseLog(taskid, caseId, ":" + operation + "; ֵ:" + operationValue, "info", String.valueOf(stepno), "");
        } catch (Exception e) {
            LogUtil.APP.error("ν׳쳣",e);
            return "ִʧܣʧ!";
        }

        try {
            //һֽ֧ӿڣweb
            if (null != operationValue && "runcase".equals(operation)) {
                String[] temp = operationValue.split(",", -1);
                TestCaseExecution testCaseExecution=new TestCaseExecution();
                String ex = testCaseExecution.oneCaseExecuteForCase(temp[0], taskid, variable, caselog, wd);
                if (!ex.contains("CallCaseó") && !ex.contains("") && !ex.contains("ʧ")) {
                    // runcaseеı
                    variable.putAll(testCaseExecution.RUNCASE_VARIABLE);
                    testCaseExecution.RUNCASE_VARIABLE.clear();
                    return ex;
                } else {
                    return "ִʧܣ"+ex;
                }
            }

            // ҳԪز
            if (null != property && null != propertyValue && null != operation) {
                WebElement we = isElementExist(wd, property, propertyValue, operation);
                //жԪǷڹؼ
            	if(operation.equals("iselementexist")){
                    // жϴԪǷ
                    if (null == we) {
                        LogUtil.APP.warn("ȡֵǡfalse");
                        return "ȡֵǡfalse";
                    }else{
                        LogUtil.APP.info("ȡֵǡtrue");
                        return "ȡֵǡtrue";
                    }
            	}
            	
                // жϴԪǷ
                if (null == we) {
                    LogUtil.APP.warn("λʧܣisElementExistΪnull!");
                    return "ִʧܣλԪزڣ";
                }

                //Ԫ
                BaseWebDrive.highLightElement(wd, we);
                
                if (operation.contains("select")) {
                    result = EncapsulateOperation.selectOperation(we, operation, operationValue);
                } else if (operation.contains("get")) {
                    result = EncapsulateOperation.getOperation(wd, we, operation, operationValue);
                } else if (operation.contains("mouse")) {
                    result = EncapsulateOperation.actionWeOperation(wd, we, operation, operationValue, property, propertyValue);
                } else {
                    result = EncapsulateOperation.objectOperation(wd, we, operation, operationValue, property, propertyValue);
                }
                // Driver
            } else if (null == property && null != operation) {
                // ¼
                if (operation.contains("alert")) {
                    result = EncapsulateOperation.alertOperation(wd, operation);
                } else if (operation.contains("mouse")) {
                    result = EncapsulateOperation.actionOperation(wd, operation, operationValue);
                } else {
                    result = EncapsulateOperation.driverOperation(wd, operation, operationValue);
                }
            } else {
                LogUtil.APP.warn("Ԫزʧܣ");
                result = "ִʧܣԪزʧܣ";
            }
        } catch (Exception e) {
            LogUtil.APP.error("Ԫضλ̻ǲʧܻ쳣",e);
            return "ִʧܣԪضλ̻ǲʧܻ쳣" + e.getMessage();
        }

        if (result.contains("ִʧܣ")){
        	caselog.insertTaskCaseLog(taskid, caseId, result, "error", String.valueOf(stepno), "");
        } else{
        	caselog.insertTaskCaseLog(taskid, caseId, result, "info", String.valueOf(stepno), "");
        } 

        if (result.contains("ȡֵǡ") && result.contains("")) {
            result = result.substring(result.indexOf("ȡֵǡ") + "ȡֵǡ".length(), result.length() - 1);
        }
        return result;
    }

    private static WebElement isElementExist(WebDriver wd, String property, String propertyValue,String operationValue) {
        try {
            WebElement we = null;
            property = property.toLowerCase();
            // WebElementλ
            switch (property) {
                case "id":
                    we = wd.findElement(By.id(propertyValue));
                    break;
                //className
                case "classname":
                    we = wd.findElement(By.className(propertyValue));
                    break;
                //classNames
                case "classnames":
                    if(NumberUtil.isInteger(operationValue)){
                        int index = Integer.parseInt(operationValue);
                        we = wd.findElements(By.className(propertyValue)).get(index);
                    }else{
                        LogUtil.APP.warn("ʹclassnamesؼoperationValueֵoperationValueֵ{}",operationValue);
                        LogUtil.APP.warn("ԶΪתclassnameؼ֣ʹĬ");
                        we = wd.findElement(By.className(propertyValue));
                    }
                    break;
                case "name":
                    we = wd.findElement(By.name(propertyValue));
                    break;
                case "xpath":
                    we = wd.findElement(By.xpath(propertyValue));
                    break;
                case "linktext":
                    we = wd.findElement(By.linkText(propertyValue));
                    break;
                case "tagname":
                    we = wd.findElement(By.tagName(propertyValue));
                    break;
                case "cssselector":
                    we = wd.findElement(By.cssSelector(propertyValue));
                    break;
                default:
                    break;
            }
            return we;

        } catch (Exception e) {
            LogUtil.APP.error("ǰλʧܣ",e);
            return null;
        }

    }

    public static Map<String,Integer> judgeResult(ProjectCase testcase, ProjectCaseSteps step, Map<String, String> params, WebDriver driver, String taskid, String expect, String result, serverOperation caselog) {
        Map<String,Integer> judgeResult=new HashMap<>();
        judgeResult.put("setResult",0);
        judgeResult.put("stepJumpNo",0);
        java.text.DateFormat timeformat = new java.text.SimpleDateFormat("MMdd-hhmmss");
        String imagname = timeformat.format(new Date());
        
        result = ActionManageForSteps.actionManage(step.getAction(), result);
        if (null != result && !result.contains("ִʧܣ")) {
            // Ԥڽ
            if (null != expect && !expect.isEmpty()) {
                //ת
                if (expect.length() > Constants.IFFAIL_JUMP.length() && expect.startsWith(Constants.IFFAIL_JUMP)) {
                    LogUtil.APP.info("Ԥڽджת裬ǰԭʼַ{}",expect);
                    String expectedTemp = expect.substring(Constants.IFFAIL_JUMP.length());
                    if(expectedTemp.contains(Constants.SYMLINK)){
                        expect = expectedTemp.substring(expectedTemp.indexOf(Constants.SYMLINK)+2);
                        try{
                            Integer stepJumpNo =  Integer.parseInt(expectedTemp.substring(0,expectedTemp.indexOf(Constants.SYMLINK)));
                            judgeResult.put("stepJumpNo",stepJumpNo);
                        }catch (NumberFormatException nfe){
                            LogUtil.APP.error("ת﷨ʧܣŲ֣ȷ:{}",expectedTemp.substring(0,expectedTemp.indexOf(Constants.SYMLINK)));
                        }
                    }else{
                        LogUtil.APP.warn("ԤڽжʧܣȷԤڽ﷨ṹ"+Constants.IFFAIL_JUMP+">>ԤڽԭʼԤڽֵ{}",expect);
                    }
                }

                LogUtil.APP.info("Ϊ{}",expect);
                // ֵģʽ
                if (expect.length() > Constants.ASSIGNMENT_SIGN.length() && expect.startsWith(Constants.ASSIGNMENT_SIGN)) {
                    variable.put(expect.substring(Constants.ASSIGNMENT_SIGN.length()), result);
                    LogUtil.APP.info(":{} {}Խ{}ֵ{}",testcase.getCaseSign(),step.getStepSerialNumber(),result,expect.substring(Constants.ASSIGNMENT_SIGN.length()));
                    caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "Խ" + result + "ֵ" + expect.substring(Constants.ASSIGNMENT_SIGN.length()) + "", "info", String.valueOf(step.getStepSerialNumber()), "");
                }
                // ֵȫֱ
                else if (expect.length() > Constants.ASSIGNMENT_GLOBALSIGN.length() && expect.startsWith(Constants.ASSIGNMENT_GLOBALSIGN)) {
                	variable.put(expect.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()), result);
                	ParamsManageForSteps.GLOBAL_VARIABLE.put(expect.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()), result);
                    LogUtil.APP.info(":{} {}Խ{}ֵȫֱ{}",testcase.getCaseSign(),step.getStepSerialNumber(),result,expect.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()));
                    caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "Խ" + result + "ֵȫֱ" + expect.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()) + "", "info", String.valueOf(step.getStepSerialNumber()), "");
                }
                // WebUIģʽ
                else if (1 == step.getStepType() && params.get("checkproperty") != null && params.get("checkproperty_value") != null) {
                    String checkproperty = params.get("checkproperty");
                    String checkPropertyValue = params.get("checkproperty_value");

                    WebElement we = isElementExist(driver, checkproperty, checkPropertyValue, "0");
                    if (null != we) {
                        LogUtil.APP.info(":{} {}ڵǰҳҵԤڽж󡣵ǰִгɹ",testcase.getCaseSign(),step.getStepSerialNumber());
                        caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ڵǰҳҵԤڽж󡣵ǰִгɹ", "info", String.valueOf(step.getStepSerialNumber()), "");
                    } else {
                        casenote = "" + step.getStepSerialNumber() + "ûڵǰҳҵԤڽжִʧܣ";
                        judgeResult.put("setResult",1);
                        BaseWebDrive.webScreenShot(driver, imagname);
                        LogUtil.APP.warn(":{} {}ûڵǰҳҵԤڽж󡣵ǰִʧܣ",testcase.getCaseSign(),step.getStepSerialNumber());
                        caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ڵǰҳûҵԤڽж󡣵ǰִʧܣ" + "checkproperty" + checkproperty + "  checkproperty_value" + checkPropertyValue + "", "error", String.valueOf(step.getStepSerialNumber()), imagname);
                    }
                }
                // ƥģʽ
                else {
                    // ģƥԤڽģʽ
                    if (expect.length() > Constants.FUZZY_MATCHING_SIGN.length() && expect.startsWith(Constants.FUZZY_MATCHING_SIGN)) {
                        if (result.contains(expect.substring(Constants.FUZZY_MATCHING_SIGN.length()))) {
                            LogUtil.APP.info(":{} {}ģƥԤڽɹִн{}",testcase.getCaseSign(),step.getStepSerialNumber(),result);
                            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ģƥԤڽɹִн" + result, "info", String.valueOf(step.getStepSerialNumber()), "");
                        } else {
                            casenote = "" + step.getStepSerialNumber() + "ģƥԤڽʧܣ";
                            judgeResult.put("setResult",1);
                            BaseWebDrive.webScreenShot(driver, imagname);
                            LogUtil.APP.warn(":{} {}ģƥԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),step.getStepSerialNumber(),expect.substring(Constants.FUZZY_MATCHING_SIGN.length()),result);
                            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ģƥԤڽʧܣԤڽ" + expect.substring(Constants.FUZZY_MATCHING_SIGN.length()) + "Խ" + result, "error", String.valueOf(step.getStepSerialNumber()), imagname);
                        }
                    }
                    // ƥԤڽģʽ
                    else if (expect.length() > Constants.REGULAR_MATCHING_SIGN.length() && expect.startsWith(Constants.REGULAR_MATCHING_SIGN)) {
                        Pattern pattern = Pattern.compile(expect.substring(Constants.REGULAR_MATCHING_SIGN.length()));
                        Matcher matcher = pattern.matcher(result);
                        if (matcher.find()) {
                            LogUtil.APP.info(":{} {}ƥԤڽɹִн:{}",testcase.getCaseSign(),step.getStepSerialNumber(),result);
                            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ƥԤڽɹ", "info", String.valueOf(step.getStepSerialNumber()), "");
                        } else {
                            casenote = "" + step.getStepSerialNumber() + "ƥԤڽʧܣ";
                            judgeResult.put("setResult",1);
                            BaseWebDrive.webScreenShot(driver, imagname);
                            LogUtil.APP.warn(":{} {}ƥԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),step.getStepSerialNumber(),expect.substring(Constants.REGULAR_MATCHING_SIGN.length()),result);
                            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ƥԤڽʧܣԤڽ" + expect.substring(Constants.REGULAR_MATCHING_SIGN.length()) + "Խ" + result, "error", String.valueOf(step.getStepSerialNumber()), imagname);
                        }
                    }
                    // ȷƥԤڽģʽ
                    else {
                        if (expect.equals(result)) {
                            LogUtil.APP.info(":{} {}ȷƥԤڽɹִн:{}",testcase.getCaseSign(),step.getStepSerialNumber(),result);
                            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ȷƥԤڽɹ", "info", String.valueOf(step.getStepSerialNumber()), "");
                        } else if(expect.trim().equals("NULL")&& StringUtils.isBlank(result)){
                            result = "ؽΪգƥNULLɹ";
                            LogUtil.APP.info(":{} {}ȷƥԤڽɹִн:{}",testcase.getCaseSign(),step.getStepSerialNumber(),result);
                            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ȷƥԤڽɹ", "info", String.valueOf(step.getStepSerialNumber()), "");
                        } else {
                            casenote = "" + step.getStepSerialNumber() + "ȷƥԤڽʧܣ";
                            judgeResult.put("setResult",1);
                            BaseWebDrive.webScreenShot(driver, imagname);
                            LogUtil.APP.warn(":{} {}ȷƥԤڽʧܣԤڽ:{}  ִн:{}",testcase.getCaseSign(),step.getStepSerialNumber(),expect,result);
                            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ȷƥԤڽʧܣԤڽǣ"+expect+"  ִн"+ result+"", "error", String.valueOf(step.getStepSerialNumber()), imagname);
                        }
                    }
                }
            }
        } else {
            casenote = (null != result) ? result : "";
            judgeResult.put("setResult",2);
            BaseWebDrive.webScreenShot(driver, imagname);
            LogUtil.APP.warn(":{} {}ִн:{}",testcase.getCaseSign(),step.getStepSerialNumber(),casenote);
            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ǰִйн|λԪ|ʧܣ" + casenote, "error", String.valueOf(step.getStepSerialNumber()), imagname);
        }

        return judgeResult;
    }
}