package luckyclient.execution.webdriver;

import com.offbytwo.jenkins.model.BuildResult;
import luckyclient.execution.httpinterface.TestControl;
import luckyclient.execution.webdriver.ex.WebCaseExecution;
import luckyclient.remote.api.GetServerApi;
import luckyclient.remote.api.serverOperation;
import luckyclient.remote.entity.*;
import luckyclient.tool.jenkins.BuildingInitialization;
import luckyclient.tool.mail.HtmlMail;
import luckyclient.tool.mail.MailSendInitialization;
import luckyclient.tool.shell.RestartServerInitialization;
import luckyclient.utils.LogUtil;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 seagull1985
 * =================================================================
 *
 * @author seagull
 *
 * @date 2017121 9:29:40
 *
 */
public class WebTestControl {

	/**
	 * ̨ģʽȼƻִ
	 * @param planname ƻ
	 */
	public static void manualExecutionPlan(String planname) {
		// ־ݿ
		serverOperation.exetype = 1;
		String taskid = "888888";
		WebDriver wd = null;
		try {
			wd = WebDriverInitialization.setWebDriverForLocal();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			LogUtil.APP.error("ʼWebDriver쳣",e);
		}
		serverOperation caselog = new serverOperation();
		List<ProjectCase> testCases = GetServerApi.getCasesbyplanname(planname);
		List<ProjectCaseParams> pcplist = new ArrayList<>();
		if (testCases.size() != 0) {
			pcplist = GetServerApi.cgetParamsByProjectid(String.valueOf(testCases.get(0).getProjectId()));
		}
		LogUtil.APP.info("ǰƻжȡ{}",testCases.size());
		int i = 0;
		for (ProjectCase testcase : testCases) {
			List<ProjectCaseSteps> steps = GetServerApi.getStepsbycaseid(testcase.getCaseId());
			if (steps.size() == 0) {
				continue;
			}
			i++;
			LogUtil.APP.info("ʼִе{}:{}......",i,testcase.getCaseSign());
			try {
				WebCaseExecution.caseExcution(testcase, steps, taskid, null,wd, caselog, pcplist);
			} catch (Exception e) {
				LogUtil.APP.error("ûִй׳쳣", e);
			}
			LogUtil.APP.info("ǰ:{}ִ......һ",testcase.getCaseSign());
		}
		LogUtil.APP.info("ǰĿԼƻеѾȫִ...");
		// ر
		assert wd != null;
		wd.quit();
	}

	public static void taskExecutionPlan(TaskExecute task) {
		// ¼־ݿ
		serverOperation.exetype = 0;
		String taskid = task.getTaskId().toString();
		TestControl.TASKID = taskid;
		String restartstatus = RestartServerInitialization.restartServerRun(taskid);
		BuildResult buildResult = BuildingInitialization.buildingRun(taskid);
		TaskScheduling taskScheduling = GetServerApi.cGetTaskSchedulingByTaskId(task.getTaskId());
		List<ProjectCaseParams> pcplist = GetServerApi.cgetParamsByProjectid(task.getProjectId().toString());
		String projectname = taskScheduling.getProject().getProjectName();
		task = GetServerApi.cgetTaskbyid(Integer.parseInt(taskid));
		String jobname = taskScheduling.getSchedulingName();
		int drivertype = serverOperation.querydrivertype(taskid);
		int[] tastcount=new int[5];
		// жǷҪԶTOMCAT
		if (restartstatus.contains("Status:true")) {
			// жǷ񹹽Ƿɹ
			if (BuildResult.SUCCESS.equals(buildResult)) {

				List<ProjectPlan> plans=new ArrayList<>();
				// ƻִ
				if(taskScheduling.getPlanType()==1){
					ProjectPlan projectPlan=GetServerApi.getProjectPlanByPlanId(taskScheduling.getPlanId());
					plans.add(projectPlan);
				}
				// ۺ϶ƻִ
				else if(taskScheduling.getPlanType()==2){
					plans.addAll(GetServerApi.getPlansbysuiteId(taskScheduling.getSuiteId()));
				}
				LogUtil.APP.info("ǰ {} йС{}Լƻ...",task.getTaskName(),plans.size());

				int caseCount=0;
				for(ProjectPlan pp:plans){
					List<ProjectCase> cases = GetServerApi.getCasesbyplanId(pp.getPlanId());
					caseCount+=cases.size();
				}

				for(ProjectPlan pp:plans){
					WebDriver wd = null;
					try {
						wd = WebDriverInitialization.setWebDriverForTask(drivertype);
					} catch (WebDriverException e1) {
						LogUtil.APP.error("ʼWebDriver WebDriverException", e1);
					} catch (IOException e2) {
						LogUtil.APP.error("ʼWebDriver IOException", e2);
					}

					serverOperation caselog = new serverOperation();
					List<ProjectCase> cases = GetServerApi.getCasesbyplanId(pp.getPlanId());
					LogUtil.APP.info("ǰԼƻ {} йС{}...",pp.getPlanName(),cases.size());
					LogUtil.APP.info("ʼִеǰԼƻ {} ......",pp.getPlanName());
					serverOperation.updateTaskExecuteStatusIng(taskid, caseCount);
					int i = 0;
					for (ProjectCase testcase : cases) {
						i++;
						LogUtil.APP.info("ʼִеǰ {} ĵڡ{}:{}......",task.getTaskName(),i,testcase.getCaseSign());
						List<ProjectCaseSteps> steps = GetServerApi.getStepsbycaseid(testcase.getCaseId());
						if (steps.size() == 0) {
							continue;
						}
						try {
							// 뿪ʼִе
							caselog.insertTaskCaseExecute(taskid, taskScheduling.getProjectId(),pp.getPlanId(),testcase.getCaseId(),testcase.getCaseSign(), testcase.getCaseName(), 4);
							WebCaseExecution.caseExcution(testcase, steps, taskid,pp.getPlanId(),wd, caselog, pcplist);
						} catch (Exception e) {
							// TODO Auto-generated catch block
							LogUtil.APP.error("ûִй׳쳣", e);
						}
						LogUtil.APP.info("ǰ:{}ִ......һ",testcase.getCaseSign());
					}
					LogUtil.APP.info("ǰ{}ԼƻеѾȫִ...",pp.getPlanName());
					assert wd != null;
					wd.quit();
				}

				tastcount = serverOperation.updateTaskExecuteData(taskid, caseCount,2);
				tastcount[0]=caseCount;
				String testtime = serverOperation.getTestTime(taskid);
				LogUtil.APP.info("ǰĿ{}ԼƻеѾȫִ...",projectname);
				MailSendInitialization.sendMailInitialization(HtmlMail.htmlSubjectFormat(jobname),
						HtmlMail.htmlContentFormat(tastcount, taskid, buildResult.toString(), restartstatus, testtime, jobname),
						taskid, taskScheduling, tastcount,testtime,buildResult.toString(),restartstatus);
			} else {
				LogUtil.APP.warn("ĿʧܣԶԶ˳ǰJENKINSмĿ");
				MailSendInitialization.sendMailInitialization(jobname, "ĿʧܣԶԶ˳ǰȥJENKINS鿴", taskid,
						taskScheduling, null,"0Сʱ00",buildResult.toString(),restartstatus);
			}
		} else {
			LogUtil.APP.warn("ĿTOMCATʧܣԶԶ˳ĿTOMCAT");
			MailSendInitialization.sendMailInitialization(jobname, "ĿTOMCATʧܣԶԶ˳ĿTOMCAT", taskid,
					taskScheduling, null,"0Сʱ00",buildResult.toString(),restartstatus);
		}
	}

}
