package luckyclient.execution.webdriver;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerDriver;

import luckyclient.utils.LogUtil;
import springboot.RunService;


/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 * 
 * @author seagull
 * @date 2017121 9:29:40
 * 
 */
public class WebDriverInitialization{
	private static final String OS=System.getProperty("os.name").toLowerCase();
	/**
	 * ʼWebDriver
	 * @param drivertype 
	 * @return سʼ
	 * @throws WebDriverException ׳쳣
	 * @throws IOException ȡļ쳣
	 */
	public static WebDriver setWebDriverForTask(int drivertype) throws WebDriverException,IOException{
		// Ϊ
		String drivenpath= RunService.APPLICATION_HOME + File.separator+"BrowserDriven"+File.separator;
		WebDriver webDriver = null;
		LogUtil.APP.info("׼ʼWebDriver...鵽ǰϵͳ:{}",OS);
		if(drivertype==0){
			if(OS.startsWith("win")){
				System.setProperty("webdriver.ie.driver",drivenpath+"IEDriverServer.exe");
				webDriver = new InternetExplorerDriver();
			}else{
				LogUtil.APP.warn("ǰϵͳ޷IEWeb UIԣѡǹȸ");
			}		
		}else if(drivertype==1){
			FirefoxOptions options = new FirefoxOptions();
			if(OS.startsWith("win")){
				System.setProperty("webdriver.gecko.driver",drivenpath+"geckodriver.exe");
			}else if(OS.contains("mac")){
				options.addArguments("start-maximized");
				System.setProperty("webdriver.gecko.driver",drivenpath+"geckodriver_mac");
			}else{
				LogUtil.APP.info("⵽ǰϵͳLinux,ĬʹheadlessʽFirefoxWeb UIԶ...");
				//޽
				options.setHeadless(true);
				//ɳ
				options.addArguments("no-sandbox");
				options.addArguments("start-maximized");
				System.setProperty("webdriver.gecko.driver",drivenpath+"geckodriver_linux64");
			}
			webDriver = new FirefoxDriver(options);
		}else if(drivertype==2){
			ChromeOptions options = new ChromeOptions();
			if(OS.startsWith("win")){
				System.setProperty("webdriver.chrome.driver",drivenpath+"chromedriver.exe");
			}else if(OS.contains("mac")){
				options.addArguments("start-maximized");
				System.setProperty("webdriver.chrome.driver",drivenpath+"chromedriver_mac");
			}else{
				LogUtil.APP.info("⵽ǰϵͳLinux,ĬʹheadlessʽChromeWeb UIԶ...");
				//޽
				options.setHeadless(true);
				//ɳ
				options.addArguments("no-sandbox");
				options.addArguments("start-maximized");
				System.setProperty("webdriver.chrome.driver",drivenpath+"chromedriver_linux64");
			}			
			webDriver = new ChromeDriver(options);
		}else if(drivertype==3){
			if(OS.startsWith("win")){
				System.setProperty("webdriver.edge.driver",drivenpath+"msedgedriver.exe");
				webDriver = new EdgeDriver();
			}else if(OS.contains("mac")){
				System.setProperty("webdriver.edge.driver",drivenpath+"msedgedriver_mac");
				webDriver = new EdgeDriver();
			}else{
				LogUtil.APP.warn("ǰϵͳ޷EdgeWeb UIԣѡǹȸ");
			}
		}else{
			LogUtil.APP.warn("ͱʶ:{}ȡͱʶδ壬ĬIEִ....",drivertype);
			System.setProperty("webdriver.ie.driver",drivenpath+"IEDriverServer.exe");
			webDriver = new InternetExplorerDriver();
		}
		
		//webdriverunixУ󻯻쳣bugunixoptionsе
		if(OS.startsWith("win")){
			assert webDriver != null;
			webDriver.manage().window().maximize();
		}

		//ҳʱ30
		assert webDriver != null;
		webDriver.manage().timeouts().pageLoadTimeout(30, TimeUnit.SECONDS);
		//Ԫسʱ30  
		webDriver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
		
        return webDriver;
	}

	/**
	 * ʼWebDriver
	 * @return سʼ
	 * @throws IOException ȡļ쳣
	 */
	public static WebDriver setWebDriverForLocal() throws IOException{
		File directory = new File("");
		String drivenpath=directory.getCanonicalPath()+File.separator+"BrowserDriven"+File.separator;
		System.setProperty("webdriver.ie.driver",drivenpath+"IEDriverServer.exe");
		WebDriver webDriver = new InternetExplorerDriver();
		webDriver.manage().window().maximize();
		//ҳʱ30
		webDriver.manage().timeouts().pageLoadTimeout(30, TimeUnit.SECONDS);
		//Ԫسʱ30  
		webDriver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);  
        return webDriver;
	}

}
