package luckyclient.execution.webdriver;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.*;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Select;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import luckyclient.execution.dispose.ChangString;
import luckyclient.execution.webdriver.ocr.Ocr;
import luckyclient.utils.LogUtil;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 *
 * @author seagull
 * @date 2017121 9:29:40
 */
public class EncapsulateOperation {

    public static String selectOperation(WebElement we, String operation, String operationValue) {
        String result = "";
        // 
        Select select = new Select(we);

        // ¼
        switch (operation) {
            case "selectbyvisibletext":
                select.selectByVisibleText(operationValue);
                result = "ͨVisibleTextѡ...VisibleTextֵ:" + operationValue + "";
                LogUtil.APP.info("ͨVisibleTextѡ...VisibleTextֵ:{}",operationValue);
                break;
            case "selectbyvalue":
                select.selectByValue(operationValue);
                result = "ͨValueѡ...Valueֵ:" + operationValue + "";
                LogUtil.APP.info("ͨValueѡ...Valueֵ:{}",operationValue);
                break;
            case "selectbyindex":
                select.selectByIndex(Integer.parseInt(operationValue));
                result = "ͨIndexѡ...Indexֵ:" + operationValue + "";
                LogUtil.APP.info("ͨIndexѡ...Indexֵ:{}",operationValue);
                break;
            case "isselect":
                result = "ȡֵǡ" + we.isSelected() + "";
                LogUtil.APP.info("ж϶ǷѾѡ...ֵ:{}",we.isSelected());
                break;
            default:
                break;
        }
        return result;
    }

    public static String getOperation(WebDriver wd, WebElement we, String operation, String value) {
        String result = "";
        // ȡ
        switch (operation) {
            case "gettext":
                result = "ȡֵǡ" + we.getText() + "";
                LogUtil.APP.info("getTextȡtext...textֵ:{}",result);
                break; // ȡ
            case "gettagname":
                result = "ȡֵǡ" + we.getTagName() + "";
                LogUtil.APP.info("getTagNameȡtagname...tagnameֵ:{}",result);
                break;
            case "getvalue":
                result = "ȡֵǡ" + we.getAttribute("value") + "";
                LogUtil.APP.info("getAttributeȡvalue...valueֵ:{}",result);
                break;
            case "getattribute":
                result = "ȡֵǡ" + we.getAttribute(value) + "";
                LogUtil.APP.info("getAttributeȡ{}...{}ֵ:{}",value,value,result);
                break;
            case "getcssvalue":
                result = "ȡֵǡ" + we.getCssValue(value) + "";
                LogUtil.APP.info("getCssValueȡ{}...{}ֵ:{}",value,value,result);
                break;
            case "getcaptcha":
                result = "ȡֵǡ" + Ocr.getCAPTCHA(wd, we) + "";
                LogUtil.APP.info("getcaptchaȡ֤...ֵ֤:{}",result);
                break;
            default:
                break;
        }
        return result;
    }

    public static String actionWeOperation(WebDriver wd, WebElement we, String operation, String operationValue, String property, String propertyValue) {
        String result = "";
        Actions action = new Actions(wd);
        // action
        switch (operation) {
            //
            case "mouselkclick":
                action.click(we).perform();
                result = "mouselkclick...λ:" + property + "; λֵ:" + propertyValue + "";
                LogUtil.APP.info("mouselkclick...λ:{}; λֵ:{}",property,propertyValue);
                break;
            case "mouserkclick":
                action.contextClick(we).perform();
                result = "mouserkclickҼ...λ:" + property + "; λֵ:" + propertyValue + "";
                LogUtil.APP.info("mouserkclickҼ...λ:{}; λֵ:{}",property,propertyValue);
                break;
            case "mousedclick":
                action.doubleClick(we).perform();
                result = "mousedclick˫...λ:" + property + "; λֵ:" + propertyValue + "";
                LogUtil.APP.info("mousedclick˫...λ:{}; λֵ:{}",property,propertyValue);
                break;
            case "mouseclickhold":
                action.clickAndHold(we).perform();
                result = "mouseclickholdͷ...λ:" + property + "; λֵ:" + propertyValue + "";
                LogUtil.APP.info("mouseclickholdͷ...λ:{}; λֵ:{}",property,propertyValue);
                break;
            case "mousedrag":
                int[] location = getLocationFromParam(operationValue);
//                String[] temp = operationValue.split(",", -1);
                action.dragAndDropBy(we, location[0], location[1]).perform();
                result = "mousedragƶ...λ:" + property + "; λֵ:" + propertyValue + "; (x,y):" + location[0] + "," + location[1] + "";
                LogUtil.APP.info("mousedragƶ...λ:{}; λֵ:{}; (x,y):{},{}",property,propertyValue,location[0],location[1]);
                break;
            case "mouseto":
                int[] location1 = getLocationFromParam(operationValue);
//                String[] temp1 = operationValue.split(",", -1);
                action.moveToElement(we, location1[0], location1[1]).perform();
                result = "mousetoƶ...λ:" + property + "; λֵ:" + propertyValue + "; (x,y):" + location1[0] + "," + location1[1] + "";
                LogUtil.APP.info("mousetoƶ...λ:{}; λֵ:{}; (x,y):{},{}",property,propertyValue,location1[0],location1[1]);
                break;
            case "mouserelease":
                action.release(we).perform();
                result = "mousereleaseͷ...";
                LogUtil.APP.info("mousereleaseͷ...");
                break;
            default:
                break;
        }
        return result;
    }

    public static String actionOperation(WebDriver wd, String operation, String operationValue) {
        String result = "";
        Actions action = new Actions(wd);
        // action
        switch (operation) {
            //
            case "mouselkclick":
                action.click().perform();
                result = "mouselkclickǰλ...";
                LogUtil.APP.info(result);
                break;
            case "mouserkclick":
                action.contextClick().perform();
                result = "mouserkclickҼǰλ...";
                LogUtil.APP.info(result);
                break;
            case "mousedclick":
                action.doubleClick().perform();
                result = "mousedclick˫ǰλ...";
                LogUtil.APP.info(result);
                break;
            case "mouseclickhold":
                action.clickAndHold().perform();
                result = "mouseclickholdǰλúͷ...";
                LogUtil.APP.info(result);
                break;
            case "mouseto":
                int[] location = getLocationFromParam(operationValue);
//                String[] temp1 = operationValue.split(",", -1);
                action.moveByOffset(location[0], location[1]).perform();
                result = "mousetoƶ...x" + location[0] + " y" + location[1];
                LogUtil.APP.info("mousetoƶ...x:{} y:{}",location[0],location[1]);
                break;
            case "mouserelease":
                action.release().perform();
                result = "mousereleaseͷ...";
                LogUtil.APP.info(result);
                break;
            case "mousekey":
                switch (operationValue) {
                    case "tab":
                        action.sendKeys(Keys.TAB).perform();
                        result = "̲TAB...";
                        LogUtil.APP.info(result);
                        break;
                    case "space":
                        action.sendKeys(Keys.SPACE).perform();
                        result = "̲SPACE...";
                        LogUtil.APP.info(result);
                        break;
                    case "ctrl":
                        action.sendKeys(Keys.CONTROL).perform();
                        result = "̲CONTROL...";
                        LogUtil.APP.info(result);
                        break;
                    case "shift":
                        action.sendKeys(Keys.SHIFT).perform();
                        result = "̲SHIFT...";
                        LogUtil.APP.info(result);
                        break;
                    case "enter":
                        action.sendKeys(Keys.ENTER).perform();
                        result = "̲ENTER...";
                        LogUtil.APP.info(result);
                        break;
                    default:
                        break;
                }
                break;
            default:
                break;
        }
        return result;
    }

    public static String objectOperation(WebDriver wd, WebElement we, String operation, String operationValue, String property, String propertyValue) {
        String result = "";
        // WebElement
        switch (operation) {
            case "click":
                we.click();
                result = "click...λ:" + property + "; λֵ:" + propertyValue + "";
                LogUtil.APP.info("click...λ:{}; λֵ:{}",property,propertyValue);
                break;
            case "sendkeys":
                we.sendKeys(operationValue);
                result = "sendKeys...λ:" + property + "; λֵ:" + propertyValue + "; ֵ:" + operationValue + "";
                LogUtil.APP.info("sendKeys...λ:{}; λֵ:{}; ֵ:{}",property,propertyValue,operationValue);
                break;
            case "clear":
                we.clear();
                result = "clear...λ:" + property + "; λֵ:" + propertyValue + "";
                LogUtil.APP.info("clear...λ:{}; λֵ:{}",property,propertyValue);
                break; // 
            case "gotoframe":
                wd.switchTo().frame(we);
                result = "gotoframeлFrame...λ:" + property + "; λֵ:" + propertyValue + "";
                LogUtil.APP.info("gotoframeлFrame...λ:{}; λֵ:{}",property,propertyValue);
                break;
            case "isenabled":
                result = "ȡֵǡ"+we.isEnabled()+"";
                LogUtil.APP.info("ȡֵǡ{}",we.isEnabled());
                break;
            case "isdisplayed":
                result = "ȡֵǡ" + we.isDisplayed() + "";
                LogUtil.APP.info("ȡֵǡ{}", we.isDisplayed());
                break;
            case "exjsob":
                JavascriptExecutor jse = (JavascriptExecutor) wd;
                Object obj = jse.executeScript(operationValue, we);
                if (null != obj) {
                    String tmp = obj.toString();
                    result = (100 < tmp.length()) ? tmp.substring(0, 100) + "..." : tmp;
                    result = "ȡֵǡ" + result + "";
                    LogUtil.APP.info("ִJS...{}صĽΪ:{}",operationValue,result);
                } else {
                    result = "ִJS..." + operationValue + "";
                    LogUtil.APP.info("ִJS...{}",operationValue);
                }
                break;
            case "scrollto":
                Point location = we.getLocation();
                ((JavascriptExecutor) wd).executeScript("window.scrollTo(" + location.getX() + ", " + location.getY() + ")");
                result = "Ŀ...λ:" + property + "; λֵ:" + propertyValue + "; (x,y):" + location.getX() + "," + location.getY() + "";
                LogUtil.APP.info("Ŀ...λ:{}; λֵ:{}; (x,y):{},{}",property,propertyValue,location.getX(),location.getY());
                break;
            case "scrollintoview":
                // ˷ִjs
                ((JavascriptExecutor) wd).executeScript("arguments[0].scrollIntoView(" + operationValue + ")", we);
                result = "Ŀ...λ:" + property + "; λֵ:" + propertyValue + "";
                LogUtil.APP.info("Ŀ...λ:{}; λֵ:{}",property,propertyValue);
                break;
            default:
                break;
        }
        return result;
    }

    public static String alertOperation(WebDriver wd, String operation) {
        String result = "";
        Alert alert = wd.switchTo().alert();
        switch (operation) {
            case "alertaccept":
                alert.accept();
                result = "ͬ...";
                LogUtil.APP.info(result);
                break;
            case "alertdismiss":
                alert.dismiss();
                result = "ȡ...";
                LogUtil.APP.info(result);
                break;
            case "alertgettext":
                result = "ȡֵǡ" + alert.getText() + "";
                LogUtil.APP.info("ͨgetTextȡtext...Textֵ:{}",alert.getText());
                break;
            default:
                break;
        }
        return result;
    }

    public static String driverOperation(WebDriver wd, String operation, String operationValue) {
        String result = "";
        // ҳ
        switch (operation) {
            case "open":
                wd.get(operationValue);
                result = "Openҳ..." + operationValue + "";
                LogUtil.APP.info("Openҳ...{}",operationValue);
                break;
            case "addcookie":
                List<Cookie> cookies = buildCookie(operationValue);
                if (null != cookies && cookies.size() > 0) {
                    for (Cookie cookie : cookies) {
                        wd.manage().addCookie(cookie);
                        LogUtil.APP.info("Cookie:{}ɹ",cookie);
                    }
                }
                result = "cookie..." + operationValue + "";
                break;
            case "exjs":
                JavascriptExecutor jse = (JavascriptExecutor) wd;
                Object obj = jse.executeScript(operationValue);
                if (null != obj) {
                    String tmp = obj.toString();
                    result = (100 < tmp.length()) ? tmp.substring(0, 100) + "..." : tmp;
                    result = "ȡֵǡ" + result + "";
                    LogUtil.APP.info("ִJS...{}صĽΪ:{}",operationValue,result);
                } else {
                    result = "ִJS..." + operationValue + "";
                    LogUtil.APP.info("{}ִJSnullûз",result);
                }
                break;
            case "gotodefaultcontent":
                wd.switchTo().defaultContent();
                result = "gotodefaultcontentлĬҳλ...";
                LogUtil.APP.info(result);
                break;
            case "gotoparentframe":
                wd.switchTo().parentFrame();
                result = "gotoparentframeлһframeλ...";
                LogUtil.APP.info(result);
                break;
            case "gettitle":
                result = "ȡֵǡ" + wd.getTitle() + "";
                LogUtil.APP.info("ȡҳTitle...{}",wd.getTitle());
                break;
            case "getwindowhandle":
                result = getTargetWindowHandle(wd, operationValue);
                break;
            case "gotowindow":
                result = switchToTargetWindow(wd, operationValue);
                break;
            case "switchtowindow":
                switchToWindow(wd);
                break;
            case "windowsetsize":
                manageWindowSetSize(wd,operationValue);
                break;
            case "closewindow":
                wd.close();
                result = "رյǰ...";
                break;
            case "pagerefresh":
                wd.navigate().refresh();
                result = "ˢµǰ...";
                break;
            case "pageforward":
                wd.navigate().forward();
                result = "ǰǰ...";
                break;
            case "pageback":
                wd.navigate().back();
                result = "˵ǰ...";
                break;
            case "timeout":
                try {
                    // ҳʱ30
                    wd.manage().timeouts().pageLoadTimeout(Integer.parseInt(operationValue), TimeUnit.SECONDS);
                    // Ԫسʱ30
                    wd.manage().timeouts().implicitlyWait(Integer.parseInt(operationValue), TimeUnit.SECONDS);
                    result = "ǰȴ" + operationValue + "...";
                    LogUtil.APP.info("ǰȴ{}...",operationValue);
                    break;
                } catch (NumberFormatException e) {
                    LogUtil.APP.error("ȴʱת쳣",e);
                    result = "ȴʱת";
                    break;
                }
            default:
                break;
        }
        return result;
    }

    private static List<Cookie> buildCookie(String operationValue) {
        if (StringUtils.isBlank(operationValue)) {
        	LogUtil.APP.info("ȡCookieֵoperationValueΪգ");
            return null;
        }
        try {
            JSONArray objects = JSON.parseArray(operationValue);
            if (null == objects) {
            	LogUtil.APP.info("ʽCookieַJSONArrayΪգ");
                return null;
            }
            List<Cookie> result = new ArrayList<>(objects.size());
            for (int i = 0; i < objects.size(); i++) {
                JSONObject jsonObject = objects.getJSONObject(i);
                if (null == jsonObject) {
                    continue;
                }
                String name = jsonObject.getString("name");
                String val = jsonObject.getString("val");
                String domain = jsonObject.getString("domain");
                String path = jsonObject.getString("path");
                // TODO ೤ʱ䣬ʧЧʱ,λ
                //String expire = jsonObject.getString("expire");
                if (!StringUtils.isBlank(name) && !StringUtils.isBlank(val)) {
                    Cookie cookie = new Cookie(name, val, domain, path, null);
                	LogUtil.APP.info("Cookieɹ{}",cookie);
                    result.add(cookie);
                }else{
                    LogUtil.APP.warn("cookie:{} ,namevalΪգ",jsonObject);
                }
            }
            return result;
        } catch (Exception e) {
            LogUtil.APP.error("ʽCookieĸʽǷȷ{}",operationValue,e);
            return null;
        }
    }

    private static int[] getLocationFromParam(String param) {
        int[] location = {0, 0};
        if (null == param || param.trim().isEmpty()) {
            return location;
        } else {
            // ָ
            if (! param.contains(",")) {
                location[0] = Integer.parseInt(param.trim());
            } else {
                String[] tmp = param.split(",", 2);
                for (int i = 0; i < 2; i++) {
                    if (! tmp[i].trim().isEmpty()){
                    	location[i] = Integer.parseInt(tmp[i].trim());
                    } 
                }
            }
        }
        return location;
    }

    /**
     * operationValueΪĿ괰ھ±, 1ʼ; Сڵ0ȡǰڵľֵ
     * ھֵCDwindow-ͷ, ΪԤڽĶ
     * @param driver 
     * @param target ַ
     * @return ػȡ
     * @author Seagull
     * @date 201989
     */
    private static String getTargetWindowHandle(WebDriver driver, String target) {
        String result;
        if (null != driver) {
            if (!ChangString.isInteger(target)) {
                result = windowHandleByTitle(driver, target);
            } else {
                int index = Integer.parseInt(target);
                result = windowHandleByIndex(driver, index);
            }
        } else {
            result = "ȡھֵʧܣWebDriverΪ";
        }
        if (result.contains("ȡھֵʧ")){
        	LogUtil.APP.warn(result);
        } else {
        	LogUtil.APP.info("ȡھֵɹĿ괰ھֵΪ{}",result);
        }
        return result;
    }

    private static String windowHandleByTitle(WebDriver driver, String title) {
        String result = "";
        String original = driver.getWindowHandle();
        if (title.isEmpty()) {
            result = original;
        } else {
            Set<String> windowHandles = driver.getWindowHandles();
            for (String windowHandle : windowHandles) {
                driver.switchTo().window(windowHandle);
                if (title.equals(driver.getTitle())) {
                    result = windowHandle;
                    break;
                }
            }
            if (0 < windowHandles.size()){
            	driver.switchTo().window(original);
            } 
        }
        result = result.isEmpty() ? "ȡھֵʧܣҪȡھֵı⡾" + title + "ûҵ" : "ȡֵǡ" + result + "";
        return result;
    }

    private static String windowHandleByIndex(WebDriver driver, int index) {
        String result;
        try {
            List<String> windowHandles = new ArrayList<>(driver.getWindowHandles());
            if (index > windowHandles.size()) {
                result = "ȡھֵʧܣҪȡھֵ±꡾" + index + "ڵǰھ" + windowHandles.size() + "";
            } else {
                if (0 >= index){
                	result = "ȡֵǡ" + driver.getWindowHandle() + "";
                } else{
                	result = "ȡֵǡ" + windowHandles.get(index - 1) + "";
                } 
            }
        } catch (IndexOutOfBoundsException e) {
        	LogUtil.APP.error("ȡھֵ쳣Ҫȡھֵ±꡾{}Խ",index,e);
            result = "ȡھֵʧܣҪȡھֵ±꡾" + index + "Խ";
        }
        return result;
    }

    // ȴ30, ÿ500ѯһ
    private static FluentWait<WebDriver> wait(WebDriver driver) {
        return new FluentWait<>(driver).withTimeout(Duration.ofSeconds(30)).pollingEvery(Duration.ofMillis(500));
    }

    private static ExpectedCondition<WebDriver> windowToBeAvailableAndSwitchToIt(final String nameOrHandleOrTitle) {
        return driver -> {
            try {
                if (null != driver){
                	return driver.switchTo().window(nameOrHandleOrTitle);
                } else{
                	return null;
                }
                    
            } catch (NoSuchWindowException windowWithNameOrHandleNotFound) {
                try {
                    return windowByTitle(driver, nameOrHandleOrTitle);
                } catch (NoSuchWindowException windowWithTitleNotFound) {
                    if (ChangString.isInteger(nameOrHandleOrTitle)){
                    	return windowByIndex(driver, Integer.parseInt(nameOrHandleOrTitle));
                    } else{
                    	return null;
                    }                       
                }
            }
        };
    }

    private static WebDriver windowByTitle(WebDriver driver, String title) {
        String original = driver.getWindowHandle();
        Set<String> windowHandles = driver.getWindowHandles();
        for (String windowHandle : windowHandles) {
            driver.switchTo().window(windowHandle);
            if (title.equals(driver.getTitle())) {
                return driver;
            }
        }
        if (0 < windowHandles.size()){
        	driver.switchTo().window(original);
        } 
        throw new NoSuchWindowException("Window with title[" + title + "] not found");
    }

    private static WebDriver windowByIndex(WebDriver driver, int index) {
        try {
            List<String> windowHandles = new ArrayList<>(driver.getWindowHandles());
            return driver.switchTo().window(windowHandles.get(index));
        } catch (IndexOutOfBoundsException windowWithIndexNotFound) {
            return null;
        }
    }

    private static String switchToTargetWindow(WebDriver driver, String target) {
        String result;
        try {
            if (null == wait(driver).until(windowToBeAvailableAndSwitchToIt(target))) {
                result = "ִʧܣлھʧܣδҵֵΪ" + target + "Ķ";
                LogUtil.APP.warn("лھʧܣδҵֵΪ{}Ķ",target);
            } else {
                result = "лھɹҵֵΪ" + target + "Ķ";
                LogUtil.APP.info("лھɹҵֵΪ{}Ķ",target);
            }
            return result;
        } catch (TimeoutException e) {
            result = "ִʧܣлھʧܣȴʱδҵֵΪ" + target + "Ķ";
            LogUtil.APP.error("лھʧܣȴʱδҵֵΪ{}Ķ",target,e);
            return result;
        }
    }

    //޸ĵ л
    private static void switchToWindow(WebDriver driver) {
        String current_window_handle=driver.getWindowHandle();
        LogUtil.APP.info("ǰ"+current_window_handle);
        driver.close();
        LogUtil.APP.info("رյǰ"+current_window_handle);
        for (String s : driver.getWindowHandles()) {
            if (!s.equals(current_window_handle)) {
                driver.switchTo().window(s);
            }
        }
    }

    //޸ĵ ڴС
    private static void manageWindowSetSize(WebDriver driver,String operationValue) {
        if(operationValue.contains(",")){
            String[] index=operationValue.split(",");

            if (index.length==2){
                driver.manage().window().setSize(new Dimension(Integer.parseInt(index[0].trim()), Integer.parseInt(index[1].trim())));
            }else {
                LogUtil.APP.info("ʽȷʽΪxxx,xxx");
            }
        }else {
            LogUtil.APP.info("ʽȷʽΪxxx,xxx");
        }
    }

}

