package luckyclient.execution.webdriver;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

import org.apache.commons.io.FileUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Augmenter;

import cn.hutool.core.util.BooleanUtil;
import luckyclient.utils.LogUtil;
import luckyclient.utils.config.SysConfig;
import springboot.RunService;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 * 
 * @author seagull
 * @date 2017121 9:29:40
 * 
 */
public class BaseWebDrive {

	/**
	 * Խнͼ
	 * @param driver 
	 * @param imgname ͼƬ
	 */
	public static void webScreenShot(WebDriver driver, String imgname) {
		String relativelyPath = RunService.APPLICATION_HOME;
		String pngpath=relativelyPath +File.separator+ "log"+File.separator+"ScreenShot" +File.separator+ imgname + ".png";

		// Զϵͳнͼ
		driver = new Augmenter().augment(driver);
		File scrFile = ((TakesScreenshot) driver).getScreenshotAs(OutputType.FILE);
		try {
			FileUtils.copyFile(scrFile, new File(pngpath));
		} catch (IOException e) {
			LogUtil.APP.error("ͼʧܣ׳쳣鿴־...", e);
		}
		scrFile.deleteOnExit();
		LogUtil.APP
				.info("ѶԵǰнͼִͨн־ϸ鿴Ҳǰͻϲ鿴...{}",pngpath);
	}

	/**
	 * ԶмʾЧ
	 * @param driver 
	 * @param element λԪ
	 * @author Seagull
	 * @date 201996
	 */
    public static void highLightElement(WebDriver driver, WebElement element){
    	Properties properties = SysConfig.getConfiguration();
    	boolean highLight = BooleanUtil.toBoolean(properties.getProperty("webdriver.highlight"));

    	if(highLight){
            JavascriptExecutor js = (JavascriptExecutor) driver;
            /*jsҳԪضıɫͱ߿ɫֱ趨Ϊɫͺɫ*/
            js.executeScript("arguments[0].setAttribute('style', arguments[1]);", element, "background: yellow; border:2px solid red;");
    	}
    }

}
