package luckyclient.execution.httpinterface;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cn.hutool.core.util.NumberUtil;
import luckyclient.driven.SubString;
import luckyclient.execution.dispose.ActionManageForSteps;
import luckyclient.execution.dispose.ParamsManageForSteps;
import luckyclient.execution.httpinterface.analyticsteps.InterfaceAnalyticCase;
import luckyclient.execution.webdriver.ex.WebOneCaseExecute;
import luckyclient.remote.api.GetServerApi;
import luckyclient.remote.api.PostServerApi;
import luckyclient.remote.api.serverOperation;
import luckyclient.remote.entity.ProjectCase;
import luckyclient.remote.entity.ProjectCaseParams;
import luckyclient.remote.entity.ProjectCaseSteps;
import luckyclient.utils.Constants;
import luckyclient.utils.InvokeMethod;
import luckyclient.utils.LogUtil;
import org.apache.commons.lang.StringUtils;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 *
 * @ClassName: WebTestCaseDebug
 * @Description: ṩWeb˵Խӿ
 * @author seagull
 * @date 201831
 */
public class WebTestCaseDebug {
    /**
     * WEBҳϵʱṩĽӿ
     * @param caseIdStr ID
     * @param userIdStr  ûID
     * @param caseTypeStr ͣHTTPӿ 0,  Web UI, 1,   API, 2,   ƶ, 3
     */
    public static void oneCaseDebug(String caseIdStr, String userIdStr,String caseTypeStr) {
        //޸ĵ
        if (Integer.parseInt(caseTypeStr)==0||Integer.parseInt(caseTypeStr)==2){
        Map<String, String> variable = new HashMap<>(0);
        serverOperation.exetype=1;
        String packagename;
        String functionname;
        String expectedresults;
        int setcaseresult = 0;
        int stepJumpNo=0;
        Object[] getParameterValues;
        String testnote = "ʼԽ";
        int k = 0;
        Integer caseId = Integer.valueOf(caseIdStr);
        Integer userId = Integer.valueOf(userIdStr);
        ProjectCase testcase = GetServerApi.cGetCaseByCaseId(caseId);
        // ʼдԼ־ģ
        serverOperation caselog = new serverOperation();

        String sign = testcase.getCaseSign();
        List<ProjectCaseParams> pcplist = GetServerApi.cgetParamsByProjectid(String.valueOf(testcase.getProjectId()));
        // ѹ뵽MAP
        for (ProjectCaseParams pcp : pcplist) {
            variable.put(pcp.getParamsName(), pcp.getParamsValue());
        }
        List<ProjectCaseSteps> steps = GetServerApi.getStepsbycaseid(testcase.getCaseId());
        //ѭв
        for (int i = 0; i < steps.size(); i++) {
            //ת﷨
            if(stepJumpNo!=0&&setcaseresult!=0){
                if(stepJumpNo==i+1){
                    setcaseresult = 0;
                    PostServerApi.cPostDebugLog(userId, caseId, "INFO", "תǰ"+(i+1)+"",0);
                    LogUtil.APP.info("תǰ{}",i+1);
                }else if(stepJumpNo>i+1){
                    PostServerApi.cPostDebugLog(userId, caseId, "INFO", "ǰ"+(i+1)+",ִ...",0);
                    LogUtil.APP.info("ǰ{},ִ...",i+1);
                    continue;
                }else{
                    PostServerApi.cPostDebugLog(userId, caseId, "INFO", "ת衾"+stepJumpNo+"Сڵǰ衾"+(i+1)+"ֱ¼ִ...",0);
                    LogUtil.APP.info("ת衾{}Сڵǰ衾{}ֱ¼ִ...",stepJumpNo,(i+1));
                }
            }

            Map<String, String> casescript = InterfaceAnalyticCase.analyticCaseStep(testcase, steps.get(i), "888888", null,variable);
            try {
                packagename = casescript.get("PackageName");
                functionname = casescript.get("FunctionName");
            } catch (Exception e) {
                LogUtil.APP.error("Ƿ쳣",e);
                PostServerApi.cPostDebugLog(userId, caseId, "ERROR", "Ƿʧܣ飡",2);
                break;        //ĳһʧܺ󣬴Ϊʧ˳
            }
            //ƽ쳣ǵ쳣
            if ((null != functionname && functionname.contains("쳣")) || k == 1) {
                testnote = "" + (i + 1) + "";
                break;
            }
            expectedresults = casescript.get("ExpectedResults");
            //жϷǷ
            if (casescript.size() > 4) {
                //ȡ
                getParameterValues = new Object[casescript.size() - 4];
                for (int j = 0; j < casescript.size() - 4; j++) {
                    if (casescript.get("FunctionParams" + (j + 1)) == null) {
                        k = 1;
                        break;
                    }

                    String parameterValues = casescript.get("FunctionParams" + (j + 1));
                    PostServerApi.cPostDebugLog(userId, caseId, "INFO", "" + packagename + " " + functionname + " " + (j + 1) + "" + parameterValues, 0);
                    getParameterValues[j] = parameterValues;
                }
            } else {
                getParameterValues = null;
            }
            //öִ̬в
            try {
                PostServerApi.cPostDebugLog(userId, caseId, "INFO", "ʼ÷" + functionname + " .....",0);

                // ӿ֧ʹruncaseؼ
                if ((null != functionname && "runcase".equals(functionname))) {
                    TestCaseExecution testCaseExecution=new TestCaseExecution();
                    testnote = testCaseExecution.oneCaseExecuteForCase(getParameterValues[0].toString(), "888888", variable, caselog, null);
                }else{
                    testnote = InvokeMethod.callCase(packagename, functionname, getParameterValues, steps.get(i).getStepType(), steps.get(i).getExtend());
                }
                testnote = ActionManageForSteps.actionManage(casescript.get("Action"), testnote);

                if (null != expectedresults && !expectedresults.isEmpty()) {
                    //ת
                    if (expectedresults.length() > Constants.IFFAIL_JUMP.length() && expectedresults.startsWith(Constants.IFFAIL_JUMP)) {
                        PostServerApi.cPostDebugLog(userId, caseId, "INFO", "Ԥڽджת裬ǰԭʼַ"+expectedresults,0);
                        LogUtil.APP.info("Ԥڽджת裬ǰԭʼַ{}",expectedresults);
                        String expectedTemp = expectedresults.substring(Constants.IFFAIL_JUMP.length());
                        if(expectedTemp.contains(Constants.SYMLINK)){
                            expectedresults = expectedTemp.substring(expectedTemp.indexOf(Constants.SYMLINK)+2);
                            try{
                                stepJumpNo =  Integer.parseInt(expectedTemp.substring(0,expectedTemp.indexOf(Constants.SYMLINK)));
                            }catch (NumberFormatException nfe){
                                LogUtil.APP.error("ת﷨ʧܣŲ֣ȷ:{}",expectedTemp.substring(0,expectedTemp.indexOf(Constants.SYMLINK)));
                            }
                        }else{
                            PostServerApi.cPostDebugLog(userId, caseId, "INFO", "ԤڽжʧܣȷԤڽ﷨ṹ"+Constants.IFFAIL_JUMP+">>ԤڽԭʼԤڽֵ"+expectedresults,0);
                            LogUtil.APP.warn("ԤڽжʧܣȷԤڽ﷨ṹ"+Constants.IFFAIL_JUMP+">>ԤڽԭʼԤڽֵ{}",expectedresults);
                        }
                    }
                    // ֵ
                    if (expectedresults.length() > Constants.ASSIGNMENT_SIGN.length() && expectedresults.startsWith(Constants.ASSIGNMENT_SIGN)) {
                        variable.put(expectedresults.substring(Constants.ASSIGNMENT_SIGN.length()), testnote);
                        PostServerApi.cPostDebugLog(userId, caseId, "INFO", "Խ" + testnote + "ֵ" + expectedresults.substring(Constants.ASSIGNMENT_SIGN.length()) + "",0);
                    }
                    // ֵȫֱ
                    else if (expectedresults.length() > Constants.ASSIGNMENT_GLOBALSIGN.length() && expectedresults.startsWith(Constants.ASSIGNMENT_GLOBALSIGN)) {
                        variable.put(expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()), testnote);
                        ParamsManageForSteps.GLOBAL_VARIABLE.put(expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()), testnote);
                        LogUtil.APP.info(":{} {}Խ{}ֵȫֱ{}",testcase.getCaseSign(),(i+1),testnote,expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()));
                        PostServerApi.cPostDebugLog(userId, caseId, "INFO", "Խ" + testnote + "ֵȫֱ" + expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()) + "",0);
                    }
                    // ģƥ
                    else if (expectedresults.length() > Constants.FUZZY_MATCHING_SIGN.length() && expectedresults.startsWith(Constants.FUZZY_MATCHING_SIGN)) {
                        if (testnote.contains(expectedresults.substring(Constants.FUZZY_MATCHING_SIGN.length()))) {
                            PostServerApi.cPostDebugLog(userId, caseId, "INFO", "ģƥԤڽɹִн" + testnote,0);
                        } else {
                            setcaseresult = 1;
                            PostServerApi.cPostDebugLog(userId, caseId, "ERROR", "" + (i + 1) + "ģƥԤڽʧܣԤڽ" + expectedresults.substring(Constants.FUZZY_MATCHING_SIGN.length()) + "Խ" + testnote,0);
                            testnote = "" + (i + 1) + "ģƥԤڽʧܣ";
                            if (testcase.getFailcontinue() == 0) {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                                break;
                            } else {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                            }
                        }
                    }
                    // ƥ
                    else if (expectedresults.length() > Constants.REGULAR_MATCHING_SIGN.length() && expectedresults.startsWith(Constants.REGULAR_MATCHING_SIGN)) {
                        Pattern pattern = Pattern.compile(expectedresults.substring(Constants.REGULAR_MATCHING_SIGN.length()));
                        Matcher matcher = pattern.matcher(testnote);
                        if (matcher.find()) {
                            PostServerApi.cPostDebugLog(userId, caseId, "INFO", "ƥԤڽɹִн" + testnote,0);
                        } else {
                            setcaseresult = 1;
                            PostServerApi.cPostDebugLog(userId, caseId, "ERROR", "" + (i + 1) + "ƥԤڽʧܣԤڽ" + expectedresults.substring(Constants.REGULAR_MATCHING_SIGN.length()) + "Խ" + testnote,0);
                            testnote = "" + (i + 1) + "ƥԤڽʧܣ";
                            if (testcase.getFailcontinue() == 0) {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                                break;
                            } else {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                            }
                        }
                    }
                    //jsonpath
                    else if (expectedresults.length() > Constants.JSONPATH_SIGN.length() && expectedresults.startsWith(Constants.JSONPATH_SIGN)) {
                        expectedresults = expectedresults.substring(Constants.JSONPATH_SIGN.length());
                        String expression = expectedresults.split("(?<!\\\\)=")[0].replace("\\=","=");
                        String exceptResult = expectedresults.split("(?<!\\\\)=")[1].replace("\\=","=");
                        //ԲԽjsonPathȡֵ
                        String result = SubString.jsonPathGetParams(expression, testnote);
                        
                        if (exceptResult.equals(result)) {
                            setcaseresult = 0;
                            PostServerApi.cPostDebugLog(userId, caseId, "INFO", "jsonpathԤڽɹԤڽ" + exceptResult + " Խ: " + result + "У: true", 0);
                        } else {
                            setcaseresult = 1;
                            PostServerApi.cPostDebugLog(userId, caseId, "ERROR", "" + (i + 1) + "jsonpathԤڽʧܣԤڽ" + exceptResult + "Խ" + result,0);
                            testnote = "" + (i + 1) + "jsonpathԤڽʧܣ";
                            if (testcase.getFailcontinue() == 0) {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                                break;
                            } else {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                            }
                        }
                    }
                    // ȫ
                    else {
                        if (expectedresults.equals(testnote)) {
                            PostServerApi.cPostDebugLog(userId, caseId, "INFO", "ȷƥԤڽɹִн" + testnote,0);
                        } else if(expectedresults.trim().equals("NULL")&& StringUtils.isBlank(testnote)){
                            testnote = "ؽΪգƥNULLɹ";
                            PostServerApi.cPostDebugLog(userId, caseId, "INFO", "ȷƥԤڽɹִн" + testnote,0);
                        } else {
                            setcaseresult = 1;
                            PostServerApi.cPostDebugLog(userId, caseId, "ERROR", "" + (i + 1) + "ȷƥԤڽʧܣԤڽ" + expectedresults + "Խ" + testnote,0);
                            testnote = "" + (i + 1) + "ȷƥԤڽʧܣ";
                            if (testcase.getFailcontinue() == 0) {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                                break;
                            } else {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                            }
                        }
                    }
                }
            } catch (Exception e) {
                setcaseresult = 1;
                LogUtil.APP.error("ִг쳣",e);
                PostServerApi.cPostDebugLog(userId, caseId, "ERROR", "÷̳" + functionname + " ¼űԼ",0);
                testnote = "CallCaseó";
                if (testcase.getFailcontinue() == 0) {
                    LogUtil.APP.error("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                    break;
                } else {
                    LogUtil.APP.error("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                }
            }
        }
        variable.clear();               //մMAP
        //÷δòԽ
        if (testnote.contains("CallCaseó") && testnote.contains("")) {
            PostServerApi.cPostDebugLog(userId, caseId, "ERRORover", " " + sign + "ǵòеķ",1);
        }
        if (0 == setcaseresult) {
            PostServerApi.cPostDebugLog(userId, caseId, "INFOover", " " + sign + "ȫִɣ",1);
        } else {
            PostServerApi.cPostDebugLog(userId, caseId, "ERRORover", " " + sign + "ִйʧܣ飡",1);
        }
    }
    }

    //޸ĵ
    /**
     * WEBҳϵʱṩĽӿ
     * @param caseIdStr ID
     * @param userIdStr  ûID
     * @param browserTypeStr web0 IE 1  2 ȸ 3 Edge
     */
    public static void oneWebCaseDebug(String caseIdStr,String userIdStr,String browserTypeStr) {
        if(NumberUtil.isInteger(caseIdStr)&&NumberUtil.isInteger(browserTypeStr)){
            int caseId=Integer.parseInt(caseIdStr);
            int browserType=Integer.parseInt(browserTypeStr);
            int userId=Integer.parseInt(userIdStr);
            WebOneCaseExecute.debugoneCaseExecute(caseId,userId,browserType);
        }else{
            LogUtil.APP.error("Գ쳣IDԼͲԭcaseId{}  browserType{}",caseIdStr,browserTypeStr);
        }

    }
}