package luckyclient.execution.httpinterface;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import luckyclient.driven.SubString;
import luckyclient.execution.dispose.ActionManageForSteps;
import luckyclient.execution.dispose.ParamsManageForSteps;
import luckyclient.execution.httpinterface.analyticsteps.InterfaceAnalyticCase;
import luckyclient.remote.api.serverOperation;
import luckyclient.remote.entity.ProjectCase;
import luckyclient.remote.entity.ProjectCaseParams;
import luckyclient.remote.entity.ProjectCaseSteps;
import luckyclient.utils.Constants;
import luckyclient.utils.InvokeMethod;
import luckyclient.utils.LogUtil;
import org.apache.commons.lang.StringUtils;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 *
 * @ClassName: ThreadForExecuteCase
 * @Description: ̳߳طʽִ
 * @author seagull
 * @date 201831
 */
public class ThreadForExecuteCase extends Thread {
    private Integer caseId;
    private String caseSign;
    private ProjectCase testcase;
    private String taskid;
    private Integer planId;
    private Integer projectId;
    private List<ProjectCaseSteps> steps;
    private List<ProjectCaseParams> pcplist;
    private serverOperation caselog;

    public ThreadForExecuteCase(ProjectCase projectcase, List<ProjectCaseSteps> steps, String taskid,Integer planId, List<ProjectCaseParams> pcplist, serverOperation caselog) {
        this.caseId = projectcase.getCaseId();
        this.testcase = projectcase;
        this.projectId = projectcase.getProjectId();
        this.caseSign = projectcase.getCaseSign();
        this.taskid = taskid;
        this.planId=planId;
        this.steps = steps;
        this.pcplist = pcplist;
        this.caselog = caselog;
    }

    @Override
    public void run() {
        Map<String, String> variable = new HashMap<>(0);
        // ѹ뵽MAP
        for (ProjectCaseParams pcp : pcplist) {
            variable.put(pcp.getParamsName(), pcp.getParamsValue());
        }
        // ȫֱ
        variable.putAll(ParamsManageForSteps.GLOBAL_VARIABLE);
        String functionname;
        String packagename;
        String expectedresults;
        int setcaseresult = 0;
        Object[] getParameterValues;
        String testnote = "ʼԽ";
        int k = 0;
        int stepJumpNo=0;
        // ѭв
        // 뿪ʼִе
        caselog.insertTaskCaseExecute(taskid, projectId, planId,caseId, caseSign, testcase.getCaseName(), 3);
        for (int i = 0; i < steps.size(); i++) {
            //ת﷨
            if(stepJumpNo!=0&&setcaseresult!=0){
                if(stepJumpNo==i+1){
                    setcaseresult = 0;
                    LogUtil.APP.info("תǰ{}",i+1);
                }else if(stepJumpNo>i+1){
                    LogUtil.APP.info("ǰ{},ִ...",i+1);
                    continue;
                }else{
                    LogUtil.APP.info("ת衾{}Сڵǰ衾{}ֱ¼ִ...",stepJumpNo,i+1);
                }
            }

            // еĽű
            Map<String, String> casescript = InterfaceAnalyticCase.analyticCaseStep(testcase, steps.get(i), taskid, caselog,variable);
            try {
                packagename = casescript.get("PackageName");
                functionname = casescript.get("FunctionName");
            } catch (Exception e) {
                LogUtil.APP.error(":{} Ƿ쳣飡",testcase.getCaseSign(),e);
                caselog.insertTaskCaseLog(taskid, caseId, "Ƿʧܣ飡", "error", String.valueOf(i + 1), "");
                break; // ĳһʧܺ󣬴Ϊʧ˳
            }
            // ƽ쳣ǵ쳣
            if ((null != functionname && functionname.contains("쳣")) || k == 1) {
                testnote = "" + (i + 1) + "";
                break;
            }
            expectedresults = casescript.get("ExpectedResults");
            // жϷǷ
            if (casescript.size() > 4) {
                // ȡ
                getParameterValues = new Object[casescript.size() - 4];
                for (int j = 0; j < casescript.size() - 4; j++) {
                    if (casescript.get("FunctionParams" + (j + 1)) == null) {
                        k = 1;
                        break;
                    }
                    String parameterValues = casescript.get("FunctionParams" + (j + 1));
                    LogUtil.APP.info(":{} :{} :{} {}:{}",testcase.getCaseSign(),packagename,functionname,(j+1),parameterValues);
                    caselog.insertTaskCaseLog(taskid, caseId, "" + packagename + " " + functionname + " " + (j + 1) + "" + parameterValues, "info", String.valueOf(i + 1), "");
                    getParameterValues[j] = parameterValues;
                }
            } else {
                getParameterValues = null;
            }
            // öִ̬в
            try {
                LogUtil.APP.info(":{}ʼ÷:{} .....",testcase.getCaseSign(),functionname);
                caselog.insertTaskCaseLog(taskid, caseId, "ʼ÷" + functionname + " .....", "info", String.valueOf(i + 1), "");

                // ӿ֧ʹruncaseؼ
                if ((null != functionname && "runcase".equals(functionname))) {
                    TestCaseExecution testCaseExecution=new TestCaseExecution();
                    testnote = testCaseExecution.oneCaseExecuteForCase(getParameterValues[0].toString(), taskid, variable, caselog, null);
                }else{
                    testnote = InvokeMethod.callCase(packagename, functionname, getParameterValues, steps.get(i).getStepType(), steps.get(i).getExtend());
                }
                testnote = ActionManageForSteps.actionManage(casescript.get("Action"), testnote);

                if (null != expectedresults && !expectedresults.isEmpty()) {
                    //ת
                    if (expectedresults.length() > Constants.IFFAIL_JUMP.length() && expectedresults.startsWith(Constants.IFFAIL_JUMP)) {
                        LogUtil.APP.info("Ԥڽджת裬ǰԭʼַ{}",expectedresults);
                        String expectedTemp = expectedresults.substring(Constants.IFFAIL_JUMP.length());
                        if(expectedTemp.contains(Constants.SYMLINK)){
                            expectedresults = expectedTemp.substring(expectedTemp.indexOf(Constants.SYMLINK)+2);
                            try{
                                stepJumpNo =  Integer.parseInt(expectedTemp.substring(0,expectedTemp.indexOf(Constants.SYMLINK)));
                            }catch (NumberFormatException nfe){
                                LogUtil.APP.error("ת﷨ʧܣŲ֣ȷ:{}",expectedTemp.substring(0,expectedTemp.indexOf(Constants.SYMLINK)));
                            }
                        }else{
                            LogUtil.APP.warn("ԤڽжʧܣȷԤڽ﷨ṹ"+Constants.IFFAIL_JUMP+">>ԤڽԭʼԤڽֵ{}",expectedresults);
                        }
                    }
                    LogUtil.APP.info("expectedResults={}",expectedresults);
                    // ֵ
                    if (expectedresults.length() > Constants.ASSIGNMENT_SIGN.length() && expectedresults.startsWith(Constants.ASSIGNMENT_SIGN)) {
                        variable.put(expectedresults.substring(Constants.ASSIGNMENT_SIGN.length()), testnote);
                        LogUtil.APP.info(":{} {}Խ{}ֵ{}",testcase.getCaseSign(),(i+1),testnote,expectedresults.substring(Constants.ASSIGNMENT_SIGN.length()));
                        caselog.insertTaskCaseLog(taskid, caseId, "Խ" + testnote + "ֵ" + expectedresults.substring(Constants.ASSIGNMENT_SIGN.length()) + "", "info", String.valueOf(i + 1), "");
                    }
                    // ֵȫֱ
                    else if (expectedresults.length() > Constants.ASSIGNMENT_GLOBALSIGN.length() && expectedresults.startsWith(Constants.ASSIGNMENT_GLOBALSIGN)) {
                        variable.put(expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()), testnote);
                        ParamsManageForSteps.GLOBAL_VARIABLE.put(expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()), testnote);
                        LogUtil.APP.info(":{} {}Խ{}ֵȫֱ{}",testcase.getCaseSign(),(i+1),testnote,expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()));
                        caselog.insertTaskCaseLog(taskid, caseId, "Խ" + testnote + "ֵȫֱ" + expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()) + "", "info", String.valueOf(i + 1), "");
                    }
                    // ģƥ
                    else if (expectedresults.length() > Constants.FUZZY_MATCHING_SIGN.length() && expectedresults.startsWith(Constants.FUZZY_MATCHING_SIGN)) {
                        if (testnote.contains(expectedresults.substring(Constants.FUZZY_MATCHING_SIGN.length()))) {
                            LogUtil.APP.info(":{} {}ģƥԤڽɹִн:{}",testcase.getCaseSign(),(i+1),testnote);
                            caselog.insertTaskCaseLog(taskid, caseId, "ģƥԤڽɹִн" + testnote, "info", String.valueOf(i + 1), "");
                        } else {
                            setcaseresult = 1;
                            LogUtil.APP.warn(":{} {}ģƥԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),(i+1),expectedresults.substring(Constants.FUZZY_MATCHING_SIGN.length()),testnote);
                            caselog.insertTaskCaseLog(taskid, caseId, "" + (i + 1) + "ģƥԤڽʧܣԤڽ" + expectedresults.substring(Constants.FUZZY_MATCHING_SIGN.length()) + "Խ" + testnote, "error", String.valueOf(i + 1), "");
                            testnote = "" + (i + 1) + "ģƥԤڽʧܣ";
                            if (testcase.getFailcontinue() == 0) {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                                break;
                            } else {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                            }
                        }
                    }
                    // ƥ
                    else if (expectedresults.length() > Constants.REGULAR_MATCHING_SIGN.length() && expectedresults.startsWith(Constants.REGULAR_MATCHING_SIGN)) {
                        Pattern pattern = Pattern.compile(expectedresults.substring(Constants.REGULAR_MATCHING_SIGN.length()));
                        Matcher matcher = pattern.matcher(testnote);
                        if (matcher.find()) {
                            LogUtil.APP.info(":{} {}ƥԤڽɹִн:{}",testcase.getCaseSign(),(i+1),testnote);
                            caselog.insertTaskCaseLog(taskid, caseId, "ƥԤڽɹִн" + testnote, "info", String.valueOf(i + 1), "");
                        } else {
                            setcaseresult = 1;
                            LogUtil.APP.warn(":{} {}ƥԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),(i+1),expectedresults.substring(Constants.REGULAR_MATCHING_SIGN.length()),testnote);
                            caselog.insertTaskCaseLog(taskid, caseId, "" + (i + 1) + "ƥԤڽʧܣԤڽ" + expectedresults.substring(Constants.REGULAR_MATCHING_SIGN.length()) + "Խ" + testnote, "error", String.valueOf(i + 1), "");
                            testnote = "" + (i + 1) + "ƥԤڽʧܣ";
                            if (testcase.getFailcontinue() == 0) {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                                break;
                            } else {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                            }
                        }
                    }
                    //jsonpath
                    else if (expectedresults.length() > Constants.JSONPATH_SIGN.length() && expectedresults.startsWith(Constants.JSONPATH_SIGN)) {
                        expectedresults = expectedresults.substring(Constants.JSONPATH_SIGN.length());
                        String expression = expectedresults.split("(?<!\\\\)=")[0].replace("\\=","=");
                        String exceptResult = expectedresults.split("(?<!\\\\)=")[1].replace("\\=","=");
                        //ԲԽjsonPathȡֵ
                        String result = SubString.jsonPathGetParams(expression, testnote);
                        
                        if (exceptResult.equals(result)) {
                            setcaseresult = 0;
                            LogUtil.APP.info("{} ڡ{}jsonpathԤڽɹԤڽ:{} Խ: {} ִн:true",testcase.getCaseSign(),(i+1),exceptResult,result);
                            caselog.insertTaskCaseLog(taskid, caseId, "jsonpathԤڽɹԤڽ:"+ expectedresults + "Խ:" + result + "ִн:true","info", String.valueOf(i + 1), "");
                        } else {
                            setcaseresult = 1;
                            LogUtil.APP.warn(":{} {}jsonpathԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),(i+1),expectedresults,result);
                            caselog.insertTaskCaseLog(taskid, caseId, "" + (i + 1) + "ƥԤڽʧܣԤڽ" + exceptResult + "Խ" + result, "error", String.valueOf(i + 1), "");
                            testnote = "" + (i + 1) + "jsonpathԤڽʧܣ";
                            if (testcase.getFailcontinue() == 0) {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                                break;
                            } else {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                            }

                            // ĳһʧܺ󣬴Ϊʧ˳
                            break;
                        }
                    }
                    // ȫ
                    else {
                        if (expectedresults.equals(testnote)) {
                            LogUtil.APP.info(":{} {}ȷƥԤڽɹִн:{}",testcase.getCaseSign(),(i+1),testnote);
                            caselog.insertTaskCaseLog(taskid, caseId, "ȷƥԤڽɹִн" + testnote, "info", String.valueOf(i + 1), "");
                        } else if(expectedresults.trim().equals("NULL")&&StringUtils.isBlank(testnote)){
                            testnote = "ؽΪգƥNULLɹ";
                            LogUtil.APP.info(":{} {}ȷƥԤڽɹִн:{}",testcase.getCaseSign(),(i+1),testnote);
                            caselog.insertTaskCaseLog(taskid, caseId, "ȷƥԤڽɹִн" + testnote, "info", String.valueOf(i + 1), "");
                        } else {
                            setcaseresult = 1;
                            LogUtil.APP.warn(":{} {}ȷƥԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),(i+1),expectedresults,testnote);
                            caselog.insertTaskCaseLog(taskid, caseId, "" + (i + 1) + "ȷƥԤڽʧܣԤڽ" + expectedresults + "Խ" + testnote, "error", String.valueOf(i + 1), "");
                            testnote = "" + (i + 1) + "ȷƥԤڽʧܣ";
                            if (testcase.getFailcontinue() == 0) {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                                break;
                            } else {
                                LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                            }
                        }
                    }
                }
            } catch (Exception e) {
                LogUtil.APP.error(":{}÷̳:{} ¼űԼ",testcase.getCaseSign(),functionname,e);
                caselog.insertTaskCaseLog(taskid, caseId, "÷̳" + functionname + " ¼űԼ", "error", String.valueOf(i + 1), "");
                testnote = "CallCaseó÷̳" + functionname + " ¼űԼ";
                setcaseresult = 1;
                if (testcase.getFailcontinue() == 0) {
                    LogUtil.APP.error("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                    break;
                } else {
                    LogUtil.APP.error("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                }
            }
        }
        // ÷δòԽ
        try {
            // ɹʧܵߴ
            if (testnote.contains("CallCaseó") || testnote.contains("")) {
                // ǵ÷ȫΪ
                LogUtil.APP.warn(":{} ִнΪο־ԭ.....", testcase.getCaseSign());
                caselog.insertTaskCaseLog(taskid, caseId, "ִнΪο־ԭ.....", "error", "SETCASERESULT...", "");
                setcaseresult = 2;
            }
            caselog.updateTaskCaseExecuteStatus(taskid, planId,caseId, setcaseresult);
            if (0 == setcaseresult) {
                LogUtil.APP.info(":{}ִнɹ......",testcase.getCaseSign());
                caselog.insertTaskCaseLog(taskid, caseId, "ִȫɹ......", "info", "ending", "");
                LogUtil.APP.info("*********{}ִ,Խɹ*********",testcase.getCaseSign());
            } else if (1 == setcaseresult) {
                LogUtil.APP.warn(":{}ִнʧ......",testcase.getCaseSign());
                caselog.insertTaskCaseLog(taskid, caseId, "ִнʧ......", "error", "ending", "");
                LogUtil.APP.warn("*********{}ִ,Խʧ*********",testcase.getCaseSign());
            } else {
                LogUtil.APP.warn("" + testcase.getCaseSign() + "ִн......");
                caselog.insertTaskCaseLog(taskid, caseId, "ִн......", "error", "ending", "");
                LogUtil.APP.warn("*********{}ִ,Խ*********",testcase.getCaseSign());
            }
        } catch (Exception e) {
            LogUtil.APP.error(":{}ִн̳......",testcase.getCaseSign(),e);
            caselog.insertTaskCaseLog(taskid, caseId, "ִн̳......", "error", "ending", "");
        } finally {
            variable.clear(); // һձ洢ռ
            TestControl.THREAD_COUNT--; // ̼߳--ڼ߳Ƿȫִ
        }
    }
}
