package luckyclient.execution.httpinterface;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import com.offbytwo.jenkins.model.BuildResult;

import luckyclient.remote.api.GetServerApi;
import luckyclient.remote.api.serverOperation;
import luckyclient.remote.entity.*;
import luckyclient.tool.jenkins.BuildingInitialization;
import luckyclient.tool.mail.HtmlMail;
import luckyclient.tool.mail.MailSendInitialization;
import luckyclient.tool.shell.RestartServerInitialization;
import luckyclient.utils.LogUtil;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 seagull1985
 * =================================================================
 * 
 * @ClassName: TestControl
 * @Description: ɨָĿűýűеķ @author seagull
 * @date 2014824 9:29:40
 * 
 */
public class TestControl {
	public static String TASKID = "NULL";
	public static int THREAD_COUNT = 0;

	/**
	 * ̨ģʽȼƻִ
	 * @param planname ƻ
	 */
	public static void manualExecutionPlan(String planname) throws Exception {
		serverOperation.exetype = 1;
		int threadcount = 10;
		// ̳߳أִ߳
		ThreadPoolExecutor threadExecute = new ThreadPoolExecutor(threadcount, 20, 3, TimeUnit.SECONDS,
				new ArrayBlockingQueue<>(1000), new ThreadPoolExecutor.CallerRunsPolicy());

		List<ProjectCase> testCases = GetServerApi.getCasesbyplanname(planname);
		List<ProjectCaseParams> pcplist = new ArrayList<>();
		if (testCases.size() != 0) {
			pcplist = GetServerApi.cgetParamsByProjectid(String.valueOf(testCases.get(0).getProjectId()));
		}

		String taskid = "888888";
		// ʼдԼ־ģ
		serverOperation caselog = new serverOperation();
		for (ProjectCase testcase : testCases) {
			List<ProjectCaseSteps> steps = GetServerApi.getStepsbycaseid(testcase.getCaseId());
			if (steps.size() == 0) {
				LogUtil.APP.warn("{}ûҵ裬ֱ飡",testcase.getCaseSign());
				caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ûҵ裬", "error", "1", "");
				continue;
			}
			THREAD_COUNT++; // ̼߳++ڼ߳Ƿȫִ
			threadExecute.execute(new ThreadForExecuteCase(testcase, steps, taskid,null, pcplist, caselog));
		}
		// ̼߳ڼ߳Ƿȫִ
		int i = 0;
		while (THREAD_COUNT != 0) {
			i++;
			if (i > 600) {
				break;
			}
			Thread.sleep(6000);
		}
		LogUtil.APP.info("ףûһҷѾȫִϣȥûʧܵɣ");
		threadExecute.shutdown();
	}

	/**
	 * ƻģʽȼƻִ
	 * @param task 
	 */
	public static void taskExecutionPlan(TaskExecute task) throws Exception {
		serverOperation.exetype = 0;
		String taskid = task.getTaskId().toString();
		TestControl.TASKID = taskid;
		String restartstatus = RestartServerInitialization.restartServerRun(taskid);
		BuildResult buildResult = BuildingInitialization.buildingRun(taskid);
		TaskScheduling taskScheduling = GetServerApi.cGetTaskSchedulingByTaskId(task.getTaskId());
		String jobname = taskScheduling.getSchedulingName();
		int timeout = taskScheduling.getTaskTimeout();
		int[] tastcount;
		List<ProjectCaseParams> pcplist = GetServerApi.cgetParamsByProjectid(taskScheduling.getProjectId().toString());
		// ʼдԼ־ģ
		serverOperation caselog = new serverOperation();
		// жǷҪԶTOMCAT
		if (restartstatus.contains("Status:true")) {
			// жǷ񹹽Ƿɹ
			if (BuildResult.SUCCESS.equals(buildResult)) {
				int threadcount = taskScheduling.getExThreadCount();
				// ̳߳أִ߳
				ThreadPoolExecutor threadExecute = new ThreadPoolExecutor(threadcount, 20, 3, TimeUnit.SECONDS,
						new ArrayBlockingQueue<>(1000), new ThreadPoolExecutor.CallerRunsPolicy());

				List<ProjectPlan> plans=new ArrayList<>();

				// ƻִ
				if(taskScheduling.getPlanType()==1){
					ProjectPlan projectPlan=GetServerApi.getProjectPlanByPlanId(taskScheduling.getPlanId());
					plans.add(projectPlan);
				}
				// ۺ϶ƻִ
				else if(taskScheduling.getPlanType()==2){
					plans.addAll(GetServerApi.getPlansbysuiteId(taskScheduling.getSuiteId()));
				}
				LogUtil.APP.info("ǰ {} йС{}Լƻ...",task.getTaskName(),plans.size());

				int caseCount=0;
				int taskStatus = 2;
				for(ProjectPlan pp:plans){
					List<ProjectCase> cases = GetServerApi.getCasesbyplanId(pp.getPlanId());
					caseCount+=cases.size();
				}

				for(ProjectPlan pp:plans) {
					List<ProjectCase> cases = GetServerApi.getCasesbyplanId(pp.getPlanId());
					LogUtil.APP.info("ǰԼƻ {} йС{}...", pp.getPlanName(), cases.size());
					serverOperation.updateTaskExecuteStatusIng(taskid, caseCount);
					int casepriority = 0;
					for (int j = 0; j < cases.size(); j++) {
						ProjectCase projectcase = cases.get(j);
						List<ProjectCaseSteps> steps = GetServerApi.getStepsbycaseid(projectcase.getCaseId());
						if (steps.size() == 0) {
							caselog.insertTaskCaseExecute(taskid, taskScheduling.getProjectId(),pp.getPlanId(), projectcase.getCaseId(), projectcase.getCaseSign(), projectcase.getCaseName(), 2);
							LogUtil.APP.warn("{}ûҵ裬ֱ飡", projectcase.getCaseSign());
							caselog.insertTaskCaseLog(taskid, projectcase.getCaseId(), "ûҵ裬", "error", "1", "");
							continue;
						}
						// ̼߳,ȼȼߵִɣż
						if (casepriority < projectcase.getPriority()) {
							LogUtil.APP.info(":{} ȼ:{} ǰȼ:{}", projectcase.getCaseSign(), casepriority, projectcase.getPriority());
							int i = 0;
							while (THREAD_COUNT != 0) {
								i++;
								if (i > timeout * 60 * 5 / cases.size()) {
									LogUtil.APP.warn(":{} ȼ:{} ǰȼ:{} ȴʱѾõƽʱ{}(㹫ʽʱʱ*5/)ڼִ...", projectcase.getCaseSign(), casepriority, projectcase.getPriority(), i);
									break;
								}
								Thread.sleep(1000);
							}
						}
						casepriority = projectcase.getPriority();
						THREAD_COUNT++; // ̼߳++ڼ߳Ƿȫִ
						LogUtil.APP.info("ʼִеǰ {} ĵڡ{}...", task.getTaskName(), j + 1);
						threadExecute.execute(new ThreadForExecuteCase(projectcase, steps, taskid,pp.getPlanId(), pcplist, caselog));
					}
					// ̼߳ڼ߳Ƿȫִ
					int i = 0;
					while (THREAD_COUNT != 0) {
						i++;
						if (i > timeout * 10) {
							taskStatus = 3;
							LogUtil.APP.warn("ǰ {} ִѾõʱʱ䡾{}ӣڼִֹͣ...", task.getTaskName(), timeout);
							break;
						}
						Thread.sleep(6000);
					}
				}
				tastcount = serverOperation.updateTaskExecuteData(taskid, caseCount,taskStatus);

				String testtime = serverOperation.getTestTime(taskid);
				MailSendInitialization.sendMailInitialization(HtmlMail.htmlSubjectFormat(jobname),
						HtmlMail.htmlContentFormat(tastcount, taskid, buildResult.toString(), restartstatus, testtime, jobname),
						taskid, taskScheduling, tastcount,testtime,buildResult.toString(),restartstatus);
				threadExecute.shutdown();
				LogUtil.APP.info("ףûһҷѾȫִϣȥûʧܵɣ");
			} else {
				LogUtil.APP.warn("ĿʧܣԶԶ˳鿴־Ŀ...");
				MailSendInitialization.sendMailInitialization(jobname, "ĿʧܣԶԶ˳鿴־Ŀ...", taskid,
						taskScheduling, null,"0Сʱ00",buildResult.toString(),restartstatus);
			}
		} else {
			LogUtil.APP.warn("ĿTOMCATʧܣԶԶ˳ĿTOMCAT");
			MailSendInitialization.sendMailInitialization(jobname, "ĿTOMCATʧܣԶԶ˳ĿTOMCAT", taskid,
					taskScheduling, null,"0Сʱ00",buildResult.toString(),restartstatus);
		}
	}

}
