package luckyclient.execution.httpinterface;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.WebDriver;

import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.android.AndroidElement;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.ios.IOSElement;
import luckyclient.driven.SubString;
import luckyclient.execution.appium.AppDriverAnalyticCase;
import luckyclient.execution.appium.androidex.AndroidCaseExecution;
import luckyclient.execution.appium.iosex.IosCaseExecution;
import luckyclient.execution.dispose.ActionManageForSteps;
import luckyclient.execution.dispose.ParamsManageForSteps;
import luckyclient.execution.httpinterface.analyticsteps.InterfaceAnalyticCase;
import luckyclient.execution.webdriver.ex.WebCaseExecution;
import luckyclient.execution.webdriver.ex.WebDriverAnalyticCase;
import luckyclient.remote.api.GetServerApi;
import luckyclient.remote.api.serverOperation;
import luckyclient.remote.entity.ProjectCase;
import luckyclient.remote.entity.ProjectCaseParams;
import luckyclient.remote.entity.ProjectCaseSteps;
import luckyclient.utils.Constants;
import luckyclient.utils.InvokeMethod;
import luckyclient.utils.LogUtil;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 *
 * @author seagull
 * @date 201831
 */
public class TestCaseExecution {
    public Map<String, String> RUNCASE_VARIABLE = new HashMap<>(0);

    /**
     * ڵԣͨ־д־UTPϣUTPϵ
     */
    public void oneCaseExecuteForTask(Integer caseId, String taskid) {
        TestControl.TASKID = taskid;
        serverOperation.exetype = 0;
        // ʼдԼ־ģ
        serverOperation caselog = new serverOperation();
        String packagename;
        String functionname;
        String expectedresults;
        int setcaseresult = 0;
        Object[] getParameterValues;
        String testnote = "ʼԽ";
        int k = 0;
        int stepJumpNo=0;
        ProjectCase testcase = GetServerApi.cGetCaseByCaseId(caseId);
        //״̬
        caselog.updateTaskCaseExecuteStatus(taskid, testcase.getCaseId(), 3);
        // ɾɵ־
        serverOperation.deleteTaskCaseLog(testcase.getCaseId(), taskid);

        List<ProjectCaseParams> pcplist = GetServerApi.cgetParamsByProjectid(String.valueOf(testcase.getProjectId()));
        // ѹ뵽MAP
        for (ProjectCaseParams pcp : pcplist) {
            RUNCASE_VARIABLE.put(pcp.getParamsName(), pcp.getParamsValue());
        }
        // ȫֱ
        RUNCASE_VARIABLE.putAll(ParamsManageForSteps.GLOBAL_VARIABLE);
        List<ProjectCaseSteps> steps = GetServerApi.getStepsbycaseid(testcase.getCaseId());
        if (steps.size() == 0) {
            setcaseresult = 2;
            LogUtil.APP.warn("δҵ裬飡");
            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "δҵ裬飡", "error", "1", "");
            testnote = "δҵ裬飡";
        }
        // ѭв
        for (int i = 0; i < steps.size(); i++) {
            //ת﷨
            if(stepJumpNo!=0&&setcaseresult!=0){
                if(stepJumpNo==i+1){
                    setcaseresult = 0;
                    LogUtil.APP.info("תǰ{}",i+1);
                }else if(stepJumpNo>i+1){
                    LogUtil.APP.info("ǰ{},ִ...",i+1);
                    continue;
                }else{
                    LogUtil.APP.info("ת衾{}Сڵǰ衾{}ֱ¼ִ...",stepJumpNo,i+1);
                }
            }

            Map<String, String> casescript = InterfaceAnalyticCase.analyticCaseStep(testcase, steps.get(i), taskid, caselog,RUNCASE_VARIABLE);
            try {
                packagename = casescript.get("PackageName");
                functionname = casescript.get("FunctionName");
            } catch (Exception e) {
                LogUtil.APP.error(":{} Ƿʧܣ飡",testcase.getCaseSign(),e);
                caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "Ƿʧܣ飡", "error", String.valueOf(i + 1), "");
                break; // ĳһʧܺ󣬴Ϊʧ˳
            }
            // ƽ쳣ǵ쳣
            if ((null != functionname && functionname.contains("쳣")) || k == 1) {
                testnote = "" + (i + 1) + "";
                break;
            }
            expectedresults = casescript.get("ExpectedResults");
            // жϷǷ
            if (casescript.size() > 4) {
                // ȡУʼ
                getParameterValues = new Object[casescript.size() - 4];
                for (int j = 0; j < casescript.size() - 4; j++) {
                    if (casescript.get("FunctionParams" + (j + 1)) == null) {
                        k = 1;
                        break;
                    }

                    String parameterValues = casescript.get("FunctionParams" + (j + 1));
                    LogUtil.APP.info(":{} :{} :{} {}:{}",testcase.getCaseSign(),packagename,functionname,(j+1),parameterValues);
                    caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "" + packagename + " " + functionname + " " + (j + 1) + "" + parameterValues, "info", String.valueOf(i + 1), "");
                    getParameterValues[j] = parameterValues;
                }
            } else {
                getParameterValues = null;
            }
            // öִ̬в
            try {
                LogUtil.APP.info("ʼ÷:{} .....",functionname);
                caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ʼ÷" + functionname + " .....", "info", String.valueOf(i + 1), "");
                // ӿ֧ʹruncaseؼ
                if ((null != functionname && "runcase".equals(functionname))) {
                    TestCaseExecution testCaseExecution=new TestCaseExecution();
                    testnote = testCaseExecution.oneCaseExecuteForCase(getParameterValues[0].toString(), taskid, RUNCASE_VARIABLE, caselog, null);
                }else{
                    testnote = InvokeMethod.callCase(packagename, functionname, getParameterValues, steps.get(i).getStepType(), steps.get(i).getExtend());
                }
                testnote = ActionManageForSteps.actionManage(casescript.get("Action"), testnote);
                // жϽ
                Map<String,Integer> judgeResult = interfaceJudgeResult(testcase, steps.get(i), taskid, expectedresults, testnote, caselog);
                Integer stepresult = judgeResult.get("setResult");
                stepJumpNo = judgeResult.get("stepJumpNo");
    			// ʧܣҲڼ,ֱֹ
                if (0 != stepresult) {
                	setcaseresult = stepresult;
                    if (testcase.getFailcontinue() == 0) {
                        LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),steps.get(i).getStepSerialNumber());
                        break;
                    } else {
                        LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),steps.get(i).getStepSerialNumber());
                    }
                }

            } catch (Exception e) {
                caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "÷̳" + functionname + " ¼űԼ", "error", String.valueOf(i + 1), "");
                LogUtil.APP.error("÷̳:{} ¼űԼ",functionname, e);
                testnote = "CallCaseó";
                setcaseresult = 1;
                e.printStackTrace();
                if (testcase.getFailcontinue() == 0) {
                    LogUtil.APP.error("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                    break;
                } else {
                    LogUtil.APP.error("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                }
            }
        }

        RUNCASE_VARIABLE.clear(); // մMAP
        // ÷δòԽ
        if (!testnote.contains("CallCaseó") && !testnote.contains("")) {
            LogUtil.APP.info("{}ɹɹз鿴ִн",testcase.getCaseSign());
            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ɹɹз鿴ִн", "info", "SETCASERESULT...", "");
            caselog.updateTaskCaseExecuteStatus(taskid, testcase.getCaseId(), setcaseresult);
        } else {
            setcaseresult = 1;
            LogUtil.APP.warn("{}ǵòеķ",testcase.getCaseSign());
            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ǵòеķ", "error", "SETCASERESULT...", "");
            caselog.updateTaskCaseExecuteStatus(taskid, testcase.getCaseId(), 2);
        }
        if (0 == setcaseresult) {
            LogUtil.APP.info("{}ȫִгɹ",testcase.getCaseSign());
            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ȫִгɹ", "info", "EXECUTECASESUC...", "");
        } else {
            LogUtil.APP.warn("{}ִйʧܣ־",testcase.getCaseSign());
            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ִйʧܣ־", "error", "EXECUTECASESUC...", "");
        }
        serverOperation.updateTaskExecuteData(taskid, 0, 2);
    }

    /**
     * runcaseõʱʹ
     * @param testCaseExternalId 
     * @param taskid ID
     * @param caselog ־
     * @param driver UI
     * @return ִн
     */
    @SuppressWarnings("unchecked")
	public String oneCaseExecuteForCase(String testCaseExternalId, String taskid, Map<String, String> outVariable, serverOperation caselog, Object driver) {
        String expectedresults;
        int setresult = 1;
        int stepJumpNo=0;
        String testnote = "ʼԽ";
        ProjectCase testcase = GetServerApi.cgetCaseBysign(testCaseExternalId);
        List<ProjectCaseParams> pcplist = GetServerApi.cgetParamsByProjectid(String.valueOf(testcase.getProjectId()));
        if(null==caselog){
            // ʼдԼ־ģ
            caselog = new serverOperation();
        }
        // ѹ뵽MAP
        for (ProjectCaseParams pcp : pcplist) {
            RUNCASE_VARIABLE.put(pcp.getParamsName(), pcp.getParamsValue());
        }
        // ȫֱ
        RUNCASE_VARIABLE.putAll(ParamsManageForSteps.GLOBAL_VARIABLE);
        // еı
        RUNCASE_VARIABLE.putAll(outVariable);

        List<ProjectCaseSteps> steps = GetServerApi.getStepsbycaseid(testcase.getCaseId());
        if (steps.size() == 0) {
            setresult = 2;
            LogUtil.APP.warn("δҵ裬飡");
            caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "δҵ裬飡", "error", "1", "");
            testnote = "δҵ裬飡";
        }

        // ѭв
        for (int i = 0; i < steps.size(); i++) {
            Map<String, String> params;
            ProjectCaseSteps step = steps.get(i);
            //ת﷨
            if(stepJumpNo!=0&&setresult!=0){
                if(stepJumpNo==i+1){
                    LogUtil.APP.info("תǰ{}",i+1);
                }else if(stepJumpNo>i+1){
                    LogUtil.APP.info("ǰ{},ִ...",i+1);
                    continue;
                }else{
                    LogUtil.APP.info("ת衾{}Сڵǰ衾{}ֱ¼ִ...",stepJumpNo,i+1);
                }
            }

            // ݲ
            if (1 == step.getStepType()){
            	params = WebDriverAnalyticCase.analyticCaseStep(testcase, step, taskid, caselog,RUNCASE_VARIABLE);
            }else if (3 == step.getStepType()){
            	params = AppDriverAnalyticCase.analyticCaseStep(testcase, step, taskid,caselog,RUNCASE_VARIABLE);
            } else{
            	params = InterfaceAnalyticCase.analyticCaseStep(testcase, step, taskid, caselog,RUNCASE_VARIABLE);
            }

            // жϷǷ쳣
            if (params.get("exception") != null && params.get("exception").contains("쳣")) {
                setresult = 2;
                break;
            }

            expectedresults = params.get("ExpectedResults");
            Map<String,Integer> judgeResult=new HashMap<>();
            // ݲִв
            if (1 == step.getStepType()){
            	WebDriver wd=(WebDriver)driver;
            	testnote = WebCaseExecution.runWebStep(params, wd, taskid, testcase.getCaseId(), step.getStepSerialNumber(), caselog);
                testnote = ActionManageForSteps.actionManage(params.get("Action"), testnote);
            	// жϽ
                judgeResult = WebCaseExecution.judgeResult(testcase, step, params, wd, taskid, expectedresults, testnote, caselog);
                setresult = judgeResult.get("setResult");
                stepJumpNo = judgeResult.get("stepJumpNo");
            }else if (3 == step.getStepType()){
            	if (driver instanceof AndroidDriver){
            		AndroidDriver<AndroidElement> ad=(AndroidDriver<AndroidElement>)driver;
            		testnote = AndroidCaseExecution.androidRunStep(params, ad, taskid, testcase.getCaseId(), step.getStepSerialNumber(), caselog);
                    testnote = ActionManageForSteps.actionManage(params.get("Action"), testnote);
            		// жϽ
                    judgeResult = AndroidCaseExecution.judgeResult(testcase, step, params, ad, taskid, expectedresults, testnote, caselog);
                    setresult = judgeResult.get("setResult");
                    stepJumpNo = judgeResult.get("stepJumpNo");
            	}else{
            		IOSDriver<IOSElement> ios=(IOSDriver<IOSElement>)driver;
            		testnote = IosCaseExecution.iosRunStep(params, RUNCASE_VARIABLE, ios, taskid, testcase.getCaseId(), step.getStepSerialNumber(), caselog);
                    testnote = ActionManageForSteps.actionManage(params.get("Action"), testnote);
            		// жϽ
                    judgeResult = IosCaseExecution.judgeResult(testcase, step, params, ios, taskid, expectedresults, testnote, caselog);
                    setresult = judgeResult.get("setResult");
                    stepJumpNo = judgeResult.get("stepJumpNo");
            	}

            } else{
            	testnote = runStep(params, taskid, testcase.getCaseSign(), step, caselog);
                testnote = ActionManageForSteps.actionManage(params.get("Action"), testnote);
                // жϽ
                judgeResult = interfaceJudgeResult(testcase, step, taskid, expectedresults, testnote, caselog);
                setresult = judgeResult.get("setResult");
                stepJumpNo = judgeResult.get("stepJumpNo");
            }

            if (0 != setresult){
            	testnote = ":"+testcase.getCaseSign()+" "+step.getStepSerialNumber()+"ִйʧܡ";
            	LogUtil.APP.warn(":{} {}ִйʧܣ־{}",testcase.getCaseSign(),step.getStepSerialNumber(),testnote);
            	break;
            }
        }

        //βգŵִеķȥ
        // RUNCASE_VARIABLE.clear();
        if (0 == setresult) {
            LogUtil.APP.info(":{}ȫִгɹ",testcase.getCaseSign());
        }
        
        return testnote;
    }

    /**
     * ͲеýӿڲԲ
     * @param params 
     * @param taskid ID
     * @param casenum 
     * @param step 
     * @param caselog ־
     * @return ִн
     */
    public String runStep(Map<String, String> params, String taskid, String casenum, ProjectCaseSteps step, serverOperation caselog) {
        String result;
        String packagename;
        String functionname = "";
        Object[] getParameterValues;
        ProjectCase projectCase = GetServerApi.cgetCaseBysign(casenum);
        try {
            packagename = params.get("PackageName");
            functionname = params.get("FunctionName");

            if (null != functionname && functionname.contains("쳣")) {
                LogUtil.APP.warn(":{}, {}ʧܣ",casenum,functionname);
                caselog.insertTaskCaseLog(taskid, projectCase.getCaseId(), ": " + casenum + ", " + functionname + "ʧܣ", "error", String.valueOf(step.getStepSerialNumber()), "");
                result = "ִʧܣʧ!";
            } else {
                // жϷǷ
                if (params.size() > 4) {
                    // ȡ
                    getParameterValues = new Object[params.size() - 4];
                    for (int j = 0; j < params.size() - 4; j++) {
                        if (params.get("FunctionParams" + (j + 1)) == null) {
                            break;
                        }
                        String parameterValues = params.get("FunctionParams" + (j + 1));
                        LogUtil.APP.info(":{}, ·:{}; :{} {}:{}",casenum,packagename,functionname,(j+1),parameterValues);
                        caselog.insertTaskCaseLog(taskid, projectCase.getCaseId(), ": " + casenum + ", " + packagename + " " + functionname + " " + (j + 1) + "" + parameterValues, "info", String.valueOf(step.getStepSerialNumber()), "");
                        getParameterValues[j] = parameterValues;
                    }
                } else {
                    getParameterValues = null;
                }

                LogUtil.APP.info("νɣȴнӿڲ......");
                caselog.insertTaskCaseLog(taskid, projectCase.getCaseId(), "·: " + packagename + "; : " + functionname, "info", String.valueOf(step.getStepSerialNumber()), "");

                // ӿ֧ʹruncaseؼ
                if ((null != functionname && "runcase".equals(functionname))) {
                    TestCaseExecution testCaseExecution=new TestCaseExecution();
                    result = testCaseExecution.oneCaseExecuteForCase(getParameterValues[0].toString(), taskid, RUNCASE_VARIABLE, caselog, null);
                }else{
                    result = InvokeMethod.callCase(packagename, functionname, getParameterValues, step.getStepType(), step.getExtend());
                }
            }
        } catch (Exception e) {
            LogUtil.APP.error("÷̳:{}¼űԼ",functionname,e);
            result = "ִʧܣӿڵó";
        }
        if (result.contains("ִʧܣ")){
        	caselog.insertTaskCaseLog(taskid, projectCase.getCaseId(), result, "error", String.valueOf(step.getStepSerialNumber()), "");
        } else{
        	caselog.insertTaskCaseLog(taskid, projectCase.getCaseId(), result, "info", String.valueOf(step.getStepSerialNumber()), "");
        }
        return result;
    }

    private Map<String,Integer> interfaceJudgeResult(ProjectCase testcase, ProjectCaseSteps step, String taskid, String expectedresults, String testnote, serverOperation caselog){
        Map<String,Integer> judgeResult=new HashMap<>();
        judgeResult.put("setResult",0);
        judgeResult.put("stepJumpNo",0);
        try{
        	if (null != expectedresults && !expectedresults.isEmpty()) {
                //ת
                if (expectedresults.length() > Constants.IFFAIL_JUMP.length() && expectedresults.startsWith(Constants.IFFAIL_JUMP)) {
                    LogUtil.APP.info("Ԥڽджת裬ǰԭʼַ{}",expectedresults);
                    String expectedTemp = expectedresults.substring(Constants.IFFAIL_JUMP.length());
                    if(expectedTemp.contains(Constants.SYMLINK)){
                        expectedresults = expectedTemp.substring(expectedTemp.indexOf(Constants.SYMLINK)+2);
                        try{
                            Integer stepJumpNo =  Integer.parseInt(expectedTemp.substring(0,expectedTemp.indexOf(Constants.SYMLINK)));
                            judgeResult.put("stepJumpNo",stepJumpNo);
                        }catch (NumberFormatException nfe){
                            LogUtil.APP.error("ת﷨ʧܣŲ֣ȷ:{}",expectedTemp.substring(0,expectedTemp.indexOf(Constants.SYMLINK)));
                        }
                    }else{
                        LogUtil.APP.warn("ԤڽжʧܣȷԤڽ﷨ṹ"+Constants.IFFAIL_JUMP+">>ԤڽԭʼԤڽֵ{}",expectedresults);
                    }
                }

                LogUtil.APP.info("expectedResults={}",expectedresults);
                // ֵ
                if (expectedresults.length() > Constants.ASSIGNMENT_SIGN.length() && expectedresults.startsWith(Constants.ASSIGNMENT_SIGN)) {
                    RUNCASE_VARIABLE.put(expectedresults.substring(Constants.ASSIGNMENT_SIGN.length()), testnote);
                    LogUtil.APP.info(":{} {}Խ{}ֵ{}",testcase.getCaseSign(),step.getStepSerialNumber(),testnote,expectedresults.substring(Constants.ASSIGNMENT_SIGN.length()));
                    caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "Խ" + testnote + "ֵ" + expectedresults.substring(Constants.ASSIGNMENT_SIGN.length()) + "", "info", String.valueOf(step.getStepSerialNumber()), "");
                }
                // ֵȫֱ
                else if (expectedresults.length() > Constants.ASSIGNMENT_GLOBALSIGN.length() && expectedresults.startsWith(Constants.ASSIGNMENT_GLOBALSIGN)) {
                    RUNCASE_VARIABLE.put(expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()), testnote);
                    ParamsManageForSteps.GLOBAL_VARIABLE.put(expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()), testnote);
                    LogUtil.APP.info(":{} {}Խ{}ֵȫֱ{}",testcase.getCaseSign(),step.getStepSerialNumber(),testnote,expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()));
                    caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "Խ" + testnote + "ֵȫֱ" + expectedresults.substring(Constants.ASSIGNMENT_GLOBALSIGN.length()) + "", "info", String.valueOf(step.getStepSerialNumber()), "");
                }
                // ģƥ
                else if (expectedresults.length() > Constants.FUZZY_MATCHING_SIGN.length() && expectedresults.startsWith(Constants.FUZZY_MATCHING_SIGN)) {
                    if (testnote.contains(expectedresults.substring(Constants.FUZZY_MATCHING_SIGN.length()))) {
                        LogUtil.APP.info(":{} {}ģƥԤڽɹִн:{}",testcase.getCaseSign(),step.getStepSerialNumber(),testnote);
                        caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ģƥԤڽɹִн" + testnote, "info", String.valueOf(step.getStepSerialNumber()), "");
                    } else {
                        judgeResult.put("setResult",1);
                        LogUtil.APP.warn(":{} {}ģƥԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),step.getStepSerialNumber(),expectedresults.substring(Constants.FUZZY_MATCHING_SIGN.length()),testnote);
                        caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ģƥԤڽʧܣԤڽ" + expectedresults.substring(Constants.FUZZY_MATCHING_SIGN.length()) + "Խ" + testnote, "error", String.valueOf(step.getStepSerialNumber()), "");
                    }
                }
                // ƥ
                else if (expectedresults.length() > Constants.REGULAR_MATCHING_SIGN.length() && expectedresults.startsWith(Constants.REGULAR_MATCHING_SIGN)) {
                    Pattern pattern = Pattern.compile(expectedresults.substring(Constants.REGULAR_MATCHING_SIGN.length()));
                    Matcher matcher = pattern.matcher(testnote);
                    if (matcher.find()) {
                        LogUtil.APP.info(":{} {}ƥԤڽɹִн:{}",testcase.getCaseSign(),step.getStepSerialNumber(),testnote);
                        caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ƥԤڽɹִн" + testnote, "info", String.valueOf(step.getStepSerialNumber()), "");
                    } else {
                        judgeResult.put("setResult",1);
                        LogUtil.APP.warn(":{} {}ƥԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),step.getStepSerialNumber(),expectedresults.substring(Constants.REGULAR_MATCHING_SIGN.length()),testnote);
                        caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ƥԤڽʧܣԤڽ" + expectedresults.substring(Constants.REGULAR_MATCHING_SIGN.length()) + "Խ" + testnote, "error", String.valueOf(step.getStepSerialNumber()), "");
                    }
                }
                //jsonpath
                else if (expectedresults.length() > Constants.JSONPATH_SIGN.length() && expectedresults.startsWith(Constants.JSONPATH_SIGN)) {
                    expectedresults = expectedresults.substring(Constants.JSONPATH_SIGN.length());
                    String expression = expectedresults.split("(?<!\\\\)=")[0].replace("\\=","=");
                    String exceptResult = expectedresults.split("(?<!\\\\)=")[1].replace("\\=","=");
                    //ԲԽjsonPathȡֵ
                    String result = SubString.jsonPathGetParams(expression, testnote);
                    
                    if (exceptResult.equals(result)) {
                        judgeResult.put("setResult",0);
                        LogUtil.APP.info(":{} {}jsonpathԤڽɹԤڽ:{} Խ: {} ִн:true",testcase.getCaseSign(),step.getStepSerialNumber(),exceptResult,result);
                    } else {
                        judgeResult.put("setResult",1);
                        LogUtil.APP.warn(":{} {}jsonpathԤڽʧܣԤڽ:{}Խ:{}" + expectedresults + "Խ" + result, "error", step.getStepSerialNumber(), "");
                        // ĳһʧܺ󣬴Ϊʧ˳
                    }

                }
                // ȫ
                else {
                    if (expectedresults.equals(testnote)) {
                        LogUtil.APP.info(":{} {}ȷƥԤڽɹִн:{}",testcase.getCaseSign(),step.getStepSerialNumber(),testnote);
                        caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ȷƥԤڽɹִн" + testnote, "info", String.valueOf(step.getStepSerialNumber()), "");
                    }  else if(expectedresults.trim().equals("NULL")&& StringUtils.isBlank(testnote)){
                        testnote = "ؽΪգƥNULLɹ";
                        LogUtil.APP.info(":{} {}ȷƥԤڽɹִн:{}",testcase.getCaseSign(),step.getStepSerialNumber(),testnote);
                        caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ȷƥԤڽɹִн" + testnote, "info", String.valueOf(step.getStepSerialNumber()), "");
                    } else {
                        judgeResult.put("setResult",1);
                        LogUtil.APP.warn(":{} {}ȷƥԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),step.getStepSerialNumber(),expectedresults,testnote);
                        caselog.insertTaskCaseLog(taskid, testcase.getCaseId(), "ȷƥԤڽʧܣԤڽ" + expectedresults + "Խ" + testnote, "error", String.valueOf(step.getStepSerialNumber()), "");
                    }
                }
            }
        }catch(Exception e){
        	LogUtil.APP.error("ƥӿԤڽ쳣",e);
            judgeResult.put("setResult",2);
        	return judgeResult;
        }
        return judgeResult;
    }
}
