package luckyclient.execution.httpinterface;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import luckyclient.remote.api.GetServerApi;
import luckyclient.remote.api.serverOperation;
import luckyclient.remote.entity.ProjectCase;
import luckyclient.utils.LogUtil;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 * 
 * @author seagull
 * @date 2017121 9:29:40
 * 
 */
public class BatchTestCaseExecution {

	/**
	 * ̳߳أִ߳
	 * @param taskid ID
	 * @param batchcase ַ#
	 * @throws Exception 쳣
	 */
	
	public static void batchCaseExecuteForTast(String taskid, String batchcase) throws Exception{
		int threadcount = GetServerApi.cGetTaskSchedulingByTaskId(Integer.parseInt(taskid)).getExThreadCount();
		ThreadPoolExecutor	threadExecute	= new ThreadPoolExecutor(threadcount, 30, 3, TimeUnit.SECONDS,
				new ArrayBlockingQueue<>(1000),
	            new ThreadPoolExecutor.CallerRunsPolicy());
		//ִȫǳɹ״̬
		if(batchcase.contains("ALLFAIL")){
			//ʼдԼ־ģ 
			serverOperation caselog = new serverOperation();        
			List<Integer> caseIdList = caselog.getCaseListForUnSucByTaskId(taskid);
			for (Integer integer : caseIdList) {
				ProjectCase testcase = GetServerApi.cGetCaseByCaseId(integer);
				TestControl.THREAD_COUNT++;   //̼߳++ڼ߳Ƿȫִ
				threadExecute.execute(new ThreadForBatchCase(testcase.getCaseId(), taskid));
			}			
		}else{                                           //ִ
			String[] temp=batchcase.split("#");
			LogUtil.APP.info("ǰִйС{}...",temp.length);
			for (String s : temp) {
				TestControl.THREAD_COUNT++;   //̼߳++ڼ߳Ƿȫִ
				threadExecute.execute(new ThreadForBatchCase(Integer.valueOf(s), taskid));
			}
		}
		//̼߳ڼ߳Ƿȫִ
		int i=0;
		while(TestControl.THREAD_COUNT!=0){
			i++;
			if(i>600){
				break;
			}
			Thread.sleep(6000);
		}
		threadExecute.shutdown();
	}

}
