package luckyclient.execution.httpinterface;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import luckyclient.execution.dispose.ActionManageForSteps;
import luckyclient.execution.httpinterface.analyticsteps.InterfaceAnalyticCase;
import luckyclient.remote.api.GetServerApi;
import luckyclient.remote.api.PostServerApi;
import luckyclient.remote.api.serverOperation;
import luckyclient.remote.entity.ProjectCase;
import luckyclient.remote.entity.ProjectCaseParams;
import luckyclient.remote.entity.ProjectCaseSteps;
import luckyclient.utils.Constants;
import luckyclient.utils.InvokeMethod;
import luckyclient.utils.LogUtil;
import luckyclient.utils.httputils.HttpRequest;
import org.apache.commons.lang.StringUtils;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 seagull1985
 * =================================================================
 * 
 * @ClassName: TestCaseDebug
 * @Description: ԶڱдУűе @author seagull
 * @date 201831
 * 
 */
public class ApiTestCaseDebug {
	private static final String ASSIGNMENT_SIGN = "$=";
	private static final String FUZZY_MATCHING_SIGN = "%=";
	private static final String REGULAR_MATCHING_SIGN = "~=";

	/**
	 * ڱ
	 * @param testCaseExternalId 
	 */
	public static void oneCaseDebug(String testCaseExternalId) {
		Map<String, String> variable = new HashMap<>(0);
		// ʼдԼ־ģ
		serverOperation caselog = new serverOperation();
		serverOperation.exetype=1;
		String packagename;
		String functionname;
		String expectedresults;
		int setcaseresult = 0;
		int stepJumpNo=0;
		Object[] getParameterValues;
		String testnote = "ʼԽ";
		int k = 0;
		ProjectCase testcase = GetServerApi.cgetCaseBysign(testCaseExternalId);
		List<ProjectCaseParams> pcplist = GetServerApi.cgetParamsByProjectid(String.valueOf(testcase.getProjectId()));
		// ѹ뵽MAP
		for (ProjectCaseParams pcp : pcplist) {
			variable.put(pcp.getParamsName(), pcp.getParamsValue());
		}
		List<ProjectCaseSteps> steps = GetServerApi.getStepsbycaseid(testcase.getCaseId());
		if (steps.size() == 0) {
			setcaseresult = 2;
			LogUtil.APP.warn("δҵ裬飡");
			testnote = "δҵ裬飡";
		}
		// ѭв
		for (int i = 0; i < steps.size(); i++) {
			//ת﷨
			if(stepJumpNo!=0&&setcaseresult!=0){
				if(stepJumpNo==i+1){
					setcaseresult = 0;
					LogUtil.APP.info("תǰ{}",i+1);
				}else if(stepJumpNo>i+1){
					LogUtil.APP.info("ǰ{},ִ...",i+1);
					continue;
				}else{
					LogUtil.APP.info("ת衾{}Сڵǰ衾{}ֱ¼ִ...",stepJumpNo,i+1);
				}
			}

			Map<String, String> casescript = InterfaceAnalyticCase.analyticCaseStep(testcase, steps.get(i), "888888",
					caselog,variable);
			try {
				packagename = casescript.get("PackageName");
				functionname = casescript.get("FunctionName");
			} catch (Exception e) {
				LogUtil.APP.error(":{} Ƿʧܣ飡",testcase.getCaseSign(),e);
				break; // ĳһʧܺ󣬴Ϊʧ˳
			}
			// ƽ쳣ǵ쳣
			if (functionname.contains("쳣") || k == 1) {
				testnote = "" + (i + 1) + "";
				break;
			}
			expectedresults = casescript.get("ExpectedResults");
			// жϷǷ
			if (casescript.size() > 4) {
				// ȡУʼ
				getParameterValues = new Object[casescript.size() - 4];
				for (int j = 0; j < casescript.size() - 4; j++) {
					if (casescript.get("FunctionParams" + (j + 1)) == null) {
						k = 1;
						break;
					}
					String parameterValues = casescript.get("FunctionParams" + (j + 1));
					LogUtil.APP.info(":{} :{} :{} {}:{}",testcase.getCaseSign(),packagename,functionname,(j+1),parameterValues);
					getParameterValues[j] = parameterValues;
				}
			} else {
				getParameterValues = null;
			}
			// öִ̬в
			try {
				LogUtil.APP.info("ʼ÷:{} .....",functionname);
				// ӿ֧ʹruncaseؼ
				if ((null != functionname && "runcase".equals(functionname))) {
					TestCaseExecution testCaseExecution=new TestCaseExecution();
					testnote = testCaseExecution.oneCaseExecuteForCase(getParameterValues[0].toString(), "888888", variable, caselog, null);
				}else{
					testnote = InvokeMethod.callCase(packagename, functionname, getParameterValues,
							steps.get(i).getStepType(), steps.get(i).getExtend());
				}
				testnote = ActionManageForSteps.actionManage(casescript.get("Action"), testnote);
				if (null != expectedresults && !expectedresults.isEmpty()) {
					//ת
					if (expectedresults.length() > Constants.IFFAIL_JUMP.length() && expectedresults.startsWith(Constants.IFFAIL_JUMP)) {
						LogUtil.APP.info("Ԥڽджת裬ǰԭʼַ{}",expectedresults);
						String expectedTemp = expectedresults.substring(Constants.IFFAIL_JUMP.length());
						if(expectedTemp.contains(Constants.SYMLINK)){
							expectedresults = expectedTemp.substring(expectedTemp.indexOf(Constants.SYMLINK)+2);
							try{
								stepJumpNo =  Integer.parseInt(expectedTemp.substring(0,expectedTemp.indexOf(Constants.SYMLINK)));
							}catch (NumberFormatException nfe){
								LogUtil.APP.error("ת﷨ʧܣŲ֣ȷ:{}",expectedTemp.substring(0,expectedTemp.indexOf(Constants.SYMLINK)));
							}
						}else{
							LogUtil.APP.warn("ԤڽжʧܣȷԤڽ﷨ṹ"+Constants.IFFAIL_JUMP+">>ԤڽԭʼԤڽֵ{}",expectedresults);
						}
					}

					LogUtil.APP.info("expectedResults={}",expectedresults);
					// ֵ
					if (expectedresults.length() > ASSIGNMENT_SIGN.length()
							&& expectedresults.startsWith(ASSIGNMENT_SIGN)) {
						variable.put(expectedresults.substring(ASSIGNMENT_SIGN.length()), testnote);
						LogUtil.APP
								.info(":{} {}Խ{}ֵ{}",testcase.getCaseSign(),(i+1),testnote,expectedresults.substring(ASSIGNMENT_SIGN.length()));
					}
					// ģƥ
					else if (expectedresults.length() > FUZZY_MATCHING_SIGN.length()
							&& expectedresults.startsWith(FUZZY_MATCHING_SIGN)) {
						if (testnote.contains(expectedresults.substring(FUZZY_MATCHING_SIGN.length()))) {
							LogUtil.APP.info(
									":{} {}ģƥԤڽɹִн:{}",testcase.getCaseSign(),(i+1),testnote);
						} else {
							setcaseresult = 1;
							LogUtil.APP.warn(":{} {}ģƥԤڽʧܣԤڽ{}Խ:{}",testcase.getCaseSign(),(i+1),expectedresults.substring(FUZZY_MATCHING_SIGN.length()),testnote);
							testnote = "" + (i + 1) + "ģƥԤڽʧܣ";
			                if (testcase.getFailcontinue() == 0) {
			                    LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
			                    break;
			                } else {
			                    LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
			                }
						}
					}
					// ƥ
					else if (expectedresults.length() > REGULAR_MATCHING_SIGN.length()
							&& expectedresults.startsWith(REGULAR_MATCHING_SIGN)) {
						Pattern pattern = Pattern.compile(expectedresults.substring(REGULAR_MATCHING_SIGN.length()));
						Matcher matcher = pattern.matcher(testnote);
						if (matcher.find()) {
							LogUtil.APP.info(
									":{} {}ƥԤڽɹִн:{}",testcase.getCaseSign(),(i+1),testnote);
						} else {
							setcaseresult = 1;
							LogUtil.APP.warn(":{} {}ƥԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),(i+1),expectedresults.substring(REGULAR_MATCHING_SIGN.length()),testnote);
							testnote = "" + (i + 1) + "ƥԤڽʧܣ";
			                if (testcase.getFailcontinue() == 0) {
			                    LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
			                    break;
			                } else {
			                    LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
			                }
						}
					}
					// ȫ
					else {
						if (expectedresults.equals(testnote)) {
							LogUtil.APP.info(
									":{} {}ȷƥԤڽɹִн:{}",testcase.getCaseSign(),(i+1),testnote);
						} else if(expectedresults.trim().equals("NULL")&& StringUtils.isBlank(testnote)){
							testnote = "ؽΪգƥNULLɹ";
							LogUtil.APP.info(
									":{} {}ȷƥԤڽɹִн:{}",testcase.getCaseSign(),(i+1),testnote);
						} else {
							setcaseresult = 1;
							LogUtil.APP.warn(":{} {}ȷƥԤڽʧܣԤڽ:{}Խ:{}",testcase.getCaseSign(),(i+1),expectedresults,testnote);
							testnote = "" + (i + 1) + "ȷƥԤڽʧܣ";
			                if (testcase.getFailcontinue() == 0) {
			                    LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
			                    break;
			                } else {
			                    LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
			                }
						}
					}
				}
			} catch (Exception e) {
				setcaseresult = 1;
				LogUtil.APP.error("÷̳:{} ¼űԼ",functionname,e);
				testnote = "CallCaseó";
                if (testcase.getFailcontinue() == 0) {
                    LogUtil.APP.warn("{}ڡ{}ִʧܣжϱִУ뵽һִ......",testcase.getCaseSign(),(i+1));
                    break;
                } else {
                    LogUtil.APP.warn("{}ڡ{}ִʧܣִУ¸ִ......",testcase.getCaseSign(),(i+1));
                }
			}
		}
		variable.clear(); // մMAP
		// ÷δòԽ
		if (!testnote.contains("CallCaseó") && !testnote.contains("")) {
			LogUtil.APP.info("{}ɹɹз鿴ִн",testCaseExternalId);
		} else {
			LogUtil.APP.warn("{}ǵòеķ",testCaseExternalId);
		}
		if (0 == setcaseresult) {
			LogUtil.APP.info("{}ȫִгɹ",testCaseExternalId);
		} else {
			LogUtil.APP.warn("{}ִйʧܣ־",testCaseExternalId);
		}
	}

	/**
	 * ڱе
	 * @param projectname Ŀ
	 * @param addtestcase 
	 */
	public static void moreCaseDebug(String projectname, List<String> addtestcase) {
		System.out.println("ǰܹ"+addtestcase.size());
		for(String testCaseExternalId:addtestcase) {
			try {
				LogUtil.APP
						.info("ʼ÷Ŀ:{}:{}",projectname,testCaseExternalId);
				oneCaseDebug(testCaseExternalId);
			} catch (Exception e) {
				LogUtil.APP.error("Debug쳣",e);
			}
		}
	}

	/**
	 * ϵͳָԤڽ
	 */
	public static String setExpectedResults(String testCaseSign, int steps, String expectedResults) {
		String results;
		String params;
		try {
			expectedResults = expectedResults.replace("%", "BBFFHH");
			expectedResults = expectedResults.replace("=", "DHDHDH");
			expectedResults = expectedResults.replace("&", "ANDAND");
			params = "caseno=" + testCaseSign;
			params += "&stepnum=" + steps;
			params += "&expectedresults=" + expectedResults;
			results = HttpRequest.sendPost("/projectCasesteps/cUpdateStepExpectedResults.do", params);
		} catch (Exception e) {
			LogUtil.APP.error("ϵͳָԤڽ쳣",e);
			return "ϵͳָԤڽ쳣";
		}
		return results;

	}

}
