package luckyclient.execution.appium.iosex;

import java.time.Duration;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import org.openqa.selenium.Alert;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.support.ui.Select;

import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.ios.IOSElement;
import io.appium.java_client.ios.IOSTouchAction;
import io.appium.java_client.touch.LongPressOptions;
import io.appium.java_client.touch.WaitOptions;
import io.appium.java_client.touch.offset.ElementOption;
import io.appium.java_client.touch.offset.PointOption;
import luckyclient.execution.dispose.ChangString;
import luckyclient.utils.LogUtil;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 seagull1985
 * =================================================================
 * 
 * @author Seagull
 * @date 201822
 * 
 */
public class IosEncapsulateOperation {
	public static String selectOperation(IOSElement ie, String operation, String operationValue) {
		String result = "";
		// 
		Select select = new Select(ie);

		// ¼
		switch (operation) {
		case "selectbyvisibletext":
			select.selectByVisibleText(operationValue);
			LogUtil.APP
					.info("ͨVisibleTextѡ...VisibleTextֵ:{}",operationValue);
			break;
		case "selectbyvalue":
			select.selectByValue(operationValue);
			LogUtil.APP.info("ͨValueѡ...Valueֵ:{}",operationValue);
			break;
		case "selectbyindex":
			select.selectByIndex(Integer.parseInt(operationValue));
			LogUtil.APP.info("ͨIndexѡ...Indexֵ:{}",operationValue);
			break;
		case "isselect":
			result = "ȡֵǡ" + ie.isSelected() + "";
			LogUtil.APP.info("ж϶ǷѾѡ...ֵ:{}",ie.isSelected());
			break;
		default:
			break;
		}
		return result;
	}

	public static String getOperation(IOSElement ie, String operation, String value) {
		String result = "";
		// ȡ
		switch (operation) {
		case "gettext":
			result = "ȡֵǡ" + ie.getText() + "";
			LogUtil.APP.info("getTextȡtext...textֵ:{}",result);
			break; // ȡ
		case "gettagname":
			result = "ȡֵǡ" + ie.getTagName() + "";
			LogUtil.APP.info("getTagNameȡtagname...tagnameֵ:{}",result);
			break;
		case "getattribute":
			result = "ȡֵǡ" + ie.getAttribute(value) + "";
			LogUtil.APP
					.info("getAttributeȡ{}...{}ֵ:{}",value,value,result);
			break;
		case "getcssvalue":
			result = "ȡֵǡ" + ie.getCssValue(value) + "";
			LogUtil.APP
					.info("getCssValueȡ{}...{}ֵ:{}",value,value,result);
			break;
		default:
			break;
		}
		return result;
	}

	public static String objectOperation(IOSDriver<IOSElement> appium, IOSElement ie, String operation,
			String operationValue, String property, String propertyValue) {
		String result = "";
		IOSTouchAction action = new IOSTouchAction(appium);
		// WebElement
		switch (operation) {
		case "click":
			ie.click();
			result = "click...λ:" + property + "; λֵ:" + propertyValue + "";
			LogUtil.APP
					.info("click...λ:{}; λֵ:{}",property,propertyValue);
			break;
		case "sendkeys":
			ie.sendKeys(operationValue);
			result = "sendKeys...λ:" + property + "; λֵ:" + propertyValue + "; ֵ:" + operationValue
					+ "";
			LogUtil.APP.info("sendkeys...λ:{}; λֵ:{}; ֵ:{}",property,propertyValue,operationValue);
			break;
		case "clear":
			ie.clear();
			result = "clear...λ:" + property + "; λֵ:" + propertyValue + "";
			LogUtil.APP
					.info("clear...λ:{}; λֵ:{}",property,propertyValue);
			break; // 
		case "isenabled":
			result = "ȡֵǡ" + ie.isEnabled() + "";
			LogUtil.APP.info("ǰжǷòֵΪ{}",ie.isEnabled());
			break;
		case "isdisplayed":
			result = "ȡֵǡ" + ie.isDisplayed() + "";
			LogUtil.APP.info("ǰжǷɼֵΪ{}",ie.isDisplayed());
			break;
		case "exjsob":
			((JavascriptExecutor) appium).executeScript(operationValue, ie);
			result = "ִJS..." + operationValue + "";
			LogUtil.APP.info("ִJS...{}",operationValue);
			break;
		case "longpresselement":
			LongPressOptions lpoptions = new LongPressOptions();
			lpoptions.withElement(ElementOption.element(ie));
			if (null != operationValue && ChangString.isNumeric(operationValue)) {
				int nanos = Integer.parseInt(operationValue) * 1000;
				Duration duration = Duration.ofNanos(nanos);
				lpoptions.withDuration(duration);
			}
			action.longPress(lpoptions).release().perform();
			result = "longpresselementĻָԪϰס" + operationValue + "...λ:" + property + "; λֵ:"
					+ propertyValue + "";
			LogUtil.APP.info("longpresselementĻָԪϰס{}...λ:{}; λֵ:{}",operationValue,property,propertyValue);
			break;
		default:
			break;
		}
		return result;
	}

	public static String alertOperation(IOSDriver<IOSElement> appium, String operation) {
		String result = "";
		Alert alert = appium.switchTo().alert();
		switch (operation) {
		case "alertaccept":
			alert.accept();
			LogUtil.APP.info("ͬ...");
			break;
		case "alertdismiss":
			alert.dismiss();
			LogUtil.APP.info("ȡ...");
			break;
		case "alertgettext":
			result = "ȡֵǡ" + alert.getText() + "";
			LogUtil.APP.info("ͨgetTextȡtext...Textֵ:{}",alert.getText());
			break;
		default:
			break;
		}
		return result;
	}

	public static String driverOperation(IOSDriver<IOSElement> appium, String operation, String operationValue) {
		String result = "";
		IOSTouchAction action = new IOSTouchAction(appium);
		// ҳ
		switch (operation) {
		case "getcontexthandles":
			Set<String> handles = appium.getContextHandles();
			int handlenum = 1;
			for (String handle : handles) {
				if (String.valueOf(handlenum).equals(operationValue)) {
					if (appium.getContext().equals(handle)) {
						result = "ע⣬ָContextHandleǵǰҳŶȡֵǡ" + handle + "";
					} else {
						result = "ָContextHandler˳ֵ" + operationValue + ",ȡֵǡ" + handle + "";
					}
					break;
				}
				handlenum++;
			}
			LogUtil.APP.info("getContextȡھ...{}",result);
			break;
		case "exjs":
			((JavascriptExecutor) appium).executeScript(operationValue);
			result = "ִJS..." + operationValue + "";
			LogUtil.APP.info("ִJS...{}",operationValue);
			break;
		// ֻ
		case "hideKeyboard":
			appium.hideKeyboard();
			result = "ֻ...hideKeyboard";
			LogUtil.APP.info("ֻ...hideKeyboard");
			break;
		case "gotocontext":
			Set<String> ctNames = appium.getContextHandles();
			int flag = 0;
			for (String contextName : ctNames) {
				if (contextName.contains(operationValue)) {
					flag = 1;
					appium.context(contextName);
					break;
				}
			}
			if (flag == 1) {
				result = "лcontext" + operationValue + "";
				LogUtil.APP.info("лcontext{}",operationValue);
			} else {
				result = "лcontextʧܣδҵcontextNameֵΪ" + operationValue + "Ķ";
				LogUtil.APP.info("лcontextʧܣδҵcontextNameֵΪ{}Ķ",operationValue);
			}
			break;
		case "getcontext":
			result = "ȡֵǡ" + appium.getContext() + "";
			LogUtil.APP.info("ȡҳContext...{}",appium.getContext());
			break;
		case "gettitle":
			result = "ȡֵǡ" + appium.getTitle() + "";
			LogUtil.APP.info("ȡҳgettitle...{}",appium.getTitle());
			break;
		case "swipeup":
			String[] tempup = operationValue.split("\\|", -1);
			if (null != tempup[0] && ChangString.isNumeric(tempup[0])) {
				Double second = Double.valueOf(tempup[0]);
				if (null != tempup[1] && ChangString.isNumeric(tempup[1])) {
					int num = Integer.parseInt(tempup[1]);
					IosBaseAppium.swipePageDown(appium, second, num);
					result = "swipeupָϻ...|" + second + "|" + num + "";
					LogUtil.APP.info("swipeupָϻ...|{}|{}",second,num);
				} else {
					result = "swipeupָϻжϴ쳣" + tempup[1] + "";
					LogUtil.APP.info("swipeupָϻжϴ쳣{}",tempup[1]);
				}
			} else {
				result = "swipeupָϻжʱ쳣" + tempup[0] + "";
				LogUtil.APP.info("swipeupָϻжʱ쳣{}",tempup[0]);
			}
			break;
		case "swipedown":
			String[] tempdown = operationValue.split("\\|", -1);
			if (null != tempdown[0] && ChangString.isNumeric(tempdown[0])) {
				Double second = Double.valueOf(tempdown[0]);
				if (null != tempdown[1] && ChangString.isNumeric(tempdown[1])) {
					int num = Integer.parseInt(tempdown[1]);
					IosBaseAppium.swipePageUp(appium, second, num);
					result = "swipedownָ»...|" + second + "|" + num + "";
					LogUtil.APP.info("swipedownָ»...|{}|{}",second,num);
				} else {
					result = "swipedownָ»жϴ쳣" + tempdown[1] + "";
					LogUtil.APP.info("swipedownָ»жϴ쳣{}",tempdown[1]);
				}
			} else {
				result = "swipedownָ»жʱ쳣" + tempdown[0] + "";
				LogUtil.APP.info("swipedownָ»жʱ쳣{}",tempdown[0]);
			}
			break;
		case "swipeleft":
			String[] templeft = operationValue.split("\\|", -1);
			if (null != templeft[0] && ChangString.isNumeric(templeft[0])) {
				Double second = Double.valueOf(templeft[0]);
				if (null != templeft[1] && ChangString.isNumeric(templeft[1])) {
					int num = Integer.parseInt(templeft[1]);
					IosBaseAppium.swipePageRight(appium, second, num);
					result = "swipleftָ󻬶...|" + second + "|" + num + "";
					LogUtil.APP.info("swipleftָ󻬶...|{}|{}",second,num);
				} else {
					result = "swipleftָ󻬶жϴ쳣" + templeft[1] + "";
					LogUtil.APP.info("swipleftָ󻬶жϴ쳣{}",templeft[1]);
				}
			} else {
				result = "swipleftָ󻬶жʱ쳣" + templeft[0] + "";
				LogUtil.APP.info("swipleftָ󻬶жʱ쳣{}",templeft[0]);
			}
			break;
		case "swiperight":
			String[] tempright = operationValue.split("\\|", -1);
			if (null != tempright[0] && ChangString.isNumeric(tempright[0])) {
				Double second = Double.valueOf(tempright[0]);
				if (null != tempright[1] && ChangString.isNumeric(tempright[1])) {
					int num = Integer.parseInt(tempright[1]);
					IosBaseAppium.swipePageLeft(appium, second, num);
					result = "swiprightָһ...|" + second + "|" + num + "";
					LogUtil.APP.info("swiprightָһ...|{}|{}",second,num);
				} else {
					result = "swiprightָһжϴ쳣" + tempright[1] + "";
					LogUtil.APP.info("swiprightָһжϴ쳣{}",tempright[1]);
				}
			} else {
				result = "swiprightָһжʱ쳣" + tempright[0] + "";
				LogUtil.APP.info("swiprightָһжʱ쳣{}",tempright[0]);
			}
			break;
		case "swipepageup":
			String[] tempPageUp = operationValue.split("\\|", -1);
			if (null != tempPageUp[0] && ChangString.isNumeric(tempPageUp[0])) {
				Double second = Double.valueOf(tempPageUp[0]);
				if (null != tempPageUp[1] && ChangString.isNumeric(tempPageUp[1])) {
					int num = Integer.parseInt(tempPageUp[1]);
					IosBaseAppium.swipePageUp(appium, second, num);
					result = "swipeupҳϻ...|" + second + "|" + num + "";
					LogUtil.APP.info("swipeupҳϻ...|{}|{}",second,num);
				} else {
					result = "swipeupҳϻжϴ쳣" + tempPageUp[1] + "";
					LogUtil.APP.info("swipeupҳϻжϴ쳣{}",tempPageUp[1]);
				}
			} else {
				result = "swipeupҳϻжʱ쳣" + tempPageUp[0] + "";
				LogUtil.APP.info("swipeupҳϻжʱ쳣{}",tempPageUp[0]);
			}
			break;
		case "swipepagedown":
			String[] tempPageDown = operationValue.split("\\|", -1);
			if (null != tempPageDown[0] && ChangString.isNumeric(tempPageDown[0])) {
				Double second = Double.valueOf(tempPageDown[0]);
				if (null != tempPageDown[1] && ChangString.isNumeric(tempPageDown[1])) {
					int num = Integer.parseInt(tempPageDown[1]);
					IosBaseAppium.swipePageDown(appium, second, num);
					result = "swipedownҳ»...|" + second + "|" + num + "";
					LogUtil.APP.info("swipedownҳ»...|{}|{}",second,num);
				} else {
					result = "swipedownҳ»жϴ쳣" + tempPageDown[1] + "";
					LogUtil.APP.info("swipedownҳ»жϴ쳣{}",tempPageDown[1]);
				}
			} else {
				result = "swipedownҳ»жʱ쳣" + tempPageDown[0] + "";
				LogUtil.APP.info("swipedownҳ»жʱ쳣{}",tempPageDown[0]);
			}
			break;
		case "swipepageleft":
			String[] tempPageLeft = operationValue.split("\\|", -1);
			if (null != tempPageLeft[0] && ChangString.isNumeric(tempPageLeft[0])) {
				Double second = Double.valueOf(tempPageLeft[0]);
				if (null != tempPageLeft[1] && ChangString.isNumeric(tempPageLeft[1])) {
					int num = Integer.parseInt(tempPageLeft[1]);
					IosBaseAppium.swipePageLeft(appium, second, num);
					result = "swipleftҳ󻬶...|" + second + "|" + num + "";
					LogUtil.APP.info("swipleftҳ󻬶...|{}|{}",second,num);
				} else {
					result = "swipleftҳ󻬶жϴ쳣" + tempPageLeft[1] + "";
					LogUtil.APP.info("swipleftҳ󻬶жϴ쳣{}",tempPageLeft[1]);
				}
			} else {
				result = "swipleftҳ󻬶жʱ쳣" + tempPageLeft[0] + "";
				LogUtil.APP.info("swipleftҳ󻬶жʱ쳣{}",tempPageLeft[0]);
			}
			break;
		case "swipepageright":
			String[] tempPageRight = operationValue.split("\\|", -1);
			if (null != tempPageRight[0] && ChangString.isNumeric(tempPageRight[0])) {
				Double second = Double.valueOf(tempPageRight[0]);
				if (null != tempPageRight[1] && ChangString.isNumeric(tempPageRight[1])) {
					int num = Integer.parseInt(tempPageRight[1]);
					IosBaseAppium.swipePageRight(appium, second, num);
					result = "swiprightҳһ...|" + second + "|" + num + "";
					LogUtil.APP.info("swiprightҳһ...|{}|{}",second,num);
				} else {
					result = "swiprightҳһжϴ쳣" + tempPageRight[1] + "";
					LogUtil.APP.info("swiprightҳһжϴ쳣{}",tempPageRight[1]);
				}
			} else {
				result = "swiprightҳһжʱ쳣" + tempPageRight[0] + "";
				LogUtil.APP.info("swiprightҳһжʱ쳣{}",tempPageRight[0]);
			}
			break;
		case "longpressxy":
			String[] longpressxy = operationValue.split("\\|", -1);
			if (null != longpressxy[0] && ChangString.isNumeric(longpressxy[0])) {
				int longpressx = Integer.parseInt(longpressxy[0]);
				if (null != longpressxy[1] && ChangString.isNumeric(longpressxy[1])) {
					int longpressy = Integer.parseInt(longpressxy[1]);
					if (null != longpressxy[2] && ChangString.isNumeric(longpressxy[2])) {
						LongPressOptions lpoptions = new LongPressOptions();
						lpoptions.withPosition(PointOption.point(longpressx, longpressy));
						int nanos = Integer.parseInt(longpressxy[2]) * 1000;
						Duration duration = Duration.ofNanos(nanos);
						lpoptions.withDuration(duration);
						action.longPress(lpoptions).release().perform();
						result = "longpressxyĻָXYϰס" + longpressxy[2] + "...X|Y" + longpressx + "|" + longpressy
								+ "";
						LogUtil.APP.info("longpressxyĻָXYϰס{}...X|Y{}|{}",longpressxy[2],longpressx,longpressy);
					} else {
						action.longPress(PointOption.point(longpressx, longpressy)).release().perform();
						result = "longpressxyĻָXYϳ...X|Y" + longpressx + "|" + longpressy + "";
						LogUtil.APP.info("longpressxyĻָXYϳ...X|Y{}|{}",longpressx,longpressy);
					}
				} else {
					result = "longpressxyָY괦쳣" + longpressxy[1] + "";
					LogUtil.APP.info("longpressxyָY괦쳣{}",longpressxy[1]);
				}
			} else {
				result = "longpressxyָX괦쳣" + longpressxy[0] + "";
				LogUtil.APP.info("longpressxyָX괦쳣{}",longpressxy[0]);
			}
			break;
		case "pressxy":
			String[] pressxy = operationValue.split("\\|", -1);
			if (null != pressxy[0] && ChangString.isNumeric(pressxy[0])) {
				int pressx = Integer.parseInt(pressxy[0]);
				if (null != pressxy[1] && ChangString.isNumeric(pressxy[1])) {
					int pressy = Integer.parseInt(pressxy[1]);
					action.press(PointOption.point(pressx, pressy)).release().perform();
					result = "pressxyĻָXYϵ...X|Y" + pressx + "|" + pressy + "";
					LogUtil.APP.info("pressxyĻָXYϵ...X|Y{}|{}",pressx,pressy);
				} else {
					result = "pressxyָY괦쳣" + pressxy[1] + "";
					LogUtil.APP.info("pressxyָY괦쳣{}",pressxy[1]);
				}
			} else {
				result = "pressxyָX괦쳣" + pressxy[0] + "";
				LogUtil.APP.info("pressxyָX괦쳣{}",pressxy[0]);
			}
			break;
		case "tapxy":
			String[] tapxy = operationValue.split("\\|", -1);
			if (null != tapxy[0] && ChangString.isNumeric(tapxy[0])) {
				int tapx = Integer.parseInt(tapxy[0]);
				if (null != tapxy[1] && ChangString.isNumeric(tapxy[1])) {
					int tapy = Integer.parseInt(tapxy[1]);
					action.tap(PointOption.point(tapx, tapy)).release().perform();
					result = "tapxyĻָXY...X|Y" + tapx + "|" + tapy + "";
					LogUtil.APP.info("tapxyĻָXY...X|Y{}|{}",tapx,tapy);
				} else {
					result = "tapxyָY괦쳣" + tapxy[1] + "";
					LogUtil.APP.info("tapxyָY괦쳣{}",tapxy[1]);
				}
			} else {
				result = "tapxyָX괦쳣" + tapxy[0] + "";
				LogUtil.APP.info("tapxyָX괦쳣{}",tapxy[0]);
			}
			break;
		case "jspressxy":
			String[] jspressxy = operationValue.split("\\|", -1);
			if (null != jspressxy[0] && ChangString.isNumeric(jspressxy[0])) {
				int jspressx = Integer.parseInt(jspressxy[0]);
				if (null != jspressxy[1] && ChangString.isNumeric(jspressxy[1])) {
					int jspressy = Integer.parseInt(jspressxy[1]);
					if (null != jspressxy[2] && ChangString.isNumeric(jspressxy[2])) {
						IosBaseAppium.clickScreenForJs(appium, jspressx, jspressy, Integer.parseInt(jspressxy[2]));
						result = "jspressxyĻָXYϰ" + jspressxy[2] + "...X|Y" + jspressx + "|" + jspressy + "";
						LogUtil.APP.info("jspressxyĻָXYϰ{}...X|Y{}|{}",jspressxy[2],jspressx,jspressy);
					} else {
						IosBaseAppium.clickScreenForJs(appium, jspressx, jspressy, 2);
						result = "jspressxyĻָXYϰ2(ʱж쳣ʹĬ2ʱ)...X|Y" + jspressx + "|" + jspressy + "";
						LogUtil.APP.info("jspressxyĻָXYϰ2(ʱж쳣ʹĬ2ʱ)...X|Y{}|{}",jspressx,jspressy);
					}
				} else {
					result = "jspressxyָY괦쳣" + jspressxy[1] + "";
					LogUtil.APP.info("jspressxyָY괦쳣{}",jspressxy[1]);
				}
			} else {
				result = "jspressxyָX괦쳣" + jspressxy[0] + "";
				LogUtil.APP.info("jspressxyָX괦쳣{}",jspressxy[0]);
			}
			break;
		case "moveto":
			String[] movexy = operationValue.split("\\|", -1);
			if (null != movexy[0] && !"".equals(movexy[0])) {
				String[] startxy = movexy[0].split(",", -1);
				int startx = Integer.parseInt(startxy[0]);
				int starty = Integer.parseInt(startxy[1]);
				for (int movexyi = 1; movexyi < movexy.length; movexyi++) {
					if (null != movexy[movexyi] && !"".equals(movexy[movexyi])) {
						String[] endxy = movexy[movexyi].split(",", -1);
						int endx = Integer.parseInt(endxy[0]);
						int endy = Integer.parseInt(endxy[1]);
						// ȷǷAPIbug,ֻһMOVEʱXY꣬һMOVEʱƫ
						if (movexy.length < 3) {
							action.press(PointOption.point(startx, starty))
									.waitAction(WaitOptions.waitOptions(Duration.ofNanos(1500)))
									.moveTo(PointOption.point(endx, endy));
							LogUtil.APP.info("ӿʼ꡾{},{}϶꡾{},{}",startxy[0],startxy[1],endxy[0],endxy[1]);
						} else {
							if (movexyi == 1) {
								action.press(PointOption.point(startx, starty))
										.waitAction(WaitOptions.waitOptions(Duration.ofNanos(1500)))
										.moveTo(PointOption.point(endx - startx, endy - starty));
								LogUtil.APP.info("ӿʼ꡾{},{}϶꡾{},{}",startxy[0],startxy[1],endxy[0],endxy[1]);
							} else {
								action.waitAction(WaitOptions.waitOptions(Duration.ofNanos(1500)))
										.moveTo(PointOption.point(endx - startx, endy - starty));
								LogUtil.APP
										.info("{}϶꡾{},{}",movexyi,endxy[0],endxy[1]);
							}
							startx = endx;
							starty = endy;
						}
					} else {
						LogUtil.APP.warn("жϽλó쳣{}",movexy[movexyi]);
					}
				}
				action.release().perform();
				result = "movetoȫ϶ͷŲɷ...ʼλá" + startxy[0] + "," + startxy[1] + "";
				LogUtil.APP.info("movetoȫ϶ͷŲɷ...ʼλá{},{}",startxy[0],startxy[1]);
			} else {
				result = "movetoָʼ괦쳣" + movexy[0] + ",飡";
				LogUtil.APP.info("movetoָʼ괦쳣{},飡",movexy[0]);
			}
			break;
		case "timeout":
			if (null != operationValue && ChangString.isNumeric(operationValue)) {
				// ҳʱ30
				appium.manage().timeouts().pageLoadTimeout(Integer.parseInt(operationValue), TimeUnit.SECONDS);
				// Ԫسʱ30
				appium.manage().timeouts().implicitlyWait(Integer.parseInt(operationValue), TimeUnit.SECONDS);
				result = "ȫҳ&Ԫسȴʱ䡾" + operationValue + "...";
				LogUtil.APP.info("ȫҳ&Ԫسȴʱ䡾{}...",operationValue);
			} else {
				result = "ȴʱת";
				LogUtil.APP.info(result + "ԭΪжĵȴʱ䲻...");
			}
			break;
		case "screenshot":
			java.text.DateFormat timeformat = new java.text.SimpleDateFormat("MMdd-HHmmss");
			String imagname = "FunctionScreenShot_" + timeformat.format(new Date());
			IosBaseAppium.screenShot(appium, imagname);
			result = "ͼơ" + imagname + "...";
			LogUtil.APP.info("ʹ÷ȡǰĻ...{}",result);
			break;
		default:
			break;
		}
		return result;
	}

}
