package luckyclient.execution.appium;

import java.io.File;
import java.util.Properties;

import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.service.local.flags.GeneralServerFlag;
import luckyclient.utils.LogUtil;
import luckyclient.utils.config.AppiumConfig;

/**
 * 
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 Seagull
 * =================================================================
 * @author Seagull
 * @date 201988
 */
public class AppiumService extends Thread{
	
	@Override
	public void run(){
		try{
			Properties properties = AppiumConfig.getConfiguration();
			File mainjsFile = new File(properties.getProperty("mainjsPath"));
			String ip=properties.getProperty("appiumsever");
			AppiumServiceBuilder builder =
	                new AppiumServiceBuilder().withArgument(GeneralServerFlag.SESSION_OVERRIDE)
	                        .withIPAddress(ip.split(":")[0].trim())
	                        .withAppiumJS(mainjsFile)
	                        .usingPort(Integer.parseInt(ip.split(":")[1].trim()));

			AppiumDriverLocalService service = AppiumDriverLocalService.buildService(builder);
	        service.start();
	        
	        if (!service.isRunning()){
	        	LogUtil.APP.warn("ԶAppiumʧܣ飡");
	        }else{
	        	LogUtil.APP.info("ԶAppiumɹIP:{} ˿:{}",ip.split(":")[0].trim(),ip.split(":")[1].trim());
	        }
		}catch(Exception e){
			LogUtil.APP.error("ԶAppium׳쳣飡",e);
		}
	}

}
