package luckyclient.execution.appium;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

import org.openqa.selenium.remote.DesiredCapabilities;

import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.android.AndroidElement;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.ios.IOSElement;

/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 seagull1985
 * =================================================================
 * 
 * @author seagull
 * 
 * @date 2017121 9:29:40
 * 
 */
public class AppiumInitialization {
	/**
	 * ʼAndroidAppium
	 * @param properties ļ
	 * @return ذ׿appium
	 * @throws IOException 쳣
	 */
	public static AndroidDriver<AndroidElement> setAndroidAppium(Properties properties) throws IOException {
		AndroidDriver<AndroidElement> appium;
		DesiredCapabilities capabilities = new DesiredCapabilities();
//		File directory = new File("");
//		File app = new File(directory.getCanonicalPath() + File.separator + properties.getProperty("appname"));
//		capabilities.setCapability("app", app.getAbsolutePath());
		// ԶԷ
		capabilities.setCapability("automationName", properties.getProperty("automationName"));
		// 豸
		capabilities.setCapability("deviceName", properties.getProperty("deviceName"));
		// ƽ̨
		capabilities.setCapability("platformName", properties.getProperty("platformName"));
		// ϵͳ汾
		capabilities.setCapability("platformVersion", properties.getProperty("platformVersion"));
		// ģϵipַ
		capabilities.setCapability("udid", properties.getProperty("udid"));
		// AndroidӦõİ
		capabilities.setCapability("appPackage", properties.getProperty("appPackage"));
		// Android Activity
		capabilities.setCapability("appActivity", properties.getProperty("appActivity"));
		// ֧룬ԶװUnicode
		capabilities.setCapability("unicodeKeyboard", Boolean.valueOf(properties.getProperty("unicodeKeyboard")));
		// 뷨ԭ״̬
		capabilities.setCapability("resetKeyboard", Boolean.valueOf(properties.getProperty("resetKeyboard")));
		// ǩapk
		capabilities.setCapability("noSign", Boolean.valueOf(properties.getProperty("noSign")));
		// Ƿ°װAPP
		capabilities.setCapability("noReset", Boolean.valueOf(properties.getProperty("noReset")));
		// ȴʱûյرappium
		capabilities.setCapability("newCommandTimeout", properties.getProperty("newCommandTimeout"));
		String url="http://" + properties.getProperty("appiumsever") + "/wd/hub";
		appium = new AndroidDriver<>(new URL(url), capabilities);
		int waittime = Integer.parseInt(properties.getProperty("implicitlyWait"));
		appium.manage().timeouts().implicitlyWait(waittime, TimeUnit.SECONDS);
		return appium;
	}

	/**
	 * ʼIOSAppium
	 * @param properties ļ
	 * @return IOS appium
	 * @throws IOException ׳IO쳣
	 */
	public static IOSDriver<IOSElement> setIosAppium(Properties properties) throws IOException {
		IOSDriver<IOSElement> appium;
		DesiredCapabilities capabilities = new DesiredCapabilities();
		File directory = new File("");
		File app = new File(directory.getCanonicalPath() + File.separator + properties.getProperty("appname"));
		capabilities.setCapability("app", app.getAbsolutePath());
		// ԶԷ
		capabilities.setCapability("automationName", properties.getProperty("automationName"));
		// 豸
		capabilities.setCapability("deviceName", properties.getProperty("deviceName"));
		// ƽ̨
		capabilities.setCapability("platformName", properties.getProperty("platformName"));
		// ϵͳ汾
		capabilities.setCapability("platformVersion", properties.getProperty("platformVersion"));
		// ģϵipַ
		capabilities.setCapability("udid", properties.getProperty("udid"));
		// ֧룬ԶװUnicode
		capabilities.setCapability("unicodeKeyboard", Boolean.valueOf(properties.getProperty("unicodeKeyboard")));
		// 뷨ԭ״̬
		capabilities.setCapability("resetKeyboard", Boolean.valueOf(properties.getProperty("resetKeyboard")));
		// ǩapk
		capabilities.setCapability("noSign", Boolean.valueOf(properties.getProperty("noSign")));
		// Ƿ°װAPP
		capabilities.setCapability("noReset", Boolean.valueOf(properties.getProperty("noReset")));
		// ȴʱûյرappium
		capabilities.setCapability("newCommandTimeout", properties.getProperty("newCommandTimeout"));
		String url="http://" + properties.getProperty("appiumsever") + "/wd/hub";
		appium = new IOSDriver<>(new URL(url), capabilities);
		int waittime = Integer.parseInt(properties.getProperty("implicitlyWait"));
		appium.manage().timeouts().implicitlyWait(waittime, TimeUnit.SECONDS);
		return appium;
	}
	
}
