package luckyclient.execution.appium;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

import luckyclient.execution.dispose.ChangString;
import luckyclient.remote.api.serverOperation;
import luckyclient.remote.entity.ProjectCase;
import luckyclient.remote.entity.ProjectCaseSteps;
import luckyclient.utils.LogUtil;
/**
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸
 * κʻӭϵۡ QQ:1573584944  seagull1985
 * =================================================================
 * @ClassName: AnalyticCase 
 * @Description: ֵĽű
 * @author seagull
 * @date 2016918 
 * 
 */
public class AppDriverAnalyticCase {
	//private static String splitFlag = "\\|";

	/**
	 * ƶ˵
	 * @param projectcase 
	 * @param step 
	 * @param taskid ID
	 * @param caselog ־
	 * @return زMAP
	 * @author Seagull
	 * @date 2019117
	 */
	public static Map<String,String> analyticCaseStep(ProjectCase projectcase,ProjectCaseSteps step,String taskid,serverOperation caselog, Map<String, String> variable){
		Map<String,String> params = new HashMap<>(0);

		String resultstr;
		try {
			// ֵ
			String path = ChangString.changparams(step.getStepPath(), variable, "·|λ·");
		if(null != path && path.contains("=")){
			String property = path.substring(0, path.indexOf("=")).trim();
			String propertyValue = path.substring(path.indexOf("=")+1).trim();
			//set
			params.put("property", property.toLowerCase());   
			//setֵ
			params.put("property_value", propertyValue);  
			LogUtil.APP.info("Խproperty:{};  property_value:{}",property,propertyValue);		
		}
		// set,ֵ
		String operation = ChangString.changparams(step.getStepOperation().toLowerCase(), variable, "");
		params.put("operation", operation);   
		// setֵ,ֵ
		String operationValue = ChangString.changparams(step.getStepParameters(), variable, "");
		if(StringUtils.isNotEmpty(operationValue)){
			 //setֵ
			params.put("operation_value", operationValue);  
		}
		LogUtil.APP.info("operation:{};  operation_value:{}",operation,operationValue);
		 //ȡԤڽַ
		resultstr = step.getExpectedResult();  

		//setԤڽ
		if(null==resultstr||"".equals(resultstr)){
			params.put("ExpectedResults", "");
		}else {
			String expectedResults = subComment(resultstr);

			//checkֶ
			if(expectedResults.startsWith("check(")){
				params.put("checkproperty", expectedResults.substring(expectedResults.indexOf("check(")+6, expectedResults.indexOf("=")));
				params.put("checkproperty_value", expectedResults.substring(expectedResults.indexOf("=")+1, expectedResults.lastIndexOf(")")));
			}
			
			//ֵ
            expectedResults = ChangString.changparams(expectedResults, variable, "Ԥڽ");
			params.put("ExpectedResults", expectedResults);
			LogUtil.APP.info("ԤڽExpectedResults:{}",expectedResults);
		}
		
		LogUtil.APP.info("ţ{} ţ{} Զűɣ",projectcase.getCaseSign(),step.getStepSerialNumber());
		if(null!=caselog){
		  caselog.insertTaskCaseLog(taskid, projectcase.getCaseId(),"ţ"+step.getStepSerialNumber()+" Զűɣ","info",String.valueOf(step.getStepSerialNumber()),"");
		}
		}catch(Exception e) {
			if(null!=caselog){
			  caselog.insertTaskCaseLog(taskid, projectcase.getCaseId(),"ţ"+step.getStepSerialNumber()+" Զű","error",String.valueOf(step.getStepSerialNumber()),"");
			}
			LogUtil.APP.error("ţ{} ţ{} Զű",projectcase.getCaseSign(),step.getStepSerialNumber(),e);
			params.put("exception","ţ"+projectcase.getCaseSign()+"|쳣,Ϊջű");
			return params;
     }
		return params;
	}
	
	private static String subComment(String htmlStr) {
		// scriptʽ
    	String regExScript = "<script[^>]*?>[\\s\\S]*?</script>";
    	// styleʽ
        String regExStyle = "<style[^>]*?>[\\s\\S]*?</style>";
        // HTMLǩʽ
        String regExHtml = "<[^>]+>"; 
        //ոسз
        String regExSpace = "[\t\r\n]";
        
        String scriptstr;
        if (htmlStr!=null) {
            Pattern pScript = Pattern.compile(regExScript, Pattern.CASE_INSENSITIVE);
            Matcher mScript = pScript.matcher(htmlStr);
            // scriptǩ
            htmlStr = mScript.replaceAll(""); 
       
            Pattern pStyle = Pattern.compile(regExStyle, Pattern.CASE_INSENSITIVE);
            Matcher mStyle = pStyle.matcher(htmlStr);
            // styleǩ
            htmlStr = mStyle.replaceAll(""); 
       
            Pattern pHtml = Pattern.compile(regExHtml, Pattern.CASE_INSENSITIVE);
            Matcher mHtml = pHtml.matcher(htmlStr);
            // htmlǩ
            htmlStr = mHtml.replaceAll(""); 
       
            Pattern pSpace = Pattern.compile(regExSpace, Pattern.CASE_INSENSITIVE);
            Matcher mSpace = pSpace.matcher(htmlStr);
            // ˿ոسǩ
            htmlStr = mSpace.replaceAll(""); 
            
        }
		assert htmlStr != null;
		if(htmlStr.contains("/*") && htmlStr.contains("*/")){
    		String commentstr = htmlStr.substring(htmlStr.trim().indexOf("/*"),htmlStr.indexOf("*/")+2);
    		 //ȥע
    		scriptstr = htmlStr.replace(commentstr, "");    
        }else{
        	scriptstr = htmlStr;
        }
        //ȥַǰĿո
        scriptstr = trimInnerSpaceStr(scriptstr);  
        //滻ոת
        scriptstr = scriptstr.replaceAll("&nbsp;", " "); 
        //ת˫
        scriptstr = scriptstr.replaceAll("&quot;", "\""); 
        //ת嵥
        scriptstr = scriptstr.replaceAll("&#39;", "'");
        //תӷ
        scriptstr = scriptstr.replaceAll("&amp;", "&");  
        scriptstr = scriptstr.replaceAll("&lt;", "<");  
        scriptstr = scriptstr.replaceAll("&gt;", ">");  
        
		return scriptstr;
	}

	/**
	 * ȥַǰĿոмĿո
	 * @param str ԭʼַ
	 * @return ȥոַ
	 */
	public static String trimInnerSpaceStr(String str) {
		str = str.trim();
		while (str.startsWith(" ")) {
			str = str.substring(1).trim();
		}
		while (str.startsWith("&nbsp;")) {
			str = str.substring(6).trim();
		}
		while (str.endsWith(" ")) {
			str = str.substring(0, str.length() - 1).trim();
		}
		while (str.endsWith("&nbsp;")) {
			str = str.substring(0, str.length() - 6).trim();
		}
		return str;
	}

}
