package luckyclient.driven;

import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;

import luckyclient.utils.Constants;
import luckyclient.utils.LogUtil;

/**
 * 
 * =================================================================
 * һƵκδǰ¶Գ޸ĺҵ;ҲԳ޸ĺκʽκĿĵٷ
 * ΪߵͶɹLuckyFrameؼȨϢϽ۸ κʻӭϵۡ QQ:1573584944 Seagull
 * =================================================================
 * @author Seagull
 * @date 2019115
 */
public class SubString {
	/**
	 * ȡַָмֶ
	 * 
	 * @param str ԭʼַ
	 * @param startstr ʼַ
	 * @param endstr ַ
	 * @return ַȡ
	 */
	public static String subCentreStr(String str, String startstr, String endstr) {
		try{
			int startnum=0;
			int endnum=str.length();
			if(!"".equals(startstr)){
				startnum=str.indexOf(startstr) + startstr.length();
			}
			if(!"".equals(endstr)){
				endnum=str.indexOf(endstr, str.indexOf(startstr) + startstr.length());
			}
			return str.substring(startnum,endnum);
		}catch(Exception e){
			LogUtil.APP.error("subCentreStrȡַ쳣",e);
			return "ȡַ쳣";
		}
	}

	/**
	 * ȡַַָʼ
	 * 
	 * @param str ԭʼַ
	 * @param startstr ʼַ
	 * @return ַȡ
	 */
	public static String subStartStr(String str, String startstr) {
		try{
			return str.substring(str.indexOf(startstr) + startstr.length());
		}catch(Exception e){
			LogUtil.APP.error("subStartStrȡַ쳣",e);
			return "ȡַ쳣";
		}
	}

	/**
	 * ȡַַָ
	 * 
	 * @param str ԭʼַ
	 * @param endstr ַ
	 * @return ַȡ
	 */
	public static String subEndStr(String str, String endstr) {
		try{
			return str.substring(0, str.indexOf(endstr));
		}catch(Exception e){
			LogUtil.APP.error("subEndStrȡַ쳣",e);
			return "ȡַ쳣";
		}
	}

	/**
	 * ַͨλýȡַָмֶ
	 * 
	 * @param str ԭʼַ
	 * @param startnum ʼַλ
	 * @param endnum λ
	 * @return ַȡ
	 */
	public static String subCentreNum(String str, String startnum, String endnum) {
		String getstr;
		if("".equals(startnum)){
			startnum="0";
		}
		if("".equals(endnum)){
			endnum=String.valueOf(str.length());
		}
		try{
			if (isInteger(startnum) && isInteger(endnum)) {
				int start = Integer.parseInt(startnum);
				int end = Integer.parseInt(endnum);
				if (start > end) {
					getstr = "ȡַʼλֲܴڽλ";
				} else if (start < 0) {
					getstr = "ȡַλõֲС0";
				} else if (start > str.length() || end > str.length()) {
					getstr = "ȡַλõֲַܴĳȡ" + str.length() + "";
				} else {
					getstr = str.substring(start, end);
				}
			} else {
				getstr = "ָĿʼǽλַͣ飡";
			}

			return getstr;
		}catch(Exception e){
			LogUtil.APP.error("subCentreNumȡַ쳣",e);
			return "ȡַ쳣";
		}
	}

	/**
	 * ַͨλýȡַַָʼ
	 * 
	 * @param str ԭʼַ
	 * @param startnum ַʼλ
	 * @return ַȡ
	 */
	public static String subStartNum(String str, String startnum) {
		String getstr;
		try{
			if (isInteger(startnum)) {
				int start = Integer.parseInt(startnum);
				if (start < 0) {
					getstr = "ȡַλõֲС0";
				} else if (start > str.length()) {
					getstr = "ȡַλõֲַܴĳȡ" + str.length() + "";
				} else {
					getstr = str.substring(start);
				}
			} else {
				getstr = "ָĿʼλַͣ飡";
			}

			return getstr;
		}catch(Exception e){
			LogUtil.APP.error("subStartNumȡַ쳣",e);
			return "ȡַ쳣";
		}
	}

	/**
	 * ȡַַָ
	 * 
	 * @param str ԭʼַ
	 * @param endnum λ
	 * @return ַȡ
	 */
	public static String subEndNum(String str, String endnum) {
		String getstr;
		try{
			if (isInteger(endnum)) {
				int end = Integer.parseInt(endnum);
				if (end < 0) {
					getstr = "ȡַλõֲС0";
				} else if (end > str.length()) {
					getstr = "ȡַλõֲַܴĳȡ" + str.length() + "";
				} else {
					getstr = str.substring(0, end);
				}
			} else {
				getstr = "ָĽλַͣ飡";
			}

			return getstr;
		}catch(Exception e){
			LogUtil.APP.error("subEndNumȡַ쳣",e);
			return "ȡַ쳣";
		}
	}

	/**
	 * ƥַ
	 * @param str ԭʼַ
	 * @param rgex ʽ
	 * @param num ַ
	 * @return ƥ䵽ַ
	 */
	public static String subStrRgex(String str, String rgex, String num) {
		List<String> list = new ArrayList<>();
		try{
			// ƥģʽ
			Pattern pattern = Pattern.compile(rgex);
			Matcher m = pattern.matcher(str);
			while (m.find()) {
//				int i = 1;
				list.add(m.group());
//				i++;
			}

			String getstr;
			if (isInteger(num)) {
				int index = Integer.parseInt(num);
				if (index < 0) {
					getstr = "ȡֲַС0";
				} else if (index > str.length()) {
					getstr = "ȡֲַַܴĳȡ" + str.length() + "";
				} else if (index > list.size()) {
					getstr = "δַָиʽҵƥִַָҵƥַ";
				} else if (index == 0) {
					getstr = list.get(0);
				} else {
					getstr = list.get(index - 1);
				}
			} else {
				getstr = "ָλַͣ飡";
			}
			return getstr;
		}catch(Exception e){
			LogUtil.APP.error("subStrRgexȡַ쳣",e);
			return "ȡַ쳣";
		}
	}

	/**
	 * жǷ
	 * @param str ַ
	 * @return زͽ
	 */
	private static boolean isInteger(String str) {
		String patternStr="^[-+]?[\\d]*$";
		Pattern pattern = Pattern.compile(patternStr);
		return pattern.matcher(str).matches();
	}

	/**
	 * ʼJSONValueֵ
	 */
	private static String JSONVALUE = "ȡJSON KEYеValue쳣";

	/**
	 * ڼKEY
	 */
	private static int COUNTER = 1;

	/**
	 * JSON
	 * @param json ԭʼJSON
	 * @param key ѯkeyֵ
	 * @param keyindex keyֵ
	 * @return json
	 */
	private static JSONObject parseJsonString(String json, String key, int keyindex) {
		LinkedHashMap<String, Object> jsonMap = JSON.parseObject(json,
				new TypeReference<LinkedHashMap<String, Object>>() {
				}, Feature.OrderedField);
		for (Map.Entry<String, Object> entry : jsonMap.entrySet()) {
			parseJsonMap(entry, key, keyindex);
		}
		return new JSONObject(jsonMap);
	}

	/**
	 * JSONеkeyԼvalue
	 * @param entry jsonеĵkeyԼvalue
	 * @param key Ҫȡkey
	 * @param keyindex ȡkey
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	private static void parseJsonMap(Map.Entry<String, Object> entry, String key, int keyindex) {
		// ǵmap
		if (entry.getValue() instanceof Map) {
			LinkedHashMap<String, Object> jsonMap = JSON.parseObject(entry.getValue().toString(),
					new TypeReference<LinkedHashMap<String, Object>>() {
					}, Feature.OrderedField);
			for (Map.Entry<String, Object> entry2 : jsonMap.entrySet()) {
				parseJsonMap(entry2, key, keyindex);
			}
		}
		// listȡ
		if (entry.getValue() instanceof List) {
			List list = (List) entry.getValue();
			for (int i = 0; i < list.size(); i++) {
				// Уѭȡ
				//list.set(i, parseJsonString(list.get(i).toString(), key, keyindex));
				//λУѭȡ
				try{
					list.set(i, parseJsonString(list.get(i).toString(), key, keyindex));
				}catch(JSONException jsone){
					if(key.equals(entry.getKey())){
						if(keyindex==COUNTER){
							JSONVALUE = entry.getValue().toString();
						}			
						COUNTER++;
					}
					break;
				}
			}
		}
		// ȡkeyеvalue
		if (key.equals(entry.getKey())) {
			if (keyindex == COUNTER) {
				JSONVALUE = entry.getValue().toString();
			}
			COUNTER++;
		}

	}

	/**
	 * ȡJSONJSONArrayָKeyеValue
	 * 
	 * @param json ԭʼJSON
	 * @param key ָkey
	 * @param indexstr key
	 * @return ָkeyvalueַ
	 */
	public static String getJsonValue(String json, String key, String indexstr) {
		json = json.trim();
		int index;
		String result = JSONVALUE;
		if (isInteger(indexstr) && !"0".equals(indexstr)) {
			index = Integer.parseInt(indexstr);
		} else {
			result = JSONVALUE + "ָkeyֵŲǴ0(Ŵ1ʼ)飡";
			return result;
		}

		if (json.startsWith("{") && json.endsWith("}")) {
			try {
				JSONObject jsonStr = JSONObject.parseObject(json, Feature.OrderedField);
				parseJsonString(jsonStr.toString(), key, index);
				result = JSONVALUE;
			} catch (Exception e) {
				result = JSONVALUE + "ʽJSON쳣" + json;
				return result;
			}
		} else if (json.startsWith("[") && json.endsWith("]")) {
			try {
				// JSONArray jsonarr = JSONArray.parseArray(json);
				// ֱʹfastjsonĽӿʵ
				JSONArray jsonarr = JSONArray.parseObject(json.getBytes(StandardCharsets.UTF_8), JSONArray.class, Feature.OrderedField);
				for (int i = 0; i < jsonarr.size(); i++) {
					JSONObject jsonStr = jsonarr.getJSONObject(i);
					parseJsonString(jsonStr.toJSONString(), key, index);
					if (!JSONVALUE.startsWith("ȡJSON KEYеValue쳣")) {
						result = JSONVALUE;
						break;
					}
				}
			} catch (Exception e) {
				result = JSONVALUE + "ʽJSONArray쳣" + json;
				return result;
			}
		} else {
			result = JSONVALUE + "ʽJSONJSONArrayʱ쳣" + json;
		}

		if (result.equals("ȡJSON KEYеValue쳣")) {
			result = JSONVALUE + "ûҵӦKEYֵȷϣ";
		}

		COUNTER = 1;
		JSONVALUE = "ȡJSON KEYеValue쳣";
		return result;
	}

    /**
     * ͨjsonPathʽȡJSONֵַָ
     * @param expressionParams jsonPathʽ
     * @param jsonString jsonԭʼַ
     * @return ȡַ
     * @author Seagull
     * @date 2019828
     */
    public static String jsonPathGetParams(String expressionParams, String jsonString) {
        String type;
        String expression="";
        if(expressionParams.endsWith("]")&&expressionParams.contains("[")){
        	try{
            	type=expressionParams.substring(0,expressionParams.indexOf("["));
            	expression=expressionParams.substring(expressionParams.indexOf("[")+1, expressionParams.lastIndexOf("]"));
            	if("list".equals(type.toLowerCase())){
            		//ȥӦͷϢ
            		if(jsonString.startsWith(Constants.RESPONSE_HEAD)){
            			jsonString = jsonString.substring(jsonString.indexOf(Constants.RESPONSE_END)+1);
            		}
            		
            		//ȥӦͷϢ
            		if(jsonString.startsWith(Constants.RESPONSE_CODE)){
            			jsonString = jsonString.substring(jsonString.indexOf(Constants.RESPONSE_END)+1);
            		}
            		
            		List<Object> list = JsonPath.parse(jsonString).read(expression);
            		jsonString="";
            		for(Object result:list){
            			result = jsonString +result+",";
            			jsonString = (String)result;
            		}    		
            	}else{                	
            		jsonString=JsonPath.parse(jsonString).read(expression).toString();
            	}
        	}catch(PathNotFoundException pnfe){
        		LogUtil.APP.error("ͨjsonPathȡJSONֵַָ쳣ûҵӦ·ȷJSONַ{}ʽǷȷ{}",jsonString,expression);
        	}catch(Exception e){
        		LogUtil.APP.error("ͨjsonPathȡJSONֵַָ쳣Ķʽ(String/List[ʽ])ǱȡjsonַǷ");
        	}
        }else{
        	LogUtil.APP.warn("ȡJSONַָjsonPathʽ{}쳣Ķʽ(String/List[ʽ])Ƿ",expressionParams);
        }
        LogUtil.APP.info("ȡJSONַָjsonPathʽ{}ֵ:{}",expression,jsonString);
        return jsonString;
    }
}
