const fs = require('fs')
const os = require('os')

const vueDir = './src/views/'
const routerFile = './src/router.js'
const routes = []

const directories = fs.readdirSync(vueDir, { withFileTypes: true })
  .filter((dirent) => dirent.isDirectory())
  .map((dirent) => dirent.name)

for (const subDir of directories) {
  getDirRoutes(`${vueDir}${subDir}/`, subDir)
}

getDirRoutes(vueDir)

/**
 * Get routes from directory
 * @param {string} dir directory
 * @param {string} subDir sub directory
 */
function getDirRoutes(dir, subDir = '') {
  const files = fs.readdirSync(dir)
  for (const filename of files) {
    if (filename.indexOf('.') < 0) {
      continue
    }
    const [name, ext] = filename.split('.')
    if (ext !== 'vue') {
      continue
    }
    const pathname = subDir ? `${subDir}/${name}` : name
    const routeName = pathname.replace(/-(\w)|\/(\w)/g, (_, match1, match2) => (match1 || match2).toUpperCase())
    let routeDescription = ''
    const contentFull = fs.readFileSync(`${dir}${filename}`, 'utf-8')
    // get route description from first line comment
    const match = /<!--\s*(.*)\s*-->/g.exec(contentFull.split(os.EOL)[0])
    if (match) {
      routeDescription = match[1].trim()
    }
    routes.push(`  {
    path: '/${name === 'home' ? '' : pathname}',
    name: '${routeName}',${routeDescription ? `\n    meta: { description: '${routeDescription}' },` : ''}
    component: () => import(/* webpackChunkName: "${routeName}" */ '@/views/${pathname}'),
  },`)
  }
}

// move home route to first
const homeIndex = routes.findIndex(route => route.indexOf('name: \'home\'') >= 0)
if (homeIndex > 0) {
  routes.unshift(routes.splice(homeIndex, 1)[0])
}

const result =
`// This file is automatically generated by gen-router.js, please do not modify it manually！
import VueRouter from 'vue-router'
import Vue from 'vue'

Vue.use(VueRouter)

const routes = [
${routes.join(os.EOL)}
]

const router = new VueRouter({
  mode: 'hash',
  routes,
})

router.afterEach((to) => {
  document.title = \`\${to.meta?.description} - VUE-EL-DEMO\`
})

export default router
`

fs.writeFile(routerFile, result, 'utf-8', (err) => {
  if (err) throw err
  console.log(`✅ Router generated successfully in ${routerFile}`)
})
