## Prerequisites
- 📦 A Python package to upload
- 🌐 A GitHub account
- 📝 A PyPI account
- 🔑 A PyPI API token

## Generating a PyPI API Token

1. **Log in to your PyPI account**: Go to the PyPI website ([https://pypi.org/](https://pypi.org/)) and log in to your account.

2. **Navigate to "Account settings"**: Click on your username in the top right corner and select "Account settings" from the dropdown menu.

3. **Create a new API token**: Scroll down to the "API tokens" section and click on the "Create API token" button.

4. **Name your token**: Give your token a name that will help you identify its purpose (e.g., "GitHub Actions").

5. **Generate the token**: Click on the "Generate token" button. The token will be displayed on the screen. Copy this token and keep it secure, as you won't be able to see it again.

6. **Add the token to GitHub secrets**: Go to your GitHub repository, click on "Settings", then "Secrets", and click on "New repository secret". Name your secret (e.g., `TEST_PYPI_API_TOKEN`) and paste the PyPI API token you generated. Click on "Add secret" to save it.

## Steps
1. 🛠️ **Create your Python package**: Make sure your package is structured correctly and contains all the necessary files.

2. 📤 **Upload your package to GitHub**: Push your Python package to a GitHub repository.

3. 🖥️ **Open your repository on GitHub**: Navigate to your repository's page on GitHub.

4. ⚙️ **Access GitHub Actions**: Click on the "Actions" tab in your repository.

5. ➕ **Create a new workflow**: Click on "New Workflow" and select "Publish Python Package".

6. 📄 **Edit the workflow file**: A new YAML file will be created inside the `.github/workflows` folder. Replace its contents with the following:

```yaml
name: Upload Python Package

on:
  push:
    tags:
    - '*'

jobs:
  deploy:
    runs-on: ubuntu-latest

    steps:
    - uses: actions/checkout@v2
    - uses: actions/setup-python@v2
    - name: Install dependencies
      run: |
        python -m pip install --upgrade pip
        pip install setuptools wheel twine
    - name: Build and publish
      env:
        TWINE_USERNAME: __token__
        TWINE_PASSWORD: ${{ secrets.TEST_PYPI_API_TOKEN }}
      run: |
        python setup.py sdist bdist_wheel
        # twine upload --repository testpypi dist/* --skip-existing
      
```

-  twine upload dist/* --skip-existing use for pypi in yml
7.Tag your commits: Use git tag -a <version> -m "Version <version>" to tag a commit with a version number before pushing it. For example, git tag -a v1.0 -m "Version 1.0"

Push your tags: Use git push origin <tag> to push your tags to the remote repository. For example, git push origin v1.0.

After setting this up, every time you push a commit with a tagged version, GitHub Actions will build and upload your package to PyPI.