export const voices = [
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ko-KR, SoonBokNeural)",
        "shortName": "ko-KR-SoonBokNeural",
        "locale": "ko-KR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "SoonBok",
            "LocalName": "순복",
            "ShortName": "ko-KR-SoonBokNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "313",
            "LocaleDescription": "Korean",
            "PreviewSentence": "사용자들에게 자연스럽게 이야기하는 앱과 서비스를 만들며 접근성과 사용성을 개선시킵니다.",
            "DisplayVoiceName": "SoonBokNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "ko-KR",
            "localeZH": "韩语(韩国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/78938d0c-5b13-4ea8-a74d-b6083591303b.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A43Z&se=2122-09-27T07%3A52%3A43Z&sr=b&sp=rl&sig=a4BfmVOXUuOTfwt01BB92behlLUwqCZTsFN1pnrAH7A%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "abdda02b-9b62-411b-bc39-003fb1d9f2cc"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, AIGenerate1Neural)",
        "shortName": "en-US-AIGenerate1Neural",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "AIGenerate1",
            "LocalName": "AIGenerate1",
            "ShortName": "en-US-AIGenerate1Neural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "149",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AIGenerate1Neural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2a97f7b9-d6cd-4a98-8bfa-b4c1001b24a1.wav?sv=2019-07-07&sr=b&sig=EQJbF1Zo1htV4uO5xtAyO%2BiJuI575pRTIge0tJtaVYg%3D&st=2022-08-01T10:34:21Z&se=2122-07-08T10:39:21Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "520f8b71-e1cc-4e80-b9ea-006d2f816864"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, LouisaNeural)",
        "shortName": "de-DE-LouisaNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Louisa",
            "LocalName": "Louisa",
            "ShortName": "de-DE-LouisaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "70",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "LouisaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3e822098-69a2-4b59-9d54-e604eca4884b.wav?sv=2019-07-07&sr=b&sig=F%2Fi5B5ZVpXmw0alfhqI0VJ9F9pdwar9jNutVyUW49gc%3D&st=2022-01-19T09:00:41Z&se=2121-12-26T09:05:41Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "526184e4-10ee-403b-b9b7-01085f46c320"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, LeilaNeural)",
        "shortName": "pt-BR-LeilaNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Leila",
            "LocalName": "Leila",
            "ShortName": "pt-BR-LeilaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "359",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "LeilaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b8e0a4a0-e1ba-4ded-823e-7d9f643ea6b4.wav?sv=2019-07-07&sr=b&sig=giWb3Ts5%2Bz7vBR9yN%2Fx8KfEQDzhvdNZzlF0JSxnzexQ%3D&st=2022-07-01T09:10:27Z&se=2122-06-07T09:15:27Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "06526159-4cf8-4c95-91fa-01e83d6fe441"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ko-KR, GookMinNeural)",
        "shortName": "ko-KR-GookMinNeural",
        "locale": "ko-KR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "GookMin",
            "LocalName": "국민",
            "ShortName": "ko-KR-GookMinNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "310",
            "LocaleDescription": "Korean",
            "PreviewSentence": "사용자들에게 자연스럽게 이야기하는 앱과 서비스를 만들며 접근성과 사용성을 개선시킵니다.",
            "DisplayVoiceName": "GookMinNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "ko-KR",
            "localeZH": "韩语(韩国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ab77ad3c-f167-45b7-a827-33033562319e.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A37Z&se=2122-09-27T07%3A52%3A37Z&sr=b&sp=rl&sig=JtoUfe%2FsQsH%2FlBx6rpAco44cJSFd9ft5NyV1WkGrbjY%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "06eaa924-21ab-4bd1-9d71-01ed40046865"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (vi-VN, HoaiMyNeural)",
        "shortName": "vi-VN-HoaiMyNeural",
        "description": "",
        "locale": "vi-VN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "HoaiMy",
            "LocalName": "Hoài My",
            "ShortName": "vi-VN-HoaiMyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "417",
            "LocaleDescription": "Vietnamese",
            "PreviewSentence": "Phát triển phần mềm và dịch vụ có thể giao tiếp tự nhiên với người dùng, nâng cao tính tiếp cận và tính khả dụng của sản phẩm",
            "DisplayVoiceName": "HoaiMyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "vi-VN",
            "localeZH": "越南语(越南)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/da4fea18-8e86-4f3b-8416-508f420b7644.wav?sv=2019-07-07&sr=b&sig=QXouIeBe1mX0tmfuajjG2YjqxbupzoLQ8izXr%2F31Va0%3D&st=2021-10-29T08:28:29Z&se=2121-10-05T08:33:29Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "090b3817-3fe2-4c37-8c5f-025db1335032"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, NilNeural)",
        "shortName": "es-ES-NilNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Nil",
            "LocalName": "Nil",
            "ShortName": "es-ES-NilNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "178",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "NilNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/97080208-6fe9-44b6-9995-8c76460f0bdc.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A50Z&se=2122-09-27T07%3A51%3A50Z&sr=b&sp=rl&sig=fP3TMtVFKp66RiKyQ6D8tn0jdH68KjKjOYkI5RwKGaU%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f078c87b-9723-4050-b57a-026f7efb38e4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ja-JP, NanamiNeural)",
        "shortName": "ja-JP-NanamiNeural",
        "description": "",
        "locale": "ja-JP",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "chat,customerservice,cheerful,Default",
            "VoiceStyleNameDefinitions": "{\"cheerful\":4,\"Default\":0}",
            "DisplayName": "Nanami",
            "LocalName": "七海",
            "ShortName": "ja-JP-NanamiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "290",
            "LocaleDescription": "Japanese",
            "PreviewSentence": "アクセシビリティとユーザビリティを向上させながら、ユーザーに自然なことばを話すアプリとサービスを構築する",
            "DisplayVoiceName": "NanamiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ja-JP",
            "localeZH": "日语(日本)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6089ffb4-5260-4086-8f51-75e65b4678ed.wav?sv=2019-07-07&sr=b&sig=DW1VaFbJsmgEsezxszcxWaf%2FOK0Y52hddZJ2zSZqtfo%3D&st=2021-10-29T08:27:21Z&se=2121-10-05T08:32:21Z&sp=rl"
                },
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2f074470-e48d-419d-bfb7-53dff173d368.wav?sv=2019-07-07&sr=b&sig=sCPVdT3aBy1p5uM6YOwuSRUU36KaX2Kd0v704E%2F1zNY%3D&st=2021-12-02T05:00:50Z&se=2121-11-08T05:05:50Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1dd3d22d-c9ed-4229-b19c-67a85d869065.wav?sv=2019-07-07&sr=b&sig=nPNnWiDyF8W5zOTQ16xMB5tdotIlrRAoVYlunfrbMgk%3D&st=2021-12-02T05:00:53Z&se=2121-11-08T05:05:53Z&sp=rl"
                },
                {
                    "styleName": "customerservice",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e075449b-6aa1-4ed2-ae86-e17d82010386.wav?sv=2019-07-07&sr=b&sig=jpYOPxmYaAOf2layv3oJccB7v5DWVxkB3rxqXmabq6I%3D&st=2021-12-02T05:00:55Z&se=2121-11-08T05:05:55Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b35c7ab9-7933-4f6b-bf49-028a06114d0b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-ZA, LukeNeural)",
        "shortName": "en-ZA-LukeNeural",
        "locale": "en-ZA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Luke",
            "LocalName": "Luke",
            "ShortName": "en-ZA-LukeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "152",
            "LocaleDescription": "en-ZA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LukeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-ZA",
            "localeZH": "英语(南非)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6566a6fe-1ba6-486c-8be2-28b595a24006.wav?sv=2019-07-07&sr=b&sig=%2FfNi4sz%2F2K6ivca%2BR4kEgHQqS72lGdocuRnH3w2pEKk%3D&st=2021-10-29T08:26:39Z&se=2121-10-05T08:31:39Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "a53f44a0-b3fe-4f02-94d8-03829b8081be"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (lo-LA, ChanthavongNeural)",
        "shortName": "lo-LA-ChanthavongNeural",
        "locale": "lo-LA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Chanthavong",
            "LocalName": "ຈັນທະວົງ",
            "ShortName": "lo-LA-ChanthavongNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "315",
            "LocaleDescription": "lo-LA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ChanthavongNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "lo-LA",
            "localeZH": "老挝语(老挝) "
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f039dc4f-87f2-44e0-be98-d9e4b0fb7415.wav?sv=2019-07-07&sr=b&sig=TGU1at1wfGYWJ7v0JXDNNafSbRwx7CeGWr019ll1Q1c%3D&st=2022-01-19T12:26:14Z&se=2121-12-26T12:31:14Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6e185350-7363-4ee0-ab2c-038326c7ff41"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, CecilioNeural)",
        "shortName": "es-MX-CecilioNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Cecilio",
            "LocalName": "Cecilio",
            "ShortName": "es-MX-CecilioNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "193",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "CecilioNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e2dd970c-15e4-49e7-822a-70f4d88b4621.wav?sv=2019-07-07&sr=b&sig=WKcVz5GattaEHgnGPxZLTvved7tDfcyryFsDiyvyLsY%3D&st=2022-07-01T09:09:08Z&se=2122-06-07T09:14:08Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f4bf856d-6246-40be-a745-03c5e68f7d10"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, LucianoNeural)",
        "shortName": "es-MX-LucianoNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Luciano",
            "LocalName": "Luciano",
            "ShortName": "es-MX-LucianoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "199",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "LucianoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/10b259e0-a091-410a-9f08-4f1e3736d064.wav?sv=2019-07-07&sr=b&sig=AN%2F5yeSDwQwvL6PsPwe6FrQWIT1IyJhV0t1Zg32nujY%3D&st=2022-07-01T09:09:17Z&se=2122-06-07T09:14:17Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "25dc980d-ff1f-42e8-bef2-04cbb4bd16ce"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ta-LK, KumarNeural)",
        "shortName": "ta-LK-KumarNeural",
        "locale": "ta-LK",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Kumar",
            "LocalName": "குமார்",
            "ShortName": "ta-LK-KumarNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "396",
            "LocaleDescription": "ta-LK",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "KumarNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ta-LK",
            "localeZH": "泰米尔语(斯里兰卡)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/71bf3957-51c1-4f2c-929e-ec32be60b1fb.wav?sv=2019-07-07&sr=b&sig=78BDe%2FNgQe5sucPHXH63Krg0j%2BIPaOSEcvN87VMU45o%3D&st=2021-10-29T08:31:19Z&se=2121-10-05T08:36:19Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7777a5ee-439b-4780-88b8-060c527fbaf8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-CH, JanNeural)",
        "shortName": "de-CH-JanNeural",
        "locale": "de-CH",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Jan",
            "LocalName": "Jan",
            "ShortName": "de-CH-JanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "58",
            "LocaleDescription": "German (Switzerland)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "JanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-CH",
            "localeZH": "德语(瑞士)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1b972b9f-df36-4fa2-b72d-4b31d0679cb3.wav?sv=2019-07-07&sr=b&sig=SbDGr%2BH1GbqLibdczO08MexYj1K2nPdzCPNWVx55ojI%3D&st=2021-10-29T08:26:12Z&se=2121-10-05T08:31:12Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7ad56aad-0fda-4b70-bb36-06328dda42f5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (gl-ES, SabelaNeural)",
        "shortName": "gl-ES-SabelaNeural",
        "locale": "gl-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sabela",
            "LocalName": "Sabela",
            "ShortName": "gl-ES-SabelaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "258",
            "LocaleDescription": "gl-ES",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SabelaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "gl-ES",
            "localeZH": "加利西亚语(加利西亚语)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/dd13a9f3-0195-4342-ac86-430bc2729648.wav?sv=2019-07-07&sr=b&sig=Sldy9Ay1ErHes4xtm57LY0mFMjko3YIkRDj%2Fb0ELVcY%3D&st=2021-10-29T08:31:06Z&se=2121-10-05T08:36:06Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "fe9d5f74-af06-4803-976d-0839093512b1"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-YE, MaryamNeural)",
        "shortName": "ar-YE-MaryamNeural",
        "locale": "ar-YE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Maryam",
            "LocalName": "مريم",
            "ShortName": "ar-YE-MaryamNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "35",
            "LocaleDescription": "ar-YE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MaryamNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-YE",
            "localeZH": "阿拉伯语(也门)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/90604848-6020-4a28-9a25-714a3c6d8270.wav?sv=2019-07-07&sr=b&sig=lW5mn4F%2FhuB18jt8MtWshBr3B862NTdOphqgoW1TYYc%3D&st=2021-10-29T08:30:19Z&se=2121-10-05T08:35:19Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9a376069-83e6-4a20-b954-093d4a7d1757"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ja-JP, DaichiNeural)",
        "shortName": "ja-JP-DaichiNeural",
        "locale": "ja-JP",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Daichi",
            "LocalName": "大智",
            "ShortName": "ja-JP-DaichiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "292",
            "LocaleDescription": "Japanese",
            "PreviewSentence": "アクセシビリティとユーザビリティを向上させながら、ユーザーに自然なことばを話すアプリとサービスを構築する",
            "DisplayVoiceName": "DaichiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ja-JP",
            "localeZH": "日语(日本)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e041111e-38c8-414f-82bc-6dc2be783342.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A26Z&se=2122-09-27T07%3A52%3A26Z&sr=b&sp=rl&sig=F1bD%2BlxnYo8KhVqB%2BlDOZdqtKrQ5hwYUm%2Ba25q94zX0%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "61284492-3628-4c8f-a33a-0972a4603ad4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ta-SG, VenbaNeural)",
        "shortName": "ta-SG-VenbaNeural",
        "locale": "ta-SG",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Venba",
            "LocalName": "வெண்பா",
            "ShortName": "ta-SG-VenbaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "401",
            "LocaleDescription": "ta-SG",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "VenbaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ta-SG",
            "localeZH": "泰米尔语(新加坡)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4b6bdb06-f687-45b5-8079-6d2d93108e25.wav?sv=2019-07-07&sr=b&sig=IA9VNgHd9XTdTEPA2vS1K75El3srLSGUP6bCA3Dhr%2BM%3D&st=2021-10-29T08:31:22Z&se=2121-10-05T08:36:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "afed09aa-94df-4115-9600-09a007819371"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (kk-KZ, AigulNeural)",
        "shortName": "kk-KZ-AigulNeural",
        "locale": "kk-KZ",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Aigul",
            "LocalName": "Айгүл",
            "ShortName": "kk-KZ-AigulNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "301",
            "LocaleDescription": "kk-KZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AigulNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "kk-KZ",
            "localeZH": "哈萨克语(哈萨克斯坦)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1ca96ded-31cc-48a9-a30b-7259725a5620.wav?sv=2019-07-07&sr=b&sig=2AXO47wnhJqgS1xmlSR089POsw7R1TocibYBT1uN3Og%3D&st=2022-01-19T09:01:49Z&se=2121-12-26T09:06:49Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "83b52df6-a6e2-4bd0-9587-09bd9bfb73e4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-NG, AbeoNeural)",
        "shortName": "en-NG-AbeoNeural",
        "locale": "en-NG",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Abeo",
            "LocalName": "Abeo",
            "ShortName": "en-NG-AbeoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "116",
            "LocaleDescription": "en-NG",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AbeoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-NG",
            "localeZH": "英语(尼日利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/79e59fdb-e530-4921-81dd-50ac3983e9fe.wav?sv=2019-07-07&sr=b&sig=N%2BJCCBPtv6YO4tUOeH0w1I%2B%2BdfK%2FX5tS%2FEvSY%2FqEu6k%3D&st=2021-10-29T08:30:25Z&se=2121-10-05T08:35:25Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e9b470fe-c8eb-4aec-a993-09e806741339"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-HK, SamNeural)",
        "shortName": "en-HK-SamNeural",
        "locale": "en-HK",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sam",
            "LocalName": "Sam",
            "ShortName": "en-HK-SamNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "108",
            "LocaleDescription": "en-HK",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SamNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-HK",
            "localeZH": "英语(香港特别行政区)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b8b41f71-8150-4461-b9a5-048bd597f500.wav?sv=2019-07-07&sr=b&sig=8BJDPaxL68pTI9hvgNN20WsVTepUCp8RE3ID0bBPFFI%3D&st=2021-10-29T08:26:26Z&se=2121-10-05T08:31:26Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f6d931ff-4b5a-417a-b3ce-0a846a4dda4c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-PT, FernandaNeural)",
        "shortName": "pt-PT-FernandaNeural",
        "description": "",
        "locale": "pt-PT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Fernanda",
            "LocalName": "Fernanda",
            "ShortName": "pt-PT-FernandaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "366",
            "LocaleDescription": "Portuguese (Portugal)",
            "PreviewSentence": "Constrói aplicações e serviços que falam naturalmente com os utilizadores, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "FernandaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-PT",
            "localeZH": "葡萄牙语(葡萄牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8dfe864f-9ad2-4e97-9bfd-2838301a7fbc.wav?sv=2019-07-07&sr=b&sig=0tP1MWoh%2FFBsN6c19dn3pDhMrhDJfhLormXYrr9rfFw%3D&st=2021-10-29T08:27:57Z&se=2121-10-05T08:32:57Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "601ef07e-2f2a-4d7b-b59e-0b3b224948f0"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ta-MY, KaniNeural)",
        "shortName": "ta-MY-KaniNeural",
        "locale": "ta-MY",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Kani",
            "LocalName": "கனி",
            "ShortName": "ta-MY-KaniNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "398",
            "LocaleDescription": "ta-MY",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "KaniNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ta-MY",
            "localeZH": "泰米尔语(马来西亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d63b91a7-091c-4103-90e1-86a0f345f7bb.wav?sv=2019-07-07&sr=b&sig=BhACX5wHoqV8fbTvp6ulX1Wfh9QN1eqwEFt2G5M8SR8%3D&st=2022-07-01T09:10:45Z&se=2122-06-07T09:15:45Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e8e16409-b614-435f-8d10-0ba08088c3c0"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-SV, RodrigoNeural)",
        "shortName": "es-SV-RodrigoNeural",
        "locale": "es-SV",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Rodrigo",
            "LocalName": "Rodrigo",
            "ShortName": "es-SV-RodrigoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "216",
            "LocaleDescription": "es-SV",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "RodrigoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-SV",
            "localeZH": "西班牙语(萨尔瓦多)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e48c5bf7-2cc4-46f8-a3bb-a21da247be7b.wav?sv=2019-07-07&sr=b&sig=Obn4dhSnZGk3hrTl3NkMxiq3LcqIiExMReKyUd3pakQ%3D&st=2021-10-29T08:30:57Z&se=2121-10-05T08:35:57Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "405d8cfc-479f-4b4c-80b7-0bf031084928"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, ElizabethNeural)",
        "shortName": "en-US-ElizabethNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Elizabeth",
            "LocalName": "Elizabeth",
            "ShortName": "en-US-ElizabethNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "137",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ElizabethNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/07aa3bb6-312f-4441-b8a1-e8da1e1fe1b3.wav?sv=2019-07-07&sr=b&sig=qwjhzO1FxVyVmnbzno6%2FL22EBjIyAjxmc20IQ7qOTHM%3D&st=2021-10-29T08:25:35Z&se=2121-10-05T08:30:35Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f1b81aff-514c-4ea8-b602-0c56180c7c63"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, WilliamNeural)",
        "shortName": "en-AU-WilliamNeural",
        "description": "",
        "locale": "en-AU",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "William",
            "LocalName": "William",
            "ShortName": "en-AU-WilliamNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "90",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "WilliamNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/56e80a84-57f2-4f25-9797-e692299001a8.wav?sv=2019-07-07&sr=b&sig=fDDKppahiltzRkh8z8%2B8haRW1yWoTLYRbB0ZHx%2B35qA%3D&st=2021-10-29T08:26:19Z&se=2121-10-05T08:31:19Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ada99918-f740-4e47-86f7-0d3c8e95c027"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, LibbyNeural)",
        "shortName": "en-GB-LibbyNeural",
        "description": "",
        "locale": "en-GB",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Libby",
            "LocalName": "Libby",
            "ShortName": "en-GB-LibbyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "93",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LibbyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8a582811-2778-4133-8050-619759d43d98.wav?sv=2019-07-07&sr=b&sig=PeL5OIL%2B%2FOWz5t3YQfYCqoJSvob%2B6%2BfdOdZbdPYYr5I%3D&st=2021-10-29T08:26:22Z&se=2121-10-05T08:31:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e4fbab32-f3f3-4943-b4db-0d8a7469b383"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, AnnetteNeural)",
        "shortName": "en-AU-AnnetteNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Annette",
            "LocalName": "Annette",
            "ShortName": "en-AU-AnnetteNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "77",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AnnetteNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/145d0b78-3bba-4579-9a6c-43fc46dc3aaa.wav?sv=2021-08-06&st=2022-10-21T07%3A45%3A58Z&se=2122-09-27T07%3A50%3A58Z&sr=b&sp=rl&sig=SEgnOd712ESUt1k3FmwN1DNTaIyUn5z7IfLC0RqtR0E%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "38715012-e919-4142-acbf-0eba9d45b70c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (cy-GB, AledNeural)",
        "shortName": "cy-GB-AledNeural",
        "locale": "cy-GB",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Aled",
            "LocalName": "Aled",
            "ShortName": "cy-GB-AledNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "52",
            "LocaleDescription": "Welsh (UK)",
            "PreviewSentence": "Mae’r feddalwedd creu cynnwys sain yn galluogi rheoli priodoleddau lleferydd yn weledol mewn amser real.",
            "DisplayVoiceName": "AledNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "cy-GB",
            "localeZH": "威尔士语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5fd043f7-0f9d-42d9-92a5-e6b999aa3add.wav?sv=2019-07-07&sr=b&sig=4T6FY9gfX77DWDF5YEZq8EvD5zk0GOcXvQs4CVsKqtc%3D&st=2021-10-29T08:26:06Z&se=2121-10-05T08:31:06Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "a2dd132c-bfcc-4215-9077-0fcd2d57255e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, ImeldaNeural)",
        "shortName": "it-IT-ImeldaNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Imelda",
            "LocalName": "Imelda",
            "ShortName": "it-IT-ImeldaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "283",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "ImeldaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/524b11c6-9532-4a86-866a-45acd064f25c.wav?sv=2019-07-07&sr=b&sig=AJK5E1ntsuiqKtxmd7rZIcwz6fDkiVoVdJVokMg6Hkg%3D&st=2022-07-01T09:09:44Z&se=2122-06-07T09:14:44Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6077350a-dec0-40d0-8497-11976c4bb81f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-AR, ElenaNeural)",
        "shortName": "es-AR-ElenaNeural",
        "locale": "es-AR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Elena",
            "LocalName": "Elena",
            "ShortName": "es-AR-ElenaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "153",
            "LocaleDescription": "es-AR",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ElenaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-AR",
            "localeZH": "西班牙语(阿根廷)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bbf0e26e-6888-478c-ad80-3e90b9f0376b.wav?sv=2019-07-07&sr=b&sig=GZp8WvCjYJQAOEEovqXIJTWtF6IUIVtmFwlNFzfLioY%3D&st=2021-10-29T08:26:40Z&se=2121-10-05T08:31:40Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "16b6c635-eef5-43eb-87d3-11c780304891"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, MiaNeural)",
        "shortName": "en-GB-MiaNeural",
        "locale": "en-GB",
        "isHiddenFromAccPortal": true,
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Mia",
            "LocalName": "Mia",
            "ShortName": "en-GB-MiaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "107",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MiaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicDeprecated",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b9488997-6d44-449f-a3ee-6dfafa95fb6f.wav?sv=2019-07-07&sr=b&sig=z%2BcV50uz327knPEC5jczY2bGQb6DP1FZ1WPi%2B1aerfY%3D&st=2021-10-29T08:26:23Z&se=2121-10-05T08:31:23Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2367bbe4-0039-4222-a92a-12b37d66a362"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-CO, SalomeNeural)",
        "shortName": "es-CO-SalomeNeural",
        "locale": "es-CO",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Salome",
            "LocalName": "Salome",
            "ShortName": "es-CO-SalomeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "160",
            "LocaleDescription": "es-CO",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SalomeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-CO",
            "localeZH": "西班牙语(哥伦比亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cde05b67-aba9-4edb-8473-5a11b8fcbebc.wav?sv=2019-07-07&sr=b&sig=Y4l00UeNRU1Xb04GlXbTddyA7Idgdnif5x5W%2FLS%2F%2FRk%3D&st=2021-10-29T08:26:42Z&se=2121-10-05T08:31:42Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6f1346c4-e658-4395-9e98-132b0e4c1a62"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fi-FI, SelmaNeural)",
        "shortName": "fi-FI-SelmaNeural",
        "locale": "fi-FI",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Selma",
            "LocalName": "Selma",
            "ShortName": "fi-FI-SelmaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "229",
            "LocaleDescription": "Finnish",
            "PreviewSentence": "Kehitä luonnolisesti puhuvia sovelluksia ja palveluja, jotka parantavat käytettävyyttä ja saavutettavuutta.",
            "DisplayVoiceName": "SelmaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fi-FI",
            "localeZH": "芬兰语(芬兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bc7d9122-ab4d-4cfe-8b47-afd69188ada0.wav?sv=2019-07-07&sr=b&sig=%2FmLYpAIv6iiioD0HKAhBE2Lym%2FZQxVaEbY6fe%2F6b0tA%3D&st=2021-10-29T08:26:53Z&se=2121-10-05T08:31:53Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0c48f5ae-fe62-4be3-a239-134492206ac5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ko-KR, SunHiNeural)",
        "shortName": "ko-KR-SunHiNeural",
        "description": "",
        "locale": "ko-KR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sun-Hi",
            "LocalName": "선히",
            "ShortName": "ko-KR-SunHiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "307",
            "LocaleDescription": "Korean",
            "PreviewSentence": "사용자들에게 자연스럽게 이야기하는 앱과 서비스를 만들며 접근성과 사용성을 개선시킵니다.",
            "DisplayVoiceName": "SunHiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ko-KR",
            "localeZH": "韩语(韩国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f118c57b-9800-49ef-bb05-e3f57226bced.wav?sv=2019-07-07&sr=b&sig=KEFcz3Ot3EUbTqIbYIEDHj5dfryoATDldp7ySWCQgQc%3D&st=2021-10-29T08:27:23Z&se=2121-10-05T08:32:23Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "17e97d15-e286-416b-bc1b-13f7b3cd67af"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, RyanNeural)",
        "shortName": "en-GB-RyanNeural",
        "description": "",
        "locale": "en-GB",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "cheerful,chat,Default",
            "VoiceStyleNameDefinitions": "{\"cheerful\":4,\"Default\":0}",
            "DisplayName": "Ryan",
            "LocalName": "Ryan",
            "ShortName": "en-GB-RyanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "104",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "RyanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e08d4f27-caef-4438-9935-25b866147878.wav?sv=2019-07-07&sr=b&sig=XUg1ZhsDfFZxLu06i2E%2F1OTBJO7XevlCUDhPVxHSpms%3D&st=2021-10-29T08:26:24Z&se=2121-10-05T08:31:24Z&sp=rl"
                },
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fe6f4fa7-e825-4524-9cfe-edc241e31337.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A23Z&se=2122-09-27T07%3A51%3A23Z&sr=b&sp=rl&sig=mMDG1iL%2BLrgaEbT%2Bfie%2BX4eeEaZ7dNTrQJz8qoIhanU%3D"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d566b16e-4bd9-45f8-8096-97a42976df09.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A25Z&se=2122-09-27T07%3A51%3A25Z&sr=b&sp=rl&sig=PKGoanHoegkj1Q9C2Tkqv%2BScPS%2FHh%2FFW%2F%2B%2F87rsnm4E%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "865ed125-9b77-4022-bf44-142ca2522695"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ja-JP, ShioriNeural)",
        "shortName": "ja-JP-ShioriNeural",
        "locale": "ja-JP",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Shiori",
            "LocalName": "志織",
            "ShortName": "ja-JP-ShioriNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "296",
            "LocaleDescription": "Japanese",
            "PreviewSentence": "アクセシビリティとユーザビリティを向上させながら、ユーザーに自然なことばを話すアプリとサービスを構築する",
            "DisplayVoiceName": "ShioriNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ja-JP",
            "localeZH": "日语(日本)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/69a73884-64a5-414e-a60e-fa7ab41c7e7f.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A32Z&se=2122-09-27T07%3A52%3A32Z&sr=b&sp=rl&sig=lxEqTOhKWbGl%2BZh3Z2IFjxYcTl4wywHLftbhRw8Fyiw%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e99ee79d-06fc-4265-a27b-14c7fe231aca"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-SA, HamedNeural)",
        "shortName": "ar-SA-HamedNeural",
        "locale": "ar-SA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Hamed",
            "LocalName": "حامد",
            "ShortName": "ar-SA-HamedNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "29",
            "LocaleDescription": "Arabic (Saudi Arabia)",
            "PreviewSentence": "إن التطبيقات التي تتحاور مع المستخدمين بصوره طبيعية،  تعمل على  تحسين امكانية الوصول اليها وسهولة الاستخدام",
            "DisplayVoiceName": "HamedNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-SA",
            "localeZH": "阿拉伯语(沙特阿拉伯)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e372a792-f10f-43fc-8f48-845cfca3b8f7.wav?sv=2019-07-07&sr=b&sig=hW8mIMoEDEZ%2FSKGYBL8AzTfmq2d1i0scvjTjX9Eog2k%3D&st=2021-10-29T08:25:57Z&se=2121-10-05T08:30:57Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "43572d52-a314-43ff-97d7-151585fb0f65"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaoxuanNeural)",
        "shortName": "zh-CN-XiaoxuanNeural",
        "description": "Confident and capable voice with rich role-play and emotions that is optimized for audio books.",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "YoungAdultFemale,YoungAdultMale,OlderAdultFemale,OlderAdultMale,SeniorFemale,SeniorMale,Girl,Boy,Default",
            "VoiceRoleNameDefinitions": "{\"YoungAdultFemale\":4,\"YoungAdultMale\":1,\"OlderAdultFemale\":5,\"OlderAdultMale\":2,\"SeniorFemale\":10,\"SeniorMale\":3,\"Girl\":8,\"Boy\":9,\"Default\":0}",
            "VoiceStyleNames": "calm,fearful,cheerful,disgruntled,serious,angry,gentle,depressed,Default",
            "VoiceStyleNameDefinitions": "{\"calm\":2,\"fearful\":3,\"cheerful\":4,\"disgruntled\":5,\"serious\":6,\"angry\":7,\"gentle\":11,\"depressed\":10,\"Default\":0}",
            "DisplayName": "Xiaoxuan",
            "LocalName": "晓萱",
            "ShortName": "zh-CN-XiaoxuanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "YoungAdult",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3d066c1a-945b-4ba9-be68-7eba4c68c0d6?sv=2019-07-07&sr=b&sig=wIafT4580SFjW5tLBXIrp4zXx71rwuM0EuiEC1G2k%2BQ%3D&st=2021-10-29T08:24:27Z&se=2121-10-05T08:29:27Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "432",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaoxuanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Audiobook"
            },
            {
                "name": "Chat"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "晓萱有声书《迟桂花》",
                "titleLocalizationId": "zh-CN-XiaoxuanNeural_Masterpieces_Audiobook_ChiGuiHua_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/31ca3221-7068-4b13-83ae-19ec4b0950ea?sv=2019-07-07&sr=b&sig=pJIcad7mIUUHo8OQNqltil%2Fr0v4EQPD%2BFpSdVo952%2Fw%3D&st=2021-10-29T08:24:50Z&se=2121-10-05T08:29:50Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [
                {
                    "roleName": "Default",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/528b1233-50c5-447e-acfa-bd79ca102c4b.wav?sv=2019-07-07&sr=b&sig=IMjiIvR9kV3eQdFOlmXkDhLS6Nx40gBLKeo7ps41kaE%3D&st=2021-10-29T08:31:39Z&se=2121-10-05T08:36:39Z&sp=rl"
                },
                {
                    "roleName": "Boy",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c7c9298c-d99d-4a85-896d-7a03d035070d.wav?sv=2019-07-07&sr=b&sig=HkCCkhJpTwVOdksUxHYUeOGCjPfwbLBuKKTaZFm0Oe4%3D&st=2021-10-29T08:31:38Z&se=2121-10-05T08:36:38Z&sp=rl"
                },
                {
                    "roleName": "Girl",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3e0ce86e-9418-4f30-b365-32e15b83d70c.wav?sv=2019-07-07&sr=b&sig=%2FQQbA5f7LMP%2B%2BuJIThvKZ4dl99JrwlTr5kb4Tgf51YY%3D&st=2021-10-29T08:31:40Z&se=2121-10-05T08:36:40Z&sp=rl"
                },
                {
                    "roleName": "OlderAdultFemale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fc462f38-f226-4f4b-934a-8e3e2770df0f.wav?sv=2019-07-07&sr=b&sig=C8W7ENarMQni8txKiJ7Dyy0UV3OIkSeeV6p%2B4Mgmg0E%3D&st=2021-10-29T08:31:41Z&se=2121-10-05T08:36:41Z&sp=rl"
                },
                {
                    "roleName": "OlderAdultMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/df1316f4-5d20-4a2a-aba8-36b85cf951fe.wav?sv=2019-07-07&sr=b&sig=SCM3HU2T8e%2FJeN4fCicmOKUfJU0CJSiKM1YLdTkwrNY%3D&st=2021-10-29T08:31:42Z&se=2121-10-05T08:36:42Z&sp=rl"
                },
                {
                    "roleName": "SeniorFemale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4f5e875a-10ca-46af-856c-c759ef50da07.wav?sv=2019-07-07&sr=b&sig=FnfZj2FcUePBUN%2FC2QRXIkgWz16rhlS1TL%2BHz3wtm0k%3D&st=2021-10-29T08:31:42Z&se=2121-10-05T08:36:42Z&sp=rl"
                },
                {
                    "roleName": "SeniorMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1ba9d228-f0aa-4551-83ff-78952b36c50c.wav?sv=2019-07-07&sr=b&sig=O7EvYbl8ZpInki6m3GPUVopeKSYRZPT%2F4GoEqnD3veI%3D&st=2021-10-29T08:31:43Z&se=2121-10-05T08:36:43Z&sp=rl"
                },
                {
                    "roleName": "YoungAdultFemale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6e0af0e0-c30e-4c0d-b586-6b9ad24dc8d5.wav?sv=2019-07-07&sr=b&sig=sSBzpbYk7xnekhnTnxI7y785oArgucwPhMCTK4FDIUM%3D&st=2021-10-29T08:31:44Z&se=2121-10-05T08:36:44Z&sp=rl"
                },
                {
                    "roleName": "YoungAdultMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0c7837f6-8932-4d79-8727-bcc8f253f3f2.wav?sv=2019-07-07&sr=b&sig=uRuPt4D%2Fjc9pgSGGDN3fCjKUNRmDKR7kk%2BfnlcKJ1Ro%3D&st=2021-10-29T08:31:45Z&se=2121-10-05T08:36:45Z&sp=rl"
                }
            ],
            "styleSamples": [
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b698c45c-cfdc-4daf-b9f2-6824abddbe18.wav?sv=2019-07-07&sr=b&sig=YXzbdxaG8LaNyIr1pf1bUnMkwKRo6MZYRJbNXG9F81I%3D&st=2021-10-29T08:29:11Z&se=2121-10-05T08:34:11Z&sp=rl"
                },
                {
                    "styleName": "calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1c50d80a-d118-421b-a7d7-1e84ea255a43.wav?sv=2019-07-07&sr=b&sig=ejc8H0CeS%2F5b8cv%2B%2FtLFal9gVmujjmwhGftg9aFTbBI%3D&st=2021-10-29T08:29:12Z&se=2121-10-05T08:34:12Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/65cca866-93f8-42b3-890e-cfdfa5868c67.wav?sv=2019-07-07&sr=b&sig=JiTG0Lm88dIflX%2FlA%2FWSRzISppcaIvOSDOgB%2BuX2Sfs%3D&st=2021-10-29T08:29:13Z&se=2121-10-05T08:34:13Z&sp=rl"
                },
                {
                    "styleName": "depressed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5986a37c-68cc-4376-9403-182a9a5ea506.wav?sv=2019-07-07&sr=b&sig=EzOoQTk%2B3fiDqxu4FlyoPbd6Q8q9ZwZbJ5VevBOrOZQ%3D&st=2021-10-29T08:29:14Z&se=2121-10-05T08:34:14Z&sp=rl"
                },
                {
                    "styleName": "disgruntled",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/255d323e-a477-41b6-a93a-655df5d2d8f9.wav?sv=2019-07-07&sr=b&sig=UWFMk5xrkyctMbwqa%2FCDjuhExtttDETua2aKKyEfHS8%3D&st=2021-10-29T08:29:15Z&se=2121-10-05T08:34:15Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/52f1e82c-ceb6-4012-bd98-1c33a9e0d698.wav?sv=2019-07-07&sr=b&sig=7%2FEPU%2BbiSk9esQIMw47Hn%2BmJfn7c2pKhy7S1eyKTuM8%3D&st=2021-10-29T08:29:16Z&se=2121-10-05T08:34:16Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6c611f99-4298-4430-b92e-56effdae3a25.wav?sv=2019-07-07&sr=b&sig=Kz22JI%2BfE1hbBdI%2BjdnAg%2FG860CK4rO8k9QqfRCc4Os%3D&st=2021-10-29T08:29:17Z&se=2121-10-05T08:34:17Z&sp=rl"
                },
                {
                    "styleName": "gentle",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b0ed5589-2b41-4658-8d08-73d7da6e2d00.wav?sv=2019-07-07&sr=b&sig=IXV9BKaFIRsFZWPyijyApoXYFBVEpq%2B76KvNPCZL3vU%3D&st=2021-10-29T08:29:18Z&se=2121-10-05T08:34:18Z&sp=rl"
                },
                {
                    "styleName": "serious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ebacec70-4b66-4a92-bca0-d3341f975dc5.wav?sv=2019-07-07&sr=b&sig=5L9Hn2pFgD2pFw8D%2FMOxxctEPz9yeZ0buazD3FSyXQo%3D&st=2021-10-29T08:29:19Z&se=2121-10-05T08:34:19Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "197d529b-8158-4bec-ab83-156c8485e81c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-NG, EzinneNeural)",
        "shortName": "en-NG-EzinneNeural",
        "locale": "en-NG",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ezinne",
            "LocalName": "Ezinne",
            "ShortName": "en-NG-EzinneNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "117",
            "LocaleDescription": "en-NG",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "EzinneNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-NG",
            "localeZH": "英语(尼日利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5029885d-574a-462e-a839-63d55b0a3160.wav?sv=2019-07-07&sr=b&sig=e9IqlT1818lvddfMOWEvfyabE%2BSd3ZqaBi8%2BsGrb9ZA%3D&st=2021-10-29T08:30:26Z&se=2121-10-05T08:35:26Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "15b8867d-a217-4abb-9dde-158670c0615c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaochenNeural)",
        "shortName": "zh-CN-XiaochenNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Xiaochen",
            "LocalName": "晓辰",
            "ShortName": "zh-CN-XiaochenNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "YoungAdult",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5a7529db-8f27-45bc-838e-8c0a6e16a06a.png?sv=2019-07-07&sr=b&sig=sWkJpp9DbQSI6J0y2WQ50%2B1Q%2B2lYe8Ls7zCV8c7XBDE%3D&st=2021-10-29T08:24:32Z&se=2121-10-05T08:29:32Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "425",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaochenNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Chat"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Chat"
                ],
                "title": "晓辰客户对话展示",
                "titleLocalizationId": "zh-CN-XiaochenNeural_Masterpieces_Chat_CustomerConversation_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/202ba518-e7fc-4254-a31d-5d8c23e3bbee.wav?sv=2019-07-07&sr=b&sig=PeEKEniX%2FXSEyLSw79EwmTYLLGAl6s60GwvyryWKDy4%3D&st=2021-10-29T08:31:50Z&se=2121-10-05T08:36:50Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/57214773-6bfe-45cd-9c0f-07a5a09e7b76.wav?sv=2019-07-07&sr=b&sig=0isjvhamcDGVJSM6WoyzY%2B7vy%2FejMw7y4E9zlF%2F%2B6NI%3D&st=2021-10-29T08:29:43Z&se=2121-10-05T08:34:43Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "16cf511c-1865-404e-b2da-160362b7dff6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (he-IL, AvriNeural)",
        "shortName": "he-IL-AvriNeural",
        "locale": "he-IL",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Avri",
            "LocalName": "אברי",
            "ShortName": "he-IL-AvriNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "261",
            "LocaleDescription": "Hebrew (Israel)",
            "PreviewSentence": "בנה יישומים ושירותים שמדברים בטבעיות למשתמשים, שמשפרים את  הנגישות והשימושיות.",
            "DisplayVoiceName": "AvriNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "he-IL",
            "localeZH": "希伯来语(以色列)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e33123ca-e9ea-4d2b-ade5-1a1513c05ee9.wav?sv=2019-07-07&sr=b&sig=B04jlPJbXefzFE3Mz7IGHnfCycZPy0G9bg2xCrOww0Y%3D&st=2021-10-29T08:27:07Z&se=2121-10-05T08:32:07Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ff915f3d-7c13-4914-a7ed-1615d17d4039"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (uk-UA, PolinaNeural)",
        "shortName": "uk-UA-PolinaNeural",
        "locale": "uk-UA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Polina",
            "LocalName": "Поліна",
            "ShortName": "uk-UA-PolinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "410",
            "LocaleDescription": "Ukrainian (Ukraine)",
            "PreviewSentence": "Створення аудіовмісту дозволяє візуально контролювати мовні атрибути в реальному часі.",
            "DisplayVoiceName": "PolinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "uk-UA",
            "localeZH": "乌克兰语(乌克兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/61f5e44e-c714-4e7c-b705-406728f0f680.wav?sv=2019-07-07&sr=b&sig=ARzDmD3Hrrc8NSzmapEoToA0RPxZ9GF6iJkogabBigM%3D&st=2021-10-29T08:28:26Z&se=2121-10-05T08:33:26Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5189e67d-9cc7-4fd8-b894-165ab7c1d504"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaoxiaoNeural)",
        "shortName": "zh-CN-XiaoxiaoNeural",
        "description": "Lively and warm voice with multiple scenario styles and emotions.",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "assistant,chat,customerservice,newscast,affectionate,angry,calm,cheerful,disgruntled,fearful,gentle,lyrical,sad,serious,poetry-reading,friendly,Default",
            "VoiceStyleNameDefinitions": "{\"affectionate\":9,\"angry\":7,\"calm\":2,\"cheerful\":4,\"disgruntled\":5,\"fearful\":3,\"gentle\":11,\"sad\":8,\"serious\":6,\"Default\":0}",
            "DisplayName": "Xiaoxiao",
            "LocalName": "晓晓",
            "ShortName": "zh-CN-XiaoxiaoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "YoungAdult",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/56a84a35-3feb-457e-a1c4-db39407e5a5f?sv=2019-07-07&sr=b&sig=VUfdT6ng%2BFDpQpleWcfDx8rTqMKYNN3h%2FRaz8V96Yo4%3D&st=2021-10-29T08:24:23Z&se=2121-10-05T08:29:23Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "423",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaoxiaoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "ExpressAsStyleValues": "Default,CustomerService,Newscast,Lyrical,VoiceAssistant",
            "ExpressAsRoleValues": "Default,CustomerService,Newscast,Lyrical,VoiceAssistant",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Newscast",
                "defaultStyle": "newscast",
                "iconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/52b4ac03-bf02-49d6-b9fd-482f4d2a1c77?sv=2019-07-07&sr=b&sig=6d3sdtxzsnEv%2BQ8XgUaGCcoy8l8n1dalU1iLMHRgZPA%3D&st=2021-10-29T08:24:26Z&se=2121-10-05T08:29:26Z&sp=rl"
            },
            {
                "name": "Audiobook",
                "defaultStyle": "lyrical",
                "iconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4b216047-db86-4eba-8d40-eebcb4f3dfe2?sv=2019-07-07&sr=b&sig=kbWHWHE%2BRU9cPDrLnq7aP4Jdz3U6igfWnE9kjQD%2BkvA%3D&st=2021-10-29T08:24:25Z&se=2121-10-05T08:29:25Z&sp=rl"
            },
            {
                "name": "CustomerService",
                "defaultStyle": "customerservice"
            },
            {
                "name": "Chat",
                "defaultStyle": "chat"
            },
            {
                "name": "Assistant",
                "defaultStyle": "assistant",
                "iconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4147367b-5ec9-474b-8fb5-f542e8767cb5?sv=2019-07-07&sr=b&sig=b3naEouPSWl6zT2kiWDon87YTbwT5AZNXx8AIz%2BrZCY%3D&st=2021-10-29T08:24:24Z&se=2121-10-05T08:29:24Z&sp=rl"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "晓晓有声书《宝黛互晓心意》",
                "titleLocalizationId": "zh-CN-XiaoxiaoNeural_Masterpieces_Audiobook_DaiYuHuXiaoXinYi_Title",
                "description": "晓晓多情感语音演绎黛玉细腻的情绪变化。",
                "descriptionLocalizationId": "zh-CN-XiaoxiaoNeural_Masterpieces_Audiobook_DaiYuHuXiaoXinYi_Description",
                "ssmlFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/676de7d8-2440-4281-9eec-ba8910b6cd7e?sv=2019-07-07&sr=b&sig=TBTgfM7Xw5jP1C12iaadWp8K1jW1LpRDsX0btcaqWoc%3D&st=2021-10-29T08:24:38Z&se=2121-10-05T08:29:38Z&sp=rl",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ad560aa9-d061-409c-ac46-99210fdd97a6?sv=2019-07-07&sr=b&sig=m3%2Fv2WLVcO5tscAKesA6vJ0B1si9KJ4yhvOTy%2FU8MyE%3D&st=2021-10-29T08:24:39Z&se=2121-10-05T08:29:39Z&sp=rl"
            },
            {
                "categories": [
                    "Newscast"
                ],
                "title": "晓晓新闻",
                "titleLocalizationId": "zh-CN-XiaoxiaoNeural_Masterpieces_Newscast_XiaoxiaoNews_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c4a7ed19-de0b-49f5-b3b0-7b732324e2d3?sv=2019-07-07&sr=b&sig=Fz4UgeOZgC75M%2F3bOViddsFExfFFap%2F6DBAXx6stD6o%3D&st=2021-10-29T08:24:47Z&se=2121-10-05T08:29:47Z&sp=rl"
            },
            {
                "categories": [
                    "CustomerService"
                ],
                "title": "晓晓智能客服",
                "titleLocalizationId": "zh-CN-XiaoxiaoNeural_Masterpieces_CustomerService_XiaoxiaoCustomerService_Title",
                "description": "晓晓帮助加快客服服务流程。",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/291ed98c-3ede-404f-8730-7b6b7870537a?sv=2019-07-07&sr=b&sig=Z8jQ8C2JUqzvV2D9WgpLjenbZAjDE%2BJbyKVhQgNHT1A%3D&st=2021-10-29T08:24:40Z&se=2121-10-05T08:29:40Z&sp=rl"
            },
            {
                "categories": [],
                "title": "晓晓多情感展示",
                "titleLocalizationId": "zh-CN-XiaoxiaoNeural_Masterpieces_None_MutipleEmotions_Title",
                "description": "晓晓多情感语音升级后支持多达14种不同风格，能在丰富的情绪和场景中自由转换，比如多情感有声读物、新闻、客服、助理、聊天等。可以满足不同领域的多样化需求。",
                "iconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5465b8bb-902e-49e7-8355-27c936b612b1?sv=2019-07-07&sr=b&sig=cpA%2BlsiDFMRCMNCOEfqFY7cmO%2F5TN5ndcIh3d7JL5zs%3D&st=2021-10-29T08:24:42Z&se=2121-10-05T08:29:42Z&sp=rl",
                "videoFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b5a28f58-bd8d-4c52-a36c-a4e52482a98d?sv=2019-07-07&sr=b&sig=dOKk%2BfC4RbfT2Hm5eEq2tjyd4pARHR6hJeHXZL7A5eM%3D&st=2021-10-29T08:24:43Z&se=2121-10-05T08:29:43Z&sp=rl",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/dfdffd66-315f-41f9-aacd-e8a97f279302?sv=2019-07-07&sr=b&sig=iGJYW2KdqwN%2BxXwIhok%2FgeTK%2FKvi8dGyDZiJlaVa3Zk%3D&st=2021-10-29T08:24:41Z&se=2121-10-05T08:29:41Z&sp=rl"
            },
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "晓晓有声书《小城三月》",
                "titleLocalizationId": "zh-CN-XiaoxiaoNeural_Masterpieces_AudioBook_XiaoChengSanYue_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ff402971-7793-42a0-b13b-afeef88ef31c?sv=2019-07-07&sr=b&sig=arsayZJVIdZaYDBtnALU4wNYbzbJCqE1MzvBN63VeYc%3D&st=2021-10-29T08:24:45Z&se=2121-10-05T08:29:45Z&sp=rl"
            },
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "晓晓有声书《秋》",
                "titleLocalizationId": "zh-CN-XiaoxiaoNeural_Masterpieces_AudioBook_Qiu_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/aa55e174-db74-4d39-9548-7a2122a4720a?sv=2019-07-07&sr=b&sig=NmAMTUEixbGR2toeFgIAPHRTOlOxYaN5WYaGBK2iRi0%3D&st=2021-10-29T08:24:44Z&se=2121-10-05T08:29:44Z&sp=rl"
            },
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "晓晓有声书《野草》",
                "titleLocalizationId": "zh-CN-XiaoxiaoNeural_Masterpieces_AudioBook_YeCao_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0908c94f-11aa-4684-be13-2490cc58146b.wav?sv=2019-07-07&sr=b&sig=epq3c%2BEZ5%2FhqnxEnqQ44fzMr346WV08id5swxiBKqjA%3D&st=2021-10-29T08:24:45Z&se=2121-10-05T08:29:45Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "affectionate",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c6181015-94ae-4df0-8c2d-ff44c01b8bba.wav?sv=2019-07-07&sr=b&sig=gXZ5rhZzXr6DNYpuTwMMXpRvuIZj%2Bm8YXQFGDh7pv2c%3D&st=2021-10-29T08:28:56Z&se=2121-10-05T08:33:56Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6c39231e-1837-46cb-9685-44a380914bb6.wav?sv=2019-07-07&sr=b&sig=wZIN4BCTZCXXP1kYSo8WJg7jxNy1jRTNhSe7ohkIeVs%3D&st=2021-10-29T08:28:57Z&se=2121-10-05T08:33:57Z&sp=rl"
                },
                {
                    "styleName": "assistant",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1e0ae7ec-e791-499a-a38c-6e69c7204139.wav?sv=2019-07-07&sr=b&sig=%2FTar4XqjueANyna64xtIhMZpwg4iNUNICQMATJ%2FJxlg%3D&st=2021-10-29T08:28:58Z&se=2121-10-05T08:33:58Z&sp=rl"
                },
                {
                    "styleName": "calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d0c3856b-f831-44f7-b5c0-d16e63edfaa3.wav?sv=2019-07-07&sr=b&sig=aT1n5AoSK1hszjyAOEss%2B5BVy9I%2BjcyGf%2FbH3XIQAlw%3D&st=2021-10-29T08:28:59Z&se=2121-10-05T08:33:59Z&sp=rl"
                },
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2f223455-7c94-4eac-a2b0-6f45f7e30ec0.wav?sv=2019-07-07&sr=b&sig=vRHMyl6IrPRorPHpdXxd%2BdtO96DAsSchbUn5uyHoy0c%3D&st=2021-10-29T08:29:00Z&se=2121-10-05T08:34:00Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7f293767-f7e8-4602-8b5e-728ef69e61f5.wav?sv=2019-07-07&sr=b&sig=Ev0jD63M0NLea4QNKnFVI9Vze09J5OCjS1QEjLZAbwE%3D&st=2021-10-29T08:29:01Z&se=2121-10-05T08:34:01Z&sp=rl"
                },
                {
                    "styleName": "customerservice",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3c6199b4-7bf2-46ec-a5a8-32d38f5a73fd.wav?sv=2019-07-07&sr=b&sig=WKvs7eQvNc8mmptgZm0nAndShLP2sjcbAq4EDKrVr8c%3D&st=2021-10-29T08:29:02Z&se=2121-10-05T08:34:02Z&sp=rl"
                },
                {
                    "styleName": "disgruntled",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6c5b9606-7fac-457d-99ef-e08b843e8bbb.wav?sv=2019-07-07&sr=b&sig=X%2B%2B18WyUEa%2Bz0m38DxBT0VbsqGi9chzL9UVej9UFhZA%3D&st=2021-10-29T08:29:03Z&se=2121-10-05T08:34:03Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b1002a0d-b6ba-4d65-8f88-29750329b078.wav?sv=2019-07-07&sr=b&sig=FHuu7kY2%2FIgEVpPL3NWhpYkXTR%2Fqgf25iUcBesTTh%2FA%3D&st=2021-10-29T08:29:04Z&se=2121-10-05T08:34:04Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2656000c-3fea-487b-aead-8e44bdb2eebb.wav?sv=2019-07-07&sr=b&sig=68DNTVvPVYBufWdkX6KRNKd668BCXrk%2FI4IP%2FDxS8BE%3D&st=2021-10-29T08:29:05Z&se=2121-10-05T08:34:05Z&sp=rl"
                },
                {
                    "styleName": "gentle",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5d7c036e-6887-4f6a-8b76-ef9d4e3b1521.wav?sv=2019-07-07&sr=b&sig=iNmPkepyjZQYzHQWfa4XXBQ84duCLo8AHMP%2BG7JnD4g%3D&st=2021-10-29T08:29:06Z&se=2121-10-05T08:34:06Z&sp=rl"
                },
                {
                    "styleName": "lyrical",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/31d8ef07-96c3-4180-a62e-86fdb1fa2041.wav?sv=2019-07-07&sr=b&sig=nxUcp3ZzIezKCDBDS66JbMiGzyM0tXkvO8uUJeW4Mtc%3D&st=2021-10-29T08:29:07Z&se=2121-10-05T08:34:07Z&sp=rl"
                },
                {
                    "styleName": "newscast",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/001752cd-ffdf-40a1-be45-29cc6bb337ce.wav?sv=2019-07-07&sr=b&sig=lxLC3LL%2F67mOrZuajDjTaDonXaFU9KtcUUAOOBStlq4%3D&st=2021-10-29T08:29:08Z&se=2121-10-05T08:34:08Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/dc5ef7bc-ac6f-4108-bcfc-e18de09d3dad.wav?sv=2019-07-07&sr=b&sig=h2LqPe4%2BuliwEnhw2%2B2bnkPek%2FTKT3t66U4OMhcwxLo%3D&st=2021-10-29T08:29:09Z&se=2121-10-05T08:34:09Z&sp=rl"
                },
                {
                    "styleName": "serious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ec2e7db4-c93b-47a1-ba43-a07e414f68c3.wav?sv=2019-07-07&sr=b&sig=8LHPeCukknY213R2AN6kXTNTr%2BsGlspyxfznlI2NyB0%3D&st=2021-10-29T08:29:10Z&se=2121-10-05T08:34:10Z&sp=rl"
                },
                {
                    "styleName": "poetry-reading",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/27547f85-06b6-44d2-87c9-f45383d29cae.wav?sv=2019-07-07&sr=b&sig=p2LYfWhP%2BP1ewOaSadSLs38yIN3VJ87ab8KUgsu3vrE%3D&st=2022-06-02T09:01:46Z&se=2122-05-09T09:06:46Z&sp=rl"
                },
                {
                    "styleName": "friendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/97a6c4bf-d269-462c-b5ca-f7644ca5df5b.wav?sv=2021-10-04&st=2023-03-03T05%3A58%3A57Z&se=2123-02-07T06%3A03%3A57Z&sr=b&sp=rl&sig=39RB1DN5h6SL1kwWavrqO1iQWF%2BQNNg%2FQnPc3zXends%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5f55541d-c844-4e04-a7f8-1723ffbea4a9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, DiegoNeural)",
        "shortName": "it-IT-DiegoNeural",
        "description": "",
        "locale": "it-IT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Diego",
            "LocalName": "Diego",
            "ShortName": "it-IT-DiegoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "289",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "DiegoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2aa84483-b966-4840-af86-a8a8b8871302.wav?sv=2019-07-07&sr=b&sig=dZKIPZQmVjlMCXIVUYQFH8bHN1TbOKly1GkmoOkjQJs%3D&st=2021-10-29T08:27:17Z&se=2121-10-05T08:32:17Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "85e7f814-532a-4345-97e8-18a61717dd8e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, KatjaNeural)",
        "shortName": "de-DE-KatjaNeural",
        "description": "",
        "locale": "de-DE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Katja",
            "LocalName": "Katja",
            "ShortName": "de-DE-KatjaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "60",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "KatjaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2c864f0e-9dc5-4b72-b2f3-45e14f88387a.wav?sv=2019-07-07&sr=b&sig=S8y3Qk%2FVuUNITFEV3DOI5PdX4LF3gnJdkK2HF5aC1Ug%3D&st=2021-10-29T08:26:15Z&se=2121-10-05T08:31:15Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b7533283-392f-4969-b977-1a364b1adbae"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, ElviraNeural)",
        "shortName": "es-ES-ElviraNeural",
        "description": "",
        "locale": "es-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Elvira",
            "LocalName": "Elvira",
            "ShortName": "es-ES-ElviraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "173",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "ElviraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/abfdb173-2ef8-4433-8e01-769f1467b289.wav?sv=2019-07-07&sr=b&sig=k4MALkTBVqaQBMSpPQNTzKrRrSnrvwIvPkNEI6CbMbo%3D&st=2021-10-29T08:26:44Z&se=2121-10-05T08:31:44Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9314d042-c519-4087-ba99-1a49d78e2d9f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (si-LK, SameeraNeural)",
        "shortName": "si-LK-SameeraNeural",
        "locale": "si-LK",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sameera",
            "LocalName": "සමීර",
            "ShortName": "si-LK-SameeraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "373",
            "LocaleDescription": "si-LK",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SameeraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "si-LK",
            "localeZH": "僧伽罗语(斯里兰卡)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/14abea49-eb75-4ec0-9162-a189a76f1454.wav?sv=2019-07-07&sr=b&sig=FhWvJOQ8tyEJZ2fzAIv0ltSK0WcWjvzRQRoOQEWoxYM%3D&st=2022-01-19T09:02:16Z&se=2121-12-26T09:07:16Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "92fde113-0078-4166-b94c-1a5277a9a8c0"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaohanNeural)",
        "shortName": "zh-CN-XiaohanNeural",
        "description": "Warm and sweet voice with rich emotions that can be used in many conversation scenarios.",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "calm,fearful,cheerful,disgruntled,serious,angry,sad,gentle,affectionate,embarrassed,Default",
            "VoiceStyleNameDefinitions": "{\"calm\":2,\"fearful\":3,\"cheerful\":4,\"disgruntled\":5,\"serious\":6,\"angry\":7,\"sad\":8,\"gentle\":11,\"affectionate\":9,\"embarrassed\":1,\"Default\":0}",
            "DisplayName": "Xiaohan",
            "LocalName": "晓涵",
            "ShortName": "zh-CN-XiaohanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "YoungAdult",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e7b408f7-7406-4ce6-bc72-34894aa2e11b?sv=2019-07-07&sr=b&sig=1mPcj71Arx2TrCG6QoD%2FJx5s9v%2F%2BWyNQDts8eGuWrqU%3D&st=2021-10-29T08:24:20Z&se=2121-10-05T08:29:20Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "426",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaohanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Audiobook"
            },
            {
                "name": "Chat"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "金粉世家",
                "titleLocalizationId": "zh-CN-XiaohanNeural_Masterpieces_AudioBook_JinFenShiJian_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0ad14630-4206-43aa-ab40-a8aa01f98686.wav?sv=2019-07-07&sr=b&sig=ygJjV9XQxedAduoalfrukBLSGJGFvA8zMHAb4FW5fgw%3D&st=2021-10-29T08:31:46Z&se=2121-10-05T08:36:46Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "affectionate",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c9ca5b9b-dec7-4639-803a-726431782557.wav?sv=2019-07-07&sr=b&sig=3Cp9lWmO6jcRZ1BY1j0ds3AO%2BKErs3eHNX%2F807WaIqY%3D&st=2021-10-29T08:28:31Z&se=2121-10-05T08:33:31Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/61a53392-877e-4181-b637-4f8b4a603e13.wav?sv=2019-07-07&sr=b&sig=7YL8%2FEffLKdaq8ALbqoql2BqMAA1j%2FgWr1UTMY5O2w0%3D&st=2021-10-29T08:28:32Z&se=2121-10-05T08:33:32Z&sp=rl"
                },
                {
                    "styleName": "calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/eabe827e-b67f-417f-b5d5-2940284e6715.wav?sv=2019-07-07&sr=b&sig=C7ABvvBzPYXC3zMWHpfO3w0UdcSg593W2gyKf9DziTc%3D&st=2021-10-29T08:28:33Z&se=2121-10-05T08:33:33Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e0168677-5b8b-406c-8cd0-68f6a1081430.wav?sv=2019-07-07&sr=b&sig=XPH5yoJWHr%2FxrllkyN9QuKW7NY7ZrgwoJ174rbHEbms%3D&st=2021-10-29T08:28:34Z&se=2121-10-05T08:33:34Z&sp=rl"
                },
                {
                    "styleName": "disgruntled",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b4ca5849-cac2-4ec3-8297-3cb2ae332442.wav?sv=2019-07-07&sr=b&sig=vFqQdK3XkpX2lHWMQw%2F8ZRIFhwE4LmxhdgqsUNYrYrM%3D&st=2021-10-29T08:28:35Z&se=2121-10-05T08:33:35Z&sp=rl"
                },
                {
                    "styleName": "embarrassed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/186d233b-90da-4de9-b4e6-59506cebca8e.wav?sv=2019-07-07&sr=b&sig=iXjTDFaCaWCj7%2BGYhbDdCnxzS7HTL8hkqHg8i8zyU5E%3D&st=2021-10-29T08:28:36Z&se=2121-10-05T08:33:36Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1351be95-2ea5-4b47-af5c-f80a6eeeb9f7.wav?sv=2019-07-07&sr=b&sig=iRNBY8KTrpmfM3EXa9QkkiZdjt4MIJ6hhW%2B0hXp7WBQ%3D&st=2021-10-29T08:28:37Z&se=2121-10-05T08:33:37Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ffea4480-fe1e-4d00-88dc-f9002bfe571a.wav?sv=2019-07-07&sr=b&sig=JKCH93ueXx6Fao24TcNWFonOTKzorzXoHLJePycJq4A%3D&st=2021-10-29T08:28:38Z&se=2121-10-05T08:33:38Z&sp=rl"
                },
                {
                    "styleName": "gentle",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ef761363-b49f-4562-87b0-309e29525a6c.wav?sv=2019-07-07&sr=b&sig=phbHjjoFMJJWf0FHUqLo4ubQ0fbV869FXMVsjNl7C1A%3D&st=2021-10-29T08:28:39Z&se=2121-10-05T08:33:39Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3b7d1627-d6a3-42d0-a260-d384ec7276ef.wav?sv=2019-07-07&sr=b&sig=knt9vN9a6D7MVg4vKBScCsMJ4OE%2FwAc6XbgVa4Ep1bA%3D&st=2021-10-29T08:28:40Z&se=2121-10-05T08:33:40Z&sp=rl"
                },
                {
                    "styleName": "serious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/16cb1adc-6e1f-4880-8f47-2a1d73ebd0cc.wav?sv=2019-07-07&sr=b&sig=lOlU9iVqaSAE7ZS1yJA4S17TPUjYCghcsk9k2gZ8%2BkM%3D&st=2021-10-29T08:28:41Z&se=2121-10-05T08:33:41Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2a741315-7d02-4b45-b91f-1b620ac545bc"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, PierinaNeural)",
        "shortName": "it-IT-PierinaNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Pierina",
            "LocalName": "Pierina",
            "ShortName": "it-IT-PierinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "287",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "PierinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b2c3ba83-6562-4c57-9dcb-b0ce77922994.wav?sv=2019-07-07&sr=b&sig=3D77CYeLNd5Y5G4Z6jRAUnKsIs%2FfD9pccg2w5qYbJ2E%3D&st=2022-07-01T09:09:53Z&se=2122-06-07T09:14:53Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2b869701-13e4-4612-9183-1d67ed0e6ccc"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-PY, TaniaNeural)",
        "shortName": "es-PY-TaniaNeural",
        "locale": "es-PY",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Tania",
            "LocalName": "Tania",
            "ShortName": "es-PY-TaniaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "214",
            "LocaleDescription": "es-PY",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "TaniaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-PY",
            "localeZH": "西班牙语(巴拉圭)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3129bdec-9e5c-4069-86e1-317ac64a140c.wav?sv=2019-07-07&sr=b&sig=uDXbQJqt3xNYD6p4lNTRttuP7ERdqzGsm%2BEFokqjp8E%3D&st=2021-10-29T08:30:55Z&se=2121-10-05T08:35:55Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "cc82356f-b180-424d-ae74-1dbbdfdac93b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, MajaNeural)",
        "shortName": "de-DE-MajaNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Maja",
            "LocalName": "Maja",
            "ShortName": "de-DE-MajaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "71",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "MajaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b8eea38b-240c-4cb5-a5a4-0c5e9126f8a6.wav?sv=2019-07-07&sr=b&sig=USXipwdcnXPw6rLGKT%2Byv8IQyH72ypBtm8NoJzTxH4Y%3D&st=2022-01-19T09:00:44Z&se=2121-12-26T09:05:44Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1f13dc7d-e108-4432-94b6-1e25445cb533"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sw-TZ, RehemaNeural)",
        "shortName": "sw-TZ-RehemaNeural",
        "locale": "sw-TZ",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Rehema",
            "LocalName": "Rehema",
            "ShortName": "sw-TZ-RehemaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "393",
            "LocaleDescription": "sw-TZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "RehemaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sw-TZ",
            "localeZH": "斯瓦希里语(坦桑尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4137ce9d-bfc1-447f-b079-c3a78c53ec56.wav?sv=2019-07-07&sr=b&sig=dPrqWVtNiNfpctCc8wx5RLBxAKRN65pwTv%2FTnUdzBRc%3D&st=2021-10-29T08:31:18Z&se=2121-10-05T08:36:18Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8e2bd817-6415-4cde-9e56-1e45e2fb6973"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (mn-MN, YesuiNeural)",
        "shortName": "mn-MN-YesuiNeural",
        "locale": "mn-MN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yesui",
            "LocalName": "Есүй",
            "ShortName": "mn-MN-YesuiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "326",
            "LocaleDescription": "mn-MN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "YesuiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "mn-MN",
            "localeZH": "蒙古语(蒙古)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b380000c-72e2-4d84-9c91-919a4f807643.wav?sv=2019-07-07&sr=b&sig=TURGtPuY9rVlHfbnI9t%2BoARQxMEmVW5fi3JULFbowMk%3D&st=2022-07-01T09:10:04Z&se=2122-06-07T09:15:04Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d91fc86e-c4ac-4528-aad1-1f17a869b835"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, AmalaNeural)",
        "shortName": "de-DE-AmalaNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Amala",
            "LocalName": "Amala",
            "ShortName": "de-DE-AmalaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "61",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "AmalaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ebb55a3d-e393-4d56-ada0-86fdc8ce096b.wav?sv=2019-07-07&sr=b&sig=z0P4aXcCwNfRwT6LqDjQ2BhXB7kYVIOjZ41BUP4GVpY%3D&st=2022-01-19T09:00:20Z&se=2121-12-26T09:05:20Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c87ed4d5-30e1-43c7-9d21-1f61797fc706"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, TinaNeural)",
        "shortName": "en-AU-TinaNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Tina",
            "LocalName": "Tina",
            "ShortName": "en-AU-TinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "89",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "TinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e2e65a36-b67f-4abf-890f-789c70ac878e.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A21Z&se=2122-09-27T07%3A51%3A21Z&sr=b&sp=rl&sig=YkeZYg8iq6j0d06AEWxscYukmI8Ynp492%2Fr4bHB%2FUbU%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "36b7073c-1426-49ea-8393-206c4cd2ce99"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, NicolauNeural)",
        "shortName": "pt-BR-NicolauNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Nicolau",
            "LocalName": "Nicolau",
            "ShortName": "pt-BR-NicolauNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "362",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "NicolauNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/74fc758b-2468-4872-a391-23e5e9bec1b5.wav?sv=2019-07-07&sr=b&sig=afYRgqQMn4yBckDnqkL1nDuyz5AZN05biJaGkIIxDPA%3D&st=2022-07-01T09:10:34Z&se=2122-06-07T09:15:34Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2e840c4d-fc29-40aa-bdb6-209cc07f26e6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, KimNeural)",
        "shortName": "en-AU-KimNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Kim",
            "LocalName": "Kim",
            "ShortName": "en-AU-KimNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "85",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "KimNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fabbd286-39f0-4d9d-8448-fad65e69528f.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A15Z&se=2122-09-27T07%3A51%3A15Z&sr=b&sp=rl&sig=K2DfnBhX7mAJ0Mj34UCJ1K8hUez5u6fNKKtvejPOoOE%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e59988b1-2234-4607-9f69-2177f5892e0d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-CH, ArianeNeural)",
        "shortName": "fr-CH-ArianeNeural",
        "description": "",
        "locale": "fr-CH",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ariane",
            "LocalName": "Ariane",
            "ShortName": "fr-CH-ArianeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "239",
            "LocaleDescription": "French (Switzerland)",
            "PreviewSentence": "Développer des applications et des services qui parlent aux utilisateurs avec naturel, pour améliorer leur accessibilité et leur utilisation.",
            "DisplayVoiceName": "ArianeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-CH",
            "localeZH": "法语(瑞士)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bfda8c6c-0ff4-4d98-8deb-6ffee6bdc8e1.wav?sv=2019-07-07&sr=b&sig=cqz8D90NBsDh5qszJsgVKexx9ozooJ9SrQGHEEBYqZA%3D&st=2021-10-29T08:26:59Z&se=2121-10-05T08:31:59Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c86e7dad-b97c-4de9-8ff1-2287bf405535"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ru-RU, SvetlanaNeural)",
        "shortName": "ru-RU-SvetlanaNeural",
        "locale": "ru-RU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Svetlana",
            "LocalName": "Светлана",
            "ShortName": "ru-RU-SvetlanaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "370",
            "LocaleDescription": "Russian",
            "PreviewSentence": "Возможность создавать приложения и сервисы, которые естественным образом общаются с пользователями, улучшая доступность и удобство использования.",
            "DisplayVoiceName": "SvetlanaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ru-RU",
            "localeZH": "俄语(俄罗斯)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/391d214e-5b29-4ed5-92bd-bbfd1503773f.wav?sv=2019-07-07&sr=b&sig=VDWEEg4gFCzDVeduKQVA1LIKeb2MJQagHBwM88HwSlU%3D&st=2021-10-29T08:28:04Z&se=2121-10-05T08:33:04Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ed169f6c-1533-4ed5-8a17-23749095b556"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (su-ID, JajangNeural)",
        "shortName": "su-ID-JajangNeural",
        "locale": "su-ID",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Jajang",
            "LocalName": "Jajang",
            "ShortName": "su-ID-JajangNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "385",
            "LocaleDescription": "su-ID",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "JajangNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "su-ID",
            "localeZH": "巽他语(印度尼西亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/87ad1e62-b3f7-4ad9-9e0d-b2f2d03f2f3a.wav?sv=2019-07-07&sr=b&sig=5%2FAnz3lIHNmT7hA23WNKYAydSuKsrzAGPHdSUjte4nM%3D&st=2021-10-29T08:31:15Z&se=2121-10-05T08:36:15Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "a6482508-cc9f-4994-adf3-2397fe3cc5cd"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaozhenNeural)",
        "shortName": "zh-CN-XiaozhenNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "angry,disgruntled,cheerful,fearful,sad,serious,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"disgruntled\":5,\"cheerful\":4,\"fearful\":3,\"sad\":8,\"serious\":6,\"Default\":0}",
            "DisplayName": "Xiaozhen",
            "LocalName": "晓甄",
            "ShortName": "zh-CN-XiaozhenNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "436",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaozhenNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/43aaa3d7-673a-41ef-af17-433efff290bf.wav?sv=2019-07-07&sr=b&sig=FAQA80moG%2BtQYS7kQLGO4eHmxMbTIXAHhlb7g%2B%2B1yo8%3D&st=2022-08-01T10:39:55Z&se=2122-07-08T10:44:55Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1953b493-24f0-4053-abbf-60c918ef25a8.wav?sv=2019-07-07&sr=b&sig=1SOQTYJb0h28Y%2FTMicddPRC0VbrRXKhpVu%2BohWXF%2BEw%3D&st=2022-08-01T10:39:58Z&se=2122-07-08T10:44:58Z&sp=rl"
                },
                {
                    "styleName": "disgruntled",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ac66aa67-2871-49be-abd9-1dbc923bbb4f.wav?sv=2019-07-07&sr=b&sig=ZApY%2Bi%2BmvphJOmTvRQ0%2FOLebuTlmIMXv1ffhuoMoSe4%3D&st=2022-08-01T10:40:01Z&se=2122-07-08T10:45:01Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/679b0ccb-ef37-4c78-b224-700efe71baa9.wav?sv=2019-07-07&sr=b&sig=FbinntCxaCZaTE7GWSrlz2Lm3mh7pp54zgZsxIdOtPI%3D&st=2022-08-01T10:40:04Z&se=2122-07-08T10:45:04Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/345a2f55-081f-4bcf-b6e7-8054dcd2c95a.wav?sv=2019-07-07&sr=b&sig=I%2BMR%2FOkFDRAyvmilXqlH6xqfVX8JCywqKlynDNi7I7w%3D&st=2022-08-01T10:40:07Z&se=2122-07-08T10:45:07Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d79870da-f5e1-4f4a-83a1-dd5537c81042.wav?sv=2019-07-07&sr=b&sig=HDXdaJ4DuiRw%2BWycQfRo1k8Ivr5ccZPrlNpJfb6xw5Q%3D&st=2022-08-01T10:40:09Z&se=2122-07-08T10:45:09Z&sp=rl"
                },
                {
                    "styleName": "serious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ce56b498-3dac-474c-befe-599967f2c75c.wav?sv=2019-07-07&sr=b&sig=GCsyziaGcbB4NR%2BzOWNK7gZX1dDG%2Bkxte995lLFNn20%3D&st=2022-08-01T10:40:12Z&se=2122-07-08T10:45:12Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "40772218-9232-47e5-aa26-23a96d5effa0"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (lt-LT, LeonasNeural)",
        "shortName": "lt-LT-LeonasNeural",
        "locale": "lt-LT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Leonas",
            "LocalName": "Leonas",
            "ShortName": "lt-LT-LeonasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "317",
            "LocaleDescription": "Lithuanian (Lithuania)",
            "PreviewSentence": "Garso turinio kūrimas leidžia vizualiai kontroliuoti kalbos atributus realiu laiku.",
            "DisplayVoiceName": "LeonasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "lt-LT",
            "localeZH": "立陶宛语(立陶宛)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/484b4313-73f9-478e-bd13-d394fccc5f94.wav?sv=2019-07-07&sr=b&sig=MPY04100ilz2NJcta9oo5mKfKGqiKXMYM6oIpf56NFA%3D&st=2021-10-29T08:27:25Z&se=2121-10-05T08:32:25Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "4a99a2e0-2cf0-46c9-bcde-23d37674ecaf"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ur-PK, UzmaNeural)",
        "shortName": "ur-PK-UzmaNeural",
        "locale": "ur-PK",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Uzma",
            "LocalName": "عظمیٰ",
            "ShortName": "ur-PK-UzmaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "414",
            "LocaleDescription": "Urdu (Pakistan)",
            "PreviewSentence": "آواز کا مواد تخلیق کرنا  اس قابل بناتا  ہیکہ آپ تقریر کی خصوصیات کو  حقیقی وقت میں  اپنے مطابق کنٹرول کر سکتے ہیں۔",
            "DisplayVoiceName": "UzmaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ur-PK",
            "localeZH": "乌尔都语(巴基斯坦)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4a98847c-1fff-40b6-8281-7d4ad735c073.wav?sv=2019-07-07&sr=b&sig=SXt2rCpaVhBYUkADr0HBFY%2B2C4xbk2BMDfv6xlAe9mM%3D&st=2021-10-29T08:28:28Z&se=2121-10-05T08:33:28Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "49efca2d-f9bb-4761-81d2-243bf84d520b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-PY, MarioNeural)",
        "shortName": "es-PY-MarioNeural",
        "locale": "es-PY",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Mario",
            "LocalName": "Mario",
            "ShortName": "es-PY-MarioNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "213",
            "LocaleDescription": "es-PY",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MarioNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-PY",
            "localeZH": "西班牙语(巴拉圭)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/71bfa0a8-97f6-46ee-81b5-6630aa4c2f02.wav?sv=2019-07-07&sr=b&sig=T8ZFrM3QE5nNG1%2BSyv4XlSoG5kqk47k9Hl6KcZ8pvjQ%3D&st=2021-10-29T08:30:54Z&se=2121-10-05T08:35:54Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c1749ad5-0aa6-428a-9336-254ee247a672"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ka-GE, EkaNeural)",
        "shortName": "ka-GE-EkaNeural",
        "locale": "ka-GE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Eka",
            "LocalName": "ეკა",
            "ShortName": "ka-GE-EkaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "299",
            "LocaleDescription": "ka-GE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "EkaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ka-GE",
            "localeZH": "格鲁吉亚语(格鲁吉亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b3e64e26-b944-4e97-9b90-776e6d5e8b85.wav?sv=2019-07-07&sr=b&sig=QHTDLkr%2Fu5iE8Jc33MawodloFwOoRiidJtLjgnodyqI%3D&st=2022-07-01T09:09:58Z&se=2122-06-07T09:14:58Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "57801f3b-0718-44bc-81ff-259334396f17"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, YaraNeural)",
        "shortName": "pt-BR-YaraNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yara",
            "LocalName": "Yara",
            "ShortName": "pt-BR-YaraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "364",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "YaraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b91e1bfd-8451-45d3-a1e7-865e1681df5e.wav?sv=2019-07-07&sr=b&sig=UzX9cUIWaIGewcZ9G6jY4Mf4Vn1V0dzknHfUl%2FDZpR0%3D&st=2022-07-01T09:10:39Z&se=2122-06-07T09:15:39Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b7429917-f62d-44e1-bdd3-2623cb475bd2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-NZ, MollyNeural)",
        "shortName": "en-NZ-MollyNeural",
        "locale": "en-NZ",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Molly",
            "LocalName": "Molly",
            "ShortName": "en-NZ-MollyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "119",
            "LocaleDescription": "en-NZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MollyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-NZ",
            "localeZH": "英语(新西兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/124fcab4-3b16-43d6-9b84-e7c883aba381.wav?sv=2019-07-07&sr=b&sig=Jol9kD0zko4iHSTyhCFKSCIexZ7ehZZX2U6QV36yA9Y%3D&st=2021-10-29T08:26:33Z&se=2121-10-05T08:31:33Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8763bcde-b893-4e6d-852d-26d9cd967f0e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-PA, MargaritaNeural)",
        "shortName": "es-PA-MargaritaNeural",
        "locale": "es-PA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Margarita",
            "LocalName": "Margarita",
            "ShortName": "es-PA-MargaritaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "207",
            "LocaleDescription": "es-PA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MargaritaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-PA",
            "localeZH": "西班牙语(巴拿马)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/894e2466-21b9-4f46-b0e1-76406161d70e.wav?sv=2019-07-07&sr=b&sig=EHfz45bjj%2BHdapvn6IR1IYg4SmhPyBm0b8ML7djX4tM%3D&st=2021-10-29T08:30:48Z&se=2121-10-05T08:35:48Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f86b8aff-fccb-4d98-a6dc-26eb83bf8ef6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-MA, JamalNeural)",
        "shortName": "ar-MA-JamalNeural",
        "locale": "ar-MA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Jamal",
            "LocalName": "جمال",
            "ShortName": "ar-MA-JamalNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "23",
            "LocaleDescription": "ar-MA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "JamalNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-MA",
            "localeZH": "阿拉伯语(摩洛哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a9da0578-2091-464a-ac84-86f5c9ee7ba9.wav?sv=2019-07-07&sr=b&sig=nEwROuRlX%2Bz5MKFPWI2Y2bAsK6%2FI6B4omfb%2FQTvz6d8%3D&st=2021-10-29T08:30:11Z&se=2121-10-05T08:35:11Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "954eda91-3108-4486-8143-26edb95e4e7f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, VeraNeural)",
        "shortName": "es-ES-VeraNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Vera",
            "LocalName": "Vera",
            "ShortName": "es-ES-VeraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "182",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "VeraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fe74029e-c21c-46e6-bb5e-e2a9896f70bd.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A59Z&se=2122-09-27T07%3A51%3A59Z&sr=b&sp=rl&sig=VS6jXsnsUb9uPdEMrqV1%2Fcxki7tBFKK2SjlCziFpRZ8%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "50b742e4-b3e5-4f11-bedf-28a1b81188c7"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, JennyMultilingualNeural)",
        "shortName": "en-US-JennyMultilingualNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Jenny Multilingual",
            "LocalName": "Jenny Multilingual",
            "ShortName": "en-US-JennyMultilingualNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "de-DE,en-AU,en-CA,en-GB,es-ES,es-MX,fr-CA,fr-FR,it-IT,ja-JP,ko-KR,pt-BR,zh-CN",
            "OrderInVoiceListApi": "127",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "JennyMultilingualNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [
                {
                    "locale": "de-DE",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b480a57c-be19-4cbb-975a-11249d411d27.wav?sv=2019-07-07&sr=b&sig=Mk%2FM5wTM%2B2HFy5gSSQDqufWs7JBcYML4TzX%2BLJ8ua30%3D&st=2021-10-29T08:24:58Z&se=2121-10-05T08:29:58Z&sp=rl"
                },
                {
                    "locale": "en-AU",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c1e33257-0472-4fb1-8745-f78473d4f7be.wav?sv=2019-07-07&sr=b&sig=XmVEwoZI4szB%2Fg8gxtiF%2FeWCixybsGf8jw%2BhCQEZYms%3D&st=2021-10-29T08:24:59Z&se=2121-10-05T08:29:59Z&sp=rl"
                },
                {
                    "locale": "en-CA",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/888bcfdd-35a3-4a08-965c-551d3f2a77fb.wav?sv=2019-07-07&sr=b&sig=4LczckirqW040KTyaLyjukRFVBZC3w%2BdfAqE%2FlBKjNY%3D&st=2021-10-29T08:25:00Z&se=2121-10-05T08:30:00Z&sp=rl"
                },
                {
                    "locale": "en-GB",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a68c5fc0-74b4-4b5e-8057-6cf2d39106a1.wav?sv=2019-07-07&sr=b&sig=QNHM932Ptc8cYyIdnRivuRt31XGewZjPLBXUI3LWvQ4%3D&st=2021-10-29T08:25:01Z&se=2121-10-05T08:30:01Z&sp=rl"
                },
                {
                    "locale": "es-ES",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c81e6516-66a0-48e1-bcfb-73342cbba4e8.wav?sv=2019-07-07&sr=b&sig=0oFdVeDv8tticsB4cUXudskHenyYhmhCHqZt8DOoKGE%3D&st=2021-10-29T08:25:03Z&se=2121-10-05T08:30:03Z&sp=rl"
                },
                {
                    "locale": "es-MX",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8ba9d11e-d0b7-41ac-bd22-0270368c4122.wav?sv=2019-07-07&sr=b&sig=anf5V5fdp74Ncj8u2Am2rwS9VOclmS0vKwrapRGnnM4%3D&st=2021-10-29T08:25:04Z&se=2121-10-05T08:30:04Z&sp=rl"
                },
                {
                    "locale": "fr-CA",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9487f1f9-c398-487d-949b-05a0575a700b.wav?sv=2019-07-07&sr=b&sig=tkgb7OqHvWF6Ma%2FEdi9OG%2FPOswYvwgyQ4vnNWB9l1uc%3D&st=2021-10-29T08:25:05Z&se=2121-10-05T08:30:05Z&sp=rl"
                },
                {
                    "locale": "fr-FR",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d8c8c739-e5c2-4c34-8c8e-7f72ad5bb647.wav?sv=2019-07-07&sr=b&sig=rM%2FRvpnOw1NeCCzah7%2F8%2F%2FcsulM%2FR0UgkH3P0VTFS2U%3D&st=2021-10-29T08:25:06Z&se=2121-10-05T08:30:06Z&sp=rl"
                },
                {
                    "locale": "it-IT",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f10cbf0e-8528-47b3-b21e-9dd8150ac5f8.wav?sv=2019-07-07&sr=b&sig=HfDUVkAaktzWilx2PtmGeCyq0PG5FXRRCLGdGSSXoCA%3D&st=2021-10-29T08:25:07Z&se=2121-10-05T08:30:07Z&sp=rl"
                },
                {
                    "locale": "ja-JP",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2bf592dc-c38b-4acf-9f5f-295d4d53863e.wav?sv=2019-07-07&sr=b&sig=8JDGbQb33uygZXuUChOsJKXACKga2YUgXHFTxOkzT4Q%3D&st=2021-10-29T08:25:08Z&se=2121-10-05T08:30:08Z&sp=rl"
                },
                {
                    "locale": "ko-KR",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/44c773f0-cd64-44f2-94ab-adb95a100bb0.wav?sv=2019-07-07&sr=b&sig=m%2BGf8VYWQBXB7LyjkXhZvkMSIZF7lzG5Ta8X65hHDuo%3D&st=2021-10-29T08:25:09Z&se=2121-10-05T08:30:09Z&sp=rl"
                },
                {
                    "locale": "pt-BR",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fe509380-d53c-45fe-bfa5-8da596701253.wav?sv=2019-07-07&sr=b&sig=vldSrqTLBmw9qZzH54QreK9nmjzSGB8AsqyriN5d6Fg%3D&st=2021-10-29T08:25:10Z&se=2121-10-05T08:30:10Z&sp=rl"
                },
                {
                    "locale": "zh-CN",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/09b22762-413c-499c-a676-53ff805b3e5f.wav?sv=2019-07-07&sr=b&sig=qvN0ivvtZA%2B2ul%2BLc75YU3W06N5rwo2XGkhFehBd9P4%3D&st=2021-10-29T08:25:12Z&se=2121-10-05T08:30:12Z&sp=rl"
                }
            ],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a06750a5-97e7-496c-8f1d-83ad74a1bff3.wav?sv=2019-07-07&sr=b&sig=6EDl4Q0V6NpAiaWvFkglbXXVvD%2BKw7oxTN%2BYe0gqLV8%3D&st=2021-10-29T08:25:47Z&se=2121-10-05T08:30:47Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "19eaa6ae-0655-4704-928b-28e1f1b917b2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-OM, AbdullahNeural)",
        "shortName": "ar-OM-AbdullahNeural",
        "locale": "ar-OM",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Abdullah",
            "LocalName": "عبدالله",
            "ShortName": "ar-OM-AbdullahNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "25",
            "LocaleDescription": "ar-OM",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AbdullahNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-OM",
            "localeZH": "阿拉伯语(阿曼)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/81878370-c06e-4507-ab32-349d85f41f0c.wav?sv=2019-07-07&sr=b&sig=29XekzumkKhVguD2wFke%2BfoWMZYiEuoD6lSG%2B3zDXUk%3D&st=2022-07-01T09:08:47Z&se=2122-06-07T09:13:47Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "79c1cc71-a4e8-4981-bd8d-2921d82d4230"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (cy-GB, NiaNeural)",
        "shortName": "cy-GB-NiaNeural",
        "locale": "cy-GB",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Nia",
            "LocalName": "Nia",
            "ShortName": "cy-GB-NiaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "53",
            "LocaleDescription": "Welsh (UK)",
            "PreviewSentence": "Mae’r feddalwedd creu cynnwys sain yn galluogi rheoli priodoleddau lleferydd yn weledol mewn amser real.",
            "DisplayVoiceName": "NiaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "cy-GB",
            "localeZH": "威尔士语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/46062812-2276-4daa-ba79-dff498534e6f.wav?sv=2019-07-07&sr=b&sig=4fN6RVo5mAcC3sYLWTKyevRjDSNXO1UutbC25j9c8V4%3D&st=2021-10-29T08:26:07Z&se=2121-10-05T08:31:07Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5f44b500-0472-4596-a79d-29be8b3fb6d3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (nb-NO, PernilleNeural)",
        "shortName": "nb-NO-PernilleNeural",
        "locale": "nb-NO",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Pernille",
            "LocalName": "Pernille",
            "ShortName": "nb-NO-PernilleNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "335",
            "LocaleDescription": "Norwegian",
            "PreviewSentence": "Bygger apper og tjenester som snakker naturlig med brukerne, utbedrer tilgjengelighet og brukskvalitet.",
            "DisplayVoiceName": "PernilleNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "nb-NO",
            "localeZH": "书面挪威语(挪威)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4b5366af-5ce9-42f6-bfb0-ba3f741344af.wav?sv=2019-07-07&sr=b&sig=y9bUIUELAR6YzILAM1rlETcOXaH2tUSvIFrC0o%2FpjR4%3D&st=2021-10-29T08:27:39Z&se=2121-10-05T08:32:39Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d278fb66-0bd9-4706-a194-29f10970f2e4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, IrmaNeural)",
        "shortName": "it-IT-IrmaNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Irma",
            "LocalName": "Irma",
            "ShortName": "it-IT-IrmaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "284",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "IrmaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6bd2e2f7-4957-450d-b767-49c48cb27806.wav?sv=2019-07-07&sr=b&sig=cISTKAOaknRbae9uC%2BymjGMBFdYuCKjud3lKYoONTvM%3D&st=2022-07-01T09:09:47Z&se=2122-06-07T09:14:47Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6f91cbf3-5833-4dbd-aaab-2a7d54ddf3f1"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pl-PL, AgnieszkaNeural)",
        "shortName": "pl-PL-AgnieszkaNeural",
        "locale": "pl-PL",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Agnieszka",
            "LocalName": "Agnieszka",
            "ShortName": "pl-PL-AgnieszkaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "345",
            "LocaleDescription": "Polish",
            "PreviewSentence": "Twórz aplikacje i serwisy, które w kontakcie z użytkownikiem posługują się naturalną mową, co podnosi ich dostępność i użyteczność.",
            "DisplayVoiceName": "AgnieszkaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pl-PL",
            "localeZH": "波兰语(波兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f4eec98a-baaa-410c-a475-32148822ed39.wav?sv=2019-07-07&sr=b&sig=D8oV4EDPcmUpP0p8KI1OQJCqVZ2eGW38M2hJLI0ThTw%3D&st=2021-10-29T08:27:48Z&se=2121-10-05T08:32:48Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ef9c11c7-07ce-476f-871d-2b7f31a7c48b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-SV, LorenaNeural)",
        "shortName": "es-SV-LorenaNeural",
        "locale": "es-SV",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Lorena",
            "LocalName": "Lorena",
            "ShortName": "es-SV-LorenaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "215",
            "LocaleDescription": "es-SV",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LorenaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-SV",
            "localeZH": "西班牙语(萨尔瓦多)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2c0fff15-407a-4dcd-b1b7-e3216cc7df88.wav?sv=2019-07-07&sr=b&sig=nn%2FCOG2UGNBMiSWjHrl4SX4n7vINWerpkf3%2BkuaakGQ%3D&st=2021-10-29T08:30:56Z&se=2121-10-05T08:35:56Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5db44c75-2d71-44b9-b82d-2bce134c4c2e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, KillianNeural)",
        "shortName": "de-DE-KillianNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Killian",
            "LocalName": "Killian",
            "ShortName": "de-DE-KillianNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "67",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "KillianNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/182d805b-f3d3-4ca3-b728-5b73f698f4f8.wav?sv=2019-07-07&sr=b&sig=8ctkmB8ZK68YeEckHk%2BRIp3vAn7zcm%2FpFkxb8%2FjJJUA%3D&st=2022-01-19T09:00:34Z&se=2121-12-26T09:05:34Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "daa147ce-c7af-4a97-9e37-2dd923df4433"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, TimNeural)",
        "shortName": "en-AU-TimNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Tim",
            "LocalName": "Tim",
            "ShortName": "en-AU-TimNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "88",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "TimNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/007b429c-35a3-460b-9485-ef5dd7595734.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A19Z&se=2122-09-27T07%3A51%3A19Z&sr=b&sp=rl&sig=eW5HsqeWMvnmTThQxNkM0Ztz1EruhQ%2FNfSBcBogBP7U%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7676f89d-cacf-492b-889d-2e7b897bcde4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (bg-BG, KalinaNeural)",
        "shortName": "bg-BG-KalinaNeural",
        "description": "",
        "locale": "bg-BG",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Kalina",
            "LocalName": "Калина",
            "ShortName": "bg-BG-KalinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "40",
            "LocaleDescription": "Bulgarian",
            "PreviewSentence": "Създай приложения и услуги, които говорят непринудено на потребителите, подобрявайки достъпността и използваемостта.",
            "DisplayVoiceName": "KalinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "bg-BG",
            "localeZH": "保加利亚语(保加利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c80e2297-19a7-4a1b-afaa-cfd54c9210cb.wav?sv=2019-07-07&sr=b&sig=DAcY60cSlpDi3F81BC7AUWNjpCDDDig4j5oQ5SaXkP4%3D&st=2021-10-29T08:26:00Z&se=2121-10-05T08:31:00Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5e4d2532-06f2-4773-b563-2f946289aadf"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, YunjianNeural)",
        "shortName": "zh-CN-YunjianNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "narration-relaxed,sports-commentary,sports-commentary-excited,Default",
            "VoiceStyleNameDefinitions": "{\"Default\":0}",
            "DisplayName": "Yunjian",
            "LocalName": "云健",
            "ShortName": "zh-CN-YunjianNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "439",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "YunjianNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/90edb4cb-2741-440a-8d75-c782ae67638a.wav?sv=2019-07-07&sr=b&sig=v%2ByGJiInKAGlKe0%2Bpy%2FKQT7WyBkLzCjtv%2B6UR4wGTrY%3D&st=2022-04-13T06:19:22Z&se=2122-03-20T06:24:22Z&sp=rl"
                },
                {
                    "styleName": "narration-relaxed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ec4a4360-f5a3-45d1-9853-ede25402b87d.wav?sv=2019-07-07&sr=b&sig=60nyIZzHCnBBuC%2Bi4QYkUU19IABwQhBU4pN1mEaJA34%3D&st=2022-04-12T10:03:03Z&se=2122-03-19T10:08:03Z&sp=rl"
                },
                {
                    "styleName": "sports-commentary",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f3470c00-752e-41f4-a88f-501d62a4b234.wav?sv=2019-07-07&sr=b&sig=JmFizCOsBSsZaWcZZOrOkTzFkDH78GDl5rIYKRHUTZE%3D&st=2022-04-12T10:03:07Z&se=2122-03-19T10:08:07Z&sp=rl"
                },
                {
                    "styleName": "sports-commentary-excited",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/82a3257e-46ff-4a1a-b381-9bb1e3d6e532.wav?sv=2019-07-07&sr=b&sig=uTzBJBpsR1KNXr1wagbZDIW918jZzt73i4NXhjt8kWI%3D&st=2022-04-12T10:03:05Z&se=2122-03-19T10:08:05Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "39947851-46d7-4561-8199-2fd8bdc49ba6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-BE, GerardNeural)",
        "shortName": "fr-BE-GerardNeural",
        "locale": "fr-BE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gerard",
            "LocalName": "Gerard",
            "ShortName": "fr-BE-GerardNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "235",
            "LocaleDescription": "French (Belgium)",
            "PreviewSentence": "La Création de Contenu Audio vous permet de contrôler visuellement les attributs vocaux en temps réel.",
            "DisplayVoiceName": "GerardNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-BE",
            "localeZH": "法语(比利时)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b76d8c67-ad9b-431f-b33e-a99f3224210c.wav?sv=2019-07-07&sr=b&sig=q7rsrms9xpyXqmJjt9BwEMqQxriVnTduQyWOSQ1C7Vw%3D&st=2021-10-29T08:26:55Z&se=2121-10-05T08:31:55Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8466e484-7aee-4c7a-85c3-30d59b533ad4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, YagoNeural)",
        "shortName": "es-MX-YagoNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yago",
            "LocalName": "Yago",
            "ShortName": "es-MX-YagoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "204",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "YagoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4e668667-ce5e-4a06-a1dd-61218015eae1.wav?sv=2019-07-07&sr=b&sig=4kNd9Xq6cXLXMnvGOT5pBBt6%2B2%2BkEhkL0iBMyu%2FGs%2Fg%3D&st=2022-07-01T09:09:28Z&se=2122-06-07T09:14:28Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f4b9fd8a-fad9-44f0-b5f0-3219888d07fd"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-KE, AsiliaNeural)",
        "shortName": "en-KE-AsiliaNeural",
        "locale": "en-KE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Asilia",
            "LocalName": "Asilia",
            "ShortName": "en-KE-AsiliaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "114",
            "LocaleDescription": "en-KE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AsiliaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-KE",
            "localeZH": "英语(肯尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/15ed4dae-ce50-4489-b578-7cd8183dfe25.wav?sv=2019-07-07&sr=b&sig=ulprV%2FHA3V7PJjSw37Xt8j%2F6PrJBXd0AxC1UesrwjWU%3D&st=2021-10-29T08:30:23Z&se=2121-10-05T08:35:23Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "62bcf61d-7e9b-4f2d-b109-326d291f3197"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (nl-NL, ColetteNeural)",
        "shortName": "nl-NL-ColetteNeural",
        "description": "",
        "locale": "nl-NL",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Colette",
            "LocalName": "Colette",
            "ShortName": "nl-NL-ColetteNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "342",
            "LocaleDescription": "Dutch",
            "PreviewSentence": "Ontwikkel apps en diensten die natuurlijk aanvoelen, waardoor de toegankelijkheid en bruikbaarheid vergroot worden.",
            "DisplayVoiceName": "ColetteNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "nl-NL",
            "localeZH": "荷兰语(荷兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9edef43c-212b-45b4-a9db-09bc222e7669.wav?sv=2019-07-07&sr=b&sig=zsQQMM1dP4h%2FPtNHv8t0bm%2BsgYm6DvB4EbWm8wQPmbE%3D&st=2021-10-29T08:27:43Z&se=2121-10-05T08:32:43Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "632392e6-d5af-4876-9417-32d19424e5b6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, GiovannaNeural)",
        "shortName": "pt-BR-GiovannaNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Giovanna",
            "LocalName": "Giovanna",
            "ShortName": "pt-BR-GiovannaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "356",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "GiovannaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/757826d2-9ac2-428c-83d4-758f4d0aeae5.wav?sv=2019-07-07&sr=b&sig=AlT7vBk3eZLOd0UcVa5Dle8HCXH%2BtFZ5Gnyernd1WJM%3D&st=2022-07-01T09:10:20Z&se=2122-06-07T09:15:20Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c101b3fa-3990-4943-b9fa-330f269e6d35"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaoyanNeural)",
        "shortName": "zh-CN-XiaoyanNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Xiaoyan",
            "LocalName": "晓颜",
            "ShortName": "zh-CN-XiaoyanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "YoungAdult",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7ce55c87-6677-4bba-a45c-ec8bc0a7a876.png?sv=2019-07-07&sr=b&sig=RErsyLJTYyf7eiRgZxbbVXlmmQCtNi79ba7cDTS69l4%3D&st=2021-10-29T08:24:36Z&se=2121-10-05T08:29:36Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "433",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaoyanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "CustomerService"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "CustomerService"
                ],
                "title": "晓颜客服对话展示",
                "titleLocalizationId": "zh-CN-XiaoyanNeural_Masterpieces_CustomerService_Conversation_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/89ecb4a5-5b99-4754-86ad-7071e57169f9.wav?sv=2019-07-07&sr=b&sig=2wNrPq7XysOY2Y2K798XS0igHvgQd%2FfieRjpr0wwWFc%3D&st=2021-10-29T08:31:54Z&se=2121-10-05T08:36:54Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2ec6251b-a67e-442d-af86-1b61a1ea5a18.wav?sv=2019-07-07&sr=b&sig=rvBt9MB%2BxRKcxOhJErRc4Ukrw5s2VpDmuqK22lDl7NI%3D&st=2021-10-29T08:29:47Z&se=2121-10-05T08:34:47Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8190b804-6f50-4ad6-9b9d-332a4d3bf521"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (gl-ES, RoiNeural)",
        "shortName": "gl-ES-RoiNeural",
        "locale": "gl-ES",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Roi",
            "LocalName": "Roi",
            "ShortName": "gl-ES-RoiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "257",
            "LocaleDescription": "gl-ES",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "RoiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "gl-ES",
            "localeZH": "加利西亚语(加利西亚语)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e0effa4a-ead4-4bad-a25e-3cca92683a05.wav?sv=2019-07-07&sr=b&sig=JA339cwp5%2FJAxlRkqT1wo67SoNlZllZu8L8Vdez5JUU%3D&st=2021-10-29T08:31:05Z&se=2121-10-05T08:36:05Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "77988ee6-38e7-4b0a-ba91-33d88b3a42b0"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-SY, LaithNeural)",
        "shortName": "ar-SY-LaithNeural",
        "locale": "ar-SY",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Laith",
            "LocalName": "ليث",
            "ShortName": "ar-SY-LaithNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "32",
            "LocaleDescription": "ar-SY",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LaithNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-SY",
            "localeZH": "阿拉伯语(叙利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/de6fe50c-875f-4a4f-bba4-6e907fc607c1.wav?sv=2019-07-07&sr=b&sig=hRmMbwd7c9bZg3Ga40CaSqXZp5qMfpFZ1lkivqZ2PzI%3D&st=2021-10-29T08:30:16Z&se=2121-10-05T08:35:16Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1152d3cc-8fd1-4448-8935-3475650a83a1"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, AmberNeural)",
        "shortName": "en-US-AmberNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Amber",
            "LocalName": "Amber",
            "ShortName": "en-US-AmberNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "129",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AmberNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/16c936b1-cfbc-4a82-9335-e57fae5b4690.wav?sv=2019-07-07&sr=b&sig=Z6tVYv4bFfcgsR1Nh8buIid5mDxtQtyd4E%2FF8peCR3c%3D&st=2021-10-29T08:25:13Z&se=2121-10-05T08:30:13Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "814db6e1-ce6e-4b8a-9c10-347943910d18"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, AntonioNeural)",
        "shortName": "pt-BR-AntonioNeural",
        "description": "",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Antonio",
            "LocalName": "Antônio",
            "ShortName": "pt-BR-AntonioNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "351",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "AntonioNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c09f225d-72d6-4d55-adec-86a9ff411214.wav?sv=2019-07-07&sr=b&sig=bQW0qGRe46oIov3SjGC%2FcjgrQBwuDysFjdMNX%2BSzLrg%3D&st=2021-10-29T08:27:52Z&se=2121-10-05T08:32:52Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "89523202-fee2-410b-8a71-355e59bdaa21"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (am-ET, AmehaNeural)",
        "shortName": "am-ET-AmehaNeural",
        "locale": "am-ET",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ameha",
            "LocalName": "አምሀ",
            "ShortName": "am-ET-AmehaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "3",
            "LocaleDescription": "am-ET",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AmehaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "am-ET",
            "localeZH": "阿姆哈拉语(埃塞俄比亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0ee26f5f-b295-4062-87f5-7389bdfc5105.wav?sv=2019-07-07&sr=b&sig=gNIz%2FQKypQIaWWgSrSDor%2FK0I2j%2BlTue5cpmJwoywwY%3D&st=2021-10-29T08:29:56Z&se=2121-10-05T08:34:56Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6c4d0fa4-d47f-4e37-9d25-357d84cb02c3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ta-SG, AnbuNeural)",
        "shortName": "ta-SG-AnbuNeural",
        "locale": "ta-SG",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Anbu",
            "LocalName": "அன்பு",
            "ShortName": "ta-SG-AnbuNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "400",
            "LocaleDescription": "ta-SG",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AnbuNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ta-SG",
            "localeZH": "泰米尔语(新加坡)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d63dbcba-3e93-4365-b150-145ad2acab79.wav?sv=2019-07-07&sr=b&sig=Nnj9Hqc1NFweXrlSPOuchOBVxHzsF5TrMGDZh2WWYFk%3D&st=2021-10-29T08:31:21Z&se=2121-10-05T08:36:21Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7b34b246-014f-4fea-9b47-3597b18778a9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, CelesteNeural)",
        "shortName": "fr-FR-CelesteNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Celeste",
            "LocalName": "Celeste",
            "ShortName": "fr-FR-CelesteNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "243",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "CelesteNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b9aae947-3622-4bc9-aa24-b52a304d8195.wav?sv=2019-07-07&sr=b&sig=5%2BVGgdktTSKb3MgHtIHq4oRs8o32IyAN45uemKJbN9g%3D&st=2022-01-19T09:01:22Z&se=2121-12-26T09:06:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "86ad0be8-ef3a-4e4b-a026-35e5c51153eb"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ko-KR, InJoonNeural)",
        "shortName": "ko-KR-InJoonNeural",
        "description": "",
        "locale": "ko-KR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "InJoon",
            "LocalName": "인준",
            "ShortName": "ko-KR-InJoonNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "308",
            "LocaleDescription": "Korean",
            "PreviewSentence": "사용자들에게 자연스럽게 이야기하는 앱과 서비스를 만들며 접근성과 사용성을 개선시킵니다.",
            "DisplayVoiceName": "InJoonNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ko-KR",
            "localeZH": "韩语(韩国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/98eb2b15-796a-44c3-8619-ff9e71c090b6.wav?sv=2019-07-07&sr=b&sig=e8yXJ7c8F5LJdj4nIRXtYDiKGlDpJPfMdmDwy7nLwvI%3D&st=2021-10-29T08:27:22Z&se=2121-10-05T08:32:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "662c6e95-d86c-490b-928d-3836034ffc42"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-CR, JuanNeural)",
        "shortName": "es-CR-JuanNeural",
        "locale": "es-CR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Juan",
            "LocalName": "Juan",
            "ShortName": "es-CR-JuanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "161",
            "LocaleDescription": "es-CR",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "JuanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-CR",
            "localeZH": "西班牙语(哥斯达黎加)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/19190158-0acd-4bb8-8bc0-b445278dde4e.wav?sv=2019-07-07&sr=b&sig=JxiZRiTrEn6D49ym2eNl0MB6h5XLgdyjjf3jFLjQi1g%3D&st=2021-10-29T08:30:32Z&se=2121-10-05T08:35:32Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "80b67b7d-afee-4874-b394-394d8de13850"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ka-GE, GiorgiNeural)",
        "shortName": "ka-GE-GiorgiNeural",
        "locale": "ka-GE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Giorgi",
            "LocalName": "გიორგი",
            "ShortName": "ka-GE-GiorgiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "300",
            "LocaleDescription": "ka-GE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "GiorgiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ka-GE",
            "localeZH": "格鲁吉亚语(格鲁吉亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/492a0799-a46e-468d-8d62-7c921adba119.wav?sv=2019-07-07&sr=b&sig=jGUSIWLwmu%2FRX8ELvAsINGXKjSGoLfBQbKKdP2fE1%2Fk%3D&st=2022-07-01T09:10:00Z&se=2122-06-07T09:15:00Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d05e2be8-ce1f-4b89-bf54-3984721887a4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, JorgeNeural)",
        "shortName": "es-MX-JorgeNeural",
        "description": "",
        "locale": "es-MX",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "cheerful,chat,Default",
            "VoiceStyleNameDefinitions": "{\"cheerful\":4,\"Default\":0}",
            "DisplayName": "Jorge",
            "LocalName": "Jorge",
            "ShortName": "es-MX-JorgeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "196",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "JorgeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fb9f06dd-aeb3-4423-a77d-d821dcf12934.wav?sv=2019-07-07&sr=b&sig=ZEMIZaKQLbAT8lOEjdCeDkyvytvohpMg2Jk7Cd%2F26HI%3D&st=2021-10-29T08:26:46Z&se=2121-10-05T08:31:46Z&sp=rl"
                },
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/76c6a7f9-76be-482c-bb88-2a4aa50f522b.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A01Z&se=2122-09-27T07%3A52%3A01Z&sr=b&sp=rl&sig=x9IxkciMnAKAXmb1kefR%2FEDm8axRxQjB7VdyojBXmqc%3D"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7da03ab3-a98a-4d59-b5bd-f6b682b941c3.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A03Z&se=2122-09-27T07%3A52%3A03Z&sr=b&sp=rl&sig=Buiz1fs1LkudmcnWnJTFrZIAEK88jROi0oYu5VDPJeQ%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ace72e9b-dd48-4374-b508-39af2d140d16"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaoyiNeural)",
        "shortName": "zh-CN-XiaoyiNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "angry,disgruntled,affectionate,cheerful,fearful,sad,embarrassed,serious,gentle,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"disgruntled\":5,\"affectionate\":9,\"cheerful\":4,\"fearful\":3,\"sad\":8,\"embarrassed\":1,\"serious\":6,\"gentle\":11,\"Default\":0}",
            "DisplayName": "Xiaoyi",
            "LocalName": "晓伊",
            "ShortName": "zh-CN-XiaoyiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "434",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaoyiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "affectionate",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8dca7a47-fadd-47da-b53b-18c72d11e770.wav?sv=2019-07-07&sr=b&sig=0NFDoj%2BFIUMovPxsxNyE1QL2Ni6i%2F5ZtYqxMfn0Qtgs%3D&st=2022-08-01T10:39:27Z&se=2122-07-08T10:44:27Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b0411bd8-ccd0-448b-bf31-9059c631aa82.wav?sv=2019-07-07&sr=b&sig=kTKG%2B%2FUjoeA5wyuczggLKYsEg5dy%2FvkLiSsRNfsVc1o%3D&st=2022-08-01T10:39:30Z&se=2122-07-08T10:44:30Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/934e1005-fecf-4583-9fd1-cb41b5363931.wav?sv=2019-07-07&sr=b&sig=gPibA1B5o778DFSa5qRmRJRAkJYmDR%2F%2BhukEAu6v%2B5c%3D&st=2022-08-01T10:39:32Z&se=2122-07-08T10:44:32Z&sp=rl"
                },
                {
                    "styleName": "disgruntled",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/603e0478-185e-4c68-957f-597c1accfea3.wav?sv=2019-07-07&sr=b&sig=Mi2F15S62r3tnGZ5WyJmxF%2FQEJi%2FB78eIxdocQ9f240%3D&st=2022-08-01T10:39:35Z&se=2122-07-08T10:44:35Z&sp=rl"
                },
                {
                    "styleName": "embarrassed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5250e1de-96d1-4928-a66d-4aa4ccf7f056.wav?sv=2019-07-07&sr=b&sig=45NNJpo%2F02LXda5gLuRpbegDHW%2FhCTFEZtY8BJAhVFg%3D&st=2022-08-01T10:39:38Z&se=2122-07-08T10:44:38Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5e4a3e8e-827b-4128-995f-1d037753be31.wav?sv=2019-07-07&sr=b&sig=QHdmx%2FjuwGPBsMe3Jgj%2Bb1r2BUpz%2FKln6OySwAkAHig%3D&st=2022-08-01T10:39:41Z&se=2122-07-08T10:44:41Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fd0cae08-8c8a-4586-9657-03af6b696f46.wav?sv=2019-07-07&sr=b&sig=006JMQfV%2BJl%2BvPACVMs%2B4%2Fnj%2BjsYjTTEEeleWaeF8wk%3D&st=2022-08-01T10:39:43Z&se=2122-07-08T10:44:43Z&sp=rl"
                },
                {
                    "styleName": "gentle",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/18c4fee8-72bd-4434-9f9e-f6ec11043358.wav?sv=2019-07-07&sr=b&sig=KJ6FBhKej53KML8BU72DIky8J0Kv5Lz%2F4IuKhmMEXsU%3D&st=2022-08-01T10:39:46Z&se=2122-07-08T10:44:46Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/623c8d2b-0fee-4e99-8f6c-80a176131f85.wav?sv=2019-07-07&sr=b&sig=amuCkshHZlGx37LLEbuSOSEXEaI24tGcSr6K5wA%2F770%3D&st=2022-08-01T10:39:49Z&se=2122-07-08T10:44:49Z&sp=rl"
                },
                {
                    "styleName": "serious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/84a256bf-76f9-4acb-8b48-5bad65939673.wav?sv=2019-07-07&sr=b&sig=PYYr7Y8ipG3FM0v4zdMBHFtZdV%2B%2F8ii%2BfMfnxbH4XV0%3D&st=2022-08-01T10:39:52Z&se=2122-07-08T10:44:52Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "38bb36cb-0dda-403c-b012-3b447db510c3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, BrandonNeural)",
        "shortName": "en-US-BrandonNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Brandon",
            "LocalName": "Brandon",
            "ShortName": "en-US-BrandonNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "133",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "BrandonNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0867127c-6078-4de7-ab37-81576a93a6bb.wav?sv=2019-07-07&sr=b&sig=358%2BaA9gu7Zu4gb77cx3%2BuUdNexvj8OVDG6YviD16ro%3D&st=2021-10-29T08:25:32Z&se=2121-10-05T08:30:32Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2380ef4f-34bb-4d06-b6e2-3bbf42621a26"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sv-SE, MattiasNeural)",
        "shortName": "sv-SE-MattiasNeural",
        "locale": "sv-SE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Mattias",
            "LocalName": "Mattias",
            "ShortName": "sv-SE-MattiasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "389",
            "LocaleDescription": "Swedish",
            "PreviewSentence": "Bygg appar och tjänster som talar naturligt till användarna, och förbättrar tillgänglighet och användbarhet.",
            "DisplayVoiceName": "MattiasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sv-SE",
            "localeZH": "瑞典语(瑞典)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d5f0b418-d063-41b8-8f27-d7bd243718cc.wav?sv=2019-07-07&sr=b&sig=%2B278BnO6Pk4fTzPi03N9TRlehgV5pn0GUvxN0P2FP8E%3D&st=2021-10-29T08:28:11Z&se=2121-10-05T08:33:11Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b99565a4-9413-4ad5-b1b0-3ceb4bf9ed48"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (az-AZ, BabekNeural)",
        "shortName": "az-AZ-BabekNeural",
        "locale": "az-AZ",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Babek",
            "LocalName": "Babək",
            "ShortName": "az-AZ-BabekNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "37",
            "LocaleDescription": "az-AZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "BabekNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "az-AZ",
            "localeZH": "阿塞拜疆语(阿塞拜疆) "
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/70a34498-9023-4759-bffc-12ed0c69fff7.wav?sv=2019-07-07&sr=b&sig=VuPOBpyfRR6HB4MHjv1Z9HFkWLraNE7NTXh02Ht2Kac%3D&st=2022-07-01T09:08:52Z&se=2122-06-07T09:13:52Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "803fad75-27ca-4d9e-99d9-3cf9bf365713"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (mk-MK, AleksandarNeural)",
        "shortName": "mk-MK-AleksandarNeural",
        "locale": "mk-MK",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Aleksandar",
            "LocalName": "Александар",
            "ShortName": "mk-MK-AleksandarNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "321",
            "LocaleDescription": "mk-MK",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AleksandarNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "mk-MK",
            "localeZH": "马其顿语(北马其顿)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7efcaca0-5639-4ee0-b23a-24825d6b89b5.wav?sv=2019-07-07&sr=b&sig=3cBQmtc4kTyoWFmB7cAh3pxdZCoRNUPWu9hEPS24UVg%3D&st=2022-01-19T09:02:02Z&se=2121-12-26T09:07:02Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6cf1db56-de08-493a-a757-3d9bbee7d7d6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-CA, AntoineNeural)",
        "shortName": "fr-CA-AntoineNeural",
        "locale": "fr-CA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Antoine",
            "LocalName": "Antoine",
            "ShortName": "fr-CA-AntoineNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "237",
            "LocaleDescription": "French (Canada)",
            "PreviewSentence": "Créer des applications et des services qui parlent aux utilisateurs, améliorant ainsi l’accessibilité et la facilité d’utilisation.",
            "DisplayVoiceName": "AntoineNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-CA",
            "localeZH": "法语(加拿大)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c506ebb2-ff4d-4a28-9f0e-090dbec86426.wav?sv=2019-07-07&sr=b&sig=z8hbRYBq%2BPKzvevrovCLmpCQdLROq4T%2FFbxOTtdXUjE%3D&st=2021-10-29T08:26:56Z&se=2121-10-05T08:31:56Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b8c2f01f-68d1-4341-b46f-3e7c67f1a149"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-DO, RamonaNeural)",
        "shortName": "es-DO-RamonaNeural",
        "locale": "es-DO",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ramona",
            "LocalName": "Ramona",
            "ShortName": "es-DO-RamonaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "166",
            "LocaleDescription": "es-DO",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "RamonaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-DO",
            "localeZH": "西班牙语(多米尼加共和国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/21cc3ece-bdc5-402d-988c-89cea1fdf345.wav?sv=2019-07-07&sr=b&sig=weBUrnkCgmSxqyNcivNAXuzScznSx1N3gY75FOiRapk%3D&st=2021-10-29T08:30:37Z&se=2121-10-05T08:35:37Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "92a6cc59-8b2b-4e31-bb80-3e8632111ae4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, TrianaNeural)",
        "shortName": "es-ES-TrianaNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Triana",
            "LocalName": "Triana",
            "ShortName": "es-ES-TrianaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "181",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "TrianaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/efa468bf-6bbb-4294-8b44-6703fa29c5e9.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A56Z&se=2122-09-27T07%3A51%3A56Z&sr=b&sp=rl&sig=VUjEYddffqp1mNZoOOzD4LAJfaKW24laLI%2BCM%2BZ4JB0%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6f16cbe3-335c-46fe-a509-3e8da79df90d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, YunhaoNeural)",
        "shortName": "zh-CN-YunhaoNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "advertisement-upbeat,Default",
            "VoiceStyleNameDefinitions": "{\"Default\":0}",
            "DisplayName": "Yunhao",
            "LocalName": "云皓",
            "ShortName": "zh-CN-YunhaoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "438",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "YunhaoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1bb3cb6b-2916-4c38-9b59-ce555af34714.wav?sv=2019-07-07&sr=b&sig=nXkSX2D%2BJ60H%2F3zKv27W9g8buPa6IL33HqFI%2BOuZWLk%3D&st=2022-04-28T07:18:47Z&se=2122-04-04T07:23:47Z&sp=rl"
                },
                {
                    "styleName": "Advertisement_upbeat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f22e8a87-0f88-40e8-9ea4-9e347b2ae0c4.wav?sv=2019-07-07&sr=b&sig=pLBpuHZL4e0hCCtqa10ax%2BhWBPx0tiS4d%2FgvG1dv%2BkY%3D&st=2022-04-28T07:18:44Z&se=2122-04-04T07:23:44Z&sp=rl"
                },
                {
                    "styleName": "Advertisement-upbeat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f22e8a87-0f88-40e8-9ea4-9e347b2ae0c4.wav?sv=2019-07-07&sr=b&sig=pLBpuHZL4e0hCCtqa10ax%2BhWBPx0tiS4d%2FgvG1dv%2BkY%3D&st=2022-04-28T07:18:44Z&se=2122-04-04T07:23:44Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "33583255-1cdd-4845-9f9f-3eb557ec2c59"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ja-JP, AoiNeural)",
        "shortName": "ja-JP-AoiNeural",
        "locale": "ja-JP",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Aoi",
            "LocalName": "碧衣",
            "ShortName": "ja-JP-AoiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "291",
            "LocaleDescription": "Japanese",
            "PreviewSentence": "アクセシビリティとユーザビリティを向上させながら、ユーザーに自然なことばを話すアプリとサービスを構築する",
            "DisplayVoiceName": "AoiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ja-JP",
            "localeZH": "日语(日本)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d4d02c8a-6d19-4c01-bd58-8ed58ee0a4d2.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A24Z&se=2122-09-27T07%3A52%3A24Z&sr=b&sp=rl&sig=zApsHIt6ntmPdn93iJA2LvyiZumxeEN%2FxroDuHBT%2BEo%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e9086169-7176-4afc-8b5e-3f06a3ad1fb3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (nl-NL, MaartenNeural)",
        "shortName": "nl-NL-MaartenNeural",
        "locale": "nl-NL",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Maarten",
            "LocalName": "Maarten",
            "ShortName": "nl-NL-MaartenNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "344",
            "LocaleDescription": "Dutch",
            "PreviewSentence": "Ontwikkel apps en diensten die natuurlijk aanvoelen, waardoor de toegankelijkheid en bruikbaarheid vergroot worden.",
            "DisplayVoiceName": "MaartenNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "nl-NL",
            "localeZH": "荷兰语(荷兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3d8c18d9-4d91-42cb-8bd8-f7bf28849cf2.wav?sv=2019-07-07&sr=b&sig=SrFVRkZpWxlyH%2BC4rtc7u8iMgrQcZ5KkNnrfG1nIHFk%3D&st=2021-10-29T08:27:47Z&se=2121-10-05T08:32:47Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c2936675-a301-488e-b13c-3ffec5a2edbe"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-SG, WayneNeural)",
        "shortName": "en-SG-WayneNeural",
        "locale": "en-SG",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Wayne",
            "LocalName": "Wayne",
            "ShortName": "en-SG-WayneNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "123",
            "LocaleDescription": "en-SG",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "WayneNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-SG",
            "localeZH": "英语(新加坡)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8d113bc3-3622-4196-9da5-8e01b1681144.wav?sv=2019-07-07&sr=b&sig=mzGnkWj3yqPbPHR%2FKVtioYPCUBwqUr6PcSIJaQ9Targ%3D&st=2022-07-03T04:14:37Z&se=2122-06-09T04:19:37Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e8cbc91c-6e36-4a26-a417-40c6765b738a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-HN, CarlosNeural)",
        "shortName": "es-HN-CarlosNeural",
        "locale": "es-HN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Carlos",
            "LocalName": "Carlos",
            "ShortName": "es-HN-CarlosNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "188",
            "LocaleDescription": "es-HN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "CarlosNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-HN",
            "localeZH": "西班牙语(洪都拉斯)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/493ed93a-78ad-4d38-97db-750760af2ce1.wav?sv=2019-07-07&sr=b&sig=wYNimvqWtWXEAhE%2FgTyb%2BUgUj87zOF%2F9P5ghHiUs1VA%3D&st=2021-10-29T08:30:44Z&se=2121-10-05T08:35:44Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "87d4f7cd-10dc-426b-8465-41a8a5b8fa12"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, MaisieNeural)",
        "shortName": "en-GB-MaisieNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Maisie",
            "LocalName": "Maisie",
            "ShortName": "en-GB-MaisieNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "100",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MaisieNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fb35070d-eca9-47ab-9a34-6438fe67160a.wav?sv=2019-07-07&sr=b&sig=4F%2F%2B6l43bM0X1XKIsCnrleCh8i47yKmaj1pFCghyRbM%3D&st=2022-01-19T09:01:06Z&se=2121-12-26T09:06:06Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "882abb1e-adef-47c6-9c0e-423e4bb1a2ab"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (so-SO, UbaxNeural)",
        "shortName": "so-SO-UbaxNeural",
        "locale": "so-SO",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ubax",
            "LocalName": "Ubax",
            "ShortName": "so-SO-UbaxNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "380",
            "LocaleDescription": "so-SO",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "UbaxNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "so-SO",
            "localeZH": "索马里语(索马里)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/13f47a53-1a1f-4ca8-82e5-8de186d301af.wav?sv=2019-07-07&sr=b&sig=npN9xxUcrI8K0RPzICKDkUpPQrg33pvrY5lx0wjkEoQ%3D&st=2021-10-29T08:31:14Z&se=2121-10-05T08:36:14Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "65cf2392-2e60-43af-b6a9-42eec2748f9e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (bn-BD, NabanitaNeural)",
        "shortName": "bn-BD-NabanitaNeural",
        "locale": "bn-BD",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Nabanita",
            "LocalName": "নবনীতা",
            "ShortName": "bn-BD-NabanitaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "41",
            "LocaleDescription": "bn-BD",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "NabanitaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "bn-BD",
            "localeZH": "孟加拉语(孟加拉)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/397bfb78-6f3d-42f3-a604-32b2efce1035.wav?sv=2019-07-07&sr=b&sig=Wj4Xiu9SGq%2FirDB9OOLwr7a2fZidt2KJSgvCrGA9PHk%3D&st=2021-10-29T08:30:21Z&se=2121-10-05T08:35:21Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f72fee1a-54ea-4186-a30e-430b14b96cc4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-QA, MoazNeural)",
        "shortName": "ar-QA-MoazNeural",
        "locale": "ar-QA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Moaz",
            "LocalName": "معاذ",
            "ShortName": "ar-QA-MoazNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "28",
            "LocaleDescription": "ar-QA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MoazNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-QA",
            "localeZH": "阿拉伯语(卡塔尔)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/150ba333-6b43-43e3-904e-be12f3bc15d7.wav?sv=2019-07-07&sr=b&sig=ARm6xz%2FbsVTx%2BlLjICyDWSmlOJEIWheviTzu2vse5i4%3D&st=2021-10-29T08:30:14Z&se=2121-10-05T08:35:14Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f710a1a0-ff4e-4eef-9909-44376390cea5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-TZ, ElimuNeural)",
        "shortName": "en-TZ-ElimuNeural",
        "locale": "en-TZ",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Elimu",
            "LocalName": "Elimu",
            "ShortName": "en-TZ-ElimuNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "124",
            "LocaleDescription": "en-TZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ElimuNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-TZ",
            "localeZH": "英语(坦桑尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/943e3c44-605e-4561-9ceb-3b84ad3502b8.wav?sv=2019-07-07&sr=b&sig=LHJTad5qCPMTKFs4o5MHH2CmG5zoSVmDyozCotakrms%3D&st=2021-10-29T08:30:27Z&se=2121-10-05T08:35:27Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e49606b3-34de-4579-bf43-4458fffd85e8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-TZ, ImaniNeural)",
        "shortName": "en-TZ-ImaniNeural",
        "locale": "en-TZ",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Imani",
            "LocalName": "Imani",
            "ShortName": "en-TZ-ImaniNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "125",
            "LocaleDescription": "en-TZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ImaniNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-TZ",
            "localeZH": "英语(坦桑尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f9f64db2-c055-4b3d-a231-5814a9237963.wav?sv=2019-07-07&sr=b&sig=%2Fi%2F63FPzkf1ApuW2j%2BQtVxyNOhhMYrG8S8FzQ0QWrFk%3D&st=2021-10-29T08:30:28Z&se=2121-10-05T08:35:28Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e9642536-74cd-4580-ba7b-459355d4168f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, DavisNeural)",
        "shortName": "en-US-DavisNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "chat,angry,cheerful,excited,friendly,hopeful,sad,shouting,terrified,unfriendly,whispering,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Davis",
            "LocalName": "Davis",
            "ShortName": "en-US-DavisNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "136",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "DavisNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f67d4510-0368-4477-a442-f5c8299ade13.wav?sv=2019-07-07&sr=b&sig=%2FYnFEVDxqnpTO%2FMfshbSoj784aNAefO6izOWqNfWbgQ%3D&st=2022-05-05T09:38:31Z&se=2122-04-11T09:43:31Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9c986c62-65a7-41d3-b9ba-21dbd7655eee.wav?sv=2019-07-07&sr=b&sig=nKVoQdnSH7Nb7feJgpdB8XvDe31P40W30q2hISW%2B5kc%3D&st=2022-04-28T10:27:01Z&se=2122-04-04T10:32:01Z&sp=rl"
                },
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7f56e8cd-6a34-4ade-ad86-572b2f43c2c8.wav?sv=2019-07-07&sr=b&sig=Be6BOmM1Pl6QB1OG70WUqBMXw0vrEO3JtNeuYYufIbg%3D&st=2022-05-05T09:38:35Z&se=2122-04-11T09:43:35Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e5ee759b-77f8-497f-bcce-c5aab00f5aa8.wav?sv=2019-07-07&sr=b&sig=%2BQ9BXNMpl3zhMjVD0P%2BiLd9wKeVOLg5qp%2FNg9zannsA%3D&st=2022-04-28T10:27:04Z&se=2122-04-04T10:32:04Z&sp=rl"
                },
                {
                    "styleName": "excited",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7501e596-8bb1-4973-ab39-43ef1cc8719d.wav?sv=2019-07-07&sr=b&sig=hoGJFp5%2Fo0MNusgg5MnEyHdlrTp3AjwbFdnXXtDtS8A%3D&st=2022-04-28T10:27:06Z&se=2122-04-04T10:32:06Z&sp=rl"
                },
                {
                    "styleName": "friendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6b419076-769c-47af-b30b-ef7bdcbf824b.wav?sv=2019-07-07&sr=b&sig=Txtx6UExlKg7gp%2FqSMnMiY6GQ5H5TC%2FlaVg5C3dC38Y%3D&st=2022-04-28T10:27:08Z&se=2122-04-04T10:32:08Z&sp=rl"
                },
                {
                    "styleName": "hopeful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ba5d2450-8f27-444e-9f37-90dde6a09503.wav?sv=2019-07-07&sr=b&sig=cA5HyxNsjF88VZZcYg%2F%2Bn2EWwiY5RrEFKW3129LKw8E%3D&st=2022-04-28T10:27:10Z&se=2122-04-04T10:32:10Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e083a4ae-d579-44b2-b9df-4294fc1d2981.wav?sv=2019-07-07&sr=b&sig=pjScu40TKa%2FHUx2QguG5t%2BVEKVxOH4uvjC5juOqLncs%3D&st=2022-04-28T10:27:13Z&se=2122-04-04T10:32:13Z&sp=rl"
                },
                {
                    "styleName": "shouting",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c740479c-a2b0-4df2-9cc5-0038a8577c8e.wav?sv=2019-07-07&sr=b&sig=27iuoKjjYYtow30AHuqrtMsbSV9DQyNZpnEWPSWBbiI%3D&st=2022-04-28T10:27:15Z&se=2122-04-04T10:32:15Z&sp=rl"
                },
                {
                    "styleName": "terrified",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d27366ab-e485-48d0-9d71-26a7221e942c.wav?sv=2019-07-07&sr=b&sig=uJC9bkFzM%2BBfLj6v4iiFF3j2mVykiGJ9UmSbqn6LstA%3D&st=2022-04-28T10:27:17Z&se=2122-04-04T10:32:17Z&sp=rl"
                },
                {
                    "styleName": "unfriendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fb59458e-d686-4a13-b143-8b481128159b.wav?sv=2019-07-07&sr=b&sig=dq1IEfmbR8k%2FYQzgkbbhqGk5TzS12%2BDOZo%2FsE1E97m4%3D&st=2022-04-28T10:27:19Z&se=2122-04-04T10:32:19Z&sp=rl"
                },
                {
                    "styleName": "whispering",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/66490161-58f1-4bb8-bc7b-0908479d4ebb.wav?sv=2019-07-07&sr=b&sig=58CiFhxM8gLuQOHKSWR%2Bfw8%2BENIjJeke6yJpRITpMm0%3D&st=2022-04-28T10:27:22Z&se=2122-04-04T10:32:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b5f86142-ce84-4483-8142-45db0d778add"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, ConradNeural)",
        "shortName": "de-DE-ConradNeural",
        "description": "",
        "locale": "de-DE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "cheerful,Default",
            "VoiceStyleNameDefinitions": "{\"cheerful\":4,\"Default\":0}",
            "DisplayName": "Conrad",
            "LocalName": "Conrad",
            "ShortName": "de-DE-ConradNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "74",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "ConradNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/735fc0e8-6a38-4a00-8356-929ef25d2279.wav?sv=2019-07-07&sr=b&sig=yZ76jzMmuuy4zniNTHeE7jIKdolKJq20T733vmAmsYQ%3D&st=2021-10-29T08:26:14Z&se=2121-10-05T08:31:14Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "865dd6ad-a19e-475b-86b9-464c889250a6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sr-RS, SophieNeural)",
        "shortName": "sr-RS-SophieNeural",
        "locale": "sr-RS",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sophie",
            "LocalName": "Софија",
            "ShortName": "sr-RS-SophieNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "384",
            "LocaleDescription": "sr-RS",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SophieNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sr-RS",
            "localeZH": "塞尔维亚语(塞尔维亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/134f99a5-2380-4087-baee-ea1481a60d61.wav?sv=2019-07-07&sr=b&sig=46NU8hLT5qoQjYWqZTCTamjlusNDg2%2BYUrY%2Bg%2B%2Fc%2BlA%3D&st=2022-01-19T09:02:22Z&se=2121-12-26T09:07:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "24760f62-1a7b-4b6f-a121-46b86bab164f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (kn-IN, SapnaNeural)",
        "shortName": "kn-IN-SapnaNeural",
        "locale": "kn-IN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sapna",
            "LocalName": "ಸಪ್ನಾ",
            "ShortName": "kn-IN-SapnaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "306",
            "LocaleDescription": "kn-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SapnaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "kn-IN",
            "localeZH": "埃纳德语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ef2e9d4c-ecdc-46f8-bd77-59f193cf211f.wav?sv=2019-07-07&sr=b&sig=1nAMjPNHWRg4JWEDRddBKFwYjprZAGBsJs5sx%2FbCsv0%3D&st=2022-01-19T09:01:56Z&se=2121-12-26T09:06:56Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1d77f6c6-6f94-4bef-884e-46f3a9e7c258"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-UY, MateoNeural)",
        "shortName": "es-UY-MateoNeural",
        "locale": "es-UY",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Mateo",
            "LocalName": "Mateo",
            "ShortName": "es-UY-MateoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "219",
            "LocaleDescription": "es-UY",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MateoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-UY",
            "localeZH": "西班牙语(乌拉圭)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/69065338-efaf-40d9-880c-2e138333c82e.wav?sv=2019-07-07&sr=b&sig=DPChWTekzsgPwMmnKoNpqJ86Bv0a5GeQgzktMkrv9I8%3D&st=2021-10-29T08:30:57Z&se=2121-10-05T08:35:57Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "57303f99-fbef-44bf-b291-4735f88f9a61"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, MarinaNeural)",
        "shortName": "es-MX-MarinaNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Marina",
            "LocalName": "Marina",
            "ShortName": "es-MX-MarinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "200",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "MarinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ef8f09c8-2dff-42f0-a1c1-43a6450c292b.wav?sv=2019-07-07&sr=b&sig=FDMlhJi2j3oNzmw7kjQ4jtBeWzLrraFWED7%2BAzo0aIk%3D&st=2022-07-01T09:09:19Z&se=2122-06-07T09:14:19Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8db5ae9b-9d62-48e3-ae1e-4899a2b2e053"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, JasonNeural)",
        "shortName": "en-US-JasonNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "angry,cheerful,excited,friendly,hopeful,sad,shouting,terrified,unfriendly,whispering,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Jason",
            "LocalName": "Jason",
            "ShortName": "en-US-JasonNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "141",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "JasonNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d91baad7-af08-40a7-aa12-142983ee5540.wav?sv=2019-07-07&sr=b&sig=Agrr1Y8DJjHq7w5eQ4V1GA3eqWU5UK26mlTujIY29T8%3D&st=2022-05-05T09:38:52Z&se=2122-04-11T09:43:52Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4490bb49-2c68-4267-b515-13b3906eef72.wav?sv=2019-07-07&sr=b&sig=lcSIr8vqtnzl9hW5NXsuXkUwLEPsaVDKVMfzIQIwTuU%3D&st=2022-04-28T10:27:47Z&se=2122-04-04T10:32:47Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c22e964e-166b-415c-a11e-4dc8fa0b1850.wav?sv=2019-07-07&sr=b&sig=ym7C9JnfduT8fOO59mnC7mNai1qtq8qvM8qkzHS%2FLDk%3D&st=2022-04-28T10:27:49Z&se=2122-04-04T10:32:49Z&sp=rl"
                },
                {
                    "styleName": "excited",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c01b0581-d9bd-4643-b68d-08f6415c8f90.wav?sv=2019-07-07&sr=b&sig=%2FVUe9782fJgBDFn1fNlcnLNo7%2BtIw1L%2Fhauipy8jjHU%3D&st=2022-04-28T10:27:51Z&se=2122-04-04T10:32:51Z&sp=rl"
                },
                {
                    "styleName": "friendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4b3450a5-9b64-4834-875d-ff57a87b91e9.wav?sv=2019-07-07&sr=b&sig=WQAIvc%2BxU1utV5fuvmqCtQvj%2BH5%2FUf016XnAmjEFPvk%3D&st=2022-04-28T10:27:54Z&se=2122-04-04T10:32:54Z&sp=rl"
                },
                {
                    "styleName": "hopeful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/609b0f08-7e35-4ee3-ab59-cda5321e10d3.wav?sv=2019-07-07&sr=b&sig=VEgybfyR3%2BTnv2miGfBHPVPSRwbc0ZWBRVthLBn5o8o%3D&st=2022-04-28T10:27:56Z&se=2122-04-04T10:32:56Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/53c5ff3f-48b4-4e97-9c1a-9f04b60f1d26.wav?sv=2019-07-07&sr=b&sig=Ab%2FPMCfyRtRLoV50BuSyrhD6YBpMi0oxJLp9QSdyhsI%3D&st=2022-04-28T10:27:58Z&se=2122-04-04T10:32:58Z&sp=rl"
                },
                {
                    "styleName": "shouting",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fbccc004-ff23-4d86-90f4-b6766d74f0e4.wav?sv=2019-07-07&sr=b&sig=5QpUD2Qb8s50upb%2FWGuyuRy%2Ff4OddpEodHgyYvLbo%2FQ%3D&st=2022-04-28T10:28:01Z&se=2122-04-04T10:33:01Z&sp=rl"
                },
                {
                    "styleName": "terrified",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/06b5569f-f055-4e26-9dd0-f7b2758af6cb.wav?sv=2019-07-07&sr=b&sig=wtFKkhYj%2BFUSGPfGAljsUMpdvFebqdLEKjVPZ3r%2Fa%2Bs%3D&st=2022-04-28T10:28:03Z&se=2122-04-04T10:33:03Z&sp=rl"
                },
                {
                    "styleName": "unfriendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7967cdb0-eee0-4975-bfce-08b3d57d65a9.wav?sv=2019-07-07&sr=b&sig=k885kwRb9v1Ud1YKB8gG7v80nBTvgF75raZ4KorpvLM%3D&st=2022-04-28T10:28:05Z&se=2122-04-04T10:33:05Z&sp=rl"
                },
                {
                    "styleName": "whispering",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/668ff93c-b99e-46c5-8a02-c45d23a6e03e.wav?sv=2019-07-07&sr=b&sig=tOHs4zf32RqWLTWrZ7znP5VrgHXfzTKLRi%2BEuEjh1Uk%3D&st=2022-04-28T10:28:07Z&se=2122-04-04T10:33:07Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "93cdc1ca-0ba2-4615-91ec-495bd6b40b3d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-HK, HiuGaaiNeural)",
        "shortName": "zh-HK-HiuGaaiNeural",
        "description": "",
        "locale": "zh-HK",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "HiuGaai",
            "LocalName": "曉佳",
            "ShortName": "zh-HK-HiuGaaiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "450",
            "LocaleDescription": "Chinese (Hong Kong)",
            "PreviewSentence": "開發可自然地與用戶溝通的應用程式及服務，以提升其使用度及可用性。",
            "DisplayVoiceName": "HiuGaaiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "zh-HK",
            "localeZH": "中文(粤语，繁体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3c5e20c1-8209-4367-bc69-e159fea8eebe.wav?sv=2019-07-07&sr=b&sig=n2vg6ynloycZTFiyRUi1J6Q%2FeEjJmH9KCcsmjPRcvv8%3D&st=2021-10-29T08:29:48Z&se=2121-10-05T08:34:48Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "43b6bf15-38b2-4df8-a439-498e3ed7bfc3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ca-ES, JoanaNeural)",
        "shortName": "ca-ES-JoanaNeural",
        "locale": "ca-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Joana",
            "LocalName": "Joana",
            "ShortName": "ca-ES-JoanaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "47",
            "LocaleDescription": "Catalan",
            "PreviewSentence": "Crea aplicacions i serveis que parlen de forma natural als usuaris, i que milloren l'accessibilitat i la facilitat d'ús.",
            "DisplayVoiceName": "JoanaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ca-ES",
            "localeZH": "加泰罗尼亚语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/26cbe67b-1673-4d25-bf17-c0995331e6b7.wav?sv=2019-07-07&sr=b&sig=78BaN3VccGs2oUd%2B4slFM5%2Frptt9CwN1cJZ1kIWjarI%3D&st=2021-10-29T08:26:03Z&se=2121-10-05T08:31:03Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "817b1bf6-0020-4d2b-a978-49ded1768b12"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ru-RU, DariyaNeural)",
        "shortName": "ru-RU-DariyaNeural",
        "description": "",
        "locale": "ru-RU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Dariya",
            "LocalName": "Дария",
            "ShortName": "ru-RU-DariyaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "371",
            "LocaleDescription": "Russian",
            "PreviewSentence": "Возможность создавать приложения и сервисы, которые естественным образом общаются с пользователями, улучшая доступность и удобство использования.",
            "DisplayVoiceName": "DariyaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ru-RU",
            "localeZH": "俄语(俄罗斯)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e3410eff-3be8-46af-9fff-6ba0c1f0545e.wav?sv=2019-07-07&sr=b&sig=g6KN7f%2BvZAvafBO1L%2FGGhD78hmwO5iXKiecuHnR6CuA%3D&st=2021-10-29T08:28:02Z&se=2121-10-05T08:33:02Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6d04d9b3-41f0-4c52-835b-4a353e799ab8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, SaraNeural)",
        "shortName": "en-US-SaraNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "angry,cheerful,excited,friendly,hopeful,sad,shouting,terrified,unfriendly,whispering,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Sara",
            "LocalName": "Sara",
            "ShortName": "en-US-SaraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "146",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SaraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/05a14c34-7f48-4c70-8e99-d8749a24d3a7.wav?sv=2019-07-07&sr=b&sig=uSOV%2BezeHBl0tfa5xJ9k2MtbvVpocN5MLOJIHzdPj7I%3D&st=2021-10-29T08:25:51Z&se=2121-10-05T08:30:51Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bf8d9029-d2da-4d44-bb45-630df0c08987.wav?sv=2019-07-07&sr=b&sig=mCjIsH6FK1UckGFOfGYezpjUtlu9UiLskJb2TCBeR3A%3D&st=2021-10-29T08:25:52Z&se=2121-10-05T08:30:52Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ea0e788b-93a3-49a9-b3d6-775ad24a4a0a.wav?sv=2019-07-07&sr=b&sig=rFk%2Bh%2FGR1IRSQzZ%2FJRP3gN0UGKSTG%2B1wdOvAadT5MnM%3D&st=2021-10-29T08:25:53Z&se=2121-10-05T08:30:53Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a03cbdcc-5369-46d1-ac22-c66ee37c93e1.wav?sv=2019-07-07&sr=b&sig=wHCFXPlo7lOg2%2Fc8%2FMvOFZyaUVvnQyPGJMJf527rpwM%3D&st=2021-10-29T08:25:54Z&se=2121-10-05T08:30:54Z&sp=rl"
                },
                {
                    "styleName": "excited",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a9947dc7-bb80-4455-9193-19a34da5b061.wav?sv=2019-07-07&sr=b&sig=57fz%2F2ax55JOZGvrwUM89barBUZuStZkw%2BUwNFVebuo%3D&st=2022-04-28T10:26:46Z&se=2122-04-04T10:31:46Z&sp=rl"
                },
                {
                    "styleName": "friendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/377c8d18-761b-4a53-be8c-0bfe5eeac34f.wav?sv=2019-07-07&sr=b&sig=018Cvmng605nULkBA4tQP8dCTImtEfnWPmRMo%2FsMDEw%3D&st=2022-04-28T10:26:48Z&se=2122-04-04T10:31:48Z&sp=rl"
                },
                {
                    "styleName": "hopeful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7f9ad302-e6c6-4521-a887-462aa97d63d4.wav?sv=2019-07-07&sr=b&sig=togFPD9fkufNQrzdkIQigdCs0os%2F7pSdjBYSeOFDF1I%3D&st=2022-04-28T10:26:50Z&se=2122-04-04T10:31:50Z&sp=rl"
                },
                {
                    "styleName": "shouting",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e1161fd7-fa8f-4b69-9ead-f589dbe99338.wav?sv=2019-07-07&sr=b&sig=6190x6A0Ev77JPdgseFpMS5jOnTuaVM8zy9t1Hz9dqA%3D&st=2022-04-28T10:26:53Z&se=2122-04-04T10:31:53Z&sp=rl"
                },
                {
                    "styleName": "terrified",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ab9ad803-3646-4a35-b3a8-d8ac840308f9.wav?sv=2019-07-07&sr=b&sig=HmcYdePtG%2B1FW66xtrMo5v67IYUzkKYuy6hMVEyIS78%3D&st=2022-04-28T10:26:55Z&se=2122-04-04T10:31:55Z&sp=rl"
                },
                {
                    "styleName": "unfriendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ca10fbbb-40d9-4693-94ad-9fff483fb192.wav?sv=2019-07-07&sr=b&sig=n4hyE0K7s1Zc80dkXVOLc6NKmh4tLg0j5HEtY3dj9Mo%3D&st=2022-04-28T10:26:57Z&se=2122-04-04T10:31:57Z&sp=rl"
                },
                {
                    "styleName": "whispering",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/34ed5c93-7578-4e11-9253-124a57f0e034.wav?sv=2019-07-07&sr=b&sig=EXlrt1LRP86wZEV7ljBxuz6708B3rqEwyhM3Qg0Wnd0%3D&st=2022-04-28T10:26:59Z&se=2122-04-04T10:31:59Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "38db11b6-fa64-4989-8d75-4a48695ee5cd"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-HK, YanNeural)",
        "shortName": "en-HK-YanNeural",
        "locale": "en-HK",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yan",
            "LocalName": "Yan",
            "ShortName": "en-HK-YanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "109",
            "LocaleDescription": "en-HK",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "YanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-HK",
            "localeZH": "英语(香港特别行政区)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/caaf35ae-387d-4a83-99f9-74b5a62679f2.wav?sv=2019-07-07&sr=b&sig=nlFZBLhzhjgG5BoK7MH07aS%2B2vDupW6WKZtC71H5RXg%3D&st=2021-10-29T08:26:27Z&se=2121-10-05T08:31:27Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "845b64ce-7525-49b4-9a5a-4c42b23ce64d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, IsabellaNeural)",
        "shortName": "it-IT-IsabellaNeural",
        "description": "",
        "locale": "it-IT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "cheerful,chat,Default",
            "VoiceStyleNameDefinitions": "{\"cheerful\":4,\"Default\":0}",
            "DisplayName": "Isabella",
            "LocalName": "Isabella",
            "ShortName": "it-IT-IsabellaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "275",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "IsabellaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5b5f4368-91d8-4253-98fe-848328d3af4d.wav?sv=2019-07-07&sr=b&sig=%2FIb64GCARSRi%2FOkF2yUsKfTMq7PSbNuDdNSgAvxhbZs%3D&st=2021-10-29T08:27:19Z&se=2121-10-05T08:32:19Z&sp=rl"
                },
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cc37df70-08ae-4557-b13f-df16c02ae630.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A19Z&se=2122-09-27T07%3A52%3A19Z&sr=b&sp=rl&sig=16tIK53mXg5H9P2zEsFuGZUIoXnoput8lNo33zgB1KI%3D"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cc98df98-c096-49e3-af49-9dca175fb876.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A21Z&se=2122-09-27T07%3A52%3A21Z&sr=b&sp=rl&sig=2%2FvsO%2F5o6LaY0vRtW3iqSEuJt%2BQS1ubxEPkwowhVKCQ%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0bad16a8-a63e-4e1d-bc80-4c88ddaf2b77"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (he-IL, HilaNeural)",
        "shortName": "he-IL-HilaNeural",
        "description": "",
        "locale": "he-IL",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Hila",
            "LocalName": "הילה",
            "ShortName": "he-IL-HilaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "262",
            "LocaleDescription": "Hebrew (Israel)",
            "PreviewSentence": "בנה יישומים ושירותים שמדברים בטבעיות למשתמשים, שמשפרים את  הנגישות והשימושיות.",
            "DisplayVoiceName": "HilaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "he-IL",
            "localeZH": "希伯来语(以色列)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a2a130fe-ab21-4e2f-a66b-377b69e620db.wav?sv=2019-07-07&sr=b&sig=ycKJ4ZRV%2FWK9ZcXXnmQ%2F0%2Bq0W%2FrlJ1Rpy%2BkQ8jwvd%2BE%3D&st=2021-10-29T08:27:08Z&se=2121-10-05T08:32:08Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "286a3a96-fa74-4489-bb0a-4db9f437d2a1"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, NatashaNeural)",
        "shortName": "en-AU-NatashaNeural",
        "description": "",
        "locale": "en-AU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Natasha",
            "LocalName": "Natasha",
            "ShortName": "en-AU-NatashaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "86",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "NatashaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3d28afc4-8a40-46f2-8d42-82d433254c86.wav?sv=2019-07-07&sr=b&sig=WTcYVq2eEiEiOL7p554SSaEBVlk5kgBHzZ5ZX3WOxMA%3D&st=2021-10-29T08:26:18Z&se=2121-10-05T08:31:18Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "40656072-27e0-4599-8cc4-4de109bcb0b1"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ca-ES, AlbaNeural)",
        "shortName": "ca-ES-AlbaNeural",
        "description": "",
        "locale": "ca-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Alba",
            "LocalName": "Alba",
            "ShortName": "ca-ES-AlbaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "48",
            "LocaleDescription": "Catalan",
            "PreviewSentence": "Crea aplicacions i serveis que parlen de forma natural als usuaris, i que milloren l'accessibilitat i la facilitat d'ús.",
            "DisplayVoiceName": "AlbaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ca-ES",
            "localeZH": "加泰罗尼亚语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cb0ad2fc-31fb-42f9-91e4-62ff22bd1e36.wav?sv=2019-07-07&sr=b&sig=lWyDoOAfR42fjVOgM1XkK7RsEow6UsQCl5%2BcUhl5za4%3D&st=2021-10-29T08:26:01Z&se=2121-10-05T08:31:01Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b06ff851-a50c-4e54-bf98-4ed52f0cb526"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (my-MM, NilarNeural)",
        "shortName": "my-MM-NilarNeural",
        "locale": "my-MM",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Nilar",
            "LocalName": "နီလာ",
            "ShortName": "my-MM-NilarNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "333",
            "LocaleDescription": "my-MM",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "NilarNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "my-MM",
            "localeZH": "缅甸语(缅甸)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2aace1bd-f2cc-4092-94f4-d766fea09b55.wav?sv=2019-07-07&sr=b&sig=D6v8yo2id6tomE767pVG%2FIs3DZcmQpV7azCfzQob2yU%3D&st=2021-10-29T08:31:11Z&se=2121-10-05T08:36:11Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ae0b8565-6ccc-462d-8fdd-4f5521dea6b4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, BrigitteNeural)",
        "shortName": "fr-FR-BrigitteNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Brigitte",
            "LocalName": "Brigitte",
            "ShortName": "fr-FR-BrigitteNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "242",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "BrigitteNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b8afe7a4-944b-492a-b3b1-bdcdabde6478.wav?sv=2019-07-07&sr=b&sig=44m7T38G1KGnKAL%2B46nS5vlH%2FKIWWl%2FeE3tzFwYreiQ%3D&st=2022-01-19T09:01:19Z&se=2121-12-26T09:06:19Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "730f985a-7223-4d6d-9bff-4fb76bdd4a0e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pl-PL, ZofiaNeural)",
        "shortName": "pl-PL-ZofiaNeural",
        "description": "",
        "locale": "pl-PL",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Zofia",
            "LocalName": "Zofia",
            "ShortName": "pl-PL-ZofiaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "347",
            "LocaleDescription": "Polish",
            "PreviewSentence": "Twórz aplikacje i serwisy, które w kontakcie z użytkownikiem posługują się naturalną mową, co podnosi ich dostępność i użyteczność.",
            "DisplayVoiceName": "ZofiaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pl-PL",
            "localeZH": "波兰语(波兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/417e79c0-8c4e-42b2-8ee9-cab9c31bda8d.wav?sv=2019-07-07&sr=b&sig=xBTF%2FjEyMYJJbb5eoytILjigqDI2yWgP8U8yifuHmkY%3D&st=2021-10-29T08:27:51Z&se=2121-10-05T08:32:51Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "621f531c-128b-4004-9c50-500d27a6c52a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (te-IN, MohanNeural)",
        "shortName": "te-IN-MohanNeural",
        "locale": "te-IN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Mohan",
            "LocalName": "మోహన్",
            "ShortName": "te-IN-MohanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "402",
            "LocaleDescription": "Telugu (India)",
            "PreviewSentence": "వినియోగం మరియు సౌలభ్యాన్ని మెరుగుపరిచే, సహజ శైలిలో మాట్లాడే అప్లికేషన్లు మరియు సేవలను అభివృద్ధి చేయండి.",
            "DisplayVoiceName": "MohanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "te-IN",
            "localeZH": "泰卢固语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/15235e9f-eb5f-4f73-8e58-8a8f5e4b01b1.wav?sv=2019-07-07&sr=b&sig=GpiCpTN1FxbgvW6b4UWX04mKE7DLDGkrMPzghZ%2F9Dqc%3D&st=2021-10-29T08:28:17Z&se=2121-10-05T08:33:17Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "db216550-1d31-4f8d-a052-5055ec63fc8d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ta-IN, ValluvarNeural)",
        "shortName": "ta-IN-ValluvarNeural",
        "locale": "ta-IN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Valluvar",
            "LocalName": "வள்ளுவர்",
            "ShortName": "ta-IN-ValluvarNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "395",
            "LocaleDescription": "Tamil (India)",
            "PreviewSentence": "பயனர்களிடம் இயற்கையாக பேசும் பயன்பாடுகள் மற்றும் சேவைகளை உருவாகுதல், இது அணுகல்தன்மை மற்றும் பயன்பாட்டினை மேம்படுத்தும்.",
            "DisplayVoiceName": "ValluvarNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ta-IN",
            "localeZH": "泰米尔语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/be283fe5-4754-4638-9565-2db5cb941069.wav?sv=2019-07-07&sr=b&sig=9qEFjG5XxTaTvlW8CmbMjzoKAYckED64NXc6aAibffU%3D&st=2021-10-29T08:28:16Z&se=2121-10-05T08:33:16Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8c9f6f0a-f349-4a59-b829-50f224817a46"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-CO, GonzaloNeural)",
        "shortName": "es-CO-GonzaloNeural",
        "locale": "es-CO",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gonzalo",
            "LocalName": "Gonzalo",
            "ShortName": "es-CO-GonzaloNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "159",
            "LocaleDescription": "es-CO",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "GonzaloNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-CO",
            "localeZH": "西班牙语(哥伦比亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2ad07c6b-4df7-4d88-b7ea-bcc297e3ecec.wav?sv=2019-07-07&sr=b&sig=atBxkxSy7yRU0qQxtAIUiZojlECXU22FXb5uCsUHA1w%3D&st=2021-10-29T08:26:42Z&se=2121-10-05T08:31:42Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b53bcfc5-812e-40cc-a3ce-50fdc560afcc"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sk-SK, LukasNeural)",
        "shortName": "sk-SK-LukasNeural",
        "locale": "sk-SK",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Lukas",
            "LocalName": "Lukáš",
            "ShortName": "sk-SK-LukasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "375",
            "LocaleDescription": "Slovak",
            "PreviewSentence": "Vytvárajú aplikácie a služby, ktoré prirodzene komunikujú s užívateľmi, čím sa zlepšuje dostupnosť a využiteľnosť.",
            "DisplayVoiceName": "LukasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sk-SK",
            "localeZH": "斯洛伐克语(斯洛伐克)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fbec18f9-560b-4552-9603-11ec4ebdc657.wav?sv=2019-07-07&sr=b&sig=QIpNS9wxzwT9cFjsMuka5GNDn5NltWdmN8wkvU3%2Fnp4%3D&st=2021-10-29T08:28:05Z&se=2121-10-05T08:33:05Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "eca66fba-5a66-4ada-9e99-513db4068ced"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, CoraNeural)",
        "shortName": "en-US-CoraNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Cora",
            "LocalName": "Cora",
            "ShortName": "en-US-CoraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "135",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "CoraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d4fda7ed-6cf0-4b2f-9aaf-91e1e7638039.wav?sv=2019-07-07&sr=b&sig=K%2FYb0Wdh07yXTA5rEvfFE5T%2BsQuZXPRPdhtyl79BWgI%3D&st=2021-10-29T08:25:34Z&se=2121-10-05T08:30:34Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "4bfabb53-98ee-4c2d-9a60-51835494916d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (vi-VN, NamMinhNeural)",
        "shortName": "vi-VN-NamMinhNeural",
        "locale": "vi-VN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "NamMinh",
            "LocalName": "Nam Minh",
            "ShortName": "vi-VN-NamMinhNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "418",
            "LocaleDescription": "Vietnamese",
            "PreviewSentence": "Phát triển phần mềm và dịch vụ có thể giao tiếp tự nhiên với người dùng, nâng cao tính tiếp cận và tính khả dụng của sản phẩm",
            "DisplayVoiceName": "NamMinhNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "vi-VN",
            "localeZH": "越南语(越南)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8c455650-f4ad-4e05-be61-b8664a1d3bb7.wav?sv=2019-07-07&sr=b&sig=6nQVwDyCP7k4nDrx2ioUTzgLmCYxGLw310xCUzpewIQ%3D&st=2021-10-29T08:28:30Z&se=2121-10-05T08:33:30Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "38c5302d-b63e-41d3-b9d5-51af941f72d4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN-shaanxi, XiaoniNeural)",
        "shortName": "zh-CN-shaanxi-XiaoniNeural",
        "locale": "zh-CN-shaanxi",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Xiaoni",
            "LocalName": "晓妮",
            "ShortName": "zh-CN-shaanxi-XiaoniNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "446",
            "LocaleDescription": "zh-CN-shaanxi",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "XiaoniNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "zh-CN-shaanxi",
            "localeZH": "中文(中原官话陕西，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c7efdb4d-0e36-4575-bc23-84389cf287c4.wav?sv=2019-07-07&sr=b&sig=hTLX0WBLjlzubtWkbhvTf7PTwQ%2BwShCrqKS3dliEoOE%3D&st=2022-08-30T08:13:48Z&se=2122-08-06T08:18:48Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ed0cbbff-e662-4159-bc8f-51e4d652db47"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (hr-HR, GabrijelaNeural)",
        "shortName": "hr-HR-GabrijelaNeural",
        "description": "",
        "locale": "hr-HR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gabrijela",
            "LocalName": "Gabrijela",
            "ShortName": "hr-HR-GabrijelaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "265",
            "LocaleDescription": "Croatian",
            "PreviewSentence": "Pravi aplikacije i usluge koje se obraćaju korisnicima na što prirodniji način i poboljšava njihovu pristupačnost i korišćenje.",
            "DisplayVoiceName": "GabrijelaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "hr-HR",
            "localeZH": "克罗地亚语(克罗地亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ade486ec-1c6a-4144-8e9a-2f4fe6252e2e.wav?sv=2019-07-07&sr=b&sig=6utndJ%2Fcp4uLMxkM%2F4c7i0tUJ%2BSPIu%2BzHoTMWbjgNEE%3D&st=2021-10-29T08:27:11Z&se=2121-10-05T08:32:11Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "48d3ffd9-2a24-450c-b423-53762f6575c4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-GQ, TeresaNeural)",
        "shortName": "es-GQ-TeresaNeural",
        "locale": "es-GQ",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Teresa",
            "LocalName": "Teresa",
            "ShortName": "es-GQ-TeresaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "185",
            "LocaleDescription": "es-GQ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "TeresaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-GQ",
            "localeZH": "西班牙语(赤道几内亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/956750a0-c05e-43ab-b624-5bb4b278323d.wav?sv=2019-07-07&sr=b&sig=fIP6JO2tsktJMhNyHTUUN4O2JdnI9VxxvbXpBfR8Clk%3D&st=2021-10-29T08:30:41Z&se=2121-10-05T08:35:41Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "94127b9b-e780-4dff-9c7f-5386d4ea6331"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, MichelleNeural)",
        "shortName": "en-US-MichelleNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Michelle",
            "LocalName": "Michelle",
            "ShortName": "en-US-MichelleNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "142",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MichelleNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d24a8779-2140-449d-8091-a5a1b20a9a4e.wav?sv=2019-07-07&sr=b&sig=3suGCqAOfep43ll9PmXQiwV3F45CsBz0RkjSaIuIFUI%3D&st=2021-10-29T08:25:49Z&se=2121-10-05T08:30:49Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d2e289ac-2b92-4127-9183-5475de808892"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, HenriNeural)",
        "shortName": "fr-FR-HenriNeural",
        "description": "",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "cheerful,sad,Default",
            "VoiceStyleNameDefinitions": "{\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Henri",
            "LocalName": "Henri",
            "ShortName": "fr-FR-HenriNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "247",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "HenriNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/78b56c23-c636-44ab-83fc-219610751cbe.wav?sv=2019-07-07&sr=b&sig=tqy7mF0xGR0WdCdZY8SOrXfXrocQJzJiyJ08ppLOxfA%3D&st=2021-10-29T08:27:02Z&se=2121-10-05T08:32:02Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/97240141-0ab6-43cd-8db3-d115eb950b0a.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A10Z&se=2122-09-27T07%3A52%3A10Z&sr=b&sp=rl&sig=XRkpprpp3oiqq1g9jbvhLe3Z%2BqGOujEHVGLhhOn3O4E%3D"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1740add2-e97c-44df-b020-57e2e0e41aed.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A12Z&se=2122-09-27T07%3A52%3A12Z&sr=b&sp=rl&sig=P1uHUqUQYkLsZXqdu6BwGAZrGYdqrUOdnnR0HYhay2s%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "db1112a4-e410-496e-b6dd-5493515bc9fa"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ml-IN, SobhanaNeural)",
        "shortName": "ml-IN-SobhanaNeural",
        "locale": "ml-IN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sobhana",
            "LocalName": "ശോഭന",
            "ShortName": "ml-IN-SobhanaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "324",
            "LocaleDescription": "ml-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SobhanaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ml-IN",
            "localeZH": "马拉雅拉姆语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/27826978-1bb3-48c0-a020-70243be13bd5.wav?sv=2019-07-07&sr=b&sig=IfnymYaRSEVtH56gf7M0Y1klrWHTDfCmJfvKGdsDwKk%3D&st=2022-01-19T09:02:09Z&se=2121-12-26T09:07:09Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0fe16f65-a722-43d7-b79c-549b0da935ab"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, EliasNeural)",
        "shortName": "es-ES-EliasNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Elias",
            "LocalName": "Elias",
            "ShortName": "es-ES-EliasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "172",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "EliasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f5281f53-65e4-4685-bfb7-f8b30372dbf2.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A38Z&se=2122-09-27T07%3A51%3A38Z&sr=b&sp=rl&sig=0xOXVIM%2B0zNsAwaHarfl4qL%2BJF8bG8ZGVDJ6%2BaHvxT4%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2590425b-a919-44b9-b8c4-54f6a7f04255"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-PT, RaquelNeural)",
        "shortName": "pt-PT-RaquelNeural",
        "locale": "pt-PT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Raquel",
            "LocalName": "Raquel",
            "ShortName": "pt-PT-RaquelNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "367",
            "LocaleDescription": "Portuguese (Portugal)",
            "PreviewSentence": "Constrói aplicações e serviços que falam naturalmente com os utilizadores, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "RaquelNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-PT",
            "localeZH": "葡萄牙语(葡萄牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/93f013e1-64ff-4340-a3b9-1eadd49bd701.wav?sv=2019-07-07&sr=b&sig=tOB09Td8LPk2fTrld5Q7r1AT0p%2B57tBUppP%2BAk5cCUY%3D&st=2021-10-29T08:27:58Z&se=2121-10-05T08:32:58Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5a8032b2-536d-4341-b828-550ae5946fd9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (el-GR, AthinaNeural)",
        "shortName": "el-GR-AthinaNeural",
        "description": "",
        "locale": "el-GR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Athina",
            "LocalName": "Αθηνά",
            "ShortName": "el-GR-AthinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "75",
            "LocaleDescription": "Greek",
            "PreviewSentence": "Δημιουργήστε εφαρμογές και υπηρεσίες που μιλούν με φυσικό τρόπο στους χρήστες, βελτιώνοντας την προσβασιμότητα και τη χρηστικότητα.",
            "DisplayVoiceName": "AthinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "el-GR",
            "localeZH": "希腊语(希腊)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/178fc88c-94be-4b83-a045-a95af7a5dda7.wav?sv=2019-07-07&sr=b&sig=mC9rVCCNWJGa%2F%2FZt8LtO3aiVb1yRi7EnmzYq0h15XTM%3D&st=2021-10-29T08:26:16Z&se=2121-10-05T08:31:16Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "4a73ab1b-4908-4586-bde6-556699f5e855"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-GQ, JavierNeural)",
        "shortName": "es-GQ-JavierNeural",
        "locale": "es-GQ",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Javier",
            "LocalName": "Javier",
            "ShortName": "es-GQ-JavierNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "184",
            "LocaleDescription": "es-GQ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "JavierNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-GQ",
            "localeZH": "西班牙语(赤道几内亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f1035f95-5c57-4cbe-a538-4cf04a030753.wav?sv=2019-07-07&sr=b&sig=n4EaaPCeiegKhne7A7hb9uWMwK%2BiT2On5w8ziNr5OUU%3D&st=2021-10-29T08:30:40Z&se=2121-10-05T08:35:40Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "76130879-a05a-442b-8145-55ecbcf934da"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (is-IS, GudrunNeural)",
        "shortName": "is-IS-GudrunNeural",
        "locale": "is-IS",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gudrun",
            "LocalName": "Guðrún",
            "ShortName": "is-IS-GudrunNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "273",
            "LocaleDescription": "is-IS",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "GudrunNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "is-IS",
            "localeZH": "冰岛语(冰岛)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d120d73a-6ba7-4002-ae76-430b0d177741.wav?sv=2019-07-07&sr=b&sig=EHs%2FS5Wf7eGS%2Be9Lgr%2FCetkf7zrL%2BGwVrLYlDFHxfiQ%3D&st=2022-01-19T09:01:44Z&se=2121-12-26T09:06:44Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "4f0f956b-7704-4cfd-b50c-56658f80084e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaoshuangNeural)",
        "shortName": "zh-CN-XiaoshuangNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "chat,Default",
            "VoiceStyleNameDefinitions": "{\"Default\":0}",
            "DisplayName": "Xiaoshuang",
            "LocalName": "晓双",
            "ShortName": "zh-CN-XiaoshuangNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "Child",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/648f9926-c7ad-4ae4-88a5-5e58db5bbf82.png?sv=2019-07-07&sr=b&sig=CcfrZ4E3GVhAxEmWq1r5FXscoVs9uqOfyVXszZyAZRw%3D&st=2021-10-29T08:24:34Z&se=2121-10-05T08:29:34Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "431",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaoshuangNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Audiobook"
            },
            {
                "name": "Chat",
                "defaultStyle": "chat"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "晓双儿童故事展示",
                "titleLocalizationId": "zh-CN-XiaoshuangNeural_Masterpieces_Audiobook_ChildrenStory_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/39a097c2-2820-4cd2-a931-9550f7957cc5.wav?sv=2019-07-07&sr=b&sig=ByKcy9Abn484xoSI7Y9RgDRaYfKAxXKB8BxKVgQx9HU%3D&st=2021-10-29T08:31:52Z&se=2121-10-05T08:36:52Z&sp=rl"
            },
            {
                "categories": [
                    "Chat"
                ],
                "title": "晓双AI对话展示",
                "titleLocalizationId": "zh-CN-XiaoshuangNeural_Masterpieces_Chat_AIConversation_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/953946d7-f809-4668-84b9-d4a46083f78e.wav?sv=2019-07-07&sr=b&sig=13%2BnCwDTMy1PN9pZ3z4PDJE%2BC2nMqD8m3gT%2F814TnGs%3D&st=2021-10-29T08:31:53Z&se=2121-10-05T08:36:53Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e9f43422-16c6-4c6f-9613-291574ecc41a.wav?sv=2019-07-07&sr=b&sig=1W%2BMJwCE6jBlbbn8mQADTefEcybLkemp%2FUn10cE7FT4%3D&st=2021-10-29T08:29:45Z&se=2121-10-05T08:34:45Z&sp=rl"
                },
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fb01c67e-b54c-440e-9457-2f972576d2e4.wav?sv=2019-07-07&sr=b&sig=XDp3wTUyLsRXq1qqMgjNi4n7IElv2PkTVJZuUgCLnWA%3D&st=2021-10-29T08:29:46Z&se=2121-10-05T08:34:46Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "732028ea-c614-45de-8cad-566e19e94e79"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (kn-IN, GaganNeural)",
        "shortName": "kn-IN-GaganNeural",
        "locale": "kn-IN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gagan",
            "LocalName": "ಗಗನ್",
            "ShortName": "kn-IN-GaganNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "305",
            "LocaleDescription": "kn-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "GaganNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "kn-IN",
            "localeZH": "埃纳德语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5783bbe7-f61d-4c2b-901c-ee632c2298ed.wav?sv=2019-07-07&sr=b&sig=Rn21duyLZd2isZdNh2pl1sJxzkEpdlXNHbuwGwQEFBM%3D&st=2022-01-19T09:01:53Z&se=2121-12-26T09:06:53Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "dc3d1705-5580-40f3-93a6-5785d1b70861"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, AlainNeural)",
        "shortName": "fr-FR-AlainNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Alain",
            "LocalName": "Alain",
            "ShortName": "fr-FR-AlainNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "241",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "AlainNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/338c189c-c746-48ca-afd5-e8c6b83ebdc4.wav?sv=2019-07-07&sr=b&sig=XRfTByipPRCYlkPj5doXt27Ec7kibbp%2FOzb7r38Ws08%3D&st=2022-01-19T09:01:17Z&se=2121-12-26T09:06:17Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "bfa6ab71-5463-4a9f-8170-58c219093aab"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, TanjaNeural)",
        "shortName": "de-DE-TanjaNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Tanja",
            "LocalName": "Tanja",
            "ShortName": "de-DE-TanjaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "73",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "TanjaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fcf16c22-b294-4297-aac6-6a8faca36271.wav?sv=2019-07-07&sr=b&sig=FTKGfxJI2T%2BBfTLzM50TGuNycBiRVcgqTMW4HYhMH84%3D&st=2022-01-19T09:00:48Z&se=2121-12-26T09:05:48Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ab391d83-4474-4387-9bdf-591524d03635"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ko-KR, JiMinNeural)",
        "shortName": "ko-KR-JiMinNeural",
        "locale": "ko-KR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "JiMin",
            "LocalName": "지민",
            "ShortName": "ko-KR-JiMinNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "311",
            "LocaleDescription": "Korean",
            "PreviewSentence": "사용자들에게 자연스럽게 이야기하는 앱과 서비스를 만들며 접근성과 사용성을 개선시킵니다.",
            "DisplayVoiceName": "JiMinNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "ko-KR",
            "localeZH": "韩语(韩国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0c797d82-969b-439e-943c-2f44b54358ba.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A39Z&se=2122-09-27T07%3A52%3A39Z&sr=b&sp=rl&sig=sxpAflw%2FzcIjeTPS87QTIYxpUpbPSzu1itxRkwWQd%2B0%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "474131f3-ea79-45eb-bb61-594966a48110"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, JennyNeural)",
        "shortName": "en-US-JennyNeural",
        "description": "",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "assistant,chat,customerservice,newscast,angry,cheerful,sad,excited,friendly,terrified,shouting,unfriendly,whispering,hopeful,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Jenny",
            "LocalName": "Jenny",
            "ShortName": "en-US-JennyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "126",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "JennyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [
            {
                "categories": [
                    "Newscast"
                ],
                "title": "News",
                "titleLocalizationId": "News",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/87013a89-c507-49bc-b1c6-6075bced1c49.wav?sv=2019-07-07&sr=b&sig=Jc3u2i8gJUgTvdmvpz80NYIwNxklRXNsK9rP4F%2BlOfQ%3D&st=2021-10-29T08:25:45Z&se=2121-10-05T08:30:45Z&sp=rl"
            },
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "AudioBook",
                "titleLocalizationId": "AudioBook",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/87cff8b8-ab91-42d0-a6f0-b004e4bad1ba.wav?sv=2019-07-07&sr=b&sig=boONrOHQTogoL9POz9A8KiwNsX3EpYFBpwTUeR4Mvb8%3D&st=2021-10-29T08:25:44Z&se=2121-10-05T08:30:44Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7e965392-7eba-43c3-ab90-833ce77cd3cf.wav?sv=2019-07-07&sr=b&sig=lyC2l0jN1nSmwMOycR2wXTkiVzjwcN8Ud5X5Gl5NGWE%3D&st=2021-10-29T08:25:46Z&se=2121-10-05T08:30:46Z&sp=rl"
                },
                {
                    "styleName": "assistant",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/538c6710-88f0-4808-bf98-e1c7b7d4dd6e.wav?sv=2019-07-07&sr=b&sig=UQhwBQ6MT2df386E78ck65m%2BqGEBHEEutda%2Fw%2BtyQU0%3D&st=2021-10-29T08:25:40Z&se=2121-10-05T08:30:40Z&sp=rl"
                },
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2125edde-b7f2-4e0f-9f04-ebb28c45f8a6.wav?sv=2019-07-07&sr=b&sig=1wolFFbwSxYkwZI3hNLLeo1NXFJj89gXxOiViBB9MUI%3D&st=2021-10-29T08:25:42Z&se=2121-10-05T08:30:42Z&sp=rl"
                },
                {
                    "styleName": "customerservice",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4bec52f6-725d-4a2a-b25f-8f232a8cd540.wav?sv=2019-07-07&sr=b&sig=AtWvxjDNZv2YrcCHYR63gX0dLlCN1yHITG%2BvQYNEMQI%3D&st=2021-10-29T08:25:43Z&se=2121-10-05T08:30:43Z&sp=rl"
                },
                {
                    "styleName": "newscast",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/78f395f6-4634-4c83-bf74-372ec3c55795.wav?sv=2019-07-07&sr=b&sig=Z5N3I3P9DdqPP%2F0nwgOhLTTI9juaxSIs0F9KYOuoX0c%3D&st=2021-10-29T08:25:48Z&se=2121-10-05T08:30:48Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/22a7100a-ac65-4aa9-9ac9-3072f60e87ca.wav?sv=2019-07-07&sr=b&sig=Gy2StMBkS6HKT0UdBHPCbj8qi2Oic8v49Wc%2Bh0unfEg%3D&st=2022-04-28T10:26:18Z&se=2122-04-04T10:31:18Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/56039fa0-2d92-4fd2-a8fe-631c2ed578ce.wav?sv=2019-07-07&sr=b&sig=zoTHGHpROIxteFYDHJ6pGIIaeng1QKj%2FNNVoJWzeO5Y%3D&st=2022-04-28T10:26:20Z&se=2122-04-04T10:31:20Z&sp=rl"
                },
                {
                    "styleName": "excited",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/23f6061b-2076-4052-bbce-8cee689c2bd9.wav?sv=2019-07-07&sr=b&sig=9QhVOSBMWRtUw%2F9xkrX9gtcRw6rkIdwwVFVH14Pf8PY%3D&st=2022-04-28T10:26:23Z&se=2122-04-04T10:31:23Z&sp=rl"
                },
                {
                    "styleName": "friendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bec707b0-decf-46b7-ba51-71d3f280540d.wav?sv=2019-07-07&sr=b&sig=EiYzAGx3q4wp1zCWDgsj7vFHg9qukJf%2B4tUtW5WlF9U%3D&st=2022-04-28T10:26:25Z&se=2122-04-04T10:31:25Z&sp=rl"
                },
                {
                    "styleName": "hopeful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8836fd85-0877-490f-bff4-172da15a5a78.wav?sv=2019-07-07&sr=b&sig=rn6QpzXMGGXT%2FxNDkVEk0N838FxzJ9JYRVMv3L1n4xQ%3D&st=2022-04-28T10:26:27Z&se=2122-04-04T10:31:27Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/263a38d0-174f-4101-8a49-b87a5d7ac4e2.wav?sv=2019-07-07&sr=b&sig=nPLZhA9M%2FHkw8v4YfU6Uno8G2To%2Fx6HzS2x2HaUL%2Bs0%3D&st=2022-04-28T10:26:30Z&se=2122-04-04T10:31:30Z&sp=rl"
                },
                {
                    "styleName": "shouting",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5f591369-3441-4803-adbc-377b24d8b3eb.wav?sv=2019-07-07&sr=b&sig=g1ytYTPYklPC1S4b3MMXxdr280W90b7O0Cjy1Xn11fM%3D&st=2022-04-28T10:26:32Z&se=2122-04-04T10:31:32Z&sp=rl"
                },
                {
                    "styleName": "terrified",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/79b3edb5-a764-4e40-804d-370464659857.wav?sv=2019-07-07&sr=b&sig=bH4rE7zATQVPH0suVg7uuN3MWaFKSjpHZgtM8A%2BvJ10%3D&st=2022-04-28T10:26:34Z&se=2122-04-04T10:31:34Z&sp=rl"
                },
                {
                    "styleName": "unfriendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e19642f8-cf41-471a-b06a-3c426ce4688b.wav?sv=2019-07-07&sr=b&sig=B%2ByAPKrl2tCB%2B06hEZ9350D8PQ1TlJhE%2FruPyhM6BgQ%3D&st=2022-04-28T10:26:37Z&se=2122-04-04T10:31:37Z&sp=rl"
                },
                {
                    "styleName": "whispering",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2ad03235-2896-40a5-ae81-9def57fbef16.wav?sv=2019-07-07&sr=b&sig=sys16iZeJi8d6TNaCKbDUkoUYfYdAxPfoAUiyUNIZIY%3D&st=2022-04-28T10:26:39Z&se=2122-04-04T10:31:39Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e5e4f59b-65c6-42b2-a6e3-5985d1a1ea07"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-UY, ValentinaNeural)",
        "shortName": "es-UY-ValentinaNeural",
        "locale": "es-UY",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Valentina",
            "LocalName": "Valentina",
            "ShortName": "es-UY-ValentinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "220",
            "LocaleDescription": "es-UY",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ValentinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-UY",
            "localeZH": "西班牙语(乌拉圭)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a2c2d068-8af9-4409-89c5-96eb23e05961.wav?sv=2019-07-07&sr=b&sig=VN8Sed9WNaUz0g3p3OayHd1C5CdI8Gfk1SVESzzvShk%3D&st=2021-10-29T08:30:59Z&se=2121-10-05T08:35:59Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "05750e25-e868-45c4-9ae7-5a137a4cdf19"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, KlarissaNeural)",
        "shortName": "de-DE-KlarissaNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Klarissa",
            "LocalName": "Klarissa",
            "ShortName": "de-DE-KlarissaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "68",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "KlarissaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5950e489-0c2c-4348-8846-bc868753a51a.wav?sv=2019-07-07&sr=b&sig=TNxfER8IWCdlZkoJlxIRx1KnrFh1qPN8oijObKYNfRk%3D&st=2022-01-19T09:00:36Z&se=2121-12-26T09:05:36Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9ebb7b98-4fc8-4093-9e92-5a567ede03d8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-CH, LeniNeural)",
        "shortName": "de-CH-LeniNeural",
        "description": "",
        "locale": "de-CH",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Leni",
            "LocalName": "Leni",
            "ShortName": "de-CH-LeniNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "59",
            "LocaleDescription": "German (Switzerland)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "LeniNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-CH",
            "localeZH": "德语(瑞士)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/00e1d1ff-c195-4d6d-929b-8a4edf8b107c.wav?sv=2019-07-07&sr=b&sig=ZuHcbosr6%2FNAD3OGr0nWzxblDODMCWnInjjzkHYkZzg%3D&st=2021-10-29T08:26:13Z&se=2121-10-05T08:31:13Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "66becf5d-1fc6-488f-9f71-5a94bca91880"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-DZ, IsmaelNeural)",
        "shortName": "ar-DZ-IsmaelNeural",
        "locale": "ar-DZ",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ismael",
            "LocalName": "إسماعيل",
            "ShortName": "ar-DZ-IsmaelNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "10",
            "LocaleDescription": "ar-DZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "IsmaelNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-DZ",
            "localeZH": "阿拉伯语(阿尔及利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6995ee7b-07ce-47a5-8938-84bfb9a5c309.wav?sv=2019-07-07&sr=b&sig=HeL%2FkHhh00JeLmguco9hSQS3qWaNZSRwWF6RnKepTPE%3D&st=2021-10-29T08:30:02Z&se=2121-10-05T08:35:02Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d26c4ed1-a6f9-4a08-af27-5aae3df3a890"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (nb-NO, FinnNeural)",
        "shortName": "nb-NO-FinnNeural",
        "locale": "nb-NO",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Finn",
            "LocalName": "Finn",
            "ShortName": "nb-NO-FinnNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "336",
            "LocaleDescription": "Norwegian",
            "PreviewSentence": "Bygger apper og tjenester som snakker naturlig med brukerne, utbedrer tilgjengelighet og brukskvalitet.",
            "DisplayVoiceName": "FinnNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "nb-NO",
            "localeZH": "书面挪威语(挪威)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2debd804-4e06-4c1a-bfff-792c2e7036a7.wav?sv=2019-07-07&sr=b&sig=YUhKlyMVZWo0RA%2B67bIqFpp2b2K%2FULR%2F9Qg74TV1Lu8%3D&st=2021-10-29T08:27:37Z&se=2121-10-05T08:32:37Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2b9002ee-95ba-419f-b983-5b14ece687a6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, BerndNeural)",
        "shortName": "de-DE-BerndNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Bernd",
            "LocalName": "Bernd",
            "ShortName": "de-DE-BerndNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "62",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "BerndNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fd1b6f2a-72cb-444a-af22-d4c203409eeb.wav?sv=2019-07-07&sr=b&sig=6x3Xg0XjgpLAq3on8ield5j8e4Ngs0QM3lpDO7gv2aM%3D&st=2022-01-19T09:00:22Z&se=2121-12-26T09:05:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "10044c16-554d-4691-9c89-5c13e892ceb6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fi-FI, NooraNeural)",
        "shortName": "fi-FI-NooraNeural",
        "description": "",
        "locale": "fi-FI",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Noora",
            "LocalName": "Noora",
            "ShortName": "fi-FI-NooraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "231",
            "LocaleDescription": "Finnish",
            "PreviewSentence": "Kehitä luonnolisesti puhuvia sovelluksia ja palveluja, jotka parantavat käytettävyyttä ja saavutettavuutta.",
            "DisplayVoiceName": "NooraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fi-FI",
            "localeZH": "芬兰语(芬兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d2a2865b-a0ce-4212-bd2b-34ebc08635bc.wav?sv=2019-07-07&sr=b&sig=gklgia2ezyW6od%2BGG4JLBf84HTiJNzCHTB7USN0eh%2BU%3D&st=2021-10-29T08:26:52Z&se=2121-10-05T08:31:52Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "33b22076-a1b7-459a-b9db-5c507945176c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaomengNeural)",
        "shortName": "zh-CN-XiaomengNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "chat,Default",
            "VoiceStyleNameDefinitions": "{\"Default\":0}",
            "DisplayName": "Xiaomeng",
            "LocalName": "晓梦",
            "ShortName": "zh-CN-XiaomengNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "427",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaomengNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bc931737-94cc-4142-b043-011f1edfd963.wav?sv=2019-07-07&sr=b&sig=eVZ9P6sCMIzwFVkOiEaDo0rqsvR0zCLW%2FIYAAonBEn4%3D&st=2022-08-01T10:39:22Z&se=2122-07-08T10:44:22Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f0c63d06-0d14-49e9-861e-bd86e0bff368.wav?sv=2019-07-07&sr=b&sig=%2FDG5ARzGSsyWxDlrElEK0SwWzJo%2FT6x72HuXJxgxd4w%3D&st=2022-08-01T10:39:25Z&se=2122-07-08T10:44:25Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e7ae8dcc-bee4-4545-8532-5c8710041809"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, CarlyNeural)",
        "shortName": "en-AU-CarlyNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Carly",
            "LocalName": "Carly",
            "ShortName": "en-AU-CarlyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "78",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "CarlyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/39b66285-bb6f-47a9-b762-b8f1f4765da6.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A00Z&se=2122-09-27T07%3A51%3A00Z&sr=b&sp=rl&sig=VcNp3II109rgabkrRSvhloN8t4Mme9G25Nl97OiTXr0%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2fd0c0e4-8885-49d0-80b8-5ca9929e8716"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-OM, AyshaNeural)",
        "shortName": "ar-OM-AyshaNeural",
        "locale": "ar-OM",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Aysha",
            "LocalName": "عائشة",
            "ShortName": "ar-OM-AyshaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "26",
            "LocaleDescription": "ar-OM",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AyshaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-OM",
            "localeZH": "阿拉伯语(阿曼)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e3ab3db1-e490-48e8-b05b-d4f01cf25bb0.wav?sv=2019-07-07&sr=b&sig=o3KjmdkOeeX27ePCOXVNn3T3pMrSifJ8vlgjgadkwt4%3D&st=2022-07-01T09:08:49Z&se=2122-06-07T09:13:49Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "99893827-8784-4146-8bec-5cd7f4b296ed"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, RalfNeural)",
        "shortName": "de-DE-RalfNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ralf",
            "LocalName": "Ralf",
            "ShortName": "de-DE-RalfNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "72",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "RalfNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bbf5cd72-930f-4522-a6cd-d09ffd0f340b.wav?sv=2019-07-07&sr=b&sig=7H4i56mUF5uKXAZrNpEnrlQYF67sMGeMbJZjT%2FrSdlw%3D&st=2022-01-19T09:00:46Z&se=2121-12-26T09:05:46Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "be77cf10-8c9f-4916-b352-5da177804842"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, YunfengNeural)",
        "shortName": "zh-CN-YunfengNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "angry,disgruntled,cheerful,fearful,sad,serious,depressed,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"disgruntled\":5,\"cheerful\":4,\"fearful\":3,\"sad\":8,\"serious\":6,\"depressed\":10,\"Default\":0}",
            "DisplayName": "Yunfeng",
            "LocalName": "云枫",
            "ShortName": "zh-CN-YunfengNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "437",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "YunfengNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2468d6bd-ee27-4198-b78f-1c0b3c019af6.wav?sv=2019-07-07&sr=b&sig=5Q7O5bY37LcEDxJlPpmZpKghkQ3Vhe4ZhTQanhba9t0%3D&st=2022-04-28T07:18:29Z&se=2122-04-04T07:23:29Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/447d30f0-b934-4f35-8b47-0cdd61d6c30b.wav?sv=2019-07-07&sr=b&sig=ClfC8EA4d0DTgj5BmgfHGuvFtYae7qjWxrfwh9qJU2o%3D&st=2022-04-28T07:18:21Z&se=2122-04-04T07:23:21Z&sp=rl"
                },
                {
                    "styleName": "disgruntled",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2e9d6bd7-46cc-49c8-ab89-4408ec356be6.wav?sv=2019-07-07&sr=b&sig=3IK0tog9gZc4oNYP6qJJ8J2QReWGFU19QLwkj89O%2FoA%3D&st=2022-04-28T07:18:23Z&se=2122-04-04T07:23:23Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2c5ff7cd-433e-4439-b60f-d2e795c490bc.wav?sv=2019-07-07&sr=b&sig=tYF33pE9zWxXqf2i4TRkcb%2BPfKFsPpwSWgKC0X34m7o%3D&st=2022-04-28T07:18:32Z&se=2122-04-04T07:23:32Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/99f38db2-2cdb-4ff3-b78c-acdb1414bb20.wav?sv=2019-07-07&sr=b&sig=dtIjh1zgOzMMGmppt6L5wQ4d8irp2wVlVFg3g3yUdzM%3D&st=2022-04-28T07:18:35Z&se=2122-04-04T07:23:35Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4f018540-8433-47a2-b643-892005c544ac.wav?sv=2019-07-07&sr=b&sig=qs0PqMs5qrKaC1flYJ1h1HXd9iikiC8sS%2BulHTt%2Ba%2FQ%3D&st=2022-04-28T07:18:38Z&se=2122-04-04T07:23:38Z&sp=rl"
                },
                {
                    "styleName": "serious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ef2429ce-6be4-43c5-b756-719864ee50d4.wav?sv=2019-07-07&sr=b&sig=wUmeGY9VrTv16CHm40DY8dz5pvdV8o2yCeutZC%2B1NDI%3D&st=2022-04-28T07:18:41Z&se=2122-04-04T07:23:41Z&sp=rl"
                },
                {
                    "styleName": "depressed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7214ca67-11a7-43c1-9cfa-435a5912dd15.wav?sv=2019-07-07&sr=b&sig=E1pK1of7%2Fh1JrxZJotQUTfAT0d6zYfk9DZqKjwPclGg%3D&st=2022-04-28T07:18:26Z&se=2122-04-04T07:23:26Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "54bdad96-b5f6-4243-9705-5e0db3f67dcd"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (si-LK, ThiliniNeural)",
        "shortName": "si-LK-ThiliniNeural",
        "locale": "si-LK",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Thilini",
            "LocalName": "තිළිණි",
            "ShortName": "si-LK-ThiliniNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "374",
            "LocaleDescription": "si-LK",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ThiliniNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "si-LK",
            "localeZH": "僧伽罗语(斯里兰卡)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9d7e5f77-d597-4d09-b210-c4238a35405a.wav?sv=2019-07-07&sr=b&sig=9LdQLm7NwMPrkO4GfOFpJEfoPtHsqLK87LXYbgEM00c%3D&st=2022-01-19T09:02:18Z&se=2121-12-26T09:07:18Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "307049c0-bfaf-40dd-8b97-5f69465d0e48"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, ClaudeNeural)",
        "shortName": "fr-FR-ClaudeNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Claude",
            "LocalName": "Claude",
            "ShortName": "fr-FR-ClaudeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "244",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "ClaudeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e7a547f8-06a3-4a3a-9058-9d56731e0c9f.wav?sv=2019-07-07&sr=b&sig=yXJWryUom4OoVLpEH3oa%2BRSBvPTsLTH0VEFrs7TEJaM%3D&st=2022-01-19T09:01:24Z&se=2121-12-26T09:06:24Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "329c1743-53d2-442e-b4ef-5fcb260105fa"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ne-NP, SagarNeural)",
        "shortName": "ne-NP-SagarNeural",
        "locale": "ne-NP",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sagar",
            "LocalName": "सागर",
            "ShortName": "ne-NP-SagarNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "339",
            "LocaleDescription": "ne-NP",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SagarNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ne-NP",
            "localeZH": "尼泊尔语(尼泊尔)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/dfe7229a-8cad-4a2f-b910-55387eaa9284.wav?sv=2019-07-07&sr=b&sig=zA0fRchR08VJZe08qrEiB5WtNX%2F%2FcZHgOAcC4prEPKo%3D&st=2022-07-01T09:10:09Z&se=2122-06-07T09:15:09Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "09d9fda8-5de9-4e7a-be8b-607a82f767d1"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, ValerioNeural)",
        "shortName": "pt-BR-ValerioNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Valerio",
            "LocalName": "Valerio",
            "ShortName": "pt-BR-ValerioNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "363",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "ValerioNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4e74721e-79e2-47cc-ba1c-9c0b0b3a1af7.wav?sv=2019-07-07&sr=b&sig=SYgs%2Biwp8U5x6f96zbGuY%2F6RbPzcVEy5%2B8GOl0pTKVI%3D&st=2022-07-01T09:10:36Z&se=2122-06-07T09:15:36Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "3bb57996-137f-460b-b245-61b4a441899f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ko-KR, YuJinNeural)",
        "shortName": "ko-KR-YuJinNeural",
        "locale": "ko-KR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "YuJin",
            "LocalName": "유진",
            "ShortName": "ko-KR-YuJinNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "314",
            "LocaleDescription": "Korean",
            "PreviewSentence": "사용자들에게 자연스럽게 이야기하는 앱과 서비스를 만들며 접근성과 사용성을 개선시킵니다.",
            "DisplayVoiceName": "YuJinNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "ko-KR",
            "localeZH": "韩语(韩国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/184afedf-101d-40e0-ad0e-07bd10f8aeb7.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A45Z&se=2122-09-27T07%3A52%3A45Z&sr=b&sp=rl&sig=Vc09h4te2JlKIVoC0%2FFbGoaJpyv6GIUIvYD6JwwGYAs%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f9fd897f-780d-4b7f-a8a2-628770eb3218"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, TonyNeural)",
        "shortName": "en-US-TonyNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "angry,cheerful,excited,friendly,hopeful,sad,shouting,terrified,unfriendly,whispering,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Tony",
            "LocalName": "Tony",
            "ShortName": "en-US-TonyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "148",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "TonyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/74d34bd9-b9df-46c2-8ade-ceaf6c9acc52.wav?sv=2019-07-07&sr=b&sig=8Vf6NOY%2BDsmj8AIitFNqfMIIiwf6IdLM90XLkZ6ZINI%3D&st=2022-05-05T09:39:10Z&se=2122-04-11T09:44:10Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c6a964ca-69fd-4762-b624-8b2bdaba9780.wav?sv=2019-07-07&sr=b&sig=MrrhONFb9%2FzajyPzBCLM0tltHx7trTg1EbkIDvSuouw%3D&st=2022-04-28T10:28:32Z&se=2122-04-04T10:33:32Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f11c0250-4ba3-4a7e-9159-d2336b52e39b.wav?sv=2019-07-07&sr=b&sig=zJU7akD3WhjoMcT2KTY9dtFD5%2Frm04PRI9Fpx0jpoKM%3D&st=2022-04-28T10:28:34Z&se=2122-04-04T10:33:34Z&sp=rl"
                },
                {
                    "styleName": "excited",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/275fd146-0946-49ca-bdb1-40df222c418c.wav?sv=2019-07-07&sr=b&sig=xHJZIRfRc%2BmfSrvp1j%2BOzcqjb1QYeOvPRnbTP9Iq9C0%3D&st=2022-04-28T10:28:37Z&se=2122-04-04T10:33:37Z&sp=rl"
                },
                {
                    "styleName": "friendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ae5e502d-c6fa-4f23-891c-9c49674376ec.wav?sv=2019-07-07&sr=b&sig=gRz3LSlxyboFiK24Cm6IkNBYxLGvZ%2FGj92CyI690t4Y%3D&st=2022-04-28T10:28:39Z&se=2122-04-04T10:33:39Z&sp=rl"
                },
                {
                    "styleName": "hopeful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e4956ea0-21f7-47d8-85d2-a8a387c92155.wav?sv=2019-07-07&sr=b&sig=D039LV9Zn0C%2BeARMaVp5beE1uJoEWWDEVuh6OXePGYY%3D&st=2022-04-28T10:28:41Z&se=2122-04-04T10:33:41Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a4968845-d471-42cd-b451-416f039b6825.wav?sv=2019-07-07&sr=b&sig=P05n9gBSpCNQNe1ygYKlF1fuFvouTydGqblUel%2Fm854%3D&st=2022-04-28T10:28:44Z&se=2122-04-04T10:33:44Z&sp=rl"
                },
                {
                    "styleName": "shouting",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bae8f254-0cd9-4730-a95d-5d15f9bf0f7d.wav?sv=2019-07-07&sr=b&sig=jblJwZbD1tB9nQ61MLWibTlWSeRwJkPAdxtiZEyUEUA%3D&st=2022-04-28T10:28:46Z&se=2122-04-04T10:33:46Z&sp=rl"
                },
                {
                    "styleName": "terrified",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/64ed2561-db0e-4162-ab95-fbda5be7c8fa.wav?sv=2019-07-07&sr=b&sig=lV3Ha%2Bm%2Fxryau29ciDpoEt4SEbaP08jXeI7siYe69Dg%3D&st=2022-04-28T10:28:48Z&se=2122-04-04T10:33:48Z&sp=rl"
                },
                {
                    "styleName": "unfriendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b240152e-6424-45fd-b9ae-63f489b02ff2.wav?sv=2019-07-07&sr=b&sig=iUK%2FLeVYywCFkDGRH5VwCnzhJGtyp1v0h5W6qD%2FGpI4%3D&st=2022-04-28T10:28:50Z&se=2122-04-04T10:33:50Z&sp=rl"
                },
                {
                    "styleName": "whispering",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cfa873a8-889c-4dca-b858-10101e300785.wav?sv=2019-07-07&sr=b&sig=xTTYfQDfBSxQqDeFChcK5jhxNwLrZOufDsbO1PaHSjo%3D&st=2022-04-28T10:28:53Z&se=2122-04-04T10:33:53Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "96d631b1-d438-48ba-aa46-6293707d2071"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, MauriceNeural)",
        "shortName": "fr-FR-MauriceNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Maurice",
            "LocalName": "Maurice",
            "ShortName": "fr-FR-MauriceNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "251",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "MauriceNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2b075c1c-3048-4f8a-8398-f6c906a635bb.wav?sv=2019-07-07&sr=b&sig=k0kW2Vyj4qIdlhDQWAXOCf9saS38rJIrxidcn65kmhA%3D&st=2022-01-19T09:01:37Z&se=2121-12-26T09:06:37Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "284ad774-159e-4a73-a997-62d7fdd72335"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (te-IN, ShrutiNeural)",
        "shortName": "te-IN-ShrutiNeural",
        "description": "",
        "locale": "te-IN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Shruti",
            "LocalName": "శ్రుతి",
            "ShortName": "te-IN-ShrutiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "403",
            "LocaleDescription": "Telugu (India)",
            "PreviewSentence": "వినియోగం మరియు సౌలభ్యాన్ని మెరుగుపరిచే, సహజ శైలిలో మాట్లాడే అప్లికేషన్లు మరియు సేవలను అభివృద్ధి చేయండి.",
            "DisplayVoiceName": "ShrutiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "te-IN",
            "localeZH": "泰卢固语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/34078a60-81b4-47c4-8e3e-4c967ec805e5.wav?sv=2019-07-07&sr=b&sig=Hm%2FXRfYFUl87zgSsVyhAUw%2FnMLOqXOjAQoCNa9DghiY%3D&st=2021-10-29T08:28:18Z&se=2121-10-05T08:33:18Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "26eddc58-d6fa-4ddf-9550-634340d7b656"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-YE, SalehNeural)",
        "shortName": "ar-YE-SalehNeural",
        "locale": "ar-YE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Saleh",
            "LocalName": "صالح",
            "ShortName": "ar-YE-SalehNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "36",
            "LocaleDescription": "ar-YE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SalehNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-YE",
            "localeZH": "阿拉伯语(也门)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7f8885ee-ce37-4ce5-b3f5-ee1df4fbfe50.wav?sv=2019-07-07&sr=b&sig=Ozyc7C6FbWCTVZU%2FJf%2FwzB%2FNuteqENeVMf7vzZL58kY%3D&st=2021-10-29T08:30:20Z&se=2121-10-05T08:35:20Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b7b0ee4d-4c7c-4156-9553-635c14ea3dc2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, LibertoNeural)",
        "shortName": "es-MX-LibertoNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Liberto",
            "LocalName": "Liberto",
            "ShortName": "es-MX-LibertoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "198",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "LibertoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5b382935-41a8-41ed-bc70-10fcff5a4c94.wav?sv=2019-07-07&sr=b&sig=ze35u4ZwV5PpGXOpJC6x9lbUZHlLP6tGoaPPIOYgHss%3D&st=2022-07-01T09:09:15Z&se=2122-06-07T09:14:15Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "588abaad-6cb0-4082-856c-64a440de1bfc"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (is-IS, GunnarNeural)",
        "shortName": "is-IS-GunnarNeural",
        "locale": "is-IS",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gunnar",
            "LocalName": "Gunnar",
            "ShortName": "is-IS-GunnarNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "274",
            "LocaleDescription": "is-IS",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "GunnarNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "is-IS",
            "localeZH": "冰岛语(冰岛)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b44042cc-3540-4a17-a087-893ff294838a.wav?sv=2019-07-07&sr=b&sig=ZQD6F%2FrH8mqtKFUXOUMoKF7rBsPHikmtDffVA6mfRmI%3D&st=2022-01-19T09:01:46Z&se=2121-12-26T09:06:46Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c40aaac4-5e0f-4341-bc48-64c0b8ed64ff"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (cs-CZ, AntoninNeural)",
        "shortName": "cs-CZ-AntoninNeural",
        "locale": "cs-CZ",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Antonin",
            "LocalName": "Antonín",
            "ShortName": "cs-CZ-AntoninNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "50",
            "LocaleDescription": "Czech",
            "PreviewSentence": "Vytvořte aplikace a služby pro přirozenou komunikaci s uživateli a usnadněte tak přístup a využití.",
            "DisplayVoiceName": "AntoninNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "cs-CZ",
            "localeZH": "捷克语(捷克)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5be94399-1c32-4115-a9e8-b06a40beec9e.wav?sv=2019-07-07&sr=b&sig=J2LVg4b18Frnv%2BueDGxwAXb%2FGqjDHgnPxtZjL741cyc%3D&st=2021-10-29T08:26:04Z&se=2121-10-05T08:31:04Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f55a63a0-99f3-47e0-b8b3-650a5c742cde"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-IQ, BasselNeural)",
        "shortName": "ar-IQ-BasselNeural",
        "locale": "ar-IQ",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Bassel",
            "LocalName": "باسل",
            "ShortName": "ar-IQ-BasselNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "13",
            "LocaleDescription": "ar-IQ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "BasselNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-IQ",
            "localeZH": "阿拉伯语(伊拉克)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f774ca2d-4652-4cc1-87da-8c15bd921498.wav?sv=2019-07-07&sr=b&sig=rez1e3s4oF%2FeNqzYpLcmw8GXYBaDQaOngGKO%2FWigWPg%3D&st=2021-10-29T08:30:03Z&se=2121-10-05T08:35:03Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8fb26b62-b1a6-496c-81da-650a7bbfb3dd"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (mt-MT, JosephNeural)",
        "shortName": "mt-MT-JosephNeural",
        "locale": "mt-MT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Joseph",
            "LocalName": "Joseph",
            "ShortName": "mt-MT-JosephNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "332",
            "LocaleDescription": "Maltese (Malta)",
            "PreviewSentence": "L-Għodda għall-Ħolqien tal-Kontenut bil-Ħoss tħallik direttament tikkontrolla l-attributi tal-leħen minn fuq l-iskrin tiegħek.",
            "DisplayVoiceName": "JosephNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "mt-MT",
            "localeZH": "马耳他语(马耳他)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a46a9bda-e2c6-4862-a1ea-38c8c47e78a4.wav?sv=2019-07-07&sr=b&sig=EcReh6YvoeWHFMXBvUJlOB07C5nH2Ig%2BHIWuIjrjWOY%3D&st=2021-10-29T08:27:36Z&se=2121-10-05T08:32:36Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "a67686f9-9d9d-43e3-8035-6528063fcfd3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, NuriaNeural)",
        "shortName": "es-MX-NuriaNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Nuria",
            "LocalName": "Nuria",
            "ShortName": "es-MX-NuriaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "201",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "NuriaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/36e90f11-f073-400b-bdd3-adf36f06d8ae.wav?sv=2019-07-07&sr=b&sig=Vd1boojtXTKKMCRkhkSDElNaW9qDjCX9FroHi0UGlDo%3D&st=2022-07-01T09:09:21Z&se=2122-06-07T09:14:21Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "3ae499e9-42b2-4a3e-999a-6549fd4d3d57"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (km-KH, PisethNeural)",
        "shortName": "km-KH-PisethNeural",
        "locale": "km-KH",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Piseth",
            "LocalName": "ពិសិដ្ឋ",
            "ShortName": "km-KH-PisethNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "303",
            "LocaleDescription": "km-KH",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "PisethNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "km-KH",
            "localeZH": "高棉语(柬埔寨)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f8dfb1fb-b58b-4841-b5c7-779653627b51.wav?sv=2019-07-07&sr=b&sig=tVkMtNpRGn0TcVfdrINR8ZfppfnAWGrdh2xFH60WrOI%3D&st=2021-10-29T08:31:09Z&se=2121-10-05T08:36:09Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5d4bc403-93ef-49c3-a2d1-6555b9bcf591"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (th-TH, NiwatNeural)",
        "shortName": "th-TH-NiwatNeural",
        "locale": "th-TH",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Niwat",
            "LocalName": "นิวัฒน์",
            "ShortName": "th-TH-NiwatNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "406",
            "LocaleDescription": "Thai",
            "PreviewSentence": "สร้างแอปและบริการที่สื่อสารกับผู้ใช้ได้อย่างเป็นธรรมชาติ ซึ่งช่วยปรับปรุงการเข้าถึงและการใช้งาน",
            "DisplayVoiceName": "NiwatNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "th-TH",
            "localeZH": "泰语(泰国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7a4bbd9c-b247-43da-aac5-2a9c0dc7bc45.wav?sv=2019-07-07&sr=b&sig=TJe6%2Fs0lHnHv7OO66pgigFCdnaEkMLTEepsulAVMU4w%3D&st=2021-10-29T08:28:21Z&se=2121-10-05T08:33:21Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "77c6b4b5-3b05-4eb6-a44e-65a20c3a5d37"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (eu-ES, AinhoaNeural)",
        "shortName": "eu-ES-AinhoaNeural",
        "locale": "eu-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ainhoa",
            "LocalName": "Ainhoa",
            "ShortName": "eu-ES-AinhoaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "225",
            "LocaleDescription": "eu-ES",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AinhoaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "eu-ES",
            "localeZH": "巴斯克语(巴斯克语)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/42a7a439-9067-4b10-8f7e-59afe6fe5536.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A05Z&se=2122-09-27T07%3A52%3A05Z&sr=b&sp=rl&sig=%2BP5KSSz0UYxcmfCOlspUqpTNfor7B9p8lkdYG3RR%2BVw%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "56d154ac-b59c-414d-8b7b-6639435999e9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, KlausNeural)",
        "shortName": "de-DE-KlausNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Klaus",
            "LocalName": "Klaus",
            "ShortName": "de-DE-KlausNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "69",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "KlausNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7120347f-7fe7-4a3a-8ff2-aad9492be7f1.wav?sv=2019-07-07&sr=b&sig=%2Bwf6GGGJlLWAKnp9F6ybmp2PlCblLCOHXWg3uQmWncs%3D&st=2022-01-19T09:00:39Z&se=2121-12-26T09:05:39Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "bc76601a-7ffa-48ba-bc8d-66db94d3910c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (mr-IN, ManoharNeural)",
        "shortName": "mr-IN-ManoharNeural",
        "locale": "mr-IN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Manohar",
            "LocalName": "मनोहर",
            "ShortName": "mr-IN-ManoharNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "328",
            "LocaleDescription": "mr-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ManoharNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "mr-IN",
            "localeZH": "马拉地语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/43201b41-12b2-4b57-8e0f-62c543bcdfaa.wav?sv=2019-07-07&sr=b&sig=IeFHdWPOuWgny%2BmUOVoA70c7CVgwCu6OGsOa7swAGhI%3D&st=2021-10-29T08:27:30Z&se=2121-10-05T08:32:30Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "4c0cb0f6-f101-4fe1-838d-67f48c70ec53"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (hr-HR, SreckoNeural)",
        "shortName": "hr-HR-SreckoNeural",
        "locale": "hr-HR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Srecko",
            "LocalName": "Srećko",
            "ShortName": "hr-HR-SreckoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "266",
            "LocaleDescription": "Croatian",
            "PreviewSentence": "Pravi aplikacije i usluge koje se obraćaju korisnicima na što prirodniji način i poboljšava njihovu pristupačnost i korišćenje.",
            "DisplayVoiceName": "SreckoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "hr-HR",
            "localeZH": "克罗地亚语(克罗地亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/55c8d442-9358-496c-b515-e1d46958c83d.wav?sv=2019-07-07&sr=b&sig=JTIQYKMehgyLfCHY0xQbgaByUe6V4266vGZBax7s9JE%3D&st=2021-10-29T08:27:12Z&se=2121-10-05T08:32:12Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b7bb8122-2c38-47be-a53b-69bbd81c7b7a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ro-RO, EmilNeural)",
        "shortName": "ro-RO-EmilNeural",
        "locale": "ro-RO",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Emil",
            "LocalName": "Emil",
            "ShortName": "ro-RO-EmilNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "369",
            "LocaleDescription": "Romanian",
            "PreviewSentence": "Creați aplicații și servicii familiare utilizatorilor, îmbunătățind accesibilitatea și ușurința utilizării.",
            "DisplayVoiceName": "EmilNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ro-RO",
            "localeZH": "罗马尼亚语(罗马尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7c4ba44b-a980-40cb-a473-fead6e0bd378.wav?sv=2019-07-07&sr=b&sig=V8xZWCnyCz%2F3AbZkKTvtirl2Sb8ysdpmpAsVtAGswms%3D&st=2021-10-29T08:28:01Z&se=2121-10-05T08:33:01Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "04b3870c-105c-4c8f-b557-6a02b92ad98f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ga-IE, OrlaNeural)",
        "shortName": "ga-IE-OrlaNeural",
        "description": "",
        "locale": "ga-IE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Orla",
            "LocalName": "Orla",
            "ShortName": "ga-IE-OrlaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "256",
            "LocaleDescription": "Irish (Ireland)",
            "PreviewSentence": "Cuireann Cruthú Ábhar Fuaime ar do chumas tréithe cainte a rialú i bhfíor-am.",
            "DisplayVoiceName": "OrlaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ga-IE",
            "localeZH": "爱尔兰语(爱尔兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/14ffd29a-8cba-4ea4-bb96-d43a90cdd278.wav?sv=2019-07-07&sr=b&sig=epiRvGou%2Bh3xn%2BDUxngnx20YQHlXYd0OXs8tWmh3rEc%3D&st=2021-10-29T08:27:04Z&se=2121-10-05T08:32:04Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5db0c41c-9206-4a67-8987-6aec4b8b92c8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ro-RO, AlinaNeural)",
        "shortName": "ro-RO-AlinaNeural",
        "description": "",
        "locale": "ro-RO",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Alina",
            "LocalName": "Alina",
            "ShortName": "ro-RO-AlinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "368",
            "LocaleDescription": "Romanian",
            "PreviewSentence": "Creați aplicații și servicii familiare utilizatorilor, îmbunătățind accesibilitatea și ușurința utilizării.",
            "DisplayVoiceName": "AlinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ro-RO",
            "localeZH": "罗马尼亚语(罗马尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3844883d-dc41-47f3-85bc-22e390cf7fce.wav?sv=2019-07-07&sr=b&sig=CziB4c12et3rzLRg4zieY2Gzm9SamCCR4rQ8eSBm%2FdI%3D&st=2021-10-29T08:27:59Z&se=2121-10-05T08:32:59Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5fc3d49b-a679-4a6b-89cd-6be315fa06c9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-MA, MounaNeural)",
        "shortName": "ar-MA-MounaNeural",
        "locale": "ar-MA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Mouna",
            "LocalName": "منى",
            "ShortName": "ar-MA-MounaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "24",
            "LocaleDescription": "ar-MA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MounaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-MA",
            "localeZH": "阿拉伯语(摩洛哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a2b03517-c1c8-4260-866f-28b79cc6979e.wav?sv=2019-07-07&sr=b&sig=4oD4GcWko0tq6TxpSDX%2BGYCFI0zn9RLV2sSnhimY0pA%3D&st=2021-10-29T08:30:12Z&se=2121-10-05T08:35:12Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d289dfad-828e-445b-bec6-6cde6dd1663c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, YunzeNeural)",
        "shortName": "zh-CN-YunzeNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "OlderAdultMale,SeniorMale,Default",
            "VoiceRoleNameDefinitions": "{\"OlderAdultMale\":2,\"SeniorMale\":3,\"Default\":0}",
            "VoiceStyleNames": "calm,fearful,cheerful,disgruntled,serious,angry,sad,depressed,documentary-narration,Default",
            "VoiceStyleNameDefinitions": "{\"calm\":2,\"fearful\":3,\"cheerful\":4,\"disgruntled\":5,\"serious\":6,\"angry\":7,\"sad\":8,\"depressed\":10,\"Default\":0}",
            "DisplayName": "Yunze",
            "LocalName": "云泽",
            "ShortName": "zh-CN-YunzeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "443",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "YunzeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [
                {
                    "roleName": "Default",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fb28a3db-bf0f-4600-9608-1055ccfa8468.wav?sv=2019-07-07&sr=b&sig=6%2BpaFYEB9nSiPSZIYuRvfVsYPPGlH2k3NUxmrrQE4pk%3D&st=2022-08-01T10:44:27Z&se=2122-07-08T10:49:27Z&sp=rl"
                },
                {
                    "roleName": "OlderAdultMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/eef5dace-3cd0-48a4-8d6f-4a4ab6c8b3a5.wav?sv=2019-07-07&sr=b&sig=g8Kxr8fVa7Ko2ybvvvwORqY7UyPdceYAipcQRbZSlmA%3D&st=2022-08-01T10:44:30Z&se=2122-07-08T10:49:30Z&sp=rl"
                },
                {
                    "roleName": "SeniorMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/32a5e7e7-31cc-48ce-90de-36484e6d1a32.wav?sv=2019-07-07&sr=b&sig=Jo5PgDK%2FTDaaUL0NC%2BLgM0dUZodMaP4DjImssnHht7E%3D&st=2022-08-01T10:44:33Z&se=2122-07-08T10:49:33Z&sp=rl"
                }
            ],
            "styleSamples": [
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5145aab5-acea-46db-9d38-4e5c66db0732.wav?sv=2019-07-07&sr=b&sig=YE8iZvzukmCE7K%2BFbzxchb5rEdrIqMb%2FLbbwf%2FpG6Ww%3D&st=2022-08-01T10:40:27Z&se=2122-07-08T10:45:27Z&sp=rl"
                },
                {
                    "styleName": "calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6b45aacf-811a-4995-8424-899fc75f94a7.wav?sv=2019-07-07&sr=b&sig=HFYj0Xp9XFgdciUy3Ol69b%2BosdjGBot5t6SkFQ0fT4E%3D&st=2022-08-01T10:40:29Z&se=2122-07-08T10:45:29Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/11536dc1-f6cf-4120-84c7-f6dc74a88ef5.wav?sv=2019-07-07&sr=b&sig=TE6OhRh2SDs6e9hn4CQTcx2pWfQBhExKcNjRUZtuvks%3D&st=2022-08-01T10:40:32Z&se=2122-07-08T10:45:32Z&sp=rl"
                },
                {
                    "styleName": "depressed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3d745437-3e42-48a0-b2a0-323403099ef4.wav?sv=2019-07-07&sr=b&sig=jki73CufYU1csrqHEql6sLpkxb7vpW4APyL0uwyKzRA%3D&st=2022-08-01T10:40:35Z&se=2122-07-08T10:45:35Z&sp=rl"
                },
                {
                    "styleName": "disgruntled",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0430cb80-fa12-46bd-ba3f-4a4d8ea729fd.wav?sv=2019-07-07&sr=b&sig=z6z2e4nZedccDrTiMHmgCfCsfs9YfMyGGOMu5VqcHsM%3D&st=2022-08-01T10:40:37Z&se=2122-07-08T10:45:37Z&sp=rl"
                },
                {
                    "styleName": "documentary-narration",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a9148b56-90f5-4f08-b5fd-a9f20c283427.wav?sv=2019-07-07&sr=b&sig=dpEKuHmS3G2vUzPJgeXuJkAFMpwJ3k0XgLduMyR1cj0%3D&st=2022-08-01T10:40:40Z&se=2122-07-08T10:45:40Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ebd268e8-fbd4-45dd-b350-5c3b6a6f8072.wav?sv=2019-07-07&sr=b&sig=MOUW%2FJ%2FunZi5%2FFMDeIZIwcvOnNCbFCpS55%2ByBXnz1HU%3D&st=2022-08-01T10:40:43Z&se=2122-07-08T10:45:43Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b67a8984-b2c8-4308-97cb-3504670b4678.wav?sv=2019-07-07&sr=b&sig=fN4FBqbXXzVQyArs7z1JFxzf%2B0ptTjjJSgz%2Fpf3QiME%3D&st=2022-08-01T10:40:47Z&se=2122-07-08T10:45:47Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/15379477-fa67-4bc4-bb5b-83eb6014c448.wav?sv=2019-07-07&sr=b&sig=B3EXny%2FFmjHxgJ99%2BuENIAXtFBKJb4BzU%2BnvGsvT%2F68%3D&st=2022-08-01T10:40:50Z&se=2122-07-08T10:45:50Z&sp=rl"
                },
                {
                    "styleName": "serious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e3855e56-dd77-4d36-b0a5-557ff981cc66.wav?sv=2019-07-07&sr=b&sig=vO2y2za%2FumcGagZQIlY85%2FWlAAoG8qn9Q41CG1VX0Zk%3D&st=2022-08-01T10:40:52Z&se=2122-07-08T10:45:52Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0c9aeff2-a86f-4b3c-ad09-6dccc70e9bb5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (da-DK, JeppeNeural)",
        "shortName": "da-DK-JeppeNeural",
        "locale": "da-DK",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Jeppe",
            "LocalName": "Jeppe",
            "ShortName": "da-DK-JeppeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "55",
            "LocaleDescription": "Danish",
            "PreviewSentence": "Lav apps og tjenester, der taler naturligt til brugere, forbedrer tilgængelighed og brugervenlighed.",
            "DisplayVoiceName": "JeppeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "da-DK",
            "localeZH": "丹麦语(丹麦)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6cf8ec50-ea13-4fc5-bc44-504d0b3af5f4.wav?sv=2019-07-07&sr=b&sig=2WZ%2B1itqPSGtYxBwLiG4mcD%2FDBrROKXmjiTRMb2JoCg%3D&st=2021-10-29T08:26:09Z&se=2121-10-05T08:31:09Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5471da53-e81c-414c-a0f3-6de6935bb24a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-AT, JonasNeural)",
        "shortName": "de-AT-JonasNeural",
        "locale": "de-AT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Jonas",
            "LocalName": "Jonas",
            "ShortName": "de-AT-JonasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "57",
            "LocaleDescription": "German (Austria)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "JonasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-AT",
            "localeZH": "德语(奥地利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ed4dbd28-0ca6-40a0-9d05-01c424070474.wav?sv=2019-07-07&sr=b&sig=Wf7OfVfN2qAJOGSOng9JYgHr%2BbJHSpTaPn%2BMUFolY4s%3D&st=2021-10-29T08:26:11Z&se=2121-10-05T08:31:11Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f6369af4-16e6-4f7a-b2af-6ebcf9052252"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, HollieNeural)",
        "shortName": "en-GB-HollieNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Hollie",
            "LocalName": "Hollie",
            "ShortName": "en-GB-HollieNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "99",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "HollieNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a5e5caeb-843a-4f8c-858b-422ae3588b2b.wav?sv=2019-07-07&sr=b&sig=gf1FeXpRX1aRcmjhW0QsWi20GYvtSNdH6Xl%2FDjuKqp0%3D&st=2022-01-19T09:01:03Z&se=2121-12-26T09:06:03Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "de121e34-6b54-46b3-8766-6efeb7ebe53c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, GianniNeural)",
        "shortName": "it-IT-GianniNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gianni",
            "LocalName": "Gianni",
            "ShortName": "it-IT-GianniNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "282",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "GianniNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/be773246-a0f7-41c7-abfa-aa2bc44a7755.wav?sv=2019-07-07&sr=b&sig=i1Sl%2B%2BWapYf%2BDze3NKJm0CJ40dn4cGY53N8GG2Tcbuw%3D&st=2022-07-01T09:09:42Z&se=2122-06-07T09:14:42Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1953900b-4f14-4b18-bebc-6f21d8b67f36"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (id-ID, GadisNeural)",
        "shortName": "id-ID-GadisNeural",
        "locale": "id-ID",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gadis",
            "LocalName": "Gadis",
            "ShortName": "id-ID-GadisNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "272",
            "LocaleDescription": "Indonesian",
            "PreviewSentence": "Buat aplikasi dan layanan yang berbicara secara alami kepada pengguna, sehingga meningkatkan aksesibilitas dan kegunaan.",
            "DisplayVoiceName": "GadisNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "id-ID",
            "localeZH": "印度尼西亚语(印度尼西亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/63b0fa9f-1f3e-4fba-8a56-dcbecbc9fc6c.wav?sv=2019-07-07&sr=b&sig=liSiYhJBQ%2BhfpRNpo3XWHyy7GLdRoOlKEA5INJHapLc%3D&st=2021-10-29T08:27:16Z&se=2121-10-05T08:32:16Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "3e2e9811-2a35-45f3-97a3-6f2d255cd9e0"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (hu-HU, NoemiNeural)",
        "shortName": "hu-HU-NoemiNeural",
        "description": "",
        "locale": "hu-HU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Noemi",
            "LocalName": "Noémi",
            "ShortName": "hu-HU-NoemiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "267",
            "LocaleDescription": "Hungarian",
            "PreviewSentence": "Készítsen appokat és szolgáltatásokat, melyek természetes hangon beszélnek a felhasználóval, ezáltal hozzáférhetőbbek és könnyebben használhatóak.",
            "DisplayVoiceName": "NoemiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "hu-HU",
            "localeZH": "匈牙利语(匈牙利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6756708e-cb80-446b-bbf2-41a8938ca10d.wav?sv=2019-07-07&sr=b&sig=9E2YOw%2FZMga2ar0YnaU%2BKZ%2Fy1lBgBwwvETnlrXgkE%2FI%3D&st=2021-10-29T08:27:13Z&se=2121-10-05T08:32:13Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "23161424-2307-449a-9d24-6f50b7c09553"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-TW, HsiaoChenNeural)",
        "shortName": "zh-TW-HsiaoChenNeural",
        "locale": "zh-TW",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "HsiaoChen",
            "LocalName": "曉臻",
            "ShortName": "zh-TW-HsiaoChenNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "452",
            "LocaleDescription": "Chinese (Taiwan)",
            "PreviewSentence": "建構可以和使用者自然對話的應用程式和服務，來提高其方便性和實用性。",
            "DisplayVoiceName": "HsiaoChenNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "zh-TW",
            "localeZH": "中文(台湾普通话)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/28d0a866-cc6d-496b-9084-0bf48d6fa07e.wav?sv=2019-07-07&sr=b&sig=WwqH3hIg20fFO74KNGq8DWooUa1%2F0ET8THRRAR2zpko%3D&st=2021-10-29T08:29:51Z&se=2121-10-05T08:34:51Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "a67d97ed-51c3-4daa-a2f2-6fb669d48ab6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-CA, SylvieNeural)",
        "shortName": "fr-CA-SylvieNeural",
        "description": "",
        "locale": "fr-CA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sylvie",
            "LocalName": "Sylvie",
            "ShortName": "fr-CA-SylvieNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "236",
            "LocaleDescription": "French (Canada)",
            "PreviewSentence": "Créer des applications et des services qui parlent aux utilisateurs, améliorant ainsi l’accessibilité et la facilité d’utilisation.",
            "DisplayVoiceName": "SylvieNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-CA",
            "localeZH": "法语(加拿大)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cb0d45ba-42ef-46d5-b0ed-353bcf7feadb.wav?sv=2019-07-07&sr=b&sig=At7OK796JZWSXkWpXI3p3IfL6imH9ATKcRpNhFHjg4M%3D&st=2021-10-29T08:26:58Z&se=2121-10-05T08:31:58Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "400eb503-6c32-499c-b66a-714a04b1e0ea"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, JosephineNeural)",
        "shortName": "fr-FR-JosephineNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Josephine",
            "LocalName": "Josephine",
            "ShortName": "fr-FR-JosephineNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "250",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "JosephineNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d8ec632e-ad80-44ed-9c33-dcadf06470f9.wav?sv=2019-07-07&sr=b&sig=v2tPx5AdxddBhf9K7iLHxeTWDh2pplh38UrbwhhX%2BjQ%3D&st=2022-01-19T09:01:35Z&se=2121-12-26T09:06:35Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "65ea2440-7f3f-422f-8688-7177e3417cd9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, FabiolaNeural)",
        "shortName": "it-IT-FabiolaNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Fabiola",
            "LocalName": "Fabiola",
            "ShortName": "it-IT-FabiolaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "280",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "FabiolaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c29bfe43-92cd-49c1-abfd-a89af97d8df7.wav?sv=2019-07-07&sr=b&sig=KoLxrttwZNqlAZCdxA6wQbDxfIZ8ibaJMPSAjorgoBY%3D&st=2022-07-01T09:09:38Z&se=2122-06-07T09:14:38Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "883d200d-43ae-4b1d-a284-7226e93177ab"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (my-MM, ThihaNeural)",
        "shortName": "my-MM-ThihaNeural",
        "locale": "my-MM",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Thiha",
            "LocalName": "သီဟ",
            "ShortName": "my-MM-ThihaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "334",
            "LocaleDescription": "my-MM",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ThihaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "my-MM",
            "localeZH": "缅甸语(缅甸)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/181833fd-0cb3-472a-9ad9-0eed0d6267b2.wav?sv=2019-07-07&sr=b&sig=TwmsXR5INrTUYKiEg0YobBpcx%2Brv32cHwJ9G8Hfpu3A%3D&st=2021-10-29T08:31:12Z&se=2121-10-05T08:36:12Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "08456f07-f950-4fa5-b0ef-7266bf338fe3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (lv-LV, NilsNeural)",
        "shortName": "lv-LV-NilsNeural",
        "locale": "lv-LV",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Nils",
            "LocalName": "Nils",
            "ShortName": "lv-LV-NilsNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "320",
            "LocaleDescription": "Latvian (Latvia)",
            "PreviewSentence": "Balss Satura Izveide ļauj jums vizuāli kontrolēt runas atribūtus reālajā laikā.",
            "DisplayVoiceName": "NilsNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "lv-LV",
            "localeZH": "拉脱维亚语(拉脱维亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/424406ba-8c2d-4a4d-9124-950fbfd5ed38.wav?sv=2019-07-07&sr=b&sig=rulzEaPe6Ink8N%2F3DS%2FTbASyvOJpSMpxQNaU7%2B6gg6E%3D&st=2021-10-29T08:27:28Z&se=2121-10-05T08:32:28Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "89a21c17-e2e5-4732-8494-73b795c92857"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, LisandroNeural)",
        "shortName": "it-IT-LisandroNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Lisandro",
            "LocalName": "Lisandro",
            "ShortName": "it-IT-LisandroNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "285",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "LisandroNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6dbbcea7-91ab-42c8-925f-526d6c677fe8.wav?sv=2019-07-07&sr=b&sig=S7%2FSfHneBNx00JmnijjWP2%2F3qv2SnFA9kxb5ccW1MpA%3D&st=2022-07-01T09:09:49Z&se=2122-06-07T09:14:49Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "cb6c203f-d969-4c34-b13e-73ed92ce859c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN-liaoning, XiaobeiNeural)",
        "shortName": "zh-CN-liaoning-XiaobeiNeural",
        "locale": "zh-CN-liaoning",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Xiaobei",
            "LocalName": "晓北",
            "ShortName": "zh-CN-liaoning-XiaobeiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "445",
            "LocaleDescription": "zh-CN-liaoning",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "XiaobeiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "zh-CN-liaoning",
            "localeZH": "中文(东北官话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c988c129-ad9e-4f2a-836b-1b2c3e7801e9.wav?sv=2019-07-07&sr=b&sig=Vf8PddKQOyCL8nks4PpIb%2BQe1VOMsyXein0KKKY51cQ%3D&st=2022-05-12T09:49:37Z&se=2122-04-18T09:54:37Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "67f27a5a-944a-4590-8a79-741d3780e48a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, ChristophNeural)",
        "shortName": "de-DE-ChristophNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Christoph",
            "LocalName": "Christoph",
            "ShortName": "de-DE-ChristophNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "63",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "ChristophNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ba166b8f-cdcb-4c90-954e-7cdd749738ae.wav?sv=2019-07-07&sr=b&sig=Dx0ZKrx%2FeHp8tx9ABG2zCPWygMX4otY9Og7NJ8QwN0w%3D&st=2022-01-19T09:00:25Z&se=2121-12-26T09:05:25Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9662aa30-0632-4d8d-8c54-74dec56333e6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ga-IE, ColmNeural)",
        "shortName": "ga-IE-ColmNeural",
        "locale": "ga-IE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Colm",
            "LocalName": "Colm",
            "ShortName": "ga-IE-ColmNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "255",
            "LocaleDescription": "Irish (Ireland)",
            "PreviewSentence": "Cuireann Cruthú Ábhar Fuaime ar do chumas tréithe cainte a rialú i bhfíor-am.",
            "DisplayVoiceName": "ColmNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ga-IE",
            "localeZH": "爱尔兰语(爱尔兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ad87fa66-a7d8-4ffc-a264-7892712ed683.wav?sv=2019-07-07&sr=b&sig=AsKYEmtuILYC6MNlLUKDbgjpzLdsNvmzlq4i6te2SKs%3D&st=2021-10-29T08:27:03Z&se=2121-10-05T08:32:03Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7e2d1117-e923-43a9-a5a0-7514dc779b95"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, OliverNeural)",
        "shortName": "en-GB-OliverNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Oliver",
            "LocalName": "Oliver",
            "ShortName": "en-GB-OliverNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "102",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "OliverNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/816f4737-fdf6-484a-960e-0b137430474e.wav?sv=2019-07-07&sr=b&sig=4WMo0CWjZyjl%2FL3XxrPBcRqCx8BfHEzWi0zHFoCjhDs%3D&st=2022-01-19T09:01:10Z&se=2121-12-26T09:06:10Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "26118d30-06ba-4c1b-9f36-752135f87647"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (bn-BD, PradeepNeural)",
        "shortName": "bn-BD-PradeepNeural",
        "locale": "bn-BD",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Pradeep",
            "LocalName": "প্রদ্বীপ",
            "ShortName": "bn-BD-PradeepNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "42",
            "LocaleDescription": "bn-BD",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "PradeepNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "bn-BD",
            "localeZH": "孟加拉语(孟加拉)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6eb56666-9989-47c2-b0f5-8180ea71dedc.wav?sv=2019-07-07&sr=b&sig=SlwZedhjKBT40CmWDRtXnuT4paiE5pmu9UwnpLkQDYI%3D&st=2021-10-29T08:30:22Z&se=2121-10-05T08:35:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2645ee9c-4b0e-46a0-8085-76606154676a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaoqiuNeural)",
        "shortName": "zh-CN-XiaoqiuNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Xiaoqiu",
            "LocalName": "晓秋",
            "ShortName": "zh-CN-XiaoqiuNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "OlderAdult",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/80019f15-a6b7-4884-870d-09498de31a5c.png?sv=2019-07-07&sr=b&sig=hPqBfmzeeVzRP%2F%2BCzaCmq5KnC53PGWX8ooz6hk%2B43XQ%3D&st=2021-10-29T08:24:33Z&se=2121-10-05T08:29:33Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "429",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaoqiuNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Audiobook"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "晓秋散文展示",
                "titleLocalizationId": "zh-CN-XiaoqiuNeural_Masterpieces_AudioBook_ProseDemo_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/74b5543e-f8e5-43ad-91e4-2c0a7f5104b8.wav?sv=2019-07-07&sr=b&sig=85KUBXC20vzIniASJ4navwAkJhL2YWZYu7WqNbLmjSA%3D&st=2021-10-29T08:31:51Z&se=2121-10-05T08:36:51Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f3b22aba-8e0d-448e-9325-294a01fa8618.wav?sv=2019-07-07&sr=b&sig=WKTnMLUiODCJEaj8W38Oj4ipBJwW7F4wQadxyA%2FclQE%3D&st=2021-10-29T08:29:44Z&se=2121-10-05T08:34:44Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "53d185d8-dd7b-4184-b987-76b6f1ce8c41"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ja-JP, NaokiNeural)",
        "shortName": "ja-JP-NaokiNeural",
        "locale": "ja-JP",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Naoki",
            "LocalName": "直紀",
            "ShortName": "ja-JP-NaokiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "295",
            "LocaleDescription": "Japanese",
            "PreviewSentence": "アクセシビリティとユーザビリティを向上させながら、ユーザーに自然なことばを話すアプリとサービスを構築する",
            "DisplayVoiceName": "NaokiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ja-JP",
            "localeZH": "日语(日本)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/269259f1-c80f-446c-bb79-7482326822b8.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A30Z&se=2122-09-27T07%3A52%3A30Z&sr=b&sp=rl&sig=2JnV7PFGO%2Fbh9pIT1bSLF3yqEa2aHN9ehBDQWgnR5Qw%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9c696a0d-fb1b-485a-abeb-773b85297701"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, YunyeNeural)",
        "shortName": "zh-CN-YunyeNeural",
        "description": "Mature and relaxing voice with multiple emotions that is optimized for audio books.",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "YoungAdultFemale,YoungAdultMale,OlderAdultFemale,OlderAdultMale,SeniorFemale,SeniorMale,Girl,Boy,Default",
            "VoiceRoleNameDefinitions": "{\"YoungAdultFemale\":4,\"YoungAdultMale\":1,\"OlderAdultFemale\":5,\"OlderAdultMale\":2,\"SeniorFemale\":10,\"SeniorMale\":3,\"Girl\":8,\"Boy\":9,\"Default\":0}",
            "VoiceStyleNames": "embarrassed,calm,fearful,cheerful,disgruntled,serious,angry,sad,Default",
            "VoiceStyleNameDefinitions": "{\"embarrassed\":1,\"calm\":2,\"fearful\":3,\"cheerful\":4,\"disgruntled\":5,\"serious\":6,\"angry\":7,\"sad\":8,\"Default\":0}",
            "DisplayName": "Yunye",
            "LocalName": "云野",
            "ShortName": "zh-CN-YunyeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "OlderAdult",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3f214a6d-d32f-46e1-a2bf-43f45c472154?sv=2019-07-07&sr=b&sig=6uBXzG3uXqs5WMmE3bhGz1eTonPHLFc5dgFAm%2B%2F0w7c%3D&st=2021-10-29T08:24:31Z&se=2121-10-05T08:29:31Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "442",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "YunyeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Audiobook"
            },
            {
                "name": "Chat"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "云野有声书《朱自清散文集》",
                "titleLocalizationId": "zh-CN-YunyeNeural_Masterpieces_AudioBook_ZhuZiQingSanWenJi_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/833c684e-ead2-42d2-97bc-a20b710febab.wav?sv=2019-07-07&sr=b&sig=BHnUvOPyTcR4efp8GNVvoLLCQWbcNIRBhomIVpiFP6I%3D&st=2021-10-29T08:24:54Z&se=2121-10-05T08:29:54Z&sp=rl"
            },
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "云野有声书《金粉世家》",
                "titleLocalizationId": "zh-CN-YunyeNeural_Masterpieces_AudioBook_JinFenShiJia_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/06d63d0b-1c99-43f8-9519-474e2b89be37?sv=2019-07-07&sr=b&sig=RCY00H6MovZoLvd4tFyPdBIka51T8HO182QOS0hKl6A%3D&st=2021-10-29T08:24:52Z&se=2121-10-05T08:29:52Z&sp=rl"
            },
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "云野有声书《骆驼祥子》",
                "titleLocalizationId": "zh-CN-YunyeNeural_Masterpieces_AudioBook_LuoTuoXiangZi_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/382cb9cd-3c3b-40c1-8477-f3094c93438c?sv=2019-07-07&sr=b&sig=y%2BRdXIupJSQMSk0K7hqJddhDI%2Bb57rhlEF1EV4rJ6sw%3D&st=2021-10-29T08:24:53Z&se=2121-10-05T08:29:53Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [
                {
                    "roleName": "Default",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f5fc312c-a10a-4f0d-acb9-bd87489ec497.wav?sv=2019-07-07&sr=b&sig=x%2FEjeQdjX1ORPS%2FbVutUwm1%2BJVZFG4X40zwxPXpxsUA%3D&st=2021-12-20T11:29:48Z&se=2121-11-26T11:34:48Z&sp=rl"
                },
                {
                    "roleName": "Boy",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e0ede06b-a535-4f5e-82e6-db78ec3aa8a2.wav?sv=2019-07-07&sr=b&sig=DP562T5Si9KU8H4EaO%2BfCcVGpEul8lfnVoBfqczXeA4%3D&st=2021-12-20T11:29:50Z&se=2121-11-26T11:34:50Z&sp=rl"
                },
                {
                    "roleName": "Girl",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8d4ed42e-69aa-475c-8058-00da3ef001ff.wav?sv=2019-07-07&sr=b&sig=KlzSUmhOj%2F%2BgWangRvj17JLkO4fVAzJebOzrxhbqpAk%3D&st=2021-12-20T11:29:53Z&se=2121-11-26T11:34:53Z&sp=rl"
                },
                {
                    "roleName": "OlderAdultFemale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/289fd066-371f-4ebc-a048-1746f4decd47.wav?sv=2019-07-07&sr=b&sig=RITeVr3p7LVgt9z5wsFEHCMoUA2GzRmPyYcPYRrDv7I%3D&st=2021-12-20T11:29:56Z&se=2121-11-26T11:34:56Z&sp=rl"
                },
                {
                    "roleName": "OlderAdultMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/49c35ceb-c15e-4e78-85f4-6e28d72c0be0.wav?sv=2019-07-07&sr=b&sig=1BXNb%2BsZoT3ZFwoC7%2FacKoZmCdVAnQKByo11yj5GwKo%3D&st=2021-12-20T11:29:58Z&se=2121-11-26T11:34:58Z&sp=rl"
                },
                {
                    "roleName": "SeniorFemale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5f0c5d64-56a5-493b-9d97-91e94827805f.wav?sv=2019-07-07&sr=b&sig=qlQmTPM7q2TLalNUyyoSRHds0tEawvPRIb61T3xv8Og%3D&st=2021-12-20T11:30:01Z&se=2121-11-26T11:35:01Z&sp=rl"
                },
                {
                    "roleName": "SeniorMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/77ec8ad9-e8d6-4e91-a73f-f8496b80b19d.wav?sv=2019-07-07&sr=b&sig=tNCqZcks4%2BeqU6Rs7ixAfRa2IFEie36a5UFK2E4ARUg%3D&st=2021-12-20T11:30:04Z&se=2121-11-26T11:35:04Z&sp=rl"
                },
                {
                    "roleName": "YoungAdultFemale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5701e3cb-e13e-45fd-8a24-9f8de377b495.wav?sv=2019-07-07&sr=b&sig=sWQUN%2FjsHZ7yAEDBZ3PhOewcymGZOU%2BBzVlS6aPSYTc%3D&st=2021-12-20T11:30:07Z&se=2121-11-26T11:35:07Z&sp=rl"
                },
                {
                    "roleName": "YoungAdultMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/82ef7994-b50a-4d06-bbb2-0347eced8f0e.wav?sv=2019-07-07&sr=b&sig=r09nEgFcKiBDH%2B9NzeGyx3UXTfw5QkcQvUCBAK1P2q0%3D&st=2021-12-20T11:30:10Z&se=2121-11-26T11:35:10Z&sp=rl"
                }
            ],
            "styleSamples": [
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d8072a88-0df9-4ef2-bfca-3e72d446569f.wav?sv=2019-07-07&sr=b&sig=vCVB%2FbC%2FQBaJi8c7owxIZmtuR5eRC7dvdJQo8%2BKoP24%3D&st=2021-10-29T08:29:35Z&se=2121-10-05T08:34:35Z&sp=rl"
                },
                {
                    "styleName": "calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0ee24ea7-7ade-4fb6-b043-3a406d26dc7b.wav?sv=2019-07-07&sr=b&sig=yZLQWvcTO6HVbi9qgjZ%2Bk9eb5iwgjHbxgf0GyOwEcAc%3D&st=2021-10-29T08:29:36Z&se=2121-10-05T08:34:36Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/67e6267f-8f36-4685-87d4-5c10387de47f.wav?sv=2019-07-07&sr=b&sig=6XAD4uyDdRzCPMNpgQJSjYtstFoy%2BsNmLs0Dkn4%2B190%3D&st=2021-10-29T08:29:37Z&se=2121-10-05T08:34:37Z&sp=rl"
                },
                {
                    "styleName": "disgruntled",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a920fcf3-c833-4739-ac3c-4b0760da71b6.wav?sv=2019-07-07&sr=b&sig=G%2F%2BSwVqshvkhv3Y3BO%2FwMBqNdZEkjbspsSzZDT%2FjEd8%3D&st=2021-10-29T08:29:38Z&se=2121-10-05T08:34:38Z&sp=rl"
                },
                {
                    "styleName": "embarrassed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3fd8e827-4c5d-4a9f-84ea-fec6145d0619.wav?sv=2019-07-07&sr=b&sig=e3VwY4K1fEm3j45%2F6Qjp9qezg40xNXF6vdrCso79Ii8%3D&st=2021-12-02T05:02:34Z&se=2121-11-08T05:07:34Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2a34875c-4a4b-42f7-9d85-31dd2a619910.wav?sv=2019-07-07&sr=b&sig=E64MW%2F5nt79Q6uxcoSePL2yW7czOXF49nfzyocfsYh8%3D&st=2021-10-29T08:29:39Z&se=2121-10-05T08:34:39Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/22657aa6-9463-4f23-9d74-501f9a7f2322.wav?sv=2019-07-07&sr=b&sig=zEOeeFbKg%2FnZM2b0QJRyvA7pN4iZZNCvbH3u4rwp6tI%3D&st=2021-10-29T08:29:40Z&se=2121-10-05T08:34:40Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/88dbaf0d-5d23-48c1-aa91-8a9bd3b29d27.wav?sv=2019-07-07&sr=b&sig=0kOxLQmbqVYVtWQxYdYFuBtXNhz58DIH0Wn%2Bgcu%2B4G4%3D&st=2021-10-29T08:29:41Z&se=2121-10-05T08:34:41Z&sp=rl"
                },
                {
                    "styleName": "serious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cd1e1437-fcab-4fa8-995f-da0f2ed2fe37.wav?sv=2019-07-07&sr=b&sig=f1ENR%2F4RvkqYAKHsyf1jvLUmsEDyGIYw52eUcmhv3i8%3D&st=2021-10-29T08:29:42Z&se=2121-10-05T08:34:42Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "26014551-90d7-4f55-a622-779b8263e006"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, YvetteNeural)",
        "shortName": "fr-FR-YvetteNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yvette",
            "LocalName": "Yvette",
            "ShortName": "fr-FR-YvetteNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "253",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "YvetteNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6e470838-e1db-4a0d-be11-965afa071801.wav?sv=2019-07-07&sr=b&sig=mBAtETP5%2B1MFg5Yq5XTBXQ8lWywmmfO%2Fdof8u%2FcTL7Q%3D&st=2022-01-19T09:01:42Z&se=2121-12-26T09:06:42Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "58345d02-5c0f-472b-8b94-783420c8c66c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (bn-IN, BashkarNeural)",
        "shortName": "bn-IN-BashkarNeural",
        "locale": "bn-IN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Bashkar",
            "LocalName": "ভাস্কর",
            "ShortName": "bn-IN-BashkarNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "43",
            "LocaleDescription": "bn-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "BashkarNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "bn-IN",
            "localeZH": "孟加拉语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b77daa45-b965-4030-9986-dea6878133dc.wav?sv=2019-07-07&sr=b&sig=o6tiWtf4URUdvWl%2BUCaZGTNkycBwQonzx4OZ75oNDAY%3D&st=2022-01-19T09:00:15Z&se=2121-12-26T09:05:15Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1564dfc6-9cf9-46f6-a7d2-795415a99ce2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (wuu-CN, XiaotongNeural)",
        "shortName": "wuu-CN-XiaotongNeural",
        "locale": "wuu-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Xiaotong",
            "LocalName": "晓彤",
            "ShortName": "wuu-CN-XiaotongNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "419",
            "LocaleDescription": "wuu-CN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "XiaotongNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "wuu-CN",
            "localeZH": "中文(吴语，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d2fb7288-b63d-43c6-8278-c32dd02a9e99.wav?sv=2021-08-06&st=2022-10-21T11%3A57%3A25Z&se=2122-09-27T12%3A02%3A25Z&sr=b&sp=rl&sig=OMuveovC4OGwJ0OVIzAU9OVXcBswQGVbL82SV%2BGnbKs%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c5b73621-18c5-425b-9020-79aae71f827e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, DarrenNeural)",
        "shortName": "en-AU-DarrenNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Darren",
            "LocalName": "Darren",
            "ShortName": "en-AU-DarrenNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "79",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "DarrenNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a12b3920-f2fa-4f39-8394-0c73bd683e20.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A02Z&se=2122-09-27T07%3A51%3A02Z&sr=b&sp=rl&sig=vZNnb2WLQIQVuTWmKnIWkiydZabGn5e%2B%2Bb0ZWNkilmE%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2e31b5db-4def-4e35-9337-79bbdaf0cd87"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-PT, DuarteNeural)",
        "shortName": "pt-PT-DuarteNeural",
        "locale": "pt-PT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Duarte",
            "LocalName": "Duarte",
            "ShortName": "pt-PT-DuarteNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "365",
            "LocaleDescription": "Portuguese (Portugal)",
            "PreviewSentence": "Constrói aplicações e serviços que falam naturalmente com os utilizadores, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "DuarteNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-PT",
            "localeZH": "葡萄牙语(葡萄牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c769c060-7cab-4b02-a81c-89cb1d7e656d.wav?sv=2019-07-07&sr=b&sig=e7%2BSgctyqnpvUElP%2FHVRNWtedDyev34IsNSSC%2B6mshI%3D&st=2021-10-29T08:27:56Z&se=2121-10-05T08:32:56Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d278f8ad-6f2c-4c23-bcbb-7ad04efd3cd4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, FreyaNeural)",
        "shortName": "en-AU-FreyaNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Freya",
            "LocalName": "Freya",
            "ShortName": "en-AU-FreyaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "82",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "FreyaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/27388180-c38e-4d13-945c-372068d0297f.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A08Z&se=2122-09-27T07%3A51%3A08Z&sr=b&sp=rl&sig=QgfwGonOnsEZwAG6P0%2Fk737BcldebJEAvm2k3y964ww%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ec6ce467-9f53-456e-87cf-7bd553a30a0f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-CA, LiamNeural)",
        "shortName": "en-CA-LiamNeural",
        "locale": "en-CA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Liam",
            "LocalName": "Liam",
            "ShortName": "en-CA-LiamNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "92",
            "LocaleDescription": "English (Canada)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LiamNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-CA",
            "localeZH": "英语(加拿大)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6342589f-8c0a-4a55-858f-ef1d705c2d3d.wav?sv=2019-07-07&sr=b&sig=cb7YkaU0xDHXf1GmfI5g1XWdEKJZ%2FHoEpkGWE%2BpFSxo%3D&st=2021-10-29T08:26:21Z&se=2121-10-05T08:31:21Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "376a5073-f406-4a9e-bc6f-7c50b23201f8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, DuncanNeural)",
        "shortName": "en-AU-DuncanNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Duncan",
            "LocalName": "Duncan",
            "ShortName": "en-AU-DuncanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "80",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "DuncanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/26cef830-8f7d-4ca0-889b-e164852c56ec.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A04Z&se=2122-09-27T07%3A51%3A04Z&sr=b&sp=rl&sig=UN5IfgOQicvRByUjcHWb4UTacevlpm6BTZ6TCKtcvGs%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "a875feda-252a-4d1d-8e72-7cc3c8199f43"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (hy-AM, AnahitNeural)",
        "shortName": "hy-AM-AnahitNeural",
        "locale": "hy-AM",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Anahit",
            "LocalName": "Անահիտ",
            "ShortName": "hy-AM-AnahitNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "269",
            "LocaleDescription": "hy-AM",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AnahitNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "hy-AM",
            "localeZH": "亚美尼亚语(亚美尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/41138159-cac4-49ba-8805-3ca3386aacca.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A14Z&se=2122-09-27T07%3A52%3A14Z&sr=b&sp=rl&sig=hPywtUtD5RdG2IlC8dqfeG2IJWQCMq%2Fhr9%2FxKj%2B94gc%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f87a9492-b32f-46c4-a8bb-7f8c275edd5d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-NI, YolandaNeural)",
        "shortName": "es-NI-YolandaNeural",
        "locale": "es-NI",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yolanda",
            "LocalName": "Yolanda",
            "ShortName": "es-NI-YolandaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "206",
            "LocaleDescription": "es-NI",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "YolandaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-NI",
            "localeZH": "西班牙语(尼加拉瓜)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/331bf9a1-0141-444a-8557-11ee211d7c63.wav?sv=2019-07-07&sr=b&sig=nKbIJmKMox5ewP7DE3WetGv10NTUm3drGk65xtQvp4E%3D&st=2021-10-29T08:30:47Z&se=2121-10-05T08:35:47Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8aba6946-2d68-4b7a-a30a-7fef52c903a2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ja-JP, KeitaNeural)",
        "shortName": "ja-JP-KeitaNeural",
        "description": "",
        "locale": "ja-JP",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Keita",
            "LocalName": "圭太",
            "ShortName": "ja-JP-KeitaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "293",
            "LocaleDescription": "Japanese",
            "PreviewSentence": "アクセシビリティとユーザビリティを向上させながら、ユーザーに自然なことばを話すアプリとサービスを構築する",
            "DisplayVoiceName": "KeitaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ja-JP",
            "localeZH": "日语(日本)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cdfd5dcd-35fb-4864-a8c1-e44026ce28e5.wav?sv=2019-07-07&sr=b&sig=K6zrzLrNzl7PbenFDGORNUDtWQ2yGudLsaUUK1%2Bd5G8%3D&st=2021-10-29T08:27:20Z&se=2121-10-05T08:32:20Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "23c439de-2ff7-499f-90ff-80609f237c76"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, CataldoNeural)",
        "shortName": "it-IT-CataldoNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Cataldo",
            "LocalName": "Cataldo",
            "ShortName": "it-IT-CataldoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "278",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "CataldoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0092a25c-5c2c-402c-a68c-9a626597a048.wav?sv=2019-07-07&sr=b&sig=sj4ZRmhwVwTLk%2B8lCXWfrMjn2Ued%2BGbcU9VKM0k5yhI%3D&st=2022-07-01T09:09:36Z&se=2122-06-07T09:14:36Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "fd07655d-a8cf-4bcd-bcb8-8074ce0a5f7c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, FabioNeural)",
        "shortName": "pt-BR-FabioNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Fabio",
            "LocalName": "Fabio",
            "ShortName": "pt-BR-FabioNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "355",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "FabioNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f0312f12-c197-4733-b43f-9ccd3ca056dc.wav?sv=2019-07-07&sr=b&sig=doIve%2FaiU4HTa9RUHaMB5NrP9XaH6qyXd59X0bZ1uM0%3D&st=2022-07-01T09:10:17Z&se=2122-06-07T09:15:17Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2345e9ff-57a6-4938-80bc-8220d9e15365"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (bs-BA, VesnaNeural)",
        "shortName": "bs-BA-VesnaNeural",
        "locale": "bs-BA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Vesna",
            "LocalName": "Vesna",
            "ShortName": "bs-BA-VesnaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "46",
            "LocaleDescription": "bs-BA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "VesnaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "bs-BA",
            "localeZH": "波斯尼亚语(波斯尼亚和黑塞哥维那)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7296e0a5-991f-4f63-86fd-633ac5c7d4e9.wav?sv=2019-07-07&sr=b&sig=Kg2iY5MD3yZ8LBwTBtRIq3%2F%2FYID0AG83iC6KxHZBB7Y%3D&st=2022-07-01T09:08:59Z&se=2122-06-07T09:13:59Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "94bf333e-29f6-443b-bbf2-82eae8bb0ff8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (uz-UZ, SardorNeural)",
        "shortName": "uz-UZ-SardorNeural",
        "locale": "uz-UZ",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sardor",
            "LocalName": "Sardor",
            "ShortName": "uz-UZ-SardorNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "416",
            "LocaleDescription": "uz-UZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SardorNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "uz-UZ",
            "localeZH": "乌兹别克语(乌兹别克斯坦)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d3ebb75a-8352-4739-8cb9-f5f789c7ccef.wav?sv=2019-07-07&sr=b&sig=qCKbG2z1NdVYeIPdAvz1rgsD6eJhSH2TeIYETYljdH4%3D&st=2021-10-29T08:31:25Z&se=2121-10-05T08:36:25Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "fcf9b60e-1a55-4a08-841b-83085ecd3213"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (th-TH, PremwadeeNeural)",
        "shortName": "th-TH-PremwadeeNeural",
        "description": "",
        "locale": "th-TH",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Premwadee",
            "LocalName": "เปรมวดี",
            "ShortName": "th-TH-PremwadeeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "404",
            "LocaleDescription": "Thai",
            "PreviewSentence": "สร้างแอปและบริการที่สื่อสารกับผู้ใช้ได้อย่างเป็นธรรมชาติ ซึ่งช่วยปรับปรุงการเข้าถึงและการใช้งาน",
            "DisplayVoiceName": "PremwadeeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "th-TH",
            "localeZH": "泰语(泰国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/81279ff2-f187-4731-a5ea-ce5bd055e1c9.wav?sv=2019-07-07&sr=b&sig=Gr5GpRLS%2Fgfuf7h1jj6EFwnB2%2BlPzQLrOQlq5OmxwcU%3D&st=2021-10-29T08:28:21Z&se=2121-10-05T08:33:21Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "671a080c-7219-425c-8bfd-832ad1ab3d54"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fi-FI, HarriNeural)",
        "shortName": "fi-FI-HarriNeural",
        "locale": "fi-FI",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Harri",
            "LocalName": "Harri",
            "ShortName": "fi-FI-HarriNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "230",
            "LocaleDescription": "Finnish",
            "PreviewSentence": "Kehitä luonnolisesti puhuvia sovelluksia ja palveluja, jotka parantavat käytettävyyttä ja saavutettavuutta.",
            "DisplayVoiceName": "HarriNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fi-FI",
            "localeZH": "芬兰语(芬兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ac2f0948-c86d-4d07-aeec-5d4513205fd2.wav?sv=2019-07-07&sr=b&sig=yxGtpJ38OxqqdW6kBkVZc4SJoakioTFq1CVtVrDQmzo%3D&st=2021-10-29T08:26:51Z&se=2121-10-05T08:31:51Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "773fda1f-5210-4de3-aba4-833d434f0aa2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN-sichuan, YunxiNeural)",
        "shortName": "zh-CN-sichuan-YunxiNeural",
        "locale": "zh-CN-sichuan",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yunxi",
            "LocalName": "云希",
            "ShortName": "zh-CN-sichuan-YunxiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "448",
            "LocaleDescription": "zh-CN-sichuan",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "YunxiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "zh-CN-sichuan",
            "localeZH": "中文(西南官话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/50cfd6fc-a61d-40ca-a7e7-65f14bb56a92.wav?sv=2019-07-07&sr=b&sig=OvCA0F9kTxcUKb2QhZDdYiBq%2BAaHsVwwPpH7k3tze1Q%3D&st=2022-05-12T09:49:40Z&se=2122-04-18T09:54:40Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "383b7b38-8e3c-4ac1-a64c-8387ddee905e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (yue-CN, YunSongNeural)",
        "shortName": "yue-CN-YunSongNeural",
        "locale": "yue-CN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "YunSong",
            "LocalName": "云松",
            "ShortName": "yue-CN-YunSongNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "422",
            "LocaleDescription": "yue-CN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "YunSongNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "yue-CN",
            "localeZH": "中文(粤语，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cf76c61d-cd0b-4909-a18d-7bfefa75012c.wav?sv=2021-08-06&st=2022-10-21T11%3A57%3A35Z&se=2122-09-27T12%3A02%3A35Z&sr=b&sp=rl&sig=rxHl0ozNf%2FSsi3nzmvZvGeVuvwjaJHphWQ8z9DDNQUA%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7f98d131-4cb7-4799-9f4b-83d4803b2fea"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (gu-IN, NiranjanNeural)",
        "shortName": "gu-IN-NiranjanNeural",
        "locale": "gu-IN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Niranjan",
            "LocalName": "નિરંજન",
            "ShortName": "gu-IN-NiranjanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "260",
            "LocaleDescription": "gu-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "NiranjanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "gu-IN",
            "localeZH": "古吉拉特语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d5b66e3f-e5ef-42b0-b501-4bb503ee29da.wav?sv=2019-07-07&sr=b&sig=eZbDS70Aby4i9xWM9iiNIDEuCNHe45BI9SGzXo6VVCo%3D&st=2021-10-29T08:27:06Z&se=2121-10-05T08:32:06Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "036ea582-19ad-4f59-b909-840af667a8a8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (lt-LT, OnaNeural)",
        "shortName": "lt-LT-OnaNeural",
        "description": "",
        "locale": "lt-LT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ona",
            "LocalName": "Ona",
            "ShortName": "lt-LT-OnaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "318",
            "LocaleDescription": "Lithuanian (Lithuania)",
            "PreviewSentence": "Garso turinio kūrimas leidžia vizualiai kontroliuoti kalbos atributus realiu laiku.",
            "DisplayVoiceName": "OnaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "lt-LT",
            "localeZH": "立陶宛语(立陶宛)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/02d90da4-d18f-4c4a-8076-70770c0f44d9.wav?sv=2019-07-07&sr=b&sig=RxqThoXqsK5ypk6MAss3qWRPLB0PFY1XPGPO%2BBxoHWE%3D&st=2021-10-29T08:27:26Z&se=2121-10-05T08:32:26Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0315db55-dbe4-4cfc-b180-848698f8a0d5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sq-AL, AnilaNeural)",
        "shortName": "sq-AL-AnilaNeural",
        "locale": "sq-AL",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Anila",
            "LocalName": "Anila",
            "ShortName": "sq-AL-AnilaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "381",
            "LocaleDescription": "sq-AL",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AnilaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sq-AL",
            "localeZH": "阿尔巴尼亚语(阿尔巴尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a7b3b213-17cd-44b7-a3d5-807d0678f5f8.wav?sv=2019-07-07&sr=b&sig=sw6jpP5%2F86NaPVZPEwLsgvmxb5rTwY97b1pqkYtsn34%3D&st=2022-07-01T09:10:41Z&se=2122-06-07T09:15:41Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b7de9dd4-e3ef-4e76-91f0-84c598201a5d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-DO, EmilioNeural)",
        "shortName": "es-DO-EmilioNeural",
        "locale": "es-DO",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Emilio",
            "LocalName": "Emilio",
            "ShortName": "es-DO-EmilioNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "165",
            "LocaleDescription": "es-DO",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "EmilioNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-DO",
            "localeZH": "西班牙语(多米尼加共和国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2bd403dd-b761-458c-a4ed-18329dcf97ab.wav?sv=2019-07-07&sr=b&sig=cG8Usdjgsi3DKpJx%2FlG%2Faj0yA7aC7TA6UfxYJuDrxIY%3D&st=2021-10-29T08:30:36Z&se=2121-10-05T08:35:36Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "aa547b35-c8dd-44f5-82f2-84e053871500"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, SoniaNeural)",
        "shortName": "en-GB-SoniaNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "cheerful,sad,Default",
            "VoiceStyleNameDefinitions": "{\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Sonia",
            "LocalName": "Sonia",
            "ShortName": "en-GB-SoniaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "105",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SoniaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/90ad80b6-d25d-43df-9f42-e3ef54858147.wav?sv=2019-07-07&sr=b&sig=7VgjB0tHvIyfbLRf8OvdR1ZkW6o7kgL7Xuy8AXv4N9U%3D&st=2021-10-29T08:26:25Z&se=2121-10-05T08:31:25Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/26041f35-178c-4dd5-a3d4-048185800f04.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A28Z&se=2122-09-27T07%3A51%3A28Z&sr=b&sp=rl&sig=Strnkedt9A0yI4LfG5DYWzU9vhed8s9HKbLdZjdzQaI%3D"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e0702984-9bf0-4f8b-b35d-2a09a65c87b1.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A30Z&se=2122-09-27T07%3A51%3A30Z&sr=b&sp=rl&sig=5YcCzZd9agapkon3Ah%2FTFfoCEO6Yxbn8xhUZodkG1X8%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "4b1dc409-f234-45cf-bda5-852fa95d0e5f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, AshleyNeural)",
        "shortName": "en-US-AshleyNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ashley",
            "LocalName": "Ashley",
            "ShortName": "en-US-AshleyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "132",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AshleyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/11e9d76b-bf93-4f41-9c42-44d3fcf1c393.wav?sv=2019-07-07&sr=b&sig=K3wVi%2FJH8o9pA%2FciMjNGtfZBKvQ2MMCWzv1zBOtFE%2BM%3D&st=2021-10-29T08:25:30Z&se=2121-10-05T08:30:30Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e46f4f45-4768-4b53-b385-85a8a36e1410"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaoruiNeural)",
        "shortName": "zh-CN-XiaoruiNeural",
        "description": "Mature and wise voice with rich emotions that is optimized for audio books.",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "calm,fearful,angry,sad,Default",
            "VoiceStyleNameDefinitions": "{\"calm\":2,\"fearful\":3,\"angry\":7,\"sad\":8,\"Default\":0}",
            "DisplayName": "Xiaorui",
            "LocalName": "晓睿",
            "ShortName": "zh-CN-XiaoruiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "Senior",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3ee261ff-1255-409f-a4b1-a0e3f7feb47b?sv=2019-07-07&sr=b&sig=YkkZjowwmsMw3ElhUzlwaiAZAkvDXWDtSnjJKveo354%3D&st=2021-10-29T08:24:22Z&se=2121-10-05T08:29:22Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "430",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaoruiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Audiobook"
            },
            {
                "name": "Chat"
            }
        ],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9a205bee-ec6d-4602-9777-565e18ee31a1.wav?sv=2019-07-07&sr=b&sig=pQaeH13AdWRmKYp2%2FZWCEfZirYBzxucpsPqEfIX%2B1is%3D&st=2021-10-29T08:28:51Z&se=2121-10-05T08:33:51Z&sp=rl"
                },
                {
                    "styleName": "calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/29673675-977a-4b16-83e1-6a4ec3a5e8c1.wav?sv=2019-07-07&sr=b&sig=jyA736N%2BNxZWK4F%2BUnxSgvphnxB9dR3A5CYq4CTxiZU%3D&st=2021-10-29T08:28:52Z&se=2121-10-05T08:33:52Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/966b523f-a73a-4f44-8876-c6986841f3bf.wav?sv=2019-07-07&sr=b&sig=a%2F8SmsrI%2F3%2FB0nSGRKl7Q7mH2hM5KDSYkratjeUuTB4%3D&st=2021-10-29T08:28:53Z&se=2121-10-05T08:33:53Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/eeb7a254-cc10-4d51-ba72-71b6c5468d9c.wav?sv=2019-07-07&sr=b&sig=Chgw8SDGzUoORy1xVVvZ2bQ%2FF5kCeAdPMh2B7uMB8z4%3D&st=2021-10-29T08:28:54Z&se=2121-10-05T08:33:54Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3e18a2ac-fea4-4e74-ae1f-a65a2bb8084e.wav?sv=2019-07-07&sr=b&sig=BYGet%2BPQ5JvFYczj%2BMqzj8MR0ahdpxaN6AYhGr%2FNZ1s%3D&st=2021-10-29T08:28:55Z&se=2121-10-05T08:33:55Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "cf45435f-b5f9-47be-850f-85bda9d6bb73"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-KW, FahedNeural)",
        "shortName": "ar-KW-FahedNeural",
        "locale": "ar-KW",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Fahed",
            "LocalName": "فهد",
            "ShortName": "ar-KW-FahedNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "17",
            "LocaleDescription": "ar-KW",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "FahedNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-KW",
            "localeZH": "阿拉伯语(科威特)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/dc0228b8-528c-4d7b-be9b-561642b0fbb8.wav?sv=2019-07-07&sr=b&sig=6hkgcMfsY%2BEPcAEhrBBnb58tf9bte5qAWGDijcFmYHE%3D&st=2021-10-29T08:30:07Z&se=2121-10-05T08:35:07Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2a069bfe-6b35-47e1-a103-86506ec659fc"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-LY, OmarNeural)",
        "shortName": "ar-LY-OmarNeural",
        "locale": "ar-LY",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Omar",
            "LocalName": "أحمد",
            "ShortName": "ar-LY-OmarNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "22",
            "LocaleDescription": "ar-LY",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "OmarNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-LY",
            "localeZH": "阿拉伯语(利比亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6bae8062-57db-4e10-adfd-930efc0c953c.wav?sv=2019-07-07&sr=b&sig=VkGBY7eIHyWA8PM3sO7EnKFGqZUKVxb2N9uof%2FM8WFs%3D&st=2021-10-29T08:30:10Z&se=2121-10-05T08:35:10Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5791793c-2e22-4adb-a56c-86b6bae8c877"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zu-ZA, ThandoNeural)",
        "shortName": "zu-ZA-ThandoNeural",
        "locale": "zu-ZA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Thando",
            "LocalName": "Thando",
            "ShortName": "zu-ZA-ThandoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "455",
            "LocaleDescription": "zu-ZA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ThandoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "zu-ZA",
            "localeZH": "祖鲁语(南非)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/316dedb6-cc30-4933-a5fc-97d370c1f46f.wav?sv=2019-07-07&sr=b&sig=XTkMMi1389WvMCFkS8n890wfLTUvC%2FXkgHWveVBNQP0%3D&st=2021-10-29T08:31:27Z&se=2121-10-05T08:36:27Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7dde73d4-b5f8-418d-a8ce-87944c7d71bd"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, SaulNeural)",
        "shortName": "es-ES-SaulNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Saul",
            "LocalName": "Saul",
            "ShortName": "es-ES-SaulNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "179",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "SaulNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/de9cf74c-8a2d-498b-b7c3-e672faab28f9.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A52Z&se=2122-09-27T07%3A51%3A52Z&sr=b&sp=rl&sig=j%2FfVoPV%2FkQbbRynPoVGg%2BM6gGNape%2Feq8Veu5I0DPo0%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e86de0ab-f6ea-44dd-aa80-879755f632a6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, CarlotaNeural)",
        "shortName": "es-MX-CarlotaNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Carlota",
            "LocalName": "Carlota",
            "ShortName": "es-MX-CarlotaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "192",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "CarlotaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2cafbcb2-71e0-41e4-84ec-de07fd360f5a.wav?sv=2019-07-07&sr=b&sig=ZQkddCB58kA9l%2FT5bn9t3Ral9yQfZlPJxWMEDax4vZs%3D&st=2022-07-01T09:09:06Z&se=2122-06-07T09:14:06Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1e298d8e-ec77-48f6-a581-8944355f4c9f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-AE, FatimaNeural)",
        "shortName": "ar-AE-FatimaNeural",
        "locale": "ar-AE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Fatima",
            "LocalName": "فاطمة",
            "ShortName": "ar-AE-FatimaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "5",
            "LocaleDescription": "ar-AE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "FatimaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-AE",
            "localeZH": "阿拉伯语(阿拉伯联合酋长国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8b765698-8e2f-43c5-a8de-c933d56725e2.wav?sv=2019-07-07&sr=b&sig=4034B79%2FR9V2z3P0J1CwUzfHZ2SIgcauP20GmBufHs4%3D&st=2021-10-29T08:29:57Z&se=2121-10-05T08:34:57Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "45565610-2f20-4ea9-8218-8a33aea63676"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (lo-LA, KeomanyNeural)",
        "shortName": "lo-LA-KeomanyNeural",
        "locale": "lo-LA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Keomany",
            "LocalName": "ແກ້ວມະນີ",
            "ShortName": "lo-LA-KeomanyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "316",
            "LocaleDescription": "lo-LA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "KeomanyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "lo-LA",
            "localeZH": "老挝语(老挝) "
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/198dff99-8ccf-4b64-8ab2-701e65f58081.wav?sv=2019-07-07&sr=b&sig=pnOHJnv59MAcAfKyFudDHqVgOO5FmxOq46DKW%2BnILBk%3D&st=2022-01-19T09:02:00Z&se=2121-12-26T09:07:00Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8271d147-3d4c-4d0d-901c-8a3c3129f0bd"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (mn-MN, BataaNeural)",
        "shortName": "mn-MN-BataaNeural",
        "locale": "mn-MN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Bataa",
            "LocalName": "Батаа",
            "ShortName": "mn-MN-BataaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "325",
            "LocaleDescription": "mn-MN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "BataaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "mn-MN",
            "localeZH": "蒙古语(蒙古)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/aefef278-68fe-4767-bbf9-1199d1fc4998.wav?sv=2019-07-07&sr=b&sig=W9B0N8M7vI3lbf%2Fu0YobXB7r9%2BFdNNjmzyUEbANQDDk%3D&st=2022-07-01T09:10:02Z&se=2122-06-07T09:15:02Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1055210c-6d26-431b-b2ee-8a3e41e3c8c7"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-AT, IngridNeural)",
        "shortName": "de-AT-IngridNeural",
        "description": "",
        "locale": "de-AT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ingrid",
            "LocalName": "Ingrid",
            "ShortName": "de-AT-IngridNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "56",
            "LocaleDescription": "German (Austria)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "IngridNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-AT",
            "localeZH": "德语(奥地利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2d785dbc-6ae5-4f50-820b-4ef3409b7884.wav?sv=2019-07-07&sr=b&sig=a3HrwRcgBpgyqH9qh7DmzNnskYcj8iamjswr1NC0b0o%3D&st=2021-10-29T08:26:10Z&se=2121-10-05T08:31:10Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "3cf2978c-83d5-4b58-b793-8b835b5f0b5f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-CU, BelkysNeural)",
        "shortName": "es-CU-BelkysNeural",
        "locale": "es-CU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Belkys",
            "LocalName": "Belkys",
            "ShortName": "es-CU-BelkysNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "163",
            "LocaleDescription": "es-CU",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "BelkysNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-CU",
            "localeZH": "西班牙语(古巴)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/49e6a9fd-1e4a-40dc-9c14-0f18c34dd22d.wav?sv=2019-07-07&sr=b&sig=ANefeTLNrc3T3Shm8b5iNSegQ5lPkxhouoa0r%2FC0rg8%3D&st=2021-10-29T08:30:34Z&se=2121-10-05T08:35:34Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "95257341-5e70-4e75-a634-8c4c9b942fd9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (af-ZA, AdriNeural)",
        "shortName": "af-ZA-AdriNeural",
        "locale": "af-ZA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Adri",
            "LocalName": "Adri",
            "ShortName": "af-ZA-AdriNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "1",
            "LocaleDescription": "af-ZA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AdriNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "af-ZA",
            "localeZH": "南非荷兰语(南非)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8dac170e-2276-44c9-b3b8-efc5a1422aa7.wav?sv=2019-07-07&sr=b&sig=qdcKgZom8yECuEZcNb9wynoOcVxL2Hfre2Ju45jbDPg%3D&st=2021-10-29T08:29:54Z&se=2121-10-05T08:34:54Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e11668e8-1d34-4470-994a-8d10d2695e09"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, ElkeNeural)",
        "shortName": "de-DE-ElkeNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Elke",
            "LocalName": "Elke",
            "ShortName": "de-DE-ElkeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "64",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "ElkeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/73d16ddf-bd65-4642-a8a7-b89ddb215ced.wav?sv=2019-07-07&sr=b&sig=vvRAAKSPqgerq1p3Ioslk%2BmxmwOLJnjdMhMUMFUOxrQ%3D&st=2022-01-19T09:00:27Z&se=2121-12-26T09:05:27Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9156f60c-d3fe-40fb-9346-8d6ae6c8da04"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-LY, ImanNeural)",
        "shortName": "ar-LY-ImanNeural",
        "locale": "ar-LY",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Iman",
            "LocalName": "إيمان",
            "ShortName": "ar-LY-ImanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "21",
            "LocaleDescription": "ar-LY",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ImanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-LY",
            "localeZH": "阿拉伯语(利比亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2846cb66-e641-4fb1-97bf-217a96723f90.wav?sv=2019-07-07&sr=b&sig=yF1hEgSfE6oC6Al2Md6NNGa%2FY7IHin%2FEPbzpTfNNwPA%3D&st=2021-10-29T08:30:09Z&se=2121-10-05T08:35:09Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "4c21507e-7a5d-4071-81a4-8da05a039a60"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fil-PH, AngeloNeural)",
        "shortName": "fil-PH-AngeloNeural",
        "locale": "fil-PH",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Angelo",
            "LocalName": "Angelo",
            "ShortName": "fil-PH-AngeloNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "232",
            "LocaleDescription": "fil-PH",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AngeloNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fil-PH",
            "localeZH": "菲律宾语(菲律宾)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ce45595b-d8f4-4130-810a-9aa253619d89.wav?sv=2019-07-07&sr=b&sig=yVBWxbcmIFkBUjEqDfKEGtMTfFdnV3tt3BDubMuHnt8%3D&st=2021-10-29T08:31:03Z&se=2121-10-05T08:36:03Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5412d6b7-554c-40ab-9892-8e2c80386b41"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-PH, RosaNeural)",
        "shortName": "en-PH-RosaNeural",
        "locale": "en-PH",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Rosa",
            "LocalName": "Rosa",
            "ShortName": "en-PH-RosaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "121",
            "LocaleDescription": "English (Philippines)",
            "PreviewSentence": "Audio Content Creation enables you to visually control speech attributes in real-time.",
            "DisplayVoiceName": "RosaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-PH",
            "localeZH": "英语(菲律宾)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d6fbef23-ab20-4d14-a289-4291c8238d1e.wav?sv=2019-07-07&sr=b&sig=3JJfTvETpd1EGWRXjDhXe0bVtP%2FfeAHIwpQwwIU%2FG1g%3D&st=2021-10-29T08:26:35Z&se=2121-10-05T08:31:35Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c3232411-1b92-4959-a799-8e2df59186eb"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, JulioNeural)",
        "shortName": "pt-BR-JulioNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Julio",
            "LocalName": "Julio",
            "ShortName": "pt-BR-JulioNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "358",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "JulioNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/68567018-c9b0-45e4-88da-359067d038f4.wav?sv=2019-07-07&sr=b&sig=8YhvSCEMDztN29NbZ4vNR4YxZqQfB0NEktygWSUawhc%3D&st=2022-07-01T09:10:24Z&se=2122-06-07T09:15:24Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2e6ce445-6c53-46d9-b8db-8fecb87dade2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, AnaNeural)",
        "shortName": "en-US-AnaNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ana",
            "LocalName": "Ana",
            "ShortName": "en-US-AnaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "130",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AnaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fc970c36-b330-470a-a367-5cd674474f18.wav?sv=2019-07-07&sr=b&sig=Dyhzua4F0iwrpeRQiln8pgU2%2BPI1mH%2FarbMcSKDZBWs%3D&st=2021-10-29T08:25:14Z&se=2121-10-05T08:30:14Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2c82b4c7-1b43-46f4-a021-9038c848dce9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-IE, ConnorNeural)",
        "shortName": "en-IE-ConnorNeural",
        "locale": "en-IE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Connor",
            "LocalName": "Connor",
            "ShortName": "en-IE-ConnorNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "110",
            "LocaleDescription": "English (Ireland)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ConnorNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-IE",
            "localeZH": "英语(爱尔兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d989d27a-6f8b-4771-89d8-73dbb6e6eb3e.wav?sv=2019-07-07&sr=b&sig=8bcfsjZsJKqAVn6HF9ee80KBxtANX1NlKeo0C40xHRQ%3D&st=2021-10-29T08:26:28Z&se=2121-10-05T08:31:28Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7db746e5-4da7-41da-8c5a-906f244effb5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sk-SK, ViktoriaNeural)",
        "shortName": "sk-SK-ViktoriaNeural",
        "description": "",
        "locale": "sk-SK",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Viktoria",
            "LocalName": "Viktória",
            "ShortName": "sk-SK-ViktoriaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "376",
            "LocaleDescription": "Slovak",
            "PreviewSentence": "Vytvárajú aplikácie a služby, ktoré prirodzene komunikujú s užívateľmi, čím sa zlepšuje dostupnosť a využiteľnosť.",
            "DisplayVoiceName": "ViktoriaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sk-SK",
            "localeZH": "斯洛伐克语(斯洛伐克)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5462d2b5-d9b8-4803-896c-e0f8ef79cd1b.wav?sv=2019-07-07&sr=b&sig=mJOj3juPRy8uyD1gi3Uz1XiF2A0VsJifz5lMu74MNrc%3D&st=2021-10-29T08:28:06Z&se=2121-10-05T08:33:06Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "28faf9ae-a1b3-4c82-a002-914e73d7e232"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ko-KR, BongJinNeural)",
        "shortName": "ko-KR-BongJinNeural",
        "locale": "ko-KR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "BongJin",
            "LocalName": "봉진",
            "ShortName": "ko-KR-BongJinNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "309",
            "LocaleDescription": "Korean",
            "PreviewSentence": "사용자들에게 자연스럽게 이야기하는 앱과 서비스를 만들며 접근성과 사용성을 개선시킵니다.",
            "DisplayVoiceName": "BongJinNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "ko-KR",
            "localeZH": "韩语(韩国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/29b9ce12-d811-49b3-9c06-73ae6f134a24.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A35Z&se=2122-09-27T07%3A52%3A35Z&sr=b&sp=rl&sig=hH3zuR%2Fe%2B2yUA5vDzRuW7%2BeMREkniEeXGUCY6S%2BMtWU%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "44ee81ca-a1f8-4c3d-9e1e-921b1d005970"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sv-SE, SofieNeural)",
        "shortName": "sv-SE-SofieNeural",
        "locale": "sv-SE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sofie",
            "LocalName": "Sofie",
            "ShortName": "sv-SE-SofieNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "387",
            "LocaleDescription": "Swedish",
            "PreviewSentence": "Bygg appar och tjänster som talar naturligt till användarna, och förbättrar tillgänglighet och användbarhet.",
            "DisplayVoiceName": "SofieNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sv-SE",
            "localeZH": "瑞典语(瑞典)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a6133923-5cb6-4d81-b9f4-3c7b2d1c873a.wav?sv=2019-07-07&sr=b&sig=H93zej0g%2B0YKmIlOMngAZqeCzFtrKoFvIoTIvAWWYuA%3D&st=2021-10-29T08:28:12Z&se=2121-10-05T08:33:12Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6b2759f1-56db-4281-bde8-9235313dea7c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (et-EE, KertNeural)",
        "shortName": "et-EE-KertNeural",
        "locale": "et-EE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Kert",
            "LocalName": "Kert",
            "ShortName": "et-EE-KertNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "224",
            "LocaleDescription": "Estonian (Estonia)",
            "PreviewSentence": "Audio Content Creation võimaldab kõne atribuute reaalajas visuaalselt kontrollida.",
            "DisplayVoiceName": "KertNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "et-EE",
            "localeZH": "爱沙尼亚语(爱沙尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/25011293-872a-4ead-a43f-9cc969242377.wav?sv=2019-07-07&sr=b&sig=HtZ8NUqud7HCPJveiZYsB9FzvC5xJ7eDRiLBcxolXtQ%3D&st=2021-10-29T08:26:50Z&se=2121-10-05T08:31:50Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "67e7d63e-f225-45e4-b75a-9266364fadb1"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-GT, MartaNeural)",
        "shortName": "es-GT-MartaNeural",
        "locale": "es-GT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Marta",
            "LocalName": "Marta",
            "ShortName": "es-GT-MartaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "187",
            "LocaleDescription": "es-GT",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MartaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-GT",
            "localeZH": "西班牙语(危地马拉)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2fdb7a4a-3307-4af6-85ac-35a80fbf5464.wav?sv=2019-07-07&sr=b&sig=axim%2BAGCbgtOQEdf2vNnuFWvQQikHrJrCtdhxfioet0%3D&st=2021-10-29T08:30:43Z&se=2121-10-05T08:35:43Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "16fd5e4d-8f1b-4f15-ab8b-92e31b1057a0"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (am-ET, MekdesNeural)",
        "shortName": "am-ET-MekdesNeural",
        "locale": "am-ET",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Mekdes",
            "LocalName": "መቅደስ",
            "ShortName": "am-ET-MekdesNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "4",
            "LocaleDescription": "am-ET",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MekdesNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "am-ET",
            "localeZH": "阿姆哈拉语(埃塞俄比亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/44ae7c7c-fd1d-4a0c-9450-562e725a11e7.wav?sv=2019-07-07&sr=b&sig=3XnccvXBx%2Bq1ELE7OavWGV9tmawr9R7iXL1PnZrEZOE%3D&st=2021-10-29T08:29:56Z&se=2121-10-05T08:34:56Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d9893835-d9d8-4485-ad27-930b275a733c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, SteffanNeural)",
        "shortName": "en-US-SteffanNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Steffan",
            "LocalName": "Steffan",
            "ShortName": "en-US-SteffanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "147",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SteffanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "AudioBook",
                "titleLocalizationId": "AudioBook",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6f014d26-4cdc-4846-8149-fea5688f4fdd.wav?sv=2021-08-06&st=2022-10-11T09%3A55%3A53Z&se=2122-09-17T10%3A00%3A53Z&sr=b&sp=rl&sig=UVYH8aw7E43F5pGDSvkJmXLSCT5xNcAJzxkBU3jjHmk%3D"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4d8beb7e-4f4b-4524-a2b2-03767469ef14.wav?sv=2021-08-06&st=2022-10-11T09%3A55%3A50Z&se=2122-09-17T10%3A00%3A50Z&sr=b&sp=rl&sig=BdJiKHIBt%2FNpfgIGgZYyA4aOuCyFGDTol%2FCvfvC%2FESU%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "09b38d23-ad18-4617-969a-9343d9021cb2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, BellaNeural)",
        "shortName": "en-GB-BellaNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Bella",
            "LocalName": "Bella",
            "ShortName": "en-GB-BellaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "96",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "BellaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e8522ceb-7bc2-4ad4-ac70-f2120135edff.wav?sv=2019-07-07&sr=b&sig=AUND%2FfBPmPPLpN85jGgp5yZiCye%2F%2BbYo3ueALLFVhpM%3D&st=2022-01-19T09:00:56Z&se=2121-12-26T09:05:56Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c08e4841-7cad-46b1-b4a7-93e996c7f5f9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, BeatrizNeural)",
        "shortName": "es-MX-BeatrizNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Beatriz",
            "LocalName": "Beatriz",
            "ShortName": "es-MX-BeatrizNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "190",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "BeatrizNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bca9bdd2-31b6-4db2-bb28-3705c416cae2.wav?sv=2019-07-07&sr=b&sig=ziYgItCUIojuPfriR1%2BlgLObBNEHLqI%2BrP2879jbgOE%3D&st=2022-07-01T09:09:02Z&se=2122-06-07T09:14:02Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2d9c6678-091a-48fb-bae9-940ffc4a138c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, AIGenerate2Neural)",
        "shortName": "en-US-AIGenerate2Neural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "AIGenerate2",
            "LocalName": "AIGenerate2",
            "ShortName": "en-US-AIGenerate2Neural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "150",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AIGenerate2Neural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bebccb1e-2c65-4a68-9c95-f95ab56a842e.wav?sv=2019-07-07&sr=b&sig=PBxUYy%2BCprNYD11L2G2r3WAZU3Hbu39ja6tpwTaSCIQ%3D&st=2022-08-30T16:24:59Z&se=2122-08-06T16:29:59Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "869464e6-c35a-4f15-ab1f-94b415772a37"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ml-IN, MidhunNeural)",
        "shortName": "ml-IN-MidhunNeural",
        "locale": "ml-IN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Midhun",
            "LocalName": "മിഥുൻ",
            "ShortName": "ml-IN-MidhunNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "323",
            "LocaleDescription": "ml-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MidhunNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ml-IN",
            "localeZH": "马拉雅拉姆语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0f81bfce-10a6-4e9e-8407-8d15bca2cb8f.wav?sv=2019-07-07&sr=b&sig=wmHJMGQLEmZUp7WJ1ep%2F%2FGcTSeW9v1VaAndLDPSt87M%3D&st=2022-01-19T09:02:06Z&se=2121-12-26T09:07:06Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f558e661-1dad-4bad-a08d-952619b409b7"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ta-IN, PallaviNeural)",
        "shortName": "ta-IN-PallaviNeural",
        "description": "",
        "locale": "ta-IN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Pallavi",
            "LocalName": "பல்லவி",
            "ShortName": "ta-IN-PallaviNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "394",
            "LocaleDescription": "Tamil (India)",
            "PreviewSentence": "பயனர்களிடம் இயற்கையாக பேசும் பயன்பாடுகள் மற்றும் சேவைகளை உருவாகுதல், இது அணுகல்தன்மை மற்றும் பயன்பாட்டினை மேம்படுத்தும்.",
            "DisplayVoiceName": "PallaviNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ta-IN",
            "localeZH": "泰米尔语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/48e60502-9864-4c14-a77b-8f5ea915a44f.wav?sv=2019-07-07&sr=b&sig=huhA8AXrqpFW%2Fq6GemtZRHQvV0iab2KmkjiHkj56p2M%3D&st=2021-10-29T08:28:15Z&se=2121-10-05T08:33:15Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d88b672d-537b-4139-aab5-95e6d24cf777"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (hi-IN, SwaraNeural)",
        "shortName": "hi-IN-SwaraNeural",
        "description": "",
        "locale": "hi-IN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Swara",
            "LocalName": "स्वरा",
            "ShortName": "hi-IN-SwaraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "264",
            "LocaleDescription": "Hindi (India)",
            "PreviewSentence": "ऐसे ऐप और सेवाओं का निर्माण करें जो उपयोगकर्ताओं से आम बोलचाल की भाषा में बात करे, जिससे सुगमता और उपयोगिता बढ़े।",
            "DisplayVoiceName": "SwaraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "hi-IN",
            "localeZH": "印地语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5325f2e4-bf1f-493c-bd2c-308b25cb309d.wav?sv=2019-07-07&sr=b&sig=LZXsPjcco%2FEjtY1uf8cTvGl7ybHz7uFq1Z%2F60tyeFdM%3D&st=2021-10-29T08:27:10Z&se=2121-10-05T08:32:10Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f7a54768-ea66-4a86-a2d5-97709ec8469f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, ManuelaNeural)",
        "shortName": "pt-BR-ManuelaNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Manuela",
            "LocalName": "Manuela",
            "ShortName": "pt-BR-ManuelaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "361",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "ManuelaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bac7c1b0-a430-4777-989c-bd5074077b75.wav?sv=2019-07-07&sr=b&sig=A3xzY8DPUiqi3RKmD%2B66A8BM2EtLtS%2B35OaY66Wxz68%3D&st=2022-07-01T09:10:31Z&se=2122-06-07T09:15:31Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ecc04a6b-9488-43da-a0a0-979ea15ce81e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-KW, NouraNeural)",
        "shortName": "ar-KW-NouraNeural",
        "locale": "ar-KW",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Noura",
            "LocalName": "نورا",
            "ShortName": "ar-KW-NouraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "18",
            "LocaleDescription": "ar-KW",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "NouraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-KW",
            "localeZH": "阿拉伯语(科威特)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/de29b460-0bc0-4f27-8ebd-9436cb83a42e.wav?sv=2019-07-07&sr=b&sig=jBTayCbm0PqGD5jEG1Nc8XQbuxzLDnOoz7Yj5njPBU4%3D&st=2021-10-29T08:30:08Z&se=2121-10-05T08:35:08Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "dbb2c827-a5e7-439a-ba4d-97e3a4ee5b81"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sw-TZ, DaudiNeural)",
        "shortName": "sw-TZ-DaudiNeural",
        "locale": "sw-TZ",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Daudi",
            "LocalName": "Daudi",
            "ShortName": "sw-TZ-DaudiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "392",
            "LocaleDescription": "sw-TZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "DaudiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sw-TZ",
            "localeZH": "斯瓦希里语(坦桑尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4f3c24d6-3c13-444a-922f-34125f933d43.wav?sv=2019-07-07&sr=b&sig=c4su9oudVJCoAUotKufy8HHtvxA4JDpk%2FyVoTvsQyGU%3D&st=2021-10-29T08:31:17Z&se=2121-10-05T08:36:17Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f4528154-ee1b-46da-997d-98d08c75000b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-CA, ClaraNeural)",
        "shortName": "en-CA-ClaraNeural",
        "description": "",
        "locale": "en-CA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Clara",
            "LocalName": "Clara",
            "ShortName": "en-CA-ClaraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "91",
            "LocaleDescription": "English (Canada)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ClaraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-CA",
            "localeZH": "英语(加拿大)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5717085c-c4c5-4bae-add6-0942edbcf166.wav?sv=2019-07-07&sr=b&sig=iCuuo%2BiAcUR0HZVN5hf3eiHTdUm%2BEW%2FCmzd8xuQlz14%3D&st=2021-10-29T08:26:20Z&se=2121-10-05T08:31:20Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f6c86801-3b7f-4cc3-abd7-996a740183fb"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, ThomasNeural)",
        "shortName": "en-GB-ThomasNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Thomas",
            "LocalName": "Thomas",
            "ShortName": "en-GB-ThomasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "106",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ThomasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b70b61f0-b991-435c-b2c3-a1cc51149c07.wav?sv=2019-07-07&sr=b&sig=WmzCiZkpqwnxyGwXQFwdZAphptuFKZVq6zC7oxIU5RM%3D&st=2022-01-19T09:01:15Z&se=2121-12-26T09:06:15Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5ddfa17b-a678-4f98-9915-9a0691680e44"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (lv-LV, EveritaNeural)",
        "shortName": "lv-LV-EveritaNeural",
        "description": "",
        "locale": "lv-LV",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Everita",
            "LocalName": "Everita",
            "ShortName": "lv-LV-EveritaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "319",
            "LocaleDescription": "Latvian (Latvia)",
            "PreviewSentence": "Balss Satura Izveide ļauj jums vizuāli kontrolēt runas atribūtus reālajā laikā.",
            "DisplayVoiceName": "EveritaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "lv-LV",
            "localeZH": "拉脱维亚语(拉脱维亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/308d7f89-d506-410d-80f2-813428428660.wav?sv=2019-07-07&sr=b&sig=i4gEjyfpJ15ezhJ2IdcxnVvzuLpu5K6q7kH3ZMOw%2Bug%3D&st=2021-10-29T08:27:27Z&se=2121-10-05T08:32:27Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "24eb77d1-92ad-4a88-a89d-9a3f741091fc"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-BH, LailaNeural)",
        "shortName": "ar-BH-LailaNeural",
        "locale": "ar-BH",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Laila",
            "LocalName": "ليلى",
            "ShortName": "ar-BH-LailaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "8",
            "LocaleDescription": "ar-BH",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LailaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-BH",
            "localeZH": "阿拉伯语(巴林)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/76b21d5b-227f-49a1-9842-a310c745c644.wav?sv=2019-07-07&sr=b&sig=gtb7okwaYopjK97zKmkG5b7ng%2F9xi3pc3XqVaoN6sjE%3D&st=2021-10-29T08:30:00Z&se=2121-10-05T08:35:00Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "32e36049-31f4-4924-b153-9ae203367d08"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, EloiseNeural)",
        "shortName": "fr-FR-EloiseNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Eloise",
            "LocalName": "Eloise",
            "ShortName": "fr-FR-EloiseNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "246",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "EloiseNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/188c6547-c2ea-4fe8-8fda-6fbf246e333b.wav?sv=2019-07-07&sr=b&sig=CzqRFazZdPEYoXWEIVDWO%2B%2FQLSGcwiDEqZ9MbuIcQqI%3D&st=2022-01-19T09:01:28Z&se=2121-12-26T09:06:28Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "94d6a384-5800-4fba-ba4f-9b19e8904d65"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-AR, TomasNeural)",
        "shortName": "es-AR-TomasNeural",
        "locale": "es-AR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Tomas",
            "LocalName": "Tomas",
            "ShortName": "es-AR-TomasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "154",
            "LocaleDescription": "es-AR",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "TomasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-AR",
            "localeZH": "西班牙语(阿根廷)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f70d05b7-05e1-4362-a172-ac5a70e69b10.wav?sv=2019-07-07&sr=b&sig=anI%2BCGMi6h1Vc0hWIQM1OcFYvAyHdYbA1pdMB%2Fbx%2FaE%3D&st=2021-10-29T08:26:41Z&se=2121-10-05T08:31:41Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b948cf84-935c-47a9-a943-9c7fdb42cde9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-TN, HediNeural)",
        "shortName": "ar-TN-HediNeural",
        "locale": "ar-TN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Hedi",
            "LocalName": "هادي",
            "ShortName": "ar-TN-HediNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "33",
            "LocaleDescription": "ar-TN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "HediNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-TN",
            "localeZH": "阿拉伯语(突尼斯)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a576c062-c540-4e29-bef8-76a97624ad91.wav?sv=2019-07-07&sr=b&sig=6Y6fIeUriEfR8cxum%2BNwzLgJ9cqnWyR1y4qHbpyatlk%3D&st=2021-10-29T08:30:17Z&se=2121-10-05T08:35:17Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "48416c15-6a97-4f7d-adeb-9ca25f4f4d5b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (da-DK, ChristelNeural)",
        "shortName": "da-DK-ChristelNeural",
        "description": "",
        "locale": "da-DK",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Christel",
            "LocalName": "Christel",
            "ShortName": "da-DK-ChristelNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "54",
            "LocaleDescription": "Danish",
            "PreviewSentence": "Lav apps og tjenester, der taler naturligt til brugere, forbedrer tilgængelighed og brugervenlighed.",
            "DisplayVoiceName": "ChristelNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "da-DK",
            "localeZH": "丹麦语(丹麦)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/78249d9a-dd2b-4148-b78d-386d4c52a2c8.wav?sv=2019-07-07&sr=b&sig=McuAUYLuQiIdLOT35hmHjHRLXLfrvcl%2BcDtT6SBa8wA%3D&st=2021-10-29T08:26:08Z&se=2121-10-05T08:31:08Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2ddbca91-11ca-43ba-aa09-9d20346f7a5a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (uk-UA, OstapNeural)",
        "shortName": "uk-UA-OstapNeural",
        "locale": "uk-UA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ostap",
            "LocalName": "Остап",
            "ShortName": "uk-UA-OstapNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "409",
            "LocaleDescription": "Ukrainian (Ukraine)",
            "PreviewSentence": "Створення аудіовмісту дозволяє візуально контролювати мовні атрибути в реальному часі.",
            "DisplayVoiceName": "OstapNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "uk-UA",
            "localeZH": "乌克兰语(乌克兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ab05c7ab-b79c-4aad-8466-2db2e5db03e9.wav?sv=2019-07-07&sr=b&sig=1%2BD%2FDbWDMKKm5N2EzF8r1InK836o3IMmZ%2FVUsGgioCE%3D&st=2021-10-29T08:28:25Z&se=2121-10-05T08:33:25Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d045ab76-5577-40b1-862b-a05fc5edf4ac"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-CU, ManuelNeural)",
        "shortName": "es-CU-ManuelNeural",
        "locale": "es-CU",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Manuel",
            "LocalName": "Manuel",
            "ShortName": "es-CU-ManuelNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "164",
            "LocaleDescription": "es-CU",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ManuelNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-CU",
            "localeZH": "西班牙语(古巴)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a8e9cb11-1ea2-4cfa-8c0d-248974384684.wav?sv=2019-07-07&sr=b&sig=r6TW9%2BoePa3EuSDomSJDKOpWxyWrjxkPY3sarSFdh6E%3D&st=2021-10-29T08:30:35Z&se=2121-10-05T08:35:35Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "a0b18d81-2da2-4896-b169-a0745021a2af"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ne-NP, HemkalaNeural)",
        "shortName": "ne-NP-HemkalaNeural",
        "locale": "ne-NP",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Hemkala",
            "LocalName": "हेमकला",
            "ShortName": "ne-NP-HemkalaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "338",
            "LocaleDescription": "ne-NP",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "HemkalaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ne-NP",
            "localeZH": "尼泊尔语(尼泊尔)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a64dec5e-ba66-47ac-ba1e-3ac7080686eb.wav?sv=2019-07-07&sr=b&sig=mfKyAXsVZOqr29EbU3c7MxvREAVxFxMLGs9M0OW8Rlg%3D&st=2022-07-01T09:10:07Z&se=2122-06-07T09:15:07Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7953a9e3-8723-45a2-b495-a0d53313f763"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, YunxiNeural)",
        "shortName": "zh-CN-YunxiNeural",
        "description": "Lively and sunshine voice with rich emotions that can be used in many conversation scenarios.",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "Narrator,YoungAdultMale,Boy,Default",
            "VoiceRoleNameDefinitions": "{\"Narrator\":0,\"YoungAdultMale\":1,\"Boy\":9,\"Default\":0}",
            "VoiceStyleNames": "narration-relaxed,embarrassed,fearful,cheerful,disgruntled,serious,angry,sad,depressed,chat,assistant,newscast,Default",
            "VoiceStyleNameDefinitions": "{\"embarrassed\":1,\"fearful\":3,\"cheerful\":4,\"disgruntled\":5,\"serious\":6,\"angry\":7,\"sad\":8,\"depressed\":10,\"Default\":0}",
            "DisplayName": "Yunxi",
            "LocalName": "云希",
            "ShortName": "zh-CN-YunxiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "YoungAdult",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a227be6e-f179-4931-bfcd-451533348ff7.png?sv=2019-07-07&sr=b&sig=qXMLZ5Zhnm7QmupNVISx8zAn7ptau1sHPEwyHwd0P6U%3D&st=2021-10-29T08:24:30Z&se=2121-10-05T08:29:30Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "441",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "YunxiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Audiobook"
            },
            {
                "name": "Chat"
            },
            {
                "name": "Assistant",
                "defaultStyle": "assistant"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "欧游杂记",
                "titleLocalizationId": "zh-CN-YunxiNeural_Masterpieces_AudioBook_OuYouZaJi_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/79f6ba77-3b5f-4a01-aeef-1541feed3316.wav?sv=2019-07-07&sr=b&sig=auf%2FHDlxl%2BcKQgkIVePztk9O%2FVPTLzMFkvR18KkSv6M%3D&st=2021-10-29T08:31:48Z&se=2121-10-05T08:36:48Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [
                {
                    "roleName": "Default",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f4ca3209-80f9-4987-aa07-092d43f82fe8.wav?sv=2019-07-07&sr=b&sig=CsrYOOuXP0bcuTFhxt6ZrHI%2B5SM7E08TAn%2F8a1LuqlI%3D&st=2021-12-20T11:29:39Z&se=2121-11-26T11:34:39Z&sp=rl"
                },
                {
                    "roleName": "Boy",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5c4a3e25-c74e-497e-bbc9-36ae5995f5b5.wav?sv=2019-07-07&sr=b&sig=jkQ8znJJ5az%2BJ4i1o3oozSOb%2FhO52Oy%2Bqpl7ZH7zsoU%3D&st=2021-12-20T11:29:36Z&se=2121-11-26T11:34:36Z&sp=rl"
                },
                {
                    "roleName": "Narrator",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/64e597fc-dc74-43c5-b29e-a225db611daf.wav?sv=2019-07-07&sr=b&sig=H6ozko9QcB9Ru7SrJLd1APGqfKPpFe%2Bop%2FMbaSmF5Us%3D&st=2021-12-20T11:29:42Z&se=2121-11-26T11:34:42Z&sp=rl"
                },
                {
                    "roleName": "YoungAdultMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/754795a7-8019-492b-9ece-e2068036337a.wav?sv=2019-07-07&sr=b&sig=3441SIV9JzBW5nGxzlHlvv0zJrXmoYoYUYABcphvvd0%3D&st=2021-12-21T09:06:49Z&se=2121-11-27T09:11:49Z&sp=rl"
                }
            ],
            "styleSamples": [
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6f050a04-d3c3-4099-b9e1-d51f152d52a4.wav?sv=2019-07-07&sr=b&sig=6X1eUm0J5I0VwDDNcpdXMZ1mP9azu11pgLcXFrzqY2U%3D&st=2021-10-29T08:29:21Z&se=2121-10-05T08:34:21Z&sp=rl"
                },
                {
                    "styleName": "assistant",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/99650f95-1535-4900-abd4-0e6aeb387814.wav?sv=2019-07-07&sr=b&sig=sQpnemtw38p%2FJM1OMC079toxZHWW%2FI08urO%2Fe2MrkBA%3D&st=2021-10-29T08:29:22Z&se=2121-10-05T08:34:22Z&sp=rl"
                },
                {
                    "styleName": "calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/669d6a6c-2d13-421c-9d54-25fa7c2742e1.wav?sv=2019-07-07&sr=b&sig=XVgH5myuwl2ldYBJMduiPedtNGF59bcOp%2FGGaUNTkoM%3D&st=2021-10-29T08:29:23Z&se=2121-10-05T08:34:23Z&sp=rl"
                },
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/905364f0-cafb-491e-841f-224a93e8e954.wav?sv=2019-07-07&sr=b&sig=%2BOoQBkECuK61qW9zVx2NylcYy1B2A9KNBszN8vbOZKE%3D&st=2021-12-02T05:02:21Z&se=2121-11-08T05:07:21Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9e766773-610b-40a0-a34a-917b27fe3d2c.wav?sv=2019-07-07&sr=b&sig=ThqEXmy0WQSjVPAUwgWi0GwiLK8Rw%2FVbScfimNS95gQ%3D&st=2021-10-29T08:29:24Z&se=2121-10-05T08:34:24Z&sp=rl"
                },
                {
                    "styleName": "depressed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1624f1d6-9217-44db-8d4f-1517cc73a583.wav?sv=2019-07-07&sr=b&sig=zhleCkQ4kfr3FQKIX2HCoV%2FKMmV%2F%2Ffijgeq6ImOoZ0Q%3D&st=2021-10-29T08:29:25Z&se=2121-10-05T08:34:25Z&sp=rl"
                },
                {
                    "styleName": "disgruntled",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b2868c0d-9a5c-48b1-88a9-6fc5b8a0f175.wav?sv=2019-07-07&sr=b&sig=CF80mWBbzU3%2FWohem2%2B6iYPbYxR6zan%2B%2FQFrBXcYm94%3D&st=2021-10-29T08:29:26Z&se=2121-10-05T08:34:26Z&sp=rl"
                },
                {
                    "styleName": "embarrassed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0f236a40-6cbe-422e-9c34-26b17632b987.wav?sv=2019-07-07&sr=b&sig=9ft%2FKlSsXzUiGdVQ8zcgE0ctOyf5FYgFAohGFs4r%2Fs8%3D&st=2021-10-29T08:29:27Z&se=2121-10-05T08:34:27Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2b5c04c5-1295-46af-9629-5ed53d730e14.wav?sv=2019-07-07&sr=b&sig=4snKuHaoEdNPj8KJKXHeQugHyY1p3YazWvZ97ri8s3Q%3D&st=2021-10-29T08:29:28Z&se=2121-10-05T08:34:28Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e4a1a6af-c1cc-48f0-ba22-a0b1d6cd8278.wav?sv=2019-07-07&sr=b&sig=3baTlmiHN%2FUQoZATNPZ1r9vsFBkZvzGV5Gl0FY0CO14%3D&st=2021-10-29T08:29:29Z&se=2121-10-05T08:34:29Z&sp=rl"
                },
                {
                    "styleName": "narration-relaxed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/01804fa7-4a20-49bc-9d06-3c691196e767.wav?sv=2019-07-07&sr=b&sig=B3owwuUbLs3nW63tJlWCJMdKSqBgAy%2BSyXry2HfIsCM%3D&st=2022-02-09T14:43:10Z&se=2122-01-16T14:48:10Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f61ff6c7-8e74-409b-a94c-980ade698071.wav?sv=2019-07-07&sr=b&sig=Slap%2Bq84FM1QBHlNN3vejmD%2BXqbqBwaPkk3EmxbAEtc%3D&st=2021-10-29T08:29:30Z&se=2121-10-05T08:34:30Z&sp=rl"
                },
                {
                    "styleName": "serious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/45b93637-35e0-47dd-94d8-a1acc385df37.wav?sv=2019-07-07&sr=b&sig=nxvG82vho2TGnDwPZ5Pg10UKiqSJPbuCd%2Bih%2BAZcFDI%3D&st=2021-10-29T08:29:31Z&se=2121-10-05T08:34:31Z&sp=rl"
                },
                {
                    "styleName": "newscast",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/06977df4-8279-43f6-9a7d-eae09f6f90c2.wav?sv=2019-07-07&sr=b&sig=JzH7R5128SHURsnJdgtDn5Ugr5NMZyc2ryhOAP0iubM%3D&st=2022-02-09T14:43:13Z&se=2122-01-16T14:48:13Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1011ca97-3e33-4e7c-8dda-a22dc244bafc"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-SG, LunaNeural)",
        "shortName": "en-SG-LunaNeural",
        "locale": "en-SG",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Luna",
            "LocalName": "Luna",
            "ShortName": "en-SG-LunaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "122",
            "LocaleDescription": "en-SG",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LunaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-SG",
            "localeZH": "英语(新加坡)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/528d5acf-f34e-41f1-bf6c-0a2b9e9bea9f.wav?sv=2019-07-07&sr=b&sig=JDV8eg1P7gf5ZIvRfwcAdHSfXs%2FIxKT5cLIIvku6pGU%3D&st=2022-07-03T04:14:35Z&se=2122-06-09T04:19:35Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5daae71c-815a-4118-a516-a37ee62db211"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (nl-BE, ArnaudNeural)",
        "shortName": "nl-BE-ArnaudNeural",
        "locale": "nl-BE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Arnaud",
            "LocalName": "Arnaud",
            "ShortName": "nl-BE-ArnaudNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "340",
            "LocaleDescription": "Dutch (Belgium)",
            "PreviewSentence": "Audio-inhoud Aanmaken laat u toe om visueel de spraakeigenschappen in te stellen in real-time.",
            "DisplayVoiceName": "ArnaudNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "nl-BE",
            "localeZH": "荷兰语(比利时)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1643c2f6-e665-4acc-8222-d981eae89d0a.wav?sv=2019-07-07&sr=b&sig=fH6Z4sJ5%2BW0lJ%2Fli568H0TBZMmzXMmHFjgCH6XqNHKg%3D&st=2021-10-29T08:27:41Z&se=2121-10-05T08:32:41Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "4a52cc29-f575-4d96-9e08-a45e7b7975b6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fa-IR, FaridNeural)",
        "shortName": "fa-IR-FaridNeural",
        "locale": "fa-IR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Farid",
            "LocalName": "فرید",
            "ShortName": "fa-IR-FaridNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "228",
            "LocaleDescription": "fa-IR",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "FaridNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fa-IR",
            "localeZH": "波斯语(伊朗)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d4be75ab-cd32-4c52-9857-af0c7eda7e96.wav?sv=2019-07-07&sr=b&sig=EtvXEHpJUm%2FtF0rzh1tuxauQ0dCly3UdZnSnBTtPQ6U%3D&st=2021-10-29T08:31:02Z&se=2121-10-05T08:36:02Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "50c098f5-42ff-4a39-9753-a595d537d428"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (tr-TR, EmelNeural)",
        "shortName": "tr-TR-EmelNeural",
        "description": "",
        "locale": "tr-TR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Emel",
            "LocalName": "Emel",
            "ShortName": "tr-TR-EmelNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "408",
            "LocaleDescription": "Turkish",
            "PreviewSentence": "Kullanıcılarla doğal biçimde konuşan, erişilebilirlik ve kullanılabilirliği iyileştiren uygulama ve servisler geliştirmek.",
            "DisplayVoiceName": "EmelNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "tr-TR",
            "localeZH": "土耳其语(Türkiye)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e6f07dfb-9314-458c-b6f3-a315a98e1315.wav?sv=2019-07-07&sr=b&sig=cfJdAWzZgyjtMsUxjTvtf%2Fkqlcwy%2BHXToQ5SwX%2Beje8%3D&st=2021-10-29T08:28:24Z&se=2121-10-05T08:33:24Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5b30688a-af74-410e-9b92-a65882a76ab6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, RogerNeural)",
        "shortName": "en-US-RogerNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Roger",
            "LocalName": "Roger",
            "ShortName": "en-US-RogerNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "145",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "RogerNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "AudioBook",
                "titleLocalizationId": "AudioBook",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/22ab7c89-5016-49c0-8cd5-105e94dec60d.wav?sv=2019-07-07&sr=b&sig=S8HWJlKu9b%2BmAoAulHXarxphuZcxx8uFtOcChN%2B3iT4%3D&st=2022-07-20T10:55:52Z&se=2122-06-26T11:00:52Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0cca4395-a736-4a09-ad0b-5913c69750ba.wav?sv=2019-07-07&sr=b&sig=c4vpw93Z2dwLmaY2S5evj8ggPSSEzrthyIdVFO%2FFUdk%3D&st=2022-07-20T10:55:48Z&se=2122-06-26T11:00:48Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ec861c24-5c0a-4b26-b2a2-a72d0ee2cbe7"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pl-PL, MarekNeural)",
        "shortName": "pl-PL-MarekNeural",
        "locale": "pl-PL",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Marek",
            "LocalName": "Marek",
            "ShortName": "pl-PL-MarekNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "346",
            "LocaleDescription": "Polish",
            "PreviewSentence": "Twórz aplikacje i serwisy, które w kontakcie z użytkownikiem posługują się naturalną mową, co podnosi ich dostępność i użyteczność.",
            "DisplayVoiceName": "MarekNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pl-PL",
            "localeZH": "波兰语(波兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4ec46e25-6055-4fc7-8eac-2b65648b35c6.wav?sv=2019-07-07&sr=b&sig=Lsfh8zHdO4HlRBOqfTCbIYaSjOR9WLmP%2FztL7UxNKPg%3D&st=2021-10-29T08:27:50Z&se=2121-10-05T08:32:50Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "adc6ae77-abab-49e2-a6e5-a79ed6646bdd"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-ZA, LeahNeural)",
        "shortName": "en-ZA-LeahNeural",
        "locale": "en-ZA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Leah",
            "LocalName": "Leah",
            "ShortName": "en-ZA-LeahNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "151",
            "LocaleDescription": "en-ZA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LeahNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-ZA",
            "localeZH": "英语(南非)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/149360ab-b012-4033-9751-ce1d1b947647.wav?sv=2019-07-07&sr=b&sig=tI2v80iXEvdIPx%2B0baYIJ6c%2B3MbJskevIpuFG7o7nQo%3D&st=2021-10-29T08:26:38Z&se=2121-10-05T08:31:38Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "edd219ae-6138-40c0-a59b-a7bc6d8be600"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, ArnauNeural)",
        "shortName": "es-ES-ArnauNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Arnau",
            "LocalName": "Arnau",
            "ShortName": "es-ES-ArnauNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "170",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "ArnauNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d9a72907-b8a6-4f5b-a8d3-2b188685b210.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A34Z&se=2122-09-27T07%3A51%3A34Z&sr=b&sp=rl&sig=FPbt0TboLe9BCrTJQiIvgfxOfsmDDau9O%2BWZkByHBJw%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b6d2cb43-e353-4409-b10e-a9a429846d00"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (eu-ES, AnderNeural)",
        "shortName": "eu-ES-AnderNeural",
        "locale": "eu-ES",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ander",
            "LocalName": "Ander",
            "ShortName": "eu-ES-AnderNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "226",
            "LocaleDescription": "eu-ES",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AnderNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "eu-ES",
            "localeZH": "巴斯克语(巴斯克语)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e3ebb69e-6e4c-45f0-8553-af7cfdea2fe3.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A08Z&se=2122-09-27T07%3A52%3A08Z&sr=b&sp=rl&sig=4Y4WqNZGa9tQ7MA%2FnzkP8MZNL0gRGUmTvwdesWtu%2FSc%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ddce4588-3f1e-459c-9934-aa4a5aea66af"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-NI, FedericoNeural)",
        "shortName": "es-NI-FedericoNeural",
        "locale": "es-NI",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Federico",
            "LocalName": "Federico",
            "ShortName": "es-NI-FedericoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "205",
            "LocaleDescription": "es-NI",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "FedericoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-NI",
            "localeZH": "西班牙语(尼加拉瓜)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e218c117-c2fc-4803-80ed-3183b204a2e6.wav?sv=2019-07-07&sr=b&sig=4uZoioSmZGpnyLe32nA08nw3JGsAdfs2dsu0lB1mW1U%3D&st=2021-10-29T08:30:46Z&se=2121-10-05T08:35:46Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "389b1132-ae33-48ae-a190-aabcb08d4db3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (wuu-CN, YunzheNeural)",
        "shortName": "wuu-CN-YunzheNeural",
        "locale": "wuu-CN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yunzhe",
            "LocalName": "云哲",
            "ShortName": "wuu-CN-YunzheNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "420",
            "LocaleDescription": "wuu-CN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "YunzheNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "wuu-CN",
            "localeZH": "中文(吴语，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a2b32854-bd49-4dcd-bb31-d9bdeef36dee.wav?sv=2021-08-06&st=2022-10-21T11%3A57%3A29Z&se=2122-09-27T12%3A02%3A29Z&sr=b&sp=rl&sig=tSJnoMcFBKIdwAsSKzMBBGht4zEp10JiSFiqAVBQO6g%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2c5617a6-37b8-44dc-b4c0-ac73be78acf8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fa-IR, DilaraNeural)",
        "shortName": "fa-IR-DilaraNeural",
        "locale": "fa-IR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Dilara",
            "LocalName": "دلارا",
            "ShortName": "fa-IR-DilaraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "227",
            "LocaleDescription": "fa-IR",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "DilaraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fa-IR",
            "localeZH": "波斯语(伊朗)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8933d097-85dc-4721-b6cf-e1e274a797e7.wav?sv=2019-07-07&sr=b&sig=ipIyjWltXSv79KqJDtx4Mgg2YMU0VjNm4%2FIYYZY%2FgkU%3D&st=2021-10-29T08:31:01Z&se=2121-10-05T08:36:01Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "68cddd97-2143-4ad6-9d14-acc2223f7ea0"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, GerardoNeural)",
        "shortName": "es-MX-GerardoNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gerardo",
            "LocalName": "Gerardo",
            "ShortName": "es-MX-GerardoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "195",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "GerardoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cce1f446-2f39-4fd8-b932-1b574c02c250.wav?sv=2019-07-07&sr=b&sig=SEbek6%2B9IxtORNmELmsWyIybxgfBF9WQRwZIm0MjNpQ%3D&st=2022-07-01T09:09:10Z&se=2122-06-07T09:14:10Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7dd9ee6d-926f-41d0-9e5f-acd41467522e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (gu-IN, DhwaniNeural)",
        "shortName": "gu-IN-DhwaniNeural",
        "locale": "gu-IN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Dhwani",
            "LocalName": "ધ્વની",
            "ShortName": "gu-IN-DhwaniNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "259",
            "LocaleDescription": "gu-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "DhwaniNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "gu-IN",
            "localeZH": "古吉拉特语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8ff832f3-634e-4a00-9bd3-e20aeeb96415.wav?sv=2019-07-07&sr=b&sig=JjEubolh%2BygfaQIjWtaFyNbItbHKj1EpoPRsA%2FyHnOc%3D&st=2021-10-29T08:27:05Z&se=2121-10-05T08:32:05Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "97ebc7c6-1e92-4764-806b-ad61201a60a5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sr-RS, NicholasNeural)",
        "shortName": "sr-RS-NicholasNeural",
        "locale": "sr-RS",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Nicholas",
            "LocalName": "Никола",
            "ShortName": "sr-RS-NicholasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "383",
            "LocaleDescription": "sr-RS",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "NicholasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sr-RS",
            "localeZH": "塞尔维亚语(塞尔维亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f183c77b-32a2-44ff-9bd6-ffb25c104dbf.wav?sv=2019-07-07&sr=b&sig=3fA8o%2FnH%2ByBQ0JSSqC1TY%2FC%2FKsxVMQW%2BOWUJWlxI%2FC8%3D&st=2022-01-19T09:02:20Z&se=2121-12-26T09:07:20Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d7747462-41fd-4140-af6b-adbb76cf2405"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, CalimeroNeural)",
        "shortName": "it-IT-CalimeroNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Calimero",
            "LocalName": "Calimero",
            "ShortName": "it-IT-CalimeroNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "277",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "CalimeroNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d7469cd1-38b9-42f0-b3d7-84e560298951.wav?sv=2019-07-07&sr=b&sig=UbX6lBkiCDMNZb59sdigVwrbAgEV%2BCF73GKEd3OhM3E%3D&st=2022-07-01T09:09:33Z&se=2122-06-07T09:14:33Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0a9b0267-c022-4f86-85ee-ae514facbeb2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, BenignoNeural)",
        "shortName": "it-IT-BenignoNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Benigno",
            "LocalName": "Benigno",
            "ShortName": "it-IT-BenignoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "276",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "BenignoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bbfcb64f-b3be-4004-8ae1-b56affe22706.wav?sv=2019-07-07&sr=b&sig=YoUt%2FsE8f%2F2P0XzsVYyEsIJNjLJ3nx0O6KnGYvaynD0%3D&st=2022-07-01T09:09:30Z&se=2122-06-07T09:14:30Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "06af3b1f-e3a7-45b3-8b84-aecd737401ed"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, PalmiraNeural)",
        "shortName": "it-IT-PalmiraNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Palmira",
            "LocalName": "Palmira",
            "ShortName": "it-IT-PalmiraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "286",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "PalmiraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/af92bb71-1063-4969-89f7-1546b0b9ed9a.wav?sv=2019-07-07&sr=b&sig=JyM50g47BYw5E9ogHJ4s40FDvagksAsC4lMXFL3XRSo%3D&st=2022-07-01T09:09:51Z&se=2122-06-07T09:14:51Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8d161c40-e771-449d-a089-af2d64dc5e3a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, AlvaroNeural)",
        "shortName": "es-ES-AlvaroNeural",
        "description": "",
        "locale": "es-ES",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Alvaro",
            "LocalName": "Álvaro",
            "ShortName": "es-ES-AlvaroNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "183",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "AlvaroNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1249e89a-f8a7-4ba3-b9ad-c08b76345bba.wav?sv=2019-07-07&sr=b&sig=OaPDKdVySv4QaSEBjNhCeFZC8QVSP084tywJ0EPUDJU%3D&st=2021-10-29T08:26:43Z&se=2121-10-05T08:31:43Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ffe34fb6-c1ee-45ae-aef3-b0c303614c19"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (su-ID, TutiNeural)",
        "shortName": "su-ID-TutiNeural",
        "locale": "su-ID",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Tuti",
            "LocalName": "Tuti",
            "ShortName": "su-ID-TutiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "386",
            "LocaleDescription": "su-ID",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "TutiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "su-ID",
            "localeZH": "巽他语(印度尼西亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5aece8b2-a471-4ab8-8d75-50c544005745.wav?sv=2019-07-07&sr=b&sig=kHWMocLNP3aTsc6W8QDE9E5qsz9NlLL%2BJgZFbONwt9c%3D&st=2021-10-29T08:31:16Z&se=2121-10-05T08:36:16Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f9d2faf8-ff6b-4a89-aeb8-b0c5f16c4e4c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, AbbiNeural)",
        "shortName": "en-GB-AbbiNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Abbi",
            "LocalName": "Abbi",
            "ShortName": "en-GB-AbbiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "94",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AbbiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8fcc9467-04db-4c67-8e60-e1af42c7dcdb.wav?sv=2019-07-07&sr=b&sig=7Z6zi7%2BcC7G7MJ6EBQDv5aE%2FrfKRNmwYcRlKtqnUgmw%3D&st=2022-01-19T09:00:51Z&se=2121-12-26T09:05:51Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7cf7c9f9-63c2-4a30-9db3-b25f99709291"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-EC, AndreaNeural)",
        "shortName": "es-EC-AndreaNeural",
        "locale": "es-EC",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Andrea",
            "LocalName": "Andrea",
            "ShortName": "es-EC-AndreaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "167",
            "LocaleDescription": "es-EC",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AndreaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-EC",
            "localeZH": "西班牙语(厄瓜多尔)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/dc233559-730b-48ff-95cd-e3dab05a03bf.wav?sv=2019-07-07&sr=b&sig=jib0zlwlqY6LALqZUZ%2BE0VYGRMs7ocjZW%2Bk0Quoimkc%3D&st=2021-10-29T08:30:38Z&se=2121-10-05T08:35:38Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "303f5b66-71d9-4c74-b75b-b38080b11cbe"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (th-TH, AcharaNeural)",
        "shortName": "th-TH-AcharaNeural",
        "description": "",
        "locale": "th-TH",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Achara",
            "LocalName": "อัจฉรา",
            "ShortName": "th-TH-AcharaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "405",
            "LocaleDescription": "Thai",
            "PreviewSentence": "สร้างแอปและบริการที่สื่อสารกับผู้ใช้ได้อย่างเป็นธรรมชาติ ซึ่งช่วยปรับปรุงการเข้าถึงและการใช้งาน",
            "DisplayVoiceName": "AcharaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "th-TH",
            "localeZH": "泰语(泰国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/38d753f1-1a94-4924-9b51-6d1299702888.wav?sv=2019-07-07&sr=b&sig=WaDMQDwdBG6%2Fvtl30Yq%2F%2Btk0JYx98PwzSBZAEaAz1MQ%3D&st=2021-10-29T08:28:19Z&se=2121-10-05T08:33:19Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ac773ad2-7b91-456c-b93f-b397ef1b11ff"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (nb-NO, IselinNeural)",
        "shortName": "nb-NO-IselinNeural",
        "description": "",
        "locale": "nb-NO",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Iselin",
            "LocalName": "Iselin",
            "ShortName": "nb-NO-IselinNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "337",
            "LocaleDescription": "Norwegian",
            "PreviewSentence": "Bygger apper og tjenester som snakker naturlig med brukerne, utbedrer tilgjengelighet og brukskvalitet.",
            "DisplayVoiceName": "IselinNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "nb-NO",
            "localeZH": "书面挪威语(挪威)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/98df46c7-f02e-481c-98ab-f54fb78023ba.wav?sv=2019-07-07&sr=b&sig=G6WewQHD7V%2FF62fFOt6knGAR9ArQ12ytG%2BiLFdV1uvU%3D&st=2021-10-29T08:27:38Z&se=2121-10-05T08:32:38Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e398d4d2-b8a8-4d1d-ab65-b4fe9278eb71"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, EricNeural)",
        "shortName": "en-US-EricNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Eric",
            "LocalName": "Eric",
            "ShortName": "en-US-EricNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "138",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "EricNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d8d65e4b-0966-41a2-ad2a-59c344f9fbd5.wav?sv=2019-07-07&sr=b&sig=mD0TyJ%2Bt4RfNH%2FYdvmY8ixKtmm2a5otEB90BKM49vMg%3D&st=2021-10-29T08:25:36Z&se=2121-10-05T08:30:36Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "22bb63f1-7dba-49b9-9d4d-b56c7ce92d47"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, AlfieNeural)",
        "shortName": "en-GB-AlfieNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Alfie",
            "LocalName": "Alfie",
            "ShortName": "en-GB-AlfieNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "95",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AlfieNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/72b25357-f84f-431e-8e6c-ca5ffad9cc16.wav?sv=2019-07-07&sr=b&sig=%2Bv2L4Bdfl%2Fx5cWH8YMof8iKAO4CuIzqZIli1jIsjP8o%3D&st=2022-01-19T09:00:53Z&se=2121-12-26T09:05:53Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1a97c094-c81f-4c6a-ad9f-b595b54bc448"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ur-IN, GulNeural)",
        "shortName": "ur-IN-GulNeural",
        "locale": "ur-IN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gul",
            "LocalName": "گل",
            "ShortName": "ur-IN-GulNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "411",
            "LocaleDescription": "ur-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "GulNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ur-IN",
            "localeZH": "乌尔都语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3306cca4-19dc-4074-aed3-ac9e3f74a8a3.wav?sv=2019-07-07&sr=b&sig=J2S1U6A%2FP4KNzfQtEErhGQ9NrFoqevdbzdbatYsgIcw%3D&st=2021-10-29T08:31:23Z&se=2121-10-05T08:36:23Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "a0c30154-af80-4aa0-8b73-b5ed657091e9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, CandelaNeural)",
        "shortName": "es-MX-CandelaNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Candela",
            "LocalName": "Candela",
            "ShortName": "es-MX-CandelaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "191",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "CandelaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9dbc2440-e100-48f1-8d6e-642953a33bfb.wav?sv=2019-07-07&sr=b&sig=vdH49ZbrU7HtheBrzPkXbKphTLIvHrEhYEcylUyCGxs%3D&st=2022-07-01T09:09:04Z&se=2122-06-07T09:14:04Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "471b7597-7004-4dcf-b364-b6bba39518f6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, MonicaNeural)",
        "shortName": "en-US-MonicaNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Monica",
            "LocalName": "Monica",
            "ShortName": "en-US-MonicaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "143",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MonicaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9337bb71-f0fc-4e2a-a836-27b4872932da.wav?sv=2019-07-07&sr=b&sig=nOt3gl3Snkv9VuxcvWL0EkgJtgCVwFCdIn2%2BwgHO97A%3D&st=2021-10-29T08:25:50Z&se=2121-10-05T08:30:50Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "af5c31bf-a36d-4852-8555-b775316d9e5f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-TW, YunJheNeural)",
        "shortName": "zh-TW-YunJheNeural",
        "locale": "zh-TW",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "YunJhe",
            "LocalName": "雲哲",
            "ShortName": "zh-TW-YunJheNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "454",
            "LocaleDescription": "Chinese (Taiwan)",
            "PreviewSentence": "建構可以和使用者自然對話的應用程式和服務，來提高其方便性和實用性。",
            "DisplayVoiceName": "YunJheNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "zh-TW",
            "localeZH": "中文(台湾普通话)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b5663e52-b08f-45aa-b1b8-6ed956f80b7f.wav?sv=2019-07-07&sr=b&sig=6FfjzgJLIyDvntlFotxOYHiep3HOQX0vqW8NGFKulm8%3D&st=2021-10-29T08:29:53Z&se=2121-10-05T08:34:53Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "eecf9888-9e58-4ed2-ae91-b7ae85a77cf3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-DZ, AminaNeural)",
        "shortName": "ar-DZ-AminaNeural",
        "locale": "ar-DZ",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Amina",
            "LocalName": "أمينة",
            "ShortName": "ar-DZ-AminaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "9",
            "LocaleDescription": "ar-DZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AminaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-DZ",
            "localeZH": "阿拉伯语(阿尔及利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d7b12fa3-619c-4c44-99b7-ab9daf34389f.wav?sv=2019-07-07&sr=b&sig=KTkbrWzyaoCSDZgz9BlTC6HHtvUxS6SxKrXQKHwzW0M%3D&st=2021-10-29T08:30:01Z&se=2121-10-05T08:35:01Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5b1e2e20-b01c-4945-b635-b865738e00f5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-JO, TaimNeural)",
        "shortName": "ar-JO-TaimNeural",
        "locale": "ar-JO",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Taim",
            "LocalName": "تيم",
            "ShortName": "ar-JO-TaimNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "16",
            "LocaleDescription": "ar-JO",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "TaimNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-JO",
            "localeZH": "阿拉伯语(约旦)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5ed486f6-d31e-4359-90cc-63e008f5f45e.wav?sv=2019-07-07&sr=b&sig=QzLaefDGUNQ6bJMprcJ3V5RASBM7w6SaNrjOcorCKAI%3D&st=2021-10-29T08:30:06Z&se=2121-10-05T08:35:06Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "08d7e69f-46fd-4053-bc85-b89ad688e3ff"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, RenataNeural)",
        "shortName": "es-MX-RenataNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Renata",
            "LocalName": "Renata",
            "ShortName": "es-MX-RenataNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "203",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "RenataNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/25a1e32a-85a6-4a14-83a3-ac8df412c9ff.wav?sv=2019-07-07&sr=b&sig=bsqrUcwvC0cSCzRNJCxXa5Fgfg7qmdMRF%2B5QmKUUPds%3D&st=2022-07-01T09:09:26Z&se=2122-06-07T09:14:26Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "176b1f4f-357d-4b5d-a59f-b8ecd1e69ed7"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, LarissaNeural)",
        "shortName": "es-MX-LarissaNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Larissa",
            "LocalName": "Larissa",
            "ShortName": "es-MX-LarissaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "197",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "LarissaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ea286546-0fd4-44c2-a0b9-93bde5720f5c.wav?sv=2019-07-07&sr=b&sig=FN2bFWI%2BfX4RqJGYHKBLkTWDnjjRvMBtdttaMeAq2To%3D&st=2022-07-01T09:09:12Z&se=2122-06-07T09:14:12Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7f8007d2-4fb4-4720-a709-b945deefba3f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sv-SE, HilleviNeural)",
        "shortName": "sv-SE-HilleviNeural",
        "description": "",
        "locale": "sv-SE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Hillevi",
            "LocalName": "Hillevi",
            "ShortName": "sv-SE-HilleviNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "388",
            "LocaleDescription": "Swedish",
            "PreviewSentence": "Bygg appar och tjänster som talar naturligt till användarna, och förbättrar tillgänglighet och användbarhet.",
            "DisplayVoiceName": "HilleviNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sv-SE",
            "localeZH": "瑞典语(瑞典)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/63d28117-7491-4e33-9ccd-56781b73e880.wav?sv=2019-07-07&sr=b&sig=h5IAvNSmVkvclIE2J%2Fma6SexEPgQL652iVf9eeVVxRo%3D&st=2021-10-29T08:28:10Z&se=2121-10-05T08:33:10Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6aeff0b1-3553-4b2b-92f4-b9a30cc8b294"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (bg-BG, BorislavNeural)",
        "shortName": "bg-BG-BorislavNeural",
        "locale": "bg-BG",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Borislav",
            "LocalName": "Борислав",
            "ShortName": "bg-BG-BorislavNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "39",
            "LocaleDescription": "Bulgarian",
            "PreviewSentence": "Създай приложения и услуги, които говорят непринудено на потребителите, подобрявайки достъпността и използваемостта.",
            "DisplayVoiceName": "BorislavNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "bg-BG",
            "localeZH": "保加利亚语(保加利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a85c27d8-332f-4803-b0b1-5824a35a021c.wav?sv=2019-07-07&sr=b&sig=IMicYRGvRJOPMqoVt52iQJUwEsGRgyntiVkozvKLYR8%3D&st=2021-10-29T08:25:59Z&se=2121-10-05T08:30:59Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "3dab86d2-97aa-4f0e-91a5-bb572a659a29"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ur-PK, AsadNeural)",
        "shortName": "ur-PK-AsadNeural",
        "locale": "ur-PK",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Asad",
            "LocalName": "اسد",
            "ShortName": "ur-PK-AsadNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "413",
            "LocaleDescription": "Urdu (Pakistan)",
            "PreviewSentence": "آواز کا مواد تخلیق کرنا  اس قابل بناتا  ہیکہ آپ تقریر کی خصوصیات کو  حقیقی وقت میں  اپنے مطابق کنٹرول کر سکتے ہیں۔",
            "DisplayVoiceName": "AsadNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ur-PK",
            "localeZH": "乌尔都语(巴基斯坦)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/635f209f-ecba-4ed8-82b8-7ca0750a3094.wav?sv=2019-07-07&sr=b&sig=YuvkUvJmkhluEHm8%2BkVutgPCjTRcRY5TOE3OjfTTHaU%3D&st=2021-10-29T08:28:27Z&se=2121-10-05T08:33:27Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "77f8306b-b8a7-4a3f-b892-bb5ed1e9ada8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ta-LK, SaranyaNeural)",
        "shortName": "ta-LK-SaranyaNeural",
        "locale": "ta-LK",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Saranya",
            "LocalName": "சரண்யா",
            "ShortName": "ta-LK-SaranyaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "397",
            "LocaleDescription": "ta-LK",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SaranyaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ta-LK",
            "localeZH": "泰米尔语(斯里兰卡)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/763f6dd2-d2ab-4572-bfb9-1b489e10f3ec.wav?sv=2019-07-07&sr=b&sig=z5c9mVAEc0%2B5vuEW6sSkWasaSnG9cTEUNuIo4Py8gmQ%3D&st=2021-10-29T08:31:20Z&se=2121-10-05T08:36:20Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "22d37991-4127-4149-b548-bc000dbde9e4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, DarioNeural)",
        "shortName": "es-ES-DarioNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Dario",
            "LocalName": "Dario",
            "ShortName": "es-ES-DarioNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "171",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "DarioNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9dedd27c-8405-4fe4-8cd1-3a10325c9628.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A36Z&se=2122-09-27T07%3A51%3A36Z&sr=b&sp=rl&sig=qIc7GGnD2NFo4kyz%2BtXXBwZNvsQAnyllvpzvwgAlYQE%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2d9dc747-b268-420e-bdb7-bc30963f9f3a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-CH, FabriceNeural)",
        "shortName": "fr-CH-FabriceNeural",
        "locale": "fr-CH",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Fabrice",
            "LocalName": "Fabrice",
            "ShortName": "fr-CH-FabriceNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "240",
            "LocaleDescription": "French (Switzerland)",
            "PreviewSentence": "Développer des applications et des services qui parlent aux utilisateurs avec naturel, pour améliorer leur accessibilité et leur utilisation.",
            "DisplayVoiceName": "FabriceNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-CH",
            "localeZH": "法语(瑞士)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d6ef5e6d-ca1d-47bd-b396-489f49a455c3.wav?sv=2019-07-07&sr=b&sig=veiH4zcppbyqR1ssSZXEZZg%2F%2Fpj8xhlsplvgMg%2FEyBc%3D&st=2021-10-29T08:27:00Z&se=2121-10-05T08:32:00Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "dead9773-6cf1-44a3-b32b-bc7fe148693d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, JaneNeural)",
        "shortName": "en-US-JaneNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "angry,cheerful,excited,friendly,hopeful,sad,shouting,terrified,unfriendly,whispering,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Jane",
            "LocalName": "Jane",
            "ShortName": "en-US-JaneNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "140",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "JaneNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/14e55cde-1ec5-4054-a54e-8aee42d80c3b.wav?sv=2019-07-07&sr=b&sig=7oR3Vy%2F1A2O2eQqsT3%2BRUjqtimhihW%2FZo7r1FCjW7Mg%3D&st=2022-05-05T09:38:43Z&se=2122-04-11T09:43:43Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2555f848-df26-4f82-89f4-e64edcc8a978.wav?sv=2019-07-07&sr=b&sig=uMgt6R%2BKGUlUugOpjnF3%2Fv%2FRpp56GEbPA3BNJyfF0kk%3D&st=2022-04-28T10:27:24Z&se=2122-04-04T10:32:24Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0d36d1e1-9b3e-4ef1-b287-97ea811f5b59.wav?sv=2019-07-07&sr=b&sig=Rbawkycxw3iaiyGXdw0%2BopAS2di8uvWDoXQBPs%2BVHMA%3D&st=2022-04-28T10:27:27Z&se=2122-04-04T10:32:27Z&sp=rl"
                },
                {
                    "styleName": "excited",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8bd03f26-2c8d-4a73-93c0-74db2f9cd442.wav?sv=2019-07-07&sr=b&sig=6dVD3IcYGpqCb07VCSeZ30%2Ftd803Bs%2FZiC68KRxwmcg%3D&st=2022-04-28T10:27:29Z&se=2122-04-04T10:32:29Z&sp=rl"
                },
                {
                    "styleName": "friendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6eedbd2d-3f3b-4bb1-a670-ccc16c9a3ded.wav?sv=2019-07-07&sr=b&sig=rOGnFl0OHS%2FMhK1Qfmnz9xQWXdcTWx8TILRMnCU%2FTPo%3D&st=2022-04-28T10:27:31Z&se=2122-04-04T10:32:31Z&sp=rl"
                },
                {
                    "styleName": "hopeful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8717df19-c4e6-4310-b14b-c54f97ff9128.wav?sv=2019-07-07&sr=b&sig=nfnJrttagjPXbWUoxfssq7VmA3z4YpzxqPCHcWdV5nI%3D&st=2022-04-28T10:27:34Z&se=2122-04-04T10:32:34Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b6431d65-451a-4ff6-aa3e-a2afd1f9ac84.wav?sv=2019-07-07&sr=b&sig=BxNoY9Gj4lGIESy5LYUkcyoUhjr%2FhF3p8NBY%2FsCPI4k%3D&st=2022-04-28T10:27:36Z&se=2122-04-04T10:32:36Z&sp=rl"
                },
                {
                    "styleName": "shouting",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/96522bca-f6dc-40fe-bf09-21f0d6078e22.wav?sv=2019-07-07&sr=b&sig=ONPm%2Bsve2pa0ByVcOFLYk6TPimtAT0rikzWLWdEw5zc%3D&st=2022-04-28T10:27:38Z&se=2122-04-04T10:32:38Z&sp=rl"
                },
                {
                    "styleName": "terrified",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/048b1093-34a7-42bf-8a6f-908f80e62a32.wav?sv=2019-07-07&sr=b&sig=FRFKmmAwHVdO8s9ya2ycJp2OieufF4Pjh1rj60IAq1E%3D&st=2022-04-28T10:27:40Z&se=2122-04-04T10:32:40Z&sp=rl"
                },
                {
                    "styleName": "unfriendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/990944c4-d6bd-47bd-88e2-f9067bb9a6fd.wav?sv=2019-07-07&sr=b&sig=%2BrMEostBehZM%2BwU0rl3IxtQivBu5p9WGTlQYohr7P8I%3D&st=2022-04-28T10:27:43Z&se=2122-04-04T10:32:43Z&sp=rl"
                },
                {
                    "styleName": "whispering",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2d870dfb-fd96-4d4c-acf4-4115f601a038.wav?sv=2019-07-07&sr=b&sig=Wri%2FGD5fVsmj9jzcIMiw%2Fo8vq9s5Q0oVVp5MRXPgPQI%3D&st=2022-04-28T10:27:45Z&se=2122-04-04T10:32:45Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1fcefcc6-c578-4aec-99fa-bcd38dfa0a02"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaoyouNeural)",
        "shortName": "zh-CN-XiaoyouNeural",
        "description": "Angelic and clear voice that can be applied in many child related scenarios.",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Xiaoyou",
            "LocalName": "晓悠",
            "ShortName": "zh-CN-XiaoyouNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "Child",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/313e781a-43a6-499d-8cee-c5b1a7ddc5e5?sv=2019-07-07&sr=b&sig=cuGCx3LdgBiThGGPrjgOS2kdZEbZr7lzeSor7lo3NtU%3D&st=2021-10-29T08:24:28Z&se=2121-10-05T08:29:28Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "435",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaoyouNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Chat"
            },
            {
                "name": "Audiobook"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "晓悠有声书《声律启蒙》",
                "titleLocalizationId": "zh-CN-XiaoyouNeural_Masterpieces_AudioBook_ShengLvQiMeng_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/73a5c13c-ebdb-4a77-b2dd-94e3c2c6af23?sv=2019-07-07&sr=b&sig=PUZd%2FC40sBe0zlgeeebTLmhdqLQW4mDIF%2BuY60Afw8Y%3D&st=2021-10-29T08:24:51Z&se=2121-10-05T08:29:51Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/65ab64f6-f0c1-44f9-a830-080ca6caa6f8.wav?sv=2019-07-07&sr=b&sig=cuya27f9FctxO8Xqxj2bimsDvBTRzqdogvw6rUpPy0I%3D&st=2021-10-29T08:29:20Z&se=2121-10-05T08:34:20Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d6814675-a0c5-4e09-9387-bd9b44d3e733"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-VE, PaolaNeural)",
        "shortName": "es-VE-PaolaNeural",
        "locale": "es-VE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Paola",
            "LocalName": "Paola",
            "ShortName": "es-VE-PaolaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "221",
            "LocaleDescription": "es-VE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "PaolaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-VE",
            "localeZH": "西班牙语(委内瑞拉)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2b958c5e-b8d3-4676-8620-bdfa2aa05b44.wav?sv=2019-07-07&sr=b&sig=gCmd1DU7pMyyAiOnu7BWGtKHeZ%2F2rKgoRSaSfM3Qv%2FI%3D&st=2021-10-29T08:30:59Z&se=2121-10-05T08:35:59Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9678300c-5bf2-4454-807b-be57d3754dff"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, PelayoNeural)",
        "shortName": "es-MX-PelayoNeural",
        "locale": "es-MX",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Pelayo",
            "LocalName": "Pelayo",
            "ShortName": "es-MX-PelayoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "202",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "PelayoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c5f751b5-a3e0-4330-8f21-83cea2e6ead8.wav?sv=2019-07-07&sr=b&sig=Oj2YbriVDG2%2B7%2BChZmOpyKODsTYsrT2Ls0gV7jFNMA8%3D&st=2022-07-01T09:09:24Z&se=2122-06-07T09:14:24Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0bf71dcf-e841-4f4c-aaf4-be63abc429f7"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-VE, SebastianNeural)",
        "shortName": "es-VE-SebastianNeural",
        "locale": "es-VE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sebastian",
            "LocalName": "Sebastián",
            "ShortName": "es-VE-SebastianNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "222",
            "LocaleDescription": "es-VE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SebastianNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-VE",
            "localeZH": "西班牙语(委内瑞拉)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2836004b-eb84-485e-9649-2138507d4c8c.wav?sv=2019-07-07&sr=b&sig=AdrYm%2FCM%2BKx9%2FuPBUmfKo14d5ocUPFwofb9U9xWz83I%3D&st=2021-10-29T08:31:00Z&se=2121-10-05T08:36:00Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "dfd6067e-87c2-428d-bd9e-be98643182f3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (et-EE, AnuNeural)",
        "shortName": "et-EE-AnuNeural",
        "description": "",
        "locale": "et-EE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Anu",
            "LocalName": "Anu",
            "ShortName": "et-EE-AnuNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "223",
            "LocaleDescription": "Estonian (Estonia)",
            "PreviewSentence": "Audio Content Creation võimaldab kõne atribuute reaalajas visuaalselt kontrollida.",
            "DisplayVoiceName": "AnuNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "et-EE",
            "localeZH": "爱沙尼亚语(爱沙尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bbce0c5e-0978-41f4-80a2-cf30651245ba.wav?sv=2019-07-07&sr=b&sig=ED1woHDXGveFrhY7DEGC9Qeol%2Bb0Bijfi2ipriIj%2BBo%3D&st=2021-10-29T08:26:49Z&se=2121-10-05T08:31:49Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6be0ede7-bb79-4435-b18d-c06bbc272df2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sw-KE, RafikiNeural)",
        "shortName": "sw-KE-RafikiNeural",
        "locale": "sw-KE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Rafiki",
            "LocalName": "Rafiki",
            "ShortName": "sw-KE-RafikiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "390",
            "LocaleDescription": "sw-KE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "RafikiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sw-KE",
            "localeZH": "斯瓦希里语(肯尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6a2d8845-107f-47a8-bc4e-4b127a40108a.wav?sv=2019-07-07&sr=b&sig=ISvJpaWfsgGg7a4tM%2BuZrVgy5PeCuib2R89Meq1d%2FR4%3D&st=2021-10-29T08:28:13Z&se=2121-10-05T08:33:13Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1acd89a8-65b1-4138-b417-c0b2950fd95c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ur-IN, SalmanNeural)",
        "shortName": "ur-IN-SalmanNeural",
        "locale": "ur-IN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Salman",
            "LocalName": "سلمان",
            "ShortName": "ur-IN-SalmanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "412",
            "LocaleDescription": "ur-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SalmanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ur-IN",
            "localeZH": "乌尔都语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c80069b4-f41b-4f82-a96b-ecd23dd36e11.wav?sv=2019-07-07&sr=b&sig=RSfK0jYKMTDmZvFFvgvM0oAqERnHJmAY1VfwpyAcahw%3D&st=2021-10-29T08:31:24Z&se=2121-10-05T08:36:24Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "10d69bc3-2b42-4fb3-9b60-c1624f09a35f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (mr-IN, AarohiNeural)",
        "shortName": "mr-IN-AarohiNeural",
        "locale": "mr-IN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Aarohi",
            "LocalName": "आरोही",
            "ShortName": "mr-IN-AarohiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "327",
            "LocaleDescription": "mr-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AarohiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "mr-IN",
            "localeZH": "马拉地语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/978bb414-7a90-4bce-a94e-1ccc7f4a5613.wav?sv=2019-07-07&sr=b&sig=qWsFfahO2Y6vFpmJx7dMUTWpyA9QX3OfrOCV7SyZTVs%3D&st=2021-10-29T08:27:29Z&se=2121-10-05T08:32:29Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "bc986aff-eabd-400a-b663-c1a401341324"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (mt-MT, GraceNeural)",
        "shortName": "mt-MT-GraceNeural",
        "description": "",
        "locale": "mt-MT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Grace",
            "LocalName": "Grace",
            "ShortName": "mt-MT-GraceNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "331",
            "LocaleDescription": "Maltese (Malta)",
            "PreviewSentence": "L-Għodda għall-Ħolqien tal-Kontenut bil-Ħoss tħallik direttament tikkontrolla l-attributi tal-leħen minn fuq l-iskrin tiegħek.",
            "DisplayVoiceName": "GraceNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "mt-MT",
            "localeZH": "马耳他语(马耳他)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/09b0c2dd-f32a-4e88-acef-e02bbc4799a4.wav?sv=2019-07-07&sr=b&sig=Rl2jsLxGHHCKS%2BUW6NwQK5fpqCSgERQXz36pMddr6nQ%3D&st=2021-10-29T08:27:34Z&se=2121-10-05T08:32:34Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c97e05df-dd50-494a-9550-c1c595382795"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (km-KH, SreymomNeural)",
        "shortName": "km-KH-SreymomNeural",
        "locale": "km-KH",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sreymom",
            "LocalName": "ស្រីមុំ",
            "ShortName": "km-KH-SreymomNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "304",
            "LocaleDescription": "km-KH",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SreymomNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "km-KH",
            "localeZH": "高棉语(柬埔寨)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/81e29034-cd41-4083-9dad-cfaf89268a42.wav?sv=2019-07-07&sr=b&sig=ed482rJxw490ZIDcV7CGuK6iG3%2B1YSUwAiQtmHlGfs0%3D&st=2021-10-29T08:31:10Z&se=2121-10-05T08:36:10Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "cfec61f9-70e7-4726-accb-c1dbcc796b68"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-PH, JamesNeural)",
        "shortName": "en-PH-JamesNeural",
        "locale": "en-PH",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "James",
            "LocalName": "James",
            "ShortName": "en-PH-JamesNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "120",
            "LocaleDescription": "English (Philippines)",
            "PreviewSentence": "Audio Content Creation enables you to visually control speech attributes in real-time.",
            "DisplayVoiceName": "JamesNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-PH",
            "localeZH": "英语(菲律宾)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d35cc8dd-fda9-4930-ba01-9b0d5793dbce.wav?sv=2019-07-07&sr=b&sig=a45NIwve%2FFRev%2FOP5%2BudCmldXgLYFD7zJrXnMWHS%2B3w%3D&st=2021-10-29T08:26:34Z&se=2121-10-05T08:31:34Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0a83aae7-926f-451b-bfb4-c3c0223e1c5b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-HN, KarlaNeural)",
        "shortName": "es-HN-KarlaNeural",
        "locale": "es-HN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Karla",
            "LocalName": "Karla",
            "ShortName": "es-HN-KarlaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "189",
            "LocaleDescription": "es-HN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "KarlaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-HN",
            "localeZH": "西班牙语(洪都拉斯)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c3726752-08d1-451c-a6a0-5a11a41cb0e9.wav?sv=2019-07-07&sr=b&sig=ckN9sIxBWW6kLdWiqGEVrOH40kJOcMBopC2WXzgZxQo%3D&st=2021-10-29T08:30:45Z&se=2121-10-05T08:35:45Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2eb006a0-2939-4131-b3ce-c465c1e60443"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-CL, LorenzoNeural)",
        "shortName": "es-CL-LorenzoNeural",
        "locale": "es-CL",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Lorenzo",
            "LocalName": "Lorenzo",
            "ShortName": "es-CL-LorenzoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "158",
            "LocaleDescription": "es-CL",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LorenzoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-CL",
            "localeZH": "西班牙语(智利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e3c3ffc4-9230-49cc-9713-1bc2bbbfb048.wav?sv=2019-07-07&sr=b&sig=ji4XSKOFDNTHFhFhVbuiyPWN7wvinOGi%2Bj0LAOXPsiQ%3D&st=2021-10-29T08:30:31Z&se=2121-10-05T08:35:31Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "47153290-5326-4c71-bcc3-c4e3dea9837f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, FiammaNeural)",
        "shortName": "it-IT-FiammaNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Fiamma",
            "LocalName": "Fiamma",
            "ShortName": "it-IT-FiammaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "281",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "FiammaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/78b6b0c0-ec18-49bd-952c-f84faa465174.wav?sv=2019-07-07&sr=b&sig=twZvFyFnJh4QloaytGwU%2FKiVj4M4BqaoaAqqiGf2xt8%3D&st=2022-07-01T09:09:40Z&se=2122-06-07T09:14:40Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "595e80a5-f5cc-4c75-9c4f-c5395abff9b5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (bs-BA, GoranNeural)",
        "shortName": "bs-BA-GoranNeural",
        "locale": "bs-BA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Goran",
            "LocalName": "Goran",
            "ShortName": "bs-BA-GoranNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "45",
            "LocaleDescription": "bs-BA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "GoranNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "bs-BA",
            "localeZH": "波斯尼亚语(波斯尼亚和黑塞哥维那)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4ce114d9-5610-4911-a55b-334e0f967747.wav?sv=2019-07-07&sr=b&sig=loqppZLETSUTP65lleVIBu4tj%2Ff9SHrCFDAUcibVBMQ%3D&st=2022-07-01T09:08:57Z&se=2122-06-07T09:13:57Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b15a636e-cdfe-47b5-b192-c5d192c6f30d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-GT, AndresNeural)",
        "shortName": "es-GT-AndresNeural",
        "locale": "es-GT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Andres",
            "LocalName": "Andrés",
            "ShortName": "es-GT-AndresNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "186",
            "LocaleDescription": "es-GT",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AndresNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-GT",
            "localeZH": "西班牙语(危地马拉)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5453b579-365b-447a-9d30-93938aedae31.wav?sv=2019-07-07&sr=b&sig=bf8dgCxNlfSASn%2F2ODIzgL1cO1nYSm0ih6Arx2xhOfE%3D&st=2021-10-29T08:30:42Z&se=2121-10-05T08:35:42Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9ae8f5ba-8753-4ccb-9e57-c5d8ff7454f3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, EstrellaNeural)",
        "shortName": "es-ES-EstrellaNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Estrella",
            "LocalName": "Estrella",
            "ShortName": "es-ES-EstrellaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "174",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "EstrellaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/59f2a05c-4bd8-4387-8133-9c493898d053.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A41Z&se=2122-09-27T07%3A51%3A41Z&sr=b&sp=rl&sig=KX5PVJeIo2xbmIY6Vra%2BpW1xH7qDl7YcPe%2FXMMDwKOI%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "adeecc76-b274-496e-ac11-c691841d03d5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (el-GR, NestorasNeural)",
        "shortName": "el-GR-NestorasNeural",
        "locale": "el-GR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Nestoras",
            "LocalName": "Νέστορας",
            "ShortName": "el-GR-NestorasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "76",
            "LocaleDescription": "Greek",
            "PreviewSentence": "Δημιουργήστε εφαρμογές και υπηρεσίες που μιλούν με φυσικό τρόπο στους χρήστες, βελτιώνοντας την προσβασιμότητα και τη χρηστικότητα.",
            "DisplayVoiceName": "NestorasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "el-GR",
            "localeZH": "希腊语(希腊)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/329b2788-1d03-43e8-a686-682be925f1ca.wav?sv=2019-07-07&sr=b&sig=h7tzFpM%2Bw6lLUQxbOAkYqE8mMy%2FNrPAb9WtKDFmReGQ%3D&st=2021-10-29T08:26:17Z&se=2121-10-05T08:31:17Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d3fc4288-e3f5-4ce8-b70e-c69ba7bd2405"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, JeromeNeural)",
        "shortName": "fr-FR-JeromeNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Jerome",
            "LocalName": "Jerome",
            "ShortName": "fr-FR-JeromeNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "249",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "JeromeNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f1b6a5ec-2042-4976-a496-22b586155b2d.wav?sv=2019-07-07&sr=b&sig=Vm%2FvktS9fkjCtLmnTt6RXlbWsKWmq5KTWyLVEAo%2BMtg%3D&st=2022-01-19T09:01:33Z&se=2121-12-26T09:06:33Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "62b4fcd7-d79c-465a-a23b-c703087f840d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (bn-IN, TanishaaNeural)",
        "shortName": "bn-IN-TanishaaNeural",
        "locale": "bn-IN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Tanishaa",
            "LocalName": "তানিশা",
            "ShortName": "bn-IN-TanishaaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "44",
            "LocaleDescription": "bn-IN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "TanishaaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "bn-IN",
            "localeZH": "孟加拉语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f3f9d7fb-6c20-4e3a-a225-35412bff732f.wav?sv=2019-07-07&sr=b&sig=bqyGvVvnrnDd3hKLraV%2BRPR84vsRJVIcMYw%2BmJJCvEM%3D&st=2022-01-19T09:00:18Z&se=2121-12-26T09:05:18Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ca1ba396-e04b-44b1-a9b3-c74433344372"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-SY, AmanyNeural)",
        "shortName": "ar-SY-AmanyNeural",
        "locale": "ar-SY",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Amany",
            "LocalName": "أماني",
            "ShortName": "ar-SY-AmanyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "31",
            "LocaleDescription": "ar-SY",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AmanyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-SY",
            "localeZH": "阿拉伯语(叙利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/21779fc8-eff6-4623-b37f-94b3fa8dcd3e.wav?sv=2019-07-07&sr=b&sig=Vr9Cga%2BOVc%2BsI4r2faFgyq2FFSRqS0r0%2FWs6XcB23k4%3D&st=2021-10-29T08:30:15Z&se=2121-10-05T08:35:15Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "74554b1d-12ba-4dc6-8e47-c7b4436ea586"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, ElliotNeural)",
        "shortName": "en-GB-ElliotNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Elliot",
            "LocalName": "Elliot",
            "ShortName": "en-GB-ElliotNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "97",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ElliotNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d16e2852-ce07-4e58-9950-346cfea0b089.wav?sv=2019-07-07&sr=b&sig=ZqodlS4akSHbUtTjYRDNJgNR0RWXHFpxji8G22ofego%3D&st=2022-01-19T09:00:58Z&se=2121-12-26T09:05:58Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "17fc7d8c-986b-48a1-889b-c84125a39f6c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-PR, VictorNeural)",
        "shortName": "es-PR-VictorNeural",
        "locale": "es-PR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Victor",
            "LocalName": "Víctor",
            "ShortName": "es-PR-VictorNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "212",
            "LocaleDescription": "es-PR",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "VictorNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-PR",
            "localeZH": "西班牙语(波多黎各)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/384779a4-19f7-4893-b982-1c8795d49395.wav?sv=2019-07-07&sr=b&sig=o17n22A%2BlcJ7jrj03d87kjZWX9l7cVNDx6YK7GrmsAw%3D&st=2021-10-29T08:30:53Z&se=2121-10-05T08:35:53Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "3d94051c-960b-45e6-b0ab-c8e0cfe4e2d5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, ElzaNeural)",
        "shortName": "pt-BR-ElzaNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Elza",
            "LocalName": "Elza",
            "ShortName": "pt-BR-ElzaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "354",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "ElzaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3107bd9f-d47a-47f5-9bc0-07c7980e055d.wav?sv=2019-07-07&sr=b&sig=MNpFARkd43OmSAlYgdqE55z%2F%2BQAGbFPocF69Ps%2Fjigo%3D&st=2022-07-01T09:10:15Z&se=2122-06-07T09:15:15Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ec99c388-f6f5-428a-9c22-c9143b16d50c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-IQ, RanaNeural)",
        "shortName": "ar-IQ-RanaNeural",
        "locale": "ar-IQ",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Rana",
            "LocalName": "رنا",
            "ShortName": "ar-IQ-RanaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "14",
            "LocaleDescription": "ar-IQ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "RanaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-IQ",
            "localeZH": "阿拉伯语(伊拉克)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/874e4ee2-800c-4bea-90ff-e72481afc231.wav?sv=2019-07-07&sr=b&sig=GDsh2RizhoPV1FWKR6XN0BRydQwaGE7GwabkClGrftM%3D&st=2021-10-29T08:30:04Z&se=2121-10-05T08:35:04Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0ee78d2e-9350-4111-86c5-c948ca6cd695"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, JoanneNeural)",
        "shortName": "en-AU-JoanneNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Joanne",
            "LocalName": "Joanne",
            "ShortName": "en-AU-JoanneNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "83",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "JoanneNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/040e21fa-1768-458d-8b58-d1138d5acd01.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A10Z&se=2122-09-27T07%3A51%3A10Z&sr=b&sp=rl&sig=39l5Wo8YUtFTzdmXPxxZnadRINOaIO50OB58oDA7RCw%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "146398ff-b6c8-4958-99ca-c965d3d12548"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, NoahNeural)",
        "shortName": "en-GB-NoahNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Noah",
            "LocalName": "Noah",
            "ShortName": "en-GB-NoahNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "101",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "NoahNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/73fb2ea3-681a-4d3c-82cd-d5dd0423f24a.wav?sv=2019-07-07&sr=b&sig=yYJESl2gVTRMd5ic4QTyNVLUqD17vV6Pc6ACdK5%2BMxM%3D&st=2022-01-19T09:01:08Z&se=2121-12-26T09:06:08Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "003c43b7-a265-41b9-b8cf-c978d9e4deb8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ms-MY, YasminNeural)",
        "shortName": "ms-MY-YasminNeural",
        "description": "",
        "locale": "ms-MY",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yasmin",
            "LocalName": "Yasmin",
            "ShortName": "ms-MY-YasminNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "330",
            "LocaleDescription": "Malay",
            "PreviewSentence": "Membina aplikasi dan perkhidmatan yang bercakap sememangnya kepada pengguna, meningkatkan kebolehcapaian dan kebolehgunaanya.",
            "DisplayVoiceName": "YasminNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ms-MY",
            "localeZH": "马来语(马来西亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4816b19b-e8c6-4729-b68d-97830942e54e.wav?sv=2019-07-07&sr=b&sig=PUHJOkor2WK3KboySG5a67RHyyavKdgJ6Rd%2FLG7KGIg%3D&st=2021-10-29T08:27:33Z&se=2121-10-05T08:32:33Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "32b1bdde-2225-4429-ad61-ca23a9d41a42"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, YunxiaNeural)",
        "shortName": "zh-CN-YunxiaNeural",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "calm,fearful,cheerful,angry,sad,Default",
            "VoiceStyleNameDefinitions": "{\"calm\":2,\"fearful\":3,\"cheerful\":4,\"angry\":7,\"sad\":8,\"Default\":0}",
            "DisplayName": "Yunxia",
            "LocalName": "云夏",
            "ShortName": "zh-CN-YunxiaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "440",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "YunxiaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "Angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/26fdc8e5-5d0a-4f07-9c2a-1b976804b4ab.wav?sv=2019-07-07&sr=b&sig=55aHYXra49WNZ92zafOJvdJIL55FjKfxOH3srv6gxOk%3D&st=2022-07-20T10:58:52Z&se=2122-06-26T11:03:52Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/26fdc8e5-5d0a-4f07-9c2a-1b976804b4ab.wav?sv=2019-07-07&sr=b&sig=55aHYXra49WNZ92zafOJvdJIL55FjKfxOH3srv6gxOk%3D&st=2022-07-20T10:58:52Z&se=2122-06-26T11:03:52Z&sp=rl"
                },
                {
                    "styleName": "Calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4932b47c-3395-43b2-877c-6f321c95d5e9.wav?sv=2019-07-07&sr=b&sig=QDDxzkKcmOjjDN64knDqnQ7II4Iezc4LH%2F4GKJ8soIU%3D&st=2022-07-20T10:58:55Z&se=2122-06-26T11:03:55Z&sp=rl"
                },
                {
                    "styleName": "calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4932b47c-3395-43b2-877c-6f321c95d5e9.wav?sv=2019-07-07&sr=b&sig=QDDxzkKcmOjjDN64knDqnQ7II4Iezc4LH%2F4GKJ8soIU%3D&st=2022-07-20T10:58:55Z&se=2122-06-26T11:03:55Z&sp=rl"
                },
                {
                    "styleName": "Cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cff3e19e-db5a-42f5-a8a9-b50b3f5ba95c.wav?sv=2019-07-07&sr=b&sig=Su%2FjrsI58sDzyYbUMVjl3zzoJRNXR9V0R8IZD7gyaxE%3D&st=2022-07-20T10:58:58Z&se=2122-06-26T11:03:58Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cff3e19e-db5a-42f5-a8a9-b50b3f5ba95c.wav?sv=2019-07-07&sr=b&sig=Su%2FjrsI58sDzyYbUMVjl3zzoJRNXR9V0R8IZD7gyaxE%3D&st=2022-07-20T10:58:58Z&se=2122-06-26T11:03:58Z&sp=rl"
                },
                {
                    "styleName": "Fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9563d6e4-ac15-43ca-bb31-8f43e7420116.wav?sv=2019-07-07&sr=b&sig=fp6Ynh%2Bl0iugD6O9ndI099aNsnee%2FFuy34ky2WJ6psQ%3D&st=2022-07-20T10:59:01Z&se=2122-06-26T11:04:01Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9563d6e4-ac15-43ca-bb31-8f43e7420116.wav?sv=2019-07-07&sr=b&sig=fp6Ynh%2Bl0iugD6O9ndI099aNsnee%2FFuy34ky2WJ6psQ%3D&st=2022-07-20T10:59:01Z&se=2122-06-26T11:04:01Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6d597103-4256-4c06-ab6e-223ab6740403.wav?sv=2019-07-07&sr=b&sig=rAXC%2BxBQZb9vuR6yeTxhFjOwa6qmG3gjBOvDkor%2BtN4%3D&st=2022-07-20T10:59:03Z&se=2122-06-26T11:04:03Z&sp=rl"
                },
                {
                    "styleName": "Sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/babc6c83-0ba6-418b-9ebb-b9451aa6b9be.wav?sv=2019-07-07&sr=b&sig=%2BET2DBG5SvyZ1%2BILRAearVk8vsN%2BRMJPes6SOpXb6Cg%3D&st=2022-07-20T10:59:06Z&se=2122-06-26T11:04:06Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/babc6c83-0ba6-418b-9ebb-b9451aa6b9be.wav?sv=2019-07-07&sr=b&sig=%2BET2DBG5SvyZ1%2BILRAearVk8vsN%2BRMJPes6SOpXb6Cg%3D&st=2022-07-20T10:59:06Z&se=2122-06-26T11:04:06Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "66dca810-157a-48a7-9a9c-cac3147734e8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sq-AL, IlirNeural)",
        "shortName": "sq-AL-IlirNeural",
        "locale": "sq-AL",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ilir",
            "LocalName": "Ilir",
            "ShortName": "sq-AL-IlirNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "382",
            "LocaleDescription": "sq-AL",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "IlirNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sq-AL",
            "localeZH": "阿尔巴尼亚语(阿尔巴尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/94fd259a-2c60-4fd2-a237-cdf458b0f978.wav?sv=2019-07-07&sr=b&sig=DFTcuZ%2FF9QZ6ufSWrd6H1Mqw7VTbYEEtg%2BNfdlSokEY%3D&st=2022-07-01T09:10:43Z&se=2122-06-07T09:15:43Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "768e2ad7-c79c-474a-b0ce-cb70c88cd6cb"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ps-AF, LatifaNeural)",
        "shortName": "ps-AF-LatifaNeural",
        "locale": "ps-AF",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Latifa",
            "LocalName": "لطيفه",
            "ShortName": "ps-AF-LatifaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "349",
            "LocaleDescription": "ps-AF",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LatifaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ps-AF",
            "localeZH": "普什图语(阿富汗)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5a5d6c0e-6fba-4fbb-b601-d609fb91402f.wav?sv=2019-07-07&sr=b&sig=O8iFZ6MxDVDB5P35f55pv%2Fy7bSu%2F0h5aORTM3K40KfA%3D&st=2022-01-19T09:02:13Z&se=2121-12-26T09:07:13Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c83eb52e-00f0-4502-839c-cba3b162bd65"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, KasperNeural)",
        "shortName": "de-DE-KasperNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Kasper",
            "LocalName": "Kasper",
            "ShortName": "de-DE-KasperNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "66",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "KasperNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d972755a-944b-4388-9efd-fc497c65c59b.wav?sv=2019-07-07&sr=b&sig=z8kzqkI8P9%2FkNHvggU2tEwlvg5BxI6fW3WHLBYDHxGI%3D&st=2022-01-19T09:00:32Z&se=2121-12-26T09:05:32Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "735f99de-0526-44f9-a4ac-cbbd845b0aba"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, FranciscaNeural)",
        "shortName": "pt-BR-FranciscaNeural",
        "description": "",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "calm,Default",
            "VoiceStyleNameDefinitions": "{\"calm\":2,\"Default\":0}",
            "DisplayName": "Francisca",
            "LocalName": "Francisca",
            "ShortName": "pt-BR-FranciscaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "350",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "FranciscaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c2f78ffd-a7a3-403f-b30b-9a3484ccc74e.wav?sv=2019-07-07&sr=b&sig=rwvD1noqGpkl1mwt7tcMxgKylgZrE1b0QiSwaHT8tO0%3D&st=2021-10-29T08:27:53Z&se=2121-10-05T08:32:53Z&sp=rl"
                },
                {
                    "styleName": "calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9118e675-7543-4f78-8184-25929d273a66.wav?sv=2019-07-07&sr=b&sig=HJGKfZsZbElvUrw3q9%2Bs7EOTKLXGpYjb4HPVluDOTgk%3D&st=2021-10-29T08:27:54Z&se=2121-10-05T08:32:54Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7f555f91-be6f-44e6-afe9-cbf590fc7f24"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-LB, RamiNeural)",
        "shortName": "ar-LB-RamiNeural",
        "locale": "ar-LB",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Rami",
            "LocalName": "رامي",
            "ShortName": "ar-LB-RamiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "20",
            "LocaleDescription": "ar-LB",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "RamiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-LB",
            "localeZH": "阿拉伯语(黎巴嫩)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e70eb2f0-6fce-49de-b943-ca1dea79333c.wav?sv=2019-07-07&sr=b&sig=wkLELI%2FZO9pml7sf5v3zLaXb4erOH839enDc7uuFo6I%3D&st=2022-07-01T09:08:45Z&se=2122-06-07T09:13:45Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7cd10960-9387-4084-b22d-cc0897e0a17b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, AriaNeural)",
        "shortName": "en-US-AriaNeural",
        "description": "",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "chat,customerservice,narration-professional,newscast-casual,newscast-formal,cheerful,empathetic,angry,sad,excited,friendly,terrified,shouting,unfriendly,whispering,hopeful,Default",
            "VoiceStyleNameDefinitions": "{\"cheerful\":4,\"angry\":7,\"sad\":8,\"Default\":0}",
            "DisplayName": "Aria",
            "LocalName": "Aria",
            "ShortName": "en-US-AriaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "131",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AriaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "ExpressAsStyleValues": "Default,Chat,Cheerful,CustomerService,Empathy,Newscast-Formal,Newscast-Casual",
            "ExpressAsRoleValues": "Default,Chat,Cheerful,CustomerService,Empathy,Newscast-Formal,Newscast-Casual",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "AudioBook",
                "titleLocalizationId": "AudioBook",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/70acf8bf-0de7-4ee7-925e-cb17b32bcdcf.wav?sv=2019-07-07&sr=b&sig=pSobsIM%2B7FNWRJEhezgYdo6m3M%2Fhrgo%2BwsJbniL%2BC3k%3D&st=2021-10-29T08:25:19Z&se=2121-10-05T08:30:19Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2dddd564-e051-43c7-995a-e9dc44d75d5e.wav?sv=2019-07-07&sr=b&sig=AqZqilK6%2FwD5IJeOl%2BopdsUg8OJBC6VSU6RtWCdBE0Y%3D&st=2021-10-29T08:25:24Z&se=2121-10-05T08:30:24Z&sp=rl"
                },
                {
                    "styleName": "chat",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/310e03ce-bb12-469b-a3d4-be08ed1e85dd.wav?sv=2019-07-07&sr=b&sig=X0%2F1aaP60LWSIVMFlr8QcwkpQ1D2eqDSoGMgEtbl93Y%3D&st=2021-10-29T08:25:15Z&se=2121-10-05T08:30:15Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f07bc6f3-a02e-4670-b224-6f8ebbe0f448.wav?sv=2019-07-07&sr=b&sig=SRPo5BQx3fGKJVBlsAuCkz3Maaa1WjPHgUkjHODpGLg%3D&st=2021-10-29T08:25:17Z&se=2121-10-05T08:30:17Z&sp=rl"
                },
                {
                    "styleName": "customerservice",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/065d4498-d65c-4d57-893e-993b74562d51.wav?sv=2019-07-07&sr=b&sig=TQYaF0J%2Be0j2g2OEFWTji9vXJbMmbEAJSRe9I%2Fqxuik%3D&st=2021-10-29T08:25:18Z&se=2121-10-05T08:30:18Z&sp=rl"
                },
                {
                    "styleName": "empathetic",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0e6971ad-df27-432c-b58b-1dded094018b.wav?sv=2019-07-07&sr=b&sig=kPFXdtU%2BtEMV9KyBfhb3EIxTZ8JdGPqWbS9Xckm66eM%3D&st=2021-10-29T08:25:20Z&se=2121-10-05T08:30:20Z&sp=rl"
                },
                {
                    "styleName": "narration-professional",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/25dbeb80-232b-4d96-b33f-f96fb184de68.wav?sv=2019-07-07&sr=b&sig=bs9i27WRQ%2BspKL2KptLH0%2BAyUgkGsYld6ijAYvVHK3U%3D&st=2021-10-29T08:25:27Z&se=2121-10-05T08:30:27Z&sp=rl"
                },
                {
                    "styleName": "newscast-casual",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2cfcfad6-1cb7-4ef3-ac1a-a3a70a56a1e3.wav?sv=2019-07-07&sr=b&sig=bseV3KzTMpWSs8VFSZWWA4Qzt0DyM0ntvowaDZDR90Y%3D&st=2021-10-29T08:25:28Z&se=2121-10-05T08:30:28Z&sp=rl"
                },
                {
                    "styleName": "newscast-formal",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/80c94e01-f16c-4245-bc45-92690462795e.wav?sv=2019-07-07&sr=b&sig=mwZ2jtG7kgVoE3phoKoLUe4%2B7rpvSKPSf8zVqtPN4tQ%3D&st=2021-10-29T08:25:29Z&se=2121-10-05T08:30:29Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/73af2f50-13af-486f-8520-ccfc6d4f8a09.wav?sv=2019-07-07&sr=b&sig=FyUr%2FtYXLu63wFDty9M63euQ8Qf9Mw7eNgQ3wkRkn4o%3D&st=2022-04-28T10:25:25Z&se=2122-04-04T10:30:25Z&sp=rl"
                },
                {
                    "styleName": "excited",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/02356840-2d3b-432d-8fbb-b2dee52d69a2.wav?sv=2019-07-07&sr=b&sig=P59eOqmEBTP9gpXO%2BCYuj%2Fq3UI%2Be9%2Fe1mzZD2XaIRxI%3D&st=2022-04-28T10:25:27Z&se=2122-04-04T10:30:27Z&sp=rl"
                },
                {
                    "styleName": "friendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/823f988c-4ebf-4255-a248-fd6dccdd64c1.wav?sv=2019-07-07&sr=b&sig=sVYCRQbDe4Kg3mFDnXtd7Obzw54%2F%2F482K7lLgsOzlgQ%3D&st=2022-04-28T10:25:29Z&se=2122-04-04T10:30:29Z&sp=rl"
                },
                {
                    "styleName": "hopeful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/436d9d4c-650d-4df1-a9a9-5d43d48f66c3.wav?sv=2019-07-07&sr=b&sig=YOhBWOU6wGUjJE9GITx6elUBIXvXfu3Lpf3cNzyBXLs%3D&st=2022-04-28T10:25:32Z&se=2122-04-04T10:30:32Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c124161f-c118-45ac-a7ac-0e9f38033281.wav?sv=2019-07-07&sr=b&sig=nfY2UcRn%2BWcXm%2Brtl0r1GcE6sQlMHnQs5WIUYqXa1ws%3D&st=2022-04-28T10:25:34Z&se=2122-04-04T10:30:34Z&sp=rl"
                },
                {
                    "styleName": "shouting",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fa5016db-52bf-4467-8656-87505ac94792.wav?sv=2019-07-07&sr=b&sig=tGgN91GcXXf3d1BPpF91HTT0TnjkErVEyrg2mzIc9M4%3D&st=2022-04-28T10:25:36Z&se=2122-04-04T10:30:36Z&sp=rl"
                },
                {
                    "styleName": "terrified",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/47daeb74-2d30-4384-bf24-e560dad0e9e9.wav?sv=2019-07-07&sr=b&sig=Y%2Bm8BIE2HEJCfW0Cao6Swrj2%2BDz4OuHvCcOURnphcv8%3D&st=2022-04-28T10:25:38Z&se=2122-04-04T10:30:38Z&sp=rl"
                },
                {
                    "styleName": "unfriendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/57eb5a8c-1dd8-449a-8ffa-6b1207bef7e0.wav?sv=2019-07-07&sr=b&sig=jcPSOu3cF1xyDgkGNQ7%2FLwm7%2BmbVKev69Ddboj2RxRI%3D&st=2022-04-28T10:25:41Z&se=2122-04-04T10:30:41Z&sp=rl"
                },
                {
                    "styleName": "whispering",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4ed6974e-108d-449f-b40d-f609af899f70.wav?sv=2019-07-07&sr=b&sig=l2PkWiOqEMnG2hxUXbefDMGFppihmj%2BC4sOr24SHd2E%3D&st=2022-04-28T10:25:43Z&se=2122-04-04T10:30:43Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "27e2f1c8-cfe0-4324-88e2-cd0bafeffe1b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, LaiaNeural)",
        "shortName": "es-ES-LaiaNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Laia",
            "LocalName": "Laia",
            "ShortName": "es-ES-LaiaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "176",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "LaiaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8188850f-0f9f-4ead-9dd5-509ed2c9f9e3.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A45Z&se=2122-09-27T07%3A51%3A45Z&sr=b&sp=rl&sig=824D0E6bLDJ48xHPuRPH7PCJ0R5gMyT5HYgpUs54YVg%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9b72401f-fa3f-447d-ac89-cd479814d3fe"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sl-SI, PetraNeural)",
        "shortName": "sl-SI-PetraNeural",
        "description": "",
        "locale": "sl-SI",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Petra",
            "LocalName": "Petra",
            "ShortName": "sl-SI-PetraNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "377",
            "LocaleDescription": "Slovenian",
            "PreviewSentence": "Razvijajte aplikacije in storitve z vrhunsko uporabniško izkušnjo povsem po meri uporabnikov.",
            "DisplayVoiceName": "PetraNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sl-SI",
            "localeZH": "斯洛文尼亚语(斯洛文尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/08c86987-7391-4c29-b6b8-4724e8735f60.wav?sv=2019-07-07&sr=b&sig=S0UULJLcT8%2BV1%2Ba5Y%2FK%2B8B%2BTKT3Y0JksdfaYPSZxmKo%3D&st=2021-10-29T08:28:08Z&se=2121-10-05T08:33:08Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f645c2c3-9181-442a-8d96-cda1eeffcccf"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-CA, JeanNeural)",
        "shortName": "fr-CA-JeanNeural",
        "description": "",
        "locale": "fr-CA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Jean",
            "LocalName": "Jean",
            "ShortName": "fr-CA-JeanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "238",
            "LocaleDescription": "French (Canada)",
            "PreviewSentence": "Créer des applications et des services qui parlent aux utilisateurs, améliorant ainsi l’accessibilité et la facilité d’utilisation.",
            "DisplayVoiceName": "JeanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-CA",
            "localeZH": "法语(加拿大)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7803a5be-516c-4b42-a09e-e59b377a629c.wav?sv=2019-07-07&sr=b&sig=tIGYLLBnXK9rdGcB7kzU2wMLU1lfZ0EahVOOpZvKZUE%3D&st=2021-10-29T08:26:57Z&se=2121-10-05T08:31:57Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "176f4338-31e6-43a9-bba2-cefe6bda182b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, NeilNeural)",
        "shortName": "en-AU-NeilNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Neil",
            "LocalName": "Neil",
            "ShortName": "en-AU-NeilNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "87",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "NeilNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1f65799d-7a64-4a54-96dd-89bfc7571966.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A17Z&se=2122-09-27T07%3A51%3A17Z&sr=b&sp=rl&sig=RSmdo3AnQg4dGBZOl9EuNL0kapcoCrtNO1nZAbX2APQ%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "46171608-fa13-4517-970b-cf3f7b9c00fb"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-IE, EmilyNeural)",
        "shortName": "en-IE-EmilyNeural",
        "description": "",
        "locale": "en-IE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Emily",
            "LocalName": "Emily",
            "ShortName": "en-IE-EmilyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "111",
            "LocaleDescription": "English (Ireland)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "EmilyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-IE",
            "localeZH": "英语(爱尔兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/38c2a8dd-4ebd-4c38-8a3a-7c63eb6fe509.wav?sv=2019-07-07&sr=b&sig=Q3clSFCRpV6bPrOZzGjsYu6PtJHdwv91aTxZJoBFDZ8%3D&st=2021-10-29T08:26:29Z&se=2121-10-05T08:31:29Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "948c1dbe-75f6-4c3e-a7be-cfa1ecdc2c9c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, CoralieNeural)",
        "shortName": "fr-FR-CoralieNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Coralie",
            "LocalName": "Coralie",
            "ShortName": "fr-FR-CoralieNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "245",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "CoralieNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6203ebbb-0b52-49db-982e-af8ab1ed2e49.wav?sv=2019-07-07&sr=b&sig=79G4c2LvqE2jfu43tdFbxwaTPHJYypJQBv0d54CfMbQ%3D&st=2022-01-19T09:01:26Z&se=2121-12-26T09:06:26Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "3a5b7702-dcd4-449f-ae08-cfc31b8f5fa4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN-henan, YundengNeural)",
        "shortName": "zh-CN-henan-YundengNeural",
        "locale": "zh-CN-henan",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yundeng",
            "LocalName": "云登",
            "ShortName": "zh-CN-henan-YundengNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "444",
            "LocaleDescription": "zh-CN-henan",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "YundengNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "zh-CN-henan",
            "localeZH": "中文(中原官话河南，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/54737f06-eb51-4bb6-955f-4cde2512306c.wav?sv=2019-07-07&sr=b&sig=xhYBA%2FeMpKyMZlb44kStghhEwReNT4cWSS1ws7EAyx8%3D&st=2022-08-30T08:13:44Z&se=2122-08-06T08:18:44Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d79eb070-849b-4b42-9ef5-d077965b075a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, YunyangNeural)",
        "shortName": "zh-CN-YunyangNeural",
        "description": "Profesional and fluent voice with multiple scenario styles.",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "customerservice,narration-professional,newscast-casual,Default",
            "VoiceStyleNameDefinitions": "{\"Default\":0}",
            "DisplayName": "Yunyang",
            "LocalName": "云扬",
            "ShortName": "zh-CN-YunyangNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "YoungAdult",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a8f66151-2121-42cd-a509-e09c4ef19124?sv=2019-07-07&sr=b&sig=HY2%2B%2B4Pny%2FkwwnQxNCih5GIDoKKcDhFCNHfk%2BrHBzwc%3D&st=2021-10-29T08:24:29Z&se=2121-10-05T08:29:29Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "424",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "YunyangNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "ExpressAsStyleValues": "Default,CustomerService",
            "ExpressAsRoleValues": "Default,CustomerService",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Audiobook",
                "defaultStyle": "narration"
            },
            {
                "name": "Newscast"
            },
            {
                "name": "CustomerService",
                "defaultStyle": "customerservice"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Newscast"
                ],
                "title": "云扬新闻",
                "titleLocalizationId": "zh-CN-YunyangNeural_Masterpieces_Newscast_YunyangNews_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/74a6b993-5efc-459b-9818-9af7b1fb144d?sv=2019-07-07&sr=b&sig=VV7Rnzr8i8TWDZ3kM97u2Qn%2BBzvCldjCbNC2sqTvWfk%3D&st=2021-10-29T08:24:56Z&se=2121-10-05T08:29:56Z&sp=rl"
            },
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "北平的四季",
                "titleLocalizationId": "zh-CN-YunyangNeural_Masterpieces_AudioBook_BeiPingDeSiJi_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b3b51b57-9daf-46a5-b8a5-459269bef018.wav?sv=2019-07-07&sr=b&sig=9Gb4fOcbdt%2FlPS61ydOoXTu7eZohcBmdai%2B0NRWKyeE%3D&st=2021-10-29T08:31:49Z&se=2121-10-05T08:36:49Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "customerservice",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0925e86d-53dc-40d0-a3d0-465ade2b5a52.wav?sv=2019-07-07&sr=b&sig=TZ3uvAF2%2FPNX%2BAlui6DOrCFUXX3iiWpFn0wysy1r5TI%3D&st=2021-10-29T08:29:32Z&se=2121-10-05T08:34:32Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/63410827-ad77-4319-868e-d01c1424e6ac.wav?sv=2019-07-07&sr=b&sig=Ixbp8gIrmryV3TBkP4tHtCHI%2FfC0w8tsVXvVNJElOws%3D&st=2021-10-29T08:29:33Z&se=2121-10-05T08:34:33Z&sp=rl"
                },
                {
                    "styleName": "narration",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/43238341-d95a-45d7-be16-87fc673bb23f.wav?sv=2019-07-07&sr=b&sig=d5QWx9FtvJhP3K8zD4kADz4nx050lcFLDXlViIc1etI%3D&st=2021-10-29T08:29:34Z&se=2121-10-05T08:34:34Z&sp=rl"
                },
                {
                    "styleName": "narration-professional",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/def47a02-8ebf-4ece-816c-802c9d488bf6.wav?sv=2019-07-07&sr=b&sig=shHae61piefsqRNZKLDcG%2Bz4YG4ggrgbAAvM5c9M2BQ%3D&st=2022-03-01T04:37:24Z&se=2122-02-05T04:42:24Z&sp=rl"
                },
                {
                    "styleName": "newscast-casual",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/df88a4f3-0a4d-471c-8c0c-f5a4021767cf.wav?sv=2019-07-07&sr=b&sig=c%2BfgmEPFKPiwF0G%2Fb0nsrSo%2FhgdLt9PO%2F6MTpNt1TOA%3D&st=2022-02-25T16:13:22Z&se=2122-02-01T16:18:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "cb034992-a2f3-4752-80ba-d093ddc3ea29"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, JacquelineNeural)",
        "shortName": "fr-FR-JacquelineNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Jacqueline",
            "LocalName": "Jacqueline",
            "ShortName": "fr-FR-JacquelineNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "248",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "JacquelineNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fa363447-ba01-4916-bbc5-4cc57cd2d1cb.wav?sv=2019-07-07&sr=b&sig=M91m4B0eUVmvOErAB0DKSFtp%2Ft7YM2pn1sRNgXYkCYM%3D&st=2022-01-19T09:01:31Z&se=2121-12-26T09:06:31Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5289eaf1-53e6-47e6-9844-d0b4a795897e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ta-MY, SuryaNeural)",
        "shortName": "ta-MY-SuryaNeural",
        "locale": "ta-MY",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Surya",
            "LocalName": "சூர்யா",
            "ShortName": "ta-MY-SuryaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "399",
            "LocaleDescription": "ta-MY",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SuryaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ta-MY",
            "localeZH": "泰米尔语(马来西亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c92d6619-347a-411e-90e9-15a5d293611f.wav?sv=2019-07-07&sr=b&sig=cXs1zQ27%2Fh9G1IycST38iD0cc0Vpx8gyepRsSvkVB%2Fk%3D&st=2022-07-01T09:08:40Z&se=2122-06-07T09:13:40Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6a0571cc-d619-41a8-b959-d19ee45dcbc6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (af-ZA, WillemNeural)",
        "shortName": "af-ZA-WillemNeural",
        "locale": "af-ZA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Willem",
            "LocalName": "Willem",
            "ShortName": "af-ZA-WillemNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "2",
            "LocaleDescription": "af-ZA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "WillemNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "af-ZA",
            "localeZH": "南非荷兰语(南非)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2e4b066d-a0a4-4525-b998-eefd09924419.wav?sv=2019-07-07&sr=b&sig=gWLxQWE00EwieMSL%2BL%2FcpaO51xrhvbHD9kT3P%2Fm72ao%3D&st=2021-10-29T08:29:55Z&se=2121-10-05T08:34:55Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "a4753064-3db5-4f5d-aeba-d28e7442c26f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (de-DE, GiselaNeural)",
        "shortName": "de-DE-GiselaNeural",
        "locale": "de-DE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gisela",
            "LocalName": "Gisela",
            "ShortName": "de-DE-GiselaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "65",
            "LocaleDescription": "German (Germany)",
            "PreviewSentence": "Erstellen Sie Apps und Dienste, die auf natürliche Art mit Nutzern sprechen, und dadurch Zugänglichkeit und Benutzerfreundlichkeit verbessern.",
            "DisplayVoiceName": "GiselaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "de-DE",
            "localeZH": "德语(德国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/06cd4bf5-4383-4b49-a59b-89fe7aa0a775.wav?sv=2019-07-07&sr=b&sig=q3YgOX7V8rqjJ6uR8SD%2BEhSphF1RTIkfsNTOsA4lyts%3D&st=2022-01-19T09:00:29Z&se=2121-12-26T09:05:29Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9bae679d-653a-4e89-82a0-d2c911f6bd1f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ja-JP, MayuNeural)",
        "shortName": "ja-JP-MayuNeural",
        "locale": "ja-JP",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Mayu",
            "LocalName": "真夕",
            "ShortName": "ja-JP-MayuNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "294",
            "LocaleDescription": "Japanese",
            "PreviewSentence": "アクセシビリティとユーザビリティを向上させながら、ユーザーに自然なことばを話すアプリとサービスを構築する",
            "DisplayVoiceName": "MayuNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ja-JP",
            "localeZH": "日语(日本)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/087a2899-a5b8-40d2-9459-3d3799d552a2.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A28Z&se=2122-09-27T07%3A52%3A28Z&sr=b&sp=rl&sig=dW1my40bjiujN4itCo18DcOuEopBT8COB8P%2BpObqOZY%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "cfcdcaa4-9d3c-4c67-ad23-d355b41f0a2a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, IreneNeural)",
        "shortName": "es-ES-IreneNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Irene",
            "LocalName": "Irene",
            "ShortName": "es-ES-IreneNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "175",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "IreneNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d5bb919d-baaf-46c6-8da5-4f5fd4fd130c.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A43Z&se=2122-09-27T07%3A51%3A43Z&sr=b&sp=rl&sig=TAi4qwIRLIJ6BgsffK2NJycWfK1H2mYq98n3dnviilA%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "db571d48-6b03-4247-87ea-d3d670ca9f16"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, BrendaNeural)",
        "shortName": "pt-BR-BrendaNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Brenda",
            "LocalName": "Brenda",
            "ShortName": "pt-BR-BrendaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "352",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "BrendaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cf1e6fc1-3f88-4809-907a-1b5346307fa5.wav?sv=2019-07-07&sr=b&sig=mHGhvvTqCtLCDg0hf7nVEpO8FclUhUgBFdr5ua6o4D8%3D&st=2022-07-01T09:10:11Z&se=2122-06-07T09:15:11Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "194f8bf8-0162-424c-ab15-d3d6bb145520"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ps-AF, GulNawazNeural)",
        "shortName": "ps-AF-GulNawazNeural",
        "locale": "ps-AF",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Gul Nawaz",
            "LocalName": " ګل نواز",
            "ShortName": "ps-AF-GulNawazNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "348",
            "LocaleDescription": "ps-AF",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "GulNawazNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ps-AF",
            "localeZH": "普什图语(阿富汗)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/255c72a4-2e34-42f4-8402-f56d492f136e.wav?sv=2019-07-07&sr=b&sig=VFWtBpBed5EUfm7PqP2i6JFd%2FCHV7rqEMFj9dLYlgU0%3D&st=2022-01-19T09:02:11Z&se=2121-12-26T09:07:11Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "752fe147-0bdf-4426-9eb7-d3e50eef4e35"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-TW, HsiaoYuNeural)",
        "shortName": "zh-TW-HsiaoYuNeural",
        "description": "",
        "locale": "zh-TW",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "HsiaoYu",
            "LocalName": "曉雨",
            "ShortName": "zh-TW-HsiaoYuNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "453",
            "LocaleDescription": "Chinese (Taiwan)",
            "PreviewSentence": "建構可以和使用者自然對話的應用程式和服務，來提高其方便性和實用性。",
            "DisplayVoiceName": "HsiaoYuNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "zh-TW",
            "localeZH": "中文(台湾普通话)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7984f96b-e52a-4a76-9bb2-df447ab6939f.wav?sv=2019-07-07&sr=b&sig=3tzoc68l8FTrXSOOKHVT9ffDpSbmvGScmYk0zscyDRk%3D&st=2021-10-29T08:29:52Z&se=2121-10-05T08:34:52Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7881206a-84f7-48a2-b3d3-d42023552efb"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, YvesNeural)",
        "shortName": "fr-FR-YvesNeural",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yves",
            "LocalName": "Yves",
            "ShortName": "fr-FR-YvesNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "252",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "YvesNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6b415d75-1b34-4140-b1d1-2c2ca2433b93.wav?sv=2019-07-07&sr=b&sig=cGAkyivIzw6Evwz9skWR530mg1i8P8fk9njvaQN58io%3D&st=2022-01-19T09:01:39Z&se=2121-12-26T09:06:39Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7dd10772-f742-4b98-8374-d473a8431e20"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, JacobNeural)",
        "shortName": "en-US-JacobNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Jacob",
            "LocalName": "Jacob",
            "ShortName": "en-US-JacobNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "139",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "JacobNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/118375a8-d2a1-450c-a252-cf02b3795716.wav?sv=2019-07-07&sr=b&sig=l%2Bzshq%2BBG6IdYg2NoUeJlqjxU%2BDreaRQkpIi0CkuKxw%3D&st=2021-10-29T08:25:39Z&se=2121-10-05T08:30:39Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c8e1b1c1-e5c4-4f04-93ab-d55b83949751"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, DonatoNeural)",
        "shortName": "pt-BR-DonatoNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Donato",
            "LocalName": "Donato",
            "ShortName": "pt-BR-DonatoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "353",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "DonatoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0967df5e-1c85-4400-8310-c27b7b4c9d67.wav?sv=2019-07-07&sr=b&sig=wQZ6ewPWEZSm0MFwoZDDQ5wJsD9nFEdiAR%2Fs7gXaVjg%3D&st=2022-07-01T09:10:13Z&se=2122-06-07T09:15:13Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "78af6233-41a2-420f-a3fe-d5e66296529f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fil-PH, BlessicaNeural)",
        "shortName": "fil-PH-BlessicaNeural",
        "locale": "fil-PH",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Blessica",
            "LocalName": "Blessica",
            "ShortName": "fil-PH-BlessicaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "233",
            "LocaleDescription": "fil-PH",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "BlessicaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fil-PH",
            "localeZH": "菲律宾语(菲律宾)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6788a858-34a4-43cd-99a1-bec4dc694a55.wav?sv=2019-07-07&sr=b&sig=S%2Fl2gOhfX%2FtoJOlxt6iBcj1tzJDK3dpXmgRSDJK028g%3D&st=2021-10-29T08:31:04Z&se=2121-10-05T08:36:04Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d6bb7968-50b7-4f22-bcf1-d709c49e70fe"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-BH, AliNeural)",
        "shortName": "ar-BH-AliNeural",
        "locale": "ar-BH",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ali",
            "LocalName": "علي",
            "ShortName": "ar-BH-AliNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "7",
            "LocaleDescription": "ar-BH",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AliNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-BH",
            "localeZH": "阿拉伯语(巴林)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/22aaff93-3036-49ca-b350-1dbb7dfe4c8e.wav?sv=2019-07-07&sr=b&sig=Ec%2Bp3mFvbuFz9vKWc1raTjvC%2Bp4Xaab8vXot5MsuGxc%3D&st=2021-10-29T08:29:59Z&se=2121-10-05T08:34:59Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "90f920d8-c159-41a0-8f3e-d7f8997ad666"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (nl-NL, FennaNeural)",
        "shortName": "nl-NL-FennaNeural",
        "locale": "nl-NL",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Fenna",
            "LocalName": "Fenna",
            "ShortName": "nl-NL-FennaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "343",
            "LocaleDescription": "Dutch",
            "PreviewSentence": "Ontwikkel apps en diensten die natuurlijk aanvoelen, waardoor de toegankelijkheid en bruikbaarheid vergroot worden.",
            "DisplayVoiceName": "FennaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "nl-NL",
            "localeZH": "荷兰语(荷兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e986f0c2-3c44-4f78-8d21-13750be8f10a.wav?sv=2019-07-07&sr=b&sig=z44s1K2A3GNF7qzzhrgw%2FQPvFxf2MugeNM5NqIflU9g%3D&st=2021-10-29T08:27:46Z&se=2121-10-05T08:32:46Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d4ed37d8-8d9f-47a2-8042-d82b9f6daf90"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-IN, NeerjaNeural)",
        "shortName": "en-IN-NeerjaNeural",
        "description": "",
        "locale": "en-IN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Neerja",
            "LocalName": "Neerja",
            "ShortName": "en-IN-NeerjaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "112",
            "LocaleDescription": "English (India)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "NeerjaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-IN",
            "localeZH": "英语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f637752e-6307-4180-887f-2c2c02b66930.wav?sv=2019-07-07&sr=b&sig=QwYzQgCSTuoXAohY0hdl3N%2BIDi3BVK9enuicMKknf%2Fg%3D&st=2021-10-29T08:26:30Z&se=2121-10-05T08:31:30Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "9622ee9e-a68a-444b-ad30-d84db7340f07"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-US, PalomaNeural)",
        "shortName": "es-US-PalomaNeural",
        "locale": "es-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Paloma",
            "LocalName": "Paloma",
            "ShortName": "es-US-PalomaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "218",
            "LocaleDescription": "es-US",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "PalomaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-US",
            "localeZH": "西班牙语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b082dac2-0a6a-4637-9bd5-36b05c437b89.wav?sv=2019-07-07&sr=b&sig=hXaQPdV1I%2BiK1FKJ1lzMZhBkJoIGeHB7F2FGeHTkPTg%3D&st=2021-10-29T08:26:48Z&se=2121-10-05T08:31:48Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "22bcc50c-a99e-4acb-8355-d853c9804874"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, NancyNeural)",
        "shortName": "en-US-NancyNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "angry,cheerful,excited,friendly,hopeful,sad,shouting,terrified,unfriendly,whispering,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Nancy",
            "LocalName": "Nancy",
            "ShortName": "en-US-NancyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "144",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "NancyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6ea25992-a569-49f8-b0bc-c257573d1784.wav?sv=2019-07-07&sr=b&sig=53%2Ffce3CKkiV%2FEbrBZmE%2FWj80t58rvh8vrpsHjVpyc0%3D&st=2022-05-05T09:39:01Z&se=2122-04-11T09:44:01Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/dedacd0a-6a00-4012-9a1d-7f9fb74439bf.wav?sv=2019-07-07&sr=b&sig=otCZemJleRaT4MPQ3ytslzjODBH2W6UMiv5TV%2FiqdPY%3D&st=2022-04-28T10:28:09Z&se=2122-04-04T10:33:09Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8ea8ca76-5244-4e95-91fc-e63a5adbf463.wav?sv=2019-07-07&sr=b&sig=Yex6gk368pgfkTREoLInBAFCSDX7noK9CU9bYOUy82w%3D&st=2022-04-28T10:28:12Z&se=2122-04-04T10:33:12Z&sp=rl"
                },
                {
                    "styleName": "excited",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cd5030c1-2f2d-4661-9d3d-9693197a2939.wav?sv=2019-07-07&sr=b&sig=JQxCQC3o05bisJDeETqbweiLa9fkjGnPy4Qz9p753ZI%3D&st=2022-04-28T10:28:14Z&se=2122-04-04T10:33:14Z&sp=rl"
                },
                {
                    "styleName": "friendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/90a807c5-89bf-45c4-8a03-1fbe330f1137.wav?sv=2019-07-07&sr=b&sig=zelCuNshZ8%2B3n9dQ2igCJMhOtg8hSZGC1QpIWvEEAGk%3D&st=2022-04-28T10:28:16Z&se=2122-04-04T10:33:16Z&sp=rl"
                },
                {
                    "styleName": "hopeful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fca0b4e3-8c06-4d75-8ebd-0816c2f5ede8.wav?sv=2019-07-07&sr=b&sig=UKn8X0TP1iwP7H6dQd7keNKqmXSmH3roXw%2BRhplbEn4%3D&st=2022-04-28T10:28:18Z&se=2122-04-04T10:33:18Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b0dfae29-094c-467c-8e9f-15c860ace2e3.wav?sv=2019-07-07&sr=b&sig=Htwm%2FKmlUW0C8i38A5B10RznQdE4uVNNwkjAMG0ltwo%3D&st=2022-04-28T10:28:21Z&se=2122-04-04T10:33:21Z&sp=rl"
                },
                {
                    "styleName": "shouting",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6861102a-2be4-40fe-8391-efe82e596209.wav?sv=2019-07-07&sr=b&sig=yATmcvFSgW%2FZqhhxL%2B1xErjRv4YdaIBIQhdAsT%2FHzRs%3D&st=2022-04-28T10:28:23Z&se=2122-04-04T10:33:23Z&sp=rl"
                },
                {
                    "styleName": "terrified",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9b94811a-8ab6-4687-ae9c-1b9442141b68.wav?sv=2019-07-07&sr=b&sig=Ve4iDx%2FGATYBJtBfJKNeUWINIGOfcbhvctO5JhNZXWQ%3D&st=2022-04-28T10:28:25Z&se=2122-04-04T10:33:25Z&sp=rl"
                },
                {
                    "styleName": "unfriendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b04d1a7e-fe38-4856-be97-ac2265b6bb30.wav?sv=2019-07-07&sr=b&sig=g3NKMQlZ%2BXJqObqS9%2BoK9z9ePny6jPGFZqnQco9hW8w%3D&st=2022-04-28T10:28:27Z&se=2122-04-04T10:33:27Z&sp=rl"
                },
                {
                    "styleName": "whispering",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9a0633ec-638b-47ef-a73a-032e00632ed1.wav?sv=2019-07-07&sr=b&sig=bHLd%2BA8hCtwj1gSdQE12Ej48HzZTFFIDaGVMClJFXuM%3D&st=2022-04-28T10:28:30Z&se=2122-04-04T10:33:30Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "52c945ea-c060-4085-aef7-d9c6951f0a86"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-HK, WanLungNeural)",
        "shortName": "zh-HK-WanLungNeural",
        "locale": "zh-HK",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "WanLung",
            "LocalName": "雲龍",
            "ShortName": "zh-HK-WanLungNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "451",
            "LocaleDescription": "Chinese (Hong Kong)",
            "PreviewSentence": "開發可自然地與用戶溝通的應用程式及服務，以提升其使用度及可用性。",
            "DisplayVoiceName": "WanLungNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "zh-HK",
            "localeZH": "中文(粤语，繁体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/584581e9-b86d-4178-acd1-f687830cd956.wav?sv=2019-07-07&sr=b&sig=Z3VKNznp%2F%2FKVLgqUCth2krgP%2FThmWy2pYCfy0XUo%2Bas%3D&st=2021-10-29T08:29:50Z&se=2121-10-05T08:34:50Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "3f845c8a-1e92-4b44-8217-da0f9f634dc4"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (az-AZ, BanuNeural)",
        "shortName": "az-AZ-BanuNeural",
        "locale": "az-AZ",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Banu",
            "LocalName": "Banu",
            "ShortName": "az-AZ-BanuNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "38",
            "LocaleDescription": "az-AZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "BanuNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "az-AZ",
            "localeZH": "阿塞拜疆语(阿塞拜疆) "
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/032e5978-5ef3-4b12-a093-f88cc908a6f4.wav?sv=2019-07-07&sr=b&sig=3QLr05iJR28%2F2ywWfN4tv9Yz%2FfNOvyhNTq2I%2BfD08NE%3D&st=2022-07-01T09:08:55Z&se=2122-06-07T09:13:55Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c03df8e3-1e9d-49a1-acb5-daa2aa3e2d2d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, AbrilNeural)",
        "shortName": "es-ES-AbrilNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Abril",
            "LocalName": "Abril",
            "ShortName": "es-ES-AbrilNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "169",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "AbrilNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/53e2cf9b-89c3-432b-afa6-1cae263c8418.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A32Z&se=2122-09-27T07%3A51%3A32Z&sr=b&sp=rl&sig=vGxyJ7vyoRyemH2Q0hNywcZCQ9eM3K4hqNthkH06tsI%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5e59b45b-251e-4424-ab41-db4ac3c27895"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sw-KE, ZuriNeural)",
        "shortName": "sw-KE-ZuriNeural",
        "locale": "sw-KE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Zuri",
            "LocalName": "Zuri",
            "ShortName": "sw-KE-ZuriNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "391",
            "LocaleDescription": "sw-KE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ZuriNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sw-KE",
            "localeZH": "斯瓦希里语(肯尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/592c5fce-c759-4c41-bcfd-a7255d788204.wav?sv=2019-07-07&sr=b&sig=ha9mujiN6yjiA4M5CMncRk9xS6B5FnSEIU53rutOLSQ%3D&st=2021-10-29T08:28:14Z&se=2121-10-05T08:33:14Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c315f54f-d225-40fc-bf38-db9afc3449cc"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (so-SO, MuuseNeural)",
        "shortName": "so-SO-MuuseNeural",
        "locale": "so-SO",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Muuse",
            "LocalName": "Muuse",
            "ShortName": "so-SO-MuuseNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "379",
            "LocaleDescription": "so-SO",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MuuseNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "so-SO",
            "localeZH": "索马里语(索马里)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/042db3b2-7136-4cc5-9ae6-078673ced639.wav?sv=2019-07-07&sr=b&sig=ryJ%2Fiym8gJSXdinLpVvCDZIqnnG%2FdPYWbfhOMWkk9lw%3D&st=2021-10-29T08:31:13Z&se=2121-10-05T08:36:13Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e572c97c-d4aa-4c57-8be4-dc529d34ab29"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (sl-SI, RokNeural)",
        "shortName": "sl-SI-RokNeural",
        "locale": "sl-SI",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Rok",
            "LocalName": "Rok",
            "ShortName": "sl-SI-RokNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "378",
            "LocaleDescription": "Slovenian",
            "PreviewSentence": "Razvijajte aplikacije in storitve z vrhunsko uporabniško izkušnjo povsem po meri uporabnikov.",
            "DisplayVoiceName": "RokNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "sl-SI",
            "localeZH": "斯洛文尼亚语(斯洛文尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/03c642e4-e769-4161-ad57-ffd2ae3ea5d1.wav?sv=2019-07-07&sr=b&sig=VViuh%2B7ZxgAwXKSW7iRaelvwxSlx88QXnEW4CZUs0%2FI%3D&st=2021-10-29T08:28:09Z&se=2121-10-05T08:33:09Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "236139f8-3803-40db-8b24-dcb56104a973"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-AE, HamdanNeural)",
        "shortName": "ar-AE-HamdanNeural",
        "locale": "ar-AE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Hamdan",
            "LocalName": "حمدان",
            "ShortName": "ar-AE-HamdanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "6",
            "LocaleDescription": "ar-AE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "HamdanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-AE",
            "localeZH": "阿拉伯语(阿拉伯联合酋长国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/f3f1470a-2c1e-47e4-8335-828c6870f04c.wav?sv=2019-07-07&sr=b&sig=RelBmhw6%2BakQxGbqDnxxaqA4pY%2FG2HNHOUrmOBv2i4k%3D&st=2021-10-29T08:29:58Z&se=2121-10-05T08:34:58Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "963644be-9a6a-4a7c-8f30-ddab286f4ba0"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN, XiaomoNeural)",
        "shortName": "zh-CN-XiaomoNeural",
        "description": "Clear and relaxing voice with rich role-play and emotions that is optimized for audio books.",
        "locale": "zh-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "YoungAdultFemale,YoungAdultMale,OlderAdultFemale,OlderAdultMale,SeniorFemale,SeniorMale,Girl,Boy,Default",
            "VoiceRoleNameDefinitions": "{\"YoungAdultFemale\":4,\"YoungAdultMale\":1,\"OlderAdultFemale\":5,\"OlderAdultMale\":2,\"SeniorFemale\":10,\"SeniorMale\":3,\"Girl\":8,\"Boy\":9,\"Default\":0}",
            "VoiceStyleNames": "embarrassed,calm,fearful,cheerful,disgruntled,serious,angry,sad,depressed,affectionate,gentle,envious,Default",
            "VoiceStyleNameDefinitions": "{\"embarrassed\":1,\"calm\":2,\"fearful\":3,\"cheerful\":4,\"disgruntled\":5,\"serious\":6,\"angry\":7,\"sad\":8,\"depressed\":10,\"affectionate\":9,\"gentle\":11,\"Default\":0}",
            "DisplayName": "Xiaomo",
            "LocalName": "晓墨",
            "ShortName": "zh-CN-XiaomoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "AgeGroups": "YoungAdult",
            "IconFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/64693a99-6981-46a7-ab94-67cf185b2bbf?sv=2019-07-07&sr=b&sig=%2FQtxKGUYE6ZVXK0vnXkj6VKLzf0ZU9EqTxLGTrKHum4%3D&st=2021-10-29T08:24:21Z&se=2121-10-05T08:29:21Z&sp=rl",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "428",
            "LocaleDescription": "Chinese (Mainland)",
            "PreviewSentence": "通过提供能和用户自然交流的应用程序和服务，以改善其可访问性和可用性。",
            "DisplayVoiceName": "XiaomoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "IsTtsBreakEnabled": "True",
            "locale": "zh-CN",
            "localeZH": "中文(普通话，简体)"
        },
        "categories": [
            {
                "name": "All"
            },
            {
                "name": "Audiobook"
            },
            {
                "name": "Chat"
            }
        ],
        "masterpieces": [
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "晓墨有声书《呼兰河传》",
                "titleLocalizationId": "zh-CN-XiaomoNeural_Masterpieces_AudioBook_HuLanHeZhuan_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/bd0d12fb-8b4f-4db9-9efe-3ac1b9fc4b4f?sv=2019-07-07&sr=b&sig=fCgXha3rya0f7dYq9HXNdKGapiU0ZmXES3%2BEZWFzmu8%3D&st=2021-10-29T08:24:48Z&se=2121-10-05T08:29:48Z&sp=rl"
            },
            {
                "categories": [
                    "Audiobook"
                ],
                "title": "晓墨有声书《马伯乐》",
                "titleLocalizationId": "zh-CN-XiaomoNeural_Masterpieces_AudioBook_MaBoLe_Title",
                "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1ea12800-a66d-45b8-9355-06b83b17a6ae?sv=2019-07-07&sr=b&sig=s8Lmx6jIlr3RF%2F5IdPN6lRr80FQzYnfthDqJ0F29Ors%3D&st=2021-10-29T08:24:49Z&se=2121-10-05T08:29:49Z&sp=rl"
            }
        ],
        "samples": {
            "languageSamples": [],
            "roleSamples": [
                {
                    "roleName": "Default",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/52ff557c-7750-4292-84c0-58a36b2a2a38.wav?sv=2019-07-07&sr=b&sig=Kr6yQEWbLS4KFA58fjoMkWO6yJJzsxyhkbi2szb41yw%3D&st=2021-10-29T08:31:29Z&se=2121-10-05T08:36:29Z&sp=rl"
                },
                {
                    "roleName": "Boy",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/3d36d976-1c39-43f7-9fa7-c635e68e5310.wav?sv=2019-07-07&sr=b&sig=clLI3Oncqry60L%2FsSg2vDh3D%2Fvqe5OEJ7vFl19%2B%2FbT8%3D&st=2021-10-29T08:31:30Z&se=2121-10-05T08:36:30Z&sp=rl"
                },
                {
                    "roleName": "Girl",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5a310bfd-e7b9-42c8-9fee-6992b4e80885.wav?sv=2019-07-07&sr=b&sig=Iy%2BOWdkKwvP5wW6CD0kV6MlLFBw43Di%2Bb22L7IzFG0Q%3D&st=2021-10-29T08:31:31Z&se=2121-10-05T08:36:31Z&sp=rl"
                },
                {
                    "roleName": "OlderAdultFemale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8066acfc-820c-4e87-b148-35c9e2effec7.wav?sv=2019-07-07&sr=b&sig=TlqpzWhGLJWNblXk8m3J7L3mn4nFrCim5r6cah2DwLw%3D&st=2021-10-29T08:31:32Z&se=2121-10-05T08:36:32Z&sp=rl"
                },
                {
                    "roleName": "OlderAdultMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0f60b76f-8434-4d2d-a12b-fefb9a38312f.wav?sv=2019-07-07&sr=b&sig=WRbGxsg3Bf4BnD8LlXgHl%2Fn%2FqebBE0TrWUkyry70P1A%3D&st=2021-10-29T08:31:33Z&se=2121-10-05T08:36:33Z&sp=rl"
                },
                {
                    "roleName": "SeniorFemale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/dabb2598-a37d-4e42-b87e-6f028487507a.wav?sv=2019-07-07&sr=b&sig=oUUNf4RlcSoZ%2FyvsXJq7VelyTAE6X97kDeYq0egHcwg%3D&st=2021-10-29T08:31:34Z&se=2121-10-05T08:36:34Z&sp=rl"
                },
                {
                    "roleName": "SeniorMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9329262a-59f0-4295-81fb-9901d97ef808.wav?sv=2019-07-07&sr=b&sig=FQnLCRv86qpgCYFpa5pSCTixFZlIYOm3qHC6E20OdeY%3D&st=2021-10-29T08:31:35Z&se=2121-10-05T08:36:35Z&sp=rl"
                },
                {
                    "roleName": "YoungAdultFemale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d05b45e5-a358-45aa-b762-247c009b7129.wav?sv=2019-07-07&sr=b&sig=MTVpCWsfEuaTBAxgLoCsdUN0G2a8Yh8qiq%2B7Widt4b4%3D&st=2021-10-29T08:31:36Z&se=2121-10-05T08:36:36Z&sp=rl"
                },
                {
                    "roleName": "YoungAdultMale",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/83642188-6398-45cf-b0fb-e22fb1e74b83.wav?sv=2019-07-07&sr=b&sig=QcT%2FRVdsW78z62u3SQsGObQh141fb8DgDL7oa9TAAyI%3D&st=2021-10-29T08:31:37Z&se=2121-10-05T08:36:37Z&sp=rl"
                }
            ],
            "styleSamples": [
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0e0e9e82-5ef4-4eea-be3e-14face618ee7.wav?sv=2019-07-07&sr=b&sig=1YlCmZS%2BGV0pcLF60r9p9%2Bs8KvwunjoVEI4CmOXuLkI%3D&st=2021-10-29T08:28:42Z&se=2121-10-05T08:33:42Z&sp=rl"
                },
                {
                    "styleName": "calm",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/eb330945-55f6-4279-b5fd-0072c919ddee.wav?sv=2019-07-07&sr=b&sig=vXmVwS9PT5NlODnpJcoerGTFtIboA4QDLROyjphjfNs%3D&st=2021-10-29T08:28:43Z&se=2121-10-05T08:33:43Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4e0f1ecf-7032-41a2-9fff-4f6855b68052.wav?sv=2019-07-07&sr=b&sig=3B5HlILJKwjx%2FjGbiYNC%2FVu2fQEgNYWtsosy2Ax3CwM%3D&st=2021-10-29T08:28:44Z&se=2121-10-05T08:33:44Z&sp=rl"
                },
                {
                    "styleName": "depressed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6ff44ced-301d-4fbd-a297-8b8acb270667.wav?sv=2019-07-07&sr=b&sig=wMV1r4o0%2Bm4U2dWdfLFt%2B5gocU2MGTJIFAnz9ng%2BFso%3D&st=2021-10-29T08:28:45Z&se=2121-10-05T08:33:45Z&sp=rl"
                },
                {
                    "styleName": "disgruntled",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d64d01be-b919-4be4-9bbc-9f03c56568fa.wav?sv=2019-07-07&sr=b&sig=m56ItegVutLLGZtghNXACvEDdx98BKs2EhTy98HcsIQ%3D&st=2021-10-29T08:28:46Z&se=2121-10-05T08:33:46Z&sp=rl"
                },
                {
                    "styleName": "fearful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/be664af1-0101-4cda-baf4-46ce20b56342.wav?sv=2019-07-07&sr=b&sig=TmZJ31YBRJVt6UNJaHDrNVurZWIgKpvG1yschAQFNDk%3D&st=2021-10-29T08:28:47Z&se=2121-10-05T08:33:47Z&sp=rl"
                },
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b9b403fd-5bae-4962-b21d-d3b2b9c70dc0.wav?sv=2019-07-07&sr=b&sig=JUcNA956d9OLlMwLAjKeMdVbMLQUyMqFg1zdSaldST0%3D&st=2021-10-29T08:28:48Z&se=2121-10-05T08:33:48Z&sp=rl"
                },
                {
                    "styleName": "gentle",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a397419e-1c5f-435b-a3d2-722d6b4d7d8b.wav?sv=2019-07-07&sr=b&sig=p2sDXyHz4BKaeCmwMTXK2Qusfd0gs6utW7wAMj9CG6g%3D&st=2021-10-29T08:28:49Z&se=2121-10-05T08:33:49Z&sp=rl"
                },
                {
                    "styleName": "serious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/11d33875-6a91-46db-bee1-8c93eaee7cb9.wav?sv=2019-07-07&sr=b&sig=qzOr4FJRSO9RiNButs0C57qGRoM6Jp5xnnJ%2FwDIr2p0%3D&st=2021-10-29T08:28:50Z&se=2121-10-05T08:33:50Z&sp=rl"
                },
                {
                    "styleName": "affectionate",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fe0424aa-b006-4168-8b88-5b3b0e4d536c.wav?sv=2019-07-07&sr=b&sig=j1XBmNquWZZ14lp0w10xQttRtZsgGy9v87MiiuBW7EE%3D&st=2021-12-20T11:26:47Z&se=2121-11-26T11:31:47Z&sp=rl"
                },
                {
                    "styleName": "embarrassed",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/17eeb808-fa65-41a9-bd60-9d56b9d9d7e1.wav?sv=2019-07-07&sr=b&sig=J01kMUjjUXSW1PpR5HnZxjfI6Zztcy6cmyHqtLOCA%2BU%3D&st=2021-12-20T11:26:50Z&se=2121-11-26T11:31:50Z&sp=rl"
                },
                {
                    "styleName": "Envy",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d56947cd-8eb1-423a-bff9-ab9405562305.wav?sv=2019-07-07&sr=b&sig=6CCDTVwbvFS2wT9ZPGr3nRmMWgI5DsQXyJaQW%2BlYqfU%3D&st=2021-12-20T11:26:52Z&se=2121-11-26T11:31:52Z&sp=rl"
                },
                {
                    "styleName": "envious",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d56947cd-8eb1-423a-bff9-ab9405562305.wav?sv=2019-07-07&sr=b&sig=6CCDTVwbvFS2wT9ZPGr3nRmMWgI5DsQXyJaQW%2BlYqfU%3D&st=2021-12-20T11:26:52Z&se=2121-11-26T11:31:52Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/460b5c2b-1123-4abf-80ff-3b18ef980b28.wav?sv=2019-07-07&sr=b&sig=i2R60koN4wuUeoPNmwS7TFuB8qT%2F%2Bupgwlk75VB%2FsXM%3D&st=2021-12-20T11:26:55Z&se=2121-11-26T11:31:55Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0ca5d0ac-5a66-4d8e-9140-de556ef3916d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, HumbertoNeural)",
        "shortName": "pt-BR-HumbertoNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Humberto",
            "LocalName": "Humberto",
            "ShortName": "pt-BR-HumbertoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "357",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "HumbertoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7b7b37d0-7235-4f09-8232-5e061f19c9b3.wav?sv=2019-07-07&sr=b&sig=JgJiiIBuZsDgjZX8kpIW6pqcaXPLKSBihGMXHiZaEZ0%3D&st=2022-07-01T09:10:22Z&se=2122-06-07T09:15:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6233d99d-eb7b-4890-bd5a-e0139af6cb4b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, EthanNeural)",
        "shortName": "en-GB-EthanNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ethan",
            "LocalName": "Ethan",
            "ShortName": "en-GB-EthanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "98",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "EthanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0d0ecf50-b8fb-4eaa-afde-da89b09e43cc.wav?sv=2019-07-07&sr=b&sig=11kFtaEpWViHcnQLRTkiPgSyu%2BnYEDhnRZqt7LkE9m0%3D&st=2022-01-19T09:01:00Z&se=2121-12-26T09:06:00Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "21d7ae8e-30af-4fa6-a265-e03e6a76e2be"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-NZ, MitchellNeural)",
        "shortName": "en-NZ-MitchellNeural",
        "locale": "en-NZ",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Mitchell",
            "LocalName": "Mitchell",
            "ShortName": "en-NZ-MitchellNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "118",
            "LocaleDescription": "en-NZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MitchellNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-NZ",
            "localeZH": "英语(新西兰)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e0f38332-30e3-4812-9dfe-ab312ccee838.wav?sv=2019-07-07&sr=b&sig=V8HcYMuLZovzMJxDhTXmvwSRbuk%2F1hBCVwKOIIina7U%3D&st=2021-10-29T08:26:32Z&se=2121-10-05T08:31:32Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8cc98d23-ea9d-4bde-85d3-e0dcdb17fddf"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zu-ZA, ThembaNeural)",
        "shortName": "zu-ZA-ThembaNeural",
        "locale": "zu-ZA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Themba",
            "LocalName": "Themba",
            "ShortName": "zu-ZA-ThembaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "456",
            "LocaleDescription": "zu-ZA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ThembaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "zu-ZA",
            "localeZH": "祖鲁语(南非)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5ff78846-a6b5-4fe6-b14b-4be6c0b872be.wav?sv=2019-07-07&sr=b&sig=9MDYSkez2nnzv%2BLiZYgsUEGhZ8QEqiK0GGfYlsBVfFs%3D&st=2021-10-29T08:31:28Z&se=2121-10-05T08:36:28Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "608b582e-0934-4d7c-b33d-e172e724cae5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-PA, RobertoNeural)",
        "shortName": "es-PA-RobertoNeural",
        "locale": "es-PA",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Roberto",
            "LocalName": "Roberto",
            "ShortName": "es-PA-RobertoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "208",
            "LocaleDescription": "es-PA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "RobertoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-PA",
            "localeZH": "西班牙语(巴拿马)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c3861064-2726-4784-ac7f-ca6228d4ef32.wav?sv=2019-07-07&sr=b&sig=Vzdh8IIC2p82vB2A27zyVJSJZwK8Xz%2Bq7dR6RX4wc70%3D&st=2021-10-29T08:30:49Z&se=2121-10-05T08:35:49Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "dc81141a-304d-48ed-b9cb-e203f94b3ad8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ms-MY, OsmanNeural)",
        "shortName": "ms-MY-OsmanNeural",
        "locale": "ms-MY",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Osman",
            "LocalName": "Osman",
            "ShortName": "ms-MY-OsmanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "329",
            "LocaleDescription": "Malay",
            "PreviewSentence": "Membina aplikasi dan perkhidmatan yang bercakap sememangnya kepada pengguna, meningkatkan kebolehcapaian dan kebolehgunaanya.",
            "DisplayVoiceName": "OsmanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ms-MY",
            "localeZH": "马来语(马来西亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0f7655f2-0289-4eb5-9535-2d6f4002d47c.wav?sv=2019-07-07&sr=b&sig=SfWf%2F2azdsvq08NkcXikBoFFgL6LTISwi66Iw3oz58w%3D&st=2021-10-29T08:27:32Z&se=2121-10-05T08:32:32Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "fe3060ea-a2a3-4c44-969c-e2b59cf5d342"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, GuyNeural)",
        "shortName": "en-US-GuyNeural",
        "description": "",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "newscast,angry,cheerful,sad,excited,friendly,terrified,shouting,unfriendly,whispering,hopeful,Default",
            "VoiceStyleNameDefinitions": "{\"angry\":7,\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Guy",
            "LocalName": "Guy",
            "ShortName": "en-US-GuyNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "128",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "GuyNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/80a0b1f2-b2b8-4dec-83f1-a15ca5a45f52.wav?sv=2019-07-07&sr=b&sig=kfS%2FUdQg3Wu37aWskWvBkVGdTbhrZZGqcQQ6xd1VQ7g%3D&st=2021-10-29T08:25:37Z&se=2121-10-05T08:30:37Z&sp=rl"
                },
                {
                    "styleName": "newscast",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c60ea716-7984-4d8c-b886-7abdbe8df66b.wav?sv=2019-07-07&sr=b&sig=oM9jysbJy2sv9Nc0P8HZyurgYeKtZ8%2BK%2FSy%2BKznwFXU%3D&st=2021-10-29T08:25:38Z&se=2121-10-05T08:30:38Z&sp=rl"
                },
                {
                    "styleName": "angry",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/de130c31-1e18-4fe4-9ead-7105dc5be49a.wav?sv=2019-07-07&sr=b&sig=hFqMrZ5aJyR2IcpnYquKbYKvFgNZxfILVRl3xlVS%2ByU%3D&st=2022-04-28T10:25:50Z&se=2122-04-04T10:30:50Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5346520a-2ae3-4ed0-94ff-419e99666a18.wav?sv=2019-07-07&sr=b&sig=vsjWhjD9dmB%2FUCnBfP76JxVBu8H8Z1YfJsLb%2FzbIosY%3D&st=2022-04-28T10:25:52Z&se=2122-04-04T10:30:52Z&sp=rl"
                },
                {
                    "styleName": "excited",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2fc9bff9-2350-45e6-aa38-9041be63453d.wav?sv=2019-07-07&sr=b&sig=zzWt3NGlGGY5U5iiS9cePR2zzV9e%2BFSKD7CWRcvfq00%3D&st=2022-04-28T10:25:55Z&se=2122-04-04T10:30:55Z&sp=rl"
                },
                {
                    "styleName": "friendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fcd059e0-683a-4f29-bb32-d04cbce04431.wav?sv=2019-07-07&sr=b&sig=fGIDrzJ7c1fSxpwR8wRTYE9Pl8h9smQLFpMoSsA5AwI%3D&st=2022-04-28T10:25:57Z&se=2122-04-04T10:30:57Z&sp=rl"
                },
                {
                    "styleName": "hopeful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c76d2e20-8672-480e-b1c1-d06d932bbfeb.wav?sv=2019-07-07&sr=b&sig=bb048dTml8wsf%2Bicd9bSPT2VvMOJdJ0cKI5DqUdVrzs%3D&st=2022-04-28T10:25:59Z&se=2122-04-04T10:30:59Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/52f63f14-582b-4581-b0f4-74a588c8b68a.wav?sv=2019-07-07&sr=b&sig=M8exKg%2F34ecrEThwelnZ%2Bz%2Bw0AoQrIecEhkCeMeoDkk%3D&st=2022-04-28T10:26:01Z&se=2122-04-04T10:31:01Z&sp=rl"
                },
                {
                    "styleName": "shouting",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c1313b6e-192b-4b53-ac33-c7fa315da639.wav?sv=2019-07-07&sr=b&sig=w8veL4pc9nLOv1smnFkDhkT9FCPI2y6hbAluZZOeQlc%3D&st=2022-04-28T10:26:04Z&se=2122-04-04T10:31:04Z&sp=rl"
                },
                {
                    "styleName": "terrified",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/57f89d08-2776-4513-a1b3-82d203a893df.wav?sv=2019-07-07&sr=b&sig=L3n3f0yOZw6t6lRcsqCRsDJZgNpmANqWcR90rmQEyqY%3D&st=2022-04-28T10:26:06Z&se=2122-04-04T10:31:06Z&sp=rl"
                },
                {
                    "styleName": "unfriendly",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d8270914-7460-4d4e-a217-6bba35906928.wav?sv=2019-07-07&sr=b&sig=aGuFKf3T5lx3lu4lc9NV3bVh3JYzJ5i11p21xGVn%2Fsc%3D&st=2022-04-28T10:26:08Z&se=2122-04-04T10:31:08Z&sp=rl"
                },
                {
                    "styleName": "whispering",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/70bfe78d-5c85-46b1-b5bb-1f8992c7314e.wav?sv=2019-07-07&sr=b&sig=x0flIet%2Bqn6IM8Qce%2BqVXW2CcbyQqzeXyf8l%2FSrGZbg%3D&st=2022-04-28T10:26:10Z&se=2122-04-04T10:31:10Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e0638b39-fbd2-4497-a482-e2f65759412a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-QA, AmalNeural)",
        "shortName": "ar-QA-AmalNeural",
        "locale": "ar-QA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Amal",
            "LocalName": "أمل",
            "ShortName": "ar-QA-AmalNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "27",
            "LocaleDescription": "ar-QA",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AmalNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-QA",
            "localeZH": "阿拉伯语(卡塔尔)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/6688d736-513a-48dc-83da-65976d8b8bf6.wav?sv=2019-07-07&sr=b&sig=rlKV0d3uVQzsnSCYxCHdjRNPDpOwt6oSTXLp3DG93kk%3D&st=2021-10-29T08:30:13Z&se=2121-10-05T08:35:13Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "59a12d88-9d94-4e6e-99e6-e49c1f433870"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-PE, CamilaNeural)",
        "shortName": "es-PE-CamilaNeural",
        "locale": "es-PE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Camila",
            "LocalName": "Camila",
            "ShortName": "es-PE-CamilaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "210",
            "LocaleDescription": "es-PE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "CamilaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-PE",
            "localeZH": "西班牙语(秘鲁)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4cbe6a7e-45ac-4a06-b245-8c5bc90e99b1.wav?sv=2019-07-07&sr=b&sig=SAzKcjSiUapBxZPDHXpnhwtkdj4S%2FBdmNgsgQpz7x1E%3D&st=2021-10-29T08:30:51Z&se=2121-10-05T08:35:51Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7dd4e360-55ef-4e1a-ac97-e53fe874660f"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-HK, HiuMaanNeural)",
        "shortName": "zh-HK-HiuMaanNeural",
        "locale": "zh-HK",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "HiuMaan",
            "LocalName": "曉曼",
            "ShortName": "zh-HK-HiuMaanNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "449",
            "LocaleDescription": "Chinese (Hong Kong)",
            "PreviewSentence": "開發可自然地與用戶溝通的應用程式及服務，以提升其使用度及可用性。",
            "DisplayVoiceName": "HiuMaanNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "zh-HK",
            "localeZH": "中文(粤语，繁体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/afec9184-36f5-423f-b497-9d792847ebf7.wav?sv=2019-07-07&sr=b&sig=kUvcZ46upW7C2vG7V%2F7LUxIB%2BRaW%2FH2hC7IQjhcaXoY%3D&st=2021-10-29T08:29:49Z&se=2121-10-05T08:34:49Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ec92d13c-b25b-4aa8-9e40-e65015775398"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (pt-BR, LeticiaNeural)",
        "shortName": "pt-BR-LeticiaNeural",
        "locale": "pt-BR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Leticia",
            "LocalName": "Leticia",
            "ShortName": "pt-BR-LeticiaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "360",
            "LocaleDescription": "Portuguese (Brazil)",
            "PreviewSentence": "Desenvolver aplicativos e serviços que conversem naturalmente com os usuários, melhorando a acessibilidade e usabilidade.",
            "DisplayVoiceName": "LeticiaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "pt-BR",
            "localeZH": "葡萄牙语(巴西)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ac4291a2-af7e-4f4e-b523-15476d993986.wav?sv=2019-07-07&sr=b&sig=VDy9qbawTe9VsiBWMB8dNphF3Zc0YaZcFF1ub0CuyWs%3D&st=2022-07-01T09:10:29Z&se=2122-06-07T09:15:29Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6eac313c-0139-4f09-a44a-e7d8731c1f1e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-BO, MarceloNeural)",
        "shortName": "es-BO-MarceloNeural",
        "locale": "es-BO",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Marcelo",
            "LocalName": "Marcelo",
            "ShortName": "es-BO-MarceloNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "155",
            "LocaleDescription": "es-BO",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MarceloNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-BO",
            "localeZH": "西班牙语(玻利维亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/dd7cfedb-d4b3-4d11-9674-db3be1e813d4.wav?sv=2019-07-07&sr=b&sig=tEngoL8QT4e7AOMZvqFqg5rAhOk9gawnb1ChKKkFPsQ%3D&st=2021-10-29T08:30:29Z&se=2121-10-05T08:35:29Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "e11817e0-75e6-48ad-b375-e8ede271ee2d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, TeoNeural)",
        "shortName": "es-ES-TeoNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Teo",
            "LocalName": "Teo",
            "ShortName": "es-ES-TeoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "180",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "TeoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2dad996f-9286-44e4-9aeb-f7a5062b7378.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A54Z&se=2122-09-27T07%3A51%3A54Z&sr=b&sp=rl&sig=VNgW4VMRocJquxep4yRZHYgkKivvKxxOgdcgEJgvyFo%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f4ae5b2b-c6f5-4574-a516-ea413ddd638b"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (yue-CN, XiaoMinNeural)",
        "shortName": "yue-CN-XiaoMinNeural",
        "locale": "yue-CN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "XiaoMin",
            "LocalName": "晓敏",
            "ShortName": "yue-CN-XiaoMinNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "421",
            "LocaleDescription": "yue-CN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "XiaoMinNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "yue-CN",
            "localeZH": "中文(粤语，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/97858b63-9f84-4f13-982b-b3ed4e6fba60.wav?sv=2021-08-06&st=2022-10-21T11%3A57%3A32Z&se=2122-09-27T12%3A02%3A32Z&sr=b&sp=rl&sig=laAn%2FiQecyy0W0AvT9I3Zn2pBBaRIXBNOZtYPwoaG9k%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d6db2ea7-2048-4c35-8733-ea7de8e8278d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-BO, SofiaNeural)",
        "shortName": "es-BO-SofiaNeural",
        "locale": "es-BO",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sofia",
            "LocalName": "Sofia",
            "ShortName": "es-BO-SofiaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "156",
            "LocaleDescription": "es-BO",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SofiaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-BO",
            "localeZH": "西班牙语(玻利维亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/2e6bd1b8-bda6-40b9-bcec-c517f48f021e.wav?sv=2019-07-07&sr=b&sig=8wEHOJds38KqYSGfg%2BCY%2B5yAHlTm957Jjk0ZbpBFUpc%3D&st=2021-10-29T08:30:29Z&se=2121-10-05T08:35:29Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "77225261-11e8-4f00-92c5-ebd3cea15fa9"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (tr-TR, AhmetNeural)",
        "shortName": "tr-TR-AhmetNeural",
        "locale": "tr-TR",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ahmet",
            "LocalName": "Ahmet",
            "ShortName": "tr-TR-AhmetNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "407",
            "LocaleDescription": "Turkish",
            "PreviewSentence": "Kullanıcılarla doğal biçimde konuşan, erişilebilirlik ve kullanılabilirliği iyileştiren uygulama ve servisler geliştirmek.",
            "DisplayVoiceName": "AhmetNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "tr-TR",
            "localeZH": "土耳其语(Türkiye)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/d683104c-db4a-4c59-b5dd-1c4081ee9b6b.wav?sv=2019-07-07&sr=b&sig=3QenHt6zJHOgbYW6NqO19%2FE4Yy9XhWbr%2FowJhUfDlFc%3D&st=2021-10-29T08:28:22Z&se=2121-10-05T08:33:22Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "3e7c9283-5b48-4bf8-acec-ec7e4a51828c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (jv-ID, DimasNeural)",
        "shortName": "jv-ID-DimasNeural",
        "locale": "jv-ID",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Dimas",
            "LocalName": "Dimas",
            "ShortName": "jv-ID-DimasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "297",
            "LocaleDescription": "jv-ID",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "DimasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "jv-ID",
            "localeZH": "爪哇语(印度尼西亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/65b124ed-4aa7-47f1-8f36-7f87097faa18.wav?sv=2019-07-07&sr=b&sig=D%2BnO78cuSxQMQ20uTLgnCyHszWVqIkMYEk1WKxoZNzQ%3D&st=2021-10-29T08:31:07Z&se=2121-10-05T08:36:07Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f8e3c0b1-fe18-4009-ae86-ecc464d3d4a5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-GB, OliviaNeural)",
        "shortName": "en-GB-OliviaNeural",
        "locale": "en-GB",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Olivia",
            "LocalName": "Olivia",
            "ShortName": "en-GB-OliviaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "103",
            "LocaleDescription": "English (UK)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "OliviaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-GB",
            "localeZH": "英语(英国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7c7bba31-c3db-478f-87c5-c03d50012ed3.wav?sv=2019-07-07&sr=b&sig=ZTZXzA05Z1Xap3O%2FbZNztoetWMYf9QdqrOZKfoeqlgA%3D&st=2022-01-19T09:01:12Z&se=2121-12-26T09:06:12Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "253a7da2-fc9a-4e1b-8d26-ed2919ecb899"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (uz-UZ, MadinaNeural)",
        "shortName": "uz-UZ-MadinaNeural",
        "locale": "uz-UZ",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Madina",
            "LocalName": "Madina",
            "ShortName": "uz-UZ-MadinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "415",
            "LocaleDescription": "uz-UZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MadinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "uz-UZ",
            "localeZH": "乌兹别克语(乌兹别克斯坦)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c4868900-70ce-4b9f-b8a4-03677b280169.wav?sv=2019-07-07&sr=b&sig=CEQVJbCSMusSkeSgO3ea2gZLvZwKUdrAWoMVx3Ktxok%3D&st=2021-10-29T08:31:26Z&se=2121-10-05T08:36:26Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "3641b93d-312b-4227-ae32-ed681431ba38"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-ES, LiaNeural)",
        "shortName": "es-ES-LiaNeural",
        "locale": "es-ES",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Lia",
            "LocalName": "Lia",
            "ShortName": "es-ES-LiaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "177",
            "LocaleDescription": "Spanish (Spain)",
            "PreviewSentence": "Crea aplicaciones y servicios que hablan de forma natural a los usuarios, y que mejoran la accesibilidad y la facilidad de uso.",
            "DisplayVoiceName": "LiaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-ES",
            "localeZH": "西班牙语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c81ffd57-6eaa-420c-8a5c-a076bab03ab4.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A47Z&se=2122-09-27T07%3A51%3A47Z&sr=b&sp=rl&sig=%2Bv0lGKiO3rbUoMFEJ5Y13ruBwQgiodDZVoHcxqGSQOg%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b1377f34-f7dd-4744-88ec-ef2fbc9ed336"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (hu-HU, TamasNeural)",
        "shortName": "hu-HU-TamasNeural",
        "locale": "hu-HU",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Tamas",
            "LocalName": "Tamás",
            "ShortName": "hu-HU-TamasNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "268",
            "LocaleDescription": "Hungarian",
            "PreviewSentence": "Készítsen appokat és szolgáltatásokat, melyek természetes hangon beszélnek a felhasználóval, ezáltal hozzáférhetőbbek és könnyebben használhatóak.",
            "DisplayVoiceName": "TamasNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "hu-HU",
            "localeZH": "匈牙利语(匈牙利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c8787051-37a5-441b-af29-0fd7f5b4ed90.wav?sv=2019-07-07&sr=b&sig=sbq3pGNZjyfM9O6UHOwjAfz4BHyr8QdpeVuchsM2ZE4%3D&st=2021-10-29T08:27:14Z&se=2121-10-05T08:32:14Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7c31a42d-a9f5-4780-81f2-f05183453f7c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (id-ID, ArdiNeural)",
        "shortName": "id-ID-ArdiNeural",
        "description": "",
        "locale": "id-ID",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ardi",
            "LocalName": "Ardi",
            "ShortName": "id-ID-ArdiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "271",
            "LocaleDescription": "Indonesian",
            "PreviewSentence": "Buat aplikasi dan layanan yang berbicara secara alami kepada pengguna, sehingga meningkatkan aksesibilitas dan kegunaan.",
            "DisplayVoiceName": "ArdiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "id-ID",
            "localeZH": "印度尼西亚语(印度尼西亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/126d8203-456e-4cae-a9b9-9a670e5aee6c.wav?sv=2019-07-07&sr=b&sig=WyMavFM1VsrGxIWflwaVGViDVebuw1UFjf3woMhxMig%3D&st=2021-10-29T08:27:15Z&se=2121-10-05T08:32:15Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "6eae597f-b880-47c8-bbe6-f05e69fbdf9d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (kk-KZ, DauletNeural)",
        "shortName": "kk-KZ-DauletNeural",
        "locale": "kk-KZ",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Daulet",
            "LocalName": "Дәулет",
            "ShortName": "kk-KZ-DauletNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "302",
            "LocaleDescription": "kk-KZ",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "DauletNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "kk-KZ",
            "localeZH": "哈萨克语(哈萨克斯坦)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/5493cad8-f74b-4562-a561-326d7a3b9d03.wav?sv=2019-07-07&sr=b&sig=J6QJrYKDE3bn4BkT6FRfPiD5X4%2FRCswYkCZxm7crBII%3D&st=2022-01-19T09:01:51Z&se=2121-12-26T09:06:51Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "990dd0ec-a391-4336-8f00-f0f1b46c5d20"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-PR, KarinaNeural)",
        "shortName": "es-PR-KarinaNeural",
        "locale": "es-PR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Karina",
            "LocalName": "Karina",
            "ShortName": "es-PR-KarinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "211",
            "LocaleDescription": "es-PR",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "KarinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-PR",
            "localeZH": "西班牙语(波多黎各)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e7bf6114-7b2b-495a-ad57-1d9040061431.wav?sv=2019-07-07&sr=b&sig=9thqRPpC24EAIXis4DChU7tmH2JzYGV%2Fy%2FiJH6dPNp0%3D&st=2021-10-29T08:30:52Z&se=2121-10-05T08:35:52Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "02973e72-898f-454c-9e9e-f11e46ec8400"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (cs-CZ, VlastaNeural)",
        "shortName": "cs-CZ-VlastaNeural",
        "description": "",
        "locale": "cs-CZ",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Vlasta",
            "LocalName": "Vlasta",
            "ShortName": "cs-CZ-VlastaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "51",
            "LocaleDescription": "Czech",
            "PreviewSentence": "Vytvořte aplikace a služby pro přirozenou komunikaci s uživateli a usnadněte tak přístup a využití.",
            "DisplayVoiceName": "VlastaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "cs-CZ",
            "localeZH": "捷克语(捷克)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fd18561b-f6a0-4c30-8b16-772e627ba39c.wav?sv=2019-07-07&sr=b&sig=azeqJr5618z5XGt1yii3bEqEiWUaNlLmJgAYtAPJgV0%3D&st=2021-10-29T08:26:05Z&se=2121-10-05T08:31:05Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b9a3e70b-049d-45aa-99ec-f171badf48ad"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-US, AlonsoNeural)",
        "shortName": "es-US-AlonsoNeural",
        "locale": "es-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Alonso",
            "LocalName": "Alonso",
            "ShortName": "es-US-AlonsoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "217",
            "LocaleDescription": "es-US",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AlonsoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-US",
            "localeZH": "西班牙语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c30f471a-646e-498b-8b8d-031c7d24049e.wav?sv=2019-07-07&sr=b&sig=nBaBQK8BblJF1sk4GecPaGyfSJF%2B%2BtRJIaoCgVB1Rz4%3D&st=2021-10-29T08:26:47Z&se=2121-10-05T08:31:47Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "76bc3321-2dfe-4d5f-bb6d-f1dcbafba5a2"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ca-ES, EnricNeural)",
        "shortName": "ca-ES-EnricNeural",
        "locale": "ca-ES",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Enric",
            "LocalName": "Enric",
            "ShortName": "ca-ES-EnricNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "49",
            "LocaleDescription": "Catalan",
            "PreviewSentence": "Crea aplicacions i serveis que parlen de forma natural als usuaris, i que milloren l'accessibilitat i la facilitat d'ús.",
            "DisplayVoiceName": "EnricNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ca-ES",
            "localeZH": "加泰罗尼亚语(西班牙)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/800b678b-966d-4bc1-b452-81bb65bc9ccc.wav?sv=2019-07-07&sr=b&sig=bLTMxKJRYWayhkHuGXZ1vdeREHOvDKUT4bm2avyc5Q0%3D&st=2021-10-29T08:26:02Z&se=2121-10-05T08:31:02Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "989cb719-479f-4bd6-9490-f3634d3f4b15"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ko-KR, SeoHyeonNeural)",
        "shortName": "ko-KR-SeoHyeonNeural",
        "locale": "ko-KR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "SeoHyeon",
            "LocalName": "서현",
            "ShortName": "ko-KR-SeoHyeonNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "312",
            "LocaleDescription": "Korean",
            "PreviewSentence": "사용자들에게 자연스럽게 이야기하는 앱과 서비스를 만들며 접근성과 사용성을 개선시킵니다.",
            "DisplayVoiceName": "SeoHyeonNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "ko-KR",
            "localeZH": "韩语(韩国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/414461a0-6e6e-4982-921f-85a3aa26ebd0.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A41Z&se=2122-09-27T07%3A52%3A41Z&sr=b&sp=rl&sig=Ok4H3Y1tSz5PFGYELJXM2Vpg6P3%2F517yfATsAFGeOU0%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2e7fd13b-b651-4055-8cc4-f382246dcee5"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-MX, DaliaNeural)",
        "shortName": "es-MX-DaliaNeural",
        "description": "",
        "locale": "es-MX",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Dalia",
            "LocalName": "Dalia",
            "ShortName": "es-MX-DaliaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "194",
            "LocaleDescription": "Spanish (Mexico)",
            "PreviewSentence": "Crea apps y servicios que hablen de forma natural con los usuarios, mejorando la accesibilidad y la usabilidad.",
            "DisplayVoiceName": "DaliaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-MX",
            "localeZH": "西班牙语(墨西哥)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/a8b8e9d9-35ca-48b6-b12c-1db37bbfcb4e.wav?sv=2019-07-07&sr=b&sig=e9ZHgQC7w50zXVdiW%2F%2BJRriLc2ri8E0xMKPHMMvXanw%3D&st=2021-10-29T08:26:45Z&se=2121-10-05T08:31:45Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f7b51518-94d6-471c-bed6-f384525f6877"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-TN, ReemNeural)",
        "shortName": "ar-TN-ReemNeural",
        "locale": "ar-TN",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Reem",
            "LocalName": "ريم",
            "ShortName": "ar-TN-ReemNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "34",
            "LocaleDescription": "ar-TN",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ReemNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-TN",
            "localeZH": "阿拉伯语(突尼斯)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/8f059465-316f-4a39-aa47-8c4a925f657f.wav?sv=2019-07-07&sr=b&sig=tpI1NctTEY4vohJ9%2BPVmf4N2Nvs7zKZPoCyNRljXfW4%3D&st=2021-10-29T08:30:18Z&se=2121-10-05T08:35:18Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "93317eac-e4c4-4178-98f5-f3a0b4e1a7fe"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-EG, SalmaNeural)",
        "shortName": "ar-EG-SalmaNeural",
        "description": "",
        "locale": "ar-EG",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Salma",
            "LocalName": "سلمى",
            "ShortName": "ar-EG-SalmaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "11",
            "LocaleDescription": "Arabic (Egypt)",
            "PreviewSentence": "إن التطبيقات التي تتحاور مع المستخدمين بصوره طبيعية،  تعمل على  تحسين امكانية الوصول اليها وسهولة الاستخدام",
            "DisplayVoiceName": "SalmaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-EG",
            "localeZH": "阿拉伯语(埃及)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/130644d5-1cea-43f8-a97d-87b2002c6e31.wav?sv=2019-07-07&sr=b&sig=ATlZztJbxCCEe5VIAsOHzWcjqWbUZ%2BKp%2FBP4kYkVbiM%3D&st=2021-10-29T08:25:55Z&se=2121-10-05T08:30:55Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "a4e51bc1-71c2-4645-a2ba-f4b78720e0a7"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (hy-AM, HaykNeural)",
        "shortName": "hy-AM-HaykNeural",
        "locale": "hy-AM",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Hayk",
            "LocalName": "Հայկ",
            "ShortName": "hy-AM-HaykNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "270",
            "LocaleDescription": "hy-AM",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "HaykNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "hy-AM",
            "localeZH": "亚美尼亚语(亚美尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c9806de9-6af4-4d51-a92b-5d7dd284e4d9.wav?sv=2021-08-06&st=2022-10-21T07%3A47%3A16Z&se=2122-09-27T07%3A52%3A16Z&sr=b&sp=rl&sig=iSsoHBdM4Y4FhGnIOUMzTS%2FBb4Uj0qA8BK3ePHiaXtM%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ea1f2715-ab0d-4c34-ac01-f4de0b4d9150"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-US, ChristopherNeural)",
        "shortName": "en-US-ChristopherNeural",
        "locale": "en-US",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Christopher",
            "LocalName": "Christopher",
            "ShortName": "en-US-ChristopherNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "134",
            "LocaleDescription": "English (US)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ChristopherNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-US",
            "localeZH": "英语(美国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/742136cb-7587-4497-a5a2-059950b0eb34.wav?sv=2019-07-07&sr=b&sig=aR7faI%2B9c2cT%2FnzSb176tTZjfqSkFvjO9n4re6yKuQ4%3D&st=2021-10-29T08:25:33Z&se=2121-10-05T08:30:33Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "4337134d-4e59-48d1-af56-f4e96771bda1"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-EG, ShakirNeural)",
        "shortName": "ar-EG-ShakirNeural",
        "locale": "ar-EG",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Shakir",
            "LocalName": "شاكر",
            "ShortName": "ar-EG-ShakirNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "12",
            "LocaleDescription": "Arabic (Egypt)",
            "PreviewSentence": "إن التطبيقات التي تتحاور مع المستخدمين بصوره طبيعية،  تعمل على  تحسين امكانية الوصول اليها وسهولة الاستخدام",
            "DisplayVoiceName": "ShakirNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-EG",
            "localeZH": "阿拉伯语(埃及)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/46a1e2e4-073b-4b29-81e0-0b9c63653c85.wav?sv=2019-07-07&sr=b&sig=8d03IlrE0jG3tN52TCoG1%2Faxvs9FbQCNivV1DO9ATEk%3D&st=2021-10-29T08:25:56Z&se=2121-10-05T08:30:56Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "b46c29d0-e660-4be9-8758-f54dfe71eb97"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (jv-ID, SitiNeural)",
        "shortName": "jv-ID-SitiNeural",
        "locale": "jv-ID",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Siti",
            "LocalName": "Siti",
            "ShortName": "jv-ID-SitiNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "298",
            "LocaleDescription": "jv-ID",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SitiNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "jv-ID",
            "localeZH": "爪哇语(印度尼西亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fb44bdd1-f72e-44ae-a2af-efc2db688ea1.wav?sv=2019-07-07&sr=b&sig=J%2FxlBYDzjZ6wCtykZW2b5n20xvxIqP2UGEKjkdS12Po%3D&st=2021-10-29T08:31:08Z&se=2121-10-05T08:36:08Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "5fb5ba29-0956-4ab0-bfd2-f55ada33426d"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-KE, ChilembaNeural)",
        "shortName": "en-KE-ChilembaNeural",
        "locale": "en-KE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Chilemba",
            "LocalName": "Chilemba",
            "ShortName": "en-KE-ChilembaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "115",
            "LocaleDescription": "en-KE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ChilembaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-KE",
            "localeZH": "英语(肯尼亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1b227fa9-cf19-40d7-9e81-bfd1f596f5a4.wav?sv=2019-07-07&sr=b&sig=UB5G5oTMpiqvZ0II0lqno7K0VdUb7eqzNzxHHFrdxos%3D&st=2021-10-29T08:30:24Z&se=2121-10-05T08:35:24Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "c403c07c-19ff-45dc-887b-f5b2639bff31"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (zh-CN-shandong, YunxiangNeural)",
        "shortName": "zh-CN-shandong-YunxiangNeural",
        "locale": "zh-CN-shandong",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Yunxiang",
            "LocalName": "云翔",
            "ShortName": "zh-CN-shandong-YunxiangNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "447",
            "LocaleDescription": "zh-CN-shandong",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "YunxiangNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "zh-CN-shandong",
            "localeZH": "中文(冀鲁官话，简体)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/60831540-2711-40d3-8741-83233345fe4f.wav?sv=2019-07-07&sr=b&sig=J0OYjjq8SmtLOakSHv6DytS9na1EySO8TabnxmewZT0%3D&st=2022-08-30T08:13:46Z&se=2122-08-06T08:18:46Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8b49a818-048b-4251-a1c3-f5b97d978db3"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-LB, LaylaNeural)",
        "shortName": "ar-LB-LaylaNeural",
        "locale": "ar-LB",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Layla",
            "LocalName": "ليلى",
            "ShortName": "ar-LB-LaylaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "19",
            "LocaleDescription": "ar-LB",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LaylaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-LB",
            "localeZH": "阿拉伯语(黎巴嫩)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/cd855623-8f42-4d82-af5f-a9450d3119be.wav?sv=2019-07-07&sr=b&sig=a6lax2WYFxI1NW66hDEHtOdXq8cUzAOV4jPxPSeZs1s%3D&st=2022-07-01T09:08:43Z&se=2122-06-07T09:13:43Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7326354c-b68b-46e7-98e0-f671a8b8c141"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, ElsaNeural)",
        "shortName": "it-IT-ElsaNeural",
        "description": "",
        "locale": "it-IT",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Elsa",
            "LocalName": "Elsa",
            "ShortName": "it-IT-ElsaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "279",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "ElsaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0bd6ab7e-efbf-42e4-a5a9-c07cde253349.wav?sv=2019-07-07&sr=b&sig=EJjnjqAB91c8ZZw6%2F85BFCj0L8IJG%2BpdI0Uveat%2BXKI%3D&st=2021-10-29T08:27:18Z&se=2121-10-05T08:32:18Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "735db598-81e2-408f-b039-f7afef686748"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-BE, CharlineNeural)",
        "shortName": "fr-BE-CharlineNeural",
        "locale": "fr-BE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Charline",
            "LocalName": "Charline",
            "ShortName": "fr-BE-CharlineNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "234",
            "LocaleDescription": "French (Belgium)",
            "PreviewSentence": "La Création de Contenu Audio vous permet de contrôler visuellement les attributs vocaux en temps réel.",
            "DisplayVoiceName": "CharlineNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "fr-BE",
            "localeZH": "法语(比利时)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/b3ae52d5-8eea-4aaf-b18c-17ba4da22821.wav?sv=2019-07-07&sr=b&sig=uR1hPZvFbr%2BndQaroPgDOfAFkx3R36DTm4Z7p1ARSCI%3D&st=2021-10-29T08:26:54Z&se=2121-10-05T08:31:54Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "88c51e8f-a6d1-4967-96c1-f7c93a9b5b0e"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (nl-BE, DenaNeural)",
        "shortName": "nl-BE-DenaNeural",
        "locale": "nl-BE",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Dena",
            "LocalName": "Dena",
            "ShortName": "nl-BE-DenaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "341",
            "LocaleDescription": "Dutch (Belgium)",
            "PreviewSentence": "Audio-inhoud Aanmaken laat u toe om visueel de spraakeigenschappen in te stellen in real-time.",
            "DisplayVoiceName": "DenaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "nl-BE",
            "localeZH": "荷兰语(比利时)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/ef625918-9c93-471f-ae54-e37d46047ce6.wav?sv=2019-07-07&sr=b&sig=0ZrnQ0ixnffSJ71NA9RvCwszNJ6vz0%2BvI3hc2rrcLRs%3D&st=2021-10-29T08:27:42Z&se=2121-10-05T08:32:42Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "68d38509-2bda-4a63-b939-f7d78d3b56a6"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-SA, ZariyahNeural)",
        "shortName": "ar-SA-ZariyahNeural",
        "description": "",
        "locale": "ar-SA",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Zariyah",
            "LocalName": "زارية",
            "ShortName": "ar-SA-ZariyahNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "30",
            "LocaleDescription": "Arabic (Saudi Arabia)",
            "PreviewSentence": "إن التطبيقات التي تتحاور مع المستخدمين بصوره طبيعية،  تعمل على  تحسين امكانية الوصول اليها وسهولة الاستخدام",
            "DisplayVoiceName": "ZariyahNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-SA",
            "localeZH": "阿拉伯语(沙特阿拉伯)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/19a68d06-fa8c-41ed-9d07-112359f30efe.wav?sv=2019-07-07&sr=b&sig=vsiuKJ897BMXTqDtJSMZ0CVtVA%2Fg0mx6RgJlvvl%2Bih4%3D&st=2021-10-29T08:25:58Z&se=2121-10-05T08:30:58Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "2e0c3be2-e1ba-48c5-adeb-f99460796c3c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, ElsieNeural)",
        "shortName": "en-AU-ElsieNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Elsie",
            "LocalName": "Elsie",
            "ShortName": "en-AU-ElsieNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "81",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "ElsieNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/1e6eef4d-18f2-4618-b46b-48796aa9e531.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A06Z&se=2122-09-27T07%3A51%3A06Z&sr=b&sp=rl&sig=ilF5gLsfBPIWQ%2FMKsqnbLtrHG3ev8YnIj6Y23SVSNK8%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "641d91b0-5484-4a79-a926-fbd57b080d61"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (it-IT, RinaldoNeural)",
        "shortName": "it-IT-RinaldoNeural",
        "locale": "it-IT",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Rinaldo",
            "LocalName": "Rinaldo",
            "ShortName": "it-IT-RinaldoNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "288",
            "LocaleDescription": "Italian",
            "PreviewSentence": "Benvenuti nella piattaforma di generazione di contenuti audio di Microsoft.",
            "DisplayVoiceName": "RinaldoNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "it-IT",
            "localeZH": "意大利语(意大利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/17c7cece-cbd4-4088-9f6e-60f906bda749.wav?sv=2019-07-07&sr=b&sig=87V%2B60lR1TAWLxFAQj17BoZoYGEaEbod1MYYkw9L6o8%3D&st=2022-07-01T09:09:55Z&se=2122-06-07T09:14:55Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "0824e990-0c58-43d2-997d-fc63fa573b04"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (fr-FR, DeniseNeural)",
        "shortName": "fr-FR-DeniseNeural",
        "description": "",
        "locale": "fr-FR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "cheerful,sad,Default",
            "VoiceStyleNameDefinitions": "{\"cheerful\":4,\"sad\":8,\"Default\":0}",
            "DisplayName": "Denise",
            "LocalName": "Denise",
            "ShortName": "fr-FR-DeniseNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "254",
            "LocaleDescription": "French (France)",
            "PreviewSentence": "Construire des applications et services qui communiquent naturellement avec l'utilisateur, en améliorant l’accessibilité et l'ergonomie",
            "DisplayVoiceName": "DeniseNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicPreview",
            "locale": "fr-FR",
            "localeZH": "法语(法国)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/55a6d687-0695-48d8-b5df-099f1caf6dd6.wav?sv=2019-07-07&sr=b&sig=cFTcv2ByipfxyC11BLJzgmgxyQMuXb8GOnknmkto4Ho%3D&st=2021-10-29T08:27:01Z&se=2121-10-05T08:32:01Z&sp=rl"
                },
                {
                    "styleName": "cheerful",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/320f3b90-e0b5-4dab-ac30-6b0df03cd32a.wav?sv=2019-07-07&sr=b&sig=t6mKtnpdcfg%2BqWHyqTJNUprEEjrb%2FVh1iMLGXb0%2Bjfo%3D&st=2022-03-23T16:49:15Z&se=2122-02-27T16:54:15Z&sp=rl"
                },
                {
                    "styleName": "sad",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/337d92cc-58b8-419c-bc78-b14a904083f3.wav?sv=2019-07-07&sr=b&sig=hxnujM5q8IeDP9jjtdCITpkKXu3k4feYdyrxZA0hhKA%3D&st=2022-03-23T16:49:18Z&se=2122-02-27T16:54:18Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "1346514b-fb3e-4b9a-a4e5-fcb93d91e4bc"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-CL, CatalinaNeural)",
        "shortName": "es-CL-CatalinaNeural",
        "locale": "es-CL",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Catalina",
            "LocalName": "Catalina",
            "ShortName": "es-CL-CatalinaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "157",
            "LocaleDescription": "es-CL",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "CatalinaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-CL",
            "localeZH": "西班牙语(智利)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/c4673b4d-d3f5-4200-9d9c-6b9137eb7792.wav?sv=2019-07-07&sr=b&sig=4hQm5oOiOkB2XMEVzj6Ay6KbcorRvK7Z9%2Biw5KtMnvE%3D&st=2021-10-29T08:30:30Z&se=2121-10-05T08:35:30Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7006e439-22ec-463e-b284-fceac3d0d4d1"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-CR, MariaNeural)",
        "shortName": "es-CR-MariaNeural",
        "locale": "es-CR",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Maria",
            "LocalName": "María",
            "ShortName": "es-CR-MariaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "162",
            "LocaleDescription": "es-CR",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MariaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-CR",
            "localeZH": "西班牙语(哥斯达黎加)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/db1a3207-71f9-4a16-9302-ae2ab13b1c58.wav?sv=2019-07-07&sr=b&sig=fQCLkspjC03ZR9rg%2BHK38D6LJcGY%2B%2BFoie2tRIeYy5s%3D&st=2021-10-29T08:30:33Z&se=2121-10-05T08:35:33Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "7053b22a-5f8a-4f1f-816f-fd6c31fd4b83"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-IN, PrabhatNeural)",
        "shortName": "en-IN-PrabhatNeural",
        "locale": "en-IN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Prabhat",
            "LocalName": "Prabhat",
            "ShortName": "en-IN-PrabhatNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "113",
            "LocaleDescription": "English (India)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "PrabhatNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-IN",
            "localeZH": "英语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/85e7e275-f9ab-4fe1-bd81-5c436ce4e937.wav?sv=2019-07-07&sr=b&sig=Gs59CTmk1Qj9AJv0umHnhkEhneO8b1lWU3IgoLQH5cc%3D&st=2021-10-29T08:26:31Z&se=2121-10-05T08:31:31Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "637ffba4-caa2-436e-a6d1-fda7a339eafe"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-EC, LuisNeural)",
        "shortName": "es-EC-LuisNeural",
        "locale": "es-EC",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Luis",
            "LocalName": "Luis",
            "ShortName": "es-EC-LuisNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "168",
            "LocaleDescription": "es-EC",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "LuisNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-EC",
            "localeZH": "西班牙语(厄瓜多尔)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/4d74645d-1d7a-4e71-a491-b754a4e0352c.wav?sv=2019-07-07&sr=b&sig=LN6Q%2FWbL8WmfAPDb6iY9N7tZp7f7z7AVe1D1mRom9mc%3D&st=2021-10-29T08:30:39Z&se=2121-10-05T08:35:39Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d99ca458-b92d-41a1-9aa3-fdd348ab1f9c"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (mk-MK, MarijaNeural)",
        "shortName": "mk-MK-MarijaNeural",
        "locale": "mk-MK",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Marija",
            "LocalName": "Марија",
            "ShortName": "mk-MK-MarijaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "322",
            "LocaleDescription": "mk-MK",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "MarijaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "mk-MK",
            "localeZH": "马其顿语(北马其顿)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/be815f6a-4612-40f3-98bf-dab74dbc61f4.wav?sv=2019-07-07&sr=b&sig=DueN3rq%2FjfZjivG8vKGbT69S1WoRsl5Wyv6BA1byKmQ%3D&st=2022-01-19T09:02:04Z&se=2121-12-26T09:07:04Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "ce2d063f-1738-4745-b504-fddd524130b8"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ru-RU, DmitryNeural)",
        "shortName": "ru-RU-DmitryNeural",
        "locale": "ru-RU",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Dmitry",
            "LocalName": "Дмитрий",
            "ShortName": "ru-RU-DmitryNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "372",
            "LocaleDescription": "Russian",
            "PreviewSentence": "Возможность создавать приложения и сервисы, которые естественным образом общаются с пользователями, улучшая доступность и удобство использования.",
            "DisplayVoiceName": "DmitryNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ru-RU",
            "localeZH": "俄语(俄罗斯)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/7a7b59dc-b4b9-426e-a6dd-055fd8c1786f.wav?sv=2019-07-07&sr=b&sig=prSZXdIh59wguEXk18cC5gOTnhNPP4mQO7rHNzdOWkE%3D&st=2021-10-29T08:28:03Z&se=2121-10-05T08:33:03Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "8f00a701-8c0f-487b-af37-fe478a30fe64"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (en-AU, KenNeural)",
        "shortName": "en-AU-KenNeural",
        "locale": "en-AU",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Ken",
            "LocalName": "Ken",
            "ShortName": "en-AU-KenNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "84",
            "LocaleDescription": "English (Australia)",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "KenNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "en-AU",
            "localeZH": "英语(澳大利亚)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/e8d90507-f549-4b9b-b581-6ef66c1e61b6.wav?sv=2021-08-06&st=2022-10-21T07%3A46%3A13Z&se=2122-09-27T07%3A51%3A13Z&sr=b&sp=rl&sig=iMcV0FBFv16zKqezPP%2F2c2x%2BU%2F654BgCFkqLoYmxYxw%3D"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "d1695bf1-7246-4c1e-9597-fe675fb2dfed"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (hi-IN, MadhurNeural)",
        "shortName": "hi-IN-MadhurNeural",
        "locale": "hi-IN",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Madhur",
            "LocalName": "मधुर",
            "ShortName": "hi-IN-MadhurNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "263",
            "LocaleDescription": "Hindi (India)",
            "PreviewSentence": "ऐसे ऐप और सेवाओं का निर्माण करें जो उपयोगकर्ताओं से आम बोलचाल की भाषा में बात करे, जिससे सुगमता और उपयोगिता बढ़े।",
            "DisplayVoiceName": "MadhurNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "hi-IN",
            "localeZH": "印地语(印度)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/fa8ea1aa-421b-4d1b-a4b9-274880e90057.wav?sv=2019-07-07&sr=b&sig=jD8n1wI2DOHZJy0wpWNwH4hR0%2Fhsz%2BkQYcCVQg5pVbw%3D&st=2021-10-29T08:27:09Z&se=2121-10-05T08:32:09Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "158031c3-095c-4d7e-b877-fe7490ba318a"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (ar-JO, SanaNeural)",
        "shortName": "ar-JO-SanaNeural",
        "locale": "ar-JO",
        "properties": {
            "Gender": "Female",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Sana",
            "LocalName": "سناء",
            "ShortName": "ar-JO-SanaNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "15",
            "LocaleDescription": "ar-JO",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "SanaNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "ar-JO",
            "localeZH": "阿拉伯语(约旦)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/0795df4a-9f76-460c-926a-a0a2b7153bfc.wav?sv=2019-07-07&sr=b&sig=9kXSJxY4mZQ7FWvmyedXJji%2B55WoXTPmz9IIdYdvZcI%3D&st=2021-10-29T08:30:05Z&se=2121-10-05T08:35:05Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "f79165a9-bc79-48fc-9c85-fe9ea43b1ec1"
    },
    {
        "name": "Microsoft Server Speech Text to Speech Voice (es-PE, AlexNeural)",
        "shortName": "es-PE-AlexNeural",
        "locale": "es-PE",
        "properties": {
            "Gender": "Male",
            "VoiceRoleNames": "",
            "VoiceRoleNameDefinitions": "{}",
            "VoiceStyleNames": "",
            "VoiceStyleNameDefinitions": "{}",
            "DisplayName": "Alex",
            "LocalName": "Alex",
            "ShortName": "es-PE-AlexNeural",
            "SampleRateHertz": "48000",
            "FrontendVoiceType": "Neural",
            "SecondaryLocales": "",
            "OrderInVoiceListApi": "209",
            "LocaleDescription": "es-PE",
            "PreviewSentence": "Welcome to the Microsoft Voice Tuning. ",
            "DisplayVoiceName": "AlexNeural",
            "VoiceModelKind": "NeuralTts",
            "ReleaseScope": "PublicGA",
            "locale": "es-PE",
            "localeZH": "西班牙语(秘鲁)"
        },
        "categories": [],
        "masterpieces": [],
        "samples": {
            "languageSamples": [],
            "roleSamples": [],
            "styleSamples": [
                {
                    "styleName": "general",
                    "audioFileEndpointWithSas": "https://cvoiceprodsea.blob.core.windows.net/bestor-acc02701-cb45-42dc-9d32-2843911017ca/VcgTaskFileManagement/9604d24f-337b-4f1f-8005-7c6d46b3a238.wav?sv=2019-07-07&sr=b&sig=0vA0KDgitMwhk8y13YimfJDVl%2F3lQIOK654KGBiO9F4%3D&st=2021-10-29T08:30:50Z&se=2121-10-05T08:35:50Z&sp=rl"
                }
            ]
        },
        "voiceType": "StandardVoice",
        "id": "565cd495-ea37-420e-99e3-fed6df8836bb"
    }
];
