/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.outputs;

import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.PluginConfigSpec;
import co.elastic.logstash.api.v0.Codec;
import co.elastic.logstash.api.v0.Output;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.logstash.Event;
import org.logstash.plugins.discovery.PluginRegistry;

@LogstashPlugin(name="java-stdout")
public class Stdout
implements Output {
    public static final PluginConfigSpec<String> CODEC_CONFIG = Configuration.stringSetting("codec", "java-line");
    private Codec codec;
    private OutputStream outputStream;
    private final CountDownLatch done = new CountDownLatch(1);

    public Stdout(Configuration configuration, Context context) {
        this(configuration, context, System.out);
    }

    Stdout(Configuration configuration, Context context, OutputStream targetStream) {
        this.outputStream = targetStream;
        String codecName = configuration.get(CODEC_CONFIG);
        this.codec = PluginRegistry.getCodec(codecName, configuration, context);
        if (this.codec == null) {
            throw new IllegalStateException(String.format("Unable to obtain codec '%a'", codecName));
        }
    }

    @Override
    public void output(Collection<Event> events) {
        for (Event e : events) {
            this.codec.encode(e, this.outputStream);
        }
    }

    @Override
    public void stop() {
        this.done.countDown();
    }

    @Override
    public void awaitStop() throws InterruptedException {
        this.done.await();
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return Collections.singletonList(CODEC_CONFIG);
    }
}

