/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import co.elastic.logstash.api.v0.Input;
import java.util.ArrayList;
import java.util.Collection;
import org.logstash.execution.JavaBasePipelineExt;

public class InputsController {
    private final Collection<Input> inputs;
    private ArrayList<Thread> threads = new ArrayList();

    public InputsController(Collection<Input> inputs) {
        this.inputs = inputs;
    }

    public void startInputs(JavaBasePipelineExt provider) {
        int inputCounter = 0;
        for (Input input : this.inputs) {
            String pluginName = input.getClass().getName();
            Thread t = new Thread(() -> input.start(provider.getQueueWriter(pluginName)));
            t.setName("input_" + inputCounter++ + "_" + pluginName);
            this.threads.add(t);
            t.start();
        }
    }

    public void stopInputs() {
        for (Input input : this.inputs) {
            input.stop();
        }
    }

    public void awaitStop() {
        for (Input input : this.inputs) {
            try {
                input.awaitStop();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

