/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import co.elastic.logstash.api.v0.Filter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.Event;
import org.logstash.RubyUtil;
import org.logstash.config.ir.compiler.AbstractFilterDelegatorExt;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;

@JRubyClass(name={"JavaFilterDelegator"})
public class JavaFilterDelegatorExt
extends AbstractFilterDelegatorExt {
    private static final RubySymbol CONCURRENCY = RubyUtil.RUBY.newSymbol("java");
    private RubyString configName;
    private Filter filter;

    public JavaFilterDelegatorExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public static JavaFilterDelegatorExt create(String configName, String id, AbstractNamespacedMetricExt metric, Filter filter) {
        JavaFilterDelegatorExt instance = new JavaFilterDelegatorExt(RubyUtil.RUBY, RubyUtil.JAVA_FILTER_DELEGATOR_CLASS);
        instance.configName = RubyUtil.RUBY.newString(configName);
        instance.initMetrics(id, metric);
        instance.filter = filter;
        return instance;
    }

    @Override
    protected RubyArray doMultiFilter(RubyArray batch) {
        List<Event> inputEvents = batch.stream().map(x -> ((JrubyEventExtLibrary.RubyEvent)((Object)((Object)x))).getEvent()).collect(Collectors.toList());
        Collection<Event> outputEvents = this.filter.filter(inputEvents);
        RubyArray newBatch = RubyArray.newArray((Ruby)RubyUtil.RUBY, (int)outputEvents.size());
        for (Event outputEvent : outputEvents) {
            newBatch.add((Object)JrubyEventExtLibrary.RubyEvent.newRubyEvent(RubyUtil.RUBY, outputEvent));
        }
        return newBatch;
    }

    @Override
    protected void doRegister(ThreadContext context) {
    }

    @Override
    protected IRubyObject doFlush(ThreadContext context, RubyHash options) {
        return context.nil;
    }

    @Override
    protected IRubyObject closeImpl(ThreadContext context) {
        return context.nil;
    }

    @Override
    protected IRubyObject doCloseImpl(ThreadContext context) {
        return context.nil;
    }

    @Override
    protected IRubyObject doStopImpl(ThreadContext context) {
        return context.nil;
    }

    @Override
    protected IRubyObject reloadable(ThreadContext context) {
        return context.tru;
    }

    @Override
    protected IRubyObject getConcurrency(ThreadContext context) {
        return CONCURRENCY;
    }

    @Override
    protected IRubyObject getConfigName(ThreadContext context) {
        return this.configName;
    }

    @Override
    protected boolean getHasFlush() {
        return false;
    }

    @Override
    protected boolean getPeriodicFlush() {
        return false;
    }
}

