/*
 * Decompiled with CFR 0.152.
 */
package org.logstashplugins;

import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Input;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.PluginConfigSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

@LogstashPlugin(name="java_input_example")
public class JavaInputExample
implements Input {
    public static final PluginConfigSpec<Long> EVENT_COUNT_CONFIG = PluginConfigSpec.numSetting((String)"count", (long)3L);
    public static final PluginConfigSpec<String> PREFIX_CONFIG = PluginConfigSpec.stringSetting((String)"prefix", (String)"message");
    private String id;
    private long count;
    private String prefix;
    private final CountDownLatch done = new CountDownLatch(1);
    private volatile boolean stopped;

    public JavaInputExample(String id, Configuration config, Context context) {
        this.id = id;
        this.count = (Long)config.get(EVENT_COUNT_CONFIG);
        this.prefix = (String)config.get(PREFIX_CONFIG);
    }

    public void start(Consumer<Map<String, Object>> consumer) {
        int eventCount = 0;
        try {
            while (!this.stopped && (long)eventCount < this.count) {
                consumer.accept(Collections.singletonMap("message", this.prefix + " " + StringUtils.center((String)(++eventCount + " of " + this.count), (int)20)));
            }
        }
        finally {
            this.stopped = true;
            this.done.countDown();
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public void awaitStop() throws InterruptedException {
        this.done.await();
    }

    public Collection<PluginConfigSpec<?>> configSchema() {
        return Arrays.asList(EVENT_COUNT_CONFIG, PREFIX_CONFIG);
    }

    public String getId() {
        return this.id;
    }
}

