# Contributing to LayoutKit

Thanks for helping make LayoutKit better! Here are some guidelines to follow when contributing.

## Reporting security issues
 
Please report security issues to [security@linkedin.com](mailto:security@linkedin.com) with a subject line of this format:

`GitHub linkedin/LayoutKit - [summary of issue]`

## Bugs

Please [create an issue](https://github.com/linkedin/LayoutKit/issues/new) and include enough information to reproduce the issue you are seeing.
A snippet of code that works in a Swift playground is ideal!

## Feature requests

Please [create an issue](https://github.com/linkedin/LayoutKit/issues/new) to describe the feature and why you think it would be useful.

## Pull requests

Pull requests should:
- Build and pass all tests.
- Have tests for all new code.
- Follow the [Swift API design guidelines](https://swift.org/documentation/api-design-guidelines/).
