# New Standard Library - July 13, 2023 - Daniel Teberian
As time goes on, the Rust core library is improved and gets closer to where the standard library is. Unfortunately, the standard library requires many features which bare-metal targets do not have, so such features must be omitted in the core library. Fortunately, the kernel supports many of the things that are required by the standard library, but not covered by the core library. The idea I have is to create as close to a "drop-in" replacement for the Rust standard library, using the features that have been implemented into the kernel. For example, we can begin working on a replacement for the standard library's "process" and "task" modules, since the kernel already supports basic multitasking and process-management. If we can create a way to use code that is designed with the standard library, we can significantly improve the speed at which this kernel is developed.

Perhaps we could set up the required features for Rust's standard library, submit a PR to the Rust language repository, and request to have our kernel added as a target triplet. :)
