## Технические детали


### Генератор данных

Воспроизводит работу бэкенд-баз данных магазинов продажи экзотических фруктов с упрощённой моделью данных.

Просмотреть и изменить текущие значения настроек можно здесь: `./deploy/env/shop-*.env` и `./docker/generator/config.json`. Не забудь пересобрать генераторы, находясь в `./deploy`: `docker compose up -d --build shop-1 shop-2`.

<details>
<summary>Функционал генератора</summary>
<br>

* Через пакет Faker генерирует строки для таблиц в Postgres базе
* Можно развернуть несколько инстансов источников (имитация филиалов)
* Воспроизводимость генерации и обновления данных через seed: `GENERATOR_SEED`
* Удаление данных старше момента времени Х через `DELETE_OLDER_THAN_SEC`
* Обновление случайного количества столбцов в строках с управляемой глубиной в прошлом: `update_rows_per_tick, UPDATE_NOT_OLDER_THAN_SEC`
* Автоматическая остановка через заданное время: `STOP_GENERATOR_AFTER_SEC`
* Управляемая частота вставки и изменения данных (через время между тиками): `TICK_INTERVAL_SEC`
* Подробное логирование уровня DEBUG и удобное уровня INFO в контейнере: `docker logs shop-1 -f` и в `./generator_app_data/logs`
</details>


### Подключение к базам
Параметры находятся в `./deploy/env/`. 
В Airflow рекомендуется использовать Admin - Connections для управления подключениями.

Схему данных на источниках предлагаю изучить напрямую из dbeaver после запуска генераторов и настройки подключений, документация к проекту есть не всегда.


### Развертывание локальной инфраструктуры
1. Сделай форк репозитория и склонируй на компьютер: `git clone https://github.com/%Username%/rzv_de_series_s01e01.git` .
2. Установи Docker Desktop (проверено на 4.26.1 (131620)). Если ещё нет любимой IDE, поставь VS Code с расширением для Python.
3. Открой репозиторй в VS Code, перейди в консоль `Ctrl+` ` и перейди в директорию `deploy` в выбранном грейде `cd ./%Grade%/deploy`
4. Подними сервисы `docker compose up -d --build`. В первый раз загрузка будет дольше, т.к. нужно скачать образы. Airflow загружается около минуты. Если ранее уже деплоились другие грейды, и в текущем что-то не работает, запусти через `docker compose up -d --build shop-1 shop-2`.
5. Перейди на страницы сервисов с UI и залогинься
* Airflow: `localhost:8080` ; airflow/airflow
* dbeaver: `localhost:80/#/admin` ; cbadmin/Password1 ; затем выйди на главный экран через логотип в левом верхнем углу.
6. DAG'и копируй или сразу редактируй в `./%Grade%/airflow_data/dags`, изменения подтянутся через 5 секунд, F5 не обязателен. Недостающие пакеты и модули ставь через добавление в `./%Grade%/docker/airflow/requirements.txt` с последующей пересборкой контейнера airflow (на текущий момент слетают подключения, см. раздел ниже) `docker compose up -d --build af-standalone`. 
7. Настрой подключения в `dbeaver` через "+" - PostgreSQL. Не забудь нажать "save credentials".
Если грейд выше G0_Trainee, настрой подключения в `Airflow` через Admin - Connections, в Admin - Variables добавь переменные, если нужно. Если соединения будут удалены после перезапуска пк/mac/docker, раскомментируй строки в `af-init` сервисе внутри `deploy/docker-compose.yml` и запусти `docker compose up -d` снова. В первый раз стоит научиться их добавлять через интерфейс.
8. Проверь, что генераторы работают через просмотр логов в `./%Grade%/generator_app_data/logs` или `docker logs shop-1 -f`, и запускай DAG'и через unpause. Данные польются в `pg-dwh` и будут видны через `dbeaver`.