# Сценарий

Настроить инкрементальную загрузку всех таблиц из всех источников в исторические таблицы DWH с SCD2. Учесть, что данные могут обновляться с некоторой глубиной в прошлом.

Настроить логирование.

<details>
<summary>Подсказки</summary>
<br>

* Вначале можно в staging грузить очередной срез данных, появившихся позднее, чем последняя загрузка max_dttm на источнике (с учётом окна возможного обновления данных). Потом -- подготавливать датасеты и значения dttm создания строк > max_dttm вставлять сразу, а для остальных, потенциально обновлённых строк, сравнивать хэши по конкатенированным неключевым значениям.
* Обеспечивай идемпотентность, где возможно. Очищай промежуточные таблицы перед вставкой. При этом следи, что другой даг прямо сейчас с ними не работает.
* Фильтруй данные, как можно сильнее снижая количество строк в датасете для очередной проверки и загрузки.
* Добавь технические поля для отслеживания источника, времени создания и/или обновления данных. Пользуйся ими для обеспечения SCD2.
* Для обновления eff_to_dttm изменённых строк удобно использовать UPDATE TABLE SET ... FROM.
* Используй `generator_app_data/logs` или `docker logs shop-1 -f` для отслеживания изменённых строк и проверяй результат через поиск строк, где уникальность по PK не соблюдается (в него добавляется третье поле -- `eff_from_dttm`).
* Используй для самопроверки `../G1_Intern/airflow_data/dags/scripts/self-test.sql`.
</details>
<br>

Definition of done:
* 3 таблицы из двух источников грузятся в DWH.
* Решение должно легко расширяться под новые таблицы и источники.
* История в строках хранится с точностью до секунды (SCD2 через timestamp).
* Захватываются последние изменения строки в пределах одного PK перед моментом очередного забора пакета данных, промежуточные пропускаются, -- это общая проблема batch загрузок, допускается..