# Сценарий

По аналогии с `dds.orders`, добавь загрузку таблиц `dds.customers` и `dds.products`. Затем добавь загрузку из источника pg-shop-2 по аналогии с shop_1_conn.
Также нужно написать Airflow DAG, который будет удалять промежуточные файлы из директории в airflow.

Для загрузки таблиц тебе нужно развернуть окружение, настроить подключения в Airflow - Admin - Connections и внести правку в конфиг `airflow_data/dags/scripts/airflow_variable.json`, который затем нужно импортировать в Admin - Variables.

<details>
<summary>Подсказки</summary>

* City name поищи здесь: `deploy/env`
* Технические поля и всё, кроме columns, заполни аналогично orders.
* Структуру колонок (схему данных двух недостающих таблиц) посмотри через dbeaver, подключившись к источникам.
* Определять "долгоживущие" файлы можно через bash-команду `find` с параметрами.
* Изучи типы данных в JSON и научись различать массивы и объекты.
* Изучи, где в коде используются подключения и таблицы, чтобы правильно заполнить конфигурационный файл. Пользуйся Ctrl+Shift+F для поиска по всему репозиторию (если используешь VS Code).
* Закомментируй участок кода, сохрани и запусти даг, чтобы понять, что сломается и за что он отвечает.
</details>
<br>

Definition of Done:
* Среди таблиц в dwh появились dds.products и dds.customers.
* Во все три таблицы данные заливаются по обоим источникам.
* Файлы в директории `cd /tmp/airflow_staging` в контейнере `docker exec -it af-standalone bash` удаляются хотя бы раз в сутки при помощи нового дага.
* Используй для самопроверки `airflow_data/dags/scripts/self-test.sql`.