﻿(function ($) {
    $.fn.Upload = function (options) {
        var settings = $.extend({
            id: '',
            showLabel: true,
            labelText: 'Upload',
            btnText: 'Choose',
            defaultUrl: '',
            accept: 'image/*',
            extensionPattern: ''
        }, options);

        return this.each(function () {
            if (!settings.id) {
                return;
            }
            var inputTextId = settings.id + 'Text';
            var inputFileId = settings.id + 'File';
            var previewId = settings.id + 'View';
            if (settings.showLabel) {
                var label = document.createElement('label');
                label.className = 'form-label';
                label.textContent = settings.labelText;
                $(this).append(label);
            }
            // create div
            var div = document.createElement('div');
            div.className = 'input-group';
            // create hidden input
            var inputHidden = document.createElement('input');
            inputHidden.type = 'hidden';
            inputHidden.id = settings.id;
            inputHidden.name = settings.id;
            inputHidden.value = settings.defaultUrl;
            div.appendChild(inputHidden);
            // create input file
            var inputFile = document.createElement('input');
            inputFile.style.display = 'none';
            inputFile.type = 'file';
            inputFile.accept = settings.accept;
            inputFile.name = inputFileId;
            inputFile.id = inputFileId;
            inputFile.onchange = (e) => {
                if (settings.onChange) {
                    settings.onChange(e);
                }
                var file = document.getElementById(inputFileId).files[0];
                if (settings.extensionPattern) {
                    if (!settings.extensionPattern.test(file.name)) {
                        return;
                    }
                }
                $('#' + inputTextId).val(e.target.value);
                if (file.type.startsWith('image')) {
                    if (window.URL && typeof window.URL.createObjectURL === 'function') {
                        $('#' + previewId).show();
                        $('#' + previewId + ' img').attr('src', window.URL.createObjectURL(document.getElementById(inputFileId).files.item(0)));
                    } else {
                        // 浏览器不支持URL.createObjectURL()
                        // 使用其他方式处理
                    }
                }
            };
            div.append(inputFile);
            // create intput text
            var inputText = document.createElement('input');
            inputText.type = "text";
            inputText.className = 'form-control';
            inputText.id = inputTextId;
            div.append(inputText);
            // create button
            var button = document.createElement('a');
            button.className = 'input-group-addon btn btn-primary';
            button.textContent = settings.btnText;
            button.onclick = () => { $('#' + inputFileId).click(); };
            div.append(button);
            // create preview
            var preview = document.createElement('div');
            preview.className = 'mt-3';
            preview.id = previewId;
            preview.style.maxWidth = '100%';
            preview.style.position = 'relative';
            if (!settings.defaultUrl) {
                preview.style.display = 'none';
            }
            // create img
            var img = document.createElement('img');
            img.src = settings.defaultUrl;
            if (settings.maxWidth) {
                img.style.maxWidth = settings.maxWidth;
            }
            if (settings.maxHeight) {
                img.style.maxHeight = settings.maxHeight;
            }
            // create delete button
            var deleteButton = document.createElement('span');
            deleteButton.className = 'badge bg-danger';
            deleteButton.style.position = 'absolute';
            deleteButton.style.right = '0';
            deleteButton.style.bottom = '0';
            deleteButton.style.cursor = 'pointer';
            deleteButton.onclick = () => {
                $('#' + previewId).hide();
                $('#' + previewId + ' img').removeAttr('src');
                $('#' + inputFileId).val('');
                $('#' + inputTextId).val('');
                if (settings.onDelete) {
                    settings.onDelete();
                }
            };
            var deleteIcon = document.createElement('i');
            deleteIcon.className = 'bi bi-trash';
            deleteButton.append(deleteIcon);
            preview.append(img);
            preview.append(deleteButton);
            $(this).append(div);
            $(this).append(preview);
        });
    }
}(jQuery));