﻿function postComment(targetCommentId) {
    $('#submit-' + targetCommentId).attr('href', 'javascript:;');
    postJson('/Articles/Comments', {
        ArticleId: $('#articleId').val(),
        CContent: $('#comment-content-' + targetCommentId).val(),
        VerificationCode: $('#comment-content-' + targetCommentId).parent().find('.verificationCode').val(),
        TargetCommentId: targetCommentId
    },
        function (response) {
            if (response.Success) {
                $('.comment-content').val('');
                $('#comment-content-' + targetCommentId).val('');
                toastSuccess('提交成功');
                var commentResult = getCommentResult(targetCommentId, response.Data);
                if (targetCommentId == 0) {
                    if ($('.comment-list').length > 0) {
                        $('.comment-list ul:eq(0)').prepend('<li class="comment-list-item-parent">' + commentResult + '<li>');
                    } else {
                        $('.comments-container').append('<div class="comment-list"><ul class=\"comment-list-parent\"><li class="comment-list-item-parent">' + commentResult + '</li></ul></div>');
                    }
                } else {
                    if ($('#comment-list-item-' + targetCommentId).parent().find('ul:eq(0)').length > 0) {
                        $('#comment-list-item-' + targetCommentId).parent().find('ul:eq(0)').prepend(commentResult);
                    } else {
                        $('#comment-list-item-' + targetCommentId).parent().append('<ul>' + commentResult + '</ul>');
                    }
                }
            } else {
                toastDanger(response.Message);
            }
            resetImage();
            $('#submit-' + targetCommentId).attr('href', 'javascript:postComment(' + targetCommentId + ');');
        },
        function () {
            toastDanger('未知错误');
            resetImage();
            $('#submit-' + targetCommentId).attr('href', 'javascript:postComment(' + targetCommentId + ');');
        });
}
function getCommentResult(targetCommentId, data) {
    if (targetCommentId == 0) {
        return '<div class="comment-list-item" id="comment-list-item-' + data.Id + '"><p><span>' + data.Nickname + '</span > <time>' + data.CreateTime + '</time> ' + (data.CanReply ? '<a href ="javascript:reply(' + data.Id + ');"><span class="bi bi-arrow-left-square"></span></a>' : '') + '</p><p>' + data.CContent + '</p></div>';
    } else {
        return '<li><div id="comment-list-item-' + data.Id + '"><p><span>' + data.Nickname + '</span> <time>' + data.CreateTime + '</time> ' + (data.CanReply ? '<a href="javascript:reply(' + data.Id + ');"><span class="bi bi-arrow-left-square"></span></a>' : '') + '</p><p>' + data.CContent + '</p></div></li>';
    }
}
function reply(targetCommentId) {
    closeReply();
    $('#comment-content-0').hide();
    $('.submit-container').hide();
    var html = '<div class="comment-target"><textarea id="comment-content-' + targetCommentId + '"></textarea><img class="verificationCodeImage" src="/Utility/VerificationCodeImage?rnd=' + Math.random() + '" /> <input type="text" id="verificationCode" class="verificationCode" /> <a href="javascript:postComment(' + targetCommentId + ');" class="submit-target">提交</a> <a href="javascript:closeReply();" class="submit-target-cancel">取消</a></div>';
    $('#comment-list-item-' + targetCommentId).append(html);
}

function closeReply() {
    $('.comment-target').remove();
    $('#comment-content-0').show();
    $('.submit-container').show();
    resetImage();
}
function resetImage() {
    if ($('.comment-target').length > 0) {
        $('.verificationCode').val('');
        $('.comment-target .verificationCodeImage').attr('src', '/Utility/VerificationCodeImage?rnd=' + Math.random());
    } else {
        $('.verificationCode').val('');
        $('.verificationCodeImage').attr('src', '/Utility/VerificationCodeImage?rnd=' + Math.random());
    }
}