import mysql.connector
from mysql.connector import Error
import os

def run_sql_script(host, user, password, script_path):
    conn = None
    try:
        # Establishing the database connection
        conn = mysql.connector.connect(
            host=host,
            user=user,
            password=password
        )

        cursor = conn.cursor()

        # Reading the SQL script
        with open(script_path, 'r') as file:
            sql_script = file.read()

        # Executing the SQL script
        for result in cursor.execute(sql_script, multi=True):
            if result.with_rows:
                print(f"Rows produced by statement '{result.statement}':")
                print(result.fetchall())
            else:
                print(f"Number of rows affected by statement '{result.statement}': {result.rowcount}")

        conn.commit()
        print("Script executed successfully")

    except Error as e:
        print(f"Error while executing SQL script: {e}")

    finally:
        if conn and conn.is_connected():
            cursor.close()
            conn.close()
            print("MySQL connection is closed")


if __name__ == "__main__":
    # User inputs
    host_input = input("Enter the database host: ")
    username_input = input("Enter the MySQL username: ")
    password_input = input("Enter the MySQL password: ")
    script_name_input = input("Enter the name of the SQL script file to create the database schema. Include path if file is not in the same directory.: ")

    # Credentials (can be modified as needed)
    #username = "ahmed"
    #password = "abcdefgh"
    # username = "root"
    # password = "rusercaines"

    # Run the script
    run_sql_script(host_input, username_input, password_input, script_name_input)
