-- MySQL Script generated by MySQL Workbench
-- Fri Dec  1 14:11:22 2023
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema smc_alumni_test
-- -----------------------------------------------------

DROP SCHEMA IF EXISTS `smc_alumni_test_2`;

-- -----------------------------------------------------
-- Schema smc_alumni
-- -----------------------------------------------------

CREATE SCHEMA IF NOT EXISTS `smc_alumni_test_2` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci ;
USE `smc_alumni_test_2`;

-- -----------------------------------------------------
-- Table `alumni`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `alumni`;

CREATE TABLE IF NOT EXISTS `alumni` (
  `alumniID` INT NOT NULL AUTO_INCREMENT,
  `firstname` VARCHAR(50) NULL DEFAULT NULL,
  `lastname` VARCHAR(50) NULL DEFAULT NULL,
  `gender` ENUM('Male', 'Female') NULL DEFAULT NULL,
  `insert_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `last_update_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fullname` VARCHAR(125) NULL DEFAULT NULL,
  PRIMARY KEY (`alumniID`))
ENGINE = InnoDB
#AUTO_INCREMENT = 1229
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE UNIQUE INDEX `firstname` ON `alumni` (`firstname` ASC, `lastname` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `Family`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `family` ;

CREATE TABLE IF NOT EXISTS `family` (
  `familyID` INT NOT NULL AUTO_INCREMENT,
  `alumniID` INT NULL DEFAULT NULL,
  `spouse` VARCHAR(100) NULL DEFAULT NULL,
  `num_of_children` INT NULL DEFAULT NULL,
  `insert_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `last_update_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`familyID`),
  CONSTRAINT `family_ibfk_1`
    FOREIGN KEY (`alumniID`)
    REFERENCES `alumni` (`alumniID`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE UNIQUE INDEX `alumniID` ON `family` (`alumniID` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `data_sources`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `data_sources` ;

CREATE TABLE IF NOT EXISTS `data_sources` (
  `data_source_id` INT NOT NULL AUTO_INCREMENT,
  `data_source_code` VARCHAR(10) NULL DEFAULT NULL,
  `data_source_name` VARCHAR(40) NULL DEFAULT NULL,
  `insert_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `last_update_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`data_source_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE UNIQUE INDEX `data_source_code` ON `data_sources` (`data_source_code` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `alumni_data_sources`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `alumni_data_sources` ;

CREATE TABLE IF NOT EXISTS `alumni_data_sources` (
  `alumni_source_id` INT NOT NULL AUTO_INCREMENT,
  `alumniID` INT NULL DEFAULT NULL,
  `data_source_code` VARCHAR(10) NULL DEFAULT NULL,
  `source_link` VARCHAR(100) NULL DEFAULT NULL,
  `insert_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `last_update_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`alumni_source_id`),
  CONSTRAINT `alumni_data_sources_ibfk_1`
    FOREIGN KEY (`alumniID`)
    REFERENCES `alumni` (`alumniID`),
  CONSTRAINT `alumni_data_sources_ibfk_2`
    FOREIGN KEY (`data_source_code`)
    REFERENCES `data_sources` (`data_source_code`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE INDEX `alumniID` ON `alumni_data_sources` (`alumniID` ASC) VISIBLE;

CREATE INDEX `data_source_code` ON `alumni_data_sources` (`data_source_code` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `contact_information`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `contact_information` ;

CREATE TABLE IF NOT EXISTS `contact_information` (
  `contactID` INT NOT NULL AUTO_INCREMENT,
  `alumniID` INT NULL DEFAULT NULL,
  `email_primary` VARCHAR(100) NULL DEFAULT NULL,
  `email_secondary` VARCHAR(100) NULL DEFAULT NULL,
  `phone` VARCHAR(25) NULL DEFAULT NULL,
  `mobile_phone` VARCHAR(25) NULL DEFAULT NULL,
  `company_phone` VARCHAR(25) NULL DEFAULT NULL,
  `insert_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `last_update_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`contactID`),
  CONSTRAINT `contact_information_ibfk_1`
    FOREIGN KEY (`alumniID`)
    REFERENCES `alumni` (`alumniID`))
ENGINE = InnoDB
#AUTO_INCREMENT = 1229
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE UNIQUE INDEX `alumniID` ON `contact_information` (`alumniID` ASC) VISIBLE;

CREATE INDEX `IDX_contact_information_email_address_primary` ON `contact_information` (`email_primary` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `education`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `education` ;

CREATE TABLE IF NOT EXISTS `education` (
  `educationID` INT NOT NULL AUTO_INCREMENT,
  `alumniID` INT NULL DEFAULT NULL,
  `graduationyear` INT NULL DEFAULT NULL,
  `degree` VARCHAR(100) NULL DEFAULT NULL,
  `field_of_study` VARCHAR(200) NULL DEFAULT NULL,
  `sm_school` VARCHAR(150) NULL DEFAULT NULL,
  `school` VARCHAR(150) NULL DEFAULT NULL,
  `start_year` VARCHAR(25) NULL DEFAULT NULL,
  `end_year` VARCHAR(25) NULL DEFAULT NULL,
  `years_attended` VARCHAR(40) NULL DEFAULT NULL,
  `insert_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `last_update_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`educationID`),
  CONSTRAINT `education_ibfk_1`
    FOREIGN KEY (`alumniID`)
    REFERENCES `alumni` (`alumniID`))
ENGINE = InnoDB
#AUTO_INCREMENT = 1947
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE INDEX `alumniID` ON `education` (`alumniID` ASC) VISIBLE;

CREATE INDEX `IDX_graduation_field_of_study` ON `education` (`field_of_study` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `employment`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `employment` ;

CREATE TABLE IF NOT EXISTS `employment` (
  `employmentID` INT NOT NULL AUTO_INCREMENT,
  `alumniID` INT NULL DEFAULT NULL,
  `employer` VARCHAR(150) NULL DEFAULT NULL,
  `job_title` VARCHAR(100) NULL DEFAULT NULL,
  `job_city` VARCHAR(50) NULL DEFAULT NULL,
  `job_state` VARCHAR(50) NULL DEFAULT NULL,
  `job_country` VARCHAR(50) NULL DEFAULT NULL,
  `start_year` INT NULL DEFAULT NULL,
  `end_year` INT NULL DEFAULT NULL,
  `insert_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `last_update_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`employmentID`),
  CONSTRAINT `employment_ibfk_1`
    FOREIGN KEY (`alumniID`)
    REFERENCES `alumni` (`alumniID`))
ENGINE = InnoDB
#AUTO_INCREMENT = 1229
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE INDEX `alumniID` ON `employment` (`alumniID` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `error_log`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `error_log` ;

CREATE TABLE IF NOT EXISTS `error_log` (
  `error_id` INT NOT NULL AUTO_INCREMENT,
  `error_timestamp` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `error_message` VARCHAR(255) NULL DEFAULT NULL,
  `alumni_id` INT NULL DEFAULT NULL,
  `dept` VARCHAR(255) NULL DEFAULT NULL,
  `url` VARCHAR(255) NULL DEFAULT NULL,
  `firstname` VARCHAR(255) NULL DEFAULT NULL,
  `lastname` VARCHAR(255) NULL DEFAULT NULL,
  `fullname` VARCHAR(255) NULL DEFAULT NULL,
  `email_first` VARCHAR(255) NULL DEFAULT NULL,
  `email_second` VARCHAR(255) NULL DEFAULT NULL,
  `address_1` VARCHAR(255) NULL DEFAULT NULL,
  `address_2` VARCHAR(255) NULL DEFAULT NULL,
  `phone` VARCHAR(255) NULL DEFAULT NULL,
  `current_title` VARCHAR(255) NULL DEFAULT NULL,
  `current_company` VARCHAR(255) NULL DEFAULT NULL,
  `company_phone` VARCHAR(255) NULL DEFAULT NULL,
  `city` VARCHAR(255) NULL DEFAULT NULL,
  `state` VARCHAR(255) NULL DEFAULT NULL,
  `zip_code` VARCHAR(255) NULL DEFAULT NULL,
  `country` VARCHAR(255) NULL DEFAULT NULL,
  `sm_school` VARCHAR(50) NULL DEFAULT NULL,
  `degree1` VARCHAR(255) NULL DEFAULT NULL,
  `field_of_study_1` VARCHAR(255) NULL DEFAULT NULL,
  `school_1` VARCHAR(255) NULL DEFAULT NULL,
  `start_year_1` VARCHAR(255) NULL DEFAULT NULL,
  `end_year_1` VARCHAR(255) NULL DEFAULT NULL,
  `years_school_1` VARCHAR(255) NULL DEFAULT NULL,
  `degree2` VARCHAR(255) NULL DEFAULT NULL,
  `field_of_study_2` VARCHAR(255) NULL DEFAULT NULL,
  `school_2` VARCHAR(255) NULL DEFAULT NULL,
  `start_year_2` VARCHAR(255) NULL DEFAULT NULL,
  `end_year_2` VARCHAR(255) NULL DEFAULT NULL,
  `years_school_2` VARCHAR(255) NULL DEFAULT NULL,
  `degree3` VARCHAR(255) NULL DEFAULT NULL,
  `field_of_study_3` VARCHAR(255) NULL DEFAULT NULL,
  `school_3` VARCHAR(255) NULL DEFAULT NULL,
  `start_year_3` VARCHAR(255) NULL DEFAULT NULL,
  `end_year_3` VARCHAR(255) NULL DEFAULT NULL,
  `years_school_3` VARCHAR(255) NULL DEFAULT NULL,
  `field_of_study_4` VARCHAR(255) NULL DEFAULT NULL,
  `start_year_4` VARCHAR(255) NULL DEFAULT NULL,
  `end_year_4` VARCHAR(255) NULL DEFAULT NULL,
  `years_school_4` VARCHAR(255) NULL DEFAULT NULL,
  `experience` TEXT NULL DEFAULT NULL,
  `employers` TEXT NULL DEFAULT NULL,
  `mc_status` VARCHAR(75) NULL DEFAULT NULL,
  `mc_join_date` TIMESTAMP NULL DEFAULT NULL,
  `extra_info` TEXT NULL DEFAULT NULL,
  `source` VARCHAR(255) NULL DEFAULT NULL,
  PRIMARY KEY (`error_id`))
ENGINE = InnoDB
#AUTO_INCREMENT = 12
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE INDEX `alumni_id` ON `error_log` (`source` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `mailing_information`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `mailing_information` ;

CREATE TABLE IF NOT EXISTS `mailing_information` (
  `mailingID` INT NOT NULL AUTO_INCREMENT,
  `alumniID` INT NULL DEFAULT NULL,
  `address1` VARCHAR(100) NULL DEFAULT NULL,
  `address2` VARCHAR(100) NULL DEFAULT NULL,
  `city` VARCHAR(50) NULL DEFAULT NULL,
  `state` VARCHAR(50) NULL DEFAULT NULL,
  `zip_code` VARCHAR(20) NULL DEFAULT NULL,
  `country` VARCHAR(25) NULL DEFAULT NULL,
  `insert_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `last_update_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `region` VARCHAR(70) NULL DEFAULT NULL,
  PRIMARY KEY (`mailingID`),
  CONSTRAINT `mailing_information_ibfk_1`
    FOREIGN KEY (`alumniID`)
    REFERENCES `alumni` (`alumniID`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE UNIQUE INDEX `alumniID` ON `mailing_information` (`alumniID` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `stg_in_linkedin`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `stg_in_linkedin` ;

CREATE TABLE IF NOT EXISTS `stg_in_linkedin` (
  `alumniID` INT NULL DEFAULT NULL,
  `dept` VARCHAR(50) NULL DEFAULT NULL,
  `firstname` VARCHAR(75) NULL DEFAULT NULL,
  `lastname` VARCHAR(75) NULL DEFAULT NULL,
  `fullname` VARCHAR(150) NULL DEFAULT NULL,
  `email_first` VARCHAR(150) NULL DEFAULT NULL,
  `email_second` VARCHAR(150) NULL DEFAULT NULL,
  `phone` VARCHAR(25) NULL DEFAULT NULL,
  `mobile_phone` VARCHAR(25) NULL DEFAULT NULL,
  `company_phone` VARCHAR(25) NULL DEFAULT NULL,
  `current_title` VARCHAR(100) NULL DEFAULT NULL,
  `current_company` VARCHAR(150) NULL DEFAULT NULL,
  `company_domain` VARCHAR(200) NULL DEFAULT NULL,
  `city` VARCHAR(50) NULL DEFAULT NULL,
  `state` VARCHAR(50) NULL DEFAULT NULL,
  `country` VARCHAR(25) NULL DEFAULT NULL,
  `sm_school` VARCHAR(50) NULL DEFAULT NULL,
  `degree1` VARCHAR(40) NULL DEFAULT NULL,
  `field_of_study_1` VARCHAR(200) NULL DEFAULT NULL,
  `school_1` VARCHAR(125) NULL DEFAULT NULL,
  `start_year_1` VARCHAR(50) NULL DEFAULT NULL,
  `end_year_1` VARCHAR(50) NULL DEFAULT NULL,
  `years_school_1` VARCHAR(50) NULL DEFAULT NULL,
  `degree2` VARCHAR(40) NULL DEFAULT NULL,
  `field_of_study_2` VARCHAR(200) NULL DEFAULT NULL,
  `school_2` VARCHAR(125) NULL DEFAULT NULL,
  `start_year_2` VARCHAR(50) NULL DEFAULT NULL,
  `end_year_2` VARCHAR(50) NULL DEFAULT NULL,
  `years_school_2` VARCHAR(50) NULL DEFAULT NULL,
  `degree3` VARCHAR(125) NULL DEFAULT NULL,
  `field_of_study_3` VARCHAR(200) NULL DEFAULT NULL,
  `school_3` VARCHAR(125) NULL DEFAULT NULL,
  `start_year_3` VARCHAR(50) NULL DEFAULT NULL,
  `end_year_3` VARCHAR(50) NULL DEFAULT NULL,
  `years_school_3` VARCHAR(50) NULL DEFAULT NULL,
  `degree4` VARCHAR(40) NULL DEFAULT NULL,
  `field_of_study_4` VARCHAR(200) NULL DEFAULT NULL,
  `school_4` VARCHAR(125) NULL DEFAULT NULL,
  `start_year_4` VARCHAR(50) NULL DEFAULT NULL,
  `end_year_4` VARCHAR(50) NULL DEFAULT NULL,
  `years_school_4` VARCHAR(50) NULL DEFAULT NULL,
  `url` VARCHAR(150) NULL DEFAULT NULL,
  `linkedin_id` VARCHAR(50) NULL DEFAULT NULL,
  `processed_status` VARCHAR(20) NULL DEFAULT NULL,
  `experience` VARCHAR(500) NULL DEFAULT NULL,
  `employers` VARCHAR(1500) NULL DEFAULT NULL,
  `extra_info` VARCHAR(1000) NULL DEFAULT NULL,
  `insert_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `last_update_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  CONSTRAINT `stg_in_linkedin_ibfk_1`
    FOREIGN KEY (`alumniID`)
    REFERENCES `alumni` (`alumniID`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE UNIQUE INDEX `firstname` ON `stg_in_linkedin` (`firstname` ASC, `lastname` ASC) VISIBLE;

CREATE INDEX `alumniID` ON `stg_in_linkedin` (`alumniID` ASC) VISIBLE;


-- -----------------------------------------------------
-- Table `stg_in_mailchimp`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `stg_in_mailchimp` ;

CREATE TABLE IF NOT EXISTS `stg_in_mailchimp` (
  `alumniID` INT NULL DEFAULT NULL,
  `firstname` VARCHAR(100) NULL DEFAULT NULL,
  `lastname` VARCHAR(100) NULL DEFAULT NULL,
  `fullname` VARCHAR(200) NULL DEFAULT NULL,
  `email_address` VARCHAR(100) NULL DEFAULT NULL,
  `address1` VARCHAR(100) NULL DEFAULT NULL,
  `address2` VARCHAR(100) NULL DEFAULT NULL,
  `city` VARCHAR(50) NULL DEFAULT NULL,
  `state` VARCHAR(50) NULL DEFAULT NULL,
  `zip_code` VARCHAR(20) NULL DEFAULT NULL,
  `country` VARCHAR(20) NULL DEFAULT NULL,
  `phone` VARCHAR(25) NULL DEFAULT NULL,
  `mc_status` VARCHAR(25) NULL DEFAULT NULL,
  `join_date` TIMESTAMP NULL DEFAULT NULL,
  `processed_status` VARCHAR(20) NULL DEFAULT NULL,
  `insert_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `last_update_ts` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  CONSTRAINT `stg_in_mailchimp_ibfk_1`
    FOREIGN KEY (`alumniID`)
    REFERENCES `alumni` (`alumniID`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;

CREATE UNIQUE INDEX `first_name` ON `stg_in_mailchimp` (`first_name` ASC, `last_name` ASC) VISIBLE;

CREATE INDEX `alumniID` ON `stg_in_mailchimp` (`alumniID` ASC) VISIBLE;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
