import { produce } from 'immer';

const INITIAL_STATE = {
  id: null,
  signed: false,
  loading: false,
};

export function auth(state = INITIAL_STATE, action) {
  return produce(state, draft => {
    switch (action.type) {
      case '@auth/SIGN_IN_SUCCESS': {
        draft.id = action.payload.student.id;
        draft.signed = true;
        draft.loading = false;
        break;
      }
      case '@auth/SIGN_IN_REQUEST': {
        draft.loading = true;
        break;
      }
      case '@auth/SIGN_IN_FAILURE': {
        draft.loading = false;
        break;
      }
      case '@auth/SIGN_OUT': {
        draft.id = null;
        draft.signed = false;
        break;
      }
      default:
    }
  });
}
