<p align="center">
   <img src=".github/logo.png" width="150"/>
</p>

# Gympoint Mobile


[![Author](https://img.shields.io/badge/author-LauraBeatris-EE4D64?style=flat-square)](https://github.com/LauraBeatris)
[![Languages](https://img.shields.io/github/languages/count/LauraBeatris/gympoint-mobile?color=%23EE4D64&style=flat-square)](#)
[![Stars](https://img.shields.io/github/stars/LauraBeatris/gympoint-mobile?color=EE4D64&style=flat-square)](https://github.com/LauraBeatris/gympoint-mobile/stargazers)
[![Forks](https://img.shields.io/github/forks/LauraBeatris/gympoint-mobile?color=%23EE4D64&style=flat-square)](https://github.com/LauraBeatris/gympoint-mobile/network/members)
[![Contributors](https://img.shields.io/github/contributors/LauraBeatris/gympoint-mobile?color=EE4D64&style=flat-square)](https://github.com/LauraBeatris/gympoint-mobile/graphs/contributors)

> Enjoy your gym enrollment by easily doing check-ins and sending questions to your instructions

---

# :pushpin: Table of Contents

* [Features](#rocket-features)
* [Installation](#construction_worker-installation)
* [Getting Started](#runner-getting-started)
* [FAQ](#postbox-faq)
* [Found a bug? Missing a specific feature?](#bug-issues)
* [Contributing](#tada-contributing)
* [License](#closed_book-license)

<p align="center">
  <img src="https://i.ibb.co/tDBZnW4/Whats-App-Image-2020-01-01-at-15-34-08.jpg" alt="Whats-App-Image-2020-01-01-at-15-34-08" border="0"  height="300" >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
  <img src="https://i.ibb.co/n860jBs/Whats-App-Image-2020-01-01-at-15-38-09.jpg" alt="Whats-App-Image-2020-01-01-at-15-38-09" border="0" height="300">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
  <img src="https://i.ibb.co/M7R7HZk/Whats-App-Image-2020-01-01-at-15-43-19.jpg" alt="Whats-App-Image-2020-01-01-at-15-43-19" border="0" height="300">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
</p>

# :rocket: Features

* Do check-ins
* Send questions to your instructions and receive their answers

It's important to mention that this is one of the applications from the **Gympoint System**

In order to explore the others, feel free to click in the links above:
- [Gympoint Web](https://github.com/LauraBeatris/gympoint-web)
- [Gympoint API](https://github.com/LauraBeatris/gympoint-api)

# :construction_worker: Installation

**You need to install [Node.js](https://nodejs.org/en/download/), [Yarn](https://yarnpkg.com/), [Android SDK](https://medium.com/surabayadev/setting-up-react-native-android-without-android-studio-35a496e1dfa3) first and then, in order to clone the project via HTTPS, run this command:**

```git clone https://github.com/LauraBeatris/gympoint-mobile.git```

SSH URLs provide access to a Git repository via SSH, a secure protocol. If you have a SSH key registered in your Github account, clone the project using this command:

```git clone git@github.com:LauraBeatris/gympoint-mobile.git```

**Install dependencies**

```yarn install```

Create your enviroment variables based on the examples of ```.env.example```

```cp .env.example .env```

After copying the examples, make sure to fill the variables with new values.

**Setup the API**

The interface needs to interact with the server to execute mutations related to check-ins and questions.

Make sure to go to the [Gympoint Rest API](https://github.com/LauraBeatris/gympoint-api) repository and follow the instructions in order to get it running in your machine.

# :runner: Getting Started

Run the following command in order to start the application in a development environment:

It's important to mention that this application is **only available for android.**

```
  // Install the application in a android device
  react-native run-android

  // Start the application
  yarn start
```

# :postbox: Faq

**Question:** What are the tecnologies used in this project?

**Answer:** The tecnologies used in this project are [React Native](https://reactnative.dev/) + [Styled Components](https://styled-components.com/) to handle scoped CSS.

# :bug: Issues

Feel free to **file a new issue** with a respective title and description on the the [Gympoint Mobile](https://github.com/LauraBeatris/gympoint-mobile/issues) repository. If you already found a solution to your problem, **i would love to review your pull request**! Have a look at our [contribution guidelines](https://github.com/LauraBeatris/gympoint-mobile/blob/master/CONTRIBUTING.md) to find out about the coding standards.

# :tada: Contributing

Check out the [contributing](https://github.com/LauraBeatris/gympoint-mobile/blob/master/CONTRIBUTING.md) page to see the best places to file issues, start discussions and begin contributing.

# :closed_book: License

Released in 2019.
This project is under the [MIT license](https://github.com/LauraBeatris/gympoint-mobile/master/LICENSE).

Made with love by [Laura Beatris](https://github.com/LauraBeatris) 💜🚀
