# Contributing Guidelines

Thanks you so much for your interest in contributing to this project!

## About our deal

Hi! I'm Laura and i'm the creator and maintainer of this project.

If you encounter bugs, please **do** open an issue describing the bug and including steps to easily reproduce it (bonus points for a CodeSandbox that demonstrates the problem).

If you have an idea for an enhancement, go ahead and share it via an issue, but please don't expect a timely response.

This project is MIT-licensed, and this means that you can implement and use whatever enhancements you'd like.

## Commits and Code Standardization

This project follow the [Conventinal Commits](https://www.conventionalcommits.org/en/v1.0.0/) specification. [Husky](https://github.com/typicode/husky) execute scrips according to git hooks in order to test if a developer is following the [Eslint Lint Rules](https://github.com/LauraBeatris/gympoint-mobile/blob/master/.eslintrc.js) and also the commits convention.

## Bug reports

If you encounter a problem with this project, please open an issue. Be sure to include:

- Package version
- Node and React Native versions
- Brief but thorough description of the issue
- Link to a CodeSandbox (or similar) demonstrating the problem (optional, but highly recommended, especially for complex problems)
