(*
  This file is part of Delphi-OpenCV-Class project.
  https://github.com/Laex/Delphi-OpenCV-Class

  It is subject to the license terms in the LICENSE file found in the top-level directory
  of this distribution and at https://www.apache.org/licenses/LICENSE-2.0.txt

  Copyright 2021, Laentir Valetov, laex@bk.ru

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*)

{$IF not defined(OPENCV_EXTERNAL_TYPES)}
{$DEFINE OPENCV_EXTERNAL_TYPES}

type
  TEmptyRec = record
  end;

  ADE_CONSTTYPEDGRAPH_OF_CV_GIMPL_LAYOUT   = type TEmptyRec;
  ADE_CONSTTYPEDGRAPH_OF_CV_GIMPL_NODEKIND = type TEmptyRec;
  ADE_CONSTTYPEDGRAPH_OF_CV_GIMPL_NODETYPE = type TEmptyRec;
  ADE_EXECUTIONENGINESETUPCONTEXT          = type TEmptyRec;
  ADE_GRAPH                                = type TEmptyRec;
  ADE_HANDLE_OF_ADE_EDGE                   = type TEmptyRec;
  ADE_HANDLE_OF_ADE_NODE                   = type TEmptyRec;
  ADE_TYPEDGRAPH_OF_CV_GIMPL_NODEKIND      = type TEmptyRec;
  ADE_TYPEDGRAPH_OF_CV_GIMPL_NODETYPE      = type TEmptyRec;
  CVCAPTURE                                = type TEmptyRec;
  // CVCREATESPARSEMAT                                = type TEmptyRec;
  CVFLANN                      = type TEmptyRec;
  CVFLANN_FLANN_ALGORITHM_T    = type TEmptyRec;
  CVFLANN_FLANN_CENTERS_INIT_T = type TEmptyRec;
  CVFLANN_FLANN_DISTANCE_T     = type TEmptyRec;
  // CVIPLIMAGE                                       = type TEmptyRec;
  CVLEVMARQ = type TEmptyRec;
  // CV_MAT                                            = {$IF Declared(CVMAT)}CVMAT{$ELSE}type TEmptyRec{$IFEND};
  CV_MATND        = {$IF Declared(TCvMatND)}TCvMatND{$ELSE} type TEmptyRec{$IFEND};
  CV_CVMEMSTORAGE = {$IF Declared(TCvMemStorage)}TCvMemStorage{$ELSE} type TEmptyRec{$IFEND};
  CVROUND64       = type TEmptyRec;
  CV_CVSEQ        = {$IF Declared(TCvSeq)}TCvSeq{$ELSE} type TEmptyRec{$IFEND};
  CV_SLICE        = {$IF Declared(TCvSlice)}TCvSlice{$ELSE} type TEmptyRec{$IFEND};
  // CV_SPARSEMAT                                      = type TEmptyRec;
  CV_TERMCRITERIA                           = TTermCriteria; // type TEmptyRec;
  CVTRUNC                                   = type TEmptyRec;
  CVVIDEOWRITER                             = type TEmptyRec;
  CV_ACCESSFLAG                             = type TEmptyRec;
  CV_AFFINE3_OF_DOUBLE                      = type TEmptyRec;
  CV_AFFINEFEATURE                          = type TEmptyRec;
  CV_AFFINEWARPER                           = type TEmptyRec;
  CV_AGASTFEATUREDETECTOR                   = type TEmptyRec;
  CV_AGASTFEATUREDETECTOR_DETECTORTYPE      = type TEmptyRec;
  CV_AKAZE                                  = type TEmptyRec;
  CV_AKAZE_DESCRIPTORTYPE                   = type TEmptyRec;
  CV_ALGORITHM                              = type TEmptyRec;
  CV_ALIGNEXPOSURES                         = type TEmptyRec;
  CV_ALIGNMTB                               = type TEmptyRec;
  CV_ARUCO                                  = type TEmptyRec;
  CV_ARUCO_ARUCODETECTOR                    = type TEmptyRec;
  CV_ARUCO_BOARD                            = type TEmptyRec;
  CV_ARUCO_CHARUCOBOARD                     = type TEmptyRec;
  CV_ARUCO_CHARUCODETECTOR                  = type TEmptyRec;
  CV_ARUCO_CHARUCOPARAMETERS                = type TEmptyRec;
  CV_ARUCO_DETECTORPARAMETERS               = type TEmptyRec;
  CV_ARUCO_DICTIONARY                       = type TEmptyRec;
  CV_ARUCO_GRIDBOARD                        = type TEmptyRec;
  CV_ARUCO_PREDEFINEDDICTIONARYTYPE         = type TEmptyRec;
  CV_ARUCO_REFINEPARAMETERS                 = type TEmptyRec;
  CV_ASYNCARRAY                             = type TEmptyRec;
  CV_ASYNCPROMISE                           = type TEmptyRec;
  CV_AUTOBUFFER_OF_DOUBLE                   = {$IF Declared(AutoBuffer_of_double)}AutoBuffer_of_double{$ELSE} type TEmptyRec{$IFEND};
  CV_AVIREADCONTAINER                       = type TEmptyRec;
  CV_AVIWRITECONTAINER                      = type TEmptyRec;
  CV_BACKGROUNDSUBTRACTOR                   = type TEmptyRec;
  CV_BACKGROUNDSUBTRACTORKNN                = type TEmptyRec;
  CV_BACKGROUNDSUBTRACTORMOG2               = {$IF Declared(TBackgroundSubtractorMOG2)}TBackgroundSubtractorMOG2{$ELSE} type TEmptyRec{$IFEND};
  CV_BASECASCADECLASSIFIER                  = type TEmptyRec;
  CV_BASECASCADECLASSIFIER_MASKGENERATOR    = type TEmptyRec;
  CV_BFMATCHER                              = type TEmptyRec;
  CV_BORDERTYPES                            = type TEmptyRec;
  CV_BOWIMGDESCRIPTOREXTRACTOR              = type TEmptyRec;
  CV_BOWKMEANSTRAINER                       = type TEmptyRec;
  CV_BOWTRAINER                             = type TEmptyRec;
  CV_BRISK                                  = type TEmptyRec;
  CV_BUFFERPOOLCONTROLLER                   = type TEmptyRec;
  CV_CALIBRATECRF                           = type TEmptyRec;
  CV_CALIBRATEDEBEVEC                       = type TEmptyRec;
  CV_CALIBRATEROBERTSON                     = type TEmptyRec;
  CV_CASCADECLASSIFIER                      = {$IF Declared(TCascadeClassifier)}TCascadeClassifier{$ELSE} type TEmptyRec{$IFEND};
  CV_CIRCLESGRIDFINDERPARAMETERS            = type TEmptyRec;
  CV_CLAHE                                  = {$IF Declared(TCLAHE)}TCLAHE{$ELSE} type TEmptyRec{$IFEND};
  CV_CODECS                                 = type TEmptyRec;
  CV_COMMANDLINEPARSER                      = type TEmptyRec;
  CV_COMPRESSEDRECTILINEARPORTRAITWARPER    = type TEmptyRec;
  CV_COMPRESSEDRECTILINEARWARPER            = type TEmptyRec;
  CV_CONJGRADSOLVER                         = type TEmptyRec;
  CV_CONTOURAPPROXIMATIONMODES              = type TEmptyRec;
  CV_CUDA                                   = type TEmptyRec;
  CV_CUDA_BUFFERPOOL                        = type TEmptyRec;
  CV_CUDA_DEVICEINFO                        = type TEmptyRec;
  CV_CUDA_DEVICEINFO_COMPUTEMODE            = type TEmptyRec;
  CV_CUDA_EVENT                             = type TEmptyRec;
  CV_CUDA_EVENT_CREATEFLAGS                 = type TEmptyRec;
  CV_CUDA_FEATURESET                        = type TEmptyRec;
  CV_CUDA_GPUDATA                           = type TEmptyRec;
  CV_CUDA_GPUMAT                            = type TEmptyRec;
  CV_CUDA_GPUMATND                          = type TEmptyRec;
  CV_CUDA_GPUMAT_ALLOCATOR                  = type TEmptyRec;
  CV_CUDA_HOSTMEM                           = type TEmptyRec;
  CV_CUDA_HOSTMEM_ALLOCTYPE                 = type TEmptyRec;
  CV_CUDA_STREAM                            = type TEmptyRec;
  CV_CUDA_TARGETARCHS                       = type TEmptyRec;
  CV_CYLINDRICALWARPER                      = type TEmptyRec;
  CV_DEFAULTDELETER_OF_CVCAPTURE            = type TEmptyRec;
  CV_DEFAULTDELETER_OF_CVMAT                = type TEmptyRec;
  CV_DEFAULTDELETER_OF_CVMATND              = type TEmptyRec;
  CV_DEFAULTDELETER_OF_CVMEMSTORAGE         = type TEmptyRec;
  CV_DEFAULTDELETER_OF_CVSPARSEMAT          = type TEmptyRec;
  CV_DEFAULTDELETER_OF_CVVIDEOWRITER        = type TEmptyRec;
  CV_DEFAULTDELETER_OF__IPLIMAGE            = type TEmptyRec;
  CV_DENSEOPTICALFLOW                       = {$IF Declared(TDenseOpticalFlow)}TDenseOpticalFlow{$ELSE} type TEmptyRec{$IFEND};
  CV_DESCRIPTORMATCHER                      = type TEmptyRec;
  CV_DESCRIPTORMATCHER_DESCRIPTORCOLLECTION = type TEmptyRec;
  CV_DESCRIPTORMATCHER_MATCHERTYPE          = type TEmptyRec;
  CV_DETAIL                                 = type TEmptyRec;
  CV_DETAILS                                = type TEmptyRec;
  CV_DETAILS_FPDENORMALSMODESTATE           = type TEmptyRec;
  CV_DETAIL_AFFINEBASEDESTIMATOR            = type TEmptyRec;
  CV_DETAIL_AFFINEBESTOF2NEARESTMATCHER     = type TEmptyRec;
  CV_DETAIL_AFFINEWARPER                    = type TEmptyRec;
  CV_DETAIL_ARGKIND                         = type TEmptyRec;
  CV_DETAIL_BESTOF2NEARESTMATCHER           = type TEmptyRec;
  CV_DETAIL_BESTOF2NEARESTRANGEMATCHER      = type TEmptyRec;
  CV_DETAIL_BLENDER                         = type TEmptyRec;
  CV_DETAIL_BLOCKSCHANNELSCOMPENSATOR       = type TEmptyRec;
  CV_DETAIL_BLOCKSCOMPENSATOR               = type TEmptyRec;
  CV_DETAIL_BLOCKSGAINCOMPENSATOR           = type TEmptyRec;
  CV_DETAIL_BUNDLEADJUSTERAFFINE            = type TEmptyRec;
  CV_DETAIL_BUNDLEADJUSTERAFFINEPARTIAL     = type TEmptyRec;
  CV_DETAIL_BUNDLEADJUSTERBASE              = type TEmptyRec;
  CV_DETAIL_BUNDLEADJUSTERRAY               = type TEmptyRec;
  CV_DETAIL_BUNDLEADJUSTERREPROJ            = type TEmptyRec;
  CV_DETAIL_CAMERAPARAMS                    = type TEmptyRec;
  CV_DETAIL_CHANNELSCOMPENSATOR             = type TEmptyRec;
  CV_DETAIL_CHECKCONTEXT                    = type TEmptyRec;
  CV_DETAIL_COMPRESSEDRECTILINEARPORTRAITPROJECTOR = type TEmptyRec;
  CV_DETAIL_COMPRESSEDRECTILINEARPORTRAITWARPER = type TEmptyRec;
  CV_DETAIL_COMPRESSEDRECTILINEARPROJECTOR      = type TEmptyRec;
  CV_DETAIL_COMPRESSEDRECTILINEARWARPER         = type TEmptyRec;
  CV_DETAIL_CYLINDRICALPORTRAITPROJECTOR        = type TEmptyRec;
  CV_DETAIL_CYLINDRICALPORTRAITWARPER           = type TEmptyRec;
  CV_DETAIL_CYLINDRICALPROJECTOR                = type TEmptyRec;
  CV_DETAIL_CYLINDRICALWARPER                   = type TEmptyRec;
  CV_DETAIL_CYLINDRICALWARPERGPU                = type TEmptyRec;
  CV_DETAIL_DISJOINTSETS                        = type TEmptyRec;
  CV_DETAIL_DPSEAMFINDER                        = type TEmptyRec;
  CV_DETAIL_DPSEAMFINDER_COSTFUNCTION           = type TEmptyRec;
  CV_DETAIL_ESTIMATOR                           = type TEmptyRec;
  CV_DETAIL_EXPOSURECOMPENSATOR                 = type TEmptyRec;
  CV_DETAIL_EXTRACTARGSCALLBACK                 = type TEmptyRec;
  CV_DETAIL_EXTRACTMETACALLBACK                 = type TEmptyRec;
  CV_DETAIL_FEATHERBLENDER                      = type TEmptyRec;
  CV_DETAIL_FEATURESMATCHER                     = type TEmptyRec;
  CV_DETAIL_FISHEYEPROJECTOR                    = type TEmptyRec;
  CV_DETAIL_FISHEYEWARPER                       = type TEmptyRec;
  CV_DETAIL_GAINCOMPENSATOR                     = type TEmptyRec;
  CV_DETAIL_GARRAYU                             = type TEmptyRec;
  CV_DETAIL_GCOMPOUNDCONTEXT                    = type TEmptyRec;
  CV_DETAIL_GCOMPOUNDKERNEL                     = type TEmptyRec;
  CV_DETAIL_GOPAQUEU                            = type TEmptyRec;
  CV_DETAIL_GRAPH                               = type TEmptyRec;
  CV_DETAIL_GRAPHCUTSEAMFINDER                  = type TEmptyRec;
  CV_DETAIL_GRAPHCUTSEAMFINDERBASE              = type TEmptyRec;
  CV_DETAIL_GRAPHEDGE                           = type TEmptyRec;
  CV_DETAIL_HOMOGRAPHYBASEDESTIMATOR            = type TEmptyRec;
  CV_DETAIL_IMAGEFEATURES                       = type TEmptyRec;
  CV_DETAIL_MATCHESINFO                         = type TEmptyRec;
  CV_DETAIL_MERCATORPROJECTOR                   = type TEmptyRec;
  CV_DETAIL_MERCATORWARPER                      = type TEmptyRec;
  CV_DETAIL_MULTIBANDBLENDER                    = type TEmptyRec;
  CV_DETAIL_NOBUNDLEADJUSTER                    = type TEmptyRec;
  CV_DETAIL_NOEXPOSURECOMPENSATOR               = type TEmptyRec;
  CV_DETAIL_NOSEAMFINDER                        = type TEmptyRec;
  CV_DETAIL_OPAQUEKIND                          = type TEmptyRec;
  CV_DETAIL_OPAQUEREF                           = type TEmptyRec;
  CV_DETAIL_PAIRWISESEAMFINDER                  = type TEmptyRec;
  CV_DETAIL_PANINIPORTRAITPROJECTOR             = type TEmptyRec;
  CV_DETAIL_PANINIPORTRAITWARPER                = type TEmptyRec;
  CV_DETAIL_PANINIPROJECTOR                     = type TEmptyRec;
  CV_DETAIL_PANINIWARPER                        = type TEmptyRec;
  CV_DETAIL_PLANEPORTRAITPROJECTOR              = type TEmptyRec;
  CV_DETAIL_PLANEPORTRAITWARPER                 = type TEmptyRec;
  CV_DETAIL_PLANEPROJECTOR                      = type TEmptyRec;
  CV_DETAIL_PLANEWARPER                         = type TEmptyRec;
  CV_DETAIL_PLANEWARPERGPU                      = type TEmptyRec;
  CV_DETAIL_PROJECTORBASE                       = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPER                      = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_COMPRESSEDRECTILINEARPORTRAITPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_COMPRESSEDRECTILINEARPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_CYLINDRICALPORTRAITPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_CYLINDRICALPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_FISHEYEPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_MERCATORPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PANINIPORTRAITPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PANINIPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PLANEPORTRAITPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PLANEPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_SPHERICALPORTRAITPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_SPHERICALPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_STEREOGRAPHICPROJECTOR = type TEmptyRec;
  CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_TRANSVERSEMERCATORPROJECTOR = type TEmptyRec;
  CV_DETAIL_SEAMFINDER = type TEmptyRec;
  CV_DETAIL_SPHERICALPORTRAITPROJECTOR                   = type TEmptyRec;
  CV_DETAIL_SPHERICALPORTRAITWARPER                      = type TEmptyRec;
  CV_DETAIL_SPHERICALPROJECTOR                           = type TEmptyRec;
  CV_DETAIL_SPHERICALWARPER                              = type TEmptyRec;
  CV_DETAIL_SPHERICALWARPERGPU                           = type TEmptyRec;
  CV_DETAIL_STEREOGRAPHICPROJECTOR                       = type TEmptyRec;
  CV_DETAIL_STEREOGRAPHICWARPER                          = type TEmptyRec;
  CV_DETAIL_TIMELAPSER                                   = type TEmptyRec;
  CV_DETAIL_TIMELAPSERCROP                               = type TEmptyRec;
  CV_DETAIL_TRACKING_CLFMILBOOST                         = type TEmptyRec;
  CV_DETAIL_TRACKING_CLFMILBOOST_PARAMS                  = type TEmptyRec;
  CV_DETAIL_TRACKING_TRACKERFEATURE                      = type TEmptyRec;
  CV_DETAIL_TRACKING_TRACKERFEATURESET                   = type TEmptyRec;
  CV_DETAIL_TRACKING_TRACKERMODEL                        = type TEmptyRec;
  CV_DETAIL_TRACKING_TRACKERSAMPLER                      = type TEmptyRec;
  CV_DETAIL_TRACKING_TRACKERSAMPLERALGORITHM             = type TEmptyRec;
  CV_DETAIL_TRACKING_TRACKERSAMPLERCSC                   = type TEmptyRec;
  CV_DETAIL_TRACKING_TRACKERSAMPLERCSC_PARAMS            = type TEmptyRec;
  CV_DETAIL_TRACKING_TRACKERSTATEESTIMATOR               = type TEmptyRec;
  CV_DETAIL_TRACKING_TRACKERSTATEESTIMATORMILBOOSTING    = type TEmptyRec;
  CV_DETAIL_TRACKING_TRACKERTARGETSTATE                  = type TEmptyRec;
  CV_DETAIL_TRANSVERSEMERCATORPROJECTOR                  = type TEmptyRec;
  CV_DETAIL_TRANSVERSEMERCATORWARPER                     = type TEmptyRec;
  CV_DETAIL_VECTORREF                                    = type TEmptyRec;
  CV_DETAIL_VORONOISEAMFINDER                            = type TEmptyRec;
  CV_DETAIL_WAVECORRECTKIND                              = type TEmptyRec;
  CV_DETECTIONBASEDTRACKER                               = type TEmptyRec;
  CV_DETECTIONBASEDTRACKER_OBJECTSTATUS                  = type TEmptyRec;
  CV_DETECTIONBASEDTRACKER_PARAMETERS                    = type TEmptyRec;
  CV_DIRECTX                                             = type TEmptyRec;
  CV_DIRECTX_OCL                                         = type TEmptyRec;
  CV_DISOPTICALFLOW                                      = type TEmptyRec;
  CV_DISTANCETYPES                                       = type TEmptyRec;
  CV_DMATCH                                              = type TEmptyRec;
  CV_DNN_BACKEND_NETWORKBACKEND                          = type TEmptyRec;
  CV_DNN_DNN4_V20221220                                  = type TEmptyRec;
  CV_DNN_DNN_ABSLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_ACCUMLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_ACOSHLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_ACOSLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_ACTIVATIONLAYER                             = type TEmptyRec;
  CV_DNN_DNN_ACTIVATIONLAYERINT8                         = type TEmptyRec;
  CV_DNN_DNN_ARGLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_ASINHLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_ASINLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_ATANHLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_ATANLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_BACKEND                                     = type TEmptyRec;
  CV_DNN_DNN_BASECONVOLUTIONLAYER                        = type TEmptyRec;
  CV_DNN_DNN_BATCHNORMLAYER                              = type TEmptyRec;
  CV_DNN_DNN_BATCHNORMLAYERINT8                          = type TEmptyRec;
  CV_DNN_DNN_BLANKLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_BNLLLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_CEILLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_CELULAYER                                   = type TEmptyRec;
  CV_DNN_DNN_CHANNELSPRELULAYER                          = type TEmptyRec;
  CV_DNN_DNN_CLASSIFICATIONMODEL                         = type TEmptyRec;
  CV_DNN_DNN_COMPARELAYER                                = type TEmptyRec;
  CV_DNN_DNN_CONCATLAYER                                 = type TEmptyRec;
  CV_DNN_DNN_CONSTLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_CONVOLUTIONLAYER                            = type TEmptyRec;
  CV_DNN_DNN_CONVOLUTIONLAYERINT8                        = type TEmptyRec;
  CV_DNN_DNN_CORRELATIONLAYER                            = type TEmptyRec;
  CV_DNN_DNN_COSHLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_COSLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_CROPANDRESIZELAYER                          = type TEmptyRec;
  CV_DNN_DNN_CROPLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_CUMSUMLAYER                                 = type TEmptyRec;
  CV_DNN_DNN_DATAAUGMENTATIONLAYER                       = type TEmptyRec;
  CV_DNN_DNN_DECONVOLUTIONLAYER                          = type TEmptyRec;
  CV_DNN_DNN_DEQUANTIZELAYER                             = type TEmptyRec;
  CV_DNN_DNN_DETECTIONMODEL                              = type TEmptyRec;
  CV_DNN_DNN_DETECTIONOUTPUTLAYER                        = type TEmptyRec;
  CV_DNN_DNN_DICT                                        = type TEmptyRec;
  CV_DNN_DNN_DICTVALUE                                   = type TEmptyRec;
  CV_DNN_DNN_ELTWISELAYER                                = type TEmptyRec;
  CV_DNN_DNN_ELTWISELAYERINT8                            = type TEmptyRec;
  CV_DNN_DNN_ELULAYER                                    = type TEmptyRec;
  CV_DNN_DNN_ERFLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_EXPLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_FLATTENLAYER                                = type TEmptyRec;
  CV_DNN_DNN_FLOORLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_FLOWWARPLAYER                               = type TEmptyRec;
  CV_DNN_DNN_GATHERLAYER                                 = type TEmptyRec;
  CV_DNN_DNN_GRULAYER                                    = type TEmptyRec;
  CV_DNN_DNN_HARDSIGMOIDLAYER                            = type TEmptyRec;
  CV_DNN_DNN_HARDSWISHLAYER                              = type TEmptyRec;
  CV_DNN_DNN_INNERPRODUCTLAYER                           = type TEmptyRec;
  CV_DNN_DNN_INNERPRODUCTLAYERINT8                       = type TEmptyRec;
  CV_DNN_DNN_INTERPLAYER                                 = type TEmptyRec;
  CV_DNN_DNN_KEYPOINTSMODEL                              = type TEmptyRec;
  CV_DNN_DNN_LAYER                                       = type TEmptyRec;
  CV_DNN_DNN_LAYERFACTORY                                = type TEmptyRec;
  CV_DNN_DNN_LAYERPARAMS                                 = type TEmptyRec;
  CV_DNN_DNN_LOGLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_LRNLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_LSTMLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_MAXUNPOOLLAYER                              = type TEmptyRec;
  CV_DNN_DNN_MISHLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_MODEL                                       = {$IF Declared(_Model)}_Model{$ELSE} type TEmptyRec{$IFEND};
  CV_DNN_DNN_MODEL_IMPL                                  = type TEmptyRec;
  CV_DNN_DNN_MVNLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_NARYELTWISELAYER                            = type TEmptyRec;
  CV_DNN_DNN_NET                                         = {$IF Declared(TNet)}TNet{$ELSE} type TEmptyRec{$IFEND};
  CV_DNN_DNN_NET_IMPL                                    = type TEmptyRec;
  CV_DNN_DNN_NORMALIZEBBOXLAYER                          = type TEmptyRec;
  CV_DNN_DNN_NOTLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_PADDINGLAYER                                = type TEmptyRec;
  CV_DNN_DNN_PERMUTELAYER                                = type TEmptyRec;
  CV_DNN_DNN_POOLINGLAYER                                = type TEmptyRec;
  CV_DNN_DNN_POOLINGLAYERINT8                            = type TEmptyRec;
  CV_DNN_DNN_POWERLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_PRIORBOXLAYER                               = type TEmptyRec;
  CV_DNN_DNN_PROPOSALLAYER                               = type TEmptyRec;
  CV_DNN_DNN_QUANTIZELAYER                               = type TEmptyRec;
  CV_DNN_DNN_RECIPROCALLAYER                             = type TEmptyRec;
  CV_DNN_DNN_REDUCELAYER                                 = type TEmptyRec;
  CV_DNN_DNN_REDUCELAYERINT8                             = type TEmptyRec;
  CV_DNN_DNN_REGIONLAYER                                 = type TEmptyRec;
  CV_DNN_DNN_RELU6LAYER                                  = type TEmptyRec;
  CV_DNN_DNN_RELULAYER                                   = type TEmptyRec;
  CV_DNN_DNN_REORGLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_REQUANTIZELAYER                             = type TEmptyRec;
  CV_DNN_DNN_RESHAPELAYER                                = type TEmptyRec;
  CV_DNN_DNN_RESIZELAYER                                 = type TEmptyRec;
  CV_DNN_DNN_RNNLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_ROUNDLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_SCALELAYER                                  = type TEmptyRec;
  CV_DNN_DNN_SCALELAYERINT8                              = type TEmptyRec;
  CV_DNN_DNN_SCATTERLAYER                                = type TEmptyRec;
  CV_DNN_DNN_SCATTERNDLAYER                              = type TEmptyRec;
  CV_DNN_DNN_SEGMENTATIONMODEL                           = type TEmptyRec;
  CV_DNN_DNN_SELULAYER                                   = type TEmptyRec;
  CV_DNN_DNN_SHIFTLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_SHIFTLAYERINT8                              = type TEmptyRec;
  CV_DNN_DNN_SHRINKLAYER                                 = type TEmptyRec;
  CV_DNN_DNN_SHUFFLECHANNELLAYER                         = type TEmptyRec;
  CV_DNN_DNN_SIGMOIDLAYER                                = type TEmptyRec;
  CV_DNN_DNN_SIGNLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_SINHLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_SINLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_SLICELAYER                                  = type TEmptyRec;
  CV_DNN_DNN_SOFTMAXLAYER                                = type TEmptyRec;
  CV_DNN_DNN_SOFTMAXLAYERINT8                            = type TEmptyRec;
  CV_DNN_DNN_SOFTNMSMETHOD                               = type TEmptyRec;
  CV_DNN_DNN_SOFTPLUSLAYER                               = type TEmptyRec;
  CV_DNN_DNN_SOFTSIGNLAYER                               = type TEmptyRec;
  CV_DNN_DNN_SPLITLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_SQRTLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_SWISHLAYER                                  = type TEmptyRec;
  CV_DNN_DNN_TANHLAYER                                   = type TEmptyRec;
  CV_DNN_DNN_TANLAYER                                    = type TEmptyRec;
  CV_DNN_DNN_TARGET                                      = type TEmptyRec;
  CV_DNN_DNN_TEXTDETECTIONMODEL                          = type TEmptyRec;
  CV_DNN_DNN_TEXTDETECTIONMODEL_DB                       = type TEmptyRec;
  CV_DNN_DNN_TEXTDETECTIONMODEL_EAST                     = type TEmptyRec;
  CV_DNN_DNN_TEXTRECOGNITIONMODEL                        = {$IF Declared(_TextRecognitionModel)}_TextRecognitionModel{$ELSE} type TEmptyRec{$IFEND};
  CV_DNN_DNN_THRESHOLDEDRELULAYER                        = type TEmptyRec;
  CV_DNN_DNN_TILELAYER                                   = type TEmptyRec;
  CV_DOWNHILLSOLVER                                      = type TEmptyRec;
  CV_DRAWMATCHESFLAGS                                    = type TEmptyRec;
  CV_EXCEPTION                                           = type TEmptyRec;
  CV_FACEDETECTORYN                                      = type TEmptyRec;
  CV_FACERECOGNIZERSF                                    = type TEmptyRec;
  CV_FARNEBACKOPTICALFLOW                                = type TEmptyRec;
  CV_FASTFEATUREDETECTOR                                 = type TEmptyRec;
  CV_FASTFEATUREDETECTOR_DETECTORTYPE                    = type TEmptyRec;
  CV_FEATURE2D                                           = type TEmptyRec;
  CV_FILENODE                                            = {$IF Declared(TFileNode)}TFileNode{$ELSE} type TEmptyRec{$IFEND};
  CV_FILENODEITERATOR                                    = {$IF Declared(TFileNodeIterator)}TFileNodeIterator{$ELSE} type TEmptyRec{$IFEND};
  CV_FILESTORAGE                                         = {$IF Declared(TFileStorage)}TFileStorage{$ELSE} type TEmptyRec{$IFEND};
  CV_FILESTORAGE_IMPL                                    = type TEmptyRec;
  CV_FISHEYE                                             = type TEmptyRec;
  CV_FISHEYEWARPER                                       = type TEmptyRec;
  CV_FLANNBASEDMATCHER                                   = type TEmptyRec;
  CV_FLANN_AUTOTUNEDINDEXPARAMS                          = type TEmptyRec;
  CV_FLANN_COMPOSITEINDEXPARAMS                          = type TEmptyRec;
  CV_FLANN_HIERARCHICALCLUSTERINGINDEXPARAMS             = type TEmptyRec;
  CV_FLANN_INDEX                                         = type TEmptyRec;
  CV_FLANN_INDEXPARAMS                                   = type TEmptyRec;
  CV_FLANN_KDTREEINDEXPARAMS                             = type TEmptyRec;
  CV_FLANN_KMEANSINDEXPARAMS                             = type TEmptyRec;
  CV_FLANN_LINEARINDEXPARAMS                             = type TEmptyRec;
  CV_FLANN_LSHINDEXPARAMS                                = type TEmptyRec;
  CV_FLANN_SAVEDINDEXPARAMS                              = type TEmptyRec;
  CV_FLANN_SEARCHPARAMS                                  = type TEmptyRec;
  CV_FLOAT16_T                                           = type TEmptyRec;
  CV_FORMATTED                                           = type TEmptyRec;
  CV_FORMATTER                                           = type TEmptyRec;
  CV_FORMATTER_FORMATTYPE                                = type TEmptyRec;
  CV_GAPI                                                = type TEmptyRec;
  CV_GAPI_CALIB3D_CPU                                    = type TEmptyRec;
  CV_GAPI_CALIB3D_CPU_STEREOINITPARAM                    = type TEmptyRec;
  CV_GAPI_COMPOUND                                       = type TEmptyRec;
  CV_GAPI_CORE_CPU                                       = type TEmptyRec;
  CV_GAPI_CORE_FLUID                                     = type TEmptyRec;
  CV_GAPI_CORE_OCL                                       = type TEmptyRec;
  CV_GAPI_CORE_PLAIDML                                   = type TEmptyRec;
  CV_GAPI_CPU                                            = type TEmptyRec;
  CV_GAPI_DETAIL                                         = type TEmptyRec;
  CV_GAPI_FLUID                                          = type TEmptyRec;
  CV_GAPI_FLUID_BUFFER                                   = type TEmptyRec;
  CV_GAPI_FLUID_BUFFERSTORAGE                            = type TEmptyRec;
  CV_GAPI_FLUID_BUFFER_CACHE                             = type TEmptyRec;
  CV_GAPI_FLUID_BUFFER_PRIV                              = type TEmptyRec;
  CV_GAPI_FLUID_VIEW                                     = type TEmptyRec;
  CV_GAPI_FLUID_VIEW_CACHE                               = type TEmptyRec;
  CV_GAPI_FLUID_VIEW_PRIV                                = type TEmptyRec;
  CV_GAPI_GBACKEND                                       = type TEmptyRec;
  CV_GAPI_GBACKEND_PRIV                                  = type TEmptyRec;
  CV_GAPI_GFUNCTOR                                       = type TEmptyRec;
  CV_GAPI_GNETPACKAGE                                    = type TEmptyRec;
  CV_GAPI_GNETPARAM                                      = type TEmptyRec;
  CV_GAPI_IE                                             = type TEmptyRec;
  CV_GAPI_IE_PYPARAMS                                    = type TEmptyRec;
  CV_GAPI_IE_TRAITAS                                     = type TEmptyRec;
  CV_GAPI_IMGPROC_CPU                                    = type TEmptyRec;
  CV_GAPI_IMGPROC_FLUID                                  = type TEmptyRec;
  CV_GAPI_IMGPROC_OCL                                    = type TEmptyRec;
  CV_GAPI_KALMANPARAMS                                   = type TEmptyRec;
  CV_GAPI_OAK                                            = type TEmptyRec;
  CV_GAPI_OAK_COLORCAMERA                                = type TEmptyRec;
  CV_GAPI_OAK_COLORCAMERAPARAMS                          = type TEmptyRec;
  CV_GAPI_OAK_ENCODERCONFIG                              = type TEmptyRec;
  CV_GAPI_OAK_OAKMEDIAADAPTER                            = type TEmptyRec;
  CV_GAPI_OAK_OAKRMATADAPTER                             = type TEmptyRec;
  CV_GAPI_OCL                                            = type TEmptyRec;
  CV_GAPI_ONNX                                           = type TEmptyRec;
  CV_GAPI_ONNX_PYPARAMS                                  = type TEmptyRec;
  CV_GAPI_OWN                                            = type TEmptyRec;
  CV_GAPI_OWN_MAT                                        = type TEmptyRec;
  CV_GAPI_OWN_SCALAR                                     = TScalar; // type TEmptyRec;
  CV_GAPI_PYTHON                                         = type TEmptyRec;
  CV_GAPI_PYTHON_GPYTHONFUNCTOR                          = type TEmptyRec;
  CV_GAPI_PYTHON_GPYTHONKERNEL                           = type TEmptyRec;
  CV_GAPI_RENDER_OCV                                     = type TEmptyRec;
  CV_GAPI_S11N                                           = type TEmptyRec;
  CV_GAPI_S11N_BYTEMEMORYINSTREAM                        = type TEmptyRec;
  CV_GAPI_S11N_BYTEMEMORYOUTSTREAM                       = type TEmptyRec;
  CV_GAPI_S11N_DETAIL                                    = type TEmptyRec;
  CV_GAPI_S11N_GSERIALIZED                               = type TEmptyRec;
  CV_GAPI_S11N_IISTREAM                                  = type TEmptyRec;
  CV_GAPI_S11N_IOSTREAM                                  = type TEmptyRec;
  CV_GAPI_STEREOOUTPUTFORMAT                             = type TEmptyRec;
  CV_GAPI_STREAMING                                      = type TEmptyRec;
  CV_GAPI_STREAMING_QUEUE_CAPACITY                       = type TEmptyRec;
  CV_GAPI_USE_ONLY                                       = type TEmptyRec;
  CV_GAPI_VIDEO_BACKGROUNDSUBTRACTORPARAMS               = type TEmptyRec;
  CV_GAPI_VIDEO_CPU                                      = type TEmptyRec;
  CV_GAPI_WIP                                            = type TEmptyRec;
  CV_GAPI_WIP_DATA                                       = type TEmptyRec;
  CV_GAPI_WIP_DRAW                                       = type TEmptyRec;
  CV_GAPI_WIP_DRAW_CIRCLE                                = type TEmptyRec;
  CV_GAPI_WIP_DRAW_FTEXT                                 = type TEmptyRec;
  CV_GAPI_WIP_DRAW_FTTEXTRENDER                          = type TEmptyRec;
  CV_GAPI_WIP_DRAW_IMAGE                                 = type TEmptyRec;
  CV_GAPI_WIP_DRAW_LINE                                  = type TEmptyRec;
  CV_GAPI_WIP_DRAW_MOSAIC                                = type TEmptyRec;
  CV_GAPI_WIP_DRAW_POLY                                  = type TEmptyRec;
  CV_GAPI_WIP_DRAW_RECT                                  = type TEmptyRec;
  CV_GAPI_WIP_DRAW_TEXT                                  = type TEmptyRec;
  CV_GAPI_WIP_GASYNCCANCELED                             = type TEmptyRec;
  CV_GAPI_WIP_GASYNCCONTEXT                              = type TEmptyRec;
  CV_GAPI_WIP_GST_GSTREAMERPIPELINE                      = type TEmptyRec;
  CV_GAPI_WIP_GST_GSTREAMERSOURCE                        = type TEmptyRec;
  CV_GAPI_WIP_GST_GSTREAMERSOURCE_OUTPUTTYPE             = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL                                     = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_ACCELTYPE                           = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_CFGPARAM                            = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_CONTEXT                             = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_DATAPROVIDEREXCEPTION               = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_DATAPROVIDERIMPLEMENTATIONEXCEPTION = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_DATAPROVIDERSYSTEMERROREXCEPTION    = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_DATAPROVIDERUNSUPPORTEDEXCEPTION    = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_DEVICE                              = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_FILEDATAPROVIDER                    = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_GSOURCE                             = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_IDATAPROVIDER                       = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_IDEVICESELECTOR                     = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_IDEVICESELECTOR_SCORE               = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_SHAREDLOCK                          = type TEmptyRec;
  CV_GAPI_WIP_ONEVPL_VPPPREPROCDISPATCHER                = type TEmptyRec;
  CV_GAPI_WIP_PP_PARAMS                                  = type TEmptyRec;
  CV_GAPI_WIP_PP_SESSION                                 = type TEmptyRec;
  CV_GARG                                                = type TEmptyRec;
  CV_GARRAYDESC                                          = type TEmptyRec;
  CV_GARRAY_OF_CV_GARRAY_OF_CV_POINT__OF_INT             = type TEmptyRec;
  CV_GARRAY_OF_CV_GMAT                                   = type TEmptyRec;
  CV_GARRAY_OF_CV_POINT3__OF_DOUBLE                      = type TEmptyRec;
  CV_GARRAY_OF_CV_POINT3__OF_FLOAT                       = type TEmptyRec;
  CV_GARRAY_OF_CV_POINT3__OF_INT                         = type TEmptyRec;
  CV_GARRAY_OF_CV_POINT__OF_DOUBLE                       = type TEmptyRec;
  CV_GARRAY_OF_CV_POINT__OF_FLOAT                        = type TEmptyRec;
  CV_GARRAY_OF_CV_POINT__OF_INT                          = type TEmptyRec;
  CV_GARRAY_OF_CV_RECT__OF_INT                           = type TEmptyRec;
  CV_GARRAY_OF_CV_UTIL_VARIANT_OF_CV_GAPI_WIP_DRAW_TEXT  = type TEmptyRec;
  CV_GARRAY_OF_INT                                       = type TEmptyRec;
  CV_GARRAY_OF_UNSIGNED_CVCHAR                           = type TEmptyRec;
  CV_GCALL                                               = type TEmptyRec;
  CV_GCALL_PRIV                                          = type TEmptyRec;
  CV_GCOMPILEARG                                         = type TEmptyRec;
  CV_GCOMPILED                                           = type TEmptyRec;
  CV_GCOMPILED_PRIV                                      = type TEmptyRec;
  CV_GCOMPUTATION                                        = type TEmptyRec;
  CV_GCOMPUTATION_PRIV                                   = type TEmptyRec;
  CV_GCPUCONTEXT                                         = type TEmptyRec;
  CV_GCPUKERNEL                                          = type TEmptyRec;
  CV_GENERALIZEDHOUGH                                    = type TEmptyRec;
  CV_GENERALIZEDHOUGHBALLARD                             = type TEmptyRec;
  CV_GENERALIZEDHOUGHGUIL                                = type TEmptyRec;
  CV_GFLUIDKERNEL                                        = type TEmptyRec;
  CV_GFLUIDKERNEL_KIND                                   = type TEmptyRec;
  CV_GFRAME                                              = type TEmptyRec;
  CV_GFRAMEDESC                                          = type TEmptyRec;
  CV_GFTTDETECTOR                                        = type TEmptyRec;
  CV_GIMPL                                               = type TEmptyRec;
  CV_GIMPL_CONSTVALUE                                    = type TEmptyRec;
  CV_GIMPL_DATA                                          = type TEmptyRec;
  CV_GIMPL_DATAOBJECTCOUNTER                             = type TEmptyRec;
  CV_GIMPL_DATA_STORAGE                                  = type TEmptyRec;
  CV_GIMPL_GCOMPILER                                     = type TEmptyRec;
  CV_GIMPL_GISLAND                                       = type TEmptyRec;
  CV_GIMPL_GISLANDEXECUTABLE                             = type TEmptyRec;
  CV_GIMPL_GISLANDEXECUTABLE_IINPUT                      = type TEmptyRec;
  CV_GIMPL_GISLANDEXECUTABLE_IOUTPUT                     = type TEmptyRec;
  CV_GIMPL_GISLANDMODEL                                  = type TEmptyRec;
  CV_GIMPL_GMODEL                                        = type TEmptyRec;
  CV_GIMPL_GMODELBUILDER                                 = type TEmptyRec;
  CV_GIMPL_GMODEL_DETAIL                                 = type TEmptyRec;
  CV_GIMPL_GRUNTIMEARGS                                  = type TEmptyRec;
  CV_GIMPL_MAGAZINE                                      = type TEmptyRec;
  CV_GIMPL_MAGAZINE_CLASS_OF_CV_MAT                      = type TEmptyRec;
  CV_GIMPL_MAGAZINE_HANDLERMAT                           = type TEmptyRec;
  CV_GIMPL_OP                                            = type TEmptyRec;
  CV_GIMPL_PROTO                                         = type TEmptyRec;
  CV_GIMPL_PROTOCOL                                      = type TEmptyRec;
  CV_GIMPL_RCDESC                                        = type TEmptyRec;
  CV_GIMPL_RMATMEDIAFRAMEADAPTER                         = type TEmptyRec;
  CV_GIMPL_SUBGRAPHMATCH                                 = type TEmptyRec;
  CV_GIMPL_UNROLLED                                      = type TEmptyRec;
  CV_GIOPROTOARGS_OF_CV_IN_TAG                           = type TEmptyRec;
  CV_GIOPROTOARGS_OF_CV_OUT_TAG                          = type TEmptyRec;
  CV_GKERNEL                                             = type TEmptyRec;
  CV_GKERNELIMPL                                         = type TEmptyRec;
  CV_GKERNELPACKAGE                                      = type TEmptyRec;
  CV_GMAT                                                = type TEmptyRec;
  CV_GMATDESC                                            = type TEmptyRec;
  CV_GMATP                                               = type TEmptyRec;
  CV_GNODE                                               = type TEmptyRec;
  CV_GOCLCONTEXT                                         = type TEmptyRec;
  CV_GOCLKERNEL                                          = type TEmptyRec;
  CV_GOPAQUEDESC                                         = type TEmptyRec;
  CV_GOPAQUE_OF_BOOL                                     = type TEmptyRec;
  CV_GOPAQUE_OF_CV_POINT__OF_INT                         = type TEmptyRec;
  CV_GOPAQUE_OF_CV_RECT__OF_INT                          = type TEmptyRec;
  CV_GOPAQUE_OF_CV_SIZE__OF_INT                          = type TEmptyRec;
  CV_GOPAQUE_OF_CV_VEC_OF_FLOAT                          = type TEmptyRec;
  CV_GOPAQUE_OF_INT                                      = type TEmptyRec;
  CV_GORIGIN                                             = type TEmptyRec;
  CV_GRUNARG                                             = type TEmptyRec;
  CV_GSCALAR                                             = type TEmptyRec;
  CV_GSCALARDESC                                         = type TEmptyRec;
  CV_GSHAPE                                              = type TEmptyRec;
  CV_GSTREAMINGCOMPILED                                  = type TEmptyRec;
  CV_GSTREAMINGCOMPILED_PRIV                             = type TEmptyRec;
  CV_GTRANSFORM                                          = type TEmptyRec;
  CV_HAL                                                 = type TEmptyRec;
  CV_HAL_DCT2D                                           = type TEmptyRec;
  CV_HAL_DFT1D                                           = type TEmptyRec;
  CV_HAL_DFT2D                                           = type TEmptyRec;
  CV_HAL_FILTER2D                                        = type TEmptyRec;
  CV_HAL_MORPH                                           = type TEmptyRec;
  CV_HAL_SEPFILTER2D                                     = type TEmptyRec;
  CV_HAMMING                                             = type TEmptyRec;
  CV_HANDEYECALIBRATIONMETHOD                            = type TEmptyRec;
  CV_HIGHGUI_BACKEND_UIBACKEND                           = type TEmptyRec;
  CV_HIGHGUI_BACKEND_UITRACKBAR                          = type TEmptyRec;
  CV_HIGHGUI_BACKEND_UIWINDOW                            = type TEmptyRec;
  CV_HIGHGUI_BACKEND_UIWINDOWBASE                        = type TEmptyRec;
  CV_HOGDESCRIPTOR                                       = {$IF Declared(THOGDescriptor)}THOGDescriptor{$ELSE} type TEmptyRec{$IFEND};
  CV_HOGDESCRIPTOR_HISTOGRAMNORMTYPE                     =
{$IF Declared(THOGDescriptor.THistogramNormType)}THOGDescriptor.THistogramNormType{$ELSE} type TEmptyRec{$IFEND};
  CV_IMAGECOLLECTION                    = type TEmptyRec;
  CV_IMAGECOLLECTION_ITERATOR           = type TEmptyRec;
  CV_INSTR                              = type TEmptyRec;
  CV_INSTR_FLAGS                        = type TEmptyRec;
  CV_INSTR_IMPL                         = type TEmptyRec;
  CV_INSTR_NODEDATA                     = type TEmptyRec;
  CV_INSTR_TYPE                         = type TEmptyRec;
  CV_INTERNAL                           = type TEmptyRec;
  CV_INTERNAL_INTRINSICPARAMS           = type TEmptyRec;
  CV_INTERNAL_WRITESTRUCTCONTEXT        = type TEmptyRec;
  CV_INTERPOLATIONFLAGS                 = type TEmptyRec;
  CV_IPP                                = type TEmptyRec;
  CV_KALMANFILTER                       = {$IF Declared(TKalmanFilter)}TKalmanFilter{$ELSE} type TEmptyRec{$IFEND};
  CV_KAZE                               = type TEmptyRec;
  CV_KAZE_DIFFUSIVITYTYPE               = type TEmptyRec;
  CV_KEYPOINT                           = type TEmptyRec;
  CV_KEYPOINTSFILTER                    = type TEmptyRec;
  CV_KMEANSFLAGS                        = type TEmptyRec;
  CV_LDA                                = type TEmptyRec;
  CV_LINEITERATOR                       = type TEmptyRec;
  CV_LINESEGMENTDETECTOR                = type TEmptyRec;
  CV_LMSOLVER                           = type TEmptyRec;
  CV_LMSOLVER_CALLBACK                  = type TEmptyRec;
  CV_MAT                                = {$IF Declared(TMat)}TMat{$ELSE} type TEmptyRec{$IFEND};
  CV_MATALLOCATOR                       = type TEmptyRec;
  CV_MATCONSTITERATOR                   = type TEmptyRec;
  CV_MATEXPR                            = TMatExpr; // type TEmptyRec;
  CV_MATOP                              = type TEmptyRec;
  CV_MATSIZE                            = TMatSize; // type TEmptyRec;
  CV_MATSTEP                            = type TEmptyRec;
  CV_MATX_ADDOP                         = type TEmptyRec;
  CV_MATX_DIVOP                         = type TEmptyRec;
  CV_MATX_MATMULOP                      = type TEmptyRec;
  CV_MATX_MULOP                         = type TEmptyRec;
  CV_MATX_OF_DOUBLE                     = type TEmptyRec;
  CV_MATX_SCALEOP                       = type TEmptyRec;
  CV_MATX_SUBOP                         = type TEmptyRec;
  CV_MATX_TOP                           = type TEmptyRec;
  CV_MAT__OF_FLOAT                      = type TEmptyRec;
  CV_MAT__OF_UNSIGNED_CVCHAR            = type TEmptyRec;
  CV_MEDIAFORMAT                        = type TEmptyRec;
  CV_MEDIAFRAME                         = type TEmptyRec;
  CV_MEDIAFRAME_ACCESS                  = type TEmptyRec;
  CV_MEDIAFRAME_IADAPTER                = type TEmptyRec;
  CV_MEDIAFRAME_VIEW                    = type TEmptyRec;
  CV_MERCATORWARPER                     = type TEmptyRec;
  CV_MERGEDEBEVEC                       = type TEmptyRec;
  CV_MERGEEXPOSURES                     = type TEmptyRec;
  CV_MERGEMERTENS                       = type TEmptyRec;
  CV_MERGEROBERTSON                     = type TEmptyRec;
  CV_MINPROBLEMSOLVER                   = type TEmptyRec;
  CV_MINPROBLEMSOLVER_FUNCTION          = type TEmptyRec;
  CV_ML                                 = type TEmptyRec;
  CV_ML_ANN_MLP                         = {$IF Declared(TANN_MLP)}TANN_MLP{$ELSE} type TEmptyRec{$IFEND};
  CV_ML_BOOST                           = type TEmptyRec;
  CV_ML_DTREES                          = type TEmptyRec;
  CV_ML_DTREES_NODE                     = type TEmptyRec;
  CV_ML_DTREES_SPLIT                    = type TEmptyRec;
  CV_ML_EM                              = type TEmptyRec;
  CV_ML_EMIMPL                          = type TEmptyRec;
  CV_ML_KDTREE                          = type TEmptyRec;
  CV_ML_KNEAREST                        = type TEmptyRec;
  CV_ML_LOGISTICREGRESSION              = type TEmptyRec;
  CV_ML_NORMALBAYESCLASSIFIER           = type TEmptyRec;
  CV_ML_PARAMGRID                       = type TEmptyRec;
  CV_ML_RTREES                          = type TEmptyRec;
  CV_ML_STATMODEL                       = type TEmptyRec;
  CV_ML_SVM                             = type TEmptyRec;
  CV_ML_SVMSGD                          = type TEmptyRec;
  CV_ML_SVM_KERNEL                      = type TEmptyRec;
  CV_ML_TRAINDATA                       = {$IF Declared(TTrainData)}TTrainData{$ELSE} type TEmptyRec{$IFEND};
  CV_MOMENTS                            = type TEmptyRec;
  CV_MORPHTYPES                         = type TEmptyRec;
  CV_MSER                               = type TEmptyRec;
  CV_NARYMATITERATOR                    = type TEmptyRec;
  CV_NODE_OF_CV_INSTR_NODEDATA          = type TEmptyRec;
  CV_OCL                                = type TEmptyRec;
  CV_OCL_CONTEXT                        = type TEmptyRec;
  CV_OCL_CONTEXT_IMPL                   = type TEmptyRec;
  CV_OCL_CONTEXT_USERCONTEXT            = type TEmptyRec;
  CV_OCL_DEVICE                         = type TEmptyRec;
  CV_OCL_DEVICE_IMPL                    = type TEmptyRec;
  CV_OCL_IMAGE2D                        = type TEmptyRec;
  CV_OCL_INTERNAL                       = type TEmptyRec;
  CV_OCL_INTERNAL_PROGRAMENTRY          = type TEmptyRec;
  CV_OCL_KERNEL                         = type TEmptyRec;
  CV_OCL_KERNELARG                      = type TEmptyRec;
  CV_OCL_OCLVECTORSTRATEGY              = type TEmptyRec;
  CV_OCL_OPENCLEXECUTIONCONTEXT         = type TEmptyRec;
  CV_OCL_PLATFORM                       = type TEmptyRec;
  CV_OCL_PLATFORMINFO                   = type TEmptyRec;
  CV_OCL_PLATFORM_IMPL                  = type TEmptyRec;
  CV_OCL_PROGRAM                        = type TEmptyRec;
  CV_OCL_PROGRAMSOURCE                  = type TEmptyRec;
  CV_OCL_PROGRAMSOURCE_IMPL             = type TEmptyRec;
  CV_OCL_PROGRAM_IMPL                   = type TEmptyRec;
  CV_OCL_QUEUE                          = type TEmptyRec;
  CV_OCL_QUEUE_IMPL                     = type TEmptyRec;
  CV_OCL_TIMER                          = type TEmptyRec;
  CV_OGL                                = type TEmptyRec;
  CV_OGL_ARRAYS                         = type TEmptyRec;
  CV_OGL_BUFFER                         = type TEmptyRec;
  CV_OGL_BUFFER_ACCESS                  = type TEmptyRec;
  CV_OGL_BUFFER_TARGET                  = type TEmptyRec;
  CV_OGL_OCL                            = type TEmptyRec;
  CV_OGL_TEXTURE2D                      = type TEmptyRec;
  CV_OGL_TEXTURE2D_FORMAT               = type TEmptyRec;
  CV_ORB                                = type TEmptyRec;
  CV_ORB_SCORETYPE                      = int; // type TEmptyRec;
  CV_PANINIPORTRAITWARPER               = type TEmptyRec;
  CV_PANINIWARPER                       = type TEmptyRec;
  CV_PARALLEL                           = type TEmptyRec;
  CV_PARALLELLOOPBODY                   = type TEmptyRec;
  CV_PARALLEL_PARALLELFORAPI            = type TEmptyRec;
  CV_PARAM                              = type TEmptyRec;
  CV_PCA                                = type TEmptyRec;
  CV_PLANEWARPER                        = type TEmptyRec;
  CV_PLUGIN_IMPL_DYNAMICLIB             = type TEmptyRec;
  CV_POINT3__OF_FLOAT                   = type TEmptyRec;
  CV_POINTSETREGISTRATOR                = type TEmptyRec;
  CV_POINTSETREGISTRATOR_CALLBACK       = type TEmptyRec;
  CV_POINT__OF_DOUBLE                   = TPoint2d; // type TEmptyRec;
  CV_POINT__OF_FLOAT                    = UInt64;   // TPoint2f; // type TEmptyRec;
  CV_POINT__OF_INT                      = UInt64;   // TPoint; // type TEmptyRec;
  CV_POINT__OF___INT64                  = type TEmptyRec;
  CV_PTR_OF_CV_AFFINEFEATURE            = type TEmptyRec;
  CV_PTR_OF_CV_AGASTFEATUREDETECTOR     = type TEmptyRec;
  CV_PTR_OF_CV_AKAZE                    = type TEmptyRec;
  CV_PTR_OF_CV_ALIGNMTB                 = type TEmptyRec;
  CV_PTR_OF_CV_ARUCO_BOARD_IMPL         = type TEmptyRec;
  CV_PTR_OF_CV_BACKGROUNDSUBTRACTORKNN  = {$IF Declared(TPtr_TBackgroundSubtractorKNN)}TPtr_TBackgroundSubtractorKNN{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_BACKGROUNDSUBTRACTORMOG2 = {$IF Declared(TPtr_TBackgroundSubtractorMOG2)}TPtr_TBackgroundSubtractorMOG2{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_BASECASCADECLASSIFIER_MASKGENERATOR = type TEmptyRec;
  CV_PTR_OF_CV_BFMATCHER                      = type TEmptyRec;
  CV_PTR_OF_CV_BRISK                          = type TEmptyRec;
  CV_PTR_OF_CV_CALIBRATEDEBEVEC               = type TEmptyRec;
  CV_PTR_OF_CV_CALIBRATEROBERTSON             = type TEmptyRec;
  CV_PTR_OF_CV_CLAHE                          = {$IF Declared(TCLAHE)}TPtr_CLAHE{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_CONJGRADSOLVER                 = type TEmptyRec;
  CV_PTR_OF_CV_CUDA_EVENT_IMPL                = type TEmptyRec;
  CV_PTR_OF_CV_CUDA_GPUMAT_ALLOCATOR          = type TEmptyRec;
  CV_PTR_OF_CV_CUDA_STREAM_IMPL               = type TEmptyRec;
  CV_PTR_OF_CV_DESCRIPTORMATCHER              = {$IF Declared(TPtr_TDescriptorMatcher)}TPtr_TDescriptorMatcher{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_DETAIL_BESTOF2NEARESTMATCHER   = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_BLENDER                 = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_BUNDLEADJUSTERBASE      = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_ESTIMATOR               = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_EXPOSURECOMPENSATOR     = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_FEATURESMATCHER         = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_ROTATIONWARPER          = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_SEAMFINDER              = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_TIMELAPSER              = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERFEATURE = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERSAMPLERALGORITHM = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERSTATEESTIMATOR = type TEmptyRec;
  CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERTARGETSTATE    = type TEmptyRec;
  CV_PTR_OF_CV_DETECTIONBASEDTRACKER_IDETECTOR       = type TEmptyRec;
  CV_PTR_OF_CV_DISOPTICALFLOW                        = {$IF Declared(TPtr_TDISOpticalFlow)}TPtr_TDISOpticalFlow{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_DNN_DNN_ABSLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ACCUMLAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ACOSHLAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ACOSLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ACTIVATIONLAYER               = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ACTIVATIONLAYERINT8           = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ARGLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ASINHLAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ASINLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ATANHLAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ATANLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_BACKENDNODE                   = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_BASECONVOLUTIONLAYER          = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_BATCHNORMLAYER                = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_BATCHNORMLAYERINT8            = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_BNLLLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_CEILLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_CELULAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_CONCATLAYER                   = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_CORRELATIONLAYER              = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_COSHLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_COSLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_CUMSUMLAYER                   = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_DATAAUGMENTATIONLAYER         = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_DEQUANTIZELAYER               = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_DETECTIONOUTPUTLAYER          = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ELTWISELAYER                  = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ELTWISELAYERINT8              = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ELULAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ERFLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_EXPLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_FLATTENLAYER                  = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_FLOORLAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_FLOWWARPLAYER                 = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_GATHERLAYER                   = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_GRULAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_HARDSIGMOIDLAYER              = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_HARDSWISHLAYER                = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_INNERPRODUCTLAYER             = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_INNERPRODUCTLAYERINT8         = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_LAYER                         = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_LAYER_CV_DNN_DNN_LAYERPARAMS  = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_LOGLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_LRNLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_LSTMLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_MAXUNPOOLLAYER                = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_MISHLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_MVNLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_NARYELTWISELAYER              = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_NORMALIZEBBOXLAYER            = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_NOTLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_PADDINGLAYER                  = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_PERMUTELAYER                  = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_POOLINGLAYER                  = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_POOLINGLAYERINT8              = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_POWERLAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_PRIORBOXLAYER                 = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_PROPOSALLAYER                 = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_QUANTIZELAYER                 = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_RECIPROCALLAYER               = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_REDUCELAYER                   = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_REDUCELAYERINT8               = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_REGIONLAYER                   = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_RELU6LAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_RELULAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_REORGLAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_REQUANTIZELAYER               = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_RESHAPELAYER                  = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_RESIZELAYER                   = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_RNNLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_ROUNDLAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SCALELAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SCALELAYERINT8                = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SCATTERLAYER                  = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SCATTERNDLAYER                = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SELULAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SHRINKLAYER                   = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SIGMOIDLAYER                  = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SIGNLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SINHLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SINLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SLICELAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SOFTMAXLAYER                  = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SOFTMAXLAYERINT8              = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SOFTPLUSLAYER                 = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SOFTSIGNLAYER                 = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SPLITLAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SQRTLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_SWISHLAYER                    = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_TANHLAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_TANLAYER                      = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_THRESHOLDEDRELULAYER          = type TEmptyRec;
  CV_PTR_OF_CV_DNN_DNN_TILELAYER                     = type TEmptyRec;
  CV_PTR_OF_CV_DOWNHILLSOLVER                        = type TEmptyRec;
  CV_PTR_OF_CV_FACEDETECTORYN                        = type TEmptyRec;
  CV_PTR_OF_CV_FACERECOGNIZERSF                      = type TEmptyRec;
  CV_PTR_OF_CV_FARNEBACKOPTICALFLOW                  = type TEmptyRec;
  CV_PTR_OF_CV_FASTFEATUREDETECTOR                   = type TEmptyRec;
  CV_PTR_OF_CV_FEATURE2D                             = type TEmptyRec;
  CV_PTR_OF_CV_FILESTORAGE                           = type TEmptyRec;
  CV_PTR_OF_CV_FILTERENGINE                          = type TEmptyRec;
  CV_PTR_OF_CV_FLANNBASEDMATCHER                     = type TEmptyRec;
  CV_PTR_OF_CV_FLANN_INDEXPARAMS                     = type TEmptyRec;
  CV_PTR_OF_CV_FLANN_SEARCHPARAMS                    = type TEmptyRec;
  CV_PTR_OF_CV_FORMATTER                             = type TEmptyRec;
  CV_PTR_OF_CV_GAPI_WIP_GST_GSTREAMERPIPELINE        = type TEmptyRec;
  CV_PTR_OF_CV_GAPI_WIP_ISTREAMSOURCE                = type TEmptyRec;
  CV_PTR_OF_CV_GENERALIZEDHOUGHBALLARD               = type TEmptyRec;
  CV_PTR_OF_CV_GENERALIZEDHOUGHGUIL                  = type TEmptyRec;
  CV_PTR_OF_CV_GFTTDETECTOR                          = type TEmptyRec;
  CV_PTR_OF_CV_HAL_DCT2D                             = type TEmptyRec;
  CV_PTR_OF_CV_HAL_DFT1D                             = type TEmptyRec;
  CV_PTR_OF_CV_HAL_DFT2D                             = type TEmptyRec;
  CV_PTR_OF_CV_HAL_FILTER2D                          = type TEmptyRec;
  CV_PTR_OF_CV_HAL_MORPH                             = type TEmptyRec;
  CV_PTR_OF_CV_HAL_SEPFILTER2D                       = type TEmptyRec;
  CV_PTR_OF_CV_IMAGECOLLECTION_IMPL                  = type TEmptyRec;
  CV_PTR_OF_CV_KAZE                                  = type TEmptyRec;
  CV_PTR_OF_CV_LINESEGMENTDETECTOR                   = type TEmptyRec;
  CV_PTR_OF_CV_LMSOLVER                              = type TEmptyRec;
  CV_PTR_OF_CV_LMSOLVER_CALLBACK                     = type TEmptyRec;
  CV_PTR_OF_CV_MERGEDEBEVEC                          = type TEmptyRec;
  CV_PTR_OF_CV_MERGEMERTENS                          = type TEmptyRec;
  CV_PTR_OF_CV_MERGEROBERTSON                        = type TEmptyRec;
  CV_PTR_OF_CV_MINPROBLEMSOLVER_FUNCTION             = type TEmptyRec;
  CV_PTR_OF_CV_ML_ANN_MLP                            = {$IF Declared(TPtr_TANN_MLP)}TPtr_TANN_MLP{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_ML_BOOST                              = type TEmptyRec;
  CV_PTR_OF_CV_ML_DTREES                             = type TEmptyRec;
  CV_PTR_OF_CV_ML_EM                                 = type TEmptyRec;
  CV_PTR_OF_CV_ML_KNEAREST                           = type TEmptyRec;
  CV_PTR_OF_CV_ML_LOGISTICREGRESSION                 = type TEmptyRec;
  CV_PTR_OF_CV_ML_NORMALBAYESCLASSIFIER              = type TEmptyRec;
  CV_PTR_OF_CV_ML_PARAMGRID                          = type TEmptyRec;
  CV_PTR_OF_CV_ML_RTREES                             = type TEmptyRec;
  CV_PTR_OF_CV_ML_SVM                                = {$IF Declared(TPtr_TSVM_pT)}TPtr_TSVM_pT{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_ML_SVMSGD                             = type TEmptyRec;
  CV_PTR_OF_CV_ML_TRAINDATA                          = {$IF Declared(TPtr_TTrainData)}TPtr_TTrainData{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_MSER                                  = type TEmptyRec;
  CV_PTR_OF_CV_ORB                                   = {$IF Declared(TPtr_TFeature2D)}TPtr_TFeature2D{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_POINTSETREGISTRATOR                   = type TEmptyRec;
  CV_PTR_OF_CV_POINTSETREGISTRATOR_CALLBACK          = type TEmptyRec;
  CV_PTR_OF_CV_QRCODEENCODER                         = type TEmptyRec;
  CV_PTR_OF_CV_SIFT                                  = {$IF Declared(TPtr_TFeature2D)}TPtr_TFeature2D{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_SIMPLEBLOBDETECTOR                    = {$IF Declared(TSimpleBlobDetector)}TPtr<TSimpleBlobDetector>{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_SPARSEPYRLKOPTICALFLOW                = type TEmptyRec;
  CV_PTR_OF_CV_STEREOBM                              = type TEmptyRec;
  CV_PTR_OF_CV_STEREOSGBM                            = type TEmptyRec;
  CV_PTR_OF_CV_STITCHER                              = {$IF Declared(TPtr_TStitcher_pT)}TPtr_TStitcher_pT{$ELSE} type TEmptyRec{$IFEND};
  CV_PTR_OF_CV_TONEMAP                               = type TEmptyRec;
  CV_PTR_OF_CV_TONEMAPDRAGO                          = type TEmptyRec;
  CV_PTR_OF_CV_TONEMAPMANTIUK                        = type TEmptyRec;
  CV_PTR_OF_CV_TONEMAPREINHARD                       = type TEmptyRec;
  CV_PTR_OF_CV_TRACKERDASIAMRPN                      = type TEmptyRec;
  CV_PTR_OF_CV_TRACKERGOTURN                         = type TEmptyRec;
  CV_PTR_OF_CV_TRACKERMIL                            = type TEmptyRec;
  CV_PTR_OF_CV_TRACKERNANO                           = type TEmptyRec;
  CV_PTR_OF_CV_UTILS_NESTED_ORIGINALCLASSNAME        = type TEmptyRec;
  CV_PTR_OF_CV_VARIATIONALREFINEMENT                 = type TEmptyRec;
  CV_PTR_OF_CV_VIDEOINPUTSTREAM                      = type TEmptyRec;
  CV_PTR_OF_CV_WARPERCREATOR                         = type TEmptyRec;
  CV_PTR_OF_FLOAT                                    = type TEmptyRec;
  CV_PYROTATIONWARPER                                = type TEmptyRec;
  CV_QRCODEDETECTOR                                  = {$IF Declared(TQRCodeDetector)}TQRCodeDetector{$ELSE} type TEmptyRec{$IFEND};
  CV_QRCODEENCODER                                   = type TEmptyRec;
  CV_QRCODEENCODER_PARAMS                            = type TEmptyRec;
  CV_QTFONT                                          = type TEmptyRec;
  CV_RANGE                                           = TRange; // type TEmptyRec;
  CV_RECT__OF_DOUBLE                                 = type TEmptyRec;
  CV_RECT__OF_FLOAT                                  = type TEmptyRec;
  CV_RECT__OF_INT                                    = TRect; // type TEmptyRec;
  CV_RETRIEVALMODES                                  = type TEmptyRec;
  CV_RIFFCHUNK                                       = type TEmptyRec;
  CV_RIFFLIST                                        = type TEmptyRec;
  CV_RMAT                                            = type TEmptyRec;
  CV_RMAT_ACCESS                                     = type TEmptyRec;
  CV_RMAT_VIEW                                       = type TEmptyRec;
  CV_RNG                                             = TRNG; // type TEmptyRec;
  CV_RNG_MT19937                                     = type TEmptyRec;
  CV_ROBOTWORLDHANDEYECALIBRATIONMETHOD              = type TEmptyRec;
  CV_ROTATEDRECT                                     = TRotatedRect; // type TEmptyRec;
  CV_SAMPLES                                         = type TEmptyRec;
  CV_SCALAR__OF_DOUBLE                               = TScalar; // type TEmptyRec;
  CV_SEGMENTATION_INTELLIGENTSCISSORSMB              = {$IF Declared(TIntelligentScissorsMB)}TIntelligentScissorsMB{$ELSE} type TEmptyRec{$IFEND};
  CV_SEGMENTATION_INTELLIGENTSCISSORSMB_IMPL         = type TEmptyRec;
  CV_SIFT                                            = type TEmptyRec;
  CV_SIMILARRECTS                                    = type TEmptyRec;
  CV_SIMPLEBLOBDETECTOR                              = {$IF Declared(TSimpleBlobDetector)}TSimpleBlobDetector{$ELSE} type TEmptyRec{$IFEND};
  CV_SIMPLEBLOBDETECTORIMPL                          = type TEmptyRec;
  CV_SIMPLEBLOBDETECTORIMPL_CENTER                   = type TEmptyRec;
  CV_SIMPLEBLOBDETECTOR_PARAMS                       = {$IF Declared(TSimpleBlobDetector)}TSimpleBlobDetector.TParams{$ELSE} type TEmptyRec{$IFEND};
  CV_SIZE__OF_DOUBLE                                 = type TEmptyRec;
  CV_SIZE__OF_FLOAT                                  = type TEmptyRec;
  CV_SIZE__OF_INT                                    = UInt64; // type TEmptyRec;
  CV_SIZE__OF___INT64                                = type TEmptyRec;
  CV_SOFTDOUBLE                                      = type TEmptyRec;
  CV_SOFTFLOAT                                       = type TEmptyRec;
  CV_SOLVEPNPMETHOD                                  = type TEmptyRec;
  CV_SPARSEMAT                                       = type TEmptyRec;
  CV_SPARSEMATCONSTITERATOR                          = type TEmptyRec;
  CV_SPARSEMATITERATOR                               = type TEmptyRec;
  CV_SPARSEMAT_HDR                                   = type TEmptyRec;
  CV_SPARSEMAT_NODE                                  = type TEmptyRec;
  CV_SPARSEOPTICALFLOW                               = type TEmptyRec;
  CV_SPARSEPYRLKOPTICALFLOW                          = type TEmptyRec;
  CV_SPHERICALWARPER                                 = type TEmptyRec;
  CV_STEREOBM                                        = type TEmptyRec;
  CV_STEREOGRAPHICWARPER                             = type TEmptyRec;
  CV_STEREOMATCHER                                   = type TEmptyRec;
  CV_STEREOSGBM                                      = type TEmptyRec;
  CV_STITCHER                                        = {$IF Declared(TStitcher)}TStitcher{$ELSE} type TEmptyRec{$IFEND};
  CV_STITCHER_MODE                                   = {$IF Declared(TStitcher)}TStitcher.mode{$ELSE} type TEmptyRec{$IFEND};
  CV_STITCHER_STATUS                                 = {$IF Declared(TStitcher)}TStitcher.Status{$ELSE} type TEmptyRec{$IFEND};
  CV_STREAMTYPE                                      = type TEmptyRec;
  CV_SUBDIV2D                                        = {$IF Declared(TSubdiv2D)}TSubdiv2D{$ELSE} type TEmptyRec{$IFEND};
  CV_SUBDIV2D_QUADEDGE                               = type TEmptyRec;
  CV_SUBDIV2D_VERTEX                                 = type TEmptyRec;
  _CV_SVD                                            = type TEmptyRec;
  // CV_TERMCRITERIA                                          = type TEmptyRec;
  CV_TICKMETER                                             = type TEmptyRec;
  CV_TLSDATACONTAINER                                      = type TEmptyRec;
  CV_TONEMAP                                               = type TEmptyRec;
  CV_TONEMAPDRAGO                                          = type TEmptyRec;
  CV_TONEMAPMANTIUK                                        = type TEmptyRec;
  CV_TONEMAPREINHARD                                       = type TEmptyRec;
  CV_TRACKER                                               = type TEmptyRec;
  CV_TRACKERDASIAMRPN                                      = type TEmptyRec;
  CV_TRACKERDASIAMRPN_PARAMS                               = type TEmptyRec;
  CV_TRACKERGOTURN                                         = type TEmptyRec;
  CV_TRACKERGOTURN_PARAMS                                  = type TEmptyRec;
  CV_TRACKERMIL                                            = type TEmptyRec;
  CV_TRACKERMIL_PARAMS                                     = type TEmptyRec;
  CV_TRACKERNANO                                           = type TEmptyRec;
  CV_TRACKERNANO_PARAMS                                    = type TEmptyRec;
  CV_TRANSVERSEMERCATORWARPER                              = type TEmptyRec;
  CV_UMAT                                                  = type TEmptyRec;
  CV_UMATDATA                                              = type TEmptyRec;
  CV_UMATDATAAUTOLOCK                                      = type TEmptyRec;
  CV_UMATUSAGEFLAGS                                        = type TEmptyRec;
  CV_UNDISTORTTYPES                                        = type TEmptyRec;
  CV_USACPARAMS                                            = type TEmptyRec;
  CV_UTILS                                                 = type TEmptyRec;
  CV_UTILS_ALLOCATORSTATISTICSINTERFACE                    = type TEmptyRec;
  CV_UTILS_BUFFERAREA                                      = type TEmptyRec;
  CV_UTILS_CLASSWITHKEYWORDPROPERTIES                      = type TEmptyRec;
  CV_UTILS_FS                                              = type TEmptyRec;
  CV_UTILS_FS_FILELOCK                                     = type TEmptyRec;
  CV_UTILS_LOGGING                                         = type TEmptyRec;
  CV_UTILS_LOGGING_INTERNAL                                = type TEmptyRec;
  CV_UTILS_LOGGING_LOGLEVEL                                = type TEmptyRec;
  CV_UTILS_LOGGING_LOGTAG                                  = type TEmptyRec;
  CV_UTILS_NESTED_ORIGINALCLASSNAME                        = type TEmptyRec;
  CV_UTILS_NESTED_ORIGINALCLASSNAME_PARAMS                 = type TEmptyRec;
  CV_UTILS_TRACE_DETAILS                                   = type TEmptyRec;
  CV_UTILS_TRACE_DETAILS_REGION                            = type TEmptyRec;
  CV_UTILS_TRACE_DETAILS_REGION_LOCATIONSTATICSTORAGE      = type TEmptyRec;
  CV_UTILS_TRACE_DETAILS_TRACEARG                          = type TEmptyRec;
  CV_UTILS_TRACE_DETAILS_TRACEMANAGER                      = type TEmptyRec;
  CV_UTIL_ANY                                              = type TEmptyRec;
  CV_UTIL_MONOSTATE                                        = type TEmptyRec;
  CV_UTIL_OPTIONAL_OF_CV_GAPI_FLUID_BORDER                 = type TEmptyRec;
  CV_UTIL_OPTIONAL_OF_CV_GAPI_WIP_PP_PARAMS                = type TEmptyRec;
  CV_UTIL_OPTIONAL_OF_CV_RECT__OF_INT                      = type TEmptyRec;
  CV_UTIL_OPTIONAL_OF_STD_BASIC_STRING_OF_CVCHAR           = type TEmptyRec;
  CV_UTIL_VARIANT_OF_CV_GMAT                               = type TEmptyRec;
  CV_UTIL_VARIANT_OF_CV_UMAT                               = type TEmptyRec;
  CV_UTIL_VARIANT_OF_CV_UTIL_MONOSTATE                     = type TEmptyRec;
  CV_UTIL_VARIANT_OF_PCV_UMAT                              = type TEmptyRec;
  CV_UTIL_VARIANT_OF_UNSIGNED_CVCHAR                       = type TEmptyRec;
  CV_VARIATIONALREFINEMENT                                 = type TEmptyRec;
  CV_VA_INTEL                                              = type TEmptyRec;
  CV_VA_INTEL_OCL                                          = type TEmptyRec;
  CV_VEC_OF_DOUBLE                                         = type TEmptyRec;
  CV_VEC_OF_INT                                            = type TEmptyRec;
  CV_VIDEOCAPTURE                                          = {$IF Declared(TVideoCapture)}TVideoCapture{$ELSE} type TEmptyRec{$IFEND};
  CV_VIDEOCAPTUREAPIS                                      = type TEmptyRec;
  CV_VIDEOIO_REGISTRY                                      = type TEmptyRec;
  CV_VIDEOWRITER                                           = {$IF Declared(TVideoWriter)}TVideoWriter{$ELSE} type TEmptyRec{$IFEND};
  CV_WARPERCREATOR                                         = type TEmptyRec;
  CV__INPUTARRAY                                           = TInputArray; // type TEmptyRec;
  CV__INPUTARRAY_KINDFLAG                                  = type TEmptyRec;
  CV__INPUTOUTPUTARRAY                                     = TInputOutputArray; // type TEmptyRec;
  CV__OUTPUTARRAY                                          = TOutputArray; // type TEmptyRec;
  CV__OUTPUTARRAY_DEPTHMASK                                = type TEmptyRec;
  ID3D10DEVICE                                             = type TEmptyRec;
  ID3D10TEXTURE2D                                          = type TEmptyRec;
  ID3D11DEVICE                                             = type TEmptyRec;
  ID3D11TEXTURE2D                                          = type TEmptyRec;
  IDIRECT3DDEVICE9                                         = type TEmptyRec;
  IDIRECT3DDEVICE9EX                                       = type TEmptyRec;
  IDIRECT3DSURFACE9                                        = type TEmptyRec;
  SIGNED_CVCHAR                                            = schar; // type TEmptyRec;
  STD_ARRAY_OF_PSTD__ALIGN_TYPE_OF_DOUBLE                  = type TEmptyRec;
  STD_ARRAY_OF_PVOID                                       = type TEmptyRec;
  STD_ARRAY_OF_UNSIGNED___INT64                            = type TEmptyRec;
  STD_BASIC_OSTREAM_OF_CVCHAR                              = type TEmptyRec;
  STD_BASIC_STRING_OF_CVCHAR                               = CppString; // type TEmptyRec;
  STD_BASIC_STRING_OF_WCHAR_T                              = type TEmptyRec;
  STD_DEQUE_OF_STD_PAIR_OF_UNSIGNED___INT64                = type TEmptyRec;
  STD_EXCEPTION_PTR                                        = type TEmptyRec;
  STD_FUNCTION_OF_CV_GARG                                  = type TEmptyRec;
  STD_FUNCTION_OF_CV_GCOMPUTATION                          = type TEmptyRec;
  STD_FUNCTION_OF_CV_GMATDESC                              = type TEmptyRec;
  STD_FUNCTION_OF_CV_MAT                                   = type TEmptyRec;
  STD_FUNCTION_OF_CV_UTIL_OPTIONAL_OF_CV_GAPI_FLUID_BORDER = type TEmptyRec;
  STD_FUNCTION_OF_INT                                      = type TEmptyRec;
  STD_FUNCTION_OF_STD_VECTOR_OF_CV_GRUNARG                 = type TEmptyRec;
  STD_FUNCTION_OF_STD_VECTOR_OF_CV_UTIL_VARIANT_OF_CV_UTIL_MONOSTATE = type TEmptyRec;
  STD_FUNCTION_OF_VOID                            = type TEmptyRec;
  STD_FUTURE_OF_VOID                              = type TEmptyRec;
  STD_INITIALIZER_LIST_OF_CV_GAPI_GNETPARAM       = type TEmptyRec;
  STD_PAIR_OF_CV_GAPI_GBACKEND                    = type TEmptyRec;
  STD_PAIR_OF_INT                                 = type TEmptyRec;
  STD_RECURSIVE_MUTEX                             = type TEmptyRec;
  STD_SHARED_PTR_OF_CV_GAPI_GBACKEND_PRIV         = type TEmptyRec;
  STD_SHARED_PTR_OF_CV_GAPI_WIP_DRAW_FTTEXTRENDER = type TEmptyRec;
  STD_SHARED_PTR_OF_CV_GAPI_WIP_GST_GSTREAMERPIPELINEFACADE = type TEmptyRec;
  STD_SHARED_PTR_OF_CV_GAPI_WIP_ISTREAMSOURCE        = type TEmptyRec;
  STD_SHARED_PTR_OF_CV_GAPI_WIP_ONEVPL_IDATAPROVIDER = type TEmptyRec;
  STD_SHARED_PTR_OF_CV_GAPI_WIP_ONEVPL_IDATAPROVIDER_MFX_BITSTREAM = type TEmptyRec;
  STD_SHARED_PTR_OF_CV_GAPI_WIP_ONEVPL_IDEVICESELECTOR     = type TEmptyRec;
  STD_SHARED_PTR_OF_CV_OCL_CONTEXT_USERCONTEXT             = type TEmptyRec;
  STD_SHARED_PTR_OF_CV_PARALLEL_PARALLELFORAPI             = type TEmptyRec;
  STD_SHARED_PTR_OF_CV_RMAT_IADAPTER                       = type TEmptyRec;
  STD_TUPLE_OF_BOOL                                        = type TEmptyRec;
  STD_TUPLE_OF_CV_GARRAY_OF_CV_GARRAY_OF_CV_POINT__OF_INT  = type TEmptyRec;
  STD_TUPLE_OF_CV_GARRAY_OF_CV_GMAT                        = type TEmptyRec;
  STD_TUPLE_OF_CV_GARRAY_OF_CV_POINT__OF_FLOAT             = type TEmptyRec;
  STD_TUPLE_OF_CV_GARRAY_OF_CV_RECT__OF_INT                = type TEmptyRec;
  STD_TUPLE_OF_CV_GMAT                                     = type TEmptyRec;
  STD_TUPLE_OF_CV_GOPAQUE_OF_DOUBLE                        = type TEmptyRec;
  STD_TUPLE_OF_STD_VECTOR_OF_CV_GIMPL_RCDESC               = type TEmptyRec;
  STD_TYPE_INDEX                                           = type TEmptyRec;
  STD_UNIQUE_PTR_OF_ADE_GRAPH                              = type TEmptyRec;
  STD_UNIQUE_PTR_OF_CV_GAPI_FLUID_VIEW_PRIV                = type TEmptyRec;
  STD_UNIQUE_PTR_OF_CV_GAPI_S11N_IISTREAM                  = type TEmptyRec;
  STD_UNIQUE_PTR_OF_CV_GAPI_WIP_GST_GSTREAMERPIPELINE_PRIV = type TEmptyRec;
  STD_UNIQUE_PTR_OF_CV_GAPI_WIP_GST_GSTREAMERSOURCE_PRIV   = type TEmptyRec;
  STD_UNIQUE_PTR_OF_CV_GAPI_WIP_ONEVPL_GSOURCE_PRIV        = type TEmptyRec;
  STD_UNIQUE_PTR_OF_CV_GIMPL_GABSTRACTEXECUTOR             = type TEmptyRec;
  STD_UNIQUE_PTR_OF_CV_GIMPL_GABSTRACTSTREAMINGEXECUTOR    = type TEmptyRec;
  STD_UNIQUE_PTR_OF_CV_GIMPL_GISLANDEXECUTABLE             = type TEmptyRec;
  STD_UNIQUE_PTR_OF_CV_MEDIAFRAME_IADAPTER                 = type TEmptyRec;
  STD_UNORDERED_SET_OF_ADE_HANDLE_OF_ADE_NODE              = type TEmptyRec;
  STD_VECTOR_OF_ADE_HANDLE_OF_ADE_EDGE                     = type TEmptyRec;
  STD_VECTOR_OF_ADE_HANDLE_OF_ADE_NODE                     = type TEmptyRec;
  STD_VECTOR_OF_BOOL                                       = type TEmptyRec;
  STD_VECTOR_OF_CVCHAR                                     = type TEmptyRec;
  STD_VECTOR_OF_CV_CUDA_GPUMAT                             = type TEmptyRec;
  STD_VECTOR_OF_CV_DETAIL_CAMERAPARAMS                     = type TEmptyRec;
  STD_VECTOR_OF_CV_DETAIL_IMAGEFEATURES                    = type TEmptyRec;
  STD_VECTOR_OF_CV_DETAIL_MATCHESINFO                      = type TEmptyRec;
  STD_VECTOR_OF_CV_DETECTIONBASEDTRACKER_EXTOBJECT         = type TEmptyRec;
  STD_VECTOR_OF_CV_DETECTIONROI                            = type TEmptyRec;
  STD_VECTOR_OF_CV_DMATCH                                  = type TEmptyRec;
  STD_VECTOR_OF_CV_DNN_DNN_TARGET                          = type TEmptyRec;
  STD_VECTOR_OF_CV_FLANN_FLANNINDEXTYPE                    = type TEmptyRec;
  STD_VECTOR_OF_CV_GAPI_GBACKEND                           = type TEmptyRec;
  STD_VECTOR_OF_CV_GAPI_GNETPARAM                          = type TEmptyRec;
  STD_VECTOR_OF_CV_GAPI_OWN_MAT                            = type TEmptyRec;
  STD_VECTOR_OF_CV_GAPI_WIP_ONEVPL_CFGPARAM                = type TEmptyRec;
  STD_VECTOR_OF_CV_GARG                                    = type TEmptyRec;
  STD_VECTOR_OF_CV_GCOMPILEARG                             = type TEmptyRec;
  STD_VECTOR_OF_CV_GIMPL_DATA                              = type TEmptyRec;
  STD_VECTOR_OF_CV_GMAT                                    = type TEmptyRec;
  STD_VECTOR_OF_CV_GRUNARG                                 = type TEmptyRec;
  STD_VECTOR_OF_CV_GTRANSFORM                              = type TEmptyRec;
  STD_VECTOR_OF_CV_GTYPEINFO                               = type TEmptyRec;
  STD_VECTOR_OF_CV_KEYPOINT                                = type TEmptyRec;
  STD_VECTOR_OF_CV_MAT                                     = vector<TMat>; // type TEmptyRec;
  STD_VECTOR_OF_CV_MOMENTS                                 = type TEmptyRec;
  STD_VECTOR_OF_CV_OCL_PLATFORMINFO                        = type TEmptyRec;
  STD_VECTOR_OF_CV_POINT3__OF_FLOAT                        = type TEmptyRec;
  STD_VECTOR_OF_CV_POINT__OF_DOUBLE                        = type TEmptyRec;
  STD_VECTOR_OF_CV_POINT__OF_FLOAT                         = vector<TPoint2f>; // type TEmptyRec;
  STD_VECTOR_OF_CV_POINT__OF_INT                           = type TEmptyRec;
  STD_VECTOR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERFEATURE = type TEmptyRec;
  STD_VECTOR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERSAMPLERALGORITHM = type TEmptyRec;
  STD_VECTOR_OF_CV_PTR_OF_CV_DNN_DNN_BACKENDNODE = type TEmptyRec;
  STD_VECTOR_OF_CV_PTR_OF_CV_DNN_DNN_BACKENDWRAPPER      = type TEmptyRec;
  STD_VECTOR_OF_CV_PTR_OF_CV_DNN_DNN_LAYER               = type TEmptyRec;
  STD_VECTOR_OF_CV_RANGE                                 = type TEmptyRec;
  STD_VECTOR_OF_CV_RECT__OF_DOUBLE                       = type TEmptyRec;
  STD_VECTOR_OF_CV_RECT__OF_INT                          = vector<TRect>; // type TEmptyRec;
  STD_VECTOR_OF_CV_ROTATEDRECT                           = type TEmptyRec;
  STD_VECTOR_OF_CV_SCALAR__OF_DOUBLE                     = type TEmptyRec;
  STD_VECTOR_OF_CV_SIMPLEBLOBDETECTORIMPL_CENTER         = type TEmptyRec;
  STD_VECTOR_OF_CV_SIZE__OF_INT                          = type TEmptyRec;
  STD_VECTOR_OF_CV_UMAT                                  = type TEmptyRec;
  STD_VECTOR_OF_CV_UTIL_VARIANT_OF_CV_GAPI_WIP_DRAW_TEXT = type TEmptyRec;
  STD_VECTOR_OF_CV_UTIL_VARIANT_OF_CV_GMAT               = type TEmptyRec;
  STD_VECTOR_OF_CV_UTIL_VARIANT_OF_CV_UTIL_MONOSTATE     = type TEmptyRec;
  STD_VECTOR_OF_CV_UTIL_VARIANT_OF_PCV_UMAT              = type TEmptyRec;
  STD_VECTOR_OF_CV_UTIL_VARIANT_OF_PCV_UTIL_OPTIONAL_OF_CV_MAT = type TEmptyRec;
  STD_VECTOR_OF_CV_VEC_OF_FLOAT                = vector<TVec6f>; // type TEmptyRec;
  STD_VECTOR_OF_CV_VIDEOCAPTURE                = type TEmptyRec;
  STD_VECTOR_OF_CV_VIDEOCAPTUREAPIS            = type TEmptyRec;
  STD_VECTOR_OF_DOUBLE                         = vector<Double>; // type TEmptyRec;
  STD_VECTOR_OF_FLOAT                          = vector<float>; // type TEmptyRec;
  STD_VECTOR_OF_INT                            = vector<int>; // type TEmptyRec;
  STD_VECTOR_OF_PCV_MAT                        = type TEmptyRec;
  STD_VECTOR_OF_PVOID                          = type TEmptyRec;
  STD_VECTOR_OF_STD_BASIC_STRING_OF_CVCHAR     = vector<CppString>; // type TEmptyRec;
  STD_VECTOR_OF_STD_PAIR_OF_CV_DNN_DNN_BACKEND = type TEmptyRec;
  STD_VECTOR_OF_STD_PAIR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERTARGETSTATE = type TEmptyRec;
  STD_VECTOR_OF_STD_PAIR_OF_CV_RECT__OF_INT       = type TEmptyRec;
  STD_VECTOR_OF_STD_PAIR_OF_CV_UMAT               = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_CVCHAR              = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_CV_DMATCH           = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_CV_KEYPOINT         = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_CV_MAT              = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_CV_POINT3__OF_FLOAT = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_CV_POINT__OF_FLOAT  = vector<vector<TPoint2f>>; // type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_CV_POINT__OF_INT    = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_FLOAT               = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_INT                 = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_STD_VECTOR_OF_INT   = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_UNSIGNED_CVCHAR     = type TEmptyRec;
  STD_VECTOR_OF_UNSIGNED_CVCHAR                   = vector<uchar>; // type TEmptyRec;
  STD_VECTOR_OF_UNSIGNED___INT64                  = type TEmptyRec;
  STD_VECTOR_OF_STD_VECTOR_OF_STD_PAIR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERTARGETSTATE = type TEmptyRec;
  STD__DEQUE_ITERATOR_OF_STD__DEQUE_VAL_OF_STD__DEQUE_SIMPLE_TYPES_OF_STD_PAIR_OF_UNSIGNED___INT64 = type TEmptyRec;
  STD__TREE_CONST_ITERATOR_OF_STD__TREE_VAL_OF_STD__TREE_SIMPLE_TYPES_OF_STD_PAIR_OF_STD_BASIC_STRING_OF_CVCHAR = type TEmptyRec;
  STD__VB_REFERENCE_OF_STD__WRAP_ALLOC_OF_STD_ALLOCATOR_OF_UNSIGNED_INT = type TEmptyRec;
  STEREOSETUP = type TEmptyRec;
  VOID__CV_CUDA_STREAM__VOID           = type TEmptyRec;
  CV_IPLIMAGE                          = {$IF Declared(_IPLIMAGE)}_IPLIMAGE{$ELSE} type TEmptyRec{$IFEND};
  pCV_GENERALIZEDHOUGH                 = ^CV_GENERALIZEDHOUGH;
  pCV_DNN_DNN_LAYERFACTORY             = ^CV_DNN_DNN_LAYERFACTORY;
  pCV_GAPI_WIP_DRAW_RECT               = ^CV_GAPI_WIP_DRAW_RECT;
  pCV_CVSEQ                            = ^CV_CVSEQ;
  pCV_DNN_DNN_INNERPRODUCTLAYERINT8    = ^CV_DNN_DNN_INNERPRODUCTLAYERINT8;
  pCV_DNN_DNN_ATANLAYER                = ^CV_DNN_DNN_ATANLAYER;
  pCV_CALIBRATEDEBEVEC                 = ^CV_CALIBRATEDEBEVEC;
  pCV__INPUTARRAY                      = ^CV__INPUTARRAY;
  pCV_QRCODEENCODER_PARAMS             = ^CV_QRCODEENCODER_PARAMS;
  pCV_HIGHGUI_BACKEND_UITRACKBAR       = ^CV_HIGHGUI_BACKEND_UITRACKBAR;
  pCV_MEDIAFRAME                       = ^CV_MEDIAFRAME;
  pCV_GMAT                             = ^CV_GMAT;
  pCV_DNN_DNN_NET_IMPL                 = ^CV_DNN_DNN_NET_IMPL;
  pCV_VIDEOCAPTURE                     = ^CV_VIDEOCAPTURE;
  pCV_SPARSEMAT_HDR                    = ^CV_SPARSEMAT_HDR;
  pCV_DETAIL_GRAPHCUTSEAMFINDER        = ^CV_DETAIL_GRAPHCUTSEAMFINDER;
  pCV_SPARSEMATCONSTITERATOR           = ^CV_SPARSEMATCONSTITERATOR;
  pCV_UTIL_VARIANT_OF_CV_UMAT          = ^CV_UTIL_VARIANT_OF_CV_UMAT;
  pCV_ROTATEDRECT                      = ^CV_ROTATEDRECT;
  pCV_DNN_DNN_ACOSLAYER                = ^CV_DNN_DNN_ACOSLAYER;
  pCV_GAPI_CALIB3D_CPU_STEREOINITPARAM = ^CV_GAPI_CALIB3D_CPU_STEREOINITPARAM;
  pCV_FLANNBASEDMATCHER                = ^CV_FLANNBASEDMATCHER;
  pCV_DETAIL_FEATURESMATCHER           = ^CV_DETAIL_FEATURESMATCHER;
  pCV_DETAIL_MERCATORWARPER            = ^CV_DETAIL_MERCATORWARPER;
  pCV_IMAGECOLLECTION_ITERATOR         = ^CV_IMAGECOLLECTION_ITERATOR;
  pCV_FACERECOGNIZERSF                 = ^CV_FACERECOGNIZERSF;
  pCV_ML_PARAMGRID                     = ^CV_ML_PARAMGRID;
  pCV_SPARSEPYRLKOPTICALFLOW           = ^CV_SPARSEPYRLKOPTICALFLOW;
  pCV_MATX_MATMULOP                    = ^CV_MATX_MATMULOP;
  pCV_GARRAYDESC                       = ^CV_GARRAYDESC;
  pCV_DNN_DNN_SIGNLAYER                = ^CV_DNN_DNN_SIGNLAYER;
  pCV_GAPI_WIP_DRAW_POLY               = ^CV_GAPI_WIP_DRAW_POLY;
  pCV_DNN_DNN_INNERPRODUCTLAYER        = ^CV_DNN_DNN_INNERPRODUCTLAYER;
  pCV_GCALL_PRIV                       = ^CV_GCALL_PRIV;
  pCV_SOFTFLOAT                        = ^CV_SOFTFLOAT;
  pCV_OCL_PROGRAM_IMPL                 = ^CV_OCL_PROGRAM_IMPL;
  pCV_ML_TRAINDATA                     = ^CV_ML_TRAINDATA;
  pCV_DETAIL_BLENDER                   = ^CV_DETAIL_BLENDER;
  pCV_DNN_DNN_CONCATLAYER              = ^CV_DNN_DNN_CONCATLAYER;
  pCV_GAPI_FLUID_BUFFER                = ^CV_GAPI_FLUID_BUFFER;
  pCV_DNN_DNN_BATCHNORMLAYER           = ^CV_DNN_DNN_BATCHNORMLAYER;
  pCV_ARUCO_DICTIONARY                 = ^CV_ARUCO_DICTIONARY;
  pCV_DETAIL_VECTORREF                 = ^CV_DETAIL_VECTORREF;
  pCV_SVD                              = ^_CV_SVD;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PANINIPORTRAITPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PANINIPORTRAITPROJECTOR;
  pCV_DNN_DNN_SQRTLAYER           = ^CV_DNN_DNN_SQRTLAYER;
  pCV_DNN_DNN_FLOWWARPLAYER       = ^CV_DNN_DNN_FLOWWARPLAYER;
  pCV_ML_EM                       = ^CV_ML_EM;
  pCV_DETAIL_BUNDLEADJUSTERREPROJ = ^CV_DETAIL_BUNDLEADJUSTERREPROJ;
  pCV_KAZE                        = ^CV_KAZE;
  pCV_ALGORITHM                   = ^CV_ALGORITHM;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_CYLINDRICALPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_CYLINDRICALPROJECTOR;
  pCV_DETAIL_COMPRESSEDRECTILINEARPORTRAITWARPER = ^CV_DETAIL_COMPRESSEDRECTILINEARPORTRAITWARPER;
  pCV_OGL_ARRAYS                                 = ^CV_OGL_ARRAYS;
  pCV_DNN_DNN_MISHLAYER                          = ^CV_DNN_DNN_MISHLAYER;
  pCV_LINESEGMENTDETECTOR                        = ^CV_LINESEGMENTDETECTOR;
  pCV_PARALLELLOOPBODY                           = ^CV_PARALLELLOOPBODY;
  pCV_GIMPL_GISLAND                              = ^CV_GIMPL_GISLAND;
  pCV_TRANSVERSEMERCATORWARPER                   = ^CV_TRANSVERSEMERCATORWARPER;
  pCV_GAPI_GBACKEND_PRIV                         = ^CV_GAPI_GBACKEND_PRIV;
  pCV_TRACKERMIL_PARAMS                          = ^CV_TRACKERMIL_PARAMS;
  pCVVIDEOWRITER                                 = ^CVVIDEOWRITER;
  pCV_FLOAT16_T                                  = ^CV_FLOAT16_T;
  pCV_DNN_DNN_INTERPLAYER                        = ^CV_DNN_DNN_INTERPLAYER;
  pCV_DNN_DNN_SOFTSIGNLAYER                      = ^CV_DNN_DNN_SOFTSIGNLAYER;
  pCV_IPLIMAGE                                   = {$IF Declared(pIPLIMAGE)}pIPLIMAGE{$ELSE} type pointer{$IFEND};
  pCV_DETAIL_MERCATORPROJECTOR                   = ^CV_DETAIL_MERCATORPROJECTOR;
  pCV_GIMPL_GISLANDEXECUTABLE                    = ^CV_GIMPL_GISLANDEXECUTABLE;
  pCV_DETAIL_BUNDLEADJUSTERAFFINE                = ^CV_DETAIL_BUNDLEADJUSTERAFFINE;
  pCV_DETAIL_TRACKING_TRACKERSTATEESTIMATOR      = ^CV_DETAIL_TRACKING_TRACKERSTATEESTIMATOR;
  pCV_DNN_DNN_CELULAYER                          = ^CV_DNN_DNN_CELULAYER;
  pCV_OCL_KERNEL                                 = ^CV_OCL_KERNEL;
  pCV_BOWIMGDESCRIPTOREXTRACTOR                  = ^CV_BOWIMGDESCRIPTOREXTRACTOR;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_CYLINDRICALPORTRAITPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_CYLINDRICALPORTRAITPROJECTOR;
  pCV_MATX_TOP                    = ^CV_MATX_TOP;
  pCV_OCL_DEVICE_IMPL             = ^CV_OCL_DEVICE_IMPL;
  pCV_DOWNHILLSOLVER              = ^CV_DOWNHILLSOLVER;
  pCV_DETAIL_BLOCKSCOMPENSATOR    = ^CV_DETAIL_BLOCKSCOMPENSATOR;
  pCV_FASTFEATUREDETECTOR         = ^CV_FASTFEATUREDETECTOR;
  pIDIRECT3DSURFACE9              = ^IDIRECT3DSURFACE9;
  pCV_DETAIL_AFFINEBASEDESTIMATOR = ^CV_DETAIL_AFFINEBASEDESTIMATOR;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_MERCATORPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_MERCATORPROJECTOR;
  pCV_DNN_DNN_ROUNDLAYER                 = ^CV_DNN_DNN_ROUNDLAYER;
  pCV_FILESTORAGE_IMPL                   = ^CV_FILESTORAGE_IMPL;
  pCV_DNN_DNN_MODEL                      = ^CV_DNN_DNN_MODEL;
  pCV_MATX_SUBOP                         = ^CV_MATX_SUBOP;
  pCV_HIGHGUI_BACKEND_UIBACKEND          = ^CV_HIGHGUI_BACKEND_UIBACKEND;
  pCV_DNN_DNN_TEXTDETECTIONMODEL_DB      = ^CV_DNN_DNN_TEXTDETECTIONMODEL_DB;
  pCV_GAPI_FLUID_BUFFER_CACHE            = ^CV_GAPI_FLUID_BUFFER_CACHE;
  pCV_GENERALIZEDHOUGHGUIL               = ^CV_GENERALIZEDHOUGHGUIL;
  pCV_MAT                                = ^CV_MAT;
  pCV_DETAIL_IMAGEFEATURES               = ^CV_DETAIL_IMAGEFEATURES;
  pCV_ML_SVMSGD                          = ^CV_ML_SVMSGD;
  pCV__OUTPUTARRAY                       = ^CV__OUTPUTARRAY;
  pCV_DNN_DNN_TEXTRECOGNITIONMODEL       = ^CV_DNN_DNN_TEXTRECOGNITIONMODEL;
  pCV_CASCADECLASSIFIER                  = ^CV_CASCADECLASSIFIER;
  pCV_MERCATORWARPER                     = ^CV_MERCATORWARPER;
  pCV_CUDA_EVENT                         = ^CV_CUDA_EVENT;
  pCV_OCL_CONTEXT_USERCONTEXT            = ^CV_OCL_CONTEXT_USERCONTEXT;
  pCV_DNN_DNN_RELULAYER                  = ^CV_DNN_DNN_RELULAYER;
  pCV_ML_NORMALBAYESCLASSIFIER           = ^CV_ML_NORMALBAYESCLASSIFIER;
  pCV_TRACKERNANO                        = ^CV_TRACKERNANO;
  pCV_OCL_QUEUE                          = ^CV_OCL_QUEUE;
  pCV_DETAIL_NOSEAMFINDER                = ^CV_DETAIL_NOSEAMFINDER;
  pCV_ALIGNMTB                           = ^CV_ALIGNMTB;
  pCV_UTILS_ALLOCATORSTATISTICSINTERFACE = ^CV_UTILS_ALLOCATORSTATISTICSINTERFACE;
  pCV_DNN_DNN_MVNLAYER                   = ^CV_DNN_DNN_MVNLAYER;
  pCV_DETAIL_CAMERAPARAMS                = ^CV_DETAIL_CAMERAPARAMS;
  pCV_TONEMAPDRAGO                       = ^CV_TONEMAPDRAGO;
  pCV_WARPERCREATOR                      = ^CV_WARPERCREATOR;
  // pCVMATND                                     = ^CVMATND;
  pCV_HAL_DFT2D                             = ^CV_HAL_DFT2D;
  pCV_DNN_DNN_KEYPOINTSMODEL                = ^CV_DNN_DNN_KEYPOINTSMODEL;
  pCVLEVMARQ                                = ^CVLEVMARQ;
  pCV_DETAIL_OPAQUEREF                      = ^CV_DETAIL_OPAQUEREF;
  pCV_DETAIL_TRACKING_TRACKERTARGETSTATE    = ^CV_DETAIL_TRACKING_TRACKERTARGETSTATE;
  pCV_SUBDIV2D_VERTEX                       = ^CV_SUBDIV2D_VERTEX;
  pCV_DETAIL_PLANEPORTRAITWARPER            = ^CV_DETAIL_PLANEPORTRAITWARPER;
  pCV_AGASTFEATUREDETECTOR                  = ^CV_AGASTFEATUREDETECTOR;
  pCV_GAPI_WIP_DRAW_MOSAIC                  = ^CV_GAPI_WIP_DRAW_MOSAIC;
  pCV_GAPI_GBACKEND                         = ^CV_GAPI_GBACKEND;
  pCV_DNN_DNN_SINLAYER                      = ^CV_DNN_DNN_SINLAYER;
  pCV_DETAIL_SPHERICALWARPERGPU             = ^CV_DETAIL_SPHERICALWARPERGPU;
  pCV_GAPI_FLUID_BUFFER_PRIV                = ^CV_GAPI_FLUID_BUFFER_PRIV;
  pCV_GCPUCONTEXT                           = ^CV_GCPUCONTEXT;
  pCV_DETAIL_SPHERICALWARPER                = ^CV_DETAIL_SPHERICALWARPER;
  pCV_DNN_DNN_CONSTLAYER                    = ^CV_DNN_DNN_CONSTLAYER;
  pCV_DNN_DNN_SHIFTLAYERINT8                = ^CV_DNN_DNN_SHIFTLAYERINT8;
  pCV_DNN_DNN_ELTWISELAYER                  = ^CV_DNN_DNN_ELTWISELAYER;
  pCV_PLANEWARPER                           = ^CV_PLANEWARPER;
  pCV_CONJGRADSOLVER                        = ^CV_CONJGRADSOLVER;
  pCV_UTIL_VARIANT_OF_UNSIGNED_CVCHAR       = ^CV_UTIL_VARIANT_OF_UNSIGNED_CVCHAR;
  pCV_RMAT                                  = ^CV_RMAT;
  pCV_FORMATTER                             = ^CV_FORMATTER;
  pCV_DNN_DNN_SINHLAYER                     = ^CV_DNN_DNN_SINHLAYER;
  pCV_GAPI_WIP_ONEVPL_IDEVICESELECTOR_SCORE = ^CV_GAPI_WIP_ONEVPL_IDEVICESELECTOR_SCORE;
  pCV_GSCALARDESC                           = ^CV_GSCALARDESC;
  pCV_COMPRESSEDRECTILINEARPORTRAITWARPER   = ^CV_COMPRESSEDRECTILINEARPORTRAITWARPER;
  pCV_DETAIL_BESTOF2NEARESTMATCHER          = ^CV_DETAIL_BESTOF2NEARESTMATCHER;
  pCV_GAPI_WIP_DATA                         = ^CV_GAPI_WIP_DATA;
  pCV_ARUCO_CHARUCOBOARD                    = ^CV_ARUCO_CHARUCOBOARD;
  pCV_DETAIL_MATCHESINFO                    = ^CV_DETAIL_MATCHESINFO;
  pSTD_VECTOR_OF_CV_MAT                     = ^STD_VECTOR_OF_CV_MAT;
  pSTD_VECTOR_OF_CV_GTRANSFORM              = ^STD_VECTOR_OF_CV_GTRANSFORM;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PLANEPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PLANEPROJECTOR;
  pCV_OCL_CONTEXT                           = ^CV_OCL_CONTEXT;
  pCV_MATALLOCATOR                          = ^CV_MATALLOCATOR;
  pCV_SUBDIV2D_QUADEDGE                     = ^CV_SUBDIV2D_QUADEDGE;
  pCV_DNN_DNN_HARDSIGMOIDLAYER              = ^CV_DNN_DNN_HARDSIGMOIDLAYER;
  pCV_DNN_DNN_ATANHLAYER                    = ^CV_DNN_DNN_ATANHLAYER;
  pCV_DENSEOPTICALFLOW                      = ^CV_DENSEOPTICALFLOW;
  pCV_GARG                                  = ^CV_GARG;
  pCV_ARUCO_ARUCODETECTOR                   = ^CV_ARUCO_ARUCODETECTOR;
  pCV_AUTOBUFFER_OF_DOUBLE                  = ^CV_AUTOBUFFER_OF_DOUBLE;
  pCV_CALIBRATEROBERTSON                    = ^CV_CALIBRATEROBERTSON;
  pCV_SIMPLEBLOBDETECTOR                    = ^CV_SIMPLEBLOBDETECTOR;
  pSTD_VECTOR_OF_STD_BASIC_STRING_OF_CVCHAR = ^STD_VECTOR_OF_STD_BASIC_STRING_OF_CVCHAR;
  pCV_BACKGROUNDSUBTRACTORKNN               = ^CV_BACKGROUNDSUBTRACTORKNN;
  pCV_DETAIL_PAIRWISESEAMFINDER             = ^CV_DETAIL_PAIRWISESEAMFINDER;
  pCV_BACKGROUNDSUBTRACTOR                  = ^CV_BACKGROUNDSUBTRACTOR;
  pCV_ML_SVM_KERNEL                         = ^CV_ML_SVM_KERNEL;
  pCV_FILESTORAGE                           = ^CV_FILESTORAGE;
  pCV_OCL_PROGRAM                           = ^CV_OCL_PROGRAM;
  pCV_GAPI_KALMANPARAMS                     = ^CV_GAPI_KALMANPARAMS;
  pSTD_VECTOR_OF_CV_KEYPOINT                = ^STD_VECTOR_OF_CV_KEYPOINT;
  pCV_VIDEOWRITER                           = ^CV_VIDEOWRITER;
  pCV_DETAIL_GAINCOMPENSATOR                = ^CV_DETAIL_GAINCOMPENSATOR;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_SPHERICALPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_SPHERICALPROJECTOR;
  pCV_TRACKER                          = ^CV_TRACKER;
  pCV_SPARSEMAT                        = {$IF Declared(pCvSparseMat)}pCvSparseMat{$ELSE} type pointer{$IFEND};
  pCV_ML_RTREES                        = ^CV_ML_RTREES;
  pCV_DETAIL_ESTIMATOR                 = ^CV_DETAIL_ESTIMATOR;
  pCV_DNN_DNN_CONVOLUTIONLAYER         = ^CV_DNN_DNN_CONVOLUTIONLAYER;
  pADE_TYPEDGRAPH_OF_CV_GIMPL_NODETYPE = ^ADE_TYPEDGRAPH_OF_CV_GIMPL_NODETYPE;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_SPHERICALPORTRAITPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_SPHERICALPORTRAITPROJECTOR;
  pCV_GAPI_FLUID_VIEW              = ^CV_GAPI_FLUID_VIEW;
  pCV_CALIBRATECRF                 = ^CV_CALIBRATECRF;
  pCV_DNN_DNN_SHUFFLECHANNELLAYER  = ^CV_DNN_DNN_SHUFFLECHANNELLAYER;
  pSTD_VECTOR_OF_CVCHAR            = ^STD_VECTOR_OF_CVCHAR;
  pCV_SIMPLEBLOBDETECTORIMPL       = ^CV_SIMPLEBLOBDETECTORIMPL;
  pCV_OCL_PLATFORMINFO             = ^CV_OCL_PLATFORMINFO;
  pCV_DNN_DNN_BASECONVOLUTIONLAYER = ^CV_DNN_DNN_BASECONVOLUTIONLAYER;
  pCV_DNN_DNN_SOFTPLUSLAYER        = ^CV_DNN_DNN_SOFTPLUSLAYER;
  pCV_ARUCO_GRIDBOARD              = ^CV_ARUCO_GRIDBOARD;
  pCV_MEDIAFRAME_IADAPTER          = ^CV_MEDIAFRAME_IADAPTER;
  pCV_CYLINDRICALWARPER            = ^CV_CYLINDRICALWARPER;
  pCV_DNN_DNN_GATHERLAYER          = ^CV_DNN_DNN_GATHERLAYER;
  pCV_QRCODEDETECTOR               = ^CV_QRCODEDETECTOR;
  pCV_ARUCO_CHARUCOPARAMETERS      = ^CV_ARUCO_CHARUCOPARAMETERS;
  pCV_STEREOSGBM                   = ^CV_STEREOSGBM;
  pCV_GKERNELPACKAGE               = ^CV_GKERNELPACKAGE;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_STEREOGRAPHICPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_STEREOGRAPHICPROJECTOR;
  pCV_GAPI_S11N_IISTREAM                           = ^CV_GAPI_S11N_IISTREAM;
  pCV_MINPROBLEMSOLVER                             = ^CV_MINPROBLEMSOLVER;
  pCV_DETAIL_SPHERICALPORTRAITWARPER               = ^CV_DETAIL_SPHERICALPORTRAITWARPER;
  pCV_HOGDESCRIPTOR                                = ^CV_HOGDESCRIPTOR;
  pCV_GAPI_WIP_ONEVPL_DATAPROVIDEREXCEPTION        = ^CV_GAPI_WIP_ONEVPL_DATAPROVIDEREXCEPTION;
  pCV_GAPI_GNETPACKAGE                             = ^CV_GAPI_GNETPACKAGE;
  pCV_UMATDATA                                     = ^CV_UMATDATA;
  pCV_DNN_DNN_MAXUNPOOLLAYER                       = ^CV_DNN_DNN_MAXUNPOOLLAYER;
  pCV_DETAIL_TRACKING_TRACKERMODEL                 = ^CV_DETAIL_TRACKING_TRACKERMODEL;
  pCV_UTIL_ANY                                     = ^CV_UTIL_ANY;
  pCV_GAPI_WIP_GASYNCCANCELED                      = ^CV_GAPI_WIP_GASYNCCANCELED;
  pCV_SEGMENTATION_INTELLIGENTSCISSORSMB           = ^CV_SEGMENTATION_INTELLIGENTSCISSORSMB;
  pSTD_DEQUE_OF_STD_PAIR_OF_UNSIGNED___INT64       = ^STD_DEQUE_OF_STD_PAIR_OF_UNSIGNED___INT64;
  pSTD_VECTOR_OF_DOUBLE                            = ^STD_VECTOR_OF_DOUBLE;
  pSTD_BASIC_OSTREAM_OF_CVCHAR                     = ^STD_BASIC_OSTREAM_OF_CVCHAR;
  pCV_GAPI_PYTHON_GPYTHONKERNEL                    = ^CV_GAPI_PYTHON_GPYTHONKERNEL;
  pCV_ML_DTREES_NODE                               = ^CV_ML_DTREES_NODE;
  pCV_TRACKERDASIAMRPN                             = ^CV_TRACKERDASIAMRPN;
  pSTD_VECTOR_OF_CV_CUDA_GPUMAT                    = ^STD_VECTOR_OF_CV_CUDA_GPUMAT;
  pCV_MERGEROBERTSON                               = ^CV_MERGEROBERTSON;
  pCV_DNN_DNN_DATAAUGMENTATIONLAYER                = ^CV_DNN_DNN_DATAAUGMENTATIONLAYER;
  pCV_DNN_DNN_SCATTERNDLAYER                       = ^CV_DNN_DNN_SCATTERNDLAYER;
  pCV_AVIREADCONTAINER                             = ^CV_AVIREADCONTAINER;
  pCV_ARUCO_REFINEPARAMETERS                       = ^CV_ARUCO_REFINEPARAMETERS;
  pSTEREOSETUP                                     = ^STEREOSETUP;
  pCV_HIGHGUI_BACKEND_UIWINDOW                     = ^CV_HIGHGUI_BACKEND_UIWINDOW;
  pCV_DNN_DNN_LRNLAYER                             = ^CV_DNN_DNN_LRNLAYER;
  pCV_BASECASCADECLASSIFIER                        = ^CV_BASECASCADECLASSIFIER;
  pCV_BUFFERPOOLCONTROLLER                         = ^CV_BUFFERPOOLCONTROLLER;
  pCV_GKERNELIMPL                                  = ^CV_GKERNELIMPL;
  pCV_DETAIL_TRACKING_TRACKERSAMPLERCSC            = ^CV_DETAIL_TRACKING_TRACKERSAMPLERCSC;
  pCV_GAPI_WIP_ONEVPL_IDEVICESELECTOR              = ^CV_GAPI_WIP_ONEVPL_IDEVICESELECTOR;
  pCV_DETAIL_PROJECTORBASE                         = ^CV_DETAIL_PROJECTORBASE;
  pCV_UTILS_TRACE_DETAILS_TRACEARG                 = ^CV_UTILS_TRACE_DETAILS_TRACEARG;
  pSTD_VECTOR_OF_STD_VECTOR_OF_CV_POINT3__OF_FLOAT = ^STD_VECTOR_OF_STD_VECTOR_OF_CV_POINT3__OF_FLOAT;
  pCV_GAPI_IE_PYPARAMS                             = ^CV_GAPI_IE_PYPARAMS;
  pCV_STEREOGRAPHICWARPER                          = ^CV_STEREOGRAPHICWARPER;
  pCV_DETAIL_PLANEWARPER                           = ^CV_DETAIL_PLANEWARPER;
  pCV_GAPI_USE_ONLY                                = ^CV_GAPI_USE_ONLY;
  pCV_GIMPL_RMATMEDIAFRAMEADAPTER                  = ^CV_GIMPL_RMATMEDIAFRAMEADAPTER;
  pCV_GAPI_WIP_ONEVPL_IDATAPROVIDER                = ^CV_GAPI_WIP_ONEVPL_IDATAPROVIDER;
  pCV_POINTSETREGISTRATOR_CALLBACK                 = ^CV_POINTSETREGISTRATOR_CALLBACK;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_COMPRESSEDRECTILINEARPROJECTOR = ^
    CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_COMPRESSEDRECTILINEARPROJECTOR;
  pCV_GCPUKERNEL                         = ^CV_GCPUKERNEL;
  pCV_DETAIL_STEREOGRAPHICWARPER         = ^CV_DETAIL_STEREOGRAPHICWARPER;
  pCV_DETAIL_BLOCKSGAINCOMPENSATOR       = ^CV_DETAIL_BLOCKSGAINCOMPENSATOR;
  pCV_OCL_PROGRAMSOURCE                  = ^CV_OCL_PROGRAMSOURCE;
  pCV_AVIWRITECONTAINER                  = ^CV_AVIWRITECONTAINER;
  pCV_DETAIL_GRAPH                       = ^CV_DETAIL_GRAPH;
  pID3D11TEXTURE2D                       = ^ID3D11TEXTURE2D;
  pID3D10TEXTURE2D                       = ^ID3D10TEXTURE2D;
  pCV_POINTSETREGISTRATOR                = ^CV_POINTSETREGISTRATOR;
  pCV_ML_SVM                             = ^CV_ML_SVM;
  pCV_DNN_DNN_TANHLAYER                  = ^CV_DNN_DNN_TANHLAYER;
  pCV_OCL_DEVICE                         = ^CV_OCL_DEVICE;
  pCV_DNN_DNN_FLATTENLAYER               = ^CV_DNN_DNN_FLATTENLAYER;
  pCV_DETAIL_DPSEAMFINDER                = ^CV_DETAIL_DPSEAMFINDER;
  pCV_GAPI_WIP_DRAW_IMAGE                = ^CV_GAPI_WIP_DRAW_IMAGE;
  pCV_DNN_DNN_FLOORLAYER                 = ^CV_DNN_DNN_FLOORLAYER;
  pCV_FILENODE                           = ^CV_FILENODE;
  pCV_DNN_DNN_RECIPROCALLAYER            = ^CV_DNN_DNN_RECIPROCALLAYER;
  pCV_ORB                                = ^CV_ORB;
  pCV_SPARSEMATITERATOR                  = ^CV_SPARSEMATITERATOR;
  pIDIRECT3DDEVICE9EX                    = ^IDIRECT3DDEVICE9EX;
  pCV_TRACKERMIL                         = ^CV_TRACKERMIL;
  pCV_GMATDESC                           = ^CV_GMATDESC;
  pCV_GAPI_WIP_DRAW_LINE                 = ^CV_GAPI_WIP_DRAW_LINE;
  pCV_DETAIL_TIMELAPSER                  = ^CV_DETAIL_TIMELAPSER;
  pCV_DETAIL_TRANSVERSEMERCATORPROJECTOR = ^CV_DETAIL_TRANSVERSEMERCATORPROJECTOR;
  pCV_DNN_DNN_TILELAYER                  = ^CV_DNN_DNN_TILELAYER;
  pCV_GOCLCONTEXT                        = ^CV_GOCLCONTEXT;
  pSTD_VECTOR_OF_STD_VECTOR_OF_INT       = ^STD_VECTOR_OF_STD_VECTOR_OF_INT;
  pCV_DETAIL_FEATHERBLENDER              = ^CV_DETAIL_FEATHERBLENDER;
  pCV_GAPI_WIP_DRAW_TEXT                 = ^CV_GAPI_WIP_DRAW_TEXT;
  pCV_DETAIL_GRAPHCUTSEAMFINDERBASE      = ^CV_DETAIL_GRAPHCUTSEAMFINDERBASE;
  pCV_TONEMAPMANTIUK                     = ^CV_TONEMAPMANTIUK;
  pCV_DNN_DNN_TEXTDETECTIONMODEL         = ^CV_DNN_DNN_TEXTDETECTIONMODEL;
  pCV_CUDA_BUFFERPOOL                    = ^CV_CUDA_BUFFERPOOL;
  pCV_GSTREAMINGCOMPILED                 = ^CV_GSTREAMINGCOMPILED;
  pCV_KALMANFILTER                       = ^CV_KALMANFILTER;
  pSTD_VECTOR_OF_STD_VECTOR_OF_STD_PAIR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERTARGETSTATE = ^
    STD_VECTOR_OF_STD_VECTOR_OF_STD_PAIR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERTARGETSTATE;
  pCV_MATX_ADDOP                    = ^CV_MATX_ADDOP;
  pCV_VARIATIONALREFINEMENT         = ^CV_VARIATIONALREFINEMENT;
  pCV_SIMPLEBLOBDETECTORIMPL_CENTER = ^CV_SIMPLEBLOBDETECTORIMPL_CENTER;
  pCV_MERGEEXPOSURES                = ^CV_MERGEEXPOSURES;
  pCV_DNN_DNN_SCALELAYER            = ^CV_DNN_DNN_SCALELAYER;
  pCV_GFRAMEDESC                    = ^CV_GFRAMEDESC;
  pCV_UTILS_LOGGING_LOGTAG          = ^CV_UTILS_LOGGING_LOGTAG;
  pCV_SIMPLEBLOBDETECTOR_PARAMS     = ^CV_SIMPLEBLOBDETECTOR_PARAMS;
  pCV_DETAIL_CYLINDRICALWARPER      = ^CV_DETAIL_CYLINDRICALWARPER;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_COMPRESSEDRECTILINEARPORTRAITPROJECTOR = ^
    CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_COMPRESSEDRECTILINEARPORTRAITPROJECTOR;
  pCV_DETAIL_TRACKING_TRACKERFEATURESET = ^CV_DETAIL_TRACKING_TRACKERFEATURESET;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_TRANSVERSEMERCATORPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_TRANSVERSEMERCATORPROJECTOR;
  pCV_DNN_DNN_CORRELATIONLAYER                  = ^CV_DNN_DNN_CORRELATIONLAYER;
  pCV_DETAIL_TRACKING_TRACKERSAMPLERALGORITHM   = ^CV_DETAIL_TRACKING_TRACKERSAMPLERALGORITHM;
  pCV_ASYNCARRAY                                = ^CV_ASYNCARRAY;
  pCV_UTILS_NESTED_ORIGINALCLASSNAME_PARAMS     = ^CV_UTILS_NESTED_ORIGINALCLASSNAME_PARAMS;
  pCV_OCL_PLATFORM                              = ^CV_OCL_PLATFORM;
  pCV_OCL_OPENCLEXECUTIONCONTEXT                = ^CV_OCL_OPENCLEXECUTIONCONTEXT;
  pCV_KEYPOINT                                  = ^CV_KEYPOINT;
  pCV_DNN_DNN_ACTIVATIONLAYERINT8               = ^CV_DNN_DNN_ACTIVATIONLAYERINT8;
  pCV_DETAIL_BUNDLEADJUSTERBASE                 = ^CV_DETAIL_BUNDLEADJUSTERBASE;
  pCV_DNN_DNN_RESIZELAYER                       = ^CV_DNN_DNN_RESIZELAYER;
  pCV_DNN_DNN_NARYELTWISELAYER                  = ^CV_DNN_DNN_NARYELTWISELAYER;
  pCV_DETAIL_COMPRESSEDRECTILINEARWARPER        = ^CV_DETAIL_COMPRESSEDRECTILINEARWARPER;
  pCV_MSER                                      = ^CV_MSER;
  pCV_ML_DTREES_SPLIT                           = ^CV_ML_DTREES_SPLIT;
  pCV_DETAIL_CYLINDRICALPORTRAITWARPER          = ^CV_DETAIL_CYLINDRICALPORTRAITWARPER;
  pCV_MATEXPR                                   = ^CV_MATEXPR;
  pCV_OCL_IMAGE2D                               = ^CV_OCL_IMAGE2D;
  pCV_GCOMPILED_PRIV                            = ^CV_GCOMPILED_PRIV;
  pCV_INTERNAL_WRITESTRUCTCONTEXT               = ^CV_INTERNAL_WRITESTRUCTCONTEXT;
  pSTD_VECTOR_OF_STD_VECTOR_OF_CV_POINT__OF_INT = ^STD_VECTOR_OF_STD_VECTOR_OF_CV_POINT__OF_INT;
  pCV_MERGEMERTENS                              = ^CV_MERGEMERTENS;
  pCV_DNN_DNN_GRULAYER                          = ^CV_DNN_DNN_GRULAYER;
  pCV_DNN_DNN_POWERLAYER                        = ^CV_DNN_DNN_POWERLAYER;
  pSTD_VECTOR_OF_INT                            = ^STD_VECTOR_OF_INT;
  pCV_OGL_TEXTURE2D                             = ^CV_OGL_TEXTURE2D;
  pCV_GAPI_OAK_COLORCAMERA                      = ^CV_GAPI_OAK_COLORCAMERA;
  pCV_DMATCH                                    = ^CV_DMATCH;
  pCV_UMATDATAAUTOLOCK                          = ^CV_UMATDATAAUTOLOCK;
  pCV_LMSOLVER                                  = ^CV_LMSOLVER;
  pCV_FACEDETECTORYN                            = ^CV_FACEDETECTORYN;
  pCV_GAPI_WIP_DRAW_FTTEXTRENDER                = ^CV_GAPI_WIP_DRAW_FTTEXTRENDER;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_FISHEYEPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_FISHEYEPROJECTOR;
  pCV_SOFTDOUBLE                      = ^CV_SOFTDOUBLE;
  pCV_DETAIL_SEAMFINDER               = ^CV_DETAIL_SEAMFINDER;
  pCV_DNN_DNN_BATCHNORMLAYERINT8      = ^CV_DNN_DNN_BATCHNORMLAYERINT8;
  pCV_DNN_DNN_LAYERPARAMS             = ^CV_DNN_DNN_LAYERPARAMS;
  pCV_DNN_DNN_LAYER                   = ^CV_DNN_DNN_LAYER;
  pCV_DNN_DNN_BNLLLAYER               = ^CV_DNN_DNN_BNLLLAYER;
  pCV_MERGEDEBEVEC                    = ^CV_MERGEDEBEVEC;
  pCV_MATSIZE                         = ^CV_MATSIZE;
  pCV_DNN_DNN_SOFTMAXLAYER            = ^CV_DNN_DNN_SOFTMAXLAYER;
  pCV_GAPI_FLUID_BUFFERSTORAGE        = ^CV_GAPI_FLUID_BUFFERSTORAGE;
  pCV_COMMANDLINEPARSER               = ^CV_COMMANDLINEPARSER;
  pCV_DETAIL_HOMOGRAPHYBASEDESTIMATOR = ^CV_DETAIL_HOMOGRAPHYBASEDESTIMATOR;
  // pCVCHAR                                              = ^CVCHAR;
  pCV_DNN_DNN_ABSLAYER                 = ^CV_DNN_DNN_ABSLAYER;
  pCV_DETAIL_SPHERICALPROJECTOR        = ^CV_DETAIL_SPHERICALPROJECTOR;
  pCV_DNN_DNN_CLASSIFICATIONMODEL      = ^CV_DNN_DNN_CLASSIFICATIONMODEL;
  pCV_DNN_DNN_LOGLAYER                 = ^CV_DNN_DNN_LOGLAYER;
  pCV_GAPI_OAK_COLORCAMERAPARAMS       = ^CV_GAPI_OAK_COLORCAMERAPARAMS;
  pCV_UTILS_CLASSWITHKEYWORDPROPERTIES = ^CV_UTILS_CLASSWITHKEYWORDPROPERTIES;
  pCV_DNN_DNN_CROPLAYER                = ^CV_DNN_DNN_CROPLAYER;
  pCV_DNN_DNN_SCATTERLAYER             = ^CV_DNN_DNN_SCATTERLAYER;
  pCV_GAPI_S11N_BYTEMEMORYOUTSTREAM    = ^CV_GAPI_S11N_BYTEMEMORYOUTSTREAM;
  pCV_DNN_DNN_CUMSUMLAYER              = ^CV_DNN_DNN_CUMSUMLAYER;
  pCV_GMATP                            = ^CV_GMATP;
  pCV_DETAIL_PANINIWARPER              = ^CV_DETAIL_PANINIWARPER;
  pCV_CIRCLESGRIDFINDERPARAMETERS      = ^CV_CIRCLESGRIDFINDERPARAMETERS;
  pCV_PANINIWARPER                     = ^CV_PANINIWARPER;
  pCV_DNN_DNN_PERMUTELAYER             = ^CV_DNN_DNN_PERMUTELAYER;
  pCV_DNN_DNN_ARGLAYER                 = ^CV_DNN_DNN_ARGLAYER;
  pCV_ARUCO_BOARD                      = ^CV_ARUCO_BOARD;
  pCV_LDA                              = ^CV_LDA;
  pCV_DETAIL_NOEXPOSURECOMPENSATOR     = ^CV_DETAIL_NOEXPOSURECOMPENSATOR;
  pCV_DNN_DNN_REQUANTIZELAYER          = ^CV_DNN_DNN_REQUANTIZELAYER;
  pCV_DNN_DNN_EXPLAYER                 = ^CV_DNN_DNN_EXPLAYER;
  // pCV_MAT                                              = pMat; // ^CV_MAT;
  pCV_MATND                                            = ^CV_MATND;
  pCV_DETAIL_BUNDLEADJUSTERRAY                         = ^CV_DETAIL_BUNDLEADJUSTERRAY;
  pCV_GAPI_WIP_ONEVPL_DATAPROVIDERSYSTEMERROREXCEPTION = ^CV_GAPI_WIP_ONEVPL_DATAPROVIDERSYSTEMERROREXCEPTION;
  pCV_DNN_DNN_PADDINGLAYER                             = ^CV_DNN_DNN_PADDINGLAYER;
  pCV_FLANN_INDEX                                      = ^CV_FLANN_INDEX;
  pCV_DNN_DNN_RESHAPELAYER                             = ^CV_DNN_DNN_RESHAPELAYER;
  pCV_DETAIL_TRACKING_TRACKERSTATEESTIMATORMILBOOSTING = ^CV_DETAIL_TRACKING_TRACKERSTATEESTIMATORMILBOOSTING;
  pCV_DNN_DNN_POOLINGLAYERINT8                         = ^CV_DNN_DNN_POOLINGLAYERINT8;
  pCV_RNG                                              = pRNG; // ^CV_RNG;
  pCV_GOCLKERNEL                                       = ^CV_GOCLKERNEL;
  pCV_DETECTIONBASEDTRACKER                            = ^CV_DETECTIONBASEDTRACKER;
  pCV_KEYPOINTSFILTER                                  = ^CV_KEYPOINTSFILTER;
  pCV_BRISK                                            = ^CV_BRISK;
  pCV_DNN_BACKEND_NETWORKBACKEND                       = ^CV_DNN_BACKEND_NETWORKBACKEND;
  pCV_SIFT                                             = ^CV_SIFT;
  pCV_DNN_DNN_REDUCELAYER                              = ^CV_DNN_DNN_REDUCELAYER;
  pCV_GKERNEL                                          = ^CV_GKERNEL;
  pCV_DETAIL_PANINIPROJECTOR                           = ^CV_DETAIL_PANINIPROJECTOR;
  pCV_DETAIL_DISJOINTSETS                              = ^CV_DETAIL_DISJOINTSETS;
  pCV_DETAIL_FISHEYEWARPER                             = ^CV_DETAIL_FISHEYEWARPER;
  pCV_DETAIL_BLOCKSCHANNELSCOMPENSATOR                 = ^CV_DETAIL_BLOCKSCHANNELSCOMPENSATOR;
  pCV_ML_DTREES                                        = ^CV_ML_DTREES;
  pCV_UMAT                                             = ^CV_UMAT;
  pCV_SEGMENTATION_INTELLIGENTSCISSORSMB_IMPL          = ^CV_SEGMENTATION_INTELLIGENTSCISSORSMB_IMPL;
  pCV_DNN_DNN_DETECTIONOUTPUTLAYER                     = ^CV_DNN_DNN_DETECTIONOUTPUTLAYER;
  pCV_MATX_DIVOP                                       = ^CV_MATX_DIVOP;
  pCV_CVMEMSTORAGE                                     = {$IF Declared(pCvMemStorage)}pCvMemStorage{$ELSE} type pointer{$IFEND};
  pCV_POINT__OF_INT                                    = pPoint; // ^CV_POINT__OF_INT;
  pCV_DETAIL_TRACKING_TRACKERSAMPLERCSC_PARAMS         = ^CV_DETAIL_TRACKING_TRACKERSAMPLERCSC_PARAMS;
  pCV_DNN_DNN_NET                                      = ^CV_DNN_DNN_NET;
  pCV_NARYMATITERATOR                                  = ^CV_NARYMATITERATOR;
  pCV_DNN_DNN_TANLAYER                                 = ^CV_DNN_DNN_TANLAYER;
  // pCV_SPARSEMAT                                         = ^CV_SPARSEMAT;
  pCV_SUBDIV2D = ^CV_SUBDIV2D;
  pSTD_VECTOR_OF_STD_PAIR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERTARGETSTATE = ^
    STD_VECTOR_OF_STD_PAIR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERTARGETSTATE;
  pCV_DNN_DNN_SPLITLAYER                              = ^CV_DNN_DNN_SPLITLAYER;
  pCV_POINT__OF_FLOAT                                 = ^CV_POINT__OF_FLOAT;
  pSTD_VECTOR_OF_CV_UTIL_VARIANT_OF_CV_UTIL_MONOSTATE = ^STD_VECTOR_OF_CV_UTIL_VARIANT_OF_CV_UTIL_MONOSTATE;
  pCV_DETAIL_CYLINDRICALPORTRAITPROJECTOR             = ^CV_DETAIL_CYLINDRICALPORTRAITPROJECTOR;
  pCV_DETAIL_PANINIPORTRAITWARPER                     = ^CV_DETAIL_PANINIPORTRAITWARPER;
  pCV_DNN_DNN_SOFTMAXLAYERINT8                        = ^CV_DNN_DNN_SOFTMAXLAYERINT8;
  pCV_PCA                                             = ^CV_PCA;
  pCV_COMPRESSEDRECTILINEARWARPER                     = ^CV_COMPRESSEDRECTILINEARWARPER;
  pCV_MATX_SCALEOP                                    = ^CV_MATX_SCALEOP;
  pCV_DNN_DNN_COMPARELAYER                            = ^CV_DNN_DNN_COMPARELAYER;
  pCV_GENERALIZEDHOUGHBALLARD                         = ^CV_GENERALIZEDHOUGHBALLARD;
  pCV_LINEITERATOR                                    = ^CV_LINEITERATOR;
  pSTD_VECTOR_OF_CV_GTYPEINFO                         = ^STD_VECTOR_OF_CV_GTYPEINFO;
  pCV_HAL_DCT2D                                       = ^CV_HAL_DCT2D;
  pCV_DETAIL_VORONOISEAMFINDER                        = ^CV_DETAIL_VORONOISEAMFINDER;
  pCV_DNN_DNN_SLICELAYER                              = ^CV_DNN_DNN_SLICELAYER;
  pCV_BOWTRAINER                                      = ^CV_BOWTRAINER;
  pCV_BACKGROUNDSUBTRACTORMOG2                        = ^CV_BACKGROUNDSUBTRACTORMOG2;
  pCV_DETAIL_COMPRESSEDRECTILINEARPORTRAITPROJECTOR   = ^CV_DETAIL_COMPRESSEDRECTILINEARPORTRAITPROJECTOR;
  pCV_SPARSEOPTICALFLOW                               = ^CV_SPARSEOPTICALFLOW;
  pCV_TONEMAPREINHARD                                 = ^CV_TONEMAPREINHARD;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PLANEPORTRAITPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PLANEPORTRAITPROJECTOR;
  pCV_CUDA_DEVICEINFO                          = ^CV_CUDA_DEVICEINFO;
  pCV_DETAIL_TRANSVERSEMERCATORWARPER          = ^CV_DETAIL_TRANSVERSEMERCATORWARPER;
  pCVCAPTURE                                   = ^CVCAPTURE;
  pCV__INPUTOUTPUTARRAY                        = ^CV__INPUTOUTPUTARRAY;
  pCV_OGL_BUFFER                               = ^CV_OGL_BUFFER;
  pCV_AFFINEWARPER                             = ^CV_AFFINEWARPER;
  pCV_FISHEYEWARPER                            = ^CV_FISHEYEWARPER;
  pCV_DNN_DNN_MODEL_IMPL                       = ^CV_DNN_DNN_MODEL_IMPL;
  pCV_DNN_DNN_RELU6LAYER                       = ^CV_DNN_DNN_RELU6LAYER;
  pCV_FILENODEITERATOR                         = ^CV_FILENODEITERATOR;
  pUNSIGNED_CVCHAR                             = ^UNSIGNED_CVCHAR;
  pCV_ML_EMIMPL                                = ^CV_ML_EMIMPL;
  pCV_EXCEPTION                                = ^CV_EXCEPTION;
  pCV_GAPI_OAK_OAKRMATADAPTER                  = ^CV_GAPI_OAK_OAKRMATADAPTER;
  pCV_GSTREAMINGCOMPILED_PRIV                  = ^CV_GSTREAMINGCOMPILED_PRIV;
  pCV_GAPI_FLUID_VIEW_CACHE                    = ^CV_GAPI_FLUID_VIEW_CACHE;
  pSTD_UNORDERED_SET_OF_ADE_HANDLE_OF_ADE_NODE = ^STD_UNORDERED_SET_OF_ADE_HANDLE_OF_ADE_NODE;
  pCV_GAPI_WIP_DRAW_CIRCLE                     = ^CV_GAPI_WIP_DRAW_CIRCLE;
  pCV_TRACKERNANO_PARAMS                       = ^CV_TRACKERNANO_PARAMS;
  pCV_GAPI_WIP_ONEVPL_VPPPREPROCDISPATCHER     = ^CV_GAPI_WIP_ONEVPL_VPPPREPROCDISPATCHER;
  pCV_DNN_DNN_CROPANDRESIZELAYER               = ^CV_DNN_DNN_CROPANDRESIZELAYER;
  pCV_DNN_DNN_REDUCELAYERINT8                  = ^CV_DNN_DNN_REDUCELAYERINT8;
  pCV_ML_LOGISTICREGRESSION                    = ^CV_ML_LOGISTICREGRESSION;
  pCV_GFTTDETECTOR                             = ^CV_GFTTDETECTOR;
  pCV_DNN_DNN_QUANTIZELAYER                    = ^CV_DNN_DNN_QUANTIZELAYER;
  pCV_CUDA_STREAM                              = ^CV_CUDA_STREAM;
  pCV_DNN_DNN_REORGLAYER                       = ^CV_DNN_DNN_REORGLAYER;
  pCV_GSCALAR                                  = ^CV_GSCALAR;
  pCV_BOWKMEANSTRAINER                         = ^CV_BOWKMEANSTRAINER;
  pCV_ARUCO_CHARUCODETECTOR                    = ^CV_ARUCO_CHARUCODETECTOR;
  pCV_AFFINEFEATURE                            = ^CV_AFFINEFEATURE;
  pCV_HAL_DFT1D                                = ^CV_HAL_DFT1D;
  pCV_CUDA_GPUMAT                              = ^CV_CUDA_GPUMAT;
  pCV_CLAHE                                    = ^CV_CLAHE;
  pCV_GAPI_ONNX_PYPARAMS                       = ^CV_GAPI_ONNX_PYPARAMS;
  pCV_DNN_DNN_ERFLAYER                         = ^CV_DNN_DNN_ERFLAYER;
  pCV_USACPARAMS                               = ^CV_USACPARAMS;
  pCV_DETAIL_COMPRESSEDRECTILINEARPROJECTOR    = ^CV_DETAIL_COMPRESSEDRECTILINEARPROJECTOR;
  pCV_DETAIL_PLANEPORTRAITPROJECTOR            = ^CV_DETAIL_PLANEPORTRAITPROJECTOR;
  pCV_TRACKERGOTURN                            = ^CV_TRACKERGOTURN;
  pIDIRECT3DDEVICE9                            = ^IDIRECT3DDEVICE9;
  pCV_GAPI_OAK_OAKMEDIAADAPTER                 = ^CV_GAPI_OAK_OAKMEDIAADAPTER;
  pCV_DETAIL_PLANEWARPERGPU                    = ^CV_DETAIL_PLANEWARPERGPU;
  pCV_DETAIL_TRACKING_CLFMILBOOST              = ^CV_DETAIL_TRACKING_CLFMILBOOST;
  // pBOOL                                        = ^BOOL;
  pCV_RECT__OF_INT                        = ^CV_RECT__OF_INT;
  pCV_GCOMPILED                           = ^CV_GCOMPILED;
  pCV_DNN_DNN_PRIORBOXLAYER               = ^CV_DNN_DNN_PRIORBOXLAYER;
  pCV_HAL_SEPFILTER2D                     = ^CV_HAL_SEPFILTER2D;
  pCV_DNN_DNN_LSTMLAYER                   = ^CV_DNN_DNN_LSTMLAYER;
  pCV_DETAIL_STEREOGRAPHICPROJECTOR       = ^CV_DETAIL_STEREOGRAPHICPROJECTOR;
  pCV_DNN_DNN_TEXTDETECTIONMODEL_EAST     = ^CV_DNN_DNN_TEXTDETECTIONMODEL_EAST;
  pCV_DNN_DNN_CONVOLUTIONLAYERINT8        = ^CV_DNN_DNN_CONVOLUTIONLAYERINT8;
  pCV_TRACKERGOTURN_PARAMS                = ^CV_TRACKERGOTURN_PARAMS;
  pCV_DNN_DNN_DICT                        = ^CV_DNN_DNN_DICT;
  pCV_OCL_KERNELARG                       = ^CV_OCL_KERNELARG;
  pCV_DNN_DNN_SHIFTLAYER                  = ^CV_DNN_DNN_SHIFTLAYER;
  pCV_DETAIL_CYLINDRICALWARPERGPU         = ^CV_DETAIL_CYLINDRICALWARPERGPU;
  pCV_DNN_DNN_ACCUMLAYER                  = ^CV_DNN_DNN_ACCUMLAYER;
  pCV_GOPAQUEDESC                         = ^CV_GOPAQUEDESC;
  pCV_DNN_DNN_HARDSWISHLAYER              = ^CV_DNN_DNN_HARDSWISHLAYER;
  pCV_GCOMPUTATION                        = ^CV_GCOMPUTATION;
  pCV_ARUCO_DETECTORPARAMETERS            = ^CV_ARUCO_DETECTORPARAMETERS;
  pCV_DETAIL_CYLINDRICALPROJECTOR         = ^CV_DETAIL_CYLINDRICALPROJECTOR;
  pCV_DETECTIONBASEDTRACKER_PARAMETERS    = ^CV_DETECTIONBASEDTRACKER_PARAMETERS;
  pID3D10DEVICE                           = ^ID3D10DEVICE;
  pCV_DNN_DNN_ASINLAYER                   = ^CV_DNN_DNN_ASINLAYER;
  pCV_DETAIL_CHANNELSCOMPENSATOR          = ^CV_DETAIL_CHANNELSCOMPENSATOR;
  pCV_GFRAME                              = ^CV_GFRAME;
  pCV_DNN_DNN_SEGMENTATIONMODEL           = ^CV_DNN_DNN_SEGMENTATIONMODEL;
  pCV_DNN_DNN_SCALELAYERINT8              = ^CV_DNN_DNN_SCALELAYERINT8;
  pCV_DNN_DNN_NORMALIZEBBOXLAYER          = ^CV_DNN_DNN_NORMALIZEBBOXLAYER;
  pCV_DNN_DNN_REGIONLAYER                 = ^CV_DNN_DNN_REGIONLAYER;
  pCV_DETAIL_AFFINEBESTOF2NEARESTMATCHER  = ^CV_DETAIL_AFFINEBESTOF2NEARESTMATCHER;
  pCV_SPARSEMAT_NODE                      = ^CV_SPARSEMAT_NODE;
  pCV_IMAGECOLLECTION                     = ^CV_IMAGECOLLECTION;
  pCV_CUDA_HOSTMEM                        = ^CV_CUDA_HOSTMEM;
  pCV_DNN_DNN_SWISHLAYER                  = ^CV_DNN_DNN_SWISHLAYER;
  pCV_DETAIL_GARRAYU                      = ^CV_DETAIL_GARRAYU;
  pUNSIGNED_SHORT                         = ^UNSIGNED_SHORT;
  pCV_DNN_DNN_RNNLAYER                    = ^CV_DNN_DNN_RNNLAYER;
  pSIGNED_CVCHAR                          = ^SIGNED_CVCHAR;
  pCV_GAPI_PYTHON_GPYTHONFUNCTOR          = ^CV_GAPI_PYTHON_GPYTHONFUNCTOR;
  pCV_DETAIL_TRACKING_CLFMILBOOST_PARAMS  = ^CV_DETAIL_TRACKING_CLFMILBOOST_PARAMS;
  pCV_ASYNCPROMISE                        = ^CV_ASYNCPROMISE;
  pCV_POINT3__OF_FLOAT                    = ^CV_POINT3__OF_FLOAT;
  pCV_DNN_DNN_ASINHLAYER                  = ^CV_DNN_DNN_ASINHLAYER;
  pCV_DNN_DNN_ACTIVATIONLAYER             = ^CV_DNN_DNN_ACTIVATIONLAYER;
  pCV_INTERNAL_INTRINSICPARAMS            = ^CV_INTERNAL_INTRINSICPARAMS;
  pCV_GRUNARG                             = ^CV_GRUNARG;
  pID3D11DEVICE                           = ^ID3D11DEVICE;
  pCV_DETAIL_GCOMPOUNDKERNEL              = ^CV_DETAIL_GCOMPOUNDKERNEL;
  pCV_DNN_DNN_SELULAYER                   = ^CV_DNN_DNN_SELULAYER;
  pCV_CUDA_GPUMAT_ALLOCATOR               = ^CV_CUDA_GPUMAT_ALLOCATOR;
  pCV_SPHERICALWARPER                     = ^CV_SPHERICALWARPER;
  pCV_SIMILARRECTS                        = ^CV_SIMILARRECTS;
  pCV_GAPI_OWN_SCALAR                     = ^CV_GAPI_OWN_SCALAR;
  pCV_GAPI_WIP_ONEVPL_DEVICE              = ^CV_GAPI_WIP_ONEVPL_DEVICE;
  pCV_GAPI_WIP_ONEVPL_CONTEXT             = ^CV_GAPI_WIP_ONEVPL_CONTEXT;
  pCV_DNN_DNN_ELTWISELAYERINT8            = ^CV_DNN_DNN_ELTWISELAYERINT8;
  pCV_DNN_DNN_CEILLAYER                   = ^CV_DNN_DNN_CEILLAYER;
  pCV_UTILS_NESTED_ORIGINALCLASSNAME      = ^CV_UTILS_NESTED_ORIGINALCLASSNAME;
  pCV_ML_STATMODEL                        = ^CV_ML_STATMODEL;
  pCV_MINPROBLEMSOLVER_FUNCTION           = ^CV_MINPROBLEMSOLVER_FUNCTION;
  pCV_DETAIL_BUNDLEADJUSTERAFFINEPARTIAL  = ^CV_DETAIL_BUNDLEADJUSTERAFFINEPARTIAL;
  pCV_NODE_OF_CV_INSTR_NODEDATA           = ^CV_NODE_OF_CV_INSTR_NODEDATA;
  pCV_DESCRIPTORMATCHER                   = ^CV_DESCRIPTORMATCHER;
  pCV_DNN_DNN_SHRINKLAYER                 = ^CV_DNN_DNN_SHRINKLAYER;
  pCV_MATX_MULOP                          = ^CV_MATX_MULOP;
  pCV_GCOMPUTATION_PRIV                   = ^CV_GCOMPUTATION_PRIV;
  pCV_STEREOMATCHER                       = ^CV_STEREOMATCHER;
  pCV_DNN_DNN_BLANKLAYER                  = ^CV_DNN_DNN_BLANKLAYER;
  pCV_ML_ANN_MLP                          = ^CV_ML_ANN_MLP;
  pCV_MATCONSTITERATOR                    = ^CV_MATCONSTITERATOR;
  pCV_HIGHGUI_BACKEND_UIWINDOWBASE        = ^CV_HIGHGUI_BACKEND_UIWINDOWBASE;
  pCV_UTILS_TRACE_DETAILS_TRACEMANAGER    = ^CV_UTILS_TRACE_DETAILS_TRACEMANAGER;
  pUNSIGNED___INT64                       = ^UNSIGNED___INT64;
  pCV_RMAT_VIEW                           = ^CV_RMAT_VIEW;
  pCV_BASECASCADECLASSIFIER_MASKGENERATOR = ^CV_BASECASCADECLASSIFIER_MASKGENERATOR;
  pCV_FORMATTED                           = ^CV_FORMATTED;
  pCV_ML_BOOST                            = ^CV_ML_BOOST;
  pCV_DETAIL_SPHERICALPORTRAITPROJECTOR   = ^CV_DETAIL_SPHERICALPORTRAITPROJECTOR;
  pCV_STEREOBM                            = ^CV_STEREOBM;
  pSTD_RECURSIVE_MUTEX                    = ^STD_RECURSIVE_MUTEX;
  pSTD_VECTOR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERSAMPLERALGORITHM = ^STD_VECTOR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERSAMPLERALGORITHM;
  pCV_DNN_DNN_POOLINGLAYER    = ^CV_DNN_DNN_POOLINGLAYER;
  pCV_SCALAR__OF_DOUBLE       = ^CV_SCALAR__OF_DOUBLE;
  pCV_DETAIL_GRAPHEDGE        = ^CV_DETAIL_GRAPHEDGE;
  pCV_DNN_DNN_COSLAYER        = ^CV_DNN_DNN_COSLAYER;
  pCV_GTRANSFORM              = ^CV_GTRANSFORM;
  pCV_DETAIL_MULTIBANDBLENDER = ^CV_DETAIL_MULTIBANDBLENDER;
  pCV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PANINIPROJECTOR = ^CV_DETAIL_ROTATIONWARPERBASE_OF_CV_DETAIL_PANINIPROJECTOR;
  pCV_LMSOLVER_CALLBACK                                   = ^CV_LMSOLVER_CALLBACK;
  pCV_DETAIL_AFFINEWARPER                                 = ^CV_DETAIL_AFFINEWARPER;
  pCV_DNN_DNN_SIGMOIDLAYER                                = ^CV_DNN_DNN_SIGMOIDLAYER;
  pCV_FARNEBACKOPTICALFLOW                                = ^CV_FARNEBACKOPTICALFLOW;
  pCV_PANINIPORTRAITWARPER                                = ^CV_PANINIPORTRAITWARPER;
  pCV_TICKMETER                                           = ^CV_TICKMETER;
  pCV_DETAIL_NOBUNDLEADJUSTER                             = ^CV_DETAIL_NOBUNDLEADJUSTER;
  pCV_DNN_DNN_DICTVALUE                                   = ^CV_DNN_DNN_DICTVALUE;
  pCV_DETAIL_TRACKING_TRACKERSAMPLER                      = ^CV_DETAIL_TRACKING_TRACKERSAMPLER;
  pCV_OCL_PROGRAMSOURCE_IMPL                              = ^CV_OCL_PROGRAMSOURCE_IMPL;
  pCV_DETAIL_TRACKING_TRACKERFEATURE                      = ^CV_DETAIL_TRACKING_TRACKERFEATURE;
  pCV_FEATURE2D                                           = ^CV_FEATURE2D;
  pCV_CUDA_TARGETARCHS                                    = ^CV_CUDA_TARGETARCHS;
  pCV_DETAIL_EXPOSURECOMPENSATOR                          = ^CV_DETAIL_EXPOSURECOMPENSATOR;
  pCV_DETAIL_PANINIPORTRAITPROJECTOR                      = ^CV_DETAIL_PANINIPORTRAITPROJECTOR;
  pCV_DNN_DNN_ELULAYER                                    = ^CV_DNN_DNN_ELULAYER;
  pCV_GAPI_WIP_ONEVPL_DATAPROVIDERUNSUPPORTEDEXCEPTION    = ^CV_GAPI_WIP_ONEVPL_DATAPROVIDERUNSUPPORTEDEXCEPTION;
  pCV_DNN_DNN_CHANNELSPRELULAYER                          = ^CV_DNN_DNN_CHANNELSPRELULAYER;
  pCV_DNN_DNN_DETECTIONMODEL                              = ^CV_DNN_DNN_DETECTIONMODEL;
  pSTD_BASIC_STRING_OF_CVCHAR                             = ^STD_BASIC_STRING_OF_CVCHAR;
  pCV_HAMMING                                             = ^CV_HAMMING;
  pCV_TERMCRITERIA                                        = ^CV_TERMCRITERIA;
  pCV_PARALLEL_PARALLELFORAPI                             = ^CV_PARALLEL_PARALLELFORAPI;
  pCV_STITCHER                                            = ^CV_STITCHER;
  pCV_DNN_DNN_DECONVOLUTIONLAYER                          = ^CV_DNN_DNN_DECONVOLUTIONLAYER;
  pCV_GAPI_S11N_IOSTREAM                                  = ^CV_GAPI_S11N_IOSTREAM;
  pCV_DISOPTICALFLOW                                      = ^CV_DISOPTICALFLOW;
  pCV_PTR_OF_CV_DNN_DNN_LAYER_CV_DNN_DNN_LAYERPARAMS      = ^CV_PTR_OF_CV_DNN_DNN_LAYER_CV_DNN_DNN_LAYERPARAMS;
  pCV_DNN_DNN_COSHLAYER                                   = ^CV_DNN_DNN_COSHLAYER;
  pCV_RANGE                                               = ^CV_RANGE;
  pCV_AKAZE                                               = ^CV_AKAZE;
  pCV_ML_KDTREE                                           = ^CV_ML_KDTREE;
  pCV_CUDA_GPUMATND                                       = ^CV_CUDA_GPUMATND;
  pCV_GAPI_STREAMING_QUEUE_CAPACITY                       = ^CV_GAPI_STREAMING_QUEUE_CAPACITY;
  pCV_OCL_CONTEXT_IMPL                                    = ^CV_OCL_CONTEXT_IMPL;
  pCV_DNN_DNN_ACOSHLAYER                                  = ^CV_DNN_DNN_ACOSHLAYER;
  p__INT64                                                = ^__INT64;
  pCV_RNG_MT19937                                         = ^CV_RNG_MT19937;
  pCV_DNN_DNN_NOTLAYER                                    = ^CV_DNN_DNN_NOTLAYER;
  pCV_DNN_DNN_THRESHOLDEDRELULAYER                        = ^CV_DNN_DNN_THRESHOLDEDRELULAYER;
  pCV_MATOP                                               = ^CV_MATOP;
  pCV_HAL_FILTER2D                                        = ^CV_HAL_FILTER2D;
  pCV_DETAIL_TIMELAPSERCROP                               = ^CV_DETAIL_TIMELAPSERCROP;
  pCV_DNN_DNN_DEQUANTIZELAYER                             = ^CV_DNN_DNN_DEQUANTIZELAYER;
  pCV_GAPI_WIP_ONEVPL_CFGPARAM                            = ^CV_GAPI_WIP_ONEVPL_CFGPARAM;
  pCV_GAPI_WIP_ONEVPL_DATAPROVIDERIMPLEMENTATIONEXCEPTION = ^CV_GAPI_WIP_ONEVPL_DATAPROVIDERIMPLEMENTATIONEXCEPTION;
  pCV_GAPI_GNETPARAM                                      = ^CV_GAPI_GNETPARAM;
  pCV_DETAIL_ROTATIONWARPER                               = ^CV_DETAIL_ROTATIONWARPER;
  pCV_OCL_QUEUE_IMPL                                      = ^CV_OCL_QUEUE_IMPL;
  pCV_OCL_PLATFORM_IMPL                                   = ^CV_OCL_PLATFORM_IMPL;
  pCV_TRACKERDASIAMRPN_PARAMS                             = ^CV_TRACKERDASIAMRPN_PARAMS;
  pCV_DETAIL_BESTOF2NEARESTRANGEMATCHER                   = ^CV_DETAIL_BESTOF2NEARESTRANGEMATCHER;
  pCV_TONEMAP                                             = ^CV_TONEMAP;
  pCV_GAPI_FLUID_VIEW_PRIV                                = ^CV_GAPI_FLUID_VIEW_PRIV;
  pCV_ALIGNEXPOSURES                                      = ^CV_ALIGNEXPOSURES;
  pCV_ML_KNEAREST                                         = ^CV_ML_KNEAREST;
  pCV_INSTR_NODEDATA                                      = ^CV_INSTR_NODEDATA;
  pCV_DETAIL_GOPAQUEU                                     = ^CV_DETAIL_GOPAQUEU;
  pCV_GCALL                                               = ^CV_GCALL;
  pSTD_VECTOR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERFEATURE = ^STD_VECTOR_OF_CV_PTR_OF_CV_DETAIL_TRACKING_TRACKERFEATURE;
  pCV_MOMENTS                                = ^CV_MOMENTS;
  pCV_DETAIL_FISHEYEPROJECTOR                = ^CV_DETAIL_FISHEYEPROJECTOR;
  pCV_BFMATCHER                              = ^CV_BFMATCHER;
  pCV_PYROTATIONWARPER                       = ^CV_PYROTATIONWARPER;
  pCV_QRCODEENCODER                          = ^CV_QRCODEENCODER;
  pCV_MATSTEP                                = ^CV_MATSTEP;
  pCV_HAL_MORPH                              = ^CV_HAL_MORPH;
  pSTD_VECTOR_OF_UNSIGNED___INT64            = ^STD_VECTOR_OF_UNSIGNED___INT64;
  pCV_DNN_DNN_PROPOSALLAYER                  = ^CV_DNN_DNN_PROPOSALLAYER;
  pCV_OCL_INTERNAL_PROGRAMENTRY              = ^CV_OCL_INTERNAL_PROGRAMENTRY;
  pCV_DESCRIPTORMATCHER_DESCRIPTORCOLLECTION = ^CV_DESCRIPTORMATCHER_DESCRIPTORCOLLECTION;
  pCV_DETAIL_PLANEPROJECTOR                  = ^CV_DETAIL_PLANEPROJECTOR;
  pCV_GORIGIN                                = ^CV_GORIGIN;

  // ------------------ manualy ------------------

  CV_ErrorCallback          = TErrorCallback;
  cv_TrackbarCallback       = {$IF Declared(TTrackbarCallback)}TTrackbarCallback{$ELSE} type TEmptyRec{$IFEND};
  CV_OpenGlDrawCallback     = {$IF Declared(TOpenGlDrawCallback)}TOpenGlDrawCallback{$ELSE} type TEmptyRec{$IFEND};
  CV_pt2Func                = {$IF Declared(Tpt2Func)}Tpt2Func{$ELSE} type TEmptyRec{$IFEND};
  CV_ButtonCallback         = {$IF Declared(TButtonCallback)}TButtonCallback{$ELSE} type TEmptyRec{$IFEND};
  CV_CVSIZE                 = {$IF Declared(TCvSize)}TCvSize{$ELSE} type TEmptyRec{$IFEND};
  pCV_CVSIZE                = ^CV_CVSIZE;
  CV_CVRECT                 = {$IF Declared(TCvRect)}TCvRect{$ELSE} type TEmptyRec{$IFEND};
  pCV_CvRect                = ^CV_CVRECT;
  CV_CVMAT                  = {$IF Declared(TCvMat)}TCvMat{$ELSE} type TEmptyRec{$IFEND};
  pCV_CVMAT                 = {$IF Declared(pCvMat)}pCvMat{$ELSE} type pointer{$IFEND};
  pCV_CvArr                 = {$IF Declared(pCvArr)}pCvArr{$ELSE} type pointer{$IFEND};
  CV_CvScalar               = {$IF Declared(TCvScalar)}TCvScalar{$ELSE} type TEmptyRec{$IFEND};
  pCV_CvScalar              = {$IF Declared(pCvScalar)}pCvScalar{$ELSE} type pointer{$IFEND};
  pCV_CVMATND               = {$IF Declared(pCVMatND)}pCVMatND{$ELSE} type pointer{$IFEND};
  pCV_CvSparseMatIterator   = {$IF Declared(pCvSparseMatIterator)}pCvSparseMatIterator{$ELSE} type pointer{$IFEND};
  pCV_CvSparseNode          = {$IF Declared(pCvSparseNode)}pCvSparseNode{$ELSE} type pointer{$IFEND};
  pCV_CvNArrayIterator      = {$IF Declared(pCvNArrayIterator)}pCvNArrayIterator{$ELSE} type pointer{$IFEND};
  CV_CvTermCriteria         = {$IF Declared(TCvTermCriteria)}TCvTermCriteria{$ELSE} type TEmptyRec{$IFEND};
  pCV_CvRNG                 = {$IF Declared(pCvRNG)}pCvRNG{$ELSE} type pointer{$IFEND};
  CV_CvPoint                = {$IF Declared(TCvPoint)}TCvPoint{$ELSE} type TEmptyRec{$IFEND};
  pCV_CvPoint               = {$IF Declared(pCvPoint)}pCvPoint{$ELSE} type pointer{$IFEND};
  CV_CvSlice                = {$IF Declared(TCvSlice)}TCvSlice{$ELSE} type TEmptyRec{$IFEND};
  pCV_CvMemStoragePos       = {$IF Declared(pCvMemStoragePos)}pCvMemStoragePos{$ELSE} type pointer{$IFEND};
  pCV_CvSeqBlock            = {$IF Declared(pCvSeqBlock)}pCvSeqBlock{$ELSE} type pointer{$IFEND};
  pCV_CvSeqWriter           = {$IF Declared(pCvSeqWriter)}pCvSeqWriter{$ELSE} type pointer{$IFEND};
  pCV_CvSeqReader           = {$IF Declared(pCvSeqReader)}pCvSeqReader{$ELSE} type pointer{$IFEND};
  TCV_CvCmpFunc             = {$IF Declared(TCvCmpFunc)}TCvCmpFunc{$ELSE} type pointer{$IFEND};
  pCV_CvSet                 = {$IF Declared(pCvSet)}pCvSet{$ELSE} type pointer{$IFEND};
  pCV_CvSetElem             = {$IF Declared(pCvSetElem)}pCvSetElem{$ELSE} type pointer{$IFEND};
  pCV_CvGraph               = {$IF Declared(pCvGraph)}pCvGraph{$ELSE} type pointer{$IFEND};
  pCV_CvGraphVtx            = {$IF Declared(pCvGraphVtx)}pCvGraphVtx{$ELSE} type pointer{$IFEND};
  pCV_CvGraphEdge           = {$IF Declared(pCvGraphEdge)}pCvGraphEdge{$ELSE} type pointer{$IFEND};
  pCV_CvGraphScanner        = {$IF Declared(pCvGraphScanner)}pCvGraphScanner{$ELSE} type pointer{$IFEND};
  pCV_CvTreeNodeIterator    = {$IF Declared(pCvTreeNodeIterator)}pCvTreeNodeIterator{$ELSE} type pointer{$IFEND};
  Cv_CViplCreateImageHeader = {$IF Declared(TCv_iplCreateImageHeader)}TCv_iplCreateImageHeader{$ELSE} type pointer{$IFEND};
  Cv_CViplAllocateImageData = {$IF Declared(TCv_iplAllocateImageData)}TCv_iplAllocateImageData{$ELSE} type pointer{$IFEND};
  Cv_CViplDeallocate        = {$IF Declared(TCv_iplDeallocate)} TCv_iplDeallocate{$ELSE} type pointer{$IFEND};
  Cv_CViplCreateROI         = {$IF Declared (TCv_iplCreateROI)} TCv_iplCreateROI{$ELSE} type pointer{$IFEND};
  Cv_CViplCloneImage        = {$IF Declared(TCv_iplCloneImage)} TCv_iplCloneImage{$ELSE} type pointer{$IFEND};
  CV_CvErrorCallback        = {$IF Declared(TCvErrorCallback)} TCvErrorCallback{$ELSE} type pointer{$IFEND};
  CV_CvPoint2D32f           = {$IF Declared(TCvPoint2D32f)}TCvPoint2D32f{$ELSE} type TEmptyRec{$IFEND};
  pCV_CvPoint2D32f          = {$IF Declared(pCvPoint2D32f)}pCvPoint2D32f{$ELSE} type pointer{$IFEND};
  pCV_IplConvKernel         = {$IF Declared(pIplConvKernel)}pIplConvKernel{$ELSE} type pointer{$IFEND};
  pCV_CvMoments             = {$IF Declared(pCvMoments)}pCvMoments{$ELSE} type pointer{$IFEND};
  pCV_CvHuMoments           = {$IF Declared(pCvHuMoments)}pCvHuMoments{$ELSE} type pointer{$IFEND};
  CV_CvDistanceFunction     = {$IF Declared(TCvDistanceFunction)}TCvDistanceFunction{$ELSE} type pointer{$IFEND};
  CV_CvContourScanner       = {$IF Declared(TCvContourScanner)}TCvContourScanner{$ELSE} type TEmptyRec{$IFEND};
  pCV_CvContourScanner      = {$IF Declared(pCvContourScanner)}pCvContourScanner{$ELSE} type pointer{$IFEND};
  pCV_CvChain               = {$IF Declared(pCvChain)}pCvChain{$ELSE} type pointer{$IFEND};
  pCV_CvChainPtReader       = {$IF Declared(pCvChainPtReader)}pCvChainPtReader{$ELSE} type pointer{$IFEND};
  CV_CvBox2D                = {$IF Declared(TCvBox2D)}TCvBox2D{$ELSE} type TEmptyRec{$IFEND};
  CV_pt4                    = {$IF Declared(pt4)}pt4{$ELSE} type TEmptyRec{$IFEND};
  pCV_CvContour             = {$IF Declared(pCvContour)}pCvContour{$ELSE} type pointer{$IFEND};
  pCV_CvHistogram           = {$IF Declared(pCvHistogram)}pCvHistogram{$ELSE} type pointer{$IFEND};
  pCV_CvConnectedComp       = {$IF Declared(pCvConnectedComp)}pCvConnectedComp{$ELSE} type pointer{$IFEND};
  pCV_CvLineIterator        = {$IF Declared(pCvLineIterator)}pCvLineIterator{$ELSE} type pointer{$IFEND};
  CV_CvFont                 = {$IF Declared(TCvFont)}TCvFont{$ELSE} type TEmptyRec{$IFEND};
  pCV_CvFont                = {$IF Declared(pCvFont)}pCvFont{$ELSE} type pointer{$IFEND};
  CV_CvTrackbarCallback     = {$IF Declared(TCvTrackbarCallback)}TCvTrackbarCallback{$ELSE} type pointer{$IFEND};
  CV_CvTrackbarCallback2    = {$IF Declared(TCvTrackbarCallback2)}TCvTrackbarCallback2{$ELSE} type pointer{$IFEND};
  CV_CvMouseCallback        = {$IF Declared(TCvMouseCallback)}TMouseCallback{$ELSE} type pointer{$IFEND};
  CV_CvOpenGlDrawCallback   = {$IF Declared(TCvOpenGlDrawCallback)}TCvOpenGlDrawCallback{$ELSE} type pointer{$IFEND};
  pCV_SIZE__OF_INT          = ^CV_SIZE__OF_INT;

{$IFEND OPENCV_EXTERNAL_TYPES}
