(*
  This file is part of Delphi-OpenCV-Class project.
  https://github.com/Laex/Delphi-OpenCV-Class

  It is subject to the license terms in the LICENSE file found in the top-level directory
  of this distribution and at https://www.apache.org/licenses/LICENSE-2.0.txt

  Copyright 2021, Laentir Valetov, laex@bk.ru

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*)
program imgproc_segmentation;

{$APPTYPE CONSOLE}
{$POINTERMATH ON}
{$R *.res}

uses
  System.SysUtils,
  cpp.utils,
  cv.resource,
  cv.opencv;

Var
  image: TMat;

begin
  try
    // Var
    image { :TMat } := TMat.Mat(Size(1920, 1080), CV_8UC3, TScalar.all(128));

    // ! [usage_example_intelligent_scissors]
    Var
      tool: TIntelligentScissorsMB;
    tool.setEdgeFeatureCannyParameters(16, 100) // using Canny() as edge feature extractor
      .setGradientMagnitudeMaxLimit(200);

    // calculate image features
    tool.applyImage(image);

    // calculate map for specified source point
    Var
      source_point: TPoint := Point(200, 100);
    tool.buildMap(source_point);

    // fast fetching of contours
    // for specified target point and the pre-calculated map (stored internally)
    Var
      target_point: TPoint := Point(400, 300);
    Var
      pts: vector<TPoint>;
    tool.getContour(target_point, pts);
    // ! [usage_example_intelligent_scissors]

    WriteLn(pts.size);

  except
    on E: Exception do
    begin
      WriteLn(E.ClassName, ': ', E.Message);
      Readln;
    end;
  end;

end.
