# GitHub Certifications Guide 🚀

GitHub certifications are here! 🎉 See the official blog post here: https://github.blog/2024-01-08-github-certifications-are-generally-available/ 

Demonstrate your proficiency at GitHub by becoming certified. This guide will help you prepare for the exams and provide you with resources to help you succeed.
![GitHub Certifications](./images/gh-certs.png)

In this repo you will find study guides, and resources to help you prepare for the exams. There are currently 4 certifications available: 

| Certification                | Description                                           | Study Guide                  |
| ---------------------------- | ----------------------------------------------------- | --------------------- |
| [GitHub Foundations](https://learn.microsoft.com/en-us/collections/o1njfe825p602p?WT.mc_id=%3Fwt.mc_id%3Dstudentamb_260352)            | Fundamentals concepts and products of GitHub     | [GitHub Foundations Guide](./study-guides//gh-foundations.md) |
| [GitHub Actions](https://learn.microsoft.com/collections/n5p4a5z7keznp5?WT.mc_id=%3Fwt.mc_id%3Dstudentamb_260352)                | Learn to automate your software development workflows     | [GitHub Actions Guide](./study-guides/gh-actions.md)    |
| [GitHub Advanced Security](https://learn.microsoft.com/collections/rqymc6yw8q5rey?WT.mc_id=%3Fwt.mc_id%3Dstudentamb_260352)    | Learn how to secure your code at every stage of your development lifecycle. | [GHAS Guide](./study-guides//gh-advanced-security.md) |
| [GitHub Administration](https://learn.microsoft.com/collections/mom7u1gzjdxw03?WT.mc_id=%3Fwt.mc_id%3Dstudentamb_260352)        | Learn to maintain a healthy, robust, and secure GitHub environment | [GitHub Admin Guide](./study-guides/gh-administration.md) |

You can find the full **candidate handbook** here: [GitHub Certification Handbook](https://examregistration.github.com/handbook).

If you have questions, be sure to check out the FAQ page here: [GitHub Certification FAQ](https://examregistration.github.com/faq)


![GitHub Certifications](image.png)

## Contributing

If you have any resources that you would like to add to this repo, please feel free to open a PR and add them! Do take a look at our contribution guidelines [here](./CONTRIBUTING.md) before you do.

## Resources

- [Linkedin Learning - GitHub Foundations Prep Course](https://www.linkedin.com/learning/paths/prepare-for-the-github-foundations-certification?u=3322) ✨
- [Linkedin Learning - GitHub Admin Prep Course](https://www.linkedin.com/learning/paths/prepare-for-the-github-administration-certification?u=3322) ✨

## License

This project is licensed under the [MIT License](https://github.com/FidelusAleksander/githubcertified/blob/master/LICENSE).
