# Web GUI For Stockfish Chess

![GUI Type](https://img.shields.io/badge/Type-Web_GUI-orange)
![JavaScript](https://img.shields.io/badge/Language-JavaScript-yellow)
![jQuery](https://img.shields.io/badge/jquery-3.7.1-blue)
![Stockfish 16 Chess Engine](https://img.shields.io/badge/Stockfish_Chess_Engine-16-43AC6A)
![Chessboard.JS](https://img.shields.io/badge/Chessboard.JS-1.0.0-brown)

## Overview

It is a web graphical user interface (GUI) for the Stockfish Chess engine. It is a fully functional web-based chess app that allows you to play against the Stockfish chess engine.

This repository contains two different implementations. Explore both and contribute to the one you find most interesting. Ultimately, only one implementation will remain once we reach a stable, bug-free version with sufficient features to be considered professional.

---

## Mission

Our mission from this project is to develop a modern responsive free and open source web-based chess GUI powered by the Stockfish chess engine.

---

## Live Demo

- https://labinatorsolutions.github.io/stockfish-chess-web-gui/implementation-1/index.html
- https://labinatorsolutions.github.io/stockfish-chess-web-gui/implementation-2/index.html

**Note:** The above implementations still require lots of work. Your contribution is always appreciated.

---

## Installation

### Online Installation

- Download or clone this repository.
- Upload the unzipped folder of this repository to your web server then view it from your web browser.

### Local Installation

- Download or clone this repository.
- Install a web server locally to test effectively the GUI.

---

## Suggestions For Contributors

1. **User Interface**
   - Responsive Design
   - Customizable Chessboard
   - Board Flip
   - Switch Board

2. **Game Play**
   - Take Back Moves
   - Move Hints
   - Evaluation Bar
   - Static Evaluation
   - Legal Move Highlighting

3. **Game Analysis**
   - Real-time Analysis
   - Game Review & Evaluation Report
   - Blunder Detection
   - Evaluation Graph
   - Move List

4. **Game Management**
   - Save and Load Games
   - PGN Viewer
   - FEN Viewer
   - Import/Export PGN and FEN

5. **Board Editor**
   - Setup Position
   - Piece Placement
   - Validate Position

6. **Training Modes**
   - Tactics Trainer
   - Endgame Training
   - Puzzle Rush

7. **Opening Explorer**
   - Opening Database

8. **Stockfish Settings**
   - Skill Level
   - Depth Control
   - Thinking Time

9. **Additional Features**
   - Highlight Best Move
   - Multiple Analysis Engines
   - Engine vs. Engine
   - Visual Customizations
   - Coach Mode
   - Dark/Light Modes
   - Enhanced Accessibility Features

11. **Keyboard Shortcuts**
    - Board Controls
    - Interface Navigation

12. **Scores of All Legal Moves**
    - Move Evaluation Display
    - Real-time Updates

13. **Analysis Lines**
    - Multi-Line Display
    - Interactive Analysis
    - Depth and Score

---

## Development & Contribution

We welcome all developers to contribute to this repository by fixing bugs or adding features.

It is also great to check our advanced chess app at:

- [https://github.com/LabinatorSolutions/boldchess-web-app](https://github.com/LabinatorSolutions/boldchess-web-app)

---

## License

GNU AGPLv3: [https://www.gnu.org/licenses/agpl-3.0.html](https://www.gnu.org/licenses/agpl-3.0.html)

---

## Credits

- Stockfish: [https://github.com/official-stockfish/Stockfish](https://github.com/official-stockfish/Stockfish)
- Stockfish.js: [https://github.com/nmrugg/stockfish.js](https://github.com/nmrugg/stockfish.js)
- BoldChess: [https://boldchess.com](https://boldchess.com/)
- Labinator: [https://labinator.com](https://labinator.com/)
