# Contributing

Thank you for your interest in contributing! We value the contributions of our community members and are excited to have you on board.
Below are the guidelines for contributing to our project. By following these guidelines, you help us maintain the quality of our code and ensure that everyone's contributions can be included.

## Getting Started

Before you begin, make sure you have a GitHub account and are familiar with GitHub repositories. You should also have a basic understanding of JavaScript and experience with the Stockfish chess engine is a plus.

1. Fork the repository on GitHub to your own account.
2. Clone your fork to your local machine.
3. Create a new branch for your changes. Use a clear branch name that describes the feature or fix you're working on.

## Reporting Bugs

If you find a bug in the app:

1. Use the GitHub issue tracker to check if the bug has already been reported.
2. If the bug is unreported, open a new issue. Provide a clear title and description of the problem. Include as much relevant information as possible: steps to reproduce the issue, browser and OS environment, and any error messages.

## Suggesting Enhancements

We welcome suggestions for enhancements! If you have an idea to improve the app:

1. First, check if the enhancement has already been suggested.
2. If it hasn't, open a new issue to suggest your enhancement. Provide a clear title and description of your suggested enhancement.

## Pull Requests

We actively welcome your pull requests:

1. Fork the repo and create your branch from `main`.
2. If you've added code, write clear, commented code and adhere to our coding conventions.
3. If you've changed APIs, update the documentation.
4. Ensure your code lints (no compile errors).
5. Issue your pull request to the `main` branch.
6. Provide a clear description of the changes in the pull request. Include the purpose of the change and any relevant issues it addresses.

## Coding Standards

Please ensure your code adheres to the following standards:

1. Use clear and meaningful variable, method, and class names.
2. Comment your code where necessary, especially for complex logic.
3. Keep your code clean and readable.
4. Follow the existing code format and structure.

## Community and Conduct

We are committed to providing a welcoming and inspiring community for all.
